static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2014 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (pan, _(\"Pan\"), 0.0)                                        \n"
"  description   (_(\"Horizontal camera panning\"))                            \n"
"  value_range   (-360.0, 360.0)                                               \n"
"  ui_meta       (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_double (tilt, _(\"Tilt\"), 0.0)                                      \n"
"  description   (_(\"Vertical camera panning\"))                              \n"
"  value_range   (-180.0, 180.0)                                               \n"
"  ui_range      (-180.0, 180.0)                                               \n"
"  ui_meta       (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_double (spin, _(\"Spin\"), 0.0)                                      \n"
"  description   (_(\"Spin angle around camera axis\"))                        \n"
"  value_range   (-360.0, 360.0)                                               \n"
"                                                                              \n"
"property_double (zoom, _(\"Zoom\"), 100.0)                                    \n"
"  description   ((\"Zoom level\"))                                            \n"
"  value_range   (0.01, 1000.0)                                                \n"
"                                                                              \n"
"property_int    (width, _(\"Width\"), -1)                                     \n"
"  description   (_(\"output/rendering width in pixels, -1 for input width\")) \n"
"  value_range   (-1, 10000)                                                   \n"
"  ui_meta       (\"role\", \"output-extent\")                                 \n"
"  ui_meta       (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_int    (height, _(\"Height\"), -1)                                   \n"
"  description   (_(\"output/rendering height in pixels, -1 for input height\"))\n"
"  value_range   (-1, 10000)                                                   \n"
"  ui_meta       (\"role\", \"output-extent\")                                 \n"
"  ui_meta       (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_boolean(little_planet, _(\"Little planet\"), FALSE)                  \n"
"  description   (_(\"Render a stereographic mapping, a tilt value of 90, which means looking at nadir provides a good default value.\"))\n"
"                                                                              \n"
"property_enum   (sampler_type, _(\"Resampling method\"),                      \n"
"                  GeglSamplerType, gegl_sampler_type, GEGL_SAMPLER_NEAREST)   \n"
"  description   (_(\"Image resampling method to use\"))                       \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE panorama-projection.c                                \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"typedef struct _Transform Transform;                                          \n"
"struct _Transform                                                             \n"
"{                                                                             \n"
"  float pan;                                                                  \n"
"  float tilt;                                                                 \n"
"  float sin_tilt;                                                             \n"
"  float cos_tilt;                                                             \n"
"  float sin_spin;                                                             \n"
"  float cos_spin;                                                             \n"
"  float sin_negspin;                                                          \n"
"  float cos_negspin;                                                          \n"
"  float zoom;                                                                 \n"
"  float spin;                                                                 \n"
"  float xoffset;                                                              \n"
"  float width;                                                                \n"
"  float height;                                                               \n"
"  void (*xy2ll) (Transform *transform, float x, float  y, float *lon, float *lat);\n"
"  void (*ll2xy) (Transform *transform, float lon, float  lat, float *x, float *y);\n"
"  int   do_spin;                                                              \n"
"  int   do_zoom;                                                              \n"
"};                                                                            \n"
"                                                                              \n"
"/* formulas from:                                                             \n"
" * http://mathworld.wolfram.com/GnomonicProjection.html                       \n"
" */                                                                           \n"
"static void inline                                                            \n"
"gnomonic_xy2ll (Transform *transform, float x, float y,                       \n"
"                float *lon, float *lat)                                       \n"
"{                                                                             \n"
"  float p, c;                                                                 \n"
"  float longtitude, latitude;                                                 \n"
"  float sin_c, cos_c;                                                         \n"
"                                                                              \n"
"  if (transform->do_spin)                                                     \n"
"  {                                                                           \n"
"    float tx = x, ty = y;                                                     \n"
"    x = tx * transform->cos_spin - ty * transform->sin_spin;                  \n"
"    y = ty * transform->cos_spin + tx * transform->sin_spin;                  \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (transform->do_zoom)                                                     \n"
"  {                                                                           \n"
"    x /= transform->zoom;                                                     \n"
"    y /= transform->zoom;                                                     \n"
"  }                                                                           \n"
"                                                                              \n"
"  p = sqrtf (x*x+y*y);                                                        \n"
"  c = atan2f (p, 1);                                                          \n"
"                                                                              \n"
"  sin_c = sinf(c);                                                            \n"
"  cos_c = cosf(c);                                                            \n"
"                                                                              \n"
"  latitude = asinf (cos_c * transform->sin_tilt + ( y * sin_c * transform->cos_tilt) / p);\n"
"  longtitude = transform->pan + atan2f (x * sin_c, p * transform->cos_tilt * cos_c - y * transform->sin_tilt * sin_c);\n"
"                                                                              \n"
"  if (longtitude < 0)                                                         \n"
"    longtitude += M_PI * 2;                                                   \n"
"                                                                              \n"
"  *lon = (longtitude / (M_PI * 2));                                           \n"
"  *lat = ((latitude + M_PI/2) / M_PI);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"gnomonic_ll2xy (Transform *transform,                                         \n"
"                float lon, float lat,                                         \n"
"                float *x, float *y)                                           \n"
"{                                                                             \n"
"  float cos_c;                                                                \n"
"  float sin_lon = sinf (lon);                                                 \n"
"  float cos_lon = cosf (lon);                                                 \n"
"  float cos_lat_minus_pan = cosf (lat - transform->pan);                      \n"
"                                                                              \n"
"  cos_c = (transform->sin_tilt * sin_lon +                                    \n"
"           transform->cos_tilt * cos (lon) *                                  \n"
"            cos_lat_minus_pan);                                               \n"
"                                                                              \n"
"  *x = ((cos_lon * sin (lat - transform->pan)) / cos_c);                      \n"
"  *y = ((transform->cos_tilt * sin_lon -                                      \n"
"         transform->sin_tilt * cos_lon * cos_lat_minus_pan) / cos_c);         \n"
"                                                                              \n"
"  if (transform->do_zoom)                                                     \n"
"  {                                                                           \n"
"    *x *= transform->zoom;                                                    \n"
"    *y *= transform->zoom;                                                    \n"
"  }                                                                           \n"
"  if (transform->do_spin)                                                     \n"
"  {                                                                           \n"
"    float tx = *x, ty = *y;                                                   \n"
"    *x = tx * transform->cos_negspin - ty * transform->sin_negspin;           \n"
"    *y = ty * transform->cos_negspin + tx * transform->sin_negspin;           \n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"stereographic_ll2xy (Transform *transform,                                    \n"
"                     float lon, float lat,                                    \n"
"                     float *x,  float *y)                                     \n"
"{                                                                             \n"
"  float k;                                                                    \n"
"  float sin_lon = sinf (lon);                                                 \n"
"  float cos_lon = cosf (lon);                                                 \n"
"  float cos_lat_minus_pan = cosf (lat - transform->pan);                      \n"
"                                                                              \n"
"  k = 2/(1 + transform->sin_tilt * sin_lon +                                  \n"
"            transform->cos_tilt * cos (lon) *                                 \n"
"            cos_lat_minus_pan);                                               \n"
"                                                                              \n"
"  *x = k * ((cos_lon * sin (lat - transform->pan)));                          \n"
"  *y = k * ((transform->cos_tilt * sin_lon -                                  \n"
"        transform->sin_tilt * cos_lon * cos_lat_minus_pan));                  \n"
"                                                                              \n"
"  if (transform->do_zoom)                                                     \n"
"  {                                                                           \n"
"    *x *= transform->zoom;                                                    \n"
"    *y *= transform->zoom;                                                    \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (transform->do_spin)                                                     \n"
"  {                                                                           \n"
"    float tx = *x, ty = *y;                                                   \n"
"    *x = tx * transform->cos_negspin - ty * transform->sin_negspin;           \n"
"    *y = ty * transform->cos_negspin + tx * transform->sin_negspin;           \n"
"  }                                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"stereographic_xy2ll (Transform *transform,                                    \n"
"                     float x, float y,                                        \n"
"                     float *lon, float *lat)                                  \n"
"{                                                                             \n"
"  float p, c;                                                                 \n"
"  float longtitude, latitude;                                                 \n"
"  float sin_c, cos_c;                                                         \n"
"                                                                              \n"
"  if (transform->do_spin)                                                     \n"
"  {                                                                           \n"
"    float tx = x, ty = y;                                                     \n"
"    x = tx * transform->cos_spin - ty * transform->sin_spin;                  \n"
"    y = ty * transform->cos_spin + tx * transform->sin_spin;                  \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (transform->do_zoom)                                                     \n"
"  {                                                                           \n"
"    x /= transform->zoom;                                                     \n"
"    y /= transform->zoom;                                                     \n"
"  }                                                                           \n"
"                                                                              \n"
"  p = sqrtf (x*x+y*y);                                                        \n"
"  c = 2 * atan2f (p / 2, 1);                                                  \n"
"                                                                              \n"
"  sin_c = sinf (c);                                                           \n"
"  cos_c = cosf (c);                                                           \n"
"                                                                              \n"
"  latitude = asinf (cos_c * transform->sin_tilt + ( y * sin_c * transform->cos_tilt) / p);\n"
"  longtitude = transform->pan + atan2f ( x * sin_c, p * transform->cos_tilt * cos_c - y * transform->sin_tilt * sin_c);\n"
"                                                                              \n"
"  if (longtitude < 0)                                                         \n"
"    longtitude += M_PI * 2;                                                   \n"
"                                                                              \n"
"  *lon = (longtitude / (M_PI * 2));                                           \n"
"  *lat = ((latitude + M_PI/2) / M_PI);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare_transform (Transform *transform,                          \n"
"                               float pan, float spin, float zoom, float tilt, \n"
"                               int little_planet,                             \n"
"                               float width, float height,                     \n"
"                               float input_width, float input_height)         \n"
"{                                                                             \n"
"  float xoffset = 0.5;                                                        \n"
"  transform->xy2ll = gnomonic_xy2ll;                                          \n"
"  transform->ll2xy = gnomonic_ll2xy;                                          \n"
"                                                                              \n"
"  pan  = pan / 360 * M_PI * 2;                                                \n"
"  spin = spin / 360 * M_PI * 2;                                               \n"
"  zoom = little_planet?zoom / 1000.0:zoom / 100.0;                            \n"
"  tilt = tilt / 360 * M_PI * 2;                                               \n"
"                                                                              \n"
"  while (pan > M_PI)                                                          \n"
"    pan -= 2 * M_PI;                                                          \n"
"                                                                              \n"
"  if (width <= 0 || height <= 0)                                              \n"
"  {                                                                           \n"
"    width = input_height;                                                     \n"
"    height = width;                                                           \n"
"    xoffset = ((input_width - height)/height) / 2 + 0.5;                      \n"
"  }                                                                           \n"
"  else                                                                        \n"
"  {                                                                           \n"
"    float orig_width = width;                                                 \n"
"    width = height;                                                           \n"
"    xoffset = ((orig_width - height)/height) / 2 + 0.5;                       \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (little_planet)                                                          \n"
"  {                                                                           \n"
"    transform->xy2ll = stereographic_xy2ll;                                   \n"
"    transform->ll2xy = stereographic_ll2xy;                                   \n"
"  }                                                                           \n"
"                                                                              \n"
"  transform->do_spin = fabs (spin) > 0.000001 ? 1 : 0;                        \n"
"  transform->do_zoom = fabs (zoom-1.0) > 0.000001 ? 1 : 0;                    \n"
"                                                                              \n"
"  transform->pan         = pan;                                               \n"
"  transform->tilt        = tilt;                                              \n"
"  transform->spin        = spin;                                              \n"
"  transform->zoom        = zoom;                                              \n"
"  transform->xoffset     = xoffset;                                           \n"
"  transform->sin_tilt    = sinf (tilt);                                       \n"
"  transform->cos_tilt    = cosf (tilt);                                       \n"
"  transform->sin_spin    = sinf (spin);                                       \n"
"  transform->cos_spin    = cosf (spin);                                       \n"
"  transform->sin_negspin = sinf (-spin);                                      \n"
"  transform->cos_negspin = cosf (-spin);                                      \n"
"  transform->width       = width;                                             \n"
"  transform->height      = height;                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *format = babl_format (\"RaGaBaA float\");                       \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle result = {0,0,0,0};                                           \n"
"                                                                              \n"
"  if (o->width <= 0 || o->height <= 0)                                        \n"
"  {                                                                           \n"
"     GeglRectangle *in_rect;                                                  \n"
"     in_rect = gegl_operation_source_get_bounding_box (operation, \"input\"); \n"
"     if (in_rect)                                                             \n"
"       {                                                                      \n"
"          result = *in_rect;                                                  \n"
"       }                                                                      \n"
"     else                                                                     \n"
"     {                                                                        \n"
"       result.width = 320;                                                    \n"
"       result.height = 200;                                                   \n"
"     }                                                                        \n"
"  }                                                                           \n"
"  else                                                                        \n"
"  {                                                                           \n"
"    result.width = o->width;                                                  \n"
"    result.height = o->height;                                                \n"
"  }                                                                           \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void prepare_transform2 (Transform *transform,                         \n"
"                                GeglOperation *operation,                     \n"
"                                gint level)                                   \n"
"{                                                                             \n"
"  gint factor = 1 << level;                                                   \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle in_rect = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"                                                                              \n"
"  prepare_transform (transform,                                               \n"
"                     o->pan, o->spin, o->zoom, o->tilt,                       \n"
"                     o->little_planet, o->width / factor, o->height / factor, \n"
"                     in_rect.width, in_rect.height);                          \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *region)                         \n"
"{                                                                             \n"
"  GeglRectangle result = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Transform           transform;                                              \n"
"  const Babl         *format_io;                                              \n"
"  GeglSampler        *sampler;                                                \n"
"  gint                factor = 1 << level;                                    \n"
"  GeglBufferIterator *it;                                                     \n"
"  GeglRectangle in_rect = *gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  GeglMatrix2  scale_matrix;                                                  \n"
"  GeglMatrix2 *scale = NULL;                                                  \n"
"  gint sampler_type = o->sampler_type;                                        \n"
"                                                                              \n"
"  prepare_transform2 (&transform, operation, level);                          \n"
"                                                                              \n"
"  if (level)                                                                  \n"
"    sampler_type = GEGL_SAMPLER_NEAREST;                                      \n"
"                                                                              \n"
"  format_io = babl_format (\"RaGaBaA float\");                                \n"
"  {                                                                           \n"
"    /* XXX: panorama projection needs to sample from a higher resolution than \n"
"     * its output to yield good results. This affects which level should      \n"
"     * be rendered for source nodes..                                         \n"
"     */                                                                       \n"
"                                                                              \n"
"    gint sample_level = level - 3;                                            \n"
"                                                                              \n"
"    if (sample_level < 0)                                                     \n"
"      sample_level = 0;                                                       \n"
"    sampler = gegl_buffer_sampler_new_at_level (input, format_io, sampler_type,\n"
"                                       sample_level);                         \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (sampler_type == GEGL_SAMPLER_NOHALO ||                                  \n"
"      sampler_type == GEGL_SAMPLER_LOHALO)                                    \n"
"    scale = &scale_matrix;                                                    \n"
"                                                                              \n"
"    {                                                                         \n"
"      float   ud = ((1.0/transform.width)*factor);                            \n"
"      float   vd = ((1.0/transform.height)*factor);                           \n"
"      it = gegl_buffer_iterator_new (output, result, level, format_io,        \n"
"                                     GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);     \n"
"                                                                              \n"
"      while (gegl_buffer_iterator_next (it))                                  \n"
"        {                                                                     \n"
"          gint i;                                                             \n"
"          gint n_pixels = it->length;                                         \n"
"          gint x = it->roi->x; /* initial x                   */              \n"
"          gint y = it->roi->y; /*           and y coordinates */              \n"
"                                                                              \n"
"          float   u0 = (((x*factor)/transform.width) - transform.xoffset);    \n"
"          float   u, v;                                                       \n"
"                                                                              \n"
"          float *out = it->data[0];                                           \n"
"                                                                              \n"
"          u = u0;                                                             \n"
"          v = ((y*factor/transform.height) - 0.5);                            \n"
"                                                                              \n"
"          if (scale)                                                          \n"
"            {                                                                 \n"
"              for (i=0; i<n_pixels; i++)                                      \n"
"                {                                                             \n"
"                  float cx, cy;                                               \n"
"#define gegl_unmap(xx,yy,ud,vd) { \\                                          \n"
"                  float rx, ry;\\                                             \n"
"                  transform.xy2ll (&transform, xx, yy, &rx, &ry);\\           \n"
"                  ud = rx;vd = ry;}                                           \n"
"                  gegl_sampler_compute_scale (scale_matrix, u, v);            \n"
"                  gegl_unmap(u,v, cx, cy);                                    \n"
"#undef gegl_unmap                                                             \n"
"                                                                              \n"
"                  gegl_sampler_get (sampler,                                  \n"
"                                    cx * in_rect.width, cy * in_rect.height,  \n"
"                                    scale, out, GEGL_ABYSS_LOOP);             \n"
"                  out += 4;                                                   \n"
"                                                                              \n"
"                  /* update x, y and u,v coordinates */                       \n"
"                  x++;                                                        \n"
"                  u+=ud;                                                      \n"
"                  if (x >= (it->roi->x + it->roi->width))                     \n"
"                    {                                                         \n"
"                      x = it->roi->x;                                         \n"
"                      y++;                                                    \n"
"                      u = u0;                                                 \n"
"                      v += vd;                                                \n"
"                    }                                                         \n"
"                }                                                             \n"
"              }                                                               \n"
"            else                                                              \n"
"              {                                                               \n"
"                for (i=0; i<n_pixels; i++)                                    \n"
"                  {                                                           \n"
"                    float cx, cy;                                             \n"
"                                                                              \n"
"                    transform.xy2ll (&transform, u, v, &cx, &cy);             \n"
"                                                                              \n"
"                    gegl_sampler_get (sampler,                                \n"
"                                      cx * in_rect.width, cy * in_rect.height,\n"
"                                      scale, out, GEGL_ABYSS_LOOP);           \n"
"                    out += 4;                                                 \n"
"                                                                              \n"
"                    /* update x, y and u,v coordinates */                     \n"
"                    x++;                                                      \n"
"                    u+=ud;                                                    \n"
"                    if (x >= (it->roi->x + it->roi->width))                   \n"
"                      {                                                       \n"
"                        x = it->roi->x;                                       \n"
"                        u = u0;                                               \n"
"                        y++;                                                  \n"
"                        v += vd;                                              \n"
"                      }                                                       \n"
"                  }                                                           \n"
"              }                                                               \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  g_object_unref (sampler);                                                   \n"
"                                                                              \n"
"#if 0                                                                         \n"
"  {                                                                           \n"
"    float t;                                                                  \n"
"    float lat0  = 0;                                                          \n"
"    float lon0 = 0;                                                           \n"
"    float lat1  = 0.5;                                                        \n"
"    float lon1 = 0.5;                                                         \n"
"    int i = 0;                                                                \n"
"    guchar pixel[4] = {255,0,0,255};                                          \n"
"                                                                              \n"
"    for (t = 0; t < 1.0; t+=0.01, i++)                                        \n"
"    {                                                                         \n"
"      float lat = lat0 * (1.0 - t) + lat1 * t;                                \n"
"      float lon = lon0 * (1.0 - t) + lon1 * t;                                \n"
"      float x, y;                                                             \n"
"      float xx, yy;                                                           \n"
"      GeglRectangle prect = {0,0,1,1};                                        \n"
"                                                                              \n"
"      ll2xy (&transform, lon, lat, &x, &y);                                   \n"
"                                                                              \n"
"      x += xoffset;                                                           \n"
"      y += 0.5;                                                               \n"
"                                                                              \n"
"      x *= width;                                                             \n"
"      y *= height;                                                            \n"
"                                                                              \n"
"      prect.x = floor (x);                                                    \n"
"      prect.y = floor (y);                                                    \n"
"      prect.width = 1;                                                        \n"
"      prect.height = 1;                                                       \n"
"                                                                              \n"
"      gegl_buffer_set (output, &prect, 0, babl_format (\"R'G'B' u8\"), pixel, 8);\n"
"    }                                                                         \n"
"  }                                                                           \n"
"#endif                                                                        \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gchar *composition = \"<?xml version='1.0' encoding='UTF-8'?>\"        \n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:panorama-projection' width='200' height='200'/>\" \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-panorama.png</param>\"                  \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass         *operation_class;                                \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class  = GEGL_OPERATION_FILTER_CLASS (klass);                        \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",                  \"gegl:panorama-projection\",                  \n"
"    \"title\",                 _(\"Panorama Projection\"),                    \n"
"    \"reference-composition\", composition,                                   \n"
"    \"position-dependent\",    \"true\",                                      \n"
"    \"categories\" ,           \"map\",                                       \n"
"    \"description\", _(\"Perform a equlinear/gnomonic or little planet/stereographic projection of a equirectangular input image.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"#endif                                                                        \n"
;
