// GENPO - the GENeral Purpose Organ
// Copyright (C) 2003,2004 - Steve Merrony 

/* This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> or
    write to the Free Software Foundation, 51 Franklin Street, Fifth Floor, 
    Boston, MA 02110-1301, USA
*/

#ifndef CONFIGPARSER_H
#define CONFIGPARSER_H

#include "console.h"

#include <qstring.h>
#include <qxml.h>

const unsigned char DEFAULT_VELOCITY = 64;

class ConfigParser : public QXmlDefaultHandler {

 public:

  bool startDocument();

  bool startElement( const QString&,
		     const QString&,
		     const QString&,
		     const QXmlAttributes& );

  bool characters( const QString& );

  bool endElement( const QString&,
		   const QString&,
		   const QString& );

  bool endDocument();

  bool copyConfig( Console * );

  //Console console;



private:

  Console console;
  
  QString indent;
  QString elName;
  int man_count;
  int stop_count;
  int coupler_count;
  int piston_count;
  int piston_stop_count;
  int toe_piston_count;
  bool thumb_piston;
  bool toe_piston;

};

#endif
