/*
 * Decompiled with CFR 0.152.
 */
package geotrans3.misc;

import geotrans3.coordinates.Accuracy;
import geotrans3.exception.CoordinateConversionException;

public class Source {
    private static final int SOURCE_NAME_LENGTH = 50;
    private static final int NUMBER_SOURCES = 19;
    private static AccuracySource[] Source_Table = new AccuracySource[]{new AccuracySource("Unknown", -1.0, -1.0, -1.0), new AccuracySource("User defined (1 meter)", 1.0, 1.0, 2.0), new AccuracySource("GPS PPS", 20.0, 20.0, 26.0), new AccuracySource("GPS SPS", 20.0, 20.0, 26.0), new AccuracySource("1:25,000 City Map", 50.0, 20.0, 52.0), new AccuracySource("1:50,000 Topographic Line Map (TLM)", 50.0, 20.0, 52.0), new AccuracySource("1:50,000 Combat Chart", 50.0, 20.0, 52.0), new AccuracySource("1:100,000 Topographic Line Map (TLM)", 100.0, 20.0, 100.0), new AccuracySource("1:250,000 Joint Operations Graphic (JOG)", 250.0, 100.0, 258.0), new AccuracySource("1:500,000 Tactical Pilotage Chart (TPC)", 1000.0, 150.0, 993.0), new AccuracySource("1:1,000,000 Operational Navigation Chart (ONC)", 2000.0, 650.0, 2031.0), new AccuracySource("Digital Terrain Elevation Data (DTED) Level 1", 50.0, 30.0, 55.0), new AccuracySource("Digital Terrain Elevation Data (DTED) Level 2", 23.0, 18.0, 27.0), new AccuracySource("Digital Feature Analysis Data (DFAD) Level 1", 130.0, -1.0, -1.0), new AccuracySource("Digital Feature Analysis Data (DFAD) Level 2", 130.0, -1.0, -1.0), new AccuracySource("Controlled Image Base (CIB) [>10m GSD]", 25.0, -1.0, -1.0), new AccuracySource("Vector Smart Map (VMAP) Level 1", 250.0, 100.0, 258.0), new AccuracySource("Vector Smart Map (VMAP) Level 2 (1:100,000)", 100.0, 20.0, 100.0), new AccuracySource("Vector Smart Map (VMAP) Level 2 (1:50,000)", 50.0, 20.0, 52.0)};

    public static int count() {
        return 19;
    }

    public static int index(String string) throws CoordinateConversionException {
        int n;
        int n2 = 0;
        int n3 = string.length();
        if (n3 > 49) {
            throw new CoordinateConversionException("Source: Invalid name\n");
        }
        String string2 = string;
        for (n = 0; n < 19 && !string2.equalsIgnoreCase(Source.Source_Table[n].name); ++n) {
        }
        if (n == 19 || !string2.equalsIgnoreCase(Source.Source_Table[n].name)) {
            throw new CoordinateConversionException("Source: Invalid name\n");
        }
        n2 = n;
        return n2;
    }

    public static String name(int n) throws CoordinateConversionException {
        if (n < 0 || n >= 19) {
            throw new CoordinateConversionException("Source: Index value outside of valid range\n");
        }
        return Source.Source_Table[n].name;
    }

    public static Accuracy accuracy(int n) throws CoordinateConversionException {
        if (n < 0 || n >= 19) {
            throw new CoordinateConversionException("Source: Index value outside of valid range\n");
        }
        return new Accuracy(Source.Source_Table[n].ce, Source.Source_Table[n].le, Source.Source_Table[n].se);
    }

    private static class AccuracySource {
        String name;
        double ce;
        double le;
        double se;

        public AccuracySource(String string, double d, double d2, double d3) {
            this.name = string;
            this.ce = d;
            this.le = d2;
            this.se = d3;
        }
    }
}

