/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.logdata;

import gmonitor.logdata.BinaryBlock;
import gmonitor.logdata.DataBlockGroupTable;
import gmonitor.logdata.HostDefBlock;
import gmonitor.logdata.IntervalDefBlock;
import gmonitor.logdata.OIDDefBlock;
import java.io.IOException;
import java.io.InputStream;

public class SecondMetaBlock
extends BinaryBlock {
    HostDefBlock hdb;
    OIDDefBlock odb;
    IntervalDefBlock idb;
    DataBlockGroupTable dbgt;

    public HostDefBlock getHostDefBlock() {
        return this.hdb;
    }

    public OIDDefBlock getOIDDefBlock() {
        return this.odb;
    }

    public IntervalDefBlock getIntervalDefBlock() {
        return this.idb;
    }

    public DataBlockGroupTable getDataBlockGroupTable() {
        return this.dbgt;
    }

    public String asDump() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# Second Meta Block\n");
        stringBuffer.append("SecondMetaBlockSize::");
        stringBuffer.append(this.size);
        stringBuffer.append('\n');
        stringBuffer.append(this.hdb.toString());
        stringBuffer.append('\n');
        stringBuffer.append(this.odb.toString());
        stringBuffer.append('\n');
        stringBuffer.append(this.idb.toString());
        stringBuffer.append('\n');
        stringBuffer.append(this.dbgt.toString());
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    public static SecondMetaBlock newInstance(InputStream inputStream, int n) throws IOException {
        SecondMetaBlock secondMetaBlock = new SecondMetaBlock();
        secondMetaBlock.deserialize(inputStream, n);
        return secondMetaBlock;
    }

    protected void parse_binary_block(InputStream inputStream) throws IOException {
        int n = this.read2bytesInt(inputStream);
        this.hdb = HostDefBlock.newInstance(inputStream, n);
        n = this.read2bytesInt(inputStream);
        this.odb = OIDDefBlock.newInstance(inputStream, n);
        n = this.read2bytesInt(inputStream);
        this.idb = IntervalDefBlock.newInstance(inputStream, n);
        n = this.read2bytesInt(inputStream);
        this.dbgt = DataBlockGroupTable.newInstance(inputStream, n);
    }

    public boolean containsHost(String string) {
        return this.hdb.containsHost(string);
    }

    public boolean containsEvent(String string) {
        return this.odb.containsEvent(string);
    }
}

