/*
 * Decompiled with CFR 0.152.
 */
package gmonitor.tools;

import gmonitor.logdata.DataFile;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class ScanLogDir {
    ArrayList files = new ArrayList();

    public ScanLogDir(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-")) continue;
            this.files.add(stringArray[i]);
        }
    }

    public void run() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        System.out.println("Processing files are:");
        for (int i = 0; i < this.files.size(); ++i) {
            String string = (String)this.files.get(i);
            System.out.print(string + "\t");
            try {
                DataFile dataFile = DataFile.getInstance(string);
                long l = dataFile.getBeginDateTime();
                long l2 = dataFile.getLatestDateTime();
                System.out.print("Begin:" + simpleDateFormat.format(new Date(l)));
                System.out.print(" End:" + simpleDateFormat.format(new Date(l2)));
                System.out.print('\n');
                continue;
            }
            catch (IOException iOException) {
                System.out.println("*** IOException ***");
            }
        }
    }

    public static void main(String[] stringArray) {
        ScanLogDir scanLogDir = new ScanLogDir(stringArray);
        long l = System.currentTimeMillis();
        scanLogDir.run();
        long l2 = System.currentTimeMillis();
        System.out.println("Elapsed in realtime: " + (l2 - l) + " milli-seconds.");
    }
}

