// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package iotdeviceadvisoriface provides an interface to enable mocking the AWS IoT Core Device Advisor service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package iotdeviceadvisoriface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/iotdeviceadvisor"
)

// IoTDeviceAdvisorAPI provides an interface to enable mocking the
// iotdeviceadvisor.IoTDeviceAdvisor service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS IoT Core Device Advisor.
//    func myFunc(svc iotdeviceadvisoriface.IoTDeviceAdvisorAPI) bool {
//        // Make svc.CreateSuiteDefinition request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := iotdeviceadvisor.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockIoTDeviceAdvisorClient struct {
//        iotdeviceadvisoriface.IoTDeviceAdvisorAPI
//    }
//    func (m *mockIoTDeviceAdvisorClient) CreateSuiteDefinition(input *iotdeviceadvisor.CreateSuiteDefinitionInput) (*iotdeviceadvisor.CreateSuiteDefinitionOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockIoTDeviceAdvisorClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type IoTDeviceAdvisorAPI interface {
	CreateSuiteDefinition(*iotdeviceadvisor.CreateSuiteDefinitionInput) (*iotdeviceadvisor.CreateSuiteDefinitionOutput, error)
	CreateSuiteDefinitionWithContext(aws.Context, *iotdeviceadvisor.CreateSuiteDefinitionInput, ...request.Option) (*iotdeviceadvisor.CreateSuiteDefinitionOutput, error)
	CreateSuiteDefinitionRequest(*iotdeviceadvisor.CreateSuiteDefinitionInput) (*request.Request, *iotdeviceadvisor.CreateSuiteDefinitionOutput)

	DeleteSuiteDefinition(*iotdeviceadvisor.DeleteSuiteDefinitionInput) (*iotdeviceadvisor.DeleteSuiteDefinitionOutput, error)
	DeleteSuiteDefinitionWithContext(aws.Context, *iotdeviceadvisor.DeleteSuiteDefinitionInput, ...request.Option) (*iotdeviceadvisor.DeleteSuiteDefinitionOutput, error)
	DeleteSuiteDefinitionRequest(*iotdeviceadvisor.DeleteSuiteDefinitionInput) (*request.Request, *iotdeviceadvisor.DeleteSuiteDefinitionOutput)

	GetSuiteDefinition(*iotdeviceadvisor.GetSuiteDefinitionInput) (*iotdeviceadvisor.GetSuiteDefinitionOutput, error)
	GetSuiteDefinitionWithContext(aws.Context, *iotdeviceadvisor.GetSuiteDefinitionInput, ...request.Option) (*iotdeviceadvisor.GetSuiteDefinitionOutput, error)
	GetSuiteDefinitionRequest(*iotdeviceadvisor.GetSuiteDefinitionInput) (*request.Request, *iotdeviceadvisor.GetSuiteDefinitionOutput)

	GetSuiteRun(*iotdeviceadvisor.GetSuiteRunInput) (*iotdeviceadvisor.GetSuiteRunOutput, error)
	GetSuiteRunWithContext(aws.Context, *iotdeviceadvisor.GetSuiteRunInput, ...request.Option) (*iotdeviceadvisor.GetSuiteRunOutput, error)
	GetSuiteRunRequest(*iotdeviceadvisor.GetSuiteRunInput) (*request.Request, *iotdeviceadvisor.GetSuiteRunOutput)

	GetSuiteRunReport(*iotdeviceadvisor.GetSuiteRunReportInput) (*iotdeviceadvisor.GetSuiteRunReportOutput, error)
	GetSuiteRunReportWithContext(aws.Context, *iotdeviceadvisor.GetSuiteRunReportInput, ...request.Option) (*iotdeviceadvisor.GetSuiteRunReportOutput, error)
	GetSuiteRunReportRequest(*iotdeviceadvisor.GetSuiteRunReportInput) (*request.Request, *iotdeviceadvisor.GetSuiteRunReportOutput)

	ListSuiteDefinitions(*iotdeviceadvisor.ListSuiteDefinitionsInput) (*iotdeviceadvisor.ListSuiteDefinitionsOutput, error)
	ListSuiteDefinitionsWithContext(aws.Context, *iotdeviceadvisor.ListSuiteDefinitionsInput, ...request.Option) (*iotdeviceadvisor.ListSuiteDefinitionsOutput, error)
	ListSuiteDefinitionsRequest(*iotdeviceadvisor.ListSuiteDefinitionsInput) (*request.Request, *iotdeviceadvisor.ListSuiteDefinitionsOutput)

	ListSuiteDefinitionsPages(*iotdeviceadvisor.ListSuiteDefinitionsInput, func(*iotdeviceadvisor.ListSuiteDefinitionsOutput, bool) bool) error
	ListSuiteDefinitionsPagesWithContext(aws.Context, *iotdeviceadvisor.ListSuiteDefinitionsInput, func(*iotdeviceadvisor.ListSuiteDefinitionsOutput, bool) bool, ...request.Option) error

	ListSuiteRuns(*iotdeviceadvisor.ListSuiteRunsInput) (*iotdeviceadvisor.ListSuiteRunsOutput, error)
	ListSuiteRunsWithContext(aws.Context, *iotdeviceadvisor.ListSuiteRunsInput, ...request.Option) (*iotdeviceadvisor.ListSuiteRunsOutput, error)
	ListSuiteRunsRequest(*iotdeviceadvisor.ListSuiteRunsInput) (*request.Request, *iotdeviceadvisor.ListSuiteRunsOutput)

	ListSuiteRunsPages(*iotdeviceadvisor.ListSuiteRunsInput, func(*iotdeviceadvisor.ListSuiteRunsOutput, bool) bool) error
	ListSuiteRunsPagesWithContext(aws.Context, *iotdeviceadvisor.ListSuiteRunsInput, func(*iotdeviceadvisor.ListSuiteRunsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*iotdeviceadvisor.ListTagsForResourceInput) (*iotdeviceadvisor.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *iotdeviceadvisor.ListTagsForResourceInput, ...request.Option) (*iotdeviceadvisor.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*iotdeviceadvisor.ListTagsForResourceInput) (*request.Request, *iotdeviceadvisor.ListTagsForResourceOutput)

	StartSuiteRun(*iotdeviceadvisor.StartSuiteRunInput) (*iotdeviceadvisor.StartSuiteRunOutput, error)
	StartSuiteRunWithContext(aws.Context, *iotdeviceadvisor.StartSuiteRunInput, ...request.Option) (*iotdeviceadvisor.StartSuiteRunOutput, error)
	StartSuiteRunRequest(*iotdeviceadvisor.StartSuiteRunInput) (*request.Request, *iotdeviceadvisor.StartSuiteRunOutput)

	StopSuiteRun(*iotdeviceadvisor.StopSuiteRunInput) (*iotdeviceadvisor.StopSuiteRunOutput, error)
	StopSuiteRunWithContext(aws.Context, *iotdeviceadvisor.StopSuiteRunInput, ...request.Option) (*iotdeviceadvisor.StopSuiteRunOutput, error)
	StopSuiteRunRequest(*iotdeviceadvisor.StopSuiteRunInput) (*request.Request, *iotdeviceadvisor.StopSuiteRunOutput)

	TagResource(*iotdeviceadvisor.TagResourceInput) (*iotdeviceadvisor.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *iotdeviceadvisor.TagResourceInput, ...request.Option) (*iotdeviceadvisor.TagResourceOutput, error)
	TagResourceRequest(*iotdeviceadvisor.TagResourceInput) (*request.Request, *iotdeviceadvisor.TagResourceOutput)

	UntagResource(*iotdeviceadvisor.UntagResourceInput) (*iotdeviceadvisor.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *iotdeviceadvisor.UntagResourceInput, ...request.Option) (*iotdeviceadvisor.UntagResourceOutput, error)
	UntagResourceRequest(*iotdeviceadvisor.UntagResourceInput) (*request.Request, *iotdeviceadvisor.UntagResourceOutput)

	UpdateSuiteDefinition(*iotdeviceadvisor.UpdateSuiteDefinitionInput) (*iotdeviceadvisor.UpdateSuiteDefinitionOutput, error)
	UpdateSuiteDefinitionWithContext(aws.Context, *iotdeviceadvisor.UpdateSuiteDefinitionInput, ...request.Option) (*iotdeviceadvisor.UpdateSuiteDefinitionOutput, error)
	UpdateSuiteDefinitionRequest(*iotdeviceadvisor.UpdateSuiteDefinitionInput) (*request.Request, *iotdeviceadvisor.UpdateSuiteDefinitionOutput)
}

var _ IoTDeviceAdvisorAPI = (*iotdeviceadvisor.IoTDeviceAdvisor)(nil)
