English | [简体中文](https://github.com/yunshuipiao/algorithms/blob/master/README_CN.md)

Pythonic Data Structures and Algorithms
=========================================

Minimal and clean example implementations of data structures and algorithms in Python.


## List of Implementations

- [array](array)
    - [circular_counter](array/circular_counter.py)
    - [flatten](array/flatten.py)
    - [garage](array/garage.py)
    - [longest_non_repeat](array/longest_non_repeat.py/)
    - [merge_intervals](array/merge_intervals.py)
    - [missing_ranges](array/missing_ranges.py)
    - [plus_one](array/plus_one.py)
    - [rotate_array](array/rotate_array.py)
    - [summary_ranges](array/summary_ranges.py)
    - [three_sum](array/three_sum.py)
    - [two_sum](array/two_sum.py)
- [backtrack](backtrack)
    - [general_solution.md](backtrack/)
    - [anagram](backtrack/anagram.py)
    - [array_sum_combinations](backtrack/array_sum_combinations.py)
    - [combination_sum](backtrack/combination_sum.py)
    - [expression_add_operators](backtrack/expression_add_operators.py)
    - [factor_combinations](backtrack/factor_combinations.py)
    - [generate_abbreviations](backtrack/generate_abbreviations.py)
    - [generate_parenthesis](backtrack/generate_parenthesis.py)
    - [letter_combination](backtrack/letter_combination.py)
    - [palindrome_partitioning](backtrack/palindrome_partitioning.py)
    - [pattern_match](backtrack/pattern_match.py)
    - [permute](backtrack/permute.py)
    - [permute_unique](backtrack/permute_unique.py)
    - [subsets](backtrack/subsets.py)
    - [subsets_unique](backtrack/subsets_unique.py)
- [bfs](bfs)
    - [shortest_distance_from_all_buildings](bfs/shortest_distance_from_all_buildings.py)
    - [word_ladder](bfs/word_ladder.py)
- [bit](bit)
    - [bytes_int_conversion](bit/bytes_int_conversion.py)
    - [count_ones](bit/count_ones.py)
    - [find_missing_number](bit/find_missing_number.py)
    - [power_of_two](bit/power_of_two.py)
    - [reverse_bits](bit/reverse_bits.py)
    - [single_number2](bit/single_number2.py)
    - [single_number](bit/single_number.py)
    - [subsets](bit/subsets.py)
    - [add_without_operator](bit/add_without_operator.py)
- [calculator](calculator)
    - [math_parser](calculator/math_parser.py)
- [dfs](dfs)
    - [all_factors](dfs/all_factors.py)
    - [count_islands](dfs/count_islands.py)
    - [pacific_atlantic](dfs/pacific_atlantic.py)
    - [sudoku_solver](dfs/sudoku_solver.py)
    - [walls_and_gates](dfs/walls_and_gates.py)
- [dp](dp)
    - [buy_sell_stock](dp/buy_sell_stock.py)
    - [climbing_stairs](dp/climbing_stairs.py)
    - [combination_sum](dp/combination_sum.py)
    - [house_robber](dp/house_robber.py)
    - [knapsack](dp/knapsack.py)
    - [longest_increasing](dp/longest_increasing.py)
    - [max_product_subarray](dp/max_product_subarray.py)
    - [max_subarray](dp/max_subarray.py)
    - [num_decodings](dp/num_decodings.py)
    - [regex_matching](dp/regex_matching.py)
    - [word_break](dp/word_break.py)
- [graph](graph)
    - [2-sat](graph/satisfiability.py)
    - [clone_graph](graph/clone_graph.py)
    - [cycle_detection](graph/cycle_detection.py)
    - [find_path](graph/find_path.py)
    - [graph](graph/graph.py)
    - [traversal](graph/traversal.py)
    - [markov_chain](graph/markov_chain.py)
- [heap](heap)
    - [merge_sorted_k_lists](heap/merge_sorted_k_lists.py)
    - [skyline](heap/skyline.py)
    - [sliding_window_max](heap/sliding_window_max.py)
- [linkedlist](linkedlist)
    - [add_two_numbers](linkedlist/add_two_numbers.py)
    - [copy_random_pointer](linkedlist/copy_random_pointer.py)
    - [delete_node](linkedlist/delete_node.py)
    - [first_cyclic_node](linkedlist/first_cyclic_node.py)
    - [is_cyclic](linkedlist/is_cyclic.py)
    - [is_palindrome](linkedlist/is_palindrome.py)
    - [kth_to_last](linkedlist/kth_to_last.py)
    - [linkedlist](linkedlist/linkedlist.py)
    - [remove_duplicates](linkedlist/remove_duplicates.py)
    - [reverse](linkedlist/reverse.py)
    - [rotate_list](linkedlist/rotate_list.py)
    - [swap_in_pairs](linkedlist/swap_in_pairs.py)
- [map](map)
    - [hashtable](map/hashtable.py)
    - [longest_common_subsequence](map/longest_common_subsequence.py)
    - [randomized_set](map/randomized_set.py)
    - [valid_sudoku](map/valid_sudoku.py)
- [math](math)
    - [extended_gcd](math/extended_gcd.py)
    - [gcd/lcm](math/gcd.py)
    - [prime_test](math/prime_test.py)
    - [primes_sieve_of_eratosthenes](math/primes_sieve_of_eratosthenes.py)
    - [generate_strobogrammtic](math/generate_strobogrammtic.py)
    - [is_strobogrammatic](math/is_strobogrammatic.py)
    - [nth_digit](math/nth_digit.py)
    - [rabin_miller](math/rabin_miller.py)
    - [rsa](math/rsa.py)
    - [sqrt_precision_factor](math/sqrt_precision_factor.py)
    - [pythagoras](math/pythagoras.py)
- [matrix](matrix)
    - [matrix_rotation.txt](matrix/matrix_rotation.txt)
    - [copy_transform](matrix/copy_transform.py)
    - [bomb_enemy](matrix/bomb_enemy.py)
    - [rotate_image](matrix/rotate_image.py)
    - [sparse_dot_vector](matrix/sparse_dot_vector.py)
    - [sparse_mul](matrix/sparse_mul.py)
    - [spiral_traversal](matrix/spiral_traversal.py)
    - [count_paths](matrix/count_paths.py)
- [queue](queue)
    - [max_sliding_window](queue/max_sliding_window.py)
    - [moving_average](queue/moving_average.py)
    - [queue](queue/queue.py)
    - [reconstruct_queue](queue/reconstruct_queue.py)
    - [zigzagiterator](queue/zigzagiterator.py)
- [search](search)
    - [binary_search](search/binary_search.py)
    - [count_elem](search/count_elem.py)
    - [first_occurance](search/first_occurance.py)
    - [last_occurance](search/last_occurance.py)
- [set](set)
    - [randomized_set](set/randomized_set.py)
    - [set_covering](set/set_covering.py)
- [sort](sort)
    - [bubble_sort](sort/bubble_sort.py)
    - [comb_sort](sort/comb_sort.py)
    - [counting_sort](sort/counting_sort.py)
    - [heap_sort](sort/heap_sort.py)
    - [insertion_sort](sort/insertion_sort.py)
    - [meeting_rooms](sort/meeting_rooms.py)
    - [merge_sort](sort/merge_sort.py)
    - [quick_sort](sort/quick_sort.py)
    - [selection_sort](sort/selection_sort.py)
    - [sort_colors](sort/sort_colors.py)
    - [topsort](sort/topsort.py)
    - [wiggle_sort](sort/wiggle_sort.py)
- [stack](stack)
    - [longest_abs_path](stack/longest_abs_path.py)
    - [simplify_path](stack/simplify_path.py)
    - [stack](stack/stack.py)
    - [valid_parenthesis](stack/valid_parenthesis.py)
- [string](string)
    - [add_binary](string/add_binary.py)
    - [breaking_bad](string/breaking_bad.py)
    - [decode_string](string/decode_string.py)
    - [encode_decode](string/encode_decode.py)
    - [group_anagrams](string/group_anagrams.py)
    - [int_to_roman](string/int_to_roman.py)
    - [is_palindrome](string/is_palindrome.py)
    - [license_number](string/license_number.py)
    - [make_sentence](string/make_sentence.py)
    - [multiply_strings](string/multiply_strings.py)
    - [one_edit_distance](string/one_edit_distance.py)
    - [rabin_karp](string/rabin_karp.py)
    - [reverse_string](string/reverse_string.py)
    - [reverse_vowel](string/reverse_vowel.py)
    - [reverse_words](string/reverse_words.py)
    - [roman_to_int](string/roman_to_int.py)
    - [word_squares](string/word_squares.py)
- [tree](tree)
    - [segment-tree](tree/Segment_Tree)
        - [segment_tree](tree/Segment_Tree/segment_tree.py)
    - [binary_tree_paths](tree/binary_tree_paths.py)
    - [bintree2list](tree/bintree2list.py)
    - [bst](tree/tree/bst)
        - [array2bst](tree/bst/array2bst.py)
        - [bst_closest_value](tree/bst/bst_closest_value.py)
        - [BSTIterator](tree/bst/BSTIterator.py)
        - [delete_node](tree/bst/delete_node.py)
        - [is_bst](tree/bst/is_bst.py)
        - [kth_smallest](tree/bst/kth_smallest.py)
        - [lowest_common_ancestor](tree/bst/lowest_common_ancestor.py)
        - [predecessor](tree/bst/predecessor.py)
        - [serialize_deserialize](tree/bst/serialize_deserialize.py)
        - [successor](tree/bst/successor.py)
        - [unique_bst](tree/bst/unique_bst.py)
    - [deepest_left](tree/deepest_left.py)
    - [invert_tree](tree/invert_tree.py)
    - [is_balanced](tree/is_balanced.py)
    - [is_subtree](tree/is_subtree.py)
    - [is_symmetric](tree/is_symmetric.py)
    - [longest_consecutive](tree/longest_consecutive.py)
    - [lowest_common_ancestor](tree/lowest_common_ancestor.py)
    - [max_height](tree/max_height.py)
    - [max_path_sum](tree/max_path_sum.py)
    - [min_height](tree/min_height.py)
    - [path_sum2](tree/path_sum2.py)
    - [path_sum](tree/path_sum.py)
    - [pretty_print](tree/pretty_print.py)
    - [same_tree](tree/same_tree.py)
    - [traversal](tree/traversal)
        - [inorder](tree/traversal/inorder.py)
        - [level_order](tree/traversal/level_order.py)
        - [zigzag](tree/traversal/zigzag.py)
    - [tree](tree/tree.py)
    - [trie](tree/trie)
        - [add_and_search](tree/trie/add_and_search.py)
        - [trie](tree/trie/trie.py)
- [union-find](union-find)
    - [count_islands](union-find/count_islands.py)

