package callrules

// go generate -import github.com/mesos/mesos-go/api/v1/lib -import github.com/mesos/mesos-go/api/v1/lib/executor -type E:*executor.Call:&executor.Call{} -type ET:executor.Call_Type -type Z:mesos.Response:&mesos.ResponseWrapper{} -output metrics_generated.go
// GENERATED CODE FOLLOWS; DO NOT EDIT.

import (
	"context"

	"strings"

	"github.com/mesos/mesos-go/api/v1/lib/extras/metrics"

	"github.com/mesos/mesos-go/api/v1/lib"
	"github.com/mesos/mesos-go/api/v1/lib/executor"
)

// Labeler generates a set of strings that should be associated with metrics that are generated for the given event.
type Labeler func(ctx context.Context, e *executor.Call) []string

var defaultLabels = func() map[executor.Call_Type][]string {
	m := make(map[executor.Call_Type][]string)
	for k, v := range executor.Call_Type_name {
		m[executor.Call_Type(k)] = []string{strings.ToLower(v)}
	}
	return m
}()

func defaultLabeler(ctx context.Context, e *executor.Call) []string {
	return defaultLabels[e.GetType()]
}

// Metrics generates a Rule that invokes the given harness for each event, using the labels generated by the Labeler.
// Panics if harness or labeler is nil.
func Metrics(harness metrics.Harness, labeler Labeler) Rule {
	if harness == nil {
		panic("harness is a required parameter")
	}
	if labeler == nil {
		labeler = defaultLabeler
	}
	return func(ctx context.Context, e *executor.Call, z mesos.Response, err error, ch Chain) (context.Context, *executor.Call, mesos.Response, error) {
		labels := labeler(ctx, e)
		harness(func() error {
			ctx, e, z, err = ch(ctx, e, z, err)
			return err
		}, labels...)
		return ctx, e, z, err
	}
}
