// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2022 The Sigstore Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package timestamp

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/sigstore/timestamp-authority/v2/pkg/generated/models"
)

// GetTimestampCertChainOKCode is the HTTP code returned for type GetTimestampCertChainOK
const GetTimestampCertChainOKCode int = 200

/*
GetTimestampCertChainOK The PEM encoded cert chain

swagger:response getTimestampCertChainOK
*/
type GetTimestampCertChainOK struct {

	/*
	  In: Body
	*/
	Payload string `json:"body,omitempty"`
}

// NewGetTimestampCertChainOK creates GetTimestampCertChainOK with default headers values
func NewGetTimestampCertChainOK() *GetTimestampCertChainOK {

	return &GetTimestampCertChainOK{}
}

// WithPayload adds the payload to the get timestamp cert chain o k response
func (o *GetTimestampCertChainOK) WithPayload(payload string) *GetTimestampCertChainOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get timestamp cert chain o k response
func (o *GetTimestampCertChainOK) SetPayload(payload string) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTimestampCertChainOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	payload := o.Payload
	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

// GetTimestampCertChainNotFoundCode is the HTTP code returned for type GetTimestampCertChainNotFound
const GetTimestampCertChainNotFoundCode int = 404

/*
GetTimestampCertChainNotFound The content requested could not be found

swagger:response getTimestampCertChainNotFound
*/
type GetTimestampCertChainNotFound struct {
}

// NewGetTimestampCertChainNotFound creates GetTimestampCertChainNotFound with default headers values
func NewGetTimestampCertChainNotFound() *GetTimestampCertChainNotFound {

	return &GetTimestampCertChainNotFound{}
}

// WriteResponse to the client
func (o *GetTimestampCertChainNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) // Remove Content-Type on empty responses

	rw.WriteHeader(404)
}

/*
GetTimestampCertChainDefault There was an internal error in the server while processing the request

swagger:response getTimestampCertChainDefault
*/
type GetTimestampCertChainDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetTimestampCertChainDefault creates GetTimestampCertChainDefault with default headers values
func NewGetTimestampCertChainDefault(code int) *GetTimestampCertChainDefault {
	if code <= 0 {
		code = 500
	}

	return &GetTimestampCertChainDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get timestamp cert chain default response
func (o *GetTimestampCertChainDefault) WithStatusCode(code int) *GetTimestampCertChainDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get timestamp cert chain default response
func (o *GetTimestampCertChainDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the get timestamp cert chain default response
func (o *GetTimestampCertChainDefault) WithPayload(payload *models.Error) *GetTimestampCertChainDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get timestamp cert chain default response
func (o *GetTimestampCertChainDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetTimestampCertChainDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
