/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pccbase;

import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.defines.BatteryStatus;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pcc.defines.RequestStatus;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.utility.log.LogAnt;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.concurrent.Semaphore;

public abstract class AntPlusCommonPcc
extends AntPluginPcc {
    private static final String TAG = AntPlusCommonPcc.class.getSimpleName();
    protected IRequestFinishedReceiver mRequestFinishedReceiver;
    protected Semaphore mCommandLock = new Semaphore(1);
    IManufacturerIdentificationReceiver mManufacturerIdentificationReceiver;
    IProductInformationReceiver mProductInformationReceiver;
    IBatteryStatusReceiver mBatteryStatusReceiver;
    IManufacturerSpecificDataReceiver mManufacturerSpecificDataReceiver;

    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 100: {
                if (this.mManufacturerIdentificationReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int hardwareRevision = b.getInt("int_hardwareRevision");
                int manufacturerID = b.getInt("int_manufacturerID");
                int modelNumber = b.getInt("int_modelNumber");
                this.mManufacturerIdentificationReceiver.onNewManufacturerIdentification(estTimestamp, eventFlags, hardwareRevision, manufacturerID, modelNumber);
                break;
            }
            case 101: {
                if (this.mProductInformationReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                int mainSoftwareRevision = b.getInt("int_softwareRevision");
                int supplementaryRevision = b.getInt("int_supplementaryRevision", -2);
                long serialNumber = b.getLong("long_serialNumber");
                this.mProductInformationReceiver.onNewProductInformation(estTimestamp, eventFlags, mainSoftwareRevision, supplementaryRevision, serialNumber);
                break;
            }
            case 102: {
                if (this.mBatteryStatusReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long cumulativeOperatingTime = b.getLong("long_cumulativeOperatingTime");
                BigDecimal batteryVoltage = (BigDecimal)b.getSerializable("decimal_batteryVoltage");
                BatteryStatus batteryStatus = BatteryStatus.getValueFromInt(b.getInt("int_batteryStatusCode"));
                int cumulativeOperatingTimeResolution = b.getInt("int_cumulativeOperatingTimeResolution");
                int numberOfBatteries = b.getInt("int_numberOfBatteries", -2);
                int batteryIdentifier = b.getInt("int_batteryIdentifier", -2);
                this.mBatteryStatusReceiver.onNewBatteryStatus(estTimestamp, eventFlags, cumulativeOperatingTime, batteryVoltage, batteryStatus, cumulativeOperatingTimeResolution, numberOfBatteries, batteryIdentifier);
                break;
            }
            case 103: {
                if (this.mManufacturerSpecificDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                byte[] rawDataBytes = b.getByteArray("arrayByte_rawDataBytes");
                this.mManufacturerSpecificDataReceiver.onNewManufacturerSpecificData(estTimestamp, eventFlags, rawDataBytes);
            }
            case 107: {
                IRequestFinishedReceiver tempReceiver = this.mRequestFinishedReceiver;
                this.mRequestFinishedReceiver = null;
                this.mCommandLock.release();
                if (tempReceiver == null) break;
                Bundle b = eventMsg.getData();
                int requestStatus = b.getInt("int_requestStatus");
                tempReceiver.onNewRequestFinished(RequestStatus.getValueFromInt(requestStatus));
                break;
            }
            default: {
                LogAnt.d(TAG, "Unrecognized event received: " + eventMsg.arg1);
            }
        }
    }

    public void subscribeManufacturerIdentificationEvent(IManufacturerIdentificationReceiver ManufacturerIdentificationReceiver) {
        this.mManufacturerIdentificationReceiver = ManufacturerIdentificationReceiver;
        if (ManufacturerIdentificationReceiver != null) {
            this.subscribeToEvent(100);
        } else {
            this.unsubscribeFromEvent(100);
        }
    }

    public void subscribeProductInformationEvent(IProductInformationReceiver ProductInformationReceiver) {
        this.mProductInformationReceiver = ProductInformationReceiver;
        if (ProductInformationReceiver != null) {
            this.subscribeToEvent(101);
        } else {
            this.unsubscribeFromEvent(101);
        }
    }

    public void subscribeBatteryStatusEvent(IBatteryStatusReceiver BatteryStatusReceiver) {
        this.mBatteryStatusReceiver = BatteryStatusReceiver;
        if (BatteryStatusReceiver != null) {
            this.subscribeToEvent(102);
        } else {
            this.unsubscribeFromEvent(102);
        }
    }

    public boolean subscribeManufacturerSpecificDataEvent(IManufacturerSpecificDataReceiver ManufacturerSpecificDataReceiver) {
        if (this.reportedServiceVersion < 20206) {
            LogAnt.w(TAG, "subscribeManufacturerSpecificDataEvent requires ANT+ Plugins Service >20206, installed: " + this.reportedServiceVersion);
            return false;
        }
        this.mManufacturerSpecificDataReceiver = ManufacturerSpecificDataReceiver;
        if (ManufacturerSpecificDataReceiver != null) {
            return this.subscribeToEvent(103);
        }
        this.unsubscribeFromEvent(103);
        return true;
    }

    public boolean requestCommonDataPage(CommonDataPage commonDataPage, IRequestFinishedReceiver requestFinishedReceiver) {
        String cmdName = "requestCommonDataPage";
        int whatCmd = 106;
        Bundle params = new Bundle();
        params.putInt("int_requestedDataPage", commonDataPage.getIntValue());
        return this.sendRequestCommand(cmdName, whatCmd, params, requestFinishedReceiver, 20209);
    }

    protected boolean sendRequestCommand(String cmdName, int whatCmd, Bundle params, IRequestFinishedReceiver requestFinishedReceiver, Integer requiredServiceVersion) {
        Message ret;
        if (requiredServiceVersion != null && this.reportedServiceVersion < requiredServiceVersion) {
            LogAnt.w(TAG, cmdName + " requires ANT+ Plugins Service >=" + requiredServiceVersion + ", installed: " + this.reportedServiceVersion);
            if (requestFinishedReceiver != null) {
                requestFinishedReceiver.onNewRequestFinished(RequestStatus.FAIL_PLUGINS_SERVICE_VERSION);
            }
            return false;
        }
        if (!this.mCommandLock.tryAcquire()) {
            LogAnt.e(TAG, "Cmd " + cmdName + " failed to start because a local command is still processing.");
            return false;
        }
        this.mRequestFinishedReceiver = requestFinishedReceiver;
        Message cmdMsg = Message.obtain();
        cmdMsg.what = whatCmd;
        if (params != null) {
            cmdMsg.setData(params);
        }
        if ((ret = this.sendPluginCommand(cmdMsg)) == null) {
            LogAnt.e(TAG, "Cmd " + cmdName + " died in sendPluginCommand()");
            this.mCommandLock.release();
            return false;
        }
        if (ret.arg1 == -3) {
            LogAnt.e(TAG, "Cmd " + cmdName + " failed with code " + ret.arg1);
            ret.recycle();
            this.mRequestFinishedReceiver = null;
            this.mCommandLock.release();
            if (requestFinishedReceiver != null) {
                requestFinishedReceiver.onNewRequestFinished(RequestStatus.FAIL_BAD_PARAMS);
            }
            return false;
        }
        if (ret.arg1 != 0) {
            LogAnt.e(TAG, "Cmd " + cmdName + " failed with code " + ret.arg1);
            ret.recycle();
            this.mRequestFinishedReceiver = null;
            this.mCommandLock.release();
            throw new RuntimeException(cmdName + " cmd failed internally");
        }
        ret.recycle();
        return true;
    }

    protected boolean sendRequestCommand(String cmdName, int whatCmd, IRequestFinishedReceiver requestFinishedReceiver) {
        return this.sendRequestCommand(cmdName, whatCmd, null, requestFinishedReceiver, null);
    }

    protected boolean sendRequestCommand(String cmdName, int whatCmd, Bundle params, IRequestFinishedReceiver requestFinishedReceiver) {
        return this.sendRequestCommand(cmdName, whatCmd, params, requestFinishedReceiver, null);
    }

    protected boolean sendRequestCommand(String cmdName, int whatCmd, IRequestFinishedReceiver requestFinishedReceiver, Integer requiredServiceVersion) {
        return this.sendRequestCommand(cmdName, whatCmd, null, requestFinishedReceiver, requiredServiceVersion);
    }

    public static interface IRequestFinishedReceiver {
        public void onNewRequestFinished(RequestStatus var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IManufacturerSpecificDataReceiver {
        public void onNewManufacturerSpecificData(long var1, EnumSet<EventFlag> var3, byte[] var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IBatteryStatusReceiver {
        public void onNewBatteryStatus(long var1, EnumSet<EventFlag> var3, long var4, BigDecimal var6, BatteryStatus var7, int var8, int var9, int var10);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IProductInformationReceiver {
        public void onNewProductInformation(long var1, EnumSet<EventFlag> var3, int var4, int var5, long var6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IManufacturerIdentificationReceiver {
        public void onNewManufacturerIdentification(long var1, EnumSet<EventFlag> var3, int var4, int var5, int var6);
    }

    public class IpcDefines {
        public static final String MSG_EVENT_ALLDATAEVENTS_PARAM_longESTTIMESTAMP = "long_EstTimestamp";
        public static final String MSG_EVENT_ALLDATAEVENTS_PARAM_longEVENTFLAGS = "long_EventFlags";
        public static final int MSG_EVENT_BASECOMMONPAGES_whatMANUFACTURERIDENTIFICATION = 100;
        public static final String MSG_EVENT_BASECOMMONPAGES_MANUFACTURERIDENTIFICATION_PARAM_intHARDWAREREVISION = "int_hardwareRevision";
        public static final String MSG_EVENT_BASECOMMONPAGES_MANUFACTURERIDENTIFICATION_PARAM_intMANUFACTURERID = "int_manufacturerID";
        public static final String MSG_EVENT_BASECOMMONPAGES_MANUFACTURERIDENTIFICATION_PARAM_intMODELNUMBER = "int_modelNumber";
        public static final int MSG_EVENT_BASECOMMONPAGES_whatPRODUCTINFORMATION = 101;
        public static final String MSG_EVENT_BASECOMMONPAGES_PRODUCTINFORMATION_PARAM_intMAINSOFTWAREREVISION = "int_softwareRevision";
        public static final String MSG_EVENT_BASECOMMONPAGES_PRODUCTINFORMATION_PARAM_intSUPPLEMENTALSOFTWAREREVISION = "int_supplementaryRevision";
        public static final String MSG_EVENT_BASECOMMONPAGES_PRODUCTINFORMATION_PARAM_longSERIALNUMBER = "long_serialNumber";
        public static final int MSG_EVENT_BASECOMMONPAGES_whatBATTERYSTATUS = 102;
        public static final String MSG_EVENT_BASECOMMONPAGES_BATTERYSTATUS_PARAM_longCUMULATIVEOPERATINGTIME = "long_cumulativeOperatingTime";
        public static final String MSG_EVENT_BASECOMMONPAGES_BATTERYSTATUS_PARAM_decimalBATTERYVOLTAGE = "decimal_batteryVoltage";
        public static final String MSG_EVENT_BASECOMMONPAGES_BATTERYSTATUS_PARAM_intBATTERYSTATUSCODE = "int_batteryStatusCode";
        public static final String MSG_EVENT_BASECOMMONPAGES_BATTERYSTATUS_PARAM_intCUMULATIVEOPERATINGTIMERESOLUTION = "int_cumulativeOperatingTimeResolution";
        public static final String MSG_EVENT_BASECOMMONPAGES_BATTERYSTATUS_PARAM_intNUMBEROFBATTERIES = "int_numberOfBatteries";
        public static final String MSG_EVENT_BASECOMMONPAGES_BATTERYSTATUS_PARAM_intBATTERYIDENTIFIER = "int_batteryIdentifier";
        public static final int MSG_EVENT_BASECOMMONPAGES_whatMANUFACTURERSPECIFICDATA = 103;
        public static final String MSG_EVENT_BASECOMMONPAGES_MANUFACTURERSPECIFICDATA_PARAM_arrayByteRAWDATABYTES = "arrayByte_rawDataBytes";
        public static final int MSG_CMD_BASECOMMONPAGES_whatREQUESTCOMMANDBURST = 104;
        public static final String MSG_CMD_BASECOMMONPAGES_REQUESTCOMMANDBURST_PARAM_intREQUESTEDCOMMANDID = "int_requestedCommandId";
        public static final String MSG_CMD_BASECOMMONPAGES_REQUESTCOMMANDBURST_PARAM_arrayByteCOMMANDDATA = "arrayByte_commandData";
        public static final int MSG_CMD_BASECOMMONPAGES_whatREQUESTCOMMANDSTATUS = 105;
        public static final int MSG_CMD_BASECOMMONPAGES_whatREQUESTDATAPAGE = 106;
        public static final String MSG_CMD_BASECOMMONPAGES_REQUESTDATAPAGE_PARAM_intREQUESTEDDATAPAGE = "int_requestedDataPage";
        public static final int MSG_EVENT_BASECOMMONPAGES_whatREQUESTFINISHED = 107;
        public static final String MSG_EVENT_BASECOMMONPAGES_REQUESTFINISHED_PARAM_intREQUESTSTATUS = "int_requestStatus";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CommonDataPage {
        MANUFACTURER_IDENTIFICATION(80),
        PRODUCT_INFORMATION(81),
        BATTERY_STATUS(82),
        COMMAND_STATUS(71),
        UNRECOGNIZED(-1);

        private int intValue;

        private CommonDataPage(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static CommonDataPage getValueFromInt(int intValue) {
            for (CommonDataPage source : CommonDataPage.values()) {
                if (source.getIntValue() != intValue) continue;
                return source;
            }
            CommonDataPage unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }
}

