# gpsim.nsi - NSIS installer script for gpsim
#
# Copyright (c) 2004-2013 Borut Razem
#
# This file is part of gpsim.
#
#  This software is provided 'as-is', without any express or implied
#  warranty.  In no event will the authors be held liable for any damages
#  arising from the use of this software.
#
#  Permission is granted to anyone to use this software for any purpose,
#  including commercial applications, and to alter it and redistribute it
#  freely, subject to the following restrictions:
#
#  1. The origin of this software must not be misrepresented; you must not
#     claim that you wrote the original software. If you use this software
#     in a product, an acknowledgment in the product documentation would be
#     appreciated but is not required.
#  2. Altered source versions must be plainly marked as such, and must not be
#     misrepresented as being the original software.
#  3. This notice may not be removed or altered from any source distribution.
#
#  Borut Razem
#  borut.razem@siol.net

; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "gpsim"

; Version
!ifdef VER_MAJOR & VER_MINOR & VER_REVISION & VER_BUILD
  !define PRODUCT_VERSION "${VER_MAJOR}.${VER_MINOR}.${VER_REVISION}"
!else
  !define PRODUCT_VERSION "XX.XX.XX"
!endif

!ifndef PRODUCT_WEB_SITE
  !define PRODUCT_WEB_SITE "http://gpsim.sourceforge.net/gpsim.html"
!endif
!define PRODUCT_PUBLISHER "www.dattalo.com"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\gpsim.bat"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"

!define GPSIM_ROOT "..\.."
!ifndef SETUP_DIR
  !define SETUP_DIR "..\..\..\..\gpsim_snapshots"
!endif
!define PKG_ROOT "${SETUP_DIR}\gpsim_pkg"

SetCompressor /SOLID lzma

;--------------------------------
; Header Files

!include "MUI2.nsh"
!include "WordFunc.nsh"
!include "WinVer.nsh"

;--------------------------------
; Functions

!ifdef VER_MAJOR & VER_MINOR & VER_REVISION & VER_BUILD
  !insertmacro VersionCompare
!endif

;--------------------------------
; Configuration

; MUI Settings
!define MUI_ABORTWARNING
;!define MUI_ICON "${PKG_ROOT}\gpsim.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME

; License page
!insertmacro MUI_PAGE_LICENSE "${GPSIM_ROOT}\COPYING"

; Uninstall/reinstall page
!ifdef VER_MAJOR & VER_MINOR & VER_REVISION & VER_BUILD
Page custom PageReinstall PageLeaveReinstall
!endif

; StartMenu page
!define MUI_STARTMENUPAGE_DEFAULTFOLDER ${PRODUCT_NAME}
!define MUI_STARTMENUPAGE_REGISTRY_ROOT "HKLM"
!define MUI_STARTMENUPAGE_REGISTRY_KEY ${PRODUCT_UNINST_KEY}
!define MUI_STARTMENUPAGE_REGISTRY_VALUENAME "NSIS:StartMenuDir"
!define MUI_STARTMENUPAGE_NODISABLE
Var MUI_STARTMENUPAGE_VARIABLE
!insertmacro MUI_PAGE_STARTMENU Application $MUI_STARTMENUPAGE_VARIABLE

; Components page
!define MUI_COMPONENTSPAGE_SMALLDESC
!insertmacro MUI_PAGE_COMPONENTS

; Directory page
!insertmacro MUI_PAGE_DIRECTORY

; Instfiles page
!insertmacro MUI_PAGE_INSTFILES

; Finish page
!define MUI_FINISHPAGE_RUN "$INSTDIR\gpsim.bat"
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README.TXT"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

!ifndef DATE
  !define DATE "YYYYMMDD"
!endif

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${SETUP_DIR}\gpsim-${PRODUCT_VERSION}-${DATE}-setup.exe"
InstallDir "$PROGRAMFILES\gpsim"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
RequestExecutionLevel admin ;Require admin rights on NT6+ (When UAC is turned on)
;;;;ShowInstDetails show
;;;;ShowUnInstDetails show

!ifndef VER_MAJOR & VER_MINOR & VER_REVISION & VER_BUILD
; Old unistallation method
Function .onInit
  ;Uninstall the old version, if present
  ReadRegStr $R0 HKLM "${PRODUCT_UNINST_KEY}" "UninstallString"
  StrCmp $R0 "" inst

  MessageBox MB_OKCANCEL|MB_ICONEXCLAMATION \
  "${PRODUCT_NAME} is already installed. $\n$\nClick 'OK' to remove the \
  previous version or 'Cancel' to cancel this upgrade." \
  IDOK uninst
  Abort

uninst:
  ; Run the uninstaller
  ClearErrors
  ExecWait '$R0 _?=$INSTDIR' ;Do not copy the uninstaller to a temp file
  Goto done

inst:
  ; Install the new version
  MessageBox MB_YESNO|MB_ICONQUESTION "This will install $(^Name). Do you wish to continue?" IDYES +2
  Abort

done:
FunctionEnd
!endif

InstType "gpsim + extras modules"
InstType "gpsim"

Section "gpim" SEC01
  SectionIn 1 2 RO
  SetOutPath "$INSTDIR\bin"
  SetOverwrite ifnewer
  File "${GPSIM_ROOT}\gpsim\gpsim.exe"
  File "${GPSIM_ROOT}\src\libgpsim.dll"
  File "${GPSIM_ROOT}\modules\libgpsim_modules.dll"
  File "${PKG_ROOT}\bin\freetype6.dll"
  File "${PKG_ROOT}\bin\gtkextra-win32-2.1.dll"
  File "${PKG_ROOT}\bin\iconv.dll"
  File "${PKG_ROOT}\bin\libatk-1.0-0.dll"
  File "${PKG_ROOT}\bin\libcairo-2.dll"
  File "${PKG_ROOT}\bin\libcairo-gobject-2.dll"
  File "${PKG_ROOT}\bin\libcairo-script-interpreter-2.dll"
  File "${PKG_ROOT}\bin\libgailutil-18.dll"
  File "${PKG_ROOT}\bin\libexpat-1.dll"
  File "${PKG_ROOT}\bin\libfontconfig-1.dll"
  File "${PKG_ROOT}\bin\${LIBGCCDDL}"
  File "${PKG_ROOT}\bin\libgdk-win32-2.0-0.dll"
  File "${PKG_ROOT}\bin\libgdk_pixbuf-2.0-0.dll"
  File "${PKG_ROOT}\bin\libgio-2.0-0.dll"
  File "${PKG_ROOT}\bin\libglib-2.0-0.dll"
  File "${PKG_ROOT}\bin\libgmodule-2.0-0.dll"
  File "${PKG_ROOT}\bin\libgobject-2.0-0.dll"
  File "${PKG_ROOT}\bin\libgthread-2.0-0.dll"
  File "${PKG_ROOT}\bin\libgtk-win32-2.0-0.dll"
  File "${PKG_ROOT}\bin\intl.dll"  
  File "${PKG_ROOT}\bin\libpango-1.0-0.dll"
  File "${PKG_ROOT}\bin\libpangocairo-1.0-0.dll"
  File "${PKG_ROOT}\bin\libpangoft2-1.0-0.dll"
  File "${PKG_ROOT}\bin\libpangowin32-1.0-0.dll"
  File "${PKG_ROOT}\bin\libpng14-14.dll"
  File "${PKG_ROOT}\bin\libstdc++-6.dll"
  File "${PKG_ROOT}\bin\libpopt-0.dll"
  File "${PKG_ROOT}\bin\pthreadGC2.dll"
  File "${PKG_ROOT}\bin\libwinpthread-1.dll"
  File "${PKG_ROOT}\bin\readline5.dll"
  File "${PKG_ROOT}\bin\zlib1.dll"

  ; ============================================================================
  ; Windows 2000 support 
  ; ============================================================================
  ${If} ${IsWin2000}
    ; Install the OldCigarettes Windows 2000 XP API Wrapper
    SetOutPath "$INSTDIR\bin"
    File "${PKG_ROOT}\bin\ws2_32.dll"
    CopyFiles "$SYSDIR\ws2_32.dll" "$INSTDIR\bin\ws2_32_org.dll"
  ${EndIf}

  SetOutPath "$INSTDIR\doc"
  File "${GPSIM_ROOT}\doc\gpsim.lyx"
  File "${GPSIM_ROOT}\doc\gpsim.ps"
  File "${GPSIM_ROOT}\doc\gpsim.pdf"

  SetOutPath "$INSTDIR\doc\screenshots"
  File "${GPSIM_ROOT}\doc\screenshots\*.png"

  SetOutPath "$INSTDIR\etc\gtk-2.0"
  File "${PKG_ROOT}\share\themes\MS-Windows\gtk-2.0\gtkrc"

  SetOutPath "$INSTDIR\etc\pango"
  File "${PKG_ROOT}\etc\pango\pango.modules"

  SetOutPath "$INSTDIR\lib\gtk-2.0\2.10.0"
  File /r "${PKG_ROOT}\lib\gtk-2.0\2.10.0\engines"

  SetOutPath "$INSTDIR"
  File /r "${PKG_ROOT}\share"

  SetOutPath "$INSTDIR\lib\gpsim"
  File "${GPSIM_ROOT}\src\libgpsim.a"
  File "${GPSIM_ROOT}\plat\win32\modules.def"

  SetOutPath "$INSTDIR\"
  File "${GPSIM_ROOT}\ChangeLog.txt"
  File "${GPSIM_ROOT}\plat\win32\gpsim.ico"
  File "${GPSIM_ROOT}\COPYING.TXT"
  File "${GPSIM_ROOT}\README.TXT"

  SetOutPath "$INSTDIR\include\gpsim"
  File "${GPSIM_ROOT}\src\*.h"

  SetOutPath "$INSTDIR\examples\12bit"
  File "${GPSIM_ROOT}\examples\12bit\*.asm"
  File "${GPSIM_ROOT}\examples\12bit\*.inc"
  File "${GPSIM_ROOT}\examples\12bit\*.stc"

  SetOutPath "$INSTDIR\examples\14bit"
  File "${GPSIM_ROOT}\examples\14bit\*.asm"
  File "${GPSIM_ROOT}\examples\14bit\*.stc"

  SetOutPath "$INSTDIR\examples\16bit"
  File "${GPSIM_ROOT}\examples\16bit\*.asm"
  File "${GPSIM_ROOT}\examples\16bit\*.inc"

  SetOutPath "$INSTDIR\examples\modules\led_test"
  File "${GPSIM_ROOT}\examples\modules\led_test\README"
  File "${GPSIM_ROOT}\examples\modules\led_test\Makefile"
  File "${GPSIM_ROOT}\examples\modules\led_test\*.asm"
  File "${GPSIM_ROOT}\examples\modules\led_test\*.stc"

  SetOutPath "$INSTDIR\examples\modules\logic_test"
  File "${GPSIM_ROOT}\examples\modules\logic_test\README"
  File "${GPSIM_ROOT}\examples\modules\logic_test\Makefile"
  File "${GPSIM_ROOT}\examples\modules\logic_test\*.asm"
  File "${GPSIM_ROOT}\examples\modules\logic_test\*.stc"

  SetOutPath "$INSTDIR\examples\modules\mod_test"
  File "${GPSIM_ROOT}\examples\modules\mod_test\README"
  File "${GPSIM_ROOT}\examples\modules\mod_test\Makefile"
  File "${GPSIM_ROOT}\examples\modules\mod_test\*.asm"
  File "${GPSIM_ROOT}\examples\modules\mod_test\*.stc"

  SetOutPath "$INSTDIR\examples\modules\paraface_test"
  File "${GPSIM_ROOT}\examples\modules\paraface_test\Makefile"
  File "${GPSIM_ROOT}\examples\modules\paraface_test\*.asm"
  File "${GPSIM_ROOT}\examples\modules\paraface_test\*.stc"

  SetOutPath "$INSTDIR\examples\modules\usart_gui"
  File "${GPSIM_ROOT}\examples\modules\usart_gui\README"
  File "${GPSIM_ROOT}\examples\modules\usart_gui\Makefile"
  File "${GPSIM_ROOT}\examples\modules\usart_gui\*.asm"
  File "${GPSIM_ROOT}\examples\modules\usart_gui\*.stc"

  SetOutPath "$INSTDIR\examples\modules\usart_test"
  File "${GPSIM_ROOT}\examples\modules\usart_test\README"
  File "${GPSIM_ROOT}\examples\modules\usart_test\Makefile"
  File "${GPSIM_ROOT}\examples\modules\usart_test\*.asm"
  File "${GPSIM_ROOT}\examples\modules\usart_test\*.stc"

  SetOutPath "$INSTDIR\examples\projects"
  File "${GPSIM_ROOT}\examples\projects\README"

  SetOutPath "$INSTDIR\examples\projects\digital_stim"
  File "${GPSIM_ROOT}\examples\projects\digital_stim\Makefile"
  File "${GPSIM_ROOT}\examples\projects\digital_stim\ChangeLog"
  File "${GPSIM_ROOT}\examples\projects\digital_stim\README"
  File "${GPSIM_ROOT}\examples\projects\digital_stim\digital_stim.asm"
  File "${GPSIM_ROOT}\examples\projects\digital_stim\digital_stim.stc"

  SetOutPath "$INSTDIR\examples\projects\p16f628_test"
  File "${GPSIM_ROOT}\examples\projects\p16f628_test\ChangeLog"
  File "${GPSIM_ROOT}\examples\projects\p16f628_test\Makefile"
  File "${GPSIM_ROOT}\examples\projects\p16f628_test\README"
  File "${GPSIM_ROOT}\examples\projects\p16f628_test\f628.asm"
  File "${GPSIM_ROOT}\examples\projects\p16f628_test\f628.stc"

  SetOutPath "$INSTDIR\examples\projects\stack_test"
  File "${GPSIM_ROOT}\examples\projects\stack_test\ChangeLog"
  File "${GPSIM_ROOT}\examples\projects\stack_test\Makefile"
  File "${GPSIM_ROOT}\examples\projects\stack_test\README"
  File "${GPSIM_ROOT}\examples\projects\stack_test\stack_test.asm"
  File "${GPSIM_ROOT}\examples\projects\stack_test\stack_test.stc"

  SetOutPath "$INSTDIR\examples\scripts"
  File "${GPSIM_ROOT}\examples\scripts\makefile"
  File "${GPSIM_ROOT}\examples\scripts\README"
  File "${GPSIM_ROOT}\examples\scripts\*.cc"
  File "${GPSIM_ROOT}\examples\scripts\*.h"
  File "${GPSIM_ROOT}\examples\scripts\*.asm"
  File "${GPSIM_ROOT}\examples\scripts\*.py"

  SetOutPath "$INSTDIR\extras\lcd\examples"
  File "${GPSIM_ROOT}\extras\lcd\examples\Makefile.am"
  File "${GPSIM_ROOT}\extras\lcd\examples\README"
  File "${GPSIM_ROOT}\extras\lcd\examples\lcd.asm"
  File "${GPSIM_ROOT}\extras\lcd\examples\lcd.inc"
  File "${GPSIM_ROOT}\extras\lcd\examples\lcd_mod.asm"
  File "${GPSIM_ROOT}\extras\lcd\examples\lcd_mod.stc"
  File "${GPSIM_ROOT}\extras\lcd\examples\lcdmemtest.c"
  File "${GPSIM_ROOT}\extras\lcd\examples\lcdmemtest.stc"
  File "${GPSIM_ROOT}\extras\lcd\examples\p16c64.inc"
  File "${GPSIM_ROOT}\extras\lcd\examples\p16c84.inc"
  File "${GPSIM_ROOT}\extras\lcd\examples\screen.asm"
  File "${GPSIM_ROOT}\extras\lcd\examples\screen.inc"

  SetOutPath "$INSTDIR\extras\graphic_lcd"
  File "${GPSIM_ROOT}\extras\graphic_lcd\AUTHORS"
  File "${GPSIM_ROOT}\extras\graphic_lcd\COPYING"
  File "${GPSIM_ROOT}\extras\graphic_lcd\ChangeLog"
  File "${GPSIM_ROOT}\extras\graphic_lcd\INSTALL"
  File "${GPSIM_ROOT}\extras\graphic_lcd\Makefile.am"
  File "${GPSIM_ROOT}\extras\graphic_lcd\NEWS"
  File "${GPSIM_ROOT}\extras\graphic_lcd\README"

  SetOutPath "$INSTDIR\extras\graphic_lcd\examples\sed1520"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\18f452.lkr"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\Makefile"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\bitmaps.asm"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\glcd_test.asm"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\globalvars.inc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\lcd100X32.asm"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\lcd100X32.inc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\portdef.inc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\processor.inc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\sed1520.asm"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\sed1520\sed1520.inc"

  SetOutPath "$INSTDIR\extras\graphic_lcd\examples\ssd0323"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\18f452.lkr"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\Makefile"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\bitmaps.asm"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\glcd_test.asm"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\globalvars.inc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\osram128x64.asm"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\osram128x64.inc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\portdef.inc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\processor.inc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\ssd0323.asm"
  File "${GPSIM_ROOT}\extras\graphic_lcd\examples\ssd0323\ssd0323.inc"

  SetOutPath "$INSTDIR\extras\graphic_lcd\src"
  File "${GPSIM_ROOT}\extras\graphic_lcd\src\Makefile.am"
  File "${GPSIM_ROOT}\extras\graphic_lcd\src\glcd_100X32_sed1520.cc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\src\glcd_100X32_sed1520.h"
  File "${GPSIM_ROOT}\extras\graphic_lcd\src\gpsim_modules.cc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\src\sed1520.cc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\src\sed1520.h"

  SetOutPath "$INSTDIR\extras\graphic_lcd\utils"
  File "${GPSIM_ROOT}\extras\graphic_lcd\utils\README"
  File "${GPSIM_ROOT}\extras\graphic_lcd\utils\custom.png"
  File "${GPSIM_ROOT}\extras\graphic_lcd\utils\fontimage.png"
  File "${GPSIM_ROOT}\extras\graphic_lcd\utils\gpsim1.png"
  File "${GPSIM_ROOT}\extras\graphic_lcd\utils\konqueror.png"
  File "${GPSIM_ROOT}\extras\graphic_lcd\utils\konqueror16X16.png"
  File "${GPSIM_ROOT}\extras\graphic_lcd\utils\konqueror3.png"
  File "${GPSIM_ROOT}\extras\graphic_lcd\utils\pngtopic.c"

  SetOutPath "$INSTDIR\extras\graphic_lcd\doc"
  File "${GPSIM_ROOT}\extras\graphic_lcd\doc\*.pdf"

  SetOutPath "$INSTDIR\extras\lcd"
  File "${GPSIM_ROOT}\extras\lcd\AUTHORS"
  File "${GPSIM_ROOT}\extras\lcd\COPYING"
  File "${GPSIM_ROOT}\extras\lcd\ChangeLog"
  File "${GPSIM_ROOT}\extras\lcd\INSTALL"
  File "${GPSIM_ROOT}\extras\lcd\Makefile.am"
  File "${GPSIM_ROOT}\extras\lcd\makefile.mingw"
  File "${GPSIM_ROOT}\extras\lcd\NEWS"
  File "${GPSIM_ROOT}\extras\lcd\README"
  File "${GPSIM_ROOT}\extras\lcd\caps.pl"
  File "${GPSIM_ROOT}\extras\lcd\hd44780.cc"
  File "${GPSIM_ROOT}\extras\lcd\hd44780.h"
  File "${GPSIM_ROOT}\extras\lcd\lcd.cc"
  File "${GPSIM_ROOT}\extras\lcd\lcd.gif"
  File "${GPSIM_ROOT}\extras\lcd\lcd.h"
  File "${GPSIM_ROOT}\extras\lcd\lcd.xpm"
  File "${GPSIM_ROOT}\extras\lcd\lcdfont.h"
  File "${GPSIM_ROOT}\extras\lcd\lcdfont.inc"
  File "${GPSIM_ROOT}\extras\lcd\lcdgui.cc"
  File "${GPSIM_ROOT}\extras\lcd\module_manager.cc"
  File "${GPSIM_ROOT}\extras\lcd\t.gif"

  SetOutPath "$INSTDIR\extras\rs232-gen\example"
  File "${GPSIM_ROOT}\extras\rs232-gen\example\Makefile"
  File "${GPSIM_ROOT}\extras\rs232-gen\example\README"
  File "${GPSIM_ROOT}\extras\rs232-gen\example\example.asm"
  File "${GPSIM_ROOT}\extras\rs232-gen\example\example.stc"

  SetOutPath "$INSTDIR\extras\rs232-gen"
  File "${GPSIM_ROOT}\extras\rs232-gen\Makefile"
  File "${GPSIM_ROOT}\extras\rs232-gen\README"
  File "${GPSIM_ROOT}\extras\rs232-gen\rs232-gen.c"

  SetOutPath "$INSTDIR\extras\ds1307\examples"
  File "${GPSIM_ROOT}\extras\ds1307\examples\16f876a.lkr"
  File "${GPSIM_ROOT}\extras\ds1307\examples\ds1307.asm"
  File "${GPSIM_ROOT}\extras\ds1307\examples\i2c_low.inc"
  File "${GPSIM_ROOT}\extras\ds1307\examples\Makefile.am"
  File "${GPSIM_ROOT}\extras\ds1307\examples\README"

  SetOutPath "$INSTDIR\extras\ds1307"
  File "${GPSIM_ROOT}\extras\ds1307\ChangeLog"
  File "${GPSIM_ROOT}\extras\ds1307\ds1307.cc"
  File "${GPSIM_ROOT}\extras\ds1307\ds1307.h"
  File "${GPSIM_ROOT}\extras\ds1307\Makefile.am"
  File "${GPSIM_ROOT}\extras\ds1307\makefile.mingw"
  File "${GPSIM_ROOT}\extras\ds1307\module_manager.cc"  

  SetOutPath "$INSTDIR\extras\ds1820\examples"
  File "${GPSIM_ROOT}\extras\ds1820\examples\16f1823_g.lkr"
  File "${GPSIM_ROOT}\extras\ds1820\examples\ds1820.asm"
  File "${GPSIM_ROOT}\extras\ds1820\examples\ds18b20.asm"
  File "${GPSIM_ROOT}\extras\ds1820\examples\Makefile.am"
  File "${GPSIM_ROOT}\extras\ds1820\examples\README"

  SetOutPath "$INSTDIR\extras\ds1820"
  File "${GPSIM_ROOT}\extras\ds1820\ds1820.cc"
  File "${GPSIM_ROOT}\extras\ds1820\ds1820.h"
  File "${GPSIM_ROOT}\extras\ds1820\rom1w.cc"
  File "${GPSIM_ROOT}\extras\ds1820\rom1w.h"
  File "${GPSIM_ROOT}\extras\ds1820\bit1w.cc"
  File "${GPSIM_ROOT}\extras\ds1820\bit1w.h"
  File "${GPSIM_ROOT}\extras\ds1820\Makefile.am"
  File "${GPSIM_ROOT}\extras\ds1820\makefile.mingw"
  File "${GPSIM_ROOT}\extras\ds1820\module_manager.cc"  

  SetOutPath "$INSTDIR\extras\dht11\examples"
  File "${GPSIM_ROOT}\extras\dht11\examples\16f627_g.lkr"
  File "${GPSIM_ROOT}\extras\dht11\examples\dht11_example.asm"
  File "${GPSIM_ROOT}\extras\dht11\examples\Makefile.am"
  File "${GPSIM_ROOT}\extras\dht11\examples\README"

  SetOutPath "$INSTDIR\extras\dht11"
  File "${GPSIM_ROOT}\extras\dht11\dht11.cc"
  File "${GPSIM_ROOT}\extras\dht11\dht11.h"
  File "${GPSIM_ROOT}\extras\dht11\README"
  File "${GPSIM_ROOT}\extras\dht11\AUTHORS"
  File "${GPSIM_ROOT}\extras\dht11\Makefile.am"
  File "${GPSIM_ROOT}\extras\dht11\makefile.mingw"
  File "${GPSIM_ROOT}\extras\dht11\module_manager.cc"  
SectionEnd

Section "extras modules" SEC02
  SectionIn 1
  SetOutPath "$INSTDIR\bin"
  SetOverwrite ifnewer
  File "${GPSIM_ROOT}\extras\graphic_lcd\src\libgpsim_graphicLCD.dll"
  File "${GPSIM_ROOT}\extras\lcd\libgpsim_lcd.dll"
  File "${GPSIM_ROOT}\extras\ds1307\libgpsim_ds1307.dll"
  File "${GPSIM_ROOT}\extras\ds1820\libgpsim_ds1820.dll"
  File "${GPSIM_ROOT}\extras\dht11\libgpsim_dht11.dll"
SectionEnd

;--------------------------------
;Descriptions

;Language strings
LangString DESC_SEC01 ${LANG_ENGLISH} "gpim"
LangString DESC_SEC02 ${LANG_ENGLISH} "extras modules"

;Assign language strings to sections
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} $(DESC_SEC01)
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} $(DESC_SEC02)
!insertmacro MUI_FUNCTION_DESCRIPTION_END
;--------------------------------

Section -Icons
  Call CreateBatFile
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"

!insertmacro MUI_STARTMENU_WRITE_BEGIN Application
  CreateDirectory "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE"
  CreateShortCut "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\${PRODUCT_NAME}.lnk" "$INSTDIR\${PRODUCT_NAME}.bat" "" "$INSTDIR\gpsim.ico" "" "" "" ""
;  CreateShortCut "$DESKTOP\${PRODUCT_NAME}.lnk" "$INSTDIR\${PRODUCT_NAME}.bat" "" "$INSTDIR\gpsim.ico" "" "" "" ""
  CreateShortCut "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\${PRODUCT_NAME} on the Web.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\Documentation.lnk" "$INSTDIR\doc\gpsim.pdf" "" "$INSTDIR\gpsim.ico" "" "" "" ""
  CreateShortCut "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\Change Log.lnk" "$INSTDIR\ChangeLog.txt" "" "$INSTDIR\gpsim.ico" "" "" "" ""
  CreateShortCut "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\README.lnk" "$INSTDIR\README.TXT" "" "$INSTDIR\gpsim.ico" "" "" "" ""
  CreateShortCut "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\GPL 2 License.lnk" "$INSTDIR\COPYING.TXT"
  CreateShortCut "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\Uninstall.lnk" "$INSTDIR\uninstall.exe"
!insertmacro MUI_STARTMENU_WRITE_END
SectionEnd

Section -Post
  WriteRegStr HKLM "Software\${PRODUCT_NAME}" "" $INSTDIR
!ifdef VER_MAJOR & VER_MINOR & VER_REVISION & VER_BUILD
  WriteRegDword HKLM "Software\${PRODUCT_NAME}" "VersionMajor" "${VER_MAJOR}"
  WriteRegDword HKLM "Software\${PRODUCT_NAME}" "VersionMinor" "${VER_MINOR}"
  WriteRegDword HKLM "Software\${PRODUCT_NAME}" "VersionRevision" "${VER_REVISION}"
  WriteRegDword HKLM "Software\${PRODUCT_NAME}" "VersionBuild" "${VER_BUILD}"
!endif

  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\gpsim.bat"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "Path" "$INSTDIR"

  WriteUninstaller "$INSTDIR\uninstall.exe"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninstall.exe"
;  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\bin\gpsim.exe"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr HKLM "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd

Section Uninstall
  ; Remove StartMenu
  !insertmacro MUI_STARTMENU_GETFOLDER Application $MUI_STARTMENUPAGE_VARIABLE

  Delete "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\${PRODUCT_NAME}.lnk"
  Delete "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\${PRODUCT_NAME} on the Web.lnk"
  Delete "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\Documentation.lnk"
  Delete "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\Change Log.lnk"
  Delete "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\README.lnk"
  Delete "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\GPL 2 License.lnk"
  Delete "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE\Uninstall.lnk"

  RMDir "$SMPROGRAMS\$MUI_STARTMENUPAGE_VARIABLE"

  ; Remove installation directory
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\.gpsim"
  Delete "$INSTDIR\uninstall.exe"
  Delete "$INSTDIR\README.TXT"
  Delete "$INSTDIR\COPYING.TXT"
  Delete "$INSTDIR\gpsim.bat"
  Delete "$INSTDIR\gpsim.ico"
  Delete "$INSTDIR\ChangeLog.txt"

  Delete "$INSTDIR\bin\libgpsim_modules.dll"

  Delete "$INSTDIR\bin\libgpsim_graphicLCD.dll"
  Delete "$INSTDIR\bin\libgpsim_lcd.dll"
  Delete "$INSTDIR\bin\libgpsim_ds1307.dll"
  
  Delete "$INSTDIR\examples\12bit\*.*"
  Delete "$INSTDIR\examples\14bit\*.*"
  Delete "$INSTDIR\examples\16bit\*.*"

  Delete "$INSTDIR\examples\modules\led_test\*.*"
  Delete "$INSTDIR\examples\modules\logic_test\*.*"
  Delete "$INSTDIR\examples\modules\mod_test\*.*"
  Delete "$INSTDIR\examples\modules\paraface_test\*.*"
  Delete "$INSTDIR\examples\modules\usart_gui\*.*"
  Delete "$INSTDIR\examples\modules\usart_test\*.*"

  Delete "$INSTDIR\examples\projects\digital_stim\*.*"
  Delete "$INSTDIR\examples\projects\p16f628_test\*.*"
  Delete "$INSTDIR\examples\projects\stack_test\*.*"
  Delete "$INSTDIR\examples\projects\*.*"
  Delete "$INSTDIR\examples\scripts\*.*"

  Delete "$INSTDIR\extras\graphics_lcd\doc\*.*"
  Delete "$INSTDIR\extras\graphics_lcd\utils\*.*"
  Delete "$INSTDIR\extras\graphics_lcd\src\*.*"
  Delete "$INSTDIR\extras\graphics_lcd\examples\*.*"
  Delete "$INSTDIR\extras\graphics_lcd\*.*"

  Delete "$INSTDIR\extras\lcd\examples\*.*"
  Delete "$INSTDIR\extras\lcd\*.*"
  Delete "$INSTDIR\extras\rs232-gen\example\*.*"
  Delete "$INSTDIR\extras\rs232-gen\*.*"
  Delete "$INSTDIR\extras\ds1307\examples\*.*"
  Delete "$INSTDIR\extras\ds1307\*.*"
  
  Delete "$INSTDIR\extras\dht11\examples\*.*"
  Delete "$INSTDIR\extras\dht11\examples\README"

  Delete "$INSTDIR\extras\dht11\*.*"
  Delete "$INSTDIR\extras\dht11\README"
  Delete "$INSTDIR\extras\dht11\AUTHORS"

  Delete "$INSTDIR\lib\gpsim\libgpsim.a"
  Delete "$INSTDIR\lib\gpsim\modules.def"

  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-arabic-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-basic-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-basic-win32.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-hangul-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-hebrew-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-indic-fc.dll"
  Delete "$INSTDIR\lib\pango\1.5.0\modules\pango-thai-fc.dll"

  Delete "$INSTDIR\etc\pango\pango.modules"
  Delete "$INSTDIR\etc\gtk-2.0\gtkrc"

  Delete "$INSTDIR\doc\gpsim.lyx"
  Delete "$INSTDIR\doc\gpsim.ps"
  Delete "$INSTDIR\doc\gpsim.pdf"
  Delete "$INSTDIR\doc\screenshots\*.png"

  Delete "$INSTDIR\bin\freetype6.dll"
  Delete "$INSTDIR\bin\gpsim.exe"
  Delete "$INSTDIR\bin\gtkextra-win32-2.1.dll"
  Delete "$INSTDIR\bin\iconv.dll"
  Delete "$INSTDIR\bin\libatk-1.0-0.dll"
  Delete "$INSTDIR\bin\libcairo-2.dll"
  Delete "$INSTDIR\bin\libcairo-gobject-2.dll"
  Delete "$INSTDIR\bin\libcairo-script-interpreter-2.dll"
  Delete "$INSTDIR\bin\libgailutil-18.dll"
  Delete "$INSTDIR\bin\libexpat-1.dll"
  Delete "$INSTDIR\bin\libfontconfig-1.dll"
  Delete "$INSTDIR\bin\${LIBGCCDDL}"
  Delete "$INSTDIR\bin\libgdk_pixbuf-2.0-0.dll"
  Delete "$INSTDIR\bin\libgdk-win32-2.0-0.dll"
  Delete "$INSTDIR\bin\libgio-2.0-0.dll"
  Delete "$INSTDIR\bin\libglib-2.0-0.dll"
  Delete "$INSTDIR\bin\libgmodule-2.0-0.dll"
  Delete "$INSTDIR\bin\libgobject-2.0-0.dll"
  Delete "$INSTDIR\bin\libgpsim.dll"
  Delete "$INSTDIR\bin\libgthread-2.0-0.dll"
  Delete "$INSTDIR\bin\libgtk-win32-2.0-0.dll"
  Delete "$INSTDIR\bin\intl.dll"
  Delete "$INSTDIR\bin\libpango-1.0-0.dll"
  Delete "$INSTDIR\bin\libpangocairo-1.0-0.dll"
  Delete "$INSTDIR\bin\libpangoft2-1.0-0.dll"
  Delete "$INSTDIR\bin\libpangowin32-1.0-0.dll"
  Delete "$INSTDIR\bin\libpng14-14.dll"
  Delete "$INSTDIR\bin\libstdc++-6.dll"
  Delete "$INSTDIR\bin\libpopt-0.dll"
  Delete "$INSTDIR\bin\pthreadGC2.dll"
  Delete "$INSTDIR\bin\libwinpthread-1.dll"
  Delete "$INSTDIR\bin\readline5.dll"
  Delete "$INSTDIR\bin\zlib1.dll"

  ; ============================================================================
  ; Windows 2000 support 
  ; ============================================================================
  ${If} ${IsWin2000}
    Delete "$INSTDIR\bin\ws2_32.dll"
    Delete "$INSTDIR\bin\ws2_32_org.dll"
  ${EndIf}

  Delete "$SMPROGRAMS\gpsim\Uninstall.lnk"
  Delete "$SMPROGRAMS\gpsim\Website.lnk"
  Delete "$DESKTOP\gpsim.lnk"
  Delete "$SMPROGRAMS\gpsim\gpsim.lnk"

  Delete "$INSTDIR\include\gpsim\*.h"

  RMDir "$SMPROGRAMS\gpsim"

  RMDir "$INSTDIR\lib\gpsim"
  RMDir "$INSTDIR\lib\pango\1.5.0\modules"
  RMDir "$INSTDIR\lib\pango\1.5.0"
  RMDir "$INSTDIR\lib\pango"
  RMDir /r "$INSTDIR\lib\gtk-2.0\2.10.0\engines"
  RMDir "$INSTDIR\lib\gtk-2.0\2.10.0"
  RMDir "$INSTDIR\lib\gtk-2.0"
  RMDir "$INSTDIR\lib"
  RMDir /r "$INSTDIR\share"
  RMDir "$INSTDIR\etc\pango"
  RMDir "$INSTDIR\etc\gtk-2.0"
  RMDir "$INSTDIR\etc"
  RMDir "$INSTDIR\doc\screenshots"
  RMDir "$INSTDIR\doc"
  RMDir "$INSTDIR\bin"
  RMDir "$INSTDIR\modules"

  RMDir "$INSTDIR\examples\12bit"
  RMDir "$INSTDIR\examples\14bit"
  RMDir "$INSTDIR\examples\16bit"
  RMDir "$INSTDIR\examples\modules\led_test"
  RMDir "$INSTDIR\examples\modules\logic_test"
  RMDir "$INSTDIR\examples\modules\mod_test"
  RMDir "$INSTDIR\examples\modules\paraface_test"
  RMDir "$INSTDIR\examples\modules\usart_gui"
  RMDir "$INSTDIR\examples\modules\usart_test"
  RMDir "$INSTDIR\examples\modules"
  RMDir "$INSTDIR\examples\projects\digital_stim"
  RMDir "$INSTDIR\examples\projects\p16f628_test"
  RMDir "$INSTDIR\examples\projects\stack_test"
  RMDir "$INSTDIR\examples\projects"
  RMDir "$INSTDIR\examples\scripts"
  RMDir "$INSTDIR\examples"

  RMDir /r "$INSTDIR\extras\graphic_lcd"
  RMDir "$INSTDIR\extras\lcd\examples"
  RMDir "$INSTDIR\extras\lcd"
  RMDir "$INSTDIR\extras\rs232-gen\example"
  RMDir "$INSTDIR\extras\rs232-gen"
  RMDir "$INSTDIR\extras\ds1307\examples"
  RMDir "$INSTDIR\extras\ds1307"
  RMDir "$INSTDIR\extras"

  RMDir "$INSTDIR\include\gpsim"
  RMDir "$INSTDIR\include"
  RMDir "$INSTDIR"

  ; Clean the registry
  DeleteRegValue HKLM ${PRODUCT_UNINST_KEY} "NSIS:StartMenuDir"
  DeleteRegKey HKLM "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  DeleteRegKey HKLM "Software\${PRODUCT_NAME}"
;;;;  SetAutoClose true
SectionEnd


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Functions                                                                   ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

!verbose 4

; CreateBatFile - Create gpsim.bat.

Function CreateBatFile
  Push $0

  FileOpen $0 "$INSTDIR\${PRODUCT_NAME}.bat$\r$\n" w
  FileWrite $0 "@echo off$\r$\n"
  FileWrite $0 "set PATH=$INSTDIR\bin;%PATH%$\r$\n"
  FileWrite $0 "$\"$INSTDIR\bin\${PRODUCT_NAME}$\" %1 %2 %3 %4 %5 %6 %7 %8 %9$\r$\n"
  FileClose $0

  Pop $0
FunctionEnd

; Uninstall/Reinstall page

!ifdef VER_MAJOR & VER_MINOR & VER_REVISION & VER_BUILD

Var ReinstallPageCheck

Function PageReinstall

  ReadRegStr $R0 HKLM "Software\${PRODUCT_NAME}" ""

  ${If} $R0 == ""
    ReadRegStr $R0 HKLM "${PRODUCT_UNINST_KEY}" "UninstallString"
    ${If} $R0 == ""
      Abort
    ${EndIf}
  ${EndIf}

  ReadRegDWORD $R0 HKLM "Software\${PRODUCT_NAME}" "VersionMajor"
  ReadRegDWORD $R1 HKLM "Software\${PRODUCT_NAME}" "VersionMinor"
  ReadRegDWORD $R2 HKLM "Software\${PRODUCT_NAME}" "VersionRevision"
  ReadRegDWORD $R3 HKLM "Software\${PRODUCT_NAME}" "VersionBuild"
  StrCpy $R0 $R0.$R1.$R2.$R3

  ${VersionCompare} ${VER_MAJOR}.${VER_MINOR}.${VER_REVISION}.${VER_BUILD} $R0 $R0
  ${If} $R0 == 0
    StrCpy $R1 "${PRODUCT_NAME} ${PRODUCT_VERSION} is already installed. Select the operation you want to perform and click Next to continue."
    StrCpy $R2 "Add/Reinstall components"
    StrCpy $R3 "Uninstall ${PRODUCT_NAME}"
    !insertmacro MUI_HEADER_TEXT "Already Installed" "Choose the maintenance option to perform."
    StrCpy $R0 "2"
  ${ElseIf} $R0 == 1
    StrCpy $R1 "An older version of ${PRODUCT_NAME} is installed on your system. It's recommended that you uninstall the current version before installing. Select the operation you want to perform and click Next to continue."
    StrCpy $R2 "Uninstall before installing"
    StrCpy $R3 "Do not uninstall"
    !insertmacro MUI_HEADER_TEXT "Already Installed" "Choose how you want to install ${PRODUCT_NAME}."
    StrCpy $R0 "1"
  ${ElseIf} $R0 == 2
    StrCpy $R1 "A newer version of ${PRODUCT_NAME} is already installed! It is not recommended that you install an older version. If you really want to install this older version, it's better to uninstall the current version first. Select the operation you want to perform and click Next to continue."
    StrCpy $R2 "Uninstall before installing"
    StrCpy $R3 "Do not uninstall"
    !insertmacro MUI_HEADER_TEXT "Already Installed" "Choose how you want to install ${PRODUCT_NAME}."
    StrCpy $R0 "1"
  ${Else}
    Abort
  ${EndIf}

  nsDialogs::Create /NOUNLOAD 1018

  ${NSD_CreateLabel} 0 0 100% 24u $R1
  Pop $R1

  ${NSD_CreateRadioButton} 30u 50u -30u 8u $R2
  Pop $R2
  ${NSD_OnClick} $R2 PageReinstallUpdateSelection

  ${NSD_CreateRadioButton} 30u 70u -30u 8u $R3
  Pop $R3
  ${NSD_OnClick} $R3 PageReinstallUpdateSelection

  ${If} $ReinstallPageCheck != 2
    SendMessage $R2 ${BM_SETCHECK} ${BST_CHECKED} 0
  ${Else}
    SendMessage $R3 ${BM_SETCHECK} ${BST_CHECKED} 0
  ${EndIf}

  nsDialogs::Show

FunctionEnd

Function PageReinstallUpdateSelection

  Pop $R1

  ${NSD_GetState} $R2 $R1

  ${If} $R1 == ${BST_CHECKED}
    StrCpy $ReinstallPageCheck 1
  ${Else}
    StrCpy $ReinstallPageCheck 2
  ${EndIf}

FunctionEnd

Function PageLeaveReinstall

  ${NSD_GetState} $R2 $R1

  StrCmp $R0 "1" 0 +2
    StrCmp $R1 "1" reinst_uninstall reinst_done

  StrCmp $R0 "2" 0 +3
    StrCmp $R1 "1" reinst_done reinst_uninstall

  reinst_uninstall:
  ReadRegStr $R1 HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}" "UninstallString"

  ;Run uninstaller
  HideWindow

    ClearErrors
    ExecWait '$R1 _?=$INSTDIR'

    IfErrors no_remove_uninstaller
    IfFileExists "$INSTDIR\bin\${PRODUCT_NAME}.exe" no_remove_uninstaller

      Delete $R1
      RMDir $INSTDIR

    no_remove_uninstaller:

  StrCmp $R0 "2" 0 +2
    Quit

  BringToFront

  reinst_done:

FunctionEnd

!endif # VER_MAJOR & VER_MINOR & VER_REVISION & VER_BUILD

