#! /bin/bash

#  This script is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License version 2 as
#  published by the Free Software Foundation.

if [ $# -lt 2 ]
then
	echo "Usage: qbsfe.sh <patchfns> <cmd> [<arg> ...]" >&2
	exit 1
fi

if [ -z "$QUILTRC" ]
then
	for QUILTRC in $HOME/.quiltrc /etc/quilt.quiltrc; do
		[ -e $QUILTRC ] && break
	done
	export QUILTRC
fi

QBSFE_PATCHFNS=$1
shift

# Read in library functions
if ! [ -r $QBSFE_PATCHFNS ]
then
	echo "Cannot read library \"$QBSFE_PATCHFNS\"" >&2
	exit 1
fi
. $QBSFE_PATCHFNS

QBSFE_CMD=$1
shift

$QBSFE_CMD "$@"
