/*
 *  @(#) $Id: splash.c 17711 2015-11-05 10:26:08Z pecold $
 *  Copyright (C) 2004 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

/* XXX: Temporary */
#include <errno.h>
#define GDK_PIXBUF_ENABLE_BACKEND 1

#include "config.h"
#include <stdlib.h>
#include <gtk/gtk.h>
#include <libgwyddion/gwymacros.h>
#include <libgwyddion/gwyutils.h>
#include <libgwyddion/gwyversion.h>
#include <libgwyddion/gwycontainer.h>

static void splash_map(void);

static gboolean in_splash = FALSE;
static GtkWidget *window = NULL;
static GtkWidget *label = NULL;
gchar *message_prefix = NULL;

/* {{{ Digit images */
static const guchar digit_0_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0xef, 0x9f, 0xd1, 0xb8, 0x00, 0x00, 0x02,
  0x49, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0xa5, 0x94, 0xcd, 0x4b, 0x15,
  0x51, 0x18, 0xc6, 0x7f, 0x33, 0x5e, 0xaf, 0xe5, 0x48, 0x5f, 0xb4, 0x10,
  0x6e, 0x52, 0x0a, 0xe5, 0x0d, 0xfa, 0x22, 0x0b, 0x34, 0xa8, 0x8d, 0x7f,
  0x41, 0x86, 0xd1, 0x3a, 0x69, 0x99, 0x86, 0xd4, 0xd6, 0x16, 0x41, 0x1f,
  0x9b, 0x5a, 0xb4, 0x0b, 0xaa, 0x65, 0x51, 0x1a, 0x41, 0x1f, 0x90, 0xe1,
  0xa6, 0x56, 0x15, 0x11, 0x2d, 0xbc, 0xd6, 0x6d, 0x51, 0x96, 0x62, 0x8b,
  0x92, 0x34, 0xb5, 0xdb, 0x35, 0xe7, 0x69, 0x71, 0x6e, 0xc7, 0x77, 0x6e,
  0x57, 0x09, 0x7a, 0x07, 0x66, 0xce, 0xfb, 0x3c, 0xcf, 0x3b, 0x67, 0xe6,
  0x9c, 0xf3, 0x3e, 0xf0, 0x9f, 0x51, 0x4d, 0x37, 0x03, 0x8c, 0x22, 0xc4,
  0x28, 0x03, 0x74, 0x53, 0xbd, 0x9c, 0xbc, 0x8d, 0x3c, 0x2a, 0xbb, 0xf2,
  0xb4, 0x2d, 0x25, 0xef, 0x22, 0x46, 0x4d, 0xba, 0xa4, 0x9c, 0x0a, 0x2a,
  0x28, 0xa7, 0x8b, 0x6a, 0x14, 0x22, 0xa6, 0xab, 0x92, 0xbc, 0x93, 0x38,
  0x50, 0xaf, 0x8a, 0xb2, 0xf1, 0x53, 0x27, 0x14, 0x08, 0x71, 0xb8, 0x5c,
  0xde, 0xc0, 0x1c, 0x3a, 0xab, 0x4a, 0x71, 0x46, 0x88, 0x1f, 0x34, 0x24,
  0x0b, 0xee, 0xa1, 0x43, 0x46, 0xd4, 0xaf, 0x9b, 0x26, 0xeb, 0x10, 0xe2,
  0xbe, 0x95, 0xef, 0x46, 0x75, 0x9a, 0xf0, 0x82, 0xd3, 0x42, 0xa8, 0xcf,
  0xe7, 0xe3, 0x8a, 0x84, 0x68, 0x59, 0x2c, 0xb8, 0x8a, 0x7a, 0x3d, 0x3d,
  0xad, 0x5a, 0x51, 0x64, 0x21, 0xd2, 0x94, 0xc7, 0x7a, 0x84, 0xb8, 0xf6,
  0x47, 0x9e, 0x66, 0x26, 0xd0, 0x88, 0x27, 0x6f, 0x0b, 0xf1, 0x88, 0x41,
  0x74, 0xcb, 0x63, 0x39, 0x05, 0x62, 0x86, 0x1a, 0x08, 0x81, 0x56, 0xa2,
  0x2c, 0x59, 0x3f, 0xdd, 0x33, 0x80, 0xc7, 0x0c, 0xc2, 0x73, 0x8f, 0x6d,
  0x25, 0x0b, 0x11, 0xad, 0xae, 0x60, 0x3f, 0xb4, 0x9b, 0x1f, 0x7a, 0x0b,
  0x30, 0xcc, 0x30, 0xbc, 0x31, 0x68, 0x3b, 0xc0, 0x01, 0x48, 0x01, 0xbb,
  0x60, 0xaf, 0xa1, 0x3e, 0x02, 0x4c, 0x10, 0xc3, 0x27, 0x83, 0xb6, 0x00,
  0xec, 0x74, 0x05, 0x8d, 0xd0, 0x6c, 0xa8, 0xaf, 0x00, 0x9f, 0x59, 0x80,
  0x2f, 0x06, 0x6d, 0xc6, 0x29, 0x53, 0xc0, 0x06, 0xc8, 0x18, 0x6a, 0x1a,
  0xe0, 0x1b, 0x82, 0xef, 0x06, 0xcd, 0xe0, 0x94, 0x00, 0x45, 0x34, 0x67,
  0xb6, 0xa9, 0x46, 0x08, 0x00, 0xa5, 0x0d, 0x3a, 0x2b, 0xc4, 0x3c, 0x04,
  0x80, 0x20, 0x26, 0xf0, 0xef, 0xaa, 0x22, 0x2e, 0xe1, 0x21, 0x0b, 0x1e,
  0x8d, 0xa9, 0x02, 0x08, 0x42, 0x97, 0xca, 0x4c, 0x2e, 0x53, 0xfa, 0x37,
  0x1a, 0x02, 0xf3, 0x50, 0x30, 0x54, 0xca, 0x3d, 0x02, 0x12, 0xbd, 0x53,
  0x70, 0x1f, 0x4f, 0xe8, 0x96, 0x65, 0xd2, 0x50, 0x2b, 0x00, 0x56, 0x52,
  0x5b, 0x1a, 0xd9, 0xb5, 0x9b, 0x74, 0x05, 0x63, 0xc9, 0x15, 0x5f, 0x05,
  0xb0, 0x86, 0x75, 0xb0, 0xd6, 0xa0, 0x63, 0xa5, 0x5b, 0x08, 0xbc, 0x87,
  0xbc, 0xa1, 0xd6, 0x03, 0xd4, 0x53, 0x5f, 0x1a, 0xd9, 0xfd, 0xff, 0xe0,
  0x0a, 0x5e, 0xc1, 0x8b, 0x44, 0x2f, 0x01, 0x19, 0x32, 0xb0, 0xc9, 0xa0,
  0x2f, 0x01, 0x5e, 0xbb, 0x82, 0xa7, 0x30, 0x54, 0xbe, 0xa7, 0xdb, 0xd8,
  0x0e, 0x5b, 0x0c, 0x3a, 0x84, 0x53, 0x3a, 0x6b, 0x99, 0x0a, 0x94, 0x33,
  0xdd, 0x86, 0x18, 0xe2, 0x09, 0x7a, 0xe0, 0xb1, 0x11, 0x7f, 0xbc, 0x5d,
  0x5c, 0x41, 0x3d, 0xa6, 0x81, 0x22, 0xf1, 0x8b, 0x78, 0xb5, 0x0a, 0x1e,
  0xeb, 0x15, 0xe2, 0xfa, 0xe2, 0x7c, 0x3b, 0x50, 0xa4, 0x71, 0x4f, 0xf7,
  0x09, 0xa1, 0x0b, 0x3e, 0x9f, 0x50, 0x9d, 0x10, 0x7b, 0x6c, 0x57, 0xdf,
  0x45, 0x07, 0xcd, 0xc9, 0xb9, 0xa1, 0x3b, 0x26, 0xeb, 0x14, 0xe2, 0x61,
  0xd2, 0x35, 0x32, 0xcc, 0xa2, 0x73, 0x15, 0x6d, 0xe6, 0xbc, 0xb3, 0x99,
  0x8d, 0xe5, 0xce, 0xd4, 0x41, 0x1c, 0xe8, 0x94, 0xe6, 0x13, 0xe2, 0xa2,
  0x4e, 0x3a, 0x23, 0x3b, 0x52, 0xc9, 0xfb, 0x8e, 0x12, 0xa3, 0xcd, 0xba,
  0xac, 0xbc, 0x8a, 0x25, 0xab, 0x6c, 0x72, 0x56, 0x79, 0x6c, 0x29, 0x77,
  0x6d, 0xe5, 0x5d, 0x05, 0x33, 0xde, 0xb7, 0x9c, 0x7f, 0xa7, 0x39, 0x4e,
  0xbf, 0xb1, 0xfb, 0x9e, 0xe5, 0xed, 0xfe, 0x1f, 0xe2, 0x37, 0xff, 0x7b,
  0xeb, 0xa3, 0x89, 0x7b, 0xb2, 0xef, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
  0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
static const guchar digit_1_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0xef, 0x9f, 0xd1, 0xb8, 0x00, 0x00, 0x00,
  0xeb, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0xed, 0x94, 0xbf, 0x0e, 0xc1,
  0x50, 0x14, 0xc6, 0x7f, 0x6d, 0x24, 0xa6, 0xce, 0x4c, 0x36, 0x89, 0x44,
  0x24, 0x06, 0x2c, 0x57, 0x44, 0xe8, 0x68, 0x90, 0x78, 0x02, 0x8b, 0xd7,
  0xf0, 0x0c, 0x9e, 0x81, 0xc1, 0xc6, 0x62, 0x31, 0x09, 0xab, 0x84, 0x87,
  0x60, 0x36, 0x58, 0x44, 0x22, 0xc7, 0xa0, 0x2d, 0xbd, 0xad, 0xb6, 0x06,
  0x26, 0xdf, 0x59, 0x6e, 0x4e, 0xbe, 0xef, 0x7c, 0xe7, 0xfe, 0x39, 0x17,
  0xa2, 0x60, 0x50, 0x64, 0xa0, 0xa7, 0xc2, 0x60, 0xd2, 0xa6, 0x82, 0xa2,
  0x81, 0xa5, 0x73, 0x52, 0x3e, 0xa2, 0x85, 0x4d, 0x93, 0x1a, 0x35, 0xcc,
  0x77, 0xa6, 0x29, 0xc0, 0xa0, 0x80, 0x42, 0xa1, 0xc8, 0xbb, 0xc9, 0x92,
  0x93, 0xc8, 0x85, 0x8a, 0xa6, 0xc8, 0x23, 0x2c, 0xb1, 0x65, 0x28, 0x4b,
  0x39, 0x8b, 0x0b, 0x04, 0x09, 0x3a, 0xa4, 0xa1, 0x45, 0x17, 0x45, 0xf9,
  0x7d, 0x27, 0x3e, 0xcc, 0x90, 0xb9, 0x84, 0x23, 0xe8, 0xa0, 0x95, 0xbc,
  0xb0, 0x8a, 0xa9, 0xee, 0x9c, 0xd2, 0x89, 0x05, 0x1b, 0x36, 0x6c, 0xb9,
  0xea, 0x25, 0xc3, 0x05, 0x7d, 0x92, 0xc2, 0x6d, 0xe9, 0xc6, 0x9a, 0x11,
  0x76, 0x32, 0x51, 0x8f, 0xba, 0x77, 0x81, 0x42, 0xcc, 0xa6, 0xf5, 0xa7,
  0x21, 0xf8, 0x18, 0x46, 0x80, 0x63, 0xf2, 0x21, 0xfe, 0x82, 0xbf, 0x20,
  0x62, 0x1e, 0x2a, 0x64, 0x23, 0x39, 0x1d, 0x6f, 0x75, 0x60, 0xef, 0xcc,
  0xf4, 0x6b, 0x04, 0x9e, 0xf7, 0x33, 0xc6, 0xde, 0xc4, 0x55, 0xc9, 0xc4,
  0x14, 0x3f, 0xb2, 0x4b, 0xf2, 0x6b, 0x3c, 0x31, 0x71, 0x1c, 0x7e, 0x73,
  0x4a, 0x40, 0xf7, 0x7b, 0x0e, 0x1f, 0xe3, 0x0e, 0x71, 0xf1, 0x9a, 0xf3,
  0x12, 0xb7, 0xa5, 0x71, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44,
  0xae, 0x42, 0x60, 0x82
};
static const guchar digit_2_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0xef, 0x9f, 0xd1, 0xb8, 0x00, 0x00, 0x01,
  0xf5, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0xb5, 0x94, 0x4f, 0x48, 0x15,
  0x51, 0x14, 0xc6, 0x7f, 0xf3, 0x66, 0xc6, 0xf7, 0x06, 0xdf, 0x26, 0xa8,
  0x08, 0x74, 0xa3, 0x54, 0x24, 0x11, 0x11, 0x68, 0x8b, 0x20, 0x02, 0x21,
  0xa2, 0xc0, 0x8d, 0xad, 0x2c, 0x28, 0xa2, 0x48, 0x5a, 0xb4, 0x09, 0xc2,
  0x4d, 0x9b, 0x22, 0xc4, 0x08, 0x97, 0x8f, 0x16, 0x22, 0x46, 0x11, 0x26,
  0xb4, 0x51, 0x12, 0x5c, 0x88, 0x98, 0x8b, 0x20, 0x2c, 0x78, 0xed, 0x42,
  0x68, 0x21, 0x58, 0xd0, 0x1f, 0x2a, 0x1b, 0x23, 0x33, 0x7d, 0x5f, 0x8b,
  0x99, 0x77, 0xbd, 0xd9, 0x1d, 0xe3, 0x2d, 0xfc, 0xee, 0x62, 0xee, 0xc0,
  0xef, 0x3b, 0xe7, 0xdc, 0x7b, 0xee, 0xbd, 0x50, 0xa3, 0x3c, 0x6b, 0x1e,
  0x72, 0x8a, 0x76, 0xf6, 0xd3, 0x44, 0x33, 0x00, 0x15, 0x5e, 0x51, 0x66,
  0x8c, 0x71, 0xb4, 0xd1, 0x16, 0x71, 0x86, 0x49, 0x2a, 0xc8, 0x39, 0xbe,
  0x70, 0x75, 0x3d, 0xb0, 0x07, 0x44, 0xc4, 0xf8, 0xe0, 0xd3, 0x4a, 0x3b,
  0x87, 0x69, 0xa1, 0x81, 0x7a, 0x7e, 0xf3, 0x99, 0x37, 0xcc, 0x30, 0xcc,
  0x1c, 0xc0, 0x34, 0x1d, 0x2c, 0x55, 0x4d, 0x45, 0x14, 0xaa, 0xa4, 0x0f,
  0x72, 0xeb, 0xb1, 0x76, 0x0a, 0x51, 0x26, 0x6f, 0x19, 0x8a, 0xda, 0x4c,
  0xf3, 0x6a, 0x12, 0xe2, 0x5e, 0xb5, 0xa4, 0x22, 0x71, 0x91, 0x38, 0x75,
  0xc7, 0xbc, 0xe6, 0x3d, 0x11, 0x87, 0x68, 0xb4, 0x16, 0x59, 0xa6, 0x8d,
  0xd5, 0x0a, 0xcd, 0xcc, 0x5b, 0x19, 0xbe, 0xa9, 0xa4, 0xa3, 0x0a, 0xd2,
  0xa5, 0xe6, 0x74, 0x41, 0xab, 0x56, 0x96, 0x73, 0x42, 0xf4, 0x99, 0x92,
  0x0a, 0xba, 0xa2, 0xfa, 0x04, 0x5d, 0xe3, 0x19, 0x0f, 0x19, 0xe1, 0x3b,
  0xea, 0xb5, 0x0c, 0x13, 0x42, 0xbc, 0x30, 0x86, 0x74, 0x4c, 0xd3, 0x45,
  0x21, 0xad, 0xe2, 0x18, 0x6a, 0xb1, 0x0c, 0x1f, 0x85, 0xf8, 0xb1, 0x6e,
  0x58, 0x66, 0x80, 0xbd, 0x1b, 0x5a, 0xaa, 0xbc, 0x65, 0x58, 0x4b, 0x42,
  0xa6, 0x6d, 0xbb, 0xcb, 0x8e, 0x7f, 0xce, 0x40, 0x88, 0x22, 0xcb, 0xb0,
  0x24, 0x44, 0x65, 0xb3, 0x43, 0x73, 0x04, 0x1d, 0xb0, 0x0c, 0xb3, 0x42,
  0xbc, 0x85, 0x5c, 0xa6, 0xe1, 0x26, 0x74, 0x5a, 0xbf, 0xa3, 0x00, 0x53,
  0xd9, 0xf1, 0x6f, 0xa3, 0x5d, 0xfa, 0x6a, 0xe2, 0x2f, 0x6a, 0xbb, 0x10,
  0x27, 0xb2, 0xf0, 0x6e, 0x54, 0xa7, 0x29, 0xab, 0xa0, 0x8b, 0x42, 0x3c,
  0xcf, 0xc2, 0x7b, 0x90, 0xaf, 0x47, 0x16, 0x5e, 0x92, 0x27, 0x7e, 0xb1,
  0xdb, 0x8d, 0xdf, 0x40, 0xbe, 0x1e, 0x58, 0xf8, 0xa0, 0x7c, 0x21, 0xce,
  0xbb, 0xf1, 0x3e, 0x14, 0x68, 0xd8, 0xc2, 0x7b, 0xe5, 0x09, 0xd1, 0xed,
  0xc6, 0xfb, 0x51, 0x9d, 0x9e, 0x18, 0x78, 0x59, 0x67, 0x93, 0xdd, 0xbf,
  0xe4, 0xbe, 0xac, 0x43, 0x28, 0xaf, 0x51, 0x83, 0xbf, 0x53, 0x9b, 0x10,
  0x31, 0xc7, 0xdd, 0xd1, 0xef, 0xa0, 0x82, 0x9e, 0x1a, 0xbc, 0xac, 0x86,
  0xa4, 0x55, 0x7b, 0xdc, 0xf8, 0x69, 0x14, 0x6a, 0xcc, 0xc2, 0xb7, 0x09,
  0x31, 0x49, 0xe4, 0xc6, 0x0f, 0xb2, 0xe2, 0x69, 0xc0, 0xe0, 0x9f, 0xd4,
  0x28, 0xc4, 0xfd, 0xbf, 0xde, 0x94, 0x54, 0x01, 0x10, 0x30, 0x42, 0x78,
  0xd9, 0x5a, 0xd9, 0x35, 0x16, 0x60, 0x85, 0x39, 0x7a, 0x1c, 0xbb, 0x08,
  0xdc, 0x42, 0xfb, 0xf4, 0xd3, 0xc4, 0x5f, 0x48, 0xf6, 0xdd, 0x3d, 0x08,
  0x80, 0x93, 0xd0, 0x6f, 0xee, 0x0d, 0x2c, 0x72, 0x3d, 0xa3, 0x45, 0x55,
  0xcd, 0xa2, 0x97, 0xfa, 0xbf, 0x92, 0x0c, 0xb9, 0x5a, 0xdf, 0xd6, 0xad,
  0x37, 0x04, 0xc9, 0xa7, 0x75, 0xeb, 0x32, 0xd4, 0xac, 0x3f, 0x18, 0x25,
  0xe5, 0xc7, 0x9c, 0x6c, 0x67, 0x4b, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
  0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
static const guchar digit_3_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0x1e, 0x94, 0x8a, 0x35, 0x00, 0x00, 0x02,
  0x62, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0x9d, 0x94, 0x4d, 0x48, 0x94,
  0x41, 0x18, 0xc7, 0x7f, 0xbb, 0x2a, 0x26, 0x66, 0x69, 0x4a, 0x1f, 0x9a,
  0xf8, 0x41, 0x7a, 0x28, 0x13, 0x2a, 0xb7, 0x2e, 0x65, 0x11, 0x0b, 0x09,
  0x21, 0xd6, 0x25, 0x04, 0x23, 0x2a, 0x22, 0x04, 0x85, 0xea, 0x56, 0x44,
  0x11, 0x5d, 0x3c, 0x44, 0x50, 0x89, 0xe0, 0x2d, 0x68, 0xc3, 0x0e, 0x1d,
  0x42, 0x94, 0xa2, 0x53, 0x07, 0x31, 0x72, 0x35, 0x0b, 0x8c, 0xec, 0x43,
  0xd8, 0xa2, 0xd8, 0x24, 0xd2, 0x36, 0xc9, 0x74, 0xd7, 0xb5, 0x7f, 0x87,
  0xf7, 0x75, 0x9c, 0xdd, 0x5c, 0xa1, 0x9e, 0xf7, 0xf0, 0x0e, 0x33, 0xff,
  0xe7, 0x37, 0xf3, 0x7c, 0xcc, 0xc0, 0x3f, 0x99, 0xc7, 0xfd, 0x67, 0xd3,
  0x44, 0x05, 0xe5, 0xf8, 0xd8, 0xe8, 0xce, 0x85, 0x09, 0xd3, 0x4b, 0x0f,
  0xc3, 0xc9, 0x2e, 0x7b, 0xe9, 0x62, 0x06, 0xa5, 0xf8, 0x06, 0x29, 0x4b,
  0x94, 0x87, 0x90, 0x57, 0x35, 0xba, 0xa0, 0x07, 0x7a, 0xad, 0xef, 0x8a,
  0x6b, 0x5e, 0x11, 0xbd, 0x52, 0x97, 0x8e, 0x6b, 0xa5, 0x10, 0x71, 0x4e,
  0x27, 0xc9, 0x07, 0xb4, 0xb4, 0x4d, 0xaa, 0x45, 0x1e, 0x21, 0x9a, 0x12,
  0xe4, 0x1f, 0x94, 0xda, 0x6e, 0x08, 0xf1, 0x93, 0x35, 0x00, 0xe9, 0x8b,
  0x5e, 0x73, 0x3c, 0x67, 0x94, 0x09, 0xb2, 0xa8, 0xa2, 0xd6, 0xe4, 0x00,
  0xce, 0xf0, 0x98, 0x47, 0xd9, 0x9c, 0xe5, 0xb2, 0xa1, 0xf7, 0xea, 0x94,
  0x56, 0x5b, 0x01, 0x56, 0x2b, 0x6c, 0xf1, 0x1f, 0x3a, 0x21, 0xbb, 0x89,
  0x0c, 0x51, 0xea, 0x41, 0x00, 0x23, 0xf4, 0x31, 0x45, 0x06, 0xf5, 0x54,
  0x36, 0x72, 0xcf, 0xf0, 0x27, 0xc9, 0x87, 0x18, 0x99, 0x86, 0x4e, 0x94,
  0x8b, 0xac, 0x32, 0xeb, 0x6b, 0x51, 0xbe, 0x45, 0x9f, 0x77, 0xf6, 0x74,
  0xed, 0x1d, 0x9d, 0x14, 0x25, 0xd5, 0x42, 0x99, 0x96, 0x3c, 0x2c, 0x44,
  0x74, 0x61, 0x69, 0xfd, 0x5f, 0xb5, 0xde, 0x89, 0x2a, 0x2c, 0xf9, 0x1d,
  0x21, 0xfa, 0x17, 0x32, 0x33, 0x0e, 0x6c, 0x66, 0x03, 0x1e, 0xbc, 0xe4,
  0xb2, 0x89, 0x2a, 0x8e, 0xc0, 0x51, 0xe3, 0x1b, 0xa5, 0x0d, 0x20, 0x60,
  0xf3, 0x02, 0x76, 0xe1, 0xd3, 0xd5, 0xac, 0x98, 0x4b, 0x8e, 0xea, 0xb0,
  0x10, 0x9f, 0xc9, 0x4e, 0xca, 0x7b, 0x35, 0x25, 0xe4, 0x50, 0x48, 0x15,
  0x7e, 0x13, 0xca, 0x00, 0xcd, 0xbc, 0x84, 0x08, 0xfb, 0x99, 0x4e, 0xa2,
  0xdf, 0x4d, 0xa8, 0x65, 0x4c, 0xdd, 0xaa, 0x73, 0x1a, 0x20, 0xc6, 0xb6,
  0x05, 0x99, 0x37, 0x55, 0x67, 0xcf, 0x02, 0xc5, 0xe4, 0x01, 0x64, 0x70,
  0x85, 0x15, 0x89, 0xab, 0x01, 0xd4, 0xae, 0x2f, 0x8a, 0x28, 0x9e, 0xb0,
  0xc7, 0x8c, 0x6e, 0x39, 0xd5, 0x1e, 0x4e, 0x74, 0x08, 0x2c, 0x86, 0x59,
  0xaa, 0x46, 0x75, 0x5b, 0x2e, 0x63, 0x2a, 0x13, 0xb2, 0x8a, 0x0c, 0xdc,
  0xe4, 0x93, 0xfb, 0xcd, 0x3a, 0x6e, 0x0d, 0x26, 0x37, 0xd2, 0xa8, 0xb2,
  0x84, 0xd8, 0xb1, 0xf4, 0xb1, 0xcb, 0x39, 0xc6, 0x38, 0xba, 0x66, 0xed,
  0x70, 0x4e, 0x88, 0xce, 0xd4, 0x77, 0x78, 0x1f, 0xda, 0x6e, 0xc9, 0x83,
  0x42, 0x84, 0x96, 0xbb, 0xf2, 0xca, 0xb1, 0xe4, 0xd3, 0x6e, 0x93, 0x79,
  0xd9, 0x45, 0x07, 0xb5, 0x4b, 0x25, 0x34, 0x6e, 0x8d, 0x33, 0xcd, 0xc8,
  0x8f, 0x10, 0x93, 0x5c, 0x62, 0x37, 0x69, 0x66, 0xf6, 0x00, 0xda, 0x6a,
  0xd1, 0x3f, 0x0a, 0x31, 0xe1, 0x36, 0x81, 0x07, 0xe5, 0x71, 0x15, 0x98,
  0xe7, 0x05, 0x7d, 0x44, 0x29, 0xa1, 0x01, 0x4e, 0x5a, 0xf4, 0x27, 0x00,
  0x43, 0x2e, 0xdd, 0xaf, 0xa0, 0xce, 0x6b, 0x8b, 0x53, 0x72, 0x21, 0x94,
  0xa6, 0x56, 0xfd, 0xb6, 0xe8, 0x35, 0x42, 0xb4, 0x9a, 0x16, 0xf3, 0xe1,
  0xa3, 0x8d, 0xaf, 0x04, 0x09, 0x31, 0xc7, 0x3a, 0x6a, 0x29, 0xb6, 0xd8,
  0xd7, 0x19, 0x82, 0x08, 0xb7, 0x0d, 0x7d, 0x39, 0x6b, 0x97, 0x57, 0x88,
  0x7a, 0x13, 0x6a, 0x6a, 0xf9, 0x88, 0x0e, 0x3a, 0xc7, 0x6b, 0x71, 0xc4,
  0xe9, 0x00, 0xfd, 0xd4, 0xe1, 0xa3, 0x9a, 0x0a, 0x8a, 0xc8, 0x25, 0x83,
  0x18, 0xdf, 0x78, 0xcf, 0x33, 0x7a, 0x78, 0x8a, 0x60, 0x9a, 0x13, 0xdc,
  0x5f, 0xbc, 0x15, 0x6f, 0x53, 0x3e, 0xa7, 0xe2, 0x17, 0x1d, 0x14, 0x26,
  0x3f, 0xd8, 0x59, 0x1c, 0x62, 0x0f, 0x45, 0x14, 0x50, 0x49, 0x01, 0x00,
  0x3f, 0x78, 0xc3, 0x20, 0x41, 0xba, 0x99, 0xe2, 0xff, 0xed, 0x0f, 0xb0,
  0x94, 0x25, 0x75, 0x81, 0x02, 0x16, 0x02, 0x00, 0x00, 0x00, 0x00, 0x49,
  0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
static const guchar digit_4_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0xeb, 0x6a, 0x01, 0x85, 0x00, 0x00, 0x01,
  0x19, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0xd5, 0xd4, 0x4d, 0x2b, 0x44,
  0x61, 0x18, 0x87, 0xf1, 0xeb, 0x19, 0x76, 0x83, 0x61, 0x6f, 0x61, 0x61,
  0x23, 0x91, 0x44, 0xd9, 0xc8, 0xca, 0x17, 0xb0, 0x9f, 0xa4, 0x44, 0x52,
  0xbe, 0x80, 0x8d, 0x6f, 0x61, 0x4a, 0x36, 0xa4, 0x59, 0x90, 0x7c, 0x04,
  0x6b, 0x6b, 0x11, 0x79, 0xd9, 0x5a, 0xd9, 0x30, 0x0d, 0x9a, 0xba, 0x6c,
  0x9e, 0xc2, 0x8c, 0x39, 0x2f, 0x68, 0xca, 0x7d, 0x36, 0xa7, 0xfe, 0xf7,
  0xaf, 0xa7, 0xee, 0xe7, 0xdc, 0x07, 0xfe, 0xb8, 0x76, 0xb0, 0xe9, 0x49,
  0xad, 0x72, 0x0b, 0x49, 0x45, 0x23, 0x3c, 0xe3, 0xae, 0x1f, 0x95, 0x8e,
  0x8a, 0x9c, 0xe3, 0xa2, 0xe6, 0x42, 0xfb, 0x38, 0x6a, 0x2d, 0x17, 0x5a,
  0xc2, 0xa2, 0x17, 0x9a, 0x03, 0x8d, 0x51, 0x0b, 0xee, 0x69, 0x0e, 0xd4,
  0xc3, 0x25, 0x2e, 0xc7, 0xc6, 0xb3, 0x8c, 0xa8, 0x8a, 0xe3, 0xd6, 0x55,
  0x7d, 0x72, 0x38, 0x13, 0x5a, 0xc1, 0x5e, 0xaf, 0x62, 0x5b, 0x59, 0x32,
  0xa0, 0x09, 0xea, 0xc1, 0x6a, 0x6c, 0x3a, 0x30, 0x64, 0x40, 0x7d, 0x5c,
  0xe3, 0x5a, 0x6c, 0xb9, 0xb3, 0x24, 0x19, 0xd0, 0x21, 0x4e, 0xfa, 0xaa,
  0x6a, 0xc3, 0x99, 0xf8, 0xe1, 0x24, 0xa3, 0x75, 0x2c, 0x79, 0x13, 0x1b,
  0x36, 0x45, 0x1e, 0xd2, 0xd0, 0x14, 0x2f, 0xc1, 0xa3, 0x18, 0x9f, 0xda,
  0x25, 0x0d, 0x66, 0x93, 0x51, 0x3f, 0xb7, 0xb8, 0x11, 0xc3, 0x47, 0x07,
  0x45, 0xb6, 0x20, 0x09, 0x05, 0x8e, 0x71, 0xda, 0xb7, 0x18, 0x2e, 0x7c,
  0x59, 0x86, 0x26, 0x24, 0xb2, 0x0d, 0x30, 0x8f, 0x03, 0xde, 0xc7, 0xa8,
  0xd2, 0xb4, 0x41, 0xdf, 0xa3, 0x02, 0x45, 0x98, 0x63, 0x28, 0x1e, 0xbb,
  0xda, 0x76, 0xeb, 0x44, 0x2a, 0xf1, 0xbd, 0xf0, 0x93, 0xff, 0x40, 0xe7,
  0x50, 0x37, 0xc0, 0x09, 0xa1, 0x4d, 0xec, 0xa7, 0x21, 0xff, 0xf2, 0xa4,
  0x90, 0x90, 0xd9, 0x72, 0x52, 0xf8, 0x17, 0xd3, 0xeb, 0xf0, 0x3d, 0xe5,
  0x1d, 0x6e, 0x81, 0x4e, 0xd5, 0x3b, 0xea, 0x9f, 0xa8, 0x7d, 0xcf, 0x59,
  0x03, 0x97, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42,
  0x60, 0x82
};
static const guchar digit_5_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0xf1, 0x56, 0xe1, 0x0b, 0x00, 0x00, 0x01,
  0xd1, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0xb5, 0x94, 0xc1, 0x4b, 0x54,
  0x51, 0x14, 0xc6, 0x7f, 0x4e, 0x19, 0xce, 0xcc, 0xc6, 0x4a, 0xb2, 0x70,
  0xa3, 0x68, 0x8b, 0x16, 0x0e, 0x08, 0xd2, 0x42, 0x70, 0x53, 0x03, 0x06,
  0xce, 0x26, 0x30, 0x08, 0x41, 0x08, 0x6c, 0x31, 0x0b, 0x77, 0xfe, 0x09,
  0xb6, 0x98, 0x4d, 0xeb, 0x20, 0x21, 0xac, 0x04, 0x15, 0x05, 0x15, 0x12,
  0xa4, 0xd5, 0x58, 0x38, 0x43, 0x69, 0x0b, 0x09, 0x1c, 0x24, 0x24, 0x25,
  0x67, 0x21, 0xf3, 0x10, 0x26, 0xb4, 0x34, 0x1c, 0xbf, 0x16, 0x97, 0x79,
  0x73, 0x47, 0xdf, 0x83, 0x37, 0x41, 0xe7, 0xad, 0xce, 0xe3, 0x77, 0xbe,
  0x77, 0xce, 0xfd, 0xce, 0x7d, 0x50, 0x63, 0x24, 0x51, 0x80, 0x67, 0x04,
  0x42, 0xb5, 0xa8, 0x86, 0x82, 0x88, 0x8f, 0x54, 0xc3, 0x35, 0x29, 0xff,
  0x07, 0xf8, 0x72, 0x75, 0x9a, 0xe3, 0x8d, 0x07, 0x94, 0xf5, 0x86, 0x37,
  0x48, 0x05, 0x57, 0x3e, 0x02, 0xf8, 0xcc, 0xbc, 0x07, 0x99, 0xb9, 0x00,
  0x1f, 0x9a, 0xaf, 0xa6, 0x02, 0x29, 0x1f, 0x02, 0xf4, 0x73, 0xca, 0x36,
  0x19, 0x36, 0x82, 0xc0, 0x1d, 0x8c, 0x02, 0xf0, 0x9d, 0x97, 0xbc, 0xa0,
  0x78, 0x61, 0x37, 0x92, 0x32, 0xb1, 0xad, 0x65, 0x4d, 0xea, 0x99, 0x1e,
  0xa9, 0xc9, 0x98, 0x77, 0x40, 0xd2, 0x17, 0xae, 0x44, 0x49, 0xef, 0xd4,
  0x63, 0x0a, 0xa6, 0xca, 0x6e, 0x84, 0xfc, 0xdd, 0xea, 0x67, 0x95, 0x57,
  0x44, 0xe1, 0x31, 0x6f, 0xcd, 0xbb, 0x4b, 0x40, 0x37, 0x89, 0x9b, 0x88,
  0x8f, 0x7c, 0xe5, 0x07, 0x61, 0x1a, 0xad, 0x92, 0x2e, 0xee, 0x31, 0xc3,
  0x9f, 0x4e, 0x0a, 0xac, 0x79, 0xae, 0x5c, 0x4c, 0xd3, 0x55, 0x0d, 0x4d,
  0x0a, 0xe1, 0x10, 0x2d, 0x2b, 0xf7, 0xf1, 0x85, 0x34, 0x69, 0xb2, 0xec,
  0xd2, 0xbc, 0x1f, 0x9d, 0xa3, 0xc8, 0x03, 0x57, 0x3d, 0xc6, 0x32, 0xf9,
  0x08, 0x7b, 0xac, 0x03, 0x84, 0xcf, 0xb5, 0x3b, 0xc0, 0x31, 0x5a, 0xb2,
  0xb4, 0xc7, 0x85, 0x58, 0xf0, 0x9b, 0xee, 0x29, 0x4a, 0x58, 0xf0, 0x96,
  0x10, 0x79, 0x3f, 0x38, 0x8c, 0x9a, 0x2d, 0xf8, 0xc4, 0x4c, 0x43, 0x9d,
  0x0f, 0xae, 0x2b, 0x9c, 0xb8, 0x49, 0xc9, 0x18, 0x5d, 0x17, 0x02, 0x16,
  0x79, 0x78, 0xee, 0xbc, 0x5b, 0xe0, 0x86, 0x95, 0xee, 0x03, 0x65, 0xdb,
  0x0b, 0x88, 0x3c, 0xc3, 0xd6, 0x9e, 0x8c, 0xa3, 0x21, 0xab, 0x8d, 0x05,
  0x21, 0x3e, 0x54, 0x60, 0x21, 0x4e, 0xc9, 0xf2, 0x9c, 0x14, 0x19, 0x14,
  0xd1, 0xa6, 0x05, 0x0f, 0x0a, 0x31, 0xe6, 0xc2, 0x13, 0x4a, 0xa8, 0xde,
  0xb5, 0xe5, 0x96, 0xde, 0x5b, 0x68, 0x4e, 0xf5, 0xe2, 0x8c, 0x56, 0x33,
  0x60, 0x81, 0x26, 0x87, 0xeb, 0xfc, 0x64, 0x95, 0x6f, 0x88, 0x76, 0xe2,
  0x34, 0xb8, 0x1d, 0x1d, 0xd3, 0xcb, 0x3a, 0xbc, 0xe6, 0x89, 0xab, 0xec,
  0xc8, 0x3b, 0x8a, 0x8a, 0x0b, 0xb1, 0x53, 0xa9, 0xf6, 0x85, 0x17, 0xd5,
  0x26, 0xc4, 0x2f, 0x3a, 0xab, 0x6e, 0xca, 0x00, 0x77, 0x89, 0x71, 0x87,
  0x56, 0xae, 0x52, 0xc2, 0x61, 0x8b, 0x15, 0xa6, 0xc9, 0x99, 0x0b, 0x1f,
  0xc7, 0xa9, 0x1c, 0xe3, 0x8a, 0xef, 0x4f, 0xee, 0x37, 0xa3, 0xb6, 0x03,
  0xc6, 0xc1, 0x08, 0xf7, 0xb9, 0x4d, 0x37, 0x1d, 0xb4, 0x73, 0x0d, 0x38,
  0x60, 0x97, 0x4f, 0xcc, 0x92, 0xe6, 0x8c, 0x7f, 0x8d, 0xbf, 0x6e, 0x65,
  0x71, 0xf9, 0xa3, 0xc8, 0x3c, 0x61, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
  0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
static const guchar digit_6_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x1a, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0xeb, 0x6a, 0x01, 0x85, 0x00, 0x00, 0x02,
  0xa6, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0xa5, 0x94, 0x4b, 0x48, 0x94,
  0x51, 0x18, 0x86, 0x9f, 0xf1, 0x32, 0x2a, 0xde, 0x0b, 0xa9, 0x46, 0x85,
  0x8a, 0xa8, 0x85, 0x54, 0x6a, 0x65, 0x25, 0x2d, 0x14, 0x5d, 0x44, 0x60,
  0x82, 0x10, 0x11, 0x51, 0xd0, 0xa2, 0xdc, 0x68, 0xb4, 0x28, 0x82, 0xa8,
  0x45, 0x9b, 0xa4, 0x4d, 0x44, 0x04, 0x5d, 0xa0, 0xab, 0x41, 0x41, 0x58,
  0x2e, 0x4c, 0xb0, 0xa8, 0xb4, 0x40, 0x53, 0x69, 0x91, 0x97, 0x85, 0x0d,
  0xa5, 0x4d, 0x2e, 0x64, 0xbc, 0x96, 0x9a, 0x3a, 0x39, 0xbe, 0x2d, 0x7e,
  0xe7, 0xf7, 0x38, 0xfe, 0x15, 0xd4, 0xf7, 0xaf, 0xce, 0x79, 0xcf, 0x73,
  0xbe, 0xff, 0xbc, 0xe7, 0x3b, 0x1f, 0xfc, 0x43, 0xb8, 0x1c, 0x67, 0x77,
  0x50, 0x42, 0x0e, 0x9b, 0xf1, 0x00, 0x30, 0x88, 0x97, 0x1e, 0x9a, 0x69,
  0xa3, 0x13, 0x39, 0x2d, 0x8f, 0xa0, 0x92, 0x5e, 0xf4, 0x9b, 0x2f, 0x40,
  0x29, 0x40, 0xd4, 0x22, 0x64, 0x1d, 0x0d, 0xac, 0x05, 0x0f, 0xfb, 0x28,
  0x24, 0x0b, 0x0f, 0x71, 0x4c, 0xe1, 0xe7, 0x13, 0x9d, 0xb4, 0xf3, 0x82,
  0xc1, 0x68, 0x32, 0xc3, 0xb3, 0xe4, 0xf1, 0x1d, 0x79, 0x74, 0x57, 0x41,
  0x39, 0x45, 0x85, 0x10, 0x15, 0x8b, 0x33, 0xe5, 0xf2, 0x16, 0x77, 0x09,
  0xd5, 0x24, 0xff, 0xd5, 0x88, 0x10, 0x94, 0x42, 0x3d, 0xee, 0x83, 0x54,
  0x1b, 0xce, 0x78, 0x69, 0x66, 0x88, 0x44, 0x36, 0xb0, 0x95, 0x78, 0x47,
  0xe8, 0x2a, 0x2b, 0x76, 0x72, 0xc7, 0x46, 0xbc, 0x94, 0xd3, 0x68, 0x5b,
  0xe5, 0x26, 0x9f, 0x52, 0xfc, 0x61, 0xf9, 0x36, 0x31, 0x17, 0x2b, 0xaf,
  0xfd, 0xf7, 0x9d, 0x5a, 0x26, 0xc4, 0x30, 0xf7, 0xa9, 0xe2, 0x0a, 0x6d,
  0x04, 0x6d, 0xff, 0x2a, 0x16, 0xa0, 0xc7, 0xe8, 0x84, 0x8d, 0x04, 0xb4,
  0x5e, 0x88, 0x27, 0x24, 0xd8, 0x7a, 0x24, 0x65, 0x3c, 0x64, 0xda, 0x84,
  0x92, 0x08, 0x44, 0xca, 0x67, 0x43, 0xb7, 0x84, 0xe8, 0x08, 0xbb, 0x0c,
  0x80, 0x58, 0x0e, 0x50, 0x14, 0x1a, 0x1c, 0x44, 0x05, 0x86, 0xb5, 0xc5,
  0x42, 0xbc, 0xa2, 0x85, 0x31, 0x84, 0xe8, 0xa7, 0x8e, 0xe3, 0x61, 0x4e,
  0x00, 0xb7, 0xd1, 0x45, 0x03, 0x4a, 0x70, 0xaa, 0x85, 0x20, 0x17, 0x16,
  0xe7, 0x6e, 0x47, 0x4d, 0x36, 0xe2, 0x13, 0x8a, 0xd6, 0x21, 0xd5, 0x69,
  0x40, 0x41, 0x4d, 0xcb, 0xab, 0x6a, 0xed, 0x96, 0x4b, 0x88, 0x36, 0x12,
  0x17, 0xa0, 0x6f, 0x68, 0xd0, 0x86, 0x3a, 0x94, 0xa3, 0xee, 0x25, 0xd5,
  0xd0, 0xa8, 0x0c, 0x21, 0xde, 0x13, 0x6d, 0x21, 0xc9, 0x28, 0xc6, 0x90,
  0xc7, 0xf5, 0xc3, 0xb1, 0x88, 0x7c, 0x4a, 0x17, 0xe2, 0xac, 0x05, 0xa5,
  0xa3, 0xb4, 0xb0, 0x05, 0x01, 0x9d, 0x53, 0xa6, 0xe2, 0x94, 0xaf, 0x77,
  0xc6, 0xec, 0x73, 0xb9, 0xc4, 0x34, 0x29, 0x00, 0x19, 0x28, 0x3d, 0x0c,
  0xda, 0x6f, 0x1b, 0x90, 0xa4, 0x2f, 0xc6, 0x7c, 0x81, 0x10, 0xe5, 0x00,
  0x9e, 0xf0, 0x4c, 0xaf, 0x85, 0x18, 0x25, 0x9b, 0x68, 0x1e, 0xa1, 0x53,
  0x86, 0x72, 0x53, 0x88, 0x5a, 0x80, 0x78, 0xe4, 0x5e, 0x04, 0x1d, 0x13,
  0xe2, 0x34, 0x00, 0xdb, 0x51, 0xae, 0xa1, 0x74, 0x0b, 0xf1, 0xd9, 0x3a,
  0xd5, 0x08, 0xf2, 0x1b, 0x52, 0x9e, 0x10, 0xb9, 0x00, 0xc4, 0xa0, 0x14,
  0x43, 0x99, 0x10, 0x62, 0x16, 0x22, 0x80, 0x5e, 0xe8, 0x31, 0xae, 0x6d,
  0xd4, 0xda, 0x08, 0x60, 0x06, 0x26, 0x0c, 0x25, 0xce, 0xaa, 0x43, 0x22,
  0x80, 0x0f, 0xd0, 0x6a, 0x48, 0x31, 0xc0, 0xfc, 0x7d, 0xb8, 0xc0, 0x6d,
  0x28, 0x93, 0x00, 0x3f, 0x2d, 0xe8, 0x25, 0x34, 0x18, 0xd2, 0x1a, 0x80,
  0x6c, 0x00, 0x56, 0xc3, 0x4a, 0x43, 0xe9, 0x03, 0xf0, 0x59, 0x50, 0x03,
  0x73, 0x8d, 0x0c, 0xd8, 0x52, 0x11, 0xc0, 0x51, 0x00, 0x8a, 0x99, 0x3f,
  0x9c, 0x15, 0xad, 0x00, 0x5d, 0xa1, 0x51, 0x2d, 0x3a, 0x63, 0x1f, 0x77,
  0x4c, 0x69, 0x42, 0x3c, 0xe3, 0x12, 0x63, 0xe8, 0xa9, 0x61, 0xc4, 0x1e,
  0x21, 0x2a, 0x43, 0x50, 0x36, 0x8a, 0x57, 0x9f, 0x2d, 0x36, 0x59, 0x2f,
  0x57, 0xe8, 0x88, 0x81, 0x74, 0x29, 0x52, 0x04, 0x48, 0x5d, 0xc8, 0x5c,
  0x83, 0xf2, 0x35, 0x63, 0x2f, 0x18, 0xd1, 0x3d, 0x5d, 0xd6, 0x1b, 0x03,
  0x99, 0xd5, 0x2e, 0x21, 0x6e, 0x98, 0xcf, 0x23, 0x89, 0xaf, 0x68, 0xaf,
  0xa6, 0xe4, 0x1c, 0x41, 0x1d, 0x16, 0xc2, 0x4f, 0x52, 0x78, 0x73, 0x99,
  0x40, 0x1b, 0xd5, 0xe2, 0x80, 0x7c, 0xb4, 0xaa, 0x6e, 0x92, 0x2d, 0x4b,
  0x7b, 0x60, 0x16, 0xc3, 0xc8, 0xa5, 0x42, 0x5d, 0x53, 0x87, 0xc6, 0x35,
  0xa7, 0x29, 0xf5, 0xe8, 0x81, 0xca, 0x14, 0x25, 0xc4, 0x10, 0xdb, 0x9c,
  0x5b, 0x67, 0x2c, 0x55, 0x4c, 0x38, 0x3c, 0xf6, 0x59, 0xae, 0xb3, 0xfc,
  0x4f, 0x3d, 0x37, 0x95, 0xf3, 0xd4, 0xd3, 0xcf, 0x1c, 0x42, 0xf4, 0x51,
  0xc3, 0x49, 0x56, 0xf1, 0xff, 0xf1, 0x0b, 0xd2, 0x23, 0xab, 0x79, 0xf7,
  0x46, 0x72, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae,
  0x42, 0x60, 0x82
};
static const guchar digit_7_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0xef, 0x9f, 0xd1, 0xb8, 0x00, 0x00, 0x01,
  0x8d, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0xb5, 0x94, 0xb1, 0x4b, 0x55,
  0x51, 0x1c, 0xc7, 0x3f, 0xef, 0xe2, 0xab, 0x37, 0x89, 0x5b, 0x46, 0x82,
  0xfa, 0x30, 0x9c, 0x6a, 0xca, 0x41, 0xb0, 0x46, 0x9b, 0x04, 0xd1, 0xa5,
  0xa1, 0xa2, 0xa1, 0xad, 0x20, 0x1c, 0x8c, 0x88, 0xfe, 0x85, 0x08, 0x0a,
  0x0a, 0x0b, 0x6c, 0x88, 0xa0, 0x31, 0xa4, 0xa1, 0xa0, 0xa9, 0x21, 0xa1,
  0xd1, 0xa2, 0x24, 0x92, 0x82, 0x1e, 0x14, 0x08, 0x3a, 0xf8, 0xca, 0xf0,
  0x3d, 0xfc, 0x34, 0x78, 0xba, 0xdd, 0xc1, 0xfb, 0xe3, 0x19, 0xf6, 0xbb,
  0x70, 0x2f, 0x9c, 0xfb, 0xf9, 0x7c, 0xcf, 0x3d, 0xe7, 0xdc, 0x73, 0xe0,
  0x1f, 0xea, 0x03, 0x76, 0x7c, 0xf5, 0x65, 0x7b, 0x4d, 0x4f, 0xc2, 0x72,
  0x27, 0xe1, 0x45, 0x61, 0xcf, 0x3d, 0xfc, 0x47, 0xa1, 0x6b, 0xe7, 0xf1,
  0x98, 0x43, 0x25, 0xc0, 0x69, 0x86, 0x00, 0x68, 0xb1, 0xd9, 0xc9, 0xb4,
  0xd6, 0xdd, 0x74, 0xa7, 0x66, 0x45, 0xbe, 0x52, 0xeb, 0x2a, 0x8d, 0xef,
  0x63, 0xb2, 0xc2, 0x5d, 0x6a, 0x00, 0xbc, 0xe2, 0x26, 0xb4, 0x98, 0xe6,
  0x57, 0xf9, 0xc7, 0x3e, 0xc7, 0x33, 0x29, 0xbd, 0x69, 0x5d, 0xe4, 0x5a,
  0x34, 0xb6, 0x29, 0xec, 0xf1, 0x7b, 0x12, 0x2e, 0x8b, 0x2c, 0x46, 0x13,
  0xd4, 0x4d, 0x03, 0xef, 0x25, 0xfc, 0xb5, 0x99, 0xfc, 0x64, 0x38, 0xca,
  0xbf, 0x8d, 0xa3, 0x09, 0x6f, 0x7b, 0x5c, 0xe4, 0x7a, 0x84, 0x8f, 0xd0,
  0xae, 0xfa, 0x36, 0x09, 0xb7, 0x44, 0x3e, 0x72, 0x30, 0x5a, 0x99, 0x25,
  0xbc, 0x9a, 0xf0, 0x55, 0x7b, 0x44, 0x4e, 0x45, 0xf9, 0x33, 0xd8, 0xef,
  0x8f, 0x24, 0x5c, 0x12, 0x79, 0x1a, 0xe1, 0xbd, 0x34, 0x71, 0x21, 0xe1,
  0x2b, 0x1e, 0x90, 0x16, 0xfd, 0x91, 0xf0, 0x08, 0x27, 0xfc, 0x53, 0x17,
  0x44, 0xee, 0x44, 0xf8, 0x09, 0xb6, 0x6b, 0xae, 0x24, 0xfc, 0x8b, 0x55,
  0xd9, 0x2a, 0xfd, 0xc9, 0x80, 0x8c, 0x37, 0x78, 0x23, 0xcf, 0xbf, 0x22,
  0x32, 0x1f, 0xe5, 0x9f, 0xc5, 0xc3, 0x36, 0x13, 0xbe, 0x61, 0xb7, 0x6c,
  0x47, 0xcb, 0x95, 0xf1, 0x19, 0x1f, 0xe4, 0xf9, 0xf7, 0x45, 0x5e, 0x44,
  0xf9, 0xe7, 0x71, 0xc8, 0x76, 0x2e, 0x8c, 0x89, 0x4c, 0x96, 0xe3, 0x15,
  0xde, 0xe1, 0xc3, 0x1c, 0x6f, 0x98, 0xc9, 0x3a, 0xd5, 0x72, 0x61, 0x1c,
  0x7b, 0xdd, 0xca, 0x85, 0x39, 0x91, 0x27, 0xd1, 0x9e, 0x3e, 0x07, 0x17,
  0x0b, 0x81, 0x2f, 0xf3, 0x5b, 0xd9, 0x80, 0xd7, 0x2a, 0xbe, 0xf7, 0x6f,
  0x1d, 0x11, 0x19, 0x28, 0x17, 0x46, 0x71, 0xb0, 0x80, 0xaf, 0x5a, 0x91,
  0x46, 0x74, 0xcc, 0x8c, 0xc0, 0xc9, 0x42, 0xe3, 0x27, 0x84, 0xe5, 0x48,
  0x38, 0x0a, 0xc7, 0x0a, 0x8d, 0xdf, 0x00, 0xd6, 0xa2, 0x35, 0x78, 0xb6,
  0xcb, 0x11, 0x33, 0x1f, 0xf5, 0x50, 0xdf, 0xe5, 0xcd, 0x06, 0xfb, 0x53,
  0xbf, 0x01, 0xeb, 0x22, 0x5e, 0xc4, 0x4d, 0x09, 0xac, 0x25, 0x00, 0x00,
  0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
static const guchar digit_8_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x5d, 0xba, 0x86, 0x00, 0x00, 0x02,
  0x69, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0xa5, 0x95, 0x49, 0x6c, 0x4d,
  0x61, 0x18, 0x86, 0x9f, 0xde, 0x72, 0xab, 0x31, 0x25, 0x6a, 0x88, 0x50,
  0x89, 0x10, 0x2c, 0x10, 0x0b, 0xba, 0x90, 0x88, 0x29, 0x62, 0x25, 0x36,
  0x34, 0xb1, 0x32, 0x6c, 0x44, 0x2c, 0x44, 0x1a, 0x5d, 0x18, 0x1a, 0x29,
  0x62, 0x4a, 0x6c, 0xb0, 0x12, 0xa5, 0xa2, 0xd1, 0x85, 0x2d, 0x41, 0x90,
  0x18, 0xd3, 0x50, 0x09, 0x42, 0x10, 0x34, 0xc4, 0x3c, 0x84, 0x1a, 0xab,
  0xd3, 0x7d, 0x2c, 0xce, 0xbd, 0xa7, 0xff, 0xb9, 0xb7, 0x6c, 0xfa, 0xdd,
  0xcd, 0x3d, 0xef, 0xf7, 0x3d, 0xe7, 0xfb, 0xcf, 0xf7, 0xbf, 0xe7, 0x3f,
  0xd0, 0xe7, 0x48, 0xb3, 0x86, 0x8b, 0xb4, 0x90, 0x41, 0xe4, 0x13, 0x4d,
  0x54, 0x33, 0xf2, 0x7f, 0xc0, 0x12, 0xbe, 0x60, 0xc1, 0xaf, 0x8b, 0xdd,
  0xa4, 0x7a, 0x07, 0x36, 0x20, 0x8e, 0xb3, 0xd6, 0x6b, 0x7e, 0xb4, 0xd3,
  0x36, 0x9f, 0x58, 0xef, 0x22, 0x8b, 0x44, 0x9a, 0x18, 0x54, 0x08, 0x54,
  0x62, 0xca, 0x6d, 0x76, 0x99, 0x1f, 0xe7, 0x1d, 0x2e, 0xd2, 0x98, 0x0f,
  0x0c, 0xe1, 0x1b, 0xee, 0xb7, 0xf7, 0x68, 0xb6, 0x44, 0x64, 0x5a, 0xc1,
  0xa2, 0x2a, 0x82, 0xa2, 0x0b, 0x1e, 0xf0, 0x52, 0x70, 0xbd, 0x51, 0xe4,
  0x64, 0x12, 0x69, 0xc2, 0xfa, 0xb8, 0x60, 0x7b, 0xf6, 0xc1, 0x0f, 0xc5,
  0xca, 0x1d, 0x91, 0x0f, 0x49, 0xe4, 0x37, 0xbe, 0x88, 0x0b, 0x46, 0x89,
  0x1c, 0xc7, 0x29, 0xb1, 0xd2, 0x16, 0xdd, 0x24, 0x11, 0x62, 0x7b, 0x5c,
  0xd0, 0x4f, 0x24, 0x8d, 0xe9, 0x58, 0xe9, 0x08, 0x90, 0xdc, 0xbc, 0x33,
  0x21, 0x3f, 0x19, 0x60, 0x39, 0xf4, 0x8b, 0x95, 0x67, 0x00, 0xef, 0x93,
  0x5d, 0x5e, 0xe1, 0xc3, 0xf8, 0x9e, 0x27, 0x44, 0x3a, 0x70, 0x56, 0xac,
  0xec, 0x12, 0x39, 0x95, 0x44, 0x1a, 0xb1, 0x26, 0x98, 0xd0, 0x3a, 0x11,
  0x0f, 0x66, 0xaf, 0x3e, 0x45, 0x3b, 0xb3, 0x24, 0x89, 0xcc, 0xc6, 0x81,
  0x41, 0x9f, 0x8c, 0x6b, 0x9d, 0x6d, 0xa7, 0xaa, 0x7f, 0x9c, 0x27, 0x72,
  0x93, 0xa2, 0xfc, 0xcd, 0x6c, 0xc0, 0xb1, 0x3e, 0x0e, 0x3a, 0xfd, 0x50,
  0xf5, 0xab, 0xf3, 0x45, 0x5a, 0x29, 0x2f, 0x34, 0xcc, 0x40, 0x9e, 0xe2,
  0x30, 0xcf, 0x25, 0xf6, 0xfd, 0xb5, 0xe3, 0xa3, 0x59, 0x55, 0xf5, 0x66,
  0xca, 0x15, 0x74, 0xe1, 0x04, 0x2f, 0xe7, 0x99, 0xe5, 0x9a, 0x33, 0x22,
  0x68, 0x17, 0xc5, 0x49, 0x60, 0x35, 0xe2, 0x4a, 0x7f, 0x65, 0x0b, 0x5b,
  0x03, 0xa8, 0xcb, 0x3d, 0xa6, 0x45, 0xae, 0x06, 0x53, 0x67, 0x21, 0x99,
  0x22, 0xf7, 0xc5, 0x45, 0x8d, 0x8e, 0xf0, 0x46, 0xa2, 0xd7, 0xcd, 0x68,
  0x66, 0x75, 0x3d, 0x4f, 0xf1, 0x19, 0xb7, 0xc7, 0xe9, 0xf7, 0x0e, 0x15,
  0x07, 0x78, 0x3a, 0x01, 0xdd, 0x8e, 0xdc, 0x5c, 0x11, 0x21, 0x1b, 0x71,
  0xa6, 0x99, 0x38, 0xb9, 0x45, 0xe4, 0x0d, 0x16, 0x5b, 0x97, 0x80, 0xaa,
  0x45, 0xea, 0x23, 0xe4, 0x0a, 0x36, 0x04, 0xa9, 0xe9, 0x22, 0x73, 0xd8,
  0x81, 0xc5, 0x5e, 0x08, 0xf4, 0xfb, 0x22, 0xef, 0x22, 0xe4, 0x17, 0xbe,
  0x0e, 0x52, 0xa5, 0x22, 0x03, 0x80, 0xaa, 0xd0, 0x32, 0xda, 0x1e, 0x58,
  0x53, 0x12, 0xaf, 0x6f, 0xff, 0x5c, 0x22, 0x8d, 0x25, 0x81, 0x9e, 0x73,
  0x73, 0x0a, 0xe8, 0x86, 0xf6, 0x60, 0xde, 0xa3, 0x01, 0x26, 0x01, 0x83,
  0xa1, 0x34, 0xd0, 0x5f, 0x66, 0xdd, 0x9c, 0x02, 0x9e, 0xc3, 0xa3, 0x20,
  0xb5, 0x18, 0xe0, 0x14, 0x5b, 0x39, 0x03, 0x0b, 0x02, 0xfd, 0x22, 0xc0,
  0xad, 0xe8, 0xff, 0x51, 0xdc, 0x1c, 0x2c, 0xe0, 0x6d, 0xce, 0x24, 0x96,
  0xdb, 0x12, 0xab, 0xdd, 0x4e, 0x15, 0x59, 0x15, 0x21, 0x15, 0x38, 0xd4,
  0x37, 0x01, 0xf4, 0xd3, 0x7a, 0x6b, 0xad, 0xf3, 0x7b, 0xa0, 0xed, 0x14,
  0x79, 0x4b, 0x3a, 0xd7, 0xf3, 0x0c, 0x56, 0x24, 0x4c, 0x92, 0x1f, 0x87,
  0x4d, 0x49, 0x37, 0x73, 0x7b, 0x96, 0x59, 0xc6, 0x2b, 0x9c, 0x98, 0x38,
  0x86, 0x7a, 0xe2, 0x85, 0x95, 0xd1, 0x42, 0x37, 0x25, 0x6d, 0x39, 0x86,
  0x7b, 0x88, 0x33, 0xdd, 0xeb, 0x75, 0x3f, 0xd8, 0x69, 0xc6, 0x56, 0xef,
  0x7a, 0xc4, 0xa5, 0xd1, 0xd0, 0xbb, 0x59, 0x59, 0x68, 0xfe, 0x62, 0x6a,
  0xf8, 0xdd, 0xcb, 0x21, 0x2e, 0x19, 0x1a, 0x18, 0xf3, 0xaf, 0x93, 0x3f,
  0xc5, 0x32, 0x8e, 0xd1, 0x9c, 0xfd, 0x54, 0xb4, 0xf2, 0x80, 0xb3, 0xac,
  0xa7, 0xac, 0xcf, 0x9f, 0xa0, 0xbf, 0x4d, 0x42, 0x16, 0x17, 0x9d, 0xa6,
  0xa3, 0xfa, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42,
  0x60, 0x82
};
static const guchar digit_9_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x5d, 0xba, 0x86, 0x00, 0x00, 0x02,
  0x79, 0x49, 0x44, 0x41, 0x54, 0x38, 0xcb, 0xa5, 0x95, 0x5f, 0x68, 0x8d,
  0x61, 0x1c, 0xc7, 0x3f, 0xe7, 0x98, 0xad, 0x6d, 0x42, 0x2d, 0xa1, 0x65,
  0x12, 0xb1, 0x30, 0x16, 0x99, 0xac, 0xb8, 0xa3, 0x91, 0xe1, 0x82, 0xdc,
  0xac, 0x84, 0x5d, 0x28, 0x47, 0x8a, 0x2b, 0x71, 0xa5, 0x64, 0x25, 0xca,
  0x8a, 0xcc, 0x8d, 0xa2, 0xa6, 0x5d, 0xe0, 0x82, 0x72, 0x21, 0xb5, 0x8b,
  0xe5, 0x6f, 0xfe, 0xcb, 0x85, 0x68, 0xc3, 0x34, 0x8c, 0xc9, 0x59, 0xcc,
  0x19, 0x67, 0x1f, 0x17, 0xe7, 0xdf, 0x73, 0xce, 0xc6, 0x8d, 0xdf, 0x5b,
  0xef, 0xfb, 0xbc, 0xdf, 0xe7, 0xf7, 0x79, 0xde, 0xe7, 0xf7, 0xfc, 0x9e,
  0xdf, 0xf3, 0xc2, 0x7f, 0xdb, 0x3c, 0x8e, 0x73, 0x8f, 0xcf, 0x88, 0xf4,
  0x71, 0x83, 0x63, 0x54, 0xff, 0xcb, 0xbd, 0x8a, 0x9b, 0x38, 0xc6, 0x75,
  0x95, 0x69, 0x63, 0x03, 0xab, 0xf9, 0x81, 0x13, 0xdd, 0xed, 0x75, 0xdf,
  0xfb, 0xcb, 0x84, 0x6f, 0xbc, 0xec, 0x36, 0x4b, 0x45, 0x12, 0xac, 0x1f,
  0x0d, 0x6c, 0x62, 0x04, 0x9b, 0xfc, 0x62, 0xa1, 0xf5, 0xba, 0x51, 0x24,
  0xc9, 0xda, 0x7c, 0xa0, 0x82, 0x38, 0x1e, 0xf4, 0x6f, 0xb6, 0x5f, 0x64,
  0x90, 0xaa, 0x10, 0x69, 0xc7, 0x0d, 0x81, 0xcb, 0xb0, 0x97, 0x6c, 0xf5,
  0x61, 0xa0, 0x6c, 0x15, 0xb9, 0x93, 0x03, 0x66, 0x30, 0x52, 0x6c, 0x4f,
  0x00, 0xac, 0x14, 0x31, 0x62, 0x4b, 0x56, 0x1b, 0xb0, 0x42, 0x64, 0x5d,
  0x06, 0xd9, 0x87, 0x9b, 0x83, 0x11, 0xdb, 0x44, 0xba, 0x39, 0xc9, 0xcf,
  0xa8, 0x0f, 0xb2, 0x6a, 0x8b, 0xc8, 0xcd, 0x0c, 0x72, 0x15, 0xcf, 0x07,
  0x48, 0x83, 0xc8, 0x66, 0xe0, 0x30, 0xee, 0xca, 0xaa, 0x5f, 0x2c, 0x96,
  0x24, 0x15, 0x29, 0xe4, 0x35, 0xbe, 0x08, 0x90, 0x4a, 0x91, 0x4a, 0x60,
  0x11, 0x2e, 0x08, 0xf4, 0x35, 0x22, 0x4d, 0x29, 0x64, 0x18, 0xbf, 0x07,
  0x5d, 0x25, 0x22, 0x11, 0xa0, 0x08, 0x27, 0x04, 0xfa, 0x11, 0x91, 0x33,
  0x10, 0x05, 0xc6, 0x43, 0x69, 0xb0, 0x7c, 0xbf, 0x01, 0x4c, 0x35, 0x12,
  0x81, 0x5e, 0x0b, 0x50, 0x9d, 0x42, 0x80, 0x78, 0xd0, 0x55, 0x06, 0x50,
  0x02, 0x4c, 0x84, 0xc9, 0x81, 0x3e, 0x07, 0x60, 0x66, 0x0a, 0x19, 0x80,
  0x0f, 0x41, 0xd7, 0x4c, 0x80, 0xf9, 0xc0, 0x2a, 0x58, 0x18, 0xe8, 0x53,
  0xd3, 0xb7, 0x28, 0xf0, 0x9c, 0x30, 0x4b, 0xd4, 0x03, 0x34, 0x51, 0xce,
  0x21, 0xd8, 0x58, 0xf8, 0xf5, 0xd2, 0x6c, 0x5e, 0x1a, 0x83, 0x30, 0x1f,
  0x59, 0x94, 0xde, 0xc3, 0xb3, 0xf3, 0x96, 0x25, 0x99, 0x52, 0x01, 0x98,
  0xc6, 0xef, 0xa8, 0xcf, 0x82, 0xce, 0x8b, 0xce, 0xb2, 0xcc, 0x06, 0xbb,
  0xf3, 0x76, 0xda, 0xf7, 0xd4, 0xf6, 0x4c, 0xdb, 0x69, 0x5c, 0x9c, 0x37,
  0x62, 0xc6, 0xfa, 0x83, 0xf6, 0x1b, 0x91, 0xfe, 0x0c, 0x52, 0x4e, 0x0f,
  0x2e, 0xb7, 0xb7, 0x00, 0x78, 0x62, 0x4d, 0xf0, 0xd6, 0x25, 0x72, 0x3f,
  0x17, 0x5b, 0x35, 0x71, 0x2c, 0x73, 0xaf, 0x9d, 0x7e, 0x32, 0xe9, 0x37,
  0x3b, 0x6d, 0xb6, 0xd8, 0xa9, 0x01, 0x72, 0x56, 0xa4, 0x23, 0x2c, 0x80,
  0xe9, 0x5c, 0x19, 0x5d, 0xc4, 0xf5, 0x01, 0xb2, 0x43, 0xe4, 0x40, 0x61,
  0x6d, 0xd6, 0x72, 0x9a, 0xc7, 0x0c, 0x21, 0x43, 0x3c, 0xe3, 0x05, 0xee,
  0x09, 0x90, 0x2a, 0x91, 0xba, 0x8c, 0xeb, 0x5a, 0x9a, 0x29, 0x2f, 0xc0,
  0x8b, 0x78, 0x89, 0x9d, 0xf9, 0x91, 0x7c, 0xcc, 0xec, 0x16, 0x88, 0x21,
  0x3f, 0x69, 0xa7, 0x91, 0x48, 0x16, 0xb8, 0x80, 0x75, 0x85, 0x75, 0x79,
  0x22, 0x37, 0x62, 0x2c, 0x3b, 0xfb, 0x61, 0xae, 0xd1, 0x42, 0x2b, 0xaf,
  0x70, 0x52, 0x90, 0xab, 0x47, 0x8e, 0x93, 0x44, 0x78, 0x38, 0xc5, 0x70,
  0x8b, 0x47, 0x5d, 0x62, 0x24, 0x1b, 0x78, 0x4d, 0x50, 0xfb, 0xbf, 0x5c,
  0x2a, 0x72, 0x2a, 0x9c, 0x77, 0x0c, 0x63, 0xaa, 0xf6, 0x79, 0xc9, 0xe3,
  0xb6, 0x79, 0x3b, 0x2f, 0x3f, 0x3b, 0x45, 0xde, 0xe5, 0x55, 0x48, 0x0e,
  0x19, 0x6d, 0x09, 0xb7, 0xa7, 0x0e, 0xbf, 0xda, 0x8c, 0x73, 0xf4, 0xdf,
  0x47, 0x74, 0x17, 0x75, 0x9c, 0x83, 0x11, 0xb6, 0xf0, 0x38, 0xb7, 0x94,
  0x69, 0xeb, 0x20, 0xce, 0x72, 0x16, 0x31, 0x9b, 0x29, 0x44, 0x89, 0xf3,
  0x8a, 0x2e, 0x3a, 0xb8, 0x8b, 0xd0, 0x47, 0x03, 0x4f, 0x0b, 0x07, 0x6b,
  0x24, 0x31, 0xe6, 0x01, 0x2e, 0x5f, 0xd9, 0xcb, 0xf8, 0x7c, 0xe7, 0x48,
  0xf6, 0x59, 0xc3, 0x32, 0x56, 0x50, 0xcd, 0x5c, 0xa6, 0x00, 0xf2, 0x96,
  0x87, 0xdc, 0xa2, 0x8d, 0xc1, 0xff, 0xff, 0x03, 0xf1, 0x07, 0x0e, 0x56,
  0xb9, 0x3c, 0x2f, 0x52, 0x38, 0xff, 0x00, 0x00, 0x00, 0x00, 0x49, 0x45,
  0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
static const guchar digit_dot_png[] = {
  0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
  0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x22,
  0x08, 0x04, 0x00, 0x00, 0x00, 0xc1, 0xda, 0xf0, 0x2a, 0x00, 0x00, 0x00,
  0x3d, 0x49, 0x44, 0x41, 0x54, 0x28, 0xcf, 0x63, 0x60, 0x18, 0x05, 0xa3,
  0x80, 0x10, 0x60, 0x64, 0x60, 0x60, 0xd0, 0xc0, 0x22, 0x7e, 0x83, 0x91,
  0x81, 0x81, 0xe1, 0x3f, 0x36, 0x0d, 0x2c, 0x10, 0x1a, 0x59, 0xd3, 0x0d,
  0xb8, 0x51, 0xff, 0x51, 0x35, 0x31, 0x32, 0x30, 0x30, 0x30, 0x30, 0x32,
  0xe1, 0xb2, 0x9c, 0x1e, 0x12, 0x2c, 0x48, 0x2e, 0x21, 0x4e, 0x07, 0x4e,
  0x00, 0x00, 0xd8, 0x12, 0x05, 0x19, 0x3a, 0x02, 0xff, 0xdf, 0x00, 0x00,
  0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};
/* }}} */

static const struct {
    gchar c;
    gsize len;
    const guchar *data;
}
digits[] = {
    { '0', G_N_ELEMENTS(digit_0_png),   digit_0_png,   },
    { '1', G_N_ELEMENTS(digit_1_png),   digit_1_png,   },
    { '2', G_N_ELEMENTS(digit_2_png),   digit_2_png,   },
    { '3', G_N_ELEMENTS(digit_3_png),   digit_3_png,   },
    { '4', G_N_ELEMENTS(digit_4_png),   digit_4_png,   },
    { '5', G_N_ELEMENTS(digit_5_png),   digit_5_png,   },
    { '6', G_N_ELEMENTS(digit_6_png),   digit_6_png,   },
    { '7', G_N_ELEMENTS(digit_7_png),   digit_7_png,   },
    { '8', G_N_ELEMENTS(digit_8_png),   digit_8_png,   },
    { '9', G_N_ELEMENTS(digit_9_png),   digit_9_png,   },
    { '.', G_N_ELEMENTS(digit_dot_png), digit_dot_png, },
};

static gint
format_check(GdkPixbufFormat *format, guchar *buffer, int size)
{
    int i, j, ii;
    gchar m;
    GdkPixbufModulePattern *pattern;
    gboolean anchored;
    guchar *prefix;
    gchar *mask;

    ii = 0;
    for (pattern = format->signature; pattern->prefix; pattern++, ii++) {
        if (pattern->mask && pattern->mask[0] == '*') {
            prefix = (guchar *)pattern->prefix + 1;
            mask = pattern->mask + 1;
            anchored = FALSE;
        }
        else {
            prefix = (guchar *)pattern->prefix;
            mask = pattern->mask;
            anchored = TRUE;
        }
        for (i = 0; i < size; i++) {
            for (j = 0; i + j < size && prefix[j] != 0; j++) {
                m = mask ? mask[j] : ' ';
                if (m == ' ') {
                    if (buffer[i + j] != prefix[j])
                        break;
                }
                else if (m == '!') {
                    if (buffer[i + j] == prefix[j])
                        break;
                }
                else if (m == 'z') {
                    if (buffer[i + j] != 0)
                        break;
                }
                else if (m == 'n') {
                    if (buffer[i + j] == 0)
                        break;
                }
            }

            if (prefix[j] == 0) {
                g_printerr("  Pattern #%d matches the file header (relevance %d).\n",
                           ii, pattern->relevance);
                return pattern->relevance;
            }

            if (anchored)
                break;
        }
    }
    g_printerr("  No pattern matches the file header.\n");
    return 0;
}

static void
sanity_check(const gchar *filename)
{
    GdkPixbufLoader *loader;
    GSList *formats, *l;
    GError *err = NULL;
    GdkPixbuf *pixbuf;
    gchar *buf = NULL;
    gsize size;
    FILE *fh;
    gboolean ok, fileok = TRUE;

    g_printerr("Performing sanity check for %s.\n", filename);
    fileok &= ok = g_file_test(filename, G_FILE_TEST_EXISTS);
    g_printerr("Does it exist: %s\n", ok ? "YES" : "NO");
    fileok &= ok = g_file_test(filename, G_FILE_TEST_IS_REGULAR);
    g_printerr("Is it a regular file: %s\n", ok ? "YES" : "NO");

    fh = gwy_fopen(filename, "rb");
    fileok &= ok = !!fh;
    g_printerr("Can we open it for reading: %s\n", ok ? "YES" : "NO");
    if (fh)
        fclose(fh);
    else
        g_printerr("gwy_fopen() fails with: %s\n", g_strerror(errno));

    fileok &= ok = g_file_get_contents(filename, &buf, &size, &err);
    g_printerr("Can we use g_file_get_contents(): %s\n", ok ? "YES" : "NO");
    if (!ok) {
        g_printerr("g_file_get_contents() fails with: %s\n", err->message);
        g_clear_error(&err);
    }

    if (!fileok) {
        if (buf)
            g_free(buf);
        g_printerr("The file does not seem OK.  No point continuing.\n");
        return;
    }
    g_printerr("The file seems OK, continuing checks.\n");

    pixbuf = gdk_pixbuf_new_from_file(filename, &err);
    if (pixbuf) {
        g_printerr("Apparently we can load the pixbuf (%dx%d) now?!\n",
                   gdk_pixbuf_get_width(pixbuf),
                   gdk_pixbuf_get_height(pixbuf));
        g_printerr("What has changed?\n");
        g_printerr("This is completely fucked up.\n");
        g_object_unref(pixbuf);
    }
    else {
        g_printerr("gdk_pixbuf_new_from_file() fails with: %s\n", err->message);
        g_clear_error(&err);
    }

    g_printerr("Checking the pixbuf loaders.\n");

    formats = gdk_pixbuf_get_formats();
    for (l = formats; l; l = g_slist_next(l)) {
        GdkPixbufFormat *pixbuf_format = (GdkPixbufFormat*)l->data;
        gchar **ext;
        gchar *fmtname, *desc, *exts;

        fmtname = gdk_pixbuf_format_get_name(pixbuf_format);
        desc = gdk_pixbuf_format_get_description(pixbuf_format);
        ext = gdk_pixbuf_format_get_extensions(pixbuf_format);
        exts = g_strjoinv(" ", ext);
        g_printerr("Found format %s: %s (%s)\n", fmtname, desc, exts);
        g_free(exts);
        g_strfreev(ext);
        g_free(desc);

        format_check(pixbuf_format, buf, size);

        loader = gdk_pixbuf_loader_new_with_type(fmtname, &err);
        if (!loader) {
            g_printerr("  Cannot create loader for %s: %s\n",
                       fmtname, err->message);
            g_clear_error(&err);
            g_free(fmtname);
            continue;
        }

        ok = gdk_pixbuf_loader_write(loader, buf, size, &err);
        if (ok) {
            g_printerr("  Loader %s accepts the file content.\n", fmtname);
            ok = gdk_pixbuf_loader_close(loader, &err);
            if (ok) {
                g_printerr("  Loader %s accepts the entire file.\n", fmtname);
                pixbuf = gdk_pixbuf_loader_get_pixbuf(loader);
                if (pixbuf) {
                    g_printerr("  Obtained pixbuf %dx%d from the loader.\n",
                               gdk_pixbuf_get_width(pixbuf),
                               gdk_pixbuf_get_height(pixbuf));
                }
                else {
                    g_printerr("  Cannot obtain pixbuf from the loader.\n");
                }
            }
            else {
                g_printerr("  Loader %s fails at close(): %s.\n",
                           fmtname, err->message);
                g_clear_error(&err);
            }
        }
        else {
            g_printerr("  Loader %s does not accept the file content: %s\n",
                       fmtname, err->message);
            g_clear_error(&err);
        }
        g_object_unref(loader);

        g_free(fmtname);
    }

    g_slist_free(formats);
}

static GdkPixbuf*
compose_splash(const gchar *version)
{
    gint xpos = 224;
    gint ypos = 36;
    GdkPixbufLoader *loader;
    GdkPixbuf *base, *digit;
    GError *err = NULL;
    guint i;
    gchar *p, *filename;

    p = gwy_find_self_dir("pixmaps");
    filename = g_build_filename(p, "splash.png", NULL);
    g_free(p);

    base = gdk_pixbuf_new_from_file(filename, &err);
    if (!base) {
        g_warning("Cannot load base splash image: %s", err->message);
        g_clear_error(&err);
        sanity_check(filename);
        g_free(filename);
        return NULL;
    }
    g_free(filename);

    while (*version) {
        loader = NULL;
        for (i = 0; i < G_N_ELEMENTS(digits); i++) {
            if (*version == digits[i].c)
                break;
        }
        if (i == G_N_ELEMENTS(digits)) {
            g_warning("Cannot find image for %c", *version);
            version++;
            continue;
        }

        loader = gdk_pixbuf_loader_new_with_type("png", &err);
        /* We have already successfully loaded base PNG */
        g_assert(loader);

        if (!gdk_pixbuf_loader_write(loader, digits[i].data, digits[i].len,
                                     &err)) {
            g_critical("Cannot load in-line image for %c as PNG", *version);
            break;
        }
        if (!gdk_pixbuf_loader_close(loader, &err)) {
            g_critical("Cannot load in-line image for %c as PNG", *version);
            break;
        }

        digit = gdk_pixbuf_loader_get_pixbuf(loader);
        g_assert(digit);

        gdk_pixbuf_composite(digit, base,
                             xpos, ypos,
                             gdk_pixbuf_get_width(digit),
                             gdk_pixbuf_get_height(digit),
                             xpos, ypos,
                             1.0, 1.0,
                             GDK_INTERP_NEAREST,
                             255);
        xpos += gdk_pixbuf_get_width(digit);
        g_object_unref(loader);

        version++;
    }
    return base;
}

/**
 * gwy_app_splash_start:
 * @visible: If %FALSE, splash screen is not actually shown, all functions just
 *           silently return.
 *
 * Starts splash screen.
 **/
void
gwy_app_splash_start(gboolean visible)
{
    GtkWidget *image, *vbox, *frame, *lab;
    GdkPixbuf *pixbuf;
    char *p, *version;

    gwy_debug("");
    g_return_if_fail(!in_splash);
    in_splash = TRUE;

    if (!visible)
        return;

    window = gtk_window_new(GTK_WINDOW_POPUP);
    p = g_strconcat(_("Starting "), g_get_application_name(), NULL);
    gtk_window_set_title(GTK_WINDOW(window), p);
    gtk_window_set_wmclass(GTK_WINDOW(window), "splash",
                           g_get_application_name());
    gtk_window_set_resizable(GTK_WINDOW(window), FALSE);
    gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
    gtk_window_set_decorated(GTK_WINDOW(window), FALSE);
    gtk_window_set_type_hint(GTK_WINDOW(window),
                             GDK_WINDOW_TYPE_HINT_SPLASHSCREEN);

    g_signal_connect_swapped(window, "delete-event",
                             G_CALLBACK(exit), GINT_TO_POINTER(0));
    /* we don't want the splash screen to send the startup notification */
    gtk_window_set_auto_startup_notification(FALSE);
    g_signal_connect(window, "map", G_CALLBACK(splash_map), NULL);

    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_OUT);
    gtk_container_add(GTK_CONTAINER(window), frame);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(frame), vbox);
    gtk_container_set_border_width(GTK_CONTAINER(vbox), 2);

    version = g_strdup_printf("%d.%d", GWY_VERSION_MAJOR, GWY_VERSION_MINOR);
    pixbuf = compose_splash(version);
    g_free(version);
    if (pixbuf) {
        image = gtk_image_new_from_pixbuf(pixbuf);
        g_object_unref(pixbuf);
    }
    else
        image = gtk_image_new_from_stock(GTK_STOCK_MISSING_IMAGE,
                                         GTK_ICON_SIZE_DIALOG);
    gtk_box_pack_start(GTK_BOX(vbox), image, FALSE, FALSE, 0);

    label = gtk_label_new(p);
    gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
    gtk_misc_set_padding(GTK_MISC(label), 6, 4);
    gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
    g_free(p);

    lab = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(vbox), lab, FALSE, FALSE, 0);

    p = g_strconcat("<small>", PACKAGE_NAME,
                    _(" is free software released under GNU GPL."), "</small>",
                    NULL);
    lab = gtk_label_new(NULL);
    gtk_label_set_markup(GTK_LABEL(lab), p);
    gtk_misc_set_alignment(GTK_MISC(lab), 0.0, 0.5);
    gtk_misc_set_padding(GTK_MISC(lab), 5, 3);
    gtk_box_pack_start(GTK_BOX(vbox), lab, FALSE, FALSE, 0);
    g_free(p);

    gtk_widget_show_all(window);

    while (gtk_events_pending())
        gtk_main_iteration();
}

void
gwy_app_splash_finish(void)
{
    g_return_if_fail(in_splash);
    if (!window)
        return;

    gtk_widget_destroy(window);
    g_free(message_prefix);

    window = NULL;
    label = NULL;
    message_prefix = NULL;

    while (gtk_events_pending())
        gtk_main_iteration();
}

void
gwy_app_splash_set_message_prefix(const gchar *prefix)
{
    g_return_if_fail(in_splash);
    if (!window)
        return;

    g_free(message_prefix);
    message_prefix = g_strdup(prefix);

    while (gtk_events_pending())
        gtk_main_iteration();
}

void
gwy_app_splash_set_message(const gchar *message)
{
    g_return_if_fail(in_splash);
    if (!window)
        return;

    while (gtk_events_pending())
        gtk_main_iteration();

    if (message_prefix) {
        gchar *s = g_strconcat(message_prefix, message, NULL);
        gtk_label_set_markup(GTK_LABEL(label), s);
        g_free(s);
    }
    else
        gtk_label_set_markup(GTK_LABEL(label), message);

    while (gtk_events_pending())
        gtk_main_iteration();
}

static void
splash_map(void)
{
    /* Reenable startup notification after the splash has been shown
     * so that the next window that is mapped sends the notification. */
    gtk_window_set_auto_startup_notification(TRUE);
}

/* vim: set cin et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
