/*
 ----------------------------------------------------------------------------
 |    Copyright (C) 1999   Raytheon Systems Company                         |
 ----------------------------------------------------------------------------
 */

#include     <HE5_HdfEosDef.h>

/*
 * In this example we will open an HDF-EOS file and attach to a
 * ZA structures within the file to read a dimension scales
 * and its attributes
 */


int main()
{
  herr_t          status = FAIL;
  hid_t           zafid = FAIL;
  hid_t           zaid1 = FAIL;
  int             i,j;
  int             bufsize;
  int            *databuff;
  long            nattr;
  long            strbufsize;
  char           *attrlist;
  size_t          fldnmlen[HE5_HDFE_NAMBUFSIZE];
  char           *fldnm[HE5_HDFE_NAMBUFSIZE];
  char           *attrname = (char *)NULL;
  hid_t          *ntype;
  hsize_t         count = 0;
  void           *attr;
  int            *attr_int;
  float          *attr_flt;
  char           *attr_char;
  hsize_t         dimsize;
  hid_t           numtype;

  /*
   * Open the HDF ZA file, "Za.h5".
   */

  zafid = HE5_ZAopen("ZA.he5", H5F_ACC_RDWR);
 
  /*
   * If the ZA file cannot be found, HE5_ZAopen will return -1 for the file
   * handle (zafid).  We there check that this is not the case before
   * proceeding with the other routines.
   * 
   * The HE5_ZAattach routine returns the handle to the existing ZA "Za1",
   * zaid.  If the ZA is not found, HE5_ZAattach returns -1 for the handle.
   */ 

  if (zafid != FAIL)
    {	  
      zaid1 = HE5_ZAattach(zafid, "ZA1");

      /* the field Spectra has Bands dimensions. 
	 Bands dim is set to 15
      */

      if (zaid1 == FAIL)
	{
	  printf("\t\tError: Cannot attach to ZA \"ZA1\"\n");
	  HE5_ZAclose(zafid);
	  return -1;
	}

      bufsize = HE5_ZAgetdimscale(zaid1, "Spectra", "Bands", &dimsize, &numtype, NULL);
      if (bufsize == -1)
	{
	  printf("\t\tError: Cannot get Dimension Scale size for Bands dimemnsion in field \"Spectra\"\n");
	  HE5_ZAdetach(zaid1);
	  HE5_ZAclose(zafid);
	  return -1;
	}
      else
	{
	  printf ("bufsize = %d \n",(int)bufsize);
	  printf ("dimsize = %d \n",(int)dimsize);
	  printf ("numtype = %d\n", (int)numtype);
	}
      databuff = (int *) malloc(bufsize);
      bufsize = HE5_ZAgetdimscale(zaid1, "Spectra", "Bands", &dimsize, &numtype, (void *)databuff);

      if (bufsize == -1)
	{
	  printf("\t\tError: Cannot get Dimension Scale for Bands dimemnsion in field \"Spectra\"\n");
	  HE5_ZAdetach(zaid1);
	  HE5_ZAclose(zafid);
	  free(databuff);
	  return -1;
	}
      else
	{
	  printf ("First 10 values are:\n");
	  for( i = 0; i < 10; i++)
	    {
	      printf ("DimscaleValue[%d] = %d\n",i,databuff[i]);
	    }
	}

      nattr = HE5_ZAinqdscaleattrs(zaid1, "Bands", NULL, &strbufsize);
      if ( nattr < 0 )
	{
	  printf("\t\tError: Cannot get Dimension Scale attribute list for \"Bands\"\n");
	  HE5_ZAdetach(zaid1);
	  HE5_ZAclose(zafid);
	  free(attrlist);
	  return -1;
	}

      attrlist = (char *) calloc(strbufsize + 2, sizeof(char));
      nattr = HE5_ZAinqdscaleattrs(zaid1, "Bands", attrlist, &strbufsize);
      if ( nattr < 0 )
	{
	  printf("\t\tError: Cannot get Dimension Scale attribute list for \"Bands\"\n");
	  HE5_ZAdetach(zaid1);
	  HE5_ZAclose(zafid);
	  free(attrlist);
	  return -1;
	}
	  printf(" \n");
	  printf("Dimension scale for \"Bands\" Attribute: \n");
      nattr = HE5_EHparsestr(attrlist, ',', fldnm, fldnmlen);
      if(nattr != FAIL)
	{
	  for( i = 0; i < nattr; i++)
	    {
	      attrname = (char *)calloc(fldnmlen[i] + 1, sizeof(char));
	      memmove(attrname,fldnm[i],fldnmlen[i]);
	      ntype = (hid_t *)calloc(1, sizeof(hid_t));
	      if(strcmp(attrname, "REFERENCE_LIST") ==0 ) continue;
	      status = HE5_ZAdscaleattrinfo(zaid1,"Bands", attrname, ntype, &count);
	      if( (int)*ntype == 0) {
		attr_int = (int *)malloc(count*sizeof(int));
		attr = (void *) attr_int;
	      }

	      if( (int)*ntype == 10) {
		attr_flt = (float *)malloc(count*sizeof(float));
		attr = (void *) attr_flt;
	      }

	      if( (int)*ntype == 57) {
		attr_char = (char *)malloc((count+1)*sizeof(char));
		attr = (void *) attr_char;
	      }
	      status = HE5_ZAreaddscaleattr(zaid1,"Bands", attrname, attr);
	      printf("\n");
	      printf("Status returned by HE5_ZAreaddscaleattr() :  %d \n", status );
	      printf("\tAttribute Name:               %s  \n",attrname);
	      printf("\tNumber of attribute elements: %lu \n", (unsigned long)count);
	      printf("\tData type of attribute:       %d \n", (int)*ntype);

	      if( (int)*ntype == 0) {
		attr_int = (int *)attr;
		for (j = 0; j < count; j++)
		  {
		    printf("\tAttrvalue[%d]:                 %d \n", j,attr_int[j]);
		  }
	      }

	      if( (int)*ntype == 10) {
		attr_flt = (float *)attr;
		for (j = 0; j < count; j++)
		  {
		    printf("\tAttrvalue[%d]:                 %f \n", j,attr_flt[j]);
		  }
	      }

	      if( (int)*ntype == 57) {
		attr_char = (char *)attr;
		attr_char[count]='\0';
		printf("\tAttrvalue:                    %s \n", attr_char);
		free(attr_char);
	      }
	    }
	}

      HE5_ZAdetach(zaid1);

      HE5_ZAclose(zafid);
      
      return 0;
    }
}
