/* 
 * ### Copyright (C) 2008 Michael Fuchs ###
 * ### All Rights Reserved.             ###
 *
 * Author: Michael Fuchs
 * E-Mail: michael.fuchs@dbdoclet.org
 * URL:    http://www.michael-a-fuchs.de
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Emphasis;

public class EmEditor extends AbstractInlineEditor {

    private Emphasis emphasis;

    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {

        DocBookTagFactory dbfactory = values.getTagFactory();
        emphasis = dbfactory.createEmphasis();
        
        setInlineElement(emphasis);

        return super.edit(values);
    }
    
    public Emphasis getEmphasis() {
        return emphasis;
    }

}
