#ifndef INCLUDED_STBASE_
#define INCLUDED_STBASE_

#include "../optbase/optbase.h"

#include "../precompopts/precompopts.h"
#include "../directopts/directopts.h"

class Args;

class STBase: public OptBase
{
    size_t d_idx;           // OptLong's nextIdx

    bool d_skipCompile;             // by default false (compilation is 
                                    // performed) but true at -tdir if 
                                    // scriptname younger scriptname.bim

    std::string d_tmp;              // set to tmpDir()/src() when using -t/-s
                                    // otherwise tmpDir()

    protected:
        Args   &d_Args;

        PtrVect d_compile;
        PtrVect d_execute;

    public:
        STBase(PtrVect &argv);
        ~STBase() override;

        PreCompOpts compileOpts();                                  // .f
        DirectOpts  executeOpts();

        bool script() const;                        
        bool skipCompile() const;                                   // .f
        void setSkipCompile(bool value);                            // .f

        void setTmp();
        std::string const &tmp() const;                             // .f

    protected:
                                // returns the 1st non-option idx or str::npos
        size_t addOptions(size_t from); // from: start position in d_argv

    private:
        bool hvOption();
        bool dOption();
        bool eOption();
};

#include "stbase.f"

#endif
