# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
UBUNTU_RELEASES += 20.04

.PHONY: all
all:: ubuntu-cloud-20.04.$(GARDEN_ARCH).qcow2 ubuntu-cloud-20.04.$(GARDEN_ARCH).run

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/ubuntu/focal-server-cloudimg-$(call map_to_debian_arch,$(GARDEN_ARCH)).img

$(GARDEN_DL_DIR)/ubuntu/focal-server-cloudimg-amd64.img $(GARDEN_DL_DIR)/ubuntu/focal-server-cloudimg-arm64.img: $(GARDEN_DL_DIR)/ubuntu/focal-server-cloudimg-%.img: | $(GARDEN_DL_DIR)/ubuntu
	$(strip $(WGET) \
		--no-clobber \
		--directory-prefix=$(firstword $|)/ \
		https://cloud-images.ubuntu.com/focal/current/focal-server-cloudimg-$*.img)

$(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-20.04.x86_64.qcow2: | $(GARDEN_DL_DIR)/ubuntu/ $(GARDEN_DL_DIR)/ubuntu/focal-server-cloudimg-amd64.img
	ln -sf $(notdir $(word 2,$|)) $@

$(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-20.04.aarch64.qcow2: | $(GARDEN_DL_DIR)/ubuntu/ $(GARDEN_DL_DIR)/ubuntu/focal-server-cloudimg-arm64.img
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/ubuntu/ubuntu-cloud-20.04.*.qcow2

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/ubuntu/focal-server-cloudimg-*.img
