#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2008-2009 Alessio Treglia
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.

import pygtk, gtk, gtk.glade
import locale, gettext
import os, commands
import optparse

import irgenerator, irgenerator.globals
import irgenerator.core.report, irgenerator.ui.gtk_ui

__doc__ = irgenerator.globals.__doc__

LOCALE_PATH = irgenerator.globals.LANG_PATH

locale.setlocale(locale.LC_ALL, '')

for module in gtk.glade, gettext:
    module.bindtextdomain('installation-report-generator', LOCALE_PATH)
    module.textdomain('installation-report-generator')

import __builtin__
__builtin__._ = gettext.gettext

def main():
    usage = (_("usage: %s [options]") % irgenerator.globals.SHORT_APPNAME)
    parser = optparse.OptionParser(usage=usage, version=' '.join([irgenerator.globals.SHORT_APPNAME,irgenerator.globals.get_version()]))
    (options, args) = parser.parse_args()
    # UI initialization
    m = irgenerator.core.report.HardwareConfiguration()
    c = irgenerator.ui.gtk_ui.MainWindowCtrl(m)
    v = irgenerator.ui.gtk_ui.MainWindowView(c)
    c.show()
    gtk.main()

if __name__ == "__main__":
    main()
