      SUBROUTINE TPWRY (IERROR)
C
C LATEST REVISION	 JULY 1984
C
C PURPOSE		 TO PROVIDE A SIMPLE DEMONSTRATION OF
C			 ENTRY PWRITY OF PWRITY	AND
C			 TO TEST PWRITY	ON A SIMPLE PROBLEM
C
C USAGE			 CALL TPWRY (IERROR)
C
C ARGUMENTS
C
C ON OUTPUT		 IERROR
C			   AN INTEGER VARIABLE
C			   = 0,	IF THE TEST WAS	SUCCESSFUL,
C			   = 1,	OTHERWISE
C
C I/O			 IF THE	TEST IS	SUCCESSFUL, THE	MESSAGE
C
C			   PWRITY TEST SUCCESSFUL  . . . SEE PLOT TO
C			   VERIFY PERFORMANCE
C
C			 IS WRITTEN TO UNIT 6.
C			 IN ADDITION, ONE FRAME	CONTAINING
C			 CHARACTER STRING PLOTS	IS PRODUCED ON THE
C			 MACHINE GRAPHICS DEVICE.  IN ORDER TO
C			 DETERMINE WHETHER THE TEST WAS	SUCCESSFUL,
C			 IT IS NECESSARY TO EXAMINE THIS PLOT.
C
C PRECISION		 SINGLE
C
C REQUIRED LIBRARY	 PWRITY
C FILES
C
C LANGUAGE		 FORTRAN
C
C ALGORITHM		 TPWRY CALLS PWRITY TO PLOT VARIOUS CHARACTER
C			 STRINGS USING DIFFERENT PARAMETERS.
C
C PORTABILITY		 ANSI FORTRAN 77
C
C
C INITIALIZE THE ERROR PARAMETER.
C
      IERROR = 0
C
C DEFINE NORMALIZATION TRANS 1 AND LOG SCALING
C
      CALL GSVP	(1, 0.0, 1.0, 0.0, 1.0)
      CALL GSWN	(1, 1.0, 1024.0, 1.0, 1024.0)
      CALL GSELNT (1)
      CALL SETUSV ('LS',1)
C
C LABEL	FRAME
C
      CALL PWRITY(512.0,950.0,
     1		  'DEMONSTRATION PLOT FOR PWRITY',
     2		  29,2,0,0)
C
C TEST PWRITY FOR DIFFERENT SIZE CHARACTERS.
C
      CALL PWRITY (10.0,900.0,'SIZE TEST',9,0,0,-1)
      CALL PWRITY (10.0,850.0,'SIZE TEST',9,1,0,-1)
      CALL PWRITY (10.0,775.0,'SIZE TEST',9,2,0,-1)
      CALL PWRITY (10.0,675.0,'SIZE TEST',9,3,0,-1)
      CALL PWRITY (10.0,525.0,'SIZE TEST',9,4,0,-1)
      CALL PWRITY (10.0,375.0,'SIZE TEST',9,5,0,-1)
C
C TEST PWRITY FOR DIFFERENT CHARACTER ORIENTATIONS.
C
      CALL PWRITY (600.0,600.0,'THETA TEST',10,2,0*90,-1)
      CALL PWRITY (600.0,600.0,'THETA TEST',10,2,1*90,-1)
      CALL PWRITY (600.0,600.0,'THETA TEST',10,2,2*90,-1)
      CALL PWRITY (600.0,600.0,'THETA TEST',10,2,3*90,-1)
C
C TEST CENTERING OPTIONS FOR PWRITY.
C
      CALL PWRITY (512.0,160.0,'CENTR TEST',10,2,0,0)
      CALL PWRITY (512.0,85.0,'CENTR TEST',10,2,0,-1)
      CALL PWRITY (512.0,235.0,'CENTR TEST',10,2,0,1)
c
c     CALL NEWFM
C
c      WRITE (6,1001)
      RETURN
C
c 1001 FORMAT ('	PWRITY TEST SUCCESSFUL',24X,
c     1	      'SEE PLOT	TO VERIFY PERFORMANCE')
C
      END
