/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag.layout;

import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.DynamicAttributes;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.StripesTagSupport;
import net.sourceforge.stripes.tag.layout.LayoutContext;

public class LayoutRenderTag
extends StripesTagSupport
implements BodyTag,
DynamicAttributes {
    private String name;
    private LayoutContext context = new LayoutContext();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        this.context.getParameters().put(localName, value);
    }

    public void addComponent(String name, String contents) {
        this.context.getComponents().put(name, contents);
    }

    public int doStartTag() throws JspException {
        this.pushPageContextAttributes(this.context.getParameters());
        return 2;
    }

    public void setBodyContent(BodyContent bodyContent) {
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
            String attributeName = "stripes.layout." + this.name;
            Stack<LayoutContext> stack = (Stack<LayoutContext>)request.getAttribute(attributeName);
            if (stack == null) {
                stack = new Stack<LayoutContext>();
                request.setAttribute(attributeName, stack);
            }
            stack.push(this.context);
            BodyContent content = this.getPageContext().pushBody();
            this.getPageContext().include(this.name, false);
            this.getPageContext().popBody();
            this.getPageContext().getOut().write(content.getString());
            if (!this.context.isRendered()) {
                throw new StripesJspException("Attempt made to render a layout that does not exist. The layout name provided was '" + this.name + "'. Please check that a JSP/view exists at " + "that location within your web application.");
            }
            stack.pop();
            this.popPageContextAttributes();
            this.context = new LayoutContext();
        }
        catch (StripesJspException sje) {
            throw sje;
        }
        catch (Exception e) {
            throw new StripesJspException("An exception was raised while invoking a layout. The layout used was '" + this.name + "'. The following information was supplied to the render " + "tag: " + this.context.toString(), e);
        }
        return 6;
    }
}

