/*                                                                            */
/* KIM-API: An API for interatomic models                                     */
/* Copyright (c) 2013--2022, Regents of the University of Minnesota.          */
/* All rights reserved.                                                       */
/*                                                                            */
/* Contributors:                                                              */
/*    Ryan S. Elliott                                                         */
/*                                                                            */
/* SPDX-License-Identifier: LGPL-2.1-or-later                                 */
/*                                                                            */
/* This library is free software; you can redistribute it and/or              */
/* modify it under the terms of the GNU Lesser General Public                 */
/* License as published by the Free Software Foundation; either               */
/* version 2.1 of the License, or (at your option) any later version.         */
/*                                                                            */
/* This library is distributed in the hope that it will be useful,            */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of             */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          */
/* Lesser General Public License for more details.                            */
/*                                                                            */
/* You should have received a copy of the GNU Lesser General Public License   */
/* along with this library; if not, write to the Free Software Foundation,    */
/* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA         */
/*                                                                            */

/*                                                                            */
/* Release: This file is part of the kim-api.git repository.                  */
/*                                                                            */


#ifndef KIM_MODEL_HEADERS_H_
#define KIM_MODEL_HEADERS_H_

/* IWYU pragma: begin_exports */
#ifndef KIM_MODEL_CREATE_H_
#include "KIM_ModelCreate.h"
#endif

#ifndef KIM_LOG_VERBOSITY_H_
#include "KIM_LogVerbosity.h"
#endif

#ifndef KIM_LANGUAGE_NAME_H_
#include "KIM_LanguageName.h"
#endif

#ifndef KIM_NUMBERING_H_
#include "KIM_Numbering.h"
#endif

#ifndef KIM_MODEL_ROUTINE_NAME_H_
#include "KIM_ModelRoutineName.h"
#endif

#ifndef KIM_SPECIES_NAME_H_
#include "KIM_SpeciesName.h"
#endif

#ifndef KIM_SUPPORT_STATUS_H_
#include "KIM_SupportStatus.h"
#endif

#ifndef KIM_UNIT_SYSTEM_H_
#include "KIM_UnitSystem.h"
#endif


#ifndef KIM_MODEL_COMPUTE_ARGUMENTS_CREATE_H_
#include "KIM_ModelComputeArgumentsCreate.h"
#endif

#ifndef KIM_COMPUTE_ARGUMENT_NAME_H_
#include "KIM_ComputeArgumentName.h"
#endif

#ifndef KIM_DATA_TYPE_H_
#include "KIM_DataType.h"
#endif

#ifndef KIM_COMPUTE_CALLBACK_NAME_H_
#include "KIM_ComputeCallbackName.h"
#endif


#ifndef KIM_MODEL_COMPUTE_ARGUMENTS_H_
#include "KIM_ModelComputeArguments.h"
#endif


#ifndef KIM_MODEL_COMPUTE_ARGUMENTS_DESTROY_H_
#include "KIM_ModelComputeArgumentsDestroy.h"
#endif


#ifndef KIM_MODEL_COMPUTE_H_
#include "KIM_ModelCompute.h"
#endif


#ifndef KIM_MODEL_EXTENSION_H_
#include "KIM_ModelExtension.h"
#endif


#ifndef KIM_MODEL_REFRESH_H_
#include "KIM_ModelRefresh.h"
#endif


#ifndef KIM_MODEL_WRITE_PARAMETERIZED_MODEL_H_
#include "KIM_ModelWriteParameterizedModel.h"
#endif


#ifndef KIM_MODEL_DESTROY_H_
#include "KIM_ModelDestroy.h"
#endif
/* IWYU pragma: end_exports */

#endif /* KIM_MODEL_HEADERS_H_ */
