/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include <QWidget>
#include <QDialog>
#include <QHostInfo>
#include <QLabel>
#include <QGridLayout>
#include <QList>
#include <QMessageBox>
#include <QStringList>
#include <QHostAddress>
#include <QPixmap>
#include <QPushButton>
#include <QGroupBox>
#include <QLineEdit>
#include <QComboBox>
#include <QIntValidator>
#include <QRegExp>
#include <QSettings>
#include <QMainWindow>
#include <QNetworkInterface>
#include <openssl/sha.h>
#include "../core/network/connection_controller.h"

class ServerCentralWindow : public QWidget
{
    Q_OBJECT

public:
    ServerCentralWindow(QWidget *parent = 0);

public slots:
    int start_server();
    void stop_server();
    void tcp_state(int state, int client_nbr);
    void auth_succeeded(int client_nbr);

signals:
    void showMessage(QString title, QString content, int duration);
private:
    QList<QHostAddress> addresses;
    QLabel *image;
    QGroupBox *groupBox;
    QPushButton *startButton;
    QPushButton *stopButton;
    QLabel *statusLabel;

    QLabel *hostLabel;
    QLabel *passwordLabel;
    QLabel *portLabel;
    QLabel *portFileLabel;

    QComboBox *ipCombo;
    QLineEdit *hostLineEdit;
    QLineEdit *passwordLineEdit;
    QLineEdit *portLineEdit;
    QLineEdit *portFileLineEdit;
    QSettings *settings;
    ConnectionController *controller;

};
