/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.servlet;

import gnu.lists.LList;
import gnu.lists.SeqPosition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class CGIServletWrapper
extends ServletOutputStream
implements HttpServletRequest,
HttpServletResponse,
ServletConfig,
ServletContext {
    byte[] buffer = null;
    int bufpos = 0;
    PrintStream out = System.out;
    Vector headers = new Vector();
    String sawContentType;
    int statusCode = 0;
    String statusString;
    String servletName;
    private static final int defaultBufferSize = 2048;
    PrintWriter writer;
    Hashtable attributes;
    boolean committed;
    String characterEncoding;
    static final Enumeration nullEnumeration = new SeqPosition(LList.Empty, 0, false);

    public static void main(String[] args) {
        try {
            CGIServletWrapper wrapper = new CGIServletWrapper();
            Class<?> servClass = Class.forName(args[0]);
            wrapper.servletName = args[0];
            HttpServlet servlet = (HttpServlet)servClass.newInstance();
            servlet.init((ServletConfig)wrapper);
            servlet.service((ServletRequest)wrapper, (ServletResponse)wrapper);
            wrapper.flushBuffer();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private void allocateBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[2048];
        }
    }

    public void write(int c) throws IOException {
        this.allocateBuffer();
        int bufsize = this.buffer.length;
        if (this.buffer.length == 0) {
            this.committ();
            this.out.write(c);
        } else {
            if (this.bufpos >= this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.bufpos++] = (byte)c;
        }
    }

    public String getCgiEnvVar(String name) {
        return System.getProperty(name);
    }

    public ServletOutputStream getOutputStream() {
        return this;
    }

    public PrintWriter getWriter() {
        if (this.writer == null) {
            this.writer = new PrintWriter(this.out);
        }
        return this.writer;
    }

    public Map getParameterMap() {
        return null;
    }

    public void setBufferSize(int size) {
        if (this.bufpos > 0 || this.committed) {
            throw new IllegalStateException();
        }
        this.buffer = new byte[size];
    }

    public int getBufferSize() {
        return this.buffer == null ? 2048 : this.buffer.length;
    }

    public void setLocale(Locale locale) {
    }

    private void committ() throws IOException {
        if (!this.committed) {
            this.printHeaders();
            this.committed = true;
        }
    }

    public void flushBuffer() throws IOException {
        this.committ();
        if (this.bufpos > 0) {
            this.out.write(this.buffer, 0, this.bufpos);
        }
        this.bufpos = 0;
    }

    public void resetBuffer() {
        this.bufpos = 0;
    }

    public void reset() {
        this.resetBuffer();
    }

    public Object getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        if (value == null) {
            this.removeAttribute(name);
        } else {
            if (this.attributes == null) {
                this.attributes = new Hashtable();
            }
            this.attributes.put(name, value);
        }
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public String getContentType() {
        return this.getCgiEnvVar("CONTENT_TYPE");
    }

    public String getPathInfo() {
        return this.getCgiEnvVar("PATH_INFO");
    }

    public String getPathTranslated() {
        return this.getCgiEnvVar("PATH_TRANSLATED");
    }

    public String getRequestURI() {
        String script = this.getServletPath();
        String path = this.getPathInfo();
        if (script == null) {
            return path;
        }
        if (path == null) {
            return script;
        }
        return script + '/' + path;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer(100);
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append('/');
        url.append(this.getRequestURI());
        return url;
    }

    public String getProtocol() {
        return this.getCgiEnvVar("SERVER_PROTOCOL");
    }

    public int getServerPort() {
        String port = this.getCgiEnvVar("SERVER_PORT");
        if (port != null) {
            try {
                return Integer.parseInt(port);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLocalPort() {
        return this.getServerPort();
    }

    public String getLocalAddr() {
        try {
            return InetAddress.getByName(this.getLocalName()).getHostAddress();
        }
        catch (UnknownHostException ex) {
            return "127.0.0.1";
        }
    }

    public String getLocalName() {
        return this.getServerName();
    }

    public int getRemotePort() {
        return -1;
    }

    public boolean isSecure() {
        return this.getServerPort() == 443;
    }

    public String getServerName() {
        return this.getCgiEnvVar("SERVER_NAME");
    }

    public String getMethod() {
        String method = this.getCgiEnvVar("REQUEST_METHOD");
        return method == null ? "GET" : method;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String enc) {
        this.characterEncoding = enc;
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public void setContentLength(int len) {
        this.setIntHeader("Content-Length", len);
    }

    public void addCookie(Cookie cookie) {
    }

    public boolean containsHeader(String str) {
        int num = this.headers.size();
        for (int i = 0; i < num; i += 2) {
            if (!this.headers.elementAt(i).equals(str)) continue;
            return true;
        }
        return false;
    }

    public String encodeURL(String str) {
        return null;
    }

    public String encodeUrl(String str) {
        return null;
    }

    public String encodeRedirectURL(String str) {
        return null;
    }

    public String encodeRedirectUrl(String str) {
        return null;
    }

    public void sendError(int i, String str) {
        this.statusCode = i;
        this.statusString = str;
    }

    public void sendError(int i) {
        this.statusCode = i;
        this.statusString = null;
    }

    public void sendRedirect(String str) {
    }

    private void printHeader(String label, String value) {
        this.out.print(label);
        this.out.print(": ");
        this.out.println(value);
    }

    private void printHeaders() {
        if (this.statusCode != 0) {
            this.out.print("Status: ");
            this.out.print(this.statusCode);
            if (this.statusString != null) {
                this.out.print(' ');
                this.out.print(this.statusString);
            }
            this.out.println();
        }
        if (this.sawContentType == null) {
            this.setContentType("text/html");
        }
        int num = this.headers.size();
        for (int i = 0; i < num; i += 2) {
            this.printHeader(this.headers.elementAt(i).toString(), this.headers.elementAt(i + 1).toString());
        }
        this.out.println();
    }

    public void setDateHeader(String str, long l) {
    }

    public void addDateHeader(String str, long l) {
    }

    public void setHeader(String label, String value) {
        int num = this.headers.size();
        for (int i = 0; i < num; i += 2) {
            if (!this.headers.elementAt(i).equals(label)) continue;
            if (label.equalsIgnoreCase("Content-type")) {
                this.sawContentType = value;
            }
            this.headers.setElementAt(value, i + 1);
            break;
        }
        this.addHeader(label, value);
    }

    public void setIntHeader(String str, int i) {
        this.setHeader(str, Integer.toString(i));
    }

    public void addHeader(String label, String value) {
        if (label.equalsIgnoreCase("Content-type")) {
            this.sawContentType = value;
        }
        this.headers.addElement(label);
        this.headers.addElement(value);
    }

    public void addIntHeader(String str, int i) {
        this.addHeader(str, Integer.toString(i));
    }

    public void setStatus(int i) {
        this.statusCode = i;
        this.statusString = null;
    }

    public void setStatus(int i, String str) {
        this.statusCode = i;
        this.statusString = str;
    }

    public String getScheme() {
        return this.getServerPort() == 443 ? "https" : "http";
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public Locale getLocale() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public String getRemoteAddr() {
        return this.getCgiEnvVar("REMOTE_ADDR");
    }

    public String getRemoteHost() {
        String host = this.getCgiEnvVar("REMOTE_HOST");
        return host != null ? host : this.getRemoteAddr();
    }

    public BufferedReader getReader() {
        return null;
    }

    public ServletInputStream getInputStream() {
        return null;
    }

    public String getParameter(String name) {
        return null;
    }

    public Enumeration getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String name) {
        return null;
    }

    public int getContentLength() {
        String length = this.getCgiEnvVar("CONTENT_LENGTH");
        if (length != null) {
            try {
                return Integer.parseInt(length);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getAuthType() {
        return this.getCgiEnvVar("AUTH_TYPE");
    }

    public long getDateHeader(String str) {
        return -1L;
    }

    public String getHeader(String str) {
        return null;
    }

    public Enumeration getHeaders(String str) {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return this.getCgiEnvVar("SCRIPT_NAME");
    }

    public HttpSession getSession(boolean b) {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public String getRemoteUser() {
        return this.getCgiEnvVar("REMOTE_USER");
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getContextPath() {
        return "";
    }

    public String getQueryString() {
        return this.getCgiEnvVar("QUERY_STRING");
    }

    public Enumeration getHeaderNames() {
        return null;
    }

    public int getIntHeader(String str) {
        return -1;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public String getInitParameter(String name) {
        return null;
    }

    public Enumeration getInitParameterNames() {
        return nullEnumeration;
    }

    public ServletContext getServletContext() {
        return this;
    }

    public String getServletName() {
        return this.servletName;
    }

    public ServletContext getContext(String path) {
        return null;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 3;
    }

    public String getMimeType(String file) {
        return null;
    }

    public Set getResourcePaths(String path) {
        return null;
    }

    public URL getResource(String path) {
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String path) {
        return null;
    }

    public Servlet getServlet(String name) {
        return null;
    }

    public Enumeration getServlets() {
        return nullEnumeration;
    }

    public Enumeration getServletNames() {
        return nullEnumeration;
    }

    public void log(String message) {
    }

    public void log(Exception ex, String mgs) {
    }

    public void log(String msg, Throwable ex) {
    }

    public String getServerInfo() {
        return "Kawa CGI/servlet wrapper";
    }

    public String getServletContextName() {
        return null;
    }
}

