/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.ArrayListIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.sort.LocalOrderComparer;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.type.BuiltInSchemaFactory;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.xpath.XPathException;

public class KeyManager
implements Serializable {
    private HashMap keyList = new HashMap();
    private transient WeakHashMap docIndexes = new WeakHashMap();

    public KeyManager() {
        this.registerIdrefKey();
    }

    private void registerIdrefKey() {
        SchemaType schemaType = BuiltInSchemaFactory.getSchemaType(561);
        SchemaType schemaType2 = BuiltInSchemaFactory.getSchemaType(562);
        ContentTypeTest contentTypeTest = new ContentTypeTest(2, schemaType);
        ContentTypeTest contentTypeTest2 = new ContentTypeTest(2, schemaType2);
        ContentTypeTest contentTypeTest3 = new ContentTypeTest(1, schemaType);
        ContentTypeTest contentTypeTest4 = new ContentTypeTest(1, schemaType2);
        UnionPattern unionPattern = new UnionPattern(contentTypeTest, contentTypeTest2);
        UnionPattern unionPattern2 = new UnionPattern(contentTypeTest3, contentTypeTest4);
        UnionPattern unionPattern3 = new UnionPattern(unionPattern, unionPattern2);
        Atomizer atomizer = new Atomizer(new ContextItemExpression());
        KeyDefinition keyDefinition = new KeyDefinition(unionPattern3, atomizer, null);
        this.setKeyDefinition(562, keyDefinition);
    }

    public void setKeyDefinition(int n, KeyDefinition keyDefinition) {
        Integer n2 = new Integer(n);
        ArrayList<KeyDefinition> arrayList = (ArrayList<KeyDefinition>)this.keyList.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList<KeyDefinition>();
            this.keyList.put(n2, arrayList);
        }
        arrayList.add(keyDefinition);
    }

    public List getKeyDefinitions(int n) {
        return (List)this.keyList.get(new Integer(n));
    }

    private synchronized HashMap buildIndex(int n, int n2, DocumentInfo documentInfo, Controller controller) throws XPathException {
        List list = this.getKeyDefinitions(n);
        if (list == null) {
            throw new XPathException.Dynamic("Key " + controller.getNamePool().getDisplayName(n) + " has not been defined");
        }
        HashMap hashMap = new HashMap();
        int n3 = 0;
        while (n3 < list.size()) {
            this.constructIndex(documentInfo, hashMap, (KeyDefinition)list.get(n3), n2, controller, n3 == 0);
            ++n3;
        }
        return hashMap;
    }

    private void constructIndex(DocumentInfo documentInfo, HashMap hashMap, KeyDefinition keyDefinition, int n, Controller controller, boolean bl) throws XPathException {
        Pattern pattern = keyDefinition.getMatch();
        Expression expression = keyDefinition.getUse();
        Collator collator = keyDefinition.getCollation();
        DocumentInfo documentInfo2 = documentInfo;
        NodeInfo nodeInfo = documentInfo2;
        SequenceIterator sequenceIterator = controller.getCurrentIterator();
        Object[] objectArray = controller.saveContext();
        XPathContext xPathContext = controller.newXPathContext();
        int n2 = pattern.getNodeKind();
        if (n2 == 2 || n2 == 0 || n2 == 9) {
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)5);
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (nodeInfo.getNodeKind() == 1) {
                    NodeInfo nodeInfo2;
                    AxisIterator axisIterator2 = nodeInfo.iterateAxis((byte)2);
                    while ((nodeInfo2 = (NodeInfo)axisIterator2.next()) != null) {
                        if (!pattern.matches(nodeInfo2, controller)) continue;
                        this.processKeyNode(nodeInfo2, expression, n, collator, hashMap, xPathContext, bl);
                    }
                    if (n2 != 0 || !pattern.matches(nodeInfo, controller)) continue;
                    this.processKeyNode(nodeInfo, expression, n, collator, hashMap, xPathContext, bl);
                    continue;
                }
                if (!pattern.matches(nodeInfo, controller)) continue;
                this.processKeyNode(nodeInfo, expression, n, collator, hashMap, xPathContext, bl);
            }
        } else {
            AxisIterator axisIterator = documentInfo.iterateAxis((byte)4, pattern.getNodeTest());
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (!(pattern instanceof NodeTest) && !pattern.matches(nodeInfo, controller)) continue;
                this.processKeyNode(nodeInfo, expression, n, collator, hashMap, xPathContext, bl);
            }
        }
        controller.setCurrentIterator(sequenceIterator);
        controller.restoreContext(objectArray);
    }

    private void processKeyNode(NodeInfo nodeInfo, Expression expression, int n, Collator collator, HashMap hashMap, XPathContext xPathContext, boolean bl) throws XPathException {
        AtomicValue atomicValue;
        AxisIterator axisIterator = SingletonIterator.makeIterator(nodeInfo);
        axisIterator.next();
        xPathContext.setCurrentIterator(axisIterator);
        xPathContext.getController().setCurrentIterator(axisIterator);
        SequenceIterator sequenceIterator = expression.iterate(xPathContext);
        while ((atomicValue = (AtomicValue)sequenceIterator.next()) != null) {
            Object object;
            if (n == 513 || n == 642) {
                object = collator == null ? atomicValue.getStringValue() : collator.getCollationKey(atomicValue.getStringValue());
            } else {
                try {
                    object = atomicValue.convert(n);
                }
                catch (XPathException xPathException) {
                    break;
                }
            }
            if (atomicValue instanceof DoubleValue && Double.isNaN(((DoubleValue)atomicValue).getValue())) break;
            ArrayList<NodeInfo> arrayList = (ArrayList<NodeInfo>)hashMap.get(object);
            if (arrayList == null) {
                arrayList = new ArrayList<NodeInfo>();
                hashMap.put(object, arrayList);
                arrayList.add(nodeInfo);
                continue;
            }
            if (bl) {
                if (arrayList.get(arrayList.size() - 1) == nodeInfo) continue;
                arrayList.add(nodeInfo);
                continue;
            }
            LocalOrderComparer localOrderComparer = LocalOrderComparer.getInstance();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                int n3 = localOrderComparer.compare(nodeInfo, (NodeInfo)arrayList.get(n2));
                if (n3 <= 0) {
                    if (n3 != 0) {
                        arrayList.add(n2, nodeInfo);
                    }
                    return;
                }
                ++n2;
            }
            arrayList.add(nodeInfo);
        }
    }

    public SequenceIterator selectByKey(int n, DocumentInfo documentInfo, AtomicValue atomicValue, Controller controller) throws XPathException {
        Object object;
        int n2 = atomicValue.getItemType().getPrimitiveType();
        if (n2 == 532 || n2 == 515 || n2 == 516) {
            n2 = 517;
            atomicValue = atomicValue.convert(n2);
        }
        if ((object = this.getIndex(documentInfo, n, n2)) instanceof String) {
            throw new XPathException.Dynamic("Key definition is circular");
        }
        HashMap hashMap = (HashMap)object;
        if (hashMap == null) {
            this.putIndex(documentInfo, n, n2, "Under Construction", controller);
            hashMap = this.buildIndex(n, n2, documentInfo, controller);
            this.putIndex(documentInfo, n, n2, hashMap, controller);
        }
        KeyDefinition keyDefinition = (KeyDefinition)this.getKeyDefinitions(n).get(0);
        Collator collator = keyDefinition.getCollation();
        Object object2 = n2 == 513 || n2 == 642 ? (collator == null ? atomicValue.getStringValue() : collator.getCollationKey(atomicValue.getStringValue())) : atomicValue;
        ArrayList arrayList = (ArrayList)hashMap.get(object2);
        if (arrayList == null) {
            return EmptyIterator.getInstance();
        }
        return new ArrayListIterator(arrayList);
    }

    private synchronized void putIndex(DocumentInfo documentInfo, int n, int n2, Object object, Controller controller) {
        HashMap hashMap;
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap();
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null || weakReference.get() == null) {
            hashMap = new HashMap();
            controller.setUserData(documentInfo, "key-index-list", hashMap);
            this.docIndexes.put(documentInfo, new WeakReference<HashMap>(hashMap));
        } else {
            hashMap = (HashMap)weakReference.get();
        }
        hashMap.put(new Long((long)n << 32 | (long)n2), object);
    }

    private synchronized Object getIndex(DocumentInfo documentInfo, int n, int n2) {
        WeakReference weakReference;
        if (this.docIndexes == null) {
            this.docIndexes = new WeakHashMap();
        }
        if ((weakReference = (WeakReference)this.docIndexes.get(documentInfo)) == null) {
            return null;
        }
        HashMap hashMap = (HashMap)weakReference.get();
        if (hashMap == null) {
            return null;
        }
        return hashMap.get(new Long((long)n << 32 | (long)n2));
    }
}

