/* vfs-file-monitor-impl-gio.c generated by valac 0.10.4, the Vala compiler
 * generated from vfs-file-monitor-impl-gio.vala, do not modify */

/*
 * Desktop Agnostic Library: File monitor implementation (with GIO).
 *
 * Copyright (C) 2009 Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Author : Mark Lee <libdesktop-agnostic@lazymalevolence.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <libdesktop-agnostic/vfs.h>
#include <gio/gio.h>


#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO (desktop_agnostic_vfs_file_monitor_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, DesktopAgnosticVFSFileMonitorGIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, DesktopAgnosticVFSFileMonitorGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_MONITOR_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, DesktopAgnosticVFSFileMonitorGIOClass))

typedef struct _DesktopAgnosticVFSFileMonitorGIO DesktopAgnosticVFSFileMonitorGIO;
typedef struct _DesktopAgnosticVFSFileMonitorGIOClass DesktopAgnosticVFSFileMonitorGIOClass;
typedef struct _DesktopAgnosticVFSFileMonitorGIOPrivate DesktopAgnosticVFSFileMonitorGIOPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO (desktop_agnostic_vfs_file_gio_get_type ())
#define DESKTOP_AGNOSTIC_VFS_FILE_GIO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO, DesktopAgnosticVFSFileGIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO, DesktopAgnosticVFSFileGIOClass))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GIO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO))
#define DESKTOP_AGNOSTIC_VFS_IS_FILE_GIO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO))
#define DESKTOP_AGNOSTIC_VFS_FILE_GIO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_GIO, DesktopAgnosticVFSFileGIOClass))

typedef struct _DesktopAgnosticVFSFileGIO DesktopAgnosticVFSFileGIO;
typedef struct _DesktopAgnosticVFSFileGIOClass DesktopAgnosticVFSFileGIOClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DesktopAgnosticVFSFileMonitorGIO {
	GObject parent_instance;
	DesktopAgnosticVFSFileMonitorGIOPrivate * priv;
};

struct _DesktopAgnosticVFSFileMonitorGIOClass {
	GObjectClass parent_class;
};

struct _DesktopAgnosticVFSFileMonitorGIOPrivate {
	GFileMonitor* monitor;
	DesktopAgnosticVFSFile* file;
};


static gpointer desktop_agnostic_vfs_file_monitor_gio_parent_class = NULL;
static DesktopAgnosticVFSFileMonitorIface* desktop_agnostic_vfs_file_monitor_gio_desktop_agnostic_vfs_file_monitor_parent_iface = NULL;

GType desktop_agnostic_vfs_file_monitor_gio_get_type (void) G_GNUC_CONST;
#define DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, DesktopAgnosticVFSFileMonitorGIOPrivate))
enum  {
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_DUMMY_PROPERTY,
	DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_CANCELLED
};
GType desktop_agnostic_vfs_file_gio_get_type (void) G_GNUC_CONST;
DesktopAgnosticVFSFileMonitorGIO* desktop_agnostic_vfs_file_monitor_gio_new (DesktopAgnosticVFSFileGIO* file);
DesktopAgnosticVFSFileMonitorGIO* desktop_agnostic_vfs_file_monitor_gio_construct (GType object_type, DesktopAgnosticVFSFileGIO* file);
static void desktop_agnostic_vfs_file_monitor_gio_monitor_callback (DesktopAgnosticVFSFileMonitorGIO* self, GFileMonitor* monitor, GFile* file, GFile* other, GFileMonitorEvent event_type);
static void _desktop_agnostic_vfs_file_monitor_gio_monitor_callback_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
static void desktop_agnostic_vfs_file_monitor_gio_real_emit (DesktopAgnosticVFSFileMonitor* base, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event);
static gboolean desktop_agnostic_vfs_file_monitor_gio_real_cancel (DesktopAgnosticVFSFileMonitor* base);
static void desktop_agnostic_vfs_file_monitor_gio_finalize (GObject* obj);
static void desktop_agnostic_vfs_file_monitor_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _desktop_agnostic_vfs_file_monitor_gio_monitor_callback_g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	desktop_agnostic_vfs_file_monitor_gio_monitor_callback (self, _sender, file, other_file, event_type);
}


DesktopAgnosticVFSFileMonitorGIO* desktop_agnostic_vfs_file_monitor_gio_construct (GType object_type, DesktopAgnosticVFSFileGIO* file) {
	DesktopAgnosticVFSFileMonitorGIO * self = NULL;
	DesktopAgnosticVFSFile* _tmp0_;
	GFile* impl;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (DesktopAgnosticVFSFileMonitorGIO*) g_object_new (object_type, NULL);
	self->priv->file = (_tmp0_ = _g_object_ref0 ((DesktopAgnosticVFSFile*) file), _g_object_unref0 (self->priv->file), _tmp0_);
	impl = _g_object_ref0 (G_FILE (desktop_agnostic_vfs_file_get_implementation ((DesktopAgnosticVFSFile*) file)));
	if (desktop_agnostic_vfs_file_get_file_type ((DesktopAgnosticVFSFile*) file) == DESKTOP_AGNOSTIC_VFS_FILE_TYPE_DIRECTORY) {
		GFileMonitor* _tmp1_;
		GFileMonitor* _tmp2_;
		_tmp1_ = g_file_monitor_directory (impl, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (impl);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		self->priv->monitor = (_tmp2_ = _tmp1_, _g_object_unref0 (self->priv->monitor), _tmp2_);
	} else {
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
		_tmp3_ = g_file_monitor_file (impl, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (impl);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		self->priv->monitor = (_tmp4_ = _tmp3_, _g_object_unref0 (self->priv->monitor), _tmp4_);
	}
	g_signal_connect_object (self->priv->monitor, "changed", (GCallback) _desktop_agnostic_vfs_file_monitor_gio_monitor_callback_g_file_monitor_changed, self, 0);
	_g_object_unref0 (impl);
	return self;
}


DesktopAgnosticVFSFileMonitorGIO* desktop_agnostic_vfs_file_monitor_gio_new (DesktopAgnosticVFSFileGIO* file) {
	return desktop_agnostic_vfs_file_monitor_gio_construct (DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR_GIO, file);
}


static void desktop_agnostic_vfs_file_monitor_gio_monitor_callback (DesktopAgnosticVFSFileMonitorGIO* self, GFileMonitor* monitor, GFile* file, GFile* other, GFileMonitorEvent event_type) {
	DesktopAgnosticVFSFile* other_file;
	DesktopAgnosticVFSFileMonitorEvent da_event = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor != NULL);
	g_return_if_fail (file != NULL);
	other_file = NULL;
	if (other != NULL) {
		char* _tmp0_;
		DesktopAgnosticVFSFile* _tmp1_;
		DesktopAgnosticVFSFile* _tmp2_;
		DesktopAgnosticVFSFile* _tmp3_;
		_tmp2_ = (_tmp1_ = desktop_agnostic_vfs_file_new_for_uri (_tmp0_ = g_file_get_uri (other), &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (other_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		other_file = (_tmp3_ = _tmp2_, _g_object_unref0 (other_file), _tmp3_);
	}
	switch (event_type) {
		case G_FILE_MONITOR_EVENT_CHANGED:
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			da_event = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CHANGED;
			break;
		}
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			da_event = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CREATED;
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			da_event = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_DELETED;
			break;
		}
		case G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
		{
			da_event = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED;
			break;
		}
		default:
		{
			da_event = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_UNKNOWN;
			break;
		}
	}
	g_signal_emit_by_name ((DesktopAgnosticVFSFileMonitor*) self, "changed", self->priv->file, other_file, da_event);
	_g_object_unref0 (other_file);
}


static void desktop_agnostic_vfs_file_monitor_gio_real_emit (DesktopAgnosticVFSFileMonitor* base, DesktopAgnosticVFSFile* other, DesktopAgnosticVFSFileMonitorEvent event) {
	DesktopAgnosticVFSFileMonitorGIO * self;
	GFileMonitorEvent gio_event = 0;
	GFile* other_file;
	self = (DesktopAgnosticVFSFileMonitorGIO*) base;
	other_file = NULL;
	switch (event) {
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CHANGED:
		{
			gio_event = G_FILE_MONITOR_EVENT_CHANGED;
			break;
		}
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_CREATED:
		{
			gio_event = G_FILE_MONITOR_EVENT_CREATED;
			break;
		}
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_DELETED:
		{
			gio_event = G_FILE_MONITOR_EVENT_DELETED;
			break;
		}
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
		{
			gio_event = G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED;
			break;
		}
		default:
		{
			_g_object_unref0 (other_file);
			return;
		}
	}
	if (other != NULL) {
		GFile* _tmp0_;
		other_file = (_tmp0_ = _g_object_ref0 (G_FILE (desktop_agnostic_vfs_file_get_implementation (other))), _g_object_unref0 (other_file), _tmp0_);
	}
	g_file_monitor_emit_event (self->priv->monitor, G_FILE (desktop_agnostic_vfs_file_get_implementation (self->priv->file)), other_file, gio_event);
	_g_object_unref0 (other_file);
}


static gboolean desktop_agnostic_vfs_file_monitor_gio_real_cancel (DesktopAgnosticVFSFileMonitor* base) {
	DesktopAgnosticVFSFileMonitorGIO * self;
	gboolean result = FALSE;
	self = (DesktopAgnosticVFSFileMonitorGIO*) base;
	result = g_file_monitor_cancel (self->priv->monitor);
	return result;
}


static gboolean desktop_agnostic_vfs_file_monitor_gio_real_get_cancelled (DesktopAgnosticVFSFileMonitor* base) {
	gboolean result;
	DesktopAgnosticVFSFileMonitorGIO* self;
	self = (DesktopAgnosticVFSFileMonitorGIO*) base;
	result = g_file_monitor_is_cancelled (self->priv->monitor);
	return result;
}


static void desktop_agnostic_vfs_file_monitor_gio_class_init (DesktopAgnosticVFSFileMonitorGIOClass * klass) {
	desktop_agnostic_vfs_file_monitor_gio_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DesktopAgnosticVFSFileMonitorGIOPrivate));
	G_OBJECT_CLASS (klass)->get_property = desktop_agnostic_vfs_file_monitor_gio_get_property;
	G_OBJECT_CLASS (klass)->finalize = desktop_agnostic_vfs_file_monitor_gio_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_CANCELLED, "cancelled");
}


static void desktop_agnostic_vfs_file_monitor_gio_desktop_agnostic_vfs_file_monitor_interface_init (DesktopAgnosticVFSFileMonitorIface * iface) {
	desktop_agnostic_vfs_file_monitor_gio_desktop_agnostic_vfs_file_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->emit = desktop_agnostic_vfs_file_monitor_gio_real_emit;
	iface->cancel = desktop_agnostic_vfs_file_monitor_gio_real_cancel;
	iface->get_cancelled = desktop_agnostic_vfs_file_monitor_gio_real_get_cancelled;
}


static void desktop_agnostic_vfs_file_monitor_gio_instance_init (DesktopAgnosticVFSFileMonitorGIO * self) {
	self->priv = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_GET_PRIVATE (self);
}


static void desktop_agnostic_vfs_file_monitor_gio_finalize (GObject* obj) {
	DesktopAgnosticVFSFileMonitorGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO (obj);
	_g_object_unref0 (self->priv->monitor);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (desktop_agnostic_vfs_file_monitor_gio_parent_class)->finalize (obj);
}


GType desktop_agnostic_vfs_file_monitor_gio_get_type (void) {
	static volatile gsize desktop_agnostic_vfs_file_monitor_gio_type_id__volatile = 0;
	if (g_once_init_enter (&desktop_agnostic_vfs_file_monitor_gio_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DesktopAgnosticVFSFileMonitorGIOClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_agnostic_vfs_file_monitor_gio_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopAgnosticVFSFileMonitorGIO), 0, (GInstanceInitFunc) desktop_agnostic_vfs_file_monitor_gio_instance_init, NULL };
		static const GInterfaceInfo desktop_agnostic_vfs_file_monitor_info = { (GInterfaceInitFunc) desktop_agnostic_vfs_file_monitor_gio_desktop_agnostic_vfs_file_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType desktop_agnostic_vfs_file_monitor_gio_type_id;
		desktop_agnostic_vfs_file_monitor_gio_type_id = g_type_register_static (G_TYPE_OBJECT, "DesktopAgnosticVFSFileMonitorGIO", &g_define_type_info, 0);
		g_type_add_interface_static (desktop_agnostic_vfs_file_monitor_gio_type_id, DESKTOP_AGNOSTIC_VFS_TYPE_FILE_MONITOR, &desktop_agnostic_vfs_file_monitor_info);
		g_once_init_leave (&desktop_agnostic_vfs_file_monitor_gio_type_id__volatile, desktop_agnostic_vfs_file_monitor_gio_type_id);
	}
	return desktop_agnostic_vfs_file_monitor_gio_type_id__volatile;
}


static void desktop_agnostic_vfs_file_monitor_gio_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DesktopAgnosticVFSFileMonitorGIO * self;
	self = DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO (object);
	switch (property_id) {
		case DESKTOP_AGNOSTIC_VFS_FILE_MONITOR_GIO_CANCELLED:
		g_value_set_boolean (value, desktop_agnostic_vfs_file_monitor_get_cancelled ((DesktopAgnosticVFSFileMonitor*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




