/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.deployers.spi.management;

import org.jboss.managed.api.ManagedDeployment;

/**
 * Enum for the known deployment types.
 * @see {@linkplain ManagedDeployment#getTypes()}
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:$
 */
public enum KnownDeploymentTypes
{
   JavaEEApplication("ear"),
   JavaEEClientApplication("car"),
   JavaEEEnterpriseBeans2x("ejb2x"),
   JavaEEEnterpriseBeans3x("ejb3x"),
   JavaEEWebApplication("war"),
   JavaEEResourceAdaptor("rar"),
   JavaEEPersistenceUnit("par"),
   JBossServices("sar"),
   MCBeans("beans"),
   OSGIBundle("bundle"),
   SpringApplication("spring"),
   Unknown("*")
   ;

   /** The simple type string, usually used as the deployment archive suffix */
   private final String type;

   private KnownDeploymentTypes(String type)
   {
      this.type = type;
   }

   /**
    * Get the simple deployment type string. This is usually used as the
    * associated deployment archive suffix.
    * 
    * @return the simple deployment type string.
    */
   public String getType()
   {
      return type;
   }
}
