/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _QTSHIVA_COLOR_BUTTON_P_H_
#define _QTSHIVA_COLOR_BUTTON_P_H_

#include <QPushButton>

namespace QtShiva {
  /**
   * @ingroup QtShiva
   * @internal
   */
  class ColorButton : public QPushButton {
    Q_OBJECT
    public:
      ColorButton( QWidget* _parent, bool _showAlpha );
      ~ColorButton();
      const QColor& currentColor() const;
    signals:
      void colorChanged( const QColor& );
    public slots:
      void setCurrentColor( const QColor& _color );
    private slots:
      void activated();
    private:
      QColor m_color;
      bool m_showAlpha;
  };
}

#endif
