/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  A MIRIAM-compliant date representation.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 <p>
 * A {@link Date} object stores a reasonably complete representation of date and
 * time.  Its purpose is to serve as a way to store dates to be read and
 * written in the <a target='_blank'
 * href='http://www.w3.org/TR/NOTE-datetime'>W3C date format</a> used in
 * RDF Dublin Core annotations within SBML.  The W3C date format is a
 * restricted form of <a target='_blank'
 * href='http://en.wikipedia.org/wiki/ISO_8601'>ISO 8601</a>, the
 * international standard for the representation of dates and times.  A
 * time and date value in this W3C format takes the form
 * YYYY-MM-DDThh:mm:ssXHH:ZZ (e.g., <code>1997-07-16T19:20:30+01:00</code>)
 * where XHH:ZZ is the time zone offset.  The libSBML {@link Date} object contains
 * the following fields to represent these values:
 <p>
 * <ul>
 * <li> <em>year</em>: a long integer representing the year.  This should be a
 * four-digit number such as <code>2011.</code>
 <p>
 * <li> <em>month</em>: a long integer representing the month, with a range of
 * values of 1&ndash;12.  The value <code>1</code> represents January, and so on.
 <p>
 * <li> <em>day</em>: a long integer representing the day of the month, with a
 * range of values of 1&ndash;31.
 <p>
 * <li> <em>hour</em>: a long integer representing the hour on a 24-hour clock,
 * with a range of values of 0&ndash;23.
 <p>
 * <li> <em>minute</em>: a long integer representing the minute, with a range
 * of 0&ndash;59.
 <p>
 * <li> <em>second</em>: a long integer representing the second, with a range
 * of 0&ndash;59.
 <p>
 * <li> <em>sign</em>: a long integer representing the sign of the offset (<code>0</code>
 * signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph below for
 * further explanations.
 <p>
 * <li> <em>hours</em> offset: a long integer representing the time zone's hour
 * offset from GMT.
 <p>
 * <li> <em>minute</em> offset: a long integer representing the time zone's
 * minute offset from GMT.
 *
 * </ul> <p>
 * To illustrate the time zone offset, a value of <code>-05:00</code> would
 * correspond to USA Eastern Standard Time.  In the {@link Date} object, this would
 * require a value of <code>1</code> for the sign field, <code>5</code> for the hour offset and
 * <code>0</code> for the minutes offset.
 <p>
 * In the restricted RDF annotations used in SBML, described in
 * Section&nbsp;6 of the SBML Level&nbsp;2 and Level&nbsp;3 specification
 * documents, date/time stamps can be used to indicate the time of
 * creation and modification of a model.  The following SBML model fragment
 * illustrates this:
<pre class='fragment'>
&lt;model metaid='_180340' id='GMO' name='Goldbeter1991_MinMitOscil'&gt;
    &lt;annotation&gt;
        &lt;rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
                 xmlns:dc='http://purl.org/dc/elements/1.1/'
                 xmlns:dcterms='http://purl.org/dc/terms/'
                 xmlns:vCard='http://www.w3.org/2001/vcard-rdf/3.0#' &gt;
            &lt;rdf:Description rdf:about='#_180340'&gt;
                &lt;dc:creator&gt;
                    &lt;rdf:Bag&gt;
                        &lt;rdf:li rdf:parseType='Resource'&gt;
                            &lt;vCard:N rdf:parseType='Resource'&gt;
                                &lt;vCard:Family&gt;Shapiro&lt;/vCard:Family&gt;
                                &lt;vCard:Given&gt;Bruce&lt;/vCard:Given&gt;
                            &lt;/vCard:N&gt;
                            &lt;vCard:EMAIL&gt;bshapiro@jpl.nasa.gov&lt;/vCard:EMAIL&gt;
                            &lt;vCard:ORG rdf:parseType='Resource'&gt;
                                &lt;vCard:Orgname&gt;NASA Jet Propulsion Laboratory&lt;/vCard:Orgname&gt;
                            &lt;/vCard:ORG&gt;
                        &lt;/rdf:li&gt;
                    &lt;/rdf:Bag&gt;
                &lt;/dc:creator&gt;
                &lt;dcterms:created rdf:parseType='Resource'&gt;
                    &lt;dcterms:W3CDTF&gt;2005-02-06T23:39:40+00:00&lt;/dcterms:W3CDTF&gt;
                &lt;/dcterms:created&gt;
                &lt;dcterms:modified rdf:parseType='Resource'&gt;
                    &lt;dcterms:W3CDTF&gt;2005-09-13T13:24:56+00:00&lt;/dcterms:W3CDTF&gt;
                &lt;/dcterms:modified&gt;
            &lt;/rdf:Description&gt;
        &lt;/rdf:RDF&gt;
    &lt;/annotation&gt;
&lt;/model&gt;
</pre>
 */

public class Date {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected Date(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(Date obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Date obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Date(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
   * Equality comparison method for Date.
   * <p>
   * Because the Java methods for libSBML are actually wrappers around code
   * implemented in C++ and C, certain operations will not behave as
   * expected.  Equality comparison is one such case.  An instance of a
   * libSBML object class is actually a <em>proxy object</em>
   * wrapping the real underlying C/C++ object.  The normal <code>==</code>
   * equality operator in Java will <em>only compare the Java proxy objects</em>,
   * not the underlying native object.  The result is almost never what you
   * want in practical situations.  Unfortunately, Java does not provide a
   * way to override <code>==</code>.
   *  <p>
   * The alternative that must be followed is to use the
   * <code>equals()</code> method.  The <code>equals</code> method on this
   * class overrides the default java.lang.Object one, and performs an
   * intelligent comparison of instances of objects of this class.  The
   * result is an assessment of whether two libSBML Java objects are truly 
   * the same underlying native-code objects.
   *  <p>
   * The use of this method in practice is the same as the use of any other
   * Java <code>equals</code> method.  For example,
   * <em>a</em><code>.equals(</code><em>b</em><code>)</code> returns
   * <code>true</code> if <em>a</em> and <em>b</em> are references to the
   * same underlying object.
   *
   * @param sb a reference to an object to which the current object
   * instance will be compared
   *
   * @return <code>true</code> if <code>sb</code> refers to the same underlying 
   * native object as this one, <code>false</code> otherwise
   */
  public boolean equals(Object sb)
  {
    if ( this == sb ) 
    {
      return true;
    }
    return swigCPtr == getCPtr((Date)(sb));
  }

  /**
   * Returns a hashcode for this Date object.
   *
   * @return a hash code usable by Java methods that need them.
   */
  public int hashCode()
  {
    return (int)(swigCPtr^(swigCPtr>>>32));
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   <p>
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   <p>
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as <code>2011.</code>  (Default value used if this
   * argument is not given: <code>2000.</code>)
   <p>
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value <code>1</code> represents January, and so
   * on.  (Default value used if this argument is not given: <code>1.</code>)
   <p>
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: <code>1.</code>)
   <p>
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: <code>0.</code>)
   <p>
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param sign a long integereger representing the sign of the offset
   * (<code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: <code>0.</code>)
   <p>
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the {@link Date} object,
   * this would require a value of <code>1</code> for the sign field, <code>5</code> for the
   * hour offset and <code>0</code> for the minutes offset.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 Date(long year, long month, long day, long hour, long minute, long second, long sign, long hoursOffset, long minutesOffset) {
    this(libsbmlJNI.new_Date__SWIG_0(year, month, day, hour, minute, second, sign, hoursOffset, minutesOffset), true);
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   <p>
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   <p>
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as <code>2011.</code>  (Default value used if this
   * argument is not given: <code>2000.</code>)
   <p>
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value <code>1</code> represents January, and so
   * on.  (Default value used if this argument is not given: <code>1.</code>)
   <p>
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: <code>1.</code>)
   <p>
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: <code>0.</code>)
   <p>
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param sign a long integereger representing the sign of the offset
   * (<code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: <code>0.</code>)
   <p>
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the {@link Date} object,
   * this would require a value of <code>1</code> for the sign field, <code>5</code> for the
   * hour offset and <code>0</code> for the minutes offset.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 Date(long year, long month, long day, long hour, long minute, long second, long sign, long hoursOffset) {
    this(libsbmlJNI.new_Date__SWIG_1(year, month, day, hour, minute, second, sign, hoursOffset), true);
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   <p>
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   <p>
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as <code>2011.</code>  (Default value used if this
   * argument is not given: <code>2000.</code>)
   <p>
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value <code>1</code> represents January, and so
   * on.  (Default value used if this argument is not given: <code>1.</code>)
   <p>
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: <code>1.</code>)
   <p>
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: <code>0.</code>)
   <p>
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param sign a long integereger representing the sign of the offset
   * (<code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: <code>0.</code>)
   <p>
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the {@link Date} object,
   * this would require a value of <code>1</code> for the sign field, <code>5</code> for the
   * hour offset and <code>0</code> for the minutes offset.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 Date(long year, long month, long day, long hour, long minute, long second, long sign) {
    this(libsbmlJNI.new_Date__SWIG_2(year, month, day, hour, minute, second, sign), true);
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   <p>
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   <p>
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as <code>2011.</code>  (Default value used if this
   * argument is not given: <code>2000.</code>)
   <p>
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value <code>1</code> represents January, and so
   * on.  (Default value used if this argument is not given: <code>1.</code>)
   <p>
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: <code>1.</code>)
   <p>
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: <code>0.</code>)
   <p>
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param sign a long integereger representing the sign of the offset
   * (<code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: <code>0.</code>)
   <p>
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the {@link Date} object,
   * this would require a value of <code>1</code> for the sign field, <code>5</code> for the
   * hour offset and <code>0</code> for the minutes offset.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 Date(long year, long month, long day, long hour, long minute, long second) {
    this(libsbmlJNI.new_Date__SWIG_3(year, month, day, hour, minute, second), true);
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   <p>
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   <p>
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as <code>2011.</code>  (Default value used if this
   * argument is not given: <code>2000.</code>)
   <p>
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value <code>1</code> represents January, and so
   * on.  (Default value used if this argument is not given: <code>1.</code>)
   <p>
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: <code>1.</code>)
   <p>
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: <code>0.</code>)
   <p>
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param sign a long integereger representing the sign of the offset
   * (<code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: <code>0.</code>)
   <p>
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the {@link Date} object,
   * this would require a value of <code>1</code> for the sign field, <code>5</code> for the
   * hour offset and <code>0</code> for the minutes offset.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 Date(long year, long month, long day, long hour, long minute) {
    this(libsbmlJNI.new_Date__SWIG_4(year, month, day, hour, minute), true);
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   <p>
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   <p>
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as <code>2011.</code>  (Default value used if this
   * argument is not given: <code>2000.</code>)
   <p>
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value <code>1</code> represents January, and so
   * on.  (Default value used if this argument is not given: <code>1.</code>)
   <p>
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: <code>1.</code>)
   <p>
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: <code>0.</code>)
   <p>
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param sign a long integereger representing the sign of the offset
   * (<code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: <code>0.</code>)
   <p>
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the {@link Date} object,
   * this would require a value of <code>1</code> for the sign field, <code>5</code> for the
   * hour offset and <code>0</code> for the minutes offset.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 Date(long year, long month, long day, long hour) {
    this(libsbmlJNI.new_Date__SWIG_5(year, month, day, hour), true);
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   <p>
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   <p>
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as <code>2011.</code>  (Default value used if this
   * argument is not given: <code>2000.</code>)
   <p>
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value <code>1</code> represents January, and so
   * on.  (Default value used if this argument is not given: <code>1.</code>)
   <p>
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: <code>1.</code>)
   <p>
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: <code>0.</code>)
   <p>
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param sign a long integereger representing the sign of the offset
   * (<code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: <code>0.</code>)
   <p>
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the {@link Date} object,
   * this would require a value of <code>1</code> for the sign field, <code>5</code> for the
   * hour offset and <code>0</code> for the minutes offset.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 Date(long year, long month, long day) {
    this(libsbmlJNI.new_Date__SWIG_6(year, month, day), true);
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   <p>
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   <p>
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as <code>2011.</code>  (Default value used if this
   * argument is not given: <code>2000.</code>)
   <p>
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value <code>1</code> represents January, and so
   * on.  (Default value used if this argument is not given: <code>1.</code>)
   <p>
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: <code>1.</code>)
   <p>
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: <code>0.</code>)
   <p>
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param sign a long integereger representing the sign of the offset
   * (<code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: <code>0.</code>)
   <p>
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the {@link Date} object,
   * this would require a value of <code>1</code> for the sign field, <code>5</code> for the
   * hour offset and <code>0</code> for the minutes offset.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 Date(long year, long month) {
    this(libsbmlJNI.new_Date__SWIG_7(year, month), true);
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   <p>
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   <p>
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as <code>2011.</code>  (Default value used if this
   * argument is not given: <code>2000.</code>)
   <p>
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value <code>1</code> represents January, and so
   * on.  (Default value used if this argument is not given: <code>1.</code>)
   <p>
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: <code>1.</code>)
   <p>
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: <code>0.</code>)
   <p>
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param sign a long integereger representing the sign of the offset
   * (<code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: <code>0.</code>)
   <p>
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the {@link Date} object,
   * this would require a value of <code>1</code> for the sign field, <code>5</code> for the
   * hour offset and <code>0</code> for the minutes offset.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 Date(long year) {
    this(libsbmlJNI.new_Date__SWIG_8(year), true);
  }

  
/**
   * Creates a time and date representation for use in model annotations
   * and elsewhere.
   <p>
   * The following is the complete set of possible arguments to this
   * constructor, with default values as indicated:
   <p>
   * @param year a long integereger representing the year.  This should be
   * a four-digit number such as <code>2011.</code>  (Default value used if this
   * argument is not given: <code>2000.</code>)
   <p>
   * @param month a long integereger representing the month, with a range
   * of values of 1&ndash;12.  The value <code>1</code> represents January, and so
   * on.  (Default value used if this argument is not given: <code>1.</code>)
   <p>
   * @param day a long integereger representing the day of the month, with
   * a range of values of 1&ndash;31.  (Default value used if this argument
   * is not given: <code>1.</code>)
   <p>
   * @param hour a long integereger representing the hour on a 24-hour
   * clock, with a range of values of 0&ndash;23.  (Default value used if
   * this argument is not given: <code>0.</code>)
   <p>
   * @param minute a long integereger representing the minute, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param second a long integereger representing the second, with a
   * range of 0&ndash;59.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param sign a long integereger representing the sign of the offset
   * (<code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-</code>).  See the paragraph
   * below for further explanations.  (Default value used if this argument
   * is not given: <code>0.</code>)
   <p>
   * @param hoursOffset a long integereger representing the time zone's
   * hour offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * @param minutesOffset a long integereger representing the time zone's
   * minute offset from GMT.  (Default value used if this argument is not
   * given: <code>0.</code>)
   <p>
   * To illustrate the time zone offset, a value of <code>-05:00</code>
   * would correspond to USA Eastern Standard Time.  In the {@link Date} object,
   * this would require a value of <code>1</code> for the sign field, <code>5</code> for the
   * hour offset and <code>0</code> for the minutes offset.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 Date() {
    this(libsbmlJNI.new_Date__SWIG_9(), true);
  }

  
/**
   * Creates a {@link Date} object from a string expressing a date and time value.
   <p>
   * This constructor expects its argument to be in the <a target='_blank'
   * href='http://www.w3.org/TR/NOTE-datetime'>W3C date format with time
   * zone offset</a>, used in RDF Dublin Core annotations within SBML.
   <p>
   * <p>
 * The date format expresses a date and time value as a string of the form
 * YYYY-MM-DDThh:mm:ssXHH:ZZ, where
 <p>
 * <ul>
 * <li> <em>YYYY</em> is a four-digit integer representing the year.  This
 * should be a four-digit number such as <code>2011.</code>
 <p>
 * <li> <em>MM</em> is a two-digit integer representing the month, with a range
 * of values of 01&ndash;12.  The value <code>1</code> represents January, and so
 * on.
 <p>
 * <li> <em>DD</em> is a two-digit integer representing the day of the month,
 * with a range of values of 01&ndash;31.
 <p>
 * <li> <em>hh</em> is a two-digit integer representing the hour on a 24-hour
 * clock, with a range of values of 00&ndash;23.
 <p>
 * <li> <em>mm</em> is a two-digit integer representing the minute, with a
 * range of 00&ndash;59.
 <p>
 * <li> <em>ss</em> is a two-digit integer representing the second, with a
 * range of 0&ndash;59.
 <p>
 * <li> <em>X</em> is the the sign of the time zone offset, either <code>+</code> or
 * <code>-</code>.
 <p>
 * <li> <em>HH</em> is a two-digit integer representing the hour of the time
 * zone offset, with a range of 00&ndash;23.
 <p>
 * <li> <em>ZZ</em> is a two-digit integer representing the minutes of the time
 * zone offset, with a range of 00&ndash;59.
 *
 * </ul> <p>
 * In the string format above, it is important not to forget the literal
 * character <code>T</code> in the string.  Here is an example date/time string:
 * <code>1997-07-16T19:20:30+01:00</code>, which would represent July 16,
 * 1997, at 19:20:30 in Central European Time (which is UTC +1:00). 
   <p>
   * If this constructor is given a <code>null</code> argument or a string of length
   * zero, it constructs a {@link Date} object with the value of January 1, 2000,
   * at time 00:00 UTC.  Otherwise, the argument <em>must</em> be in the
   * complete format described above, or unpredictable results will happen.
   <p>
   * @param date a string representing the date.
   */ public
 Date(String date) {
    this(libsbmlJNI.new_Date__SWIG_10(date), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link Date}.
   <p>
   * @param orig the object to copy.
   */ public
 Date(Date orig) {
    this(libsbmlJNI.new_Date__SWIG_11(Date.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link Date} object.
   <p>
   * @return the (deep) copy of this {@link Date} object.
   */ public
 Date cloneObject() {
    long cPtr = libsbmlJNI.Date_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Date(cPtr, true);
  }

  
/**
   * Returns the year from this {@link Date}.
   <p>
   * @return the year from this {@link Date}.
   */ public
 long getYear() {
    return libsbmlJNI.Date_getYear(swigCPtr, this);
  }

  
/**
   * Returns the month from this {@link Date}.
   <p>
   * @return the month from this {@link Date}.
   */ public
 long getMonth() {
    return libsbmlJNI.Date_getMonth(swigCPtr, this);
  }

  
/**
   * Returns the day from this {@link Date}.
   <p>
   * @return the day from this {@link Date}.
   */ public
 long getDay() {
    return libsbmlJNI.Date_getDay(swigCPtr, this);
  }

  
/**
   * Returns the hour from this {@link Date}.
   <p>
   * @return the hour from this {@link Date}.
   */ public
 long getHour() {
    return libsbmlJNI.Date_getHour(swigCPtr, this);
  }

  
/**
   * Returns the minute from this {@link Date}.
   <p>
   * @return the minute from this {@link Date}.
   */ public
 long getMinute() {
    return libsbmlJNI.Date_getMinute(swigCPtr, this);
  }

  
/**
   * Returns the seconds from this {@link Date}.
   <p>
   * @return the seconds from this {@link Date}.
   */ public
 long getSecond() {
    return libsbmlJNI.Date_getSecond(swigCPtr, this);
  }

  
/**
   * Returns the sign of the time zone offset from this {@link Date}.
   <p>
   * @return the sign of the offset from this {@link Date}.
   */ public
 long getSignOffset() {
    return libsbmlJNI.Date_getSignOffset(swigCPtr, this);
  }

  
/**
   * Returns the hours of the time zone offset from this {@link Date}.
   <p>
   * @return the hours of the offset from this {@link Date}.
   */ public
 long getHoursOffset() {
    return libsbmlJNI.Date_getHoursOffset(swigCPtr, this);
  }

  
/**
   * Returns the minutes of the time zone offset from this {@link Date}.
   <p>
   * @return the minutes of the offset from this {@link Date}.
   */ public
 long getMinutesOffset() {
    return libsbmlJNI.Date_getMinutesOffset(swigCPtr, this);
  }

  
/**
   * Returns the current {@link Date} value in text-string form.
   <p>
   * The string returned will be in the <a target='_blank'
   * href='http://www.w3.org/TR/NOTE-datetime'>W3C date format with time
   * zone offset</a>, used in RDF Dublin Core annotations within SBML.
   <p>
   * <p>
 * The date format expresses a date and time value as a string of the form
 * YYYY-MM-DDThh:mm:ssXHH:ZZ, where
 <p>
 * <ul>
 * <li> <em>YYYY</em> is a four-digit integer representing the year.  This
 * should be a four-digit number such as <code>2011.</code>
 <p>
 * <li> <em>MM</em> is a two-digit integer representing the month, with a range
 * of values of 01&ndash;12.  The value <code>1</code> represents January, and so
 * on.
 <p>
 * <li> <em>DD</em> is a two-digit integer representing the day of the month,
 * with a range of values of 01&ndash;31.
 <p>
 * <li> <em>hh</em> is a two-digit integer representing the hour on a 24-hour
 * clock, with a range of values of 00&ndash;23.
 <p>
 * <li> <em>mm</em> is a two-digit integer representing the minute, with a
 * range of 00&ndash;59.
 <p>
 * <li> <em>ss</em> is a two-digit integer representing the second, with a
 * range of 0&ndash;59.
 <p>
 * <li> <em>X</em> is the the sign of the time zone offset, either <code>+</code> or
 * <code>-</code>.
 <p>
 * <li> <em>HH</em> is a two-digit integer representing the hour of the time
 * zone offset, with a range of 00&ndash;23.
 <p>
 * <li> <em>ZZ</em> is a two-digit integer representing the minutes of the time
 * zone offset, with a range of 00&ndash;59.
 *
 * </ul> <p>
 * In the string format above, it is important not to forget the literal
 * character <code>T</code> in the string.  Here is an example date/time string:
 * <code>1997-07-16T19:20:30+01:00</code>, which would represent July 16,
 * 1997, at 19:20:30 in Central European Time (which is UTC +1:00). 
   <p>
   * @return the date as a string.
   */ public
 String getDateAsString() {
    return libsbmlJNI.Date_getDateAsString(swigCPtr, this);
  }

  
/**
   * Sets the value of the year of this {@link Date} object.
   <p>
   * The value given as argument must be between 1000 and 9999 inclusive.
   * (In the millennium during which this libSBML documentation is being
   * written, a typical value is <code>2011</code>, but we hope that SBML will
   * continue to be used for a long time.)
   <p>
   * @param year a long integer representing the year.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * </ul>
   */ public
 int setYear(long year) {
    return libsbmlJNI.Date_setYear(swigCPtr, this, year);
  }

  
/**
   * Sets the value of the month of this {@link Date} object.
   <p>
   * @param month a long integer representing the month; it must be in the
   * range 1&ndash;12 or an error will be signaled.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * </ul>
   */ public
 int setMonth(long month) {
    return libsbmlJNI.Date_setMonth(swigCPtr, this, month);
  }

  
/**
   * Sets the value of the day of this {@link Date} object.
   <p>
   * @param day a long integer representing the day; it must be in the
   * range 0&ndash;31 or an error will be signaled.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * </ul>
   */ public
 int setDay(long day) {
    return libsbmlJNI.Date_setDay(swigCPtr, this, day);
  }

  
/**
   * Sets the value of the hour of this {@link Date} object.
   <p>
   * @param hour a long integer representing the hour to set; it must be
   * in the range 0&ndash;23 or an error will be signaled.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * </ul>
   */ public
 int setHour(long hour) {
    return libsbmlJNI.Date_setHour(swigCPtr, this, hour);
  }

  
/**
   * Sets the value of the minute of this {@link Date} object.
   <p>
   * @param minute a long integer representing the minute to set; it must
   * be in the range 0&ndash;59 or an error will be signaled.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * </ul>
   */ public
 int setMinute(long minute) {
    return libsbmlJNI.Date_setMinute(swigCPtr, this, minute);
  }

  
/**
   * Sets the value of the second of the {@link Date} object.
   <p>
   * @param second a long integer representing the seconds; it must
   * be in the range 0&ndash;59 or an error will be signaled.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * </ul>
   */ public
 int setSecond(long second) {
    return libsbmlJNI.Date_setSecond(swigCPtr, this, second);
  }

  
/**
   * Sets the value of the sign of the time zone offset of this {@link Date} object.
   <p>
   * The only permissible values are <code>0</code> and <code>1.</code>
   <p>
   * @param sign a long integer representing the sign of the offset, with
   * <code>0</code> signifying <code>+</code> and <code>1</code> signifying <code>-.</code>
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * </ul>
   */ public
 int setSignOffset(long sign) {
    return libsbmlJNI.Date_setSignOffset(swigCPtr, this, sign);
  }

  
/**
   * Sets the value of this {@link Date} object's time zone hour offset.
   <p>
   * @param hoursOffset a long integer representing the hours of the
   * offset; it must be in the range 0&ndash;23 or an error will be
   * signaled.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * </ul>
   */ public
 int setHoursOffset(long hoursOffset) {
    return libsbmlJNI.Date_setHoursOffset(swigCPtr, this, hoursOffset);
  }

  
/**
   * Sets the value of this {@link Date} object's time zone minutes offset.
   <p>
   * @param minutesOffset a long integer representing the minutes of the
   * offset; it must be in the range 0&ndash;59 or an error will be
   * signaled.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * </ul>
   */ public
 int setMinutesOffset(long minutesOffset) {
    return libsbmlJNI.Date_setMinutesOffset(swigCPtr, this, minutesOffset);
  }

  
/**
   * Sets the value of this {@link Date} object using a date and time value
   * expressed as a text string.
   <p>
   * This method expects its argument to be in the <a target='_blank'
   * href='http://www.w3.org/TR/NOTE-datetime'>W3C date format with time
   * zone offset</a>, used in RDF Dublin Core annotations within SBML.
   <p>
   * <p>
 * The date format expresses a date and time value as a string of the form
 * YYYY-MM-DDThh:mm:ssXHH:ZZ, where
 <p>
 * <ul>
 * <li> <em>YYYY</em> is a four-digit integer representing the year.  This
 * should be a four-digit number such as <code>2011.</code>
 <p>
 * <li> <em>MM</em> is a two-digit integer representing the month, with a range
 * of values of 01&ndash;12.  The value <code>1</code> represents January, and so
 * on.
 <p>
 * <li> <em>DD</em> is a two-digit integer representing the day of the month,
 * with a range of values of 01&ndash;31.
 <p>
 * <li> <em>hh</em> is a two-digit integer representing the hour on a 24-hour
 * clock, with a range of values of 00&ndash;23.
 <p>
 * <li> <em>mm</em> is a two-digit integer representing the minute, with a
 * range of 00&ndash;59.
 <p>
 * <li> <em>ss</em> is a two-digit integer representing the second, with a
 * range of 0&ndash;59.
 <p>
 * <li> <em>X</em> is the the sign of the time zone offset, either <code>+</code> or
 * <code>-</code>.
 <p>
 * <li> <em>HH</em> is a two-digit integer representing the hour of the time
 * zone offset, with a range of 00&ndash;23.
 <p>
 * <li> <em>ZZ</em> is a two-digit integer representing the minutes of the time
 * zone offset, with a range of 00&ndash;59.
 *
 * </ul> <p>
 * In the string format above, it is important not to forget the literal
 * character <code>T</code> in the string.  Here is an example date/time string:
 * <code>1997-07-16T19:20:30+01:00</code>, which would represent July 16,
 * 1997, at 19:20:30 in Central European Time (which is UTC +1:00). 
   <p>
   * If this method is given a <code>null</code> argument or a string of length zero,
   * it constructs a {@link Date} object with the value of January 1, 2000, at time
   * 00:00 UTC.  Otherwise, the argument <em>must</em> be in the complete format
   * described above, or unpredictable results will happen.
   <p>
   * @param date a string representing the date.
   <p>
   * <p>
 * @return integer value indicating success/failure of the
 * function.   The possible values
 * returned by this function are:
   * <ul>
   * <li> {@link libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS}
   * <li> {@link libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE}
   * </ul>
   */ public
 int setDateAsString(String date) {
    return libsbmlJNI.Date_setDateAsString(swigCPtr, this, date);
  }

  
/**
   * Returns true or false depending on whether this date object represents
   * a valid date and time value.
   <p>
   * This method verifies that the date/time value stored in this object is
   * well-formed and represents plausible values.  A time and date value in
   * the W3C format takes the form YYYY-MM-DDThh:mm:ssXHH:ZZ (e.g.,
   * <code>1997-07-16T19:20:30+01:00</code>) where XHH:ZZ is the time zone
   * offset.  This method checks such things as whether the value of the
   * month number is less than or equal to 12, whether the value of the
   * minutes number is less than or equal to 59, whether a time zone offset
   * is set, etc.
   <p>
   * @return <code>true</code> if the date is valid, <code>false</code> otherwise.
   */ public
 boolean representsValidDate() {
    return libsbmlJNI.Date_representsValidDate(swigCPtr, this);
  }

  
/** * @internal */ public
 boolean hasBeenModified() {
    return libsbmlJNI.Date_hasBeenModified(swigCPtr, this);
  }

  
/** * @internal */ public
 void resetModifiedFlags() {
    libsbmlJNI.Date_resetModifiedFlags(swigCPtr, this);
  }

}
