---
name: Bug report
about: Create a report to help us improve
title: ''
labels: Reported bug
assignees: ''

---

**Describe the bug**
A clear and concise description of what the bug is.

**Version information**
1. The version of the TwelveMonkeys ImageIO library in use.
For example:  4.0.0

2. The *exact* output of `java --version` (or `java -version` for older Java releases). 
For example: 

    java version "1.8.0_271"
    Java(TM) SE Runtime Environment (build 1.8.0_271-b09)
    Java HotSpot(TM) 64-Bit Server VM (build 25.271-b09, mixed mode)

3. Extra information about OS version, server version, standalone program or web application packaging, executable wrapper, etc. Please state exact version numbers where applicable.

**To Reproduce**
Steps to reproduce the behavior:

1. Compile the below sample code
2. Download the sample image file
3. Run the code with the sample file
4. See error

**Expected behavior**
A clear and concise description of what you expected to happen.

**Example code**
Preferably as a failing JUnit test, or a standalone program with a `main` method that showcases the problem. 

Less is more. Don't add your entire project, only the code required to reproduce the problem. 😀 

**Sample file(s)**
Attach any sample files needed to reproduce the problem. Use a ZIP-file if the format is not directly supported by GitHub.

**Stak trace**
Always include the stack trace you experience.

**Screenshots**
If applicable, add screenshots to help explain your problem.
Do not add screenshots of code or stack traces. 😀 

**Additional context**
Add any other context about the problem here.
