# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.plot import Plot


class PlotRangeHandlesItem(Plot):
    r"""
    PlotRangeHandlesItem - item to show and control a range on Axis
    
    Superclass: Plot
    
    PlotRangeHandlesItem provides range handles painting and
    management for a provided extent. Handles can be moved by clicking on
    them. The range is shown when hovering or moving the handles. It
    emits a start_interaction_event when starting to interact with a
    handle, an interaction_event when interacting with a handle and an
    end_interaction_event when releasing a handle. It emits a
    left_mouse_button_double_click_event when double clicked. Options can be
    used to change the appearence or behavior of handles:
    - synchronize_handles_range: When enabled, moving the minimum handle
      triggers the modification of the whole range, resulting in the
      maximum handle being moved too. Disabled by default.
    - Orientation: Choose between horizontal (Y axis) or vertical (X
      axis) handles. Default is vertical.
    - extent_to_axis: When enabled, the height of handles span the range of
    the opposite axis. If disabled, the height of handles is defined by
      the provided extent. Enabled by default.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPlotRangeHandlesItem, obj, update, **traits)
    
    extent_to_axis_range = tvtk_base.true_bool_trait(desc=\
        r"""
        Set/Get whether handles span the range of the axis. Default is
        On.
        """
    )

    def _extent_to_axis_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtentToAxisRange,
                        self.extent_to_axis_range_)

    lock_tooltip_to_mouse = tvtk_base.true_bool_trait(desc=\
        r"""
        If On, the range tooltip is always rendered using mouse position,
        otherwise it is placed at the center of the x axis Default is On.
        """
    )

    def _lock_tooltip_to_mouse_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLockTooltipToMouse,
                        self.lock_tooltip_to_mouse_)

    synchronize_range_handles = tvtk_base.false_bool_trait(desc=\
        r"""
        Set/Get whether handles move together when one of them is update.
        Default is Off.
        """
    )

    def _synchronize_range_handles_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSynchronizeRangeHandles,
                        self.synchronize_range_handles_)

    handle_orientation = tvtk_base.RevPrefixMap({'vertical': 0, 'horizontal': 1}, default_value='vertical', desc=\
        r"""
        Set/Get the handles orientation in the plot.
        """
    )

    def _handle_orientation_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHandleOrientation,
                        self.handle_orientation_)

    extent = traits.Array(enter_set=True, auto_set=False, shape=(4,), dtype="float", value=(0.0, 1.0, 0.0, 1.0), cols=3, desc=\
        r"""
        Set/Get the extent of the handles in data space (axis unscaled
        range). The first two parameters define the left and right
        handles positions on the axis. The last two parameters define the
        length of handles along the opposite axis. Default values are set
        to (0, 1, 0, 1). When using extent_to_axis_range_on(), the last two
        parameters don't have any effect and handles span the axis range.
        """
    )

    def _extent_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetExtent,
                        self.extent)

    handle_width = traits.Float(2.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the handles width in pixels. Default is 2.
        """
    )

    def _handle_width_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHandleWidth,
                        self.handle_width)

    def get_handles_range(self, *args):
        """
        get_handles_range(self, range:[float, float]) -> None
        C++: virtual void get_handles_range(double range[2])
        Recover the range currently set by the handles Use this method by
        observing end_interaction_event
        """
        ret = self._wrap_call(self._vtk_obj.GetHandlesRange, *args)
        return ret

    def _get_highlight_brush(self):
        return wrap_vtk(self._vtk_obj.GetHighlightBrush())
    highlight_brush = traits.Property(_get_highlight_brush, desc=\
        r"""
        Return the brush used to paint handles being hovered
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input table used by the plot.
        """
    )

    def compute_handles_draw_range(self):
        """
        compute_handles_draw_range(self) -> None
        C++: virtual void compute_handles_draw_range()
        Compute the handles draw range by using the handle width and the
        transfer function
        """
        ret = self._vtk_obj.ComputeHandlesDrawRange()
        return ret
        

    _updateable_traits_ = \
    (('extent_to_axis_range', 'GetExtentToAxisRange'),
    ('lock_tooltip_to_mouse', 'GetLockTooltipToMouse'),
    ('synchronize_range_handles', 'GetSynchronizeRangeHandles'),
    ('legend_visibility', 'GetLegendVisibility'), ('selectable',
    'GetSelectable'), ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('handle_orientation',
    'GetHandleOrientation'), ('extent', 'GetExtent'), ('handle_width',
    'GetHandleWidth'), ('label', 'GetLabel'), ('tooltip_label_format',
    'GetTooltipLabelFormat'), ('tooltip_notation', 'GetTooltipNotation'),
    ('tooltip_precision', 'GetTooltipPrecision'),
    ('use_index_for_x_series', 'GetUseIndexForXSeries'), ('width',
    'GetWidth'), ('opacity', 'GetOpacity'), ('interactive',
    'GetInteractive'), ('visible', 'GetVisible'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'extent_to_axis_range', 'global_warning_display',
    'legend_visibility', 'lock_tooltip_to_mouse', 'selectable',
    'synchronize_range_handles', 'handle_orientation', 'extent',
    'handle_width', 'interactive', 'label', 'object_name', 'opacity',
    'tooltip_label_format', 'tooltip_notation', 'tooltip_precision',
    'use_index_for_x_series', 'visible', 'width'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PlotRangeHandlesItem, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PlotRangeHandlesItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['extent_to_axis_range', 'legend_visibility',
            'lock_tooltip_to_mouse', 'selectable', 'synchronize_range_handles'],
            ['handle_orientation'], ['extent', 'handle_width', 'interactive',
            'label', 'object_name', 'opacity', 'tooltip_label_format',
            'tooltip_notation', 'tooltip_precision', 'use_index_for_x_series',
            'visible', 'width']),
            title='Edit PlotRangeHandlesItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PlotRangeHandlesItem properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

