/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "stl.h"

#include <Metview.h>


#ifndef VariableTask_H
#include "VariableTask.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Log_H
#include "Log.h"
#endif


#ifndef Request_H
#include "Request.h"
#endif

#ifndef Service_H
#include "Service.h"
#endif
#ifndef Action_H
#include "Action.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif
#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef VariableEditor_H
#include "VariableEditor.h"
#endif


#ifndef TempIconClass_H
#include "TempIconClass.h"
#endif

//=================================================================

VariableTask::VariableTask(VariableEditor& editor,const string& service,const Request& request):
	service_(service),
	request_(request),
	editor_(editor),
	class_(0)
{
}

VariableTask::~VariableTask()
{
	delete class_;
}

void VariableTask::start()
{
	callService(service_,request_);
}

void VariableTask::reply(const Request& r,int err)
{
	if(err)
	{
		editor_.fail();
	}
	else
	{
		class_ = new TempIconClass(r,&editor_.iconClass());  
		editor_.reply(*class_);
	}
}

void VariableTask::progress(const Request& r)
{
}

void VariableTask::message(const string& msg)
{
	//static string cr("\n");
	//if(!stopped_) {
		//editor_.progress(msg);
		//editor_.progress(cr);
	//}
}

void VariableTask::print(ostream& s) const
{
}

