(* Copyright 2007, spiralvoice *)
(*
    This file is part of mldonkey.

    mldonkey is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    mldonkey is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with mldonkey; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*)

(*
    flags are converted from png files taken from

      http://flags.blogpotato.de
      world.small.zip, special.zip (EU flag), gb.small.zip (Isle of Man)

      black image for "--" was made by spiralvoice ;-)
*)

open Options
open CommonOptions

let files = Hashtbl.create 300

let flag_html cc =
  let filename = Printf.sprintf "flag_%s.png" (String.lowercase cc) in
  if !!html_flags && Hashtbl.mem files filename then
    Printf.sprintf "\\<img src=\\\"%s\\\" alt=\\\"%s\\\"\\>" filename cc
  else
    cc

let compute_ocaml_code dir output =
  let code_string = ref "" in
  List.iter (fun f ->
    let f = Filename.concat dir f in
    code_string := !code_string ^ (
    Printf.sprintf "\n  Hashtbl.add %s \"%s\" \"%s\";\n"
      (List.hd (List.rev (Filename2.path_of_filename dir))) f
      (String.escaped (File.to_string f)))
  ) (Unix2.list_directory dir);
  ignore (File.from_string output !code_string)


let _ =

  Hashtbl.add files "favicon.ico" "\000\000\001\000\001\000\016\016\000\000\001\000 \000h\004\000\000\022\000\000\000(\000\000\000\016\000\000\000 \000\000\000\001\000 \000\000\000\000\000@\004\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\000\000\000\031\000\000\0000\000\000\000E\000\000\000R\000\000\0008\000\000\000&\000\000\000\015\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\000\000\000\015\000\000\000&\000\000\000.\000\000\000&\000\000\000\168\000\000\000\194\000\000\000^\000\000\000$\000\000\0000\000\000\000\015\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\000\000\000\008\000\000\000G\000\000\000k\000\000\0000\000\000\000z\000\000[\255\000\000\132\255\000\000\000\176\000\000\0000\000\000\000k\000\000\000W\000\000\000\015\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\000\000\000=\000\000\000c\000\000\000\128\000\000\000=\026\026h\255\000\000\148\255\000\000\160\255\000\000_\255\000\000\000z\000\000\000x\000\000\000k\000\000\000O\000\000\000\015\255\255\255\000\255\255\255\000\000\000\000\031\000\000\000\148\000\000\000^\000\000\000\015\000\000\0000\000\000m\255\000\000z\255\000\000I\255\000\000\152\255\000\000\000p\000\000\000\015\000\000\000G\000\000\000\148\000\000\000.\255\255\255\000\000\000\000\015\000\000\000k\000\000\000\199\000\000\000\028\255\255\255\000\000\000\000i\000\000\139\255\011\011w\255\000\000\000\143\025D\153\255\007\007n\255\000\000\000\015\000\000\000\015\000\000\000\171\000\000\000\138\000\000\000\028\000\000\000.\000\000\000\199\000\000\000\171\000\000\000\008\000\000\000\023\000\000w\255\000\000\144\255\000\000\000W\000\000\000;\000\000\148\255\000\000\137\255\000\000\000=\255\255\255\000\000\000\000i\000\000\000\217\000\000\0003\000\000\000=\027\027\027\255\000\000\000x\255\255\255\000\000\000\000=\000\000\139\255\005\n\135\255\000\000\000!\000\000\000\015\000\000\139\255\000\000\164\255\000\000\000f\255\255\255\000\000\000\000O\026\026\026\255\000\000\000R\000\000\0008\000\000\000\199232\255\000\000\000+\000\000\000i\000\000\147\255\000\000\000i\000\000\000!\000\000\000\028\000\000\000Y\000\000\154\255\000\000\147\255\000\000\0000\000\000\000\171\000\000\000\217\000\000\000G\000\000\000$\000\000\000\138\000\000\000\194\000\000\000i\000\000\152\255\000\000\146\255\000\000\136\255\002\002\150\255\005\005\155\255\015\031\131\255\000\000\140\255\000\000\152\255\000\000\000i\000\000\000\191\000\000\000\150\000\000\000&\000\000\000\015\000\000\000G\000\000\000\150\000\000\161\255\000\000\142\255\n\n\184\255\002\002\173\255\000\000\157\255\000\000\160\255\000\000\168\255\000\000\185\255\000\000\139\255\000\000\159\255\000\000\000\150\000\000\000W\000\000\000\015\000\000\000\028\000\000\000=\000\000\181\255\000\000\139\255\000\000\191\255\000\000\000\026\000\000\000\026\000\000\0003\000\000\0008\000\000\000!\164\132\164M\002\002\187\255\000\000\131\255\000\000\181\255\000\000\000=\000\000\000\028\000\000\000\031\000\000\199\255\000\000\132\255\000\000\196\255\164\132\164n\000\000\0003\000\000\000\015\000\000\0003\000\000\0003\000\000\000\023\000\000\000)\164\132\164u\000\000\189\255\000\000\131\255\000\000\198\255\000\000\000\031\000\000\000&\030\030\194\255\t\t\199\255\000\000\0003\000\000\0003\000\000\000\028\000\000\000&\000\000\000R\000\000\000c\000\000\000$\000\000\000\028\000\000\0003\000\000\0003\t\t\197\255\030\030\195\255\000\000\000&\000\000\000\008\000\000\000\015\000\000\000\015\000\000\000\008\000\000\000\015\000\000\000)\000\000\0000\000\000\000B\000\000\000E\000\000\0003\000\000\000)\000\000\000\015\000\000\000\015\000\000\000\015\000\000\000\015\000\000\000\008\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\255\255\255\000\248\015\255\255\224\007\255\255\192\003\255\255\192\001\255\255\128\001\255\255\008\000\255\255\000\008\255\255\016\008\255\255\000\000\255\255\000\000\255\255\000\000\255\255\000\000\255\255\000\000\255\255\000\000\255\255\000\000\255\255\255\255\255\255";

  Hashtbl.add files "flag_--.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\000\027IDAT(\145cd``\248\207@\005\192D\013CF\013\0265h\248\026\004\000\145A\001\023l\174\136\154\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_eu.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\138IDATx\218b\1486\172\209PS\1785S\230\229\225\250\247\159\153\129\129\233\255\127&F\006\198\255\255\025\025\024@\020\016\131\016\195_F\198\127\159\191|;r\250\206\141\155\247\000\002\136\229\195W\166\189\199\158\026\233)j\168\24223\129\180\177\179\254\253\253\135ED\224\211\215\031\156?~\17800\252\255\251\015h\196\191\191\255\254\158\189\252\025\168\152\155\131\t \128XX\152\217\024\024\152\143\156~\196\198\202\196\202\194\202\240\159\201P\249\193\147\215\226\175^\252\253\246\139]J\248\237\143_,\015\159\1371\176\252\254\253\231\015P\025\003\003P\011#@\0001\242k\244\127\252\0022LN\138WZ\236\171\137\210\131=\023\181~\255e\249\247\135\153\129\145\129\131\2377\208Z\013\153g\251/\169\255\252\253\255\209\147/@\231\240s\255\007\008 \150\255\255\185\129\006\000U<z\246\255\245;\246\191?\184o>`\248\255\255/\003\195\031\160\223\024\2541\t\240\1770\252b\186\243\016(\200\196\192(\192\240\031\200\248\003\016@,\012\255y\025\0248\024\2543310\153h^\185\246\192\240\223\031N\006\230\127\012\016\192\196\240\254#\211\143\255\127d\197x\030=\227c`\006\154\005\148\250\001\016\128\007:\198\001\000\132A\000\008\210\250\255\023\139\212A\194N\184\226\003\203=,\170\208\018\220q\195\143\229\179AM\179\133!\190\002\008\232\188\175\012\140\191\025\024\153\25410\157\185&a\174~\246\213G\205\127\127\152\160\022\254b\017\023\255 +|\247\252-A\006\230w`\171\25410\254\002\008 \160m\223\024\024~\130\\\195\192\196\204\242KJ\240\149\188\024\255\235\143\188_\190p30\254\019\023y\199\204\248\247\223\191?\012,\159\025~32\252\007icd\252\011\016@\204\028b\246?~\003#\020h\025\227\207\223\236\151n\170\006\217\158\225dc\016\227\255\206\203\253'\192\234\244\187\207|\251O\234\253c\249\013\014\164_\012\012\1919\216~\002\004\016#\143z\227\151\239\028\012\140\156\012\012\236\160\176a\224dbbb\248\195f\161{\235\203w\158\027\015\196\2552\254\253\251\023h\201w`H\128\220\245\255;\015\231\015\128\000b\017\224\254\203\002\012X`\2000\178\254\255\015\138\250\255\255Y\025\025\152.\223\214ad\250\207\201\014\244\t0Y\001\173b\003\186\141\225\255/`j\227\225\248\011\016`\000\158\172\242\157[\144\248r\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ad.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\139IDATx\218bdP\247x`\174\175+\224hn\200\192\199\195\195\240\255/\019\003\195/N\134\180\128\019\012\012\191\025\024\024\2541@\000P\248?\015\003\195\147y`&\003\019##\195\239O\159\024^\238\223\207\240\226\228\201\015\000\001\196\194\192\200\"r\242\234mn;3]\006%Y\017\006f&\022\160Al\012\\|j\016\131\254C\013b\00429\025\024\132\213 \0061\252\253\203\240\225\236Y\134\031'O2\17630\176\000\004\016\011\195\127\214?\012\140L\012G\206_g`cca`ebe`\248\206\206\224fr\021a\208\127\136\139\024\128v|\185\na\254\255\253\155\225\221\145#`;\128\142\254\007\016@@\023q\000E\153\024\142_x\192\240\244\229'\006\022F\160\234\143\220\012Y~+\024\190\127ad\248\245\133\137\225/\208 6\142\127\012\\\210\255\025\158-\1308\240\255\159?\012_\031=\002\251\028h\031\011@\000\001]\196\005\020\005jf\252\199\240\232\249O\006\198\255\191\024\024>\179001\223gx\177\142\149\225\221Mf\006^\225\255\012\127e\2551\200\198\254a\248}\255?\196\161\255\255\131\029\n2\232/P7@\000A\012\002\249\018\236`F\160\002``0\0082p\252\250\207\240\143\245?\003\027\023#\003'0l~\17921\252\252\201\200\192\244\031\022\250\0120o\129\013\002\008 \022p(\1301\208 `L\128100X\129>\230\230\255\207\192\014\196\2559\152\025\254}\252\203\192.\242\143\129\021\162\01792\193\017\n\016@\1920\250\006\212\252\007\200\251\0151\004\026K, \130\027\232%\005\160\128\208o\134_?\2543\240}c\004\186\029\162\224/\003\".\152\129\024 \128\128\006}\007\026\240\011\234\026\144\241@\243\255\17810q30hy\252exv\251?\195\015\160\001\134:\127\025\152\196 \006\176@]\002\243\026\208 F\128\000\002\138}\135\250\144\025\130a\222\004\234`\006J\201JA=\241\011\020\229\016\141L\008U`\215\128h\128\000\002\186\232\0154\156\128\212\127`\008\252\007\006\252\127n\134\191\127\160n\255\011\181\154\025\020\229\016!\152k\144\164\152\000\002\008\024k\127\2220\252e\254\199\240\231?\196\240\127@?\254c\252\255\242%\208\244/\224T\001\138iF\176\213\192\000z\005q?8\161Cc\140\225\019\003\195O\128\000\003\000\229\127\205Up(\\\190\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ae.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\152IDATx\218b\156\199\192\240@\194\220\\@\210\209\145\129\159\143\143a\185\255\127\006\134\031\012\012\012\255\024\176\003F(\197\200\200\240\233\215'\134\253O\2473\156|r\242\003@\000\177\17630\136\2528y\146\155\213\206\142\129OI\137AM\128\153\129\225\023P\229\127\006\220\000h\216\223\255\127\025\206\190=\203p\242\243I\006\0066\006\022\128\000b\001\170\255\003\146{\127\228\008\003?\027\027\195U\003V\006\134\159x\\\004\005\191\255\253f8\242\234\008\196\133\255\024\254\001\004\016\203?\168\158\247\199\1433p=}\202\176\200\129\133\129\225\011\003\196U\184\000\200\246\255\127\024\030}~\004t\026\144\255\157\129\005 \128X\254B\013\250\013\196\015\031=b8e\248\134\129\024\240\239\223?0\254\243\231\015\195\219\183o\025\001\002\008\238\"f\024\013\244\030\227\127F\134\255\191\255c\t(F\176\216\255\255@\0124\132\225\239_\134\255\127\2542\252\249\249\143\017 \128X@RLP\012\002\172@\131\152\1291\242\143\021w \129\012\250\0114\2287\208\027\255\152\152\128\1503\253\007\008 \022\144KX\1450;33\003\019P\146\129\005\191\183\254\254e\002\186\015\228\178\191\012,@S\000\002\136\005\164\030\132\185\128X\nd\024++\003\025\128\017 \128@v\131\195\135\017\234\"r\001@\000\193=\001\n\145?\020\152\003\016@,\192\220\240\006\0247\255\128\1661\179C\194\156\017\026]\140\136T\131\147\013\003?\001\002\012\000\005+\136\148\147\137\215n\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_af.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002BIDATx\218bd``x`nn.\224\232\232\200\192\199\199\199\240\255\255\127\1344\006\252`\150\011\003\003\227OF\134O?>1\236\127\176\159\225\228\131\147\031\000\002\136\005(.r\242\228In;;;\006%%%\006fff\006.\002\006\169\13700\252\253\249\151\225\236\139\179\012'\223\156d``e`\001\008 \144A\127@\146G\142\028a`ccc`eeepC\214\197\202\206\192\192\001\196\159?\193\133\174*10\252\254\250\155\225\200\147#@\167\001\005\2541\252\003\008 \016\245\001\136\249A\n\228\228\228\024XXX\024N\1288@\205\255\245\205\025\024\255\002\237abb\248\255\239\031\003\227\133s@k\1270Xt\001\169w\127\024\030\189}\0041\249\011\195w\128\000bA\182\252\209\163G\012\140\140\140\012L \206\180e\012\012YQ\012\012O\15800\176\003]$*\202\192\208\015\020+\140b\184\255\154\129\225\255\183\255\016M\255\193\152\017 \128P\\\004\003\159\173\194\025\024\211\178\024\024.?e`\224\229``\184s\147\129AL\006\0248\242\012\255\231Mb\224\245]\195\000\014\200\223@\252\023\164\129\225'@\0001a\011L6.n\006V\160wX\247\204c`5\144c`\213\208a`\221\183\128\129\245?3\003\0277\031\003\216\201\204\012\016\154\017\140\255\003\004\016V\023\129,ax\243\134\129\193\204\150\225\191W4\003#\023+0\206\187\129.\188\206\192\160\"\202\192<\003(\255\013\136\127@\163\2343\195\015\128\000b\193\230\"\1763\227R\024\254\223\189\198\192x\2436\003#3PYg\025\003\131O\024\003\195O\160\156\000\212\016fh\024\001\221\004\016@,8\019\203\182\013\012\140\186&\192\184>\015T\252\143\129A\207\156\129\225\210ID\0003\192\189\005\198\000\001\196\008\142<\006\006nd3\254\016H\144,+\129\196[ \254\005\247\218o\128\000\002\185\232\0138I\193\130\015\024\255/YX\255\255\003\210\192\148\003\178\012\152i\192\246\002\021\000\153\191\25432\188\253\199\192\252\030\200\254\011\013\208\175\012?\001\002\012\000)'\1590:j\132d\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ag.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\002IDATx\218b\180\226\224~\240W_G\192\209\209\145\129\143\143\143\225\255\255\255\012\196\000FFF\134O\159>1\236\223\191\159\225\215\133\171\031\000\002\136e\n\175\160\136\209\153\179\220vvv\012JJJ\012\204\204\204p\197,,\140\012\252\130\140\012LL\255\025>\188c`\248\253\027a\201\223\191\127\025\206\158=\203p\242\204\025\134S\130\146,\000\001\196\242\148\145\241\207N\001\t\134\134cG\025\216\216\216\024XYY\193\n\197\196\152\024||\2553\240\243A4~\252\196\192\176};#\195\243g\255\192\252\223\191\1273\0289z\148a5\1918\195\027&\166\127\000\001\196\242\242\0313\13193\019\131\203\229;\012\011\031?\001\186\130\133\001\228\166\197K\024\0248\216\025\024~\254\132\024\004b\219\15230\132\13300|\255\203\192\240\231\207\031\006\159\247\223\024t8\249\024\014\254\251\203\002\016\128c9F\001\016\004\000(\250\203A)ih\240\140\157\161K\006]\1921h2\019\020DM\026\222\248\198\210\219\217\004\155\212\024W\177\247\140O\030m\"\021GH\207/7\199\180FB~\177\151B\249\198.\023\142~K\019\195'\128\024\167\011\171\127\224bd\230\231a\248\203\160\195\244\129!&\225&\195\031af\134\207\023~\002\189\195\002\012TH\184\252\255\207\200\192\195\251\135AH\159\157\225\031\208\144\165\243\012\025n\254ab\248\196\200\202\240\241\223\159\159\000\001\196\196\008\138\001\144\159\025\153\025\030\253\250\204\2089[\135\225\229;6\1347\191\127\002\003\249\003\003#\243G0fb\254\192\240\241\215\015\134\135\159\217\024Zf\1553\188\250\254\144\225'\019+X/\019\208\030\128\000baf\252\195\192\006\180\149\029(\242\147M\134\129\231\205-\134u\231\147\024\212\183/b\248\246\225\027\195\191?\127\193J\153\024\2543p\138\2400\220\142*g\248\254\230:\195\02315\006v\134?`\215\130\204\000\008 `\208\254c`\005b6\160A,\192\180\241GT\145\225\251\174\165\012\204;\163\024\164<\189\024\254\255\251\013I7@\219\127\158;\195\240}e\015\195\0311\005\006V\166?\012\140\1924\247\015\232sf\134\255\140\000\001\196\0046\141\241/\208\137\255\192\024\024(\012\127\005\164\025\246xy3|\253\249\139\225/\208\000\016\254\0054l\187\177)\195o\030q\160\003\153\224\234AzAf\000\004\016P\232\031\011(e\128\132\255\254g\002\198\014\016\003c\144\021\008\247\243I\130\019\030\008\239\021\211\000\133\005\195\031n\001\176\026\144Z\168\213@\131\2541\001\004\016\203\143\255\255\223\252\007z\000\232J\176\011\025A\241\004t\243?\017e\198\031on0\236\143\234\251\207\196'\206\248\232\245M\006\014\017\141\255L\255\254\129\020\000C\140\241?\200\016\160\231\024>\255\255\247\019 \192\000\170B\028?nj\016\133\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ai.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\240IDATx\218\000I\000\182\255\001\204kn\224\013;J\016\167\222\007\000\013\n\005\000^\025\234\000\000\255\002\000\160\232#\000\000\254\237\000V'\015\000\n$\012\000\160\181\242\000\000\000\252\000\000\001\254\000\001\000\253\000\001\001\253\000\243\242\244\000\196\196\214\000\204\204\215\240\002\136\197{\139\172\200d\1983\220yII\012\207U\248\024\216/\\```\225`p\210\147d\208\144\016e\248\252\139\151\225\232\141O\012\170\170\191\129\0061\002\241\127 \254\199\240\239\239_\134\011\023?1\156;\247\008h(\011\011@\0001^us\251\240\133\129\149_L\156\159A(\200\159\225\203\173\007`\013<rR\012\127\152\185\025~\190\255\200\192\205\203\1920\253\145,\196\028\176A\191\025\254\252\254\205p\248\240-\134\211\167\0312\252\251\207\240\025 \128X\024\255\252a\248\253\225'\195\031\001\001\134\031\219\1820|8{\013\164\154\129\213\211\129\225\203\249\235\012\127De\024X\248\025\024V\030Q\129\186\232\015\131\1535/\003?\191\000\131\180,+\003+\151(\195\225\253\031Y\000\002\136QXw\229\135M\173\214\252\202\2107\025\218\182\2433\212]\154\205\240\239\219K\134\217s\2310\164\031y\207p\236\228!\134\248\221\220\012\012\015\239\001\013\249\011\196o\025n\223*e\248\247o=\016\1712\252\249\163\197\160\173\211\250\003 \128\024ol\217\247\129\255\224S~\1419@\133l\230\012\143\221\183002\253f\144\217\232\196\192 \198\205\240t/\208%\235.1H7\000\003\251?3\208 v\134\199\015$\025\254}ea\248\251\238\019\195/\150?\012\234\230\143\127\002\004\016#\159@\195\007F\006y~`\136\001]\206\nt\252?hX0\001\241\027 \022\0062\217\129\225\251\013j\208;\134\139g\220\024DXv1\252\230sg\184q\2273\131\155\199\150\031\000\001\196\200/\208\241\129\145\145\141\159\017d\016\208\0040\005\006\255\208h&(\253\155\129\149\231;\195\175\155\021\012\012\191~1\176\168\2452\252\250\241\255\007@\000\17702|\006jg\1338\008j\024D\019\204D\024\253\031N\255\249\250\129A\194\189\141\225\255\143\191\012/\127~\007\n\1772\002\004\016\011\003\227W\160\001 /1\0031\011P\025+\212 f\176W\254C\013b\004\025\196\248\023\026\224\130\012\175\175\254`\248\255\255\015P/P\029\208\012\128\000\002\186\232'\011H#\200\128\255\255\129a\193\192\t\014P\136\129\204P\012r\007\208\128\255\192\020\205\000J\152?\129|\144e@\2150\252``b\252\205\004\016@,\255\255\255~\003\212\244\143\241\255\127f\160\157L\255AN`b\252\015Le\008\167\252Gb\195\028\007$A\017\243\159\225\023\195\255\127\223~\002\004\024\000\243y\001O\208\187\188\167\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_al.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\148IDATx\218b\156\195\165\248@\210\212P@\194\206\154\129\153\143\135\225\255?F\006\006\006F\134\255\012 \154\001\204\134\128\255P\222\1270\155\145\233?\195\223O_\024^\028:\202\240\252\244\249\015\000\001\196\194\206\192(\242\227\204enV\027\011\006\001E\025\006\006f\022\168>\152\001h\128\017b \195\223?\012\031\206_e\000\234e\000\154\193\002\016@,\255\025\152\255\128\196\223\030?\195\192\204\198\n\018\002\219\203\007$\191\001i\022\160y\127@\174\000\026\204\006\164\191B]\245\255\207\031\176\030\016\248\199\192\252\015 \128X\254203\252eddxw\234\018\195\207\231\175\025x\128.:\202\252\151\225\001\211?\134\191@E\031\128.\248\012\164\021\128\006\137\003\177\197_\022\006f\160\185\127\129.\250\250\2489P/\011\195\175\255\255X\000\002\136\229\031\208\158\127@\t&\160\205\223\030\191a`\006\026*\0144\168\130\237'\131\025P\227G\160\237\226\255\153\024\142\003\013\188\0024\240\208O\014\1347@\241?\255\129\174\130\234\253\007t.@\000\001\013b\0019\141\225\255\127p\016\002\02100\136\130D\128\002\183\129\134\179\129]\197\192\240\019H3\001#\226\251?`\136\000\013\134\004\249\127\160J\160\235\024~3\002\004\0160\008\024\193\241\194\004$\153A\152\017$\193\196`\248\159\005\236\181'L \030\003\1318\208\016\161\255\204\012\002\140\204`C\153\2553\192c\145\137\129\233?@\000\17703\252\006\218\202\196\192\0144\000\020\176<@IP\024q\002\131X\008\232\170\127\255\2551\252\002\138)\001\013\001\217\015r\029'P;((\254@\156\005\ne\006\128\000bbf\252\0054\000\136\129\006\178\002\241_\160\001\150\255\2541\240\003\013\209\007\006\192\005\160\139>\002\0130\002\178\2230B,`\006b\144Z\144\030\144^&\198_\140\000\001\004t\017(\148\254\131\189\006\180\007h\016\208{\1920\152\247\139\025\028Fw\129\178f\255\152\024|\25521\164\001\213\221\003\187\235?\212K\016\189 3\000\002\136\005\168\021\152\150X\192\006\192B\nd\231\249\255\016\003\171\129\001\242\025(u\007\028\030\255\192\t\018\152\166\193\129\253\023\028\220 \131\2542\001\004\016\203\015\134\255o\254\255\255\007\012J&PD1A\211.(\018\025A\001\240\028\162\147\017\146E\024\2553\002\243\0164\205\255\135\024\246\151\225\211\255\127?\001\002\012\000\215\226\251\220\1652\028d\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_am.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\230IDATx\218b<# \240P\208\196\148\159\199\198\142\129\137\143\151\129\225?\003\004\192ht\192\136\160\255}\250\204\240\229\200!\134\247gN\127\004\008 \022\014FFa\230sg\185Y\173\173\024\216\020\228\025\024\153\153\177\232b\1920\253\255\223\191\012\191.^`\000\234e\000\154\193\002\016@,\140\012\140\127\128\152\225\247\137\147\012\204\172l\012\012\172,\008\003\254\227p\013H\226\247\031\176\030\144^ \239\031@\000\1770\254\231\002s\254\156\190\194\240\227\249{\006\006\022f$w`w\017\152\252\243\151\225\207\147\167\012 \253\255\254\255c\001\008 F\t\129E\031\152\025\217\249\153\160\138\024\025\255\227\240\014\170\161\255\255C\248\255@\142\248\255\245\007@\000\177|c\224\007\154\202\003T\007\242\018\019P\005#T\211\127\028\014\130\202\129\241? \245\007h(\019#@\000\177@$\128\00600\1311\200\155@ga7\008\230\178\255\255\025\254\131\013\250\0111\140\145\233?@\000\177p\177\127\002\006\203\031\006&F&\176\129 3\024QL\192\244\026\216\152\255\016\143\001\195\007\024\238\159\024\000\002\136\241V\151\236\007AnF~\014`\132\177\177\128\194\154\017h(\254\192\254\247\031\020\214\255\025~\253a`\248\241\139\129\225\197\199\127?\001\002\136\133\129\251+\003\003\031P\003+\01633B|\008r\214\127\028\006\129}\253\031\226\171\191\160d\000\194\255\024\000\002\136\229\255\191\255,\012\127@\18202\252\003\026\242\151\t\024\127`\131\024q\024\244\031\168\022\136\255\001\189\0055\012\168\138\t \128X\190\253\252\255\022\024&\255X\153\024\153\129^\002\026\003\012:F\144J\136)@3\255\255\255\015c\255\007\134\200\127Fx|\001\137\159@G\188\251\252\239'@\128\001\000=\\\175\253H\212Cs\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_an.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\028IDATx\218b<s\230\204\003AAA\017\030\030\158?LLL\012\200\224\238\172Y\012\204P\246_ VNKC\145\255\247\239\031\195\151/_X\222\191\127\255\006 \128X888\004\152\153\153\185YYY\025\216\216\216\024\024\025\025\225\nE\213\212\024`F\255\003bN..\006\152\236\255\255\255\025~\253\250\197\000\212\203\0004\227\015@\000\177\1284\130\240\239\223\191\193\130\200\224\219\213\171\008\141 W\185\185\161\200\131\244\128\244\002\013e\002\008 \184A\127\254\252a\248\241\227\007X\001\204U_\022-b\248\n5\132\007\136\127fe\193]\003\002 = \181@/\178\000\004\016P\199\188\015\012\012l\252\012`\187\255\001%\254C\237\251\003\196b\012\202\154R\012\252\028\172\012\231\206?\002\242_\0021\011\2120\144z&\1685\223~\000\004\016PT\016\200\224\130*`\130*`d0\177\230a\184z\254;\195\243\231?\024^1\253``e\227c\2083\145d8w\2523\208\005\255\161\006\252\131Z\248\145\017 \128X .\001\153\204\012\197\016\175>\188\251\151\129\157\143\131\225\211\219\223`\023\240\ts2<\188\243\023h\017\011\212\144\255\208\184\004\025\198\248\031 \128\128&\000}\198\240\014\136_\003\241+\176\243\255\255\127\201\240\250\197#\006\183Py\006NYA\134\127\"\188\012\254\209\138\012\175_>\002\203A\188\248\n\170\007\164\247#\003@\0001\222\186u\235\0030\029\241\003\163\016\028\253,,,\012\176\244\180\014\2322!\168{A\218B\160\129\012J?\160\128\006E?(\130^\188x\241\019 \128X\024\240\000\001\168\195\255C\217\248\000@\000\177\252G\178\005\132\255\254\253\011\143^\144\163\217\161\n\127\130\130\021(\199\136\164\022\132a\201\001 \128X\190}\251\246\001\232\021V\168\151@\128\017\136A&1\130B\128\003\164\014\200\006\025\244\250\213\171\255@\205\140 \141@\250?\200{\192D\201\004\204\"?\000\002\012\000Yb\224/^&\235D\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ao.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\187IDATx\218b\156\195\165\248@\210\212P@\194\206\154\129\153\143\135\225\255?F\006\006\006F\134\255\012 \154\001\204\134\128\255P\222\1270\155\145\233?\195\223O_\024^\028:\202\240\252\244\249\015\000\001\196\194\206\192(\242\227\204enV\027\011\006\001E\025\006\006f\022\136\182\2550\003P\001##\196@\134\191\127\024>\156\191\202\000\212\203\0004\131\005 \128X\25430\255\001\137\191=~\134\129\153\141\021$\004\183\023D3\254\255\207\240\239\015\144f\002r\153a\238\252\207\240\255\207\031\176\030\016\248\199\192\252\015 \128X\254203\252eddxw\234\018\195\207\231\175\025\152\128.b\132z\228\2397F\006\145\192\031\012\220\158\127\024\030\167q30\000\237`b\131\200\253\003\186\232\235\227\231@\189,\012\191\254\255c\001\008 \022&\0066\006\160w\025\152\129\186\127=~\195\192\0044\020\228\158\127?\024\025\216%\2540pI\127c\248\185\136\137A\162\241/\195\1318~\006\022n\160k\128j\254\001]\202\012\212\011\164\024\152\128\"\000\001\196\194\201\200\204\192\005\196\172\012 \001F\176\161 \239\176\17622\176J\253g\248x\158\131\225\217b^\0067\153w\012?\196Y\024>\127`\002\006#\208 \176\151\2543\252\006:\224'\144\004\008 \150\024\246o@\157\204\192@\132\134\t\144\254\003T\245\231-\003\195\217\138o\012I\165\236\012W\025\1903\156a\252\199\224\197\253\157\225\237/f\006\014\160m\255aa\005\142\196?\255\001\002\136E\128\233\015\208;\255\129\024\022-\255\193a\230\016\240\135\193:\129\145\161\187\228\027\003\007\251\127\134\029/\152\024\222\222\253\203 -\254\023j\000D\195?\160A\127\255\253a\000\008 &f\160\003Y\025~3\1760\254f`\005\026\202\202\248\151\225\219\231\191\012z\242\127\024\206/\254\201\160%\011\212\248\157\129\225\209S\006\006;\227\223@]\127\193j@j\193z\128z\129f0\002\004\016\163\180\168\236\007`\000\2433\130\002\025\028\208L\224\196\248\232\005#\003?\023#\003\0150p\159\188fd\144\016\250\199\224a\253\151a\239)f\176\015\192!\244\255?\024\255\253\247\239'@\0001\202\136J\127abd\230\134$\020\024f\006\027\246\023\154\202A\225\006\210\240\251\207\127\006N6p\194\000\027\004\198\255\2551\252\253\255\2317@\000\177\000\021\188\001\154\253\015\232Wf\160\191\129\193\008L\187\160h\251\207\008\0135\016\027\146\014\129\225\240\255\231\191\255 \005\224\164\n\177\230\0310\156\254\253\004\0080\000@\163\003\142\029\216\143\003\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_aq.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\214IDATx\218b\244\140;\243I[M\248\175\182\006\023\003;;\019\195\255\127\012\012\255\025 \248\031\144\248\007\228312002Bh\016\000Q\140L\012\012?\127\254c\184z\227\027\195\181[o\153\001\002\136\133\133\133\139\247\238cF\006C\0296\006Y\t6\136*\144A \147\024\2541\176\176\252g\248\243\135\145\225\207_F\160A\140\012\204\204\016% \249GO\1271\220{\252\029\168\134\139\001 \128X@\182\130\140\191\245\2247\144\193\196\192\196\0121\232\031\208i\026J\191\024$EX\128630\188|\251\143\225\249k\006\134\239?X\128\202\153\192\006\221\186\255\027\232r&\134?@6@\000\177\252\253\007\177\237\194\181_\012\159>\190\001Jp3\188\251\204\193 \194\255\133\193\209\132\141\129\005\232\031\022N\006\006%\153\191@\177\223\012\155\014\252b\184|\139\023(\206\192\240\250\253\031\134\191\255\025\129\15022\000\004\016\203o \193\200\008\178\129\153\225\213g.\006\127\251\031\012w\159\253a\208Vb``c\227d@\000&\006\001~f\006A\129\191\012\143^\252c\224\224\004:\029\168\007\024\132\012\191\128\142\001\008 \150_@\2150\252c\006\250\159\149\225\241kv\134k\207~1\148D\179\003\165Y\0240\193\127\160w\2553\240\24012|\249\206\198\192\196\244\023\028\025\191\129f\000\004\016\011(:@.b\004\134\"#3\019\003\200\171\172\172\236`\023`\003F\154@o\170\252b8w\137\133\129\029\020\155\012\127\129\250\025\025\000\002\136\133\157\153\145\129\029\232af`(\179\179\1790<~\244\151\225\241\139_\012\1382\220\012\136\200F\128\015\159~3\252\252\194\200\192\205\202\002\142\209\191\192\128g\248\205\200\000\016@,\172@\154\029\024\160\204,\160\232eb\248\008\012\167\005\235\1900\184X}\004\134\027\019\131\016\031\019\131\154\018\023\003\007;\200\171\127\025N_\254\193\240\2529\023\003\015\007#P\030\024Q\160\192\006\154\001\016@,,\1920\003:\138\129\025\154\20089X\024\174\222\019b\184t\231/8\253\1762\127b\168\203\250\192\160\171\202\013L\"?\024\214\237\006E?;\003\011\243\031\134\127\127 \014\006\153\001\016@,\224\144`\252\199\000\130\255\129i\231\255_\160\159\129Nf\004\165h\166\255\012\255\025\185\024\230n\253\t\012\183\223\012\207\159\178\000\211\017'\003;\219_\134\223\192Pf\004\233\001b\144\025\000\001\196\242\251\247\215\207@\231\001\141`\002&N\144VfP\240\129\019\220\127h\184\\\188\204\000\206:,@\223\177\179~b\248\245\019\148\012A\170\25400\253\253\205\240\247\207g&\128\000\003\000>W\240\027\217\146TX\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ar.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002VIDATx\218bd\168]\242\192\\^Z\192QA\156\129\143\141\141\225\255\127F\006\006\006\016f@\162a\224?\156fd\252\207\240\233\215/\134\253\015^2\156|\248\244\003@\000\1770\176r\136\156|\251\157\219N\153\153AI\132\155\129\153\145\137(\131\254\254\255\199p\246\229_\006\160^\006\160\025,\000\001\196\194\240\151\233\015\195\127&\134#O\2223\176112\1762\003\013\194\234*\132!\012@\215\252\254\251\015\172\007\164\151\225\015\227?\128\000ba\248\199\206\192\240\151\149\225\248\163o\012O?\253c`\001\026\006t7P\001P\0033+\003\003'\016\255\003\178\127\254\005\170\251\005\151\251\003\020{\244\225\007\208`\160\252\031\022\022\128\000b\188~\253\218\007^^^~\022\022\022\006&&&0F\248\004\168\233\230-\006\006v\160!\n\154`\151\192\192\191\127\255\192\248\207\159?\012o\223\190\253\001\016@,\140\1920af\006\006\021+\027\144f\006\027\196\008\180\021\132__\191\201\240~\191\021\003\019\011\003\003\175\205Q\006q\003}\160\199\128\016\232\"\144!\127\255\254\005;\028\228L\128\000b\001i\000i\006\025\194\202\202\n\166Ab \192\246\247?\003\143(\196\135\172\192\192eec\1338\020\168\027d\008\008@}\241\031 \128X@z\152\152\024\193\152\153\153\t\140a\222\14705\004\154v\154\129\129\005\0246\218\022\240\000\007\185\006\028s\127!\250@f\000\004\016#C\245\246\015\012\220<\252\012,l@k\153\129\166\0021(\t\128\212\130\196\184A\145\001d\255\248\t\012T\160\129 ;\128\174c\248\007\020\252\253\023\"\246\241\221O\128\000ba`\255\205\192\192\001\020`\001bf\160\209\204\176t\004\194@\177\031\223!\161\203\002t\013\011\019\212U@\012\140~\006f\144A 5\191\025\000\002\136\005\200aa`\252\007M2\1604\004\012YFfH\250\248\143\1488A\161\nR\007\194 \179\224z\254\129,a\002\008 \022\134_?\22300|\251\199\192\248\155\153\225?;0\202@\206\002Y\207\0045\129\233?$\029\252\135\166\198\127@\246\031 \011\024\019\012\192t\244\023\136\191~\250\t\016`\000d\198\206!hwyq\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_as.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\184IDATx\218bd`H\251`i\169\205\224\232\168\193\192\195\195\205\240\255?3\003\003\003\019\016\131hF(\006\129\255H\248/\003#\2277\134\159_\1900\188\220\191\130A\237\2293\006\128\000\002\170\202\006\202\1763TW\1873\232\233I101\193\012bD\162A\224\031\016\255d`ex\207\160\204\194\198\160 \197\206\240\246\193q\006\006s/\134o\223\1901\000\004\016\011\003\003\027X\195\241\227\247\129\18200\176\176\176 \185\2327\016\255`\016dx\202`\192\204\204`\160'\193\192\224`\002\020\227`X\190r\002\195\179\167O\024\146,}\192\214\000\004\016P\023/X\227\190}/\024\238\222\253\193\192\204\252\021\200\127\199`\198p\153!HB\156\193!\216\136\129!\204\017\232h)\160{\024\024\190\003\137d\023C\006\214\143\127\025\228\180\184\025fqlg\1762Vc\000\008 \160Ab@\233\015@|\133A\255\225\021\134tc\029\006\243$\007\006\134\240\028\006\136%\168\192YT\148A\t\232X!\165\255\012\127\22200(\200+3\200\201J2\000\004\016c+\135\223\255\228\204P\006\214t\003\006f\tY`\0241\1291.P\146\223\199\240\238\234\020\006Qa\005\134\019{O1l}\240\130\225\227\199\143\012\000\001\196\244\237\215\127\134/\159\12710\191\254\193\192\202\202\202\192\198\198\006\166\177\225\127\127\25538E\1843\204=\240\136\193>\160\149A\206P\028l)#0p\001\002\008\024\188\211\129\177\246\th\215]\006\023\1343\012\217**\012~Y.\012\012\249\158@1)\184K~\003\0139\181c\018\195\175\015'\025\184E|\024\150\175\171c\176w\159\204`\239h\193\240\254\253{\006\128\000\002\026\212\240\031\022s\1928\003\226/@\252\150\193\132\225$C\150\000\015Cb\150=\208\208 `P\234\128\013|\254\235%\195\1309Y\012R<J\012\207_=d\240\247n\007\186\246?\003@\000\001\013*\129\026\004\138nV\006\008\027\134\127\130cP\150\225\004C:\195W\134\234\194\008\006\006w>\134\219\188\203\025\238\177\2343\188\252m\192\224\164\225\201\240\227\221;\006\128\000\002\026\148\0114\136\011\168\129\019\t\179C\013e\129bf\168\161/\024\132\024>2d0\254`(OQf`\204\212g\248)\171\198\240\225\195\007\006\128\000\002\026\148\001\140{\030\160\191\184\128:\184\129|N \230\000\026\206\194\0081\132\233?$y\131R60\160\024\2542\130\018)\003\1953 \251\0260\189\221c\240\151\225e\004\0080\000\134<\179\139\020R\015)\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_at.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\139IDATx\218b<\204\192\240@\202\220\\\128\199\209\145\129\137\143\143\129\225\255\127\006\162\000##\195\191O\159\024\190\236\223\207\240\254\228\201\015\000\001\196\194\201\192 \194|\242$7\171\157\029\003\155\146\018\003#33Q\230\252\255\251\151\225\215\217\179\012@\189\012\028\012\012,\000\001\196\002\020\251\195\008$~\0319\194\192\204\198\198\192\192\202J\156\139~\255\006\235\001\233\005\250\225\031@\000\177\128\024 \252\231\248q\134\031O\159\130\205f$\228\026\016\241\231\015\195\159G\143\192j\255\001u\001\004\016\011\195\245\235\012L\188\188\012\204 \003\152\152\024\152\128\152\024\240\239\223?\006f \254\0154\144\225\237[F\128\000ba\252\003\020\000\134\011+\208K \026d\016#0 A\024\171k\128\145\001\194 \131\254\002\195\233?$r\024\001\002\136\133\129\141\005\172\025\2170\\\134 \027\0062\004\004\152 \190\248\015\016@,L\231\03100I\13910\177\178\128\189\199\204\012\146`\132\133\004\182x\007\186\006(\247\023\232\"\160\183\152~\254b`|\243\150\001 \128X\024\"\220\161\210\016\204\004\197\004\195\008\170\030\026\248\140\000\001\196\196\200@\029\000\016@,P\012\182\001\132\255\226\241\020\178k`\024\234\027&\128\000by\207\192\240\006$\0064\013\024:\012 \0232\002\211\246\255\127P\1513B2\013\156\013\162\254A,\251\015\140x\134_@\252\150\129\225'@\128\001\000\137\001x\196\168d\240\002\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_au.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\255IDATx\218\000I\000\182\255\001lFh\224>YF\016\223\255\020\000\253\248\t\000e\016\230\000\212\250\011\000\198\238\018\000\027\017\001\000B\025\004\000\194\241\255\000\225\231\247\000\000\003\255\000\000\000\254\000\000\255\252\000\n\012\004\000\235\237\242\000\189\196\209\000\201\207\215\240\002\136e\209\011V\145\167\179vq\207\173\015a\248\169\166\205\192\245\232\023\131\250?&\006cca\006ffv\134co\1903p\255\251\197\160\198\195\202\000\006\140@\131~\254aPU\227g8u\229\015\195\201}7\025\024\254\252a\001\008 \198=\134v\031\024?\252\227W\240\178f\0161\146a\248\255\230+\003#\023;\003\131\160 \195\235\215\204\012\162\204L\012\239\2178\025\022|\019``\248\254\139\129\129\155\025\236\170\223_~2\236;x\131\225'\231_\006#M\254\207\000\001\000I\000\182\255\004D\005S\000rI\022\000n\014\247\000b\217\023\000\150\240\177\000\216\008&\000\186(5\000b\249\220\000k\222\235\000\198\212\232\000\016\017\004\000SG\"\000\157\161\203\000\000\012\004\000\252\253\252\000\229\227\244\000\029\030\018\000\204\210\246\004\002\000I\000\182\255\004\149*\004\000\245\232\232\000 \160\245\000\000\018\244\000i0\013\000\164\227\227\000\161\148\174\000\1347\018\000\196e\018\000\019\224\235\000\148\211\244\000\004\007\232\000\223\236\255\000\000\239\253\000\255\253\000\000\020\022\028\000\226\230\249\000\224\239\239\001\002\136\145\129\175\239\003\003\023/?\003\007\019\208\201@E\239\22210p\001\189\193\197\194\192\240\013\232\149O@aI\014\160o\254\000\195\002\024>\172,\160\128\130\168\005\225\127@\177?\159~\002\004\016\019\131\0000\0169\024!\001\249\227\015C\237D\127\006e\003\025`x\000\021ps20Hp@\2440\001\213\177\001\195\142\017d\0160\156\254\131\2440A\012ed\250\015\016@,\012\140\159\129\140_\016\147\129\234\234b\132\024._\186\207p\247\212s`XpBmf\128\186\002J\255\250\015\193\\L\016a\198\175\012\000\001\0044\232\011\144\241\131\129\001d\209\159\191\012\172\236\181\012\012\002@\175\ts\001\005\190#\025\000\245\202\143\223\012\142\142J\012\014\166\018\012\245\229{\025\024\196\185@\250\025\001\002\136\145A1\247\003\003\019\027?\003#3\196\217\255A&\1781\128\249`\1673A\013\250\007M\140\191\025X\216\152\0258\216\2541|\249\008\244\013\0190\212\255~\255\t\016@@]\191X\192~\006i\254\015\244\027\003\208;\140@\250?+$,P\012\002jb\252\205\240\231\231w\134/\1604\197\012\n+ \205\240\155\t \128X\024\254\253~\003\140\138\127\012\255\2551\003}\193\004\012DX\14802\252\255\015\245\019(d\129\020##\148\205\012\014`PP\000\029\0024\255\219O\128\000\003\000\156B\246\188bF\138\178\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_aw.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002dIDATx\218b\212\168Z\244@O^V\192LE\146\129\155\133\153\225\255\127F\134\255\012L\012`\240\031D02\1929P&#\195?\006&\198\255\012_\127\254b8\249\224\021\195\165\007\143?\000\004\016\011\003\011\135\200jN\025\238\220O\015\024>i\0272\252\251\251\143\129\245\255\127$\003\208\193\127\006\144U\127\129j\174\191\252\192p\253\205W\006&V\014\022\128\000b\249\207\198\253\167\255\2122\006\137+\187\024\164\131#\024\014\155\0070|\254\249\027\172\024l\216\127\006\1523\160\134@\232?\255\2541\156\127\242\001(\206\204\240\239\031\243?\128\000b\249\247\251?\195\012\013\015\006\131C\027\025\150\127\020c\184q\2495\003\199\223\031\016\131\2543\162\154\195\248\031\238\203\191\255\2543<\255\240\003\200d\001\178\153X\000\002\136\229\255?V\134w_\2543\212\167\207cx\244\235/\003\231\219\159\012\140P\013\008c\144\130\012\204\000\133\018\008p\002\195\244?\195\191\255?\025\001\002\136\229\223\1276\006\190\191,\012O\19001\1762\001Mgb\199\019>0\231\129\\\0114\128\241/\195\255\127\127\128^ce\004\008 \150\191@C\024\254\177\000\229X\129&3\003\0211\001]\132\223 \144+\128&\128\130\028D\001\189\198\250\031 \128X8\217\1911\176p230\179\252\002\134>3\208\028\152A\255q9\007l\208\127``\255\251\253\151\225/\203\031\134\223?\1911\000\004\016\227\252]v\031\248\005\152\249\217\129>bec``ffd`b\002)f\192\226E`\172\001\133\254\001\003\250\239\223\255\012\191\12710\252\252\201\192\240\230\213\239\159\000\001\196\194\194\244\139\129\005\024\133L /10C\157\206\004M\148\140\240\008\135\004<\196K@\163\192|&`\024\1770\254c`a\250\205\000\016@,\189'\139XX\184\248\025\2543\003\157\196\194\014\140\016\160\179\024Y \134\129\013D\024\196\008\212\004\194\012\255\255\000\195\020\232\156?\192\024\254\251\147\225\247\231\183L\000\001\196\242\237+\195\027F`\234\250\199\240\155\025\168\148\233?#\0162\252\001\006\003\208\019\016\131\192\t\n\154\142\128\140\127@\246_ \243\247\127\144a\140\255~1\252\253\242\243'@\128\001\000E\191\252E\197Kfx\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ax.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\214\216\212OX2\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002`IDATx\218D\146\207k\019A\020\199\191\179;\147ML\187b\138=T\211\2186U\164\160\224I\172\008\n\030\004\255\008\015\158=z\245\224U\175\030zR\241R\004{\243ZA\138\005)RP\180\181b\139\181\013\253\153\1666\219\236\204\206\248\157l\172!//\236\206\247\243\230}\223\019\184\245x\249\234x\237\212\205\203\231\016\159(\194\025\133\011\213\021L$\139\216_\236C\241\198\030^/\223F\170C\000\150\225\000\145A\008\139f\235\0083\011+\152\251\178\188'\017F\253s\223\183z\175_\026\196\200\153\024!\020\006O\247\163\156\242p\214\003\213W\193X\187\007\218\016$\2201,\179\022\031\151Z\160\022d(\t\1674\130\016\179_\235(E\nJD(\006\171\168%?\144,U`\135\246\240mm\000m\173rH\007\230\008\206:\026\175\133\150\153\132\233\225\203\002>|nb}s\021\202\149\208\154\152\197\149\230\012\182\166\171\136\207\255\198\171wU$\135e\138\012\254}\180\182X\221\252C&\245:Pb\242\217\248N\185,*\146\224\144\213\130@\161:PG\229\173\197\250\243a\212^|\194|k\148B\153\251\227\127\153l\198\246\156\000/\134F#K\196\251k\181\157X\134\021)<H `\214\244\169\185\017#\173\023\209{q\023\189\165\004\194Cr\014\027\020\176\252\159\145h\152\183R\147H\203iXx#\249\237\130\164\144\144.\128\021\001\164\013\017\210\001\015r]P\135\233\242\171y\160\213\014\242\231}\1298\022(\020\004h=!\002Cg\21502-\240kr\020cO\0230\159\012#MU\167\024\216\142\2437\201\004\013\023|\238\176\189# \239M=\004\162\"\251\n\243\t\164e<\184;\133'\242\013\162 E\147&\223y\249\008\007\007'\255\155\237l\030\150\006e\140\164\t\238\017\157\015\2490\240\021}D\008\142M\013\025\172\006o\180\200\131\203H\181\159\0275:\207\225!5\129_\016\211\221X\191\189\nmS\130\209\001\143\020`\012\177\150#\182\165nD<#\187g}A\227o\026r\143\218\155\\\202\140\189\231ou\001\187\013\135\141}\160\206\017\155mj\015Y5\241\133lw)S\230#r\018fFzp\244W\128\001\000W\139\023NDA\178\131\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_az.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\212IDATx\218bTK\222\252\192@E\\\192LM\152\129\155\131\133\225\223\127F\006\006 \254\207\000\002\140\012\168\224?D\132\241?\003\019\016\127\253\241\135\225\212\173\183\012\023\238\188\252\000\016@,\140,\236\"W\158\253\2306\213da\144\147\224f`fd\130ja\000\027\136\002\024\255\195\141\254\251\255\031\195\181\199_\025\128z\025\128f\176\000\004\016\203/&\206?LL\236\012'\239\255``bae`af\132Y\206\240\255?\204Q\0161FF\184\021\012\127\254\254\007\235\249\t\212\251\143\241\207?\128\000\002\250\133\129\129\t\168\240\210\195o\012o>\255a`fff`\248\253\155\225\239\251\023\012L\130b@G\176\128]\002\212\201\192\192\201\0065\029\232\162\127\255\025\158\189\251\005\214\251\247\239_\022\128\000b\188.$\246\129\151\145\129\159\005(\192\196\000\242;\208\218\183\175\024\024\150lb`\016\001j,*f`x|\019h\152\024\016\127f``\229\001\026\246\023\024\150\255\129n`d\248\003\212\243\246\255\255\031\000\001\196\242\131S\129\129\157\137\133\225?\019#\003\208-\012L\143\2063\176\215ob`\213\209a\248\174\175\200\192\192\194\207\192~\245.\003\147\180\016\1957\025C\006\006v!\134\255\204,\012\127A\174\002\226\223@\151\253\248\251\139\017 \128XX\254\1772\176223\176\253c\002\210\012\192\192\230f`{\247\143\129\137\137\027h\023?\195\1276)\006\182\245w\025\024Cx\0248>\253d`\224a\007\250\142\025h\200\127\134\223 _\002\003\157\005\232<\128\000b\250\199\248\027\0249\192\144g\004*b\250\201\192$\167\204\240gR\004\003\203\137\139\012\\\199\1433\176\026h1\252\234\242e\248\233\166\tt\149$\003\019\235\031\160\218\031`\245 \012\210\011\012l\006\128\000b4\157d\250\129\157\151\145\159\153\029\024\004,\140`\252\031h\203\255\2197\025\152\248E\025\024y\005\025\024\184\153\025\254\253\001\134\031\011#<6\255\003c\237?P\236/\208\254\239\239\254\254\004\008 \022\209/\191\0258\254310\003\253\197\200\012LC\160X\003\134\214\127am\136\134\239@\177\239\144\168g\004\007\239\127H\018\248\011\180\012\136\255\002\253\247\237\235\031\006\128\000,\146A\014\000@\004\003U\252\255\197\022C\246\214\13142\157\136\206\016\156,\1573\n\n#`V\148\247\025\254\029\218tF\195\143\213\214\008\241\145\nF\246|\004\016\203\223_\255\222\252c\248\007\204\025\204\204\127\255\255\007\134\217\127\160R\144\231\128j\224I\019b\026\208m \227\025\193\201\228?P1H\226\239_\134\223_\255\252\004\0080\0008\242\011\235\140\227\252\176\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ba.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002wIDATx\218bd`\168y0s\150\189\192\135\015\252\012\255Yx\025\220\013\1821\200\232\254``x\205\192\192\240\159\001;`\004b\022F\134\127?>1\248\165\1542\156<y\225\003@\000\001\133\026\19000|\229>s&\131\129\147S\148\225\218\245\183\012\250*\215\025\164U\19120|d\192\t\2543\253e\248\245\238,\131\144\150:\144\247\236+@\000\17700\176\253a`\224b\200\205=\204\224\228\164\202\224\237\169\193\176l\139\014\131\163\246R\006\003\167\159\012\012/q\152\196\252\155\225\247\135#@\1346\016\179\254\003\008 \160A\156 w2\028?\254\145\225\233\211\235\012\154\218\204\012gO\191aX\180\220\139\161=.\141\1931\017\232\199\235h\174\001\017\236\127\024\254|x\004d\228\0021\027\011@\000\001\013\226\001\137\130\165\031\001\197c\163\1430,Z\230\200\240\240\161\008CDU1\195\140w\021\012\193\165\247\025\024.\160\154\244\143\233?\0033\019\136\195\013\194\140\000\001\0044\136\151\001\2285\160[\129\152\137\225\255\127Q\134\216\200\231\012\160\208\238\232ufH\175\217\197\240\252\149\025C\201\228w\012\012g\129f\252\135\224\127@\157\127AZ\192\250?3\002\004\016\019$\n\024\161\006\1290+\200\169`C\249\132?0\232\233\188chXy\137ae\187\"\003\171\005P\134\021\228\017\160* \134\184\008D0\254\007\008  \023\024i\012\127\161\002L(a\145\149\176\131a\253f7\134\251\247\005\025\146\011\1661\1763\2312D\214\223a\248w\n\028\172P\023}\003\226\175\012\000\001\196\002\"\024\024\254 \025\196\204\128p%/C\160\239ap\024\206\153\017\192\016S\180\131\225\227;c\134\140\137\031\025\254]\004\170`\130\025\244\133\017 \128\128\204\239\012\016\252\011j\224\127$\003\217\224\225\199\206\255\152\193L\255!C\246\252\011\012\027Z\164!\177\254\143\001\170\231'\003@\000\001]\244\139\005\018.\140\208\240a\135b\022(\134x76\2424\195\234\141V\012\143\238\1392\004\023\206`\216\196\153\196`\159\254\026j\218o&\128\000\002\025\244\006h3\144\199\002t\194_\160\174\191@\019\255\128\226\134\017\162\136\025\202\230f\008\245?\011r.cS\159\005C\200\140\181\255\179\206\022\002\185O@a\244\019 \192\000\170/\18724\t|\242\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bb.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\191IDATx\218bdS/|`\166\175&`o\174\198\192\199\195\197\240\247/\011\195\255_\236\012i\190\155\025\024~100\252g\128\000F \230``\152\181\201\139\129\145\245/\0033\243o\134O_\1901\028<y\139\225\212\197[\031\000\002\136\005(*r\250\2343n[3\021\006EY~\006&&f\160Al\012\\|j\012\012\127\208\012bc`PS\230e`d\249\199\240\239\223\031\134\243\215\1900\000\245\002\229XY\000\002\008h=\219\031\006Ff\134\163\231\0312\176\1771\003\013\002\n}\231dp3\184\n1\224?\0203B\232\171\183\164\025\024\217\254\002\013\250\013\214\003\210\203\240\159\245\031@\000\001]\196\205\240\255?3\195\201\011\175\025\158\189\252\193\192\200\200\194\240\247+?C\150\199\"\134\197+\025\024\028\141\128j\153\024\024\246\159f`\136\137f`X\180Q\134\129\025h\208\255\255\191\025\030?\255\0124\155\011h\195/\022\128\000\020\1421\n\1280\016\004'g)\017\004\017\255\255\000\127\224W\012\216\216X+\022f\221\244\1873c}nD\148\196q:Y\226\187*1\021zO\214\013\238\023\150\001b\134\178W\186,\162\209\025\253u\170\158\244\011 \150\255 \131\0248\129.g\129\248\228?\019\208\022\030\006\142\239\255\025|-\024\024\170\15020p\001\003\217Y\031\024\214L y)\160e@\139\024\255@}\014\164\25533\002\004\016D7\003\019\00432B\252\012\012'`\1960\136\15200l\137g`\248\241\149\129aB-P\201O\144Z\160\022\198\127@\252\031d*T/\227\127\128\000bad\004\170\002\154\206\200\196\004\014P\198\255 \250/\003\011\208 \144\223fW00\188\253\008\212.\014\228\191\006b\230\183@\251\254\002\213\255\133D\194?\144\161_\025\000\002\008\024\216_\128\140\159@IF\136\139\152X\1294\007\0030\02100\000c\150\019\024\150\002@\181L/\128|v\144\229\223\129\156\223@\165\144D\006\n[\160\024#@\000\001\221\249\021(\008L \140 '\179B\156\014r\026\200\197@\199zXA\163\2543$A\130\003\023\156\174@N\006\025\248\007h\2207\006\128\000\002\186\232'P'3$\181\253\007a\160\234\255\156\012\127Aa\t\194\255\024\016\193\008\014_\160\127A\222\255\0152\008\138\025\1271\001\004\224\152\202q\000\134a\144\157\255\127\180j\199(R\229\000\193Y\0258\133\231\175O\216\140\013\179q\136\204`\233y\237c\222^\229N\179\181\156BQH\149AP\205\172\254\017\214\127\004\024\000\158`\231\137\222\184\216\020\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bd.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\195IDATx\218bd\1425{`\166j \224\168a\194\192\203\201\203\240\255\031#\003\003\003\019\003\195\127\016\205\200\240\159\001DCX\012 \204\008\162\255102\253g\248\252\2533\195\254\027g\024N\221\190\240\001 \128X\024\152YDN=\190\206m\167e\196\160$.\193\192\204\196\012\213\0064\140\025h\200\255\255`>\216\188\191 c\255\129\013\252\251\239/\195\185G\031\025\128z\129\234XX\000\002\136\005H\254a`dd8r\231\"\003\027\011\011\003\0113\011\195\127\144a\255\2551\132<z\199 \251\249'X\227\011\030v\134\149\178\194\012\255X\152\024\024\255\254e\248\243\247\015X\015H/\195\127\230\127\000\001\196\200\028\231\242\129\129\157\145\159\129\241\031\131\156\144\008\003#;\027P\227\031\134\019\155\17410\17602|eg\002{\141\2517\208%\223\2550\216\248\2340\252aae\248\255\243\023\195\163wo\128\134\000\229\191\255\253\014\016@@\235\217A&\130m}\244\225\011\195?^6\134\133\251.30=y\199\240\150\135\133\001\006~\001\1770\208\160\137\027?3xy\02610~\254\013\012..HX\254\251\205\008\016@,\012\1279\128\012V`\248\002}\015\020\252\255\151\153!\240\217W\134\239\156\236\012,\255\025\025\144\193\015vf\006\155\167_\024\254\255\230\006\006\221?\006fP\248\253\003\226\191?\024\001\002\136\005\028\136 \1272\129\002\020\020\192L\012`\207\001\185l\168\230\128\197\217@j\129j\192\250\152\254\129#\018\168\247?@\000110\003\003\147\229;\003#\2437\006&\182/@\149\223\0246\201\2422\240}\255\197\192\202\244\023\005\011\003\195\229$P\142\129\227+P\237W\176\030\144^\006\166\159\012\000\001\196\004\"\024\152\128\028\150\031@\135\001\233__\025B\157\020\025\152\1281#\254\2377\003\231\191\127`,\254\2277\003\211\183_\012\206\206j@5\223\129\142\248\006\214\003\214\203\244\147\017 \128 .b\004\006%\227o\006P\204\177\252\005\165\019v\006\198d+\134}\146\130\012|_\254\001\241\031\134\147\"|\012\236\201\182\012\1919\216!j\024\255A\245\000\245\002\205\000\008 `\172\253e\129\164d\016\0062\255\178\002]\203\194\240\135\153\147\193\217\211\018\200\255\011\012P&pR`\000\186\138\229\235oh\136\001\233\255\127@\169\020\148\210\153\000\002\144L\1988\000\128 \016\003\249\255OM\\\197\152`\015\247\203-m\161v\167\237\192y\147\003\163\186\t\175\160\149Z\199\196\1341\0244\001\150\255f\\\24275\2062\243\t0\0004\179\249m\\\224\162\031\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_be.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\182IDATx\218bd``x`nn.\224\232\232\200\192\199\199\199\240\255\255\127\006\016H\139\001\018\191\129\248/\003\004010\252\231a`x2\015\204d`bdd\248\253\233\019\195\203\253\251\025^\156<\249\001 \128X\128b\"'O\158\228\182\179\179cPRRb`ff\006\235\227\226\131\026\244\015j\016#\208 N\006\006a5\136A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0042\232\015H\252\200\145#\012lll\012\172\172\172`}n\182@\226'\170A\012@\213_\174B\012\250\255\2517\195;\160\030\006\136\146\127\000\001\004\146\254\000\196\252 \001999\006\022\022\022\176\228\137\029@\226\011\212U \000t\232\1271\006\134\011\014P\131\254\252a\248\250\232\017\216\231\159\024\024\190\003\004\016\011\003\018x\004\148`dd\132\004\201?h\248\252\129J\002\131\238?P\234\219}\168A\192\176\252\015u0P\025#@\000\161\024\196\000U\000\002\028 \031\178B\012\128\187\136\013\137\015\0050\131\000\002\008\195 \024`e\195n\016\011$\002\225A\199\004\141P\128\000\194i\0168\168X\144t0CTsB\195\253/4\248\254C\164\024\000\002\008\167AL\204\008\235\224\233\136\tb6#\146\240?\136A\140\000\001\196\196@\"\248\143\148\026\152\160\174\001\209\000\001\196\130\203U\127\255@c\0129\214\254@\188\003\179\253/\194\215L\000\001\0042\228\013\194\133`5 \203\254\191|\t\164?\0039\191\193\017\201\008\150eg\248\255\n\026C\160\132\014K!\192t\244\019 \192\000ST}\176\134\221\019n\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bf.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\183IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\128\026\254\128\196\223\0299\194\192\204\198\198\192\200\202\n\215\244\031\151! \185\223\191\193z@\224\031\016\001\004\016\203?\008\131\225\221\241\227\012?\159>e`da\129k\192e\016\216\235\127\2540|}\244\008\172\2477\208E\000\001\196\002\146d\002b\144\135~\002%\152\128~G\214\192\165\n4\128\155\129\225\243\005\136\026\152\248?`X2C\217@\245\140\000\001\196\"\014d\240\0021+\2120f\160\002\144A?\128X\220\137\129Ah\019D\243\1870\006\134\215\219\024\024\216\160\154\255B1\2085 1F\128\000bd\216\199\240\129\129\031\008A*X\160\206\003\225\159@\012\012\197\159r\016\131\216\031CMg\135\134\005\008\131B\247\023\016\191a\248\001\016@,\012\175\161\154`\0061C\013\002\002A [\227\003\003\195\007\160\213B@g\190\251\011\245\219?\168s`\006\189e`\000\008 \022\176\224\127,\024\008\222\003\021\190\255\007\213\204\132\028eh\248\031\003#@\000\177 R\024Z\252b\139s\172)\019\130\001\002\008d\016\011<\244\024\2256\224O\145\255\145\188\247\031\236Z&\128\000b\001\006\224\027\176034t\024\193\016\148O\024\161\026\177\179A,h\"b\248\200\240\019 \192\000{\\\142Y\132\231\223\221\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bg.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\173IDATx\218b<s\230\204CAAAann\238?\191\191\253``\229dg`faa \006\252\251\247\143\225\203\151/,\239\223\191\127\011\016@,\028\028\028\252\204\204\204\220\015\158\220a``\253\195\192\254\141\151AE^\149\129\137\137\025\175!\255\255\255g\248\245\235\023\003P/\003\208\140?\000\001\196\194\200\200\200\000\194\239\159\221g\248\247\235=\003\015\159\024\195\031iE\160A\255\t\186\232\247\239\223`\189@C\153\000\002\136\229\235\223\031\012L\255\217\024\020Tu\024>\223;\204\192/)\201\240\249\2317\134\191\255\254b\213\204\008\243\214\255\127\012\191\128\006\253\251\247\159\225\211\175\175,\000\001\196(\218#\249\129\145\131\145\159\137\141\153\129\153\157\135\225\255\191\239\012\255\254\252\004\219\132\221K \002\137\254\0034\244\203\191\031\000\001\196\242\250\235s\176\000\195/ \254\014\181\146\145\128\159\160\1340\252\133\226\175\012\140\000\001\196\194\200\006d\1280+\016\131\194\151\137H\131\254A\013\249\013\214\255\031 \128Xx~\002\2452C\004\025Y!\0061\0180\232?\212\160\255 C@^\003\154\001\016@\140Gy\025>\24032\240s\128\012fD8\no\250\129:\230\023\208\192\031@\250\245\127\134\159\000\001\196\"\250\153\129A\016\200\225\128\250\144\133H\131\254@\131\245\007\212\167\000\001\196\242\031I\018f\211\127\"\012\130aX\144\001\004\016\2037\006\134\143@\023\176B]\194\004\n\"&\136\028#4\221\128\130\004\206\006jf\132\005\209\031HX3}\000:\012 \192\000H`\152\167\141\013\019}\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bh.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\025IDATx\218b<z\244\232\003aaa\001^^>\006&ff\006F&F\134?\159\1270|:r\134\225\231\147\235\012\232\128\017\134\025\025\025~\127\250\196\240r\255~\134\023'O~\000\008 \022NNN\017\160 7++\011\003\007\007'\003\003\208\160\191?\25520\ns0\252\229R\195j\016\024\252\253\203\240\225\236Y\134\031'O2\17630\176\000\004\016\011P\234\015\200\244\159?\12720\131\\\196\194\194\240\231\215\015\134\239\207^0\252z\246\008\187!@\240\255\247o\134wG\142\128\217\255\128\008 \128X\128n\004\170`b\248\245\2357\195\127\134o\012L\172\172\012?>~bx\189s7\195\151\243'\177\026\244\031\132\255\252a\248\250\232\017\200\016\134\223@\023\001\004\016\011#\0033\2087\204\012\204,,`\003\129\206b\248\243\224\021\195\231\195\135\024~\190~\198\128\013\128\012\250\247\255?\132\006\249\018\168\019 \128\152@\154\153\152Y\128\250Y\025XX\216\024\216\216\216\0248\229\020\0258\149-\129:\25430\"a\006d\012\0050\131\000\002\136\005\020>LLL\224\240a\005z\139\005h\208_\022V\006f\160?X\208\195\005\137\254\011e3A\240\127\128\000\002z\237?(\162\128\174a\130`P\128\191\127\205\192\252\228\002(6P\012B6\240\015$l\192lf \006\008 &F\166\255\224\160\001\025\006\194\204@\215\177\203\n3p(\1710\1762@\\\005\195\172P\140\206\006\026\196\008\016@,\144\004\246\031\201\225@\214\247\159@\183\255\007\251\159\145\001;`\132z\139\025J\003\004\016\203\255\255\255\128\024\168\233\223? \254\207\240\007\152\208~\190\251\206\240\249\238\029\134_X\162\158\017K8\001\013c\002\008 \150\239\223\191\191\001\006\248?f\022Vf`\022ab\230`g\252\245\255\223\255O\202V\140\239\159\222\005i\252\015\211\015b\131R\029\212\176\255\208\024c\248\196\192\240\019 \192\000\130\179\172\145M\003eZ\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bi.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\215IDATx\218b<s\234\204\003nA\001\129\191\155\1820\252\254\249\141\129\225\255\127\006F\006 \197\128\029\192\228\254322\1762\17800\007\2482|\251\252\245\003@\000\177\220\252vC\196Z\212\134\155/1\142\129\241\231/\134/G\0143\252\005*d\194b\024\204\016\016\205cn\t$\184\024>}\250\196p\227\245u\022\128\000b\138>\025\243\167\224Z\t\195\239\239\191\025\152\1848\025\184\221\220\024\024\216\184\025>\\\189\202\240\243\218\013\134\191\n\170\012\191\149\212\024~\221y\000\022\251\251\143\153\129\007\168\134\153\159\023\172\167\230F\003C\208\177\160\127\000\001\196\2000\149\225\003\208\n~\006V\006\134\157V\251\025\012D\180\024\024\129\206\254\250\250=\003\155\168 \195\209ym\012L\247\0313\0246Og`z\253\145\129[\148\031\232\251\255\012\183?\222c\1769\002t\213w\160\243\2540|\007\008 \136A\\@\131@\238\253\194\192`\174\232\206\176U\127)\003\003\007\196\0273EE\193R\209\175_3\240\128\252\247\139\129!\236B&\195\190\251\171\025\024\184\161~\253\196\240\003 \128\152\224\158g\006bA\006\134\147\015v2\184\223\204c\224\224\224`x\194\193\196\224\247\226\021\131\247\251O\012\2399\152\193b\241\247z\025\246\221\005\026\"\000\213\003\t8F\128\000b\0023\024\161\161\203\012\tT>I\007\134WK\2061\236\230\017b\248\241\236\005\003\019'#\195\001\030A\134;U[\024\216E-!\138\152\161z z\255\003\004\016\019\220\016&\136\215lu\002\024\246\168&3\2524cc\224\001\138\241r\255e\224c\249\199\192\t\242\149#+\195j\021o\006O\163x\176Z\184^ \013\016@\140\0123\128a\196\002\012#v\006\134C\142'\024\172%M\025\152\152\152\024>\252\252\203\240\131\157\153A\020\026\245o\129\152\229\239_\006!ff\134\127\255\2541\\{}\139A\247\128&\003\195g\160\196\015\134\159\000\001\196\00429X1\130\225\179\207g\006sQC\134\159@\241\155\2495\012\1679X\024\158\178r3<\172\155\206\240\176e&\1953\001q\134\179,,\012W\2273\193j\212\004\149\024>\187\127fHPMa`\248\202\192\000\016@\140+\143\174\248\226\164\234\204\205\198\206\198\240\249\230}\134\027f\006\012\191\129\n\129\169\001\1560\255A]\004\011BXbU\219}\136\129\223L\159\225\247\175_\012\135\174\031\250\013\016@\140\231\207\158\127\192\200\206&\24484\146\249\221\245KL@\003\024\153\192\025\133\129\017\154\178a\137\025D\252\007\005\007\200p\160e\255\249e\149\025\164\215\172`\248\246\237\219O\128\000\003\000\145\180\227?N[j\245\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bj.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\241IDATx\218bd\200dx`\174l.\224\168\234\200\192\199\193\199\240\255\223\127\006\134\159\012\0121f\002\012\\\204\204\012\127\2541 \129\255\008\204\200\200\240\239\239g\134\207\159\1432\188}{\246\003@\000\1770\1762\136\156|q\146\219N\195\142AIL\137\129\153\145\153\129\2257\003\003\03177\003\0273\019\195\223\127\200\134 \179\2552\252\248q\025h\222\005\006NNF\022\128\000b\001\138\252\001I\029\185\127\132\129\141\133\141\129\149\137\149\129\225;\003\131\173\"\031\003\211\127\144\139\016\0060\"\025\244\255\255\031\134\159?O\129\028\198\240\239\031\227?\128\000b\001\026\012\182\224\248\163\227\012O?=e`a\002\154\253\153\145!Z_\156\129\137\157\149\225\231\031\006,\000d\208_\134\223\191\159\002Mg\006\186\250?\011@\000\177\192]\012\164\031}x\196\192\200\004\180\226\003#\003#\199_\006&f6\006&\198\127\152\238\129\006\019\011\200\245\127\128j\153\2552\002\004\016\011\003H\029\0083A\212\254\135z\133\139\135\141\129\003\008\025\129:\024\209\194\027d\016(\236\254\002}\195\248\235?\003\019\203\031F\128\000b\129[\198\132\132\149\2543\156\016\189\199 \015\012\171\183(nA\196\219?h\224\254\006\242\222\003\133\000\002\136\133\001d\020\0083C1\136\205\199\192\192\250\253\0158\248X\176\134\016\196\016F$>@\000\177\128y\140H\0061C\\\197\193\206\192\192\006LO\172H\006\1924\"\133\004\212\016\006F\128\000b\129i\132\027\008\149\253\247\015\162\225?\003v\000\011\013\152v\128\000b\129\187\030\230\241\191\016\250\023\003\004\255Ds\013#J\146\132\000\160aL\000\001\196\002\012\1737`\173\140Hn\003&\138WP=\159!z\024\161\134\252g\004g\014\136Y0{?\001\237\003\0080\000\141\004\151\215\159\204T\255\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bl.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\151IDATx\218b\\\231\025\252@>.V\224\240\023a\134o\175_1HH\2021\184}?\207\176\142\199\134\225\243\227\199\012B\204\127\024<\181\196\024\254\241s1|>\178\129\129\137\001\002\024\025\025\025\254|\250\196\240z\255~\134\231'O~\000\008 \150\164\235z\"1\139\142r7\213\0041\252\022ugx\207\245\151\129\251\220#\006GU)\006Q\013\022\006^EQ\134\139_X\025\190_\127\197\160\163\166\198\240\007j\208\255\191\127\025>\157=\203\240\243\228I\006\014\006\006\022\128\000b\188ll\252\225\2517\022\254\191\154\n\012r\014\006\012\140\012\172\012\159\223\127e\224\231ff\248\195'\193\240\243\239?\006\142\143/\025\152\249\185\025>\190\252\004\148\135\026\244\2517\195\235}\251\024\222\031?\206\240\133\129\2253@\000\1774\190Sa\14470b(\140\209``9\178\135\225\131\148:\195\147\165\211\024xg/d`{t\151\225\231\225#\012\211~\23220|{\207\224\127n\017\195w\144! \175qr0\176z\1323\240\243\n1\252c\225c\001\008 \166Kv\169\012\142\185n\012g\142\191c\016\159\165\196\016\245\218\150A\230\223W\006\131m\018\012\170\251\181\024\190&&1h+\1372l\185\198\205\240\253\193}\134_\247\2393|\007b\006)\029\006\190\156\024\134\171\162\198\012b-\165\140\000\001\196|\148\247A\197\195\222~\142\182\131w\025D\127\157b\008zr\133A\239\221i\134\2237^1\188<T\194\176g\238}\134\012\011C\134\140'3\024\030>{\001q\014\016\240\136\1540\156\250\247\131\161\2511\027\131\227\157w\127\001\002\136q1\003\195\007A\006\006~=\160$?\016?\000\226W@,\011\197\031\129\248:,\166\160\222b\006\226Ol\156\012\179\138\026\024\152\212\165\025\004\219[\127\000\004\016\227r\160A|@3\216\129\146,P\204\136\164\017\025\252G\162Y\129\248\020\016\239\148b`H|\198\240\003 \128X\152\161\154Y\1614\136\207\132E3\178\161\255\128\024\148\012,\128\216\238\025\003\195\013\1604@\000\129\013b\134*dD3\224?\026\159\017\205\181\223\161^\007\201\001\004\016\2047p[\152\144\012\249\143\2305F$\252\015\138\161\226L\000\001\196\242\147\129\225\013\208\212\127@\003\152\255C\204\001&~\134\255@E\140PW\252\255\015u\008\019\194a`G\254\135Z\254\137\129\225'@\128\001\000\192(\215\129\129\017\164'\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bn.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\164IDATx\218b<yr\221\003a\225e\002\188\188*\012LL|\012\012\012\255\025\136\003\140\012\255\254}b\248\242e?\195\251\247'?\000\004\016\0117\183\154\008\011K\0157++\031\003+\235=\006F\198\251@L\216\152\255\255\2552\252\250u\150\129\153\249$\003\007\007\003\011@\0001\233\233\233\255\217\177s\031\195\239\223\191\1296\1682\252\253\235\006d\2031\252\249s\021\140\191|\187\202p\246\19258\031\134\255\254\189\012Tw\004l\233\255\255\012\255\000\002\008d\247\007 \230\007\217\210\2181\129!%1\018(\ts\210c\1345=\t\012\167\214|g\232:\241\015\236iF\176k@r\127\128\006>\002\026\200\000\244\026\195w\128\000b\184p\129\225\131\177%X\013\024\003\013\249\031\147Z\254\255\244\1557\255\231DN\248\191\145\145\255\255l\160X\144 \227\255\231o\024\255\191\001\226W \252\138\225\255\139\023\012\255\159<a\248\127\241\"\195w\128\000b\188q\131\225\003??\003?\027\027\003CD\001\003\195\190\197\012\012*@\019\239\002\177\165_.\131%'7CV\168?\195\031\011]\134\191\236o\024\182ed1\252\251\191\141!y\030\003\2165\191~10\000\013\253\t\016@\0127o2|x\249\146\225\255\135\015\012\255\191~e\248\255\227\007\195\255cz\156\255;\152X\254\179\128\\\008\196IF\246\255S\218\183\254\191Z\183\247\255Q\205\028\160\154\031\255?~9\240\031\232\165\255 \189\151/3|\007\008 \022Pp01A033\004\031c\254\195\224\186\235?\195%w6\006\022\209\191\012\247\207\029dx\002\196s\128\174\\\227\229\011T\195\204\192\206`\193\240\011\024\253\127\255\157\007\134Y\008\003@\0001\193S\005#\004\131\012\244\219\253\135ai(\019\195\143\191L\012\178/X\025\148\0248\024\162\128\024\004\194\183m\006&\019V\134\164\148\028p\164\176\178h\001\233}\140\000\001\196\132-\141\168\n\255g\136H\250\207\016\023\252\143A\183\224/\131S\252?\006\017\197\255\012\255\14303$\213@\212,[2\135\129\151\151\151\193\219\219\143\225\205\219O\012\000\001\004\n\163/\175_3\252\255\248\145\225\255\247\239\012\255\129\129\247\255\207\031\252\024\164f\226\020DL\003\241/\128\000b<\127\158\225\00177\131\016\208\181\204@o1\0011#\016\195\146\012\200\187\255\129\233\006\206\254\247\143\129\017\148\142\1284\200P\134\155\183\024\024\242\243\024~\002\004\024\000A7: ~)r\179\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bo.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\nIDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\25410\252\001\137\191=r\132\129\153\141\141\129\145\149\021\167!\200\134\253\255\253\027\172\007l&\003\195?\128\000b\249\td\176\002\241\171\227\199\025\190=}\202\192\200\194\002\183\149\003\166\017(\240\015h\250/\168K\193\248\207\031\134/\143\0301\000\029\194\240\013\232\"\128\000b\177\186\206\192\192\203\011b1001=\002bF\184\189\191\128\142>\184\225'\195\183g\255\025l\179x\025\132\024\190\192=\253\015h\242?\144w\128\254y\251\150\129\017 \128X@\250X\128\193\194\198\n\t\030&\166\255`\0230221\\leeX\247L\142\225\014\163\012\131d\251u\006\219\198\175\012\140\255\255\001#\132\001l\0080\152\192\230\130\148\003\004\016\011H\019\019\019\196\016V\168a\140\140\016\159\219>\254\206\144\206\169\200\240T\132\133\193\229\226{\160\130\191\144\136\248\0155\132\001\162\023\136\255\003\004\016\220 \152a\016WA}W\249\135a\230\129[\012\255\249X\024X\188~\000\157\206\000\245\022<\226\192jAf\000\004\016#C?\195\007\006\030\006~\0066\006\136Bf\164\196\"\202\000\141SX\140 \133\246_\168\028(\006>0\252\004\008 \022\006. \131\007\170\144\025\201 \016\248\140\196\254\014\196\156P6\204 \016\0069\000\024\245\000\001\196\002v\007H\002\228\\&\168$#R\162\249\143\158\018\145\\\245\015J320\001\004\016\011\208io\128\177\250\015h\0083H\000\"\012\148\254\007\213\202\200\000\2023\0086\140d\000\171\129x\239\011\195O\128\000\003\000\206\170\159\134!\025\025\159\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_br.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\179IDATx\218bd\152\192\240\192\\\198\\\192Q\218\145\129\143\141\143\225\255\255\255\012`\000\165\024\254A\217\204P>#\148bdd\248\244\235\019\195\254\167\251\025N>9\249\001 \128X\024\216\024DN~>\201m\199b\199\160$\168\196\192\204\200\012\209\008\194\191\025\0244E\025\024X\128\154/\191\002\242Y\161\006\001\241\223\255\127\025\206\190=\203\000\212\203\0004\131\005 \128X\128\194\127\024\152\024\024\142\188>\194\192\198\204\198\192\202\200\n6\128\145\141\129\161@\022(\203\002q\129$\208\192)O\129R? \006\254\254\255\027\172\007\164\023h\233?\128\000b\1299\255\248\155\227\012O??e`\249\206\194\016\165\203\192\144'\194\1920\249n5\195\188\171\190`\195R5\0140\196IU0,}\205\1920\235\002\208v\206?\012\143~>\130x\253/\003\011@\00012Le\248\192\192\197\192\207\240\029(\192\197\192p\219\131\145A\016\168q\215\243\137\012\209\151\163\024\020\217\2542<\249\249\151\225\247{6\1348\253\237\012\189\154q\012?\128\222\150\223\241\159\225\239G\136\030\134\207\012?\000\002\136\145a\n\196\160Zc\006\134by\160K\153@\001\201\192\016\127\254\011\195\239?\255\025\132\217~0\008\003\003\233\242G\022\134]\215Y\024>'\241\128\131\239\031\208%\243\15810\020\001\131\008h\194O\128\000b\129\005\030\0190\140Y\129~gf\134\132\231\186\235@\014/P\011\203\031\006. 3R\148\141!\209\138\153\129\013\200\254\015\n\236\191\016=`\197L\012\255\001\002\136\t\028X@\1754\002M\230\222\202\192\240\026\168\128\005\168\184\221q>\003\195WV\006AvN\006\022&\014\134\185\247\216\025lE\1832\176\000#\225\011P\011\255\014`d\028b\128\0046\016\003\004\016\019\140\001\012%0-\187\026\168\224\022\003C\153|\006\195\020\199\005\012\239?\1773|\250\194\1930\197j=C\162d\016C\243\003\006\006\145e\192\192\006\249O\016\154\190\024\025\024\001\002\136\145a\022\208\135|@cX\161\130 C\191\0021/\208\011\142@\204\tM\128\192h\0238\204\192\240\241-\144\195\195\000\139-pRax\203\240\019 \128X\128!\199\002\023d\132&D\144f\160FF\160\205]\174@\199\002\189\158\190\029\234j.\168\218\255P\250\031\216\030&\128\000bd\152\204\240\128\129\157A\008\232\018f\160AL`\227\152@I\012H\255\007'W\008\155\013\018\168`\249\255\208L\244\015,\207\192\240\137\225'@\128\001\000\242H\194\202\216\164<a\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bs.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\254IDATx\218bd`R~`n\190P\192\209Q\146\129\143\247\007\195\255\255\140\012\012\012L@\204\136\132A\224?\018\254\199\192\200\248\143\225\211\231\159\012\251\247?a8y\234\193\007\128\000ba\248wW\228\228\t\027n;\187m\012JJV\012\204\204\223\192\nQ\013a\1920\236\239\223\127\012g\207\253\004\026\242\001\200gg\001\008 \022 \249\007$w\228P3\003\027k0\003+k\000P\136\011\168\246#\003&@\024\244\251\247_\160\158\183\012\012\127YAF\252\003\008 \144\149 #\249A\202\228\228\228\024XXY\128\206\206f\016\016ucx\255\250=\208q0\215\253G1\240\207\159\255\012\143\030}\135\242\191|\007\008 \020\131@\128\145\017\226\029O\031\006\134E\243\005\161\162\1910\188\249\239\223\127\176\029\127\25402\188}\251\255\007@\000a\024\132\n\024\025JZE\025\026\242\005\025\222}Br\0150B@\134\252\253\011\244\"\208\142\215o\254\252\004\008 \022\006\188\000\232\157\255\255\128\225\198\200\192\193\254\143\225\031(F\129B\255\254\255\007\027\002\002\127\153@\214\253\255\015\016@,\216\221\001\244\0260\2047\175\021\132&\133'\012\194\002\140H\222\002\185\006\232\225_\255\025~\254dd\248\253\227?\003@\000az\013\028\235m\012\188\130I\012\159\223\190\002\217\137\150\150\024\160\201\227/\020\255\006\226w?\001\002\008\213E\140\n@\007\172\005\210\226\012\159\223\223\194\145 \255\129S\012\004\255\134F\196\007\006\128\000\002\185\155\005\172\150\169\158\129\129\249\004P\031H\225} \159\025(\195\138\134\153\161\152\t\164\011\136\129.b\006\026\198\252\139\t \128X\024\152\212\22200N\002\166y>\160\138\019 \021@cY\129V33B\194\135\t\020\226\140P\023\001\137\223\140\016\215\000\003\136\001\148\142~\000\241\231\159\000\001\006\000a\248\183\2402\221FU\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bt.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\0033IDATx\218b<s@\242\129\160\136\137\000\015\159\021\003\0193\031\003\195\127\006(`d\128\003&(\006\203\001\137\127\016\225\127,\159\024\190|9\198\240\190\240\204\007\128\000b\225\224`\020a\254\127\158\155\149\213\130\129\141S\150\129\145\145\005\162\234?\2120F\168\222oB\012\239\191\2432\008s>``\224\005\n1\253a\248r\245\017\195\199\224\139\012L\255\024Y\000\002\136\133\145\145\233\015#P\241\239\239\167\024\152\153\128\1340\177\162\186\134\153\145\225\203\019Q\134\157w\196\0254\021y\025\190pX3\240|y\198\192\252\250\006C\205\196\015\012\137@[\004\129F\001\004\016\011#\0033\003\200\160??\2073\252\248\255\018h\006\011\212\024 \tr\220W\022\134\167\143\157\025^<\227dxs\247(\131\208?F\134k7^10\138\0110\024\220\223\201\160\240\159\137\225\205\191\255,\000\001\196\196\248\159\153\129\t\168\153\153\025h\192\255W@c\159\003\131\227\025\003\019\199S\006\166\207/\025\152~=dP\226\154\199\160+\163\204\240\246\0157\195\139\197\011\024\132\207nc\208\1806f\008\239\157\196\240\235?\011\195\191\255\204\140\000\001\196x\227\148\234\007~>f~66\160/\128\222`\002\006*#\235\127\006\198w\028\012\213k'0\220\228\231b\008T\190\195pm\221M\006>;\023\134\187?\1273\200-\153\199\224\195\206\207 ~\239$\003\199\247/\012/\255\252\249\t\016@, o01\001=\200\204\192\192\n\244\n3P\132Q\128\129\225\252\241X\134\187/\1902\184\205+a\016\228\215gPs\246b8\255\251\031CaS6\131.\208\219\127\129a\243\013\024\t?\129l\160\221\255\001\002\136\137\145\241/\208\160\223\192\168\255\205\192\204\249\151\129Y\232\023\003\203\171\223\012[\223j2X\136\189dp\202\205c\008\254t\140\193au9\195\167'\215\025^\171\1680\23602gx\194\198\196\192\n\212\199\200\248\027\232\133\191\012\000\001\196\196\192\008L\020\140\127\024\024\217\129\248\222/\134\237\027\\\025zn\2440\252\249\242\138\225\227\173\163\012\154\193.\012_5\181\025\180\128\137g\229\188.\134\215:\154\012\190\235\2310p\135F\000\221\242\007\024\190@}\140\255\024\001\002\136\241\214Y\153\015\130r\140\252\028\028L\012\155/\1511l\155\241\159!\224\223s\006\179C+\024f\02370h/_\192\016\244\236!P\211\127`D\000c\023H\191UP`\224|p\023\156\192\190\255\255\207\240\226\207\191\159\000\001\196x\243\166\212\023!!6\238\023\1576\012\156\027\2552\200\253<\005\2443\019\195g`\180\242\222\191\202p\187b1\131\252\202Nh\186\252\015t\001(Y\255c\248\253\255\031\195/ \251'\144\006\006\246o\128\000b\249\182\239\255\155o-\127\255\177\253;\004\1404\022\166\231\255\153\192z\128\154\024\223\200h3p\001\217/\161)\148\145\241?P\028\020\024@\247\0019\127\128\188_\140\255\025\222\253\251\247\019 \192\000\129,\021\217\246\193\151\003\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bv.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\197IDATx\218b\220\167\160\240@\196\208H\128\223\194\138\129\137\157\147\129CV\144a\023\139+\195\183\223\012\012\001\172'\025\190\223}\192\192\192\198\193\192\200\000\002\255\025\024`4\211\127\134\127\159?3|<q\140\225\205\249s\031\000\002\136\133\131\145Q\132\225\210%n6ss\006\014EY\0066\t~\006yf.\134\031\127\024\024\184X\196\024X\025\129F\176\176\"\012\128\177\254\253a\248q\229\n\003P/\003\208\012\022\128\000ba``\254\003\146\248v\230\012\208VF\006\166\127b\012O\152\013\024\190\000]d\202\241\144\225\231\141G\012\012\236\236\012\008\0001\236\255\159\223`= \240\143\129\249\031@\000\1770~\253\197\192\200\196\192\240\227\232\t\134\127W\17530ZJ0\028\148\244bx\243\157\129\193\239\207j\134\207{\17530\240\242\163\024\0046\234\207_\134_O\15920\254gd\248\247\247?\011@\000\177\0088\2323\240\17833\176\000\253\204\244\253\011\003\147\138\030\195\247\215L\012\239\223\000\131AS\139A@\231\021\003\0037/\146A\144\208\250\247\015\136\181\197\025\254\252\003\026\244\2537#@\0001\154\133\222\248\192\202\206\207\207\196\204\006T\195\204\192\195\202\196pk\207\007\134\223\191\2553\232z\n3|\253\003\241\012#\138\139\128\240\255? \254\011t\205/\134\159\223^\253\004\008 \022\006``221\00113\208\t\172\012L,\204@!6\160\198\255@sY\225\00602 \251\014h4\208\016`\224\000\189\006\210\203\244\031 \128X\150\176T0\008\002c\005\232;\006\182\159_\024\152\245\012\025\178\249\155\024\030\001}\180Q\171\159\129\225\204\030`\024\241\160z\011\024.\127\255\253g\248\245\151\145\225'P\232%\203O\006\128\000b\249\176\007\024[L\140\012\236\192\000g\003\166\011\209\143\015\025\190*\1830\252\004\198'\211\249\237\012\239\214\158b`\016\016F\1371\160C\024\254\002]\245\011H\255\004r>\252\253\199\008\016@,\012<\192\196\198\012\244\030(\189\000\189\200 %\003w=\131\152\028\003\003\207m \230C2\232?\200?\160\132\004\164@\024\200\254\243\143\001 \000\011\228\182\002\000\008\131P\1371\232\255\191\182\150,[{\020\241\194\209.-aZ\209\221w9\012\203\137\016\002\238\137#\015\233]TP\212A\176\212\007\175\212\184\002pHm)\000\1310lU\239\127Oa\130\160\136NM\140\251i\191\146\230\209\208\2017\003\008t\222\1509\212\199\n\"\155v\212K$y\224\188\149\240\170\214}\252AirK\204'J\225\199\017`\000\141\005\000\184\027\212~\179\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bw.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002:IDATx\218bL\233\156\255@INV@UF\130\129\131\141\141\225\239\127F\134\255\012L\012\255\024\024\025@\224?\003\0040Bi&\160\008#P\150\153\241?\195\143_\191\024n?y\193p\239\209\227\015\000\001\196\194\202\198.\242\226\195WnMy&\006I!\030\160\014&\168\001\140`\140l\018#T\020\162\224\031\195\227\215\031\024\128z\025\128f\176\000\004\016\203_\006\150?\172@\205\247_\189g`aaf`f\130*\255\207\0087\016b\014\196\000FF\136a\127\255\253\007\235\001Y\252\231?\243?\128\000b\249\241\159\149\129\225\031\011\195\237\023\159\024\222}\253\0054\136\137\001\006\254\163x\234?\156\005\002\127\255\253cx\251\249\007\144fa\248\254\151\137\005 \128X\004e\149\025\184\184y\025\152\153Y\024\152\128\1340\130\188\192\136\172\005\019\252\255\015\012E\160-\194\"\255\024\254\254\253\195\192\246\225-#@\000\177|;z\142\225\031'\023\0033\208[@_\0011#\003\178\2130/\161\184\007(\244\015h\024\208w\012\127\255\252e\248\246\249##@\000\129d?\0001?\003e\224\007@\000\177$eM`\224\225be`ef\004z\015\136\153@\174\250\143\020\241\232\000\024\249\192\136\248\251\015\232\154\191\255\025~\003\241\199\207\223\025\000\002\136E\220\219\157\129\135O\136\129\141\157\029\024\141\172\012L\192\176bdd\194c\012(\140\2541\252\003\134\205\239_\191\025~\253\252\201\192\254\2309#@\000\177\188\189s\141\225;77\0033\027;\208\016V\006F\160A\255\025\153\129\138!\137\0189\250\193\137\145\017(\250\255/\195\127\160A\255\254\254f\248\251\235'\195\231\015\031\024\000\002\136\133\013(\193\002\244\015#X\025\0110e\179\001\013\000\209\204@\154\t\205 `\138f\248\011\140\177?\012L\224T\254\023h1\019\003\200\012\128\000L\1469\014\000 \008\004\017\240\255\191\245@\001W+\203\205$\179\205\168\217\208h\149R\016\025(\190(\000<\249\239\248\233\238\0180\206\005!\154\139A\197;\173=\249\0080\0005q\208\228g\166Dr\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_by.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\201IDATx\218b<0o\222\003^&\014\001~EE\134OG\24730\252\255\207\240\159\129\001\140\177\001F\024fdd\248\253\233\019\195\203\253\251\025\158\157<\249\001 \128XX~\254\018\249~\252 \183pB\018\131\144\146\018\003#33NC\144\013c\248\251\151\225\221\217\179\012_O\158d`g``\001\008 \022F.\190?\1402\n\012_^\188`\248w\2452\003\019++\\\195\127l\006\192\228~\255fx{\228\008X\236/\003\195?\128\000b\249\253\246;\195\159\163'\025\254\243\1370\188_\188\152\129\137\133\133\129\024\240\255\207\031\134\175\143\0301\252\003\178\127\003]\004\016@,\191\159\254d\248\243\229\015\003\215_^\176\0043##VW\160\187\238\0310,\255B\\\003\194\140\000\001\196\194\174\170\200\192\254!\136\129\133U\012,\200\004T\128\226\005l\174\001\025\004\165a\006\001\004\016\0118\006X\217\025X\25511p\002\217\204 \195\008x\235\031\194\0000\000\134\234\127\128\000b\249\253\236)\195\191{[\024d\229\162\024\190\003\005\249\208\002\149\001\135\139\254@\194\134\225'\016\191\001b\128\000ba\229g`\016{\242\158a\187\253G\134\140\205P\235X\1360\233/\2124\144I\239\025\024\001\002\136\133MN\128A\200\221\133\129\2357P\246\029T\017\182@Bw&\204 \016\254\196\192\000\016@,\012\159\223\179\252\253\251\130\129\225\179\008\196\244\255\208@\250\143#!1\"\1336,\176\25410\001\004\016\203/\022\1507\159\184\164\255}\254\nL\210\031\129F\252\003*e\132\186\235?\220M\140P\131\016\236\255\012\255\225\006~a\248\t\016`\000\229h\161\\H/4\t\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_bz.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\219IDATx\218b\220\199\192\240@\196\220\\\128\223\209\145\129\137\143\143\129\225\255\127\006\024`\004\226\191P63\016#d@\146\140\012\255>}b\248\184\127?\195\155\147'?\000\004\016\203,\006w\017\230\147\172\220\222v\026\012\nJ*\012\140\204,@UL\012\255\128\218\190\0011\011\003'\216\192_\012?\024\184\192\006\130x@\217\191\127\024\030\156\189\195\176\245\228\021\160e\238,\000\001\196\178\130\161\248\015\003\0037\195\189#|\012Nl\252\012\172\172L`\133\012@#\228\244\216\025\248\149\223\001\141\251\199\240\229\129\012\195\131\243\191\193F\130,\250\253\251\031\195\190#\252\012\199\025T\129\252/\255\000\002\136\145\141a\241\007\006\0066~\144=\178r\\\012L,\140\012\127\024X\025\250\166\1362\252Q\221\196pp\221\005\134\159\223\1582\132\186$0|\253\165\203P\148\250\019\232\170\159\012\255\255\252gx\252\232\027\212\187\223\190\003\004\016\208z\014\006\144\139\2543\2400<z\196\196p\251\254\127\006=-\014\134?*k\025>\172x\195pp\207C\134\029'>1LMX\200\192*~\144\193\206\137\131\225\206}\006\176Z\144\030\144^\006\006vF\128\000b\249\015\24697\208\231,@\t\160\228\127f\006Q\251\223\012\202\156n\012\127\212\1900LV\139d\224`\153\1950w\174>\003/\163\017\131\148-0\208\231\136\001\213\254\006\234\249\015\132\192\144a\248\205\008\016@,\144\184a\004\251\027\020. \204\252\239\031\131\150\152(\003\131\191\024C\218\138\231\012\127\190\1792\204[\159\201\192\240\2311\195\182c\175\161\234\254C\227\020\172\247?@\000\001C\228;4.\254\0001\019\216\199o\143\2420\236\138\221\202pb\229K\134\021o\005\128\202\181\024\196{\026\025\\R\004\025^\030\181\003\170\248\004r;4R@.\250\206\000\016@\192\192^\006\012l.~&\176-\204@)&`\188\1763l\222&\196\192`\183\146\225\217A)\006vf.\006a\187\167\012\204G\157\024\188\\\255\000U~\007\226\127`\023\253\003\027\244\241'@\000\001\221u\000h\016??0\192\128\002\172P\012\146\020`\176\142\022`\208\014\188\207\240\247\223_\134\251\187U\025\246\205\006*ex\007U\243\027\138\127\002\241\235\159\000\001\196\024\206\224\243\133\149\129\141\155\tj\208\127\0066\160-\236@W\253gx\008\142\006Q\160\151\025\025>3\188b\144\007\197\0158\000~\002\201_`\131\254\001\217?\025~\252\006\008 \198C\192,\194\201\192 \004\244\0243\208yLL\224\196\015\014\000Fh\022\249\015\244\004#+$c\128\217\012\144\208\249\255\023\154<\129n\252\t\016`\000\129\139\225\158\186\167E\001\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ca.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\132IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\153\143\143\129G\215\142\129\215B\157\225\223\159\127\012\216\000\019\011\019\195\231\0197\025\190\\>\196\240\247\211'\134\151\251\2473\1888y\242\003@\000\177\17630\136\2528y\146\155\205\206\142\129OI\137\129KZ\128\129\147\139\139\225\223_\168AL\140\016\250\223\127\008\151\153\137\129\t\168\134\245\171\018\195\167\179g\025\128z\025\128f\176\000\004\016\011P\250\015H\193\187#G\024\024\217\216\024\152x\133\024X\149e\129\006\253e``ff\248\247\2537\195\255\223\127\024X\1849\025\254\003\197\152\25433\252x\254\140\225\243\229\203`=`;\128\008 \128X\254A\024\012\239\142\031g\248\250\244)\131\020+/\003\139\169\001\195\223\255\255\025\152\254\252a\184\235\225\197\240\255\235\023\006\165\195\135\192\154\152\129boO\159cx\182x1\195\207G\143\192z\127\003]\004\016@,\127\161\0061\001\2417\160\196\239w\255\024\024\153\152\192\154@\158\249t\254,\195_\176\159 b \143\130\212\128\2122A\245\002\229\025\001\002\008\238\"\168\019\025X\184\212\128\006\1770\\\020\018\128\184@F\157\129\233\215\015\134K\"\"`y\227w\031\024\216y5\224\150\195\012\002\008 \022F\168\000\008\179\0001\235?F\006vN\014`\128\2433|\253\246\145\129\225\201M\184%\028 \012\012+\144\026\022$}@\252\031 \128\152\152A\154\161\152\003l\208#\006N6V\006\155\207\239\0244\202\251\025\184\129b\\@\172\156\\\193`\007\012l.\022\022\160\011\239C\212B1\200\012\128\000ba\129\185\004\234=f\230\207\192\224`b\248\251\2357\131\\G\001\131P\188\015\003\208i\012<&z\012\255\128b,@K\152Y\190\128\245\192\\\n4\136\017 \128X\152\160&2A\003\151\129\017\146^\254\255\251\199\240\031\024s\204?\254\000\197\129\201\000\200f\248\007\013M\160\026Fh\192\195\244\002\004\016\200 \176\225\127\161\006\253\249\203\205\240\023\232\133?\160\148\253\231\007\003\179\134\"X\239\159\175? f\128\228@j\160\0061@\012c\002\008\192\226\184\228\000\000\0011t\202$\194\253/\233\179\178\017,F\137e_\155\188*\235v]\132~\017\164.\1369\219\026\251\237\000\199c\134\171\001`\026<J\023\169\004\250\0150\206#\192\000&.\221\143\235\021\187\133\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cc.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002_IDATx\218b\\\024\151/ka{\252\135\008\211/\166X\241g\239\025\1847\191\144\226d\248\232\168/\252\143\147m\199\137\215\012 \240\143\145\225/\003\227\207/\159\191\0308x\253\222\221\007\000\001\196|W X\139\229el\132\177\166\179\022\211\2517\236\"\194z\1982\182\2142?\197\132\239\190\252\195\203\254WP\144\029\140\024}\1885\254\254c\232\237Y\247\247/#@\000\0007\000\200\255\004\152\228\156\241\200\239\219\227\205\025#$\244\006\005\002\000\255\007\000\003\229\013\015\012\243\250?\007\012\136\247\029\000\000\255\000\000\253\000\000\000\221\222\238\198\197\217\001\001\003\002\003\254\002\0007\000\200\255\004g$s\139\165C\027\240\229\201\223\251\"\186\149\244\008\016\007\130\137\031\223\204\188\200\237\154\210\254\220\201\200\014\012\008'(\024\203\203\220\252\252\253\232\232\227\131\135X\226\228\244\002\0007\000\200\255\004\128I\020\021\166\1837\148\206\228\254,\231E\253\243\236\2385%\1606I\022\183i\n\250\207\209`\227\243\"#\022ac,\175\175\207\000\000\n\005\005#\151\149\226\254\000\253\002\136\145\139\167\242\219\023\022\006\006N\176c^20\17620\00800\188c`P`d\250\241\255\223o\006\006 \250\202\192 \196\192\240GMO\253\197\163\151\127\254\188\005\008 fV6\159\223\191\152\025\024\024\025\024\190\196\022D\136J\200\223\191q\019\172\232\023\195\127&\006\006f\176A\\\012\012@\246\255\183/\223\254\252\241\155\149\141\013 \128X\024\025\190\128\205\251\195\198\2065\191\199\144\017\232e\230\213`\017f\006\020\240\215\194V\251\230\213\023\239\223\189gd`\003\008 \230\127\127\181\255\255\007*\250\249\247\239\167\215\239\254/^z\225\234\149[\012\012l\192\184\002\007\224\031\024z\189l\169\247\167/?._\188\249\239\239/\128\000b\020\020\202\252\244\241\02333\011\2161@\1559\024\024\248\193Nb\130D4L?\208\232\015\012\012,\127\2552\240\241\179\001\004\016\203\151\207\159\152\1528\193z \026\216\254\131\216\204H\218\2542\130\244\252\002\171\249\193\196\244\003\168\005 \128X~\255\254\001V\001\241:\196`&p\1682\130\181\253\135\t\194\237\252\t\212\012\016`\000d\139\243\019$D\206\164\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cd.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\214\216\212OX2\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002BIDATx\218L\146\219KTQ\024\197\215>\1839\199\2338\157\153I3+\018B\234!\"C\n\153\"H*\0023\017B$\147^,BA\176\127@\nz\nB\178\160^\234!\0184_\180\030l\186\130\250R\147$\136\023J,\197a\210\185\1683sn\251\236\206\025+\251X\172\183\223^{\239o\017t\015W\149\239\172\173\208TQd\000\024\1297\155\1909\172`\028\145\216v~q\223\204=\245\225\160\192K\210b~\249X(N\148#\022\147\025\251\007\144?\012\227\192C\243\165+\140\249\226\177h\252\218`\194\148\005\206\145Z\203\250\"\202\204g\179#\150\174\177\193\021\142'\133\012\030\028\217Q\180Rm\199*gg1e%>L\232\166\168\149f\005\139*c\153\227\015\166\205/y+\182f\128\211\189\012G\000'\237\t-\180\216\003\181\031\163\228\181\017\223(b\148*\246\156\213\022xz\180\153\224\214(_\164P\182M\016s6D0\023\144w\135\023ZY\127\211\219\231\234P2\149(v@\180`&W_\252\236\228\229>\238\226\252OM\000\019)\243\187\151\177\029\013\188/\024N5\136\175:Go\135\006\150V\151\130i\132Bj\218:\239\239\175\187\241H\188\242m\185\012\166\001')\128\016\239\013\240\251\195\249Fu\228\230X\247\174\190\239\171?\002I\148\132\228\148P'\0124\\\237Q\174O'\246B\183\000\029\188\155M\004@\1485\1891\024m\143\245\028|1\149\154R\147\008\006|\235\190\186\220\203\250\011\189\225\182\241D\0216\000.\015\153\194\162\128\251kT8W\254\166+\254\228p\239d.\230\255\229\002|V:\163\1437\157\184[\222\017\141G\176H \232p7\202(\008\245\1569.F&\014\241\190I\201\134\172!\0318m|j\169\185S\2145\178\018AV\000\175\131\176\194>\\Q86l\011\182\137l\134\188C\160\004f8\162\127\189T}\127\127\231p\250\020]S\192\025[\021!\1271f\131\026\158ri\242\190R\2017\151>>\208>\1489km\168 \150W\015\246_\185\1820\203\147\163\195X\255-\192\000,0\003\130\179)D\226\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cf.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\142IDATx\218bd`\152\246\192\217NL\192\194J\145\129\151\143\157\129\225?\019\003\003\003\019\195_\006.\006y\134\027\012v\012\167\025@\224\024\131.\195]\006C\006f\134\175@\222?\006F\198\127\012\159>\253`8\184\255\t\195\169\147\015>\000\004\016\011\003\003\183H{w\t\247\237[\237\012\204\172\182\012,\204\255\129\n\025\025\2543p2\1361\0083\2401\168\129\013\146\005\242\152\129\1343\002!\2086\134\191\127\2552\156;\251\131\225\248\201\247@>\027\011@\000\001\013\250\241\199\1999\134AY\151\133\193\201\2335\003++\003X!\003\208\144\175\012\015\0244\024\174\130\013z\196\240\155\225&\131$\144\245\022l\209\239\223\127\025\014\029y\006t\249\031\144\011\255\001\004\016\227\181k\215>pp\242\240\179\17913\176\176\128lc\006:\251?\216{_V\174b\184\221\223\007v\131|B\018\131`F\026\216[\255\2553\130\013\255\243\231\015\216e\239\223\191\255\014\016@,\140\255\2553\000\205``\006\2021\002\0210\129\130\008\164\021\200\248\245\134\129\225\203\253\251`M?_\253\005\n\001%\255\253\007K\255\251\247\015\172\007d%\200A\000\001( c\020\000@\024\006\166\212JA\031\225\224\255\031X\144\154l\025\142\\\2000w~\019\1369\225\204\130Uh\164v\0298E\242\175\186\200L\244k4\023\171Hk\218JR\251\002\136Ec\171\006\0030\012\025\024X\193\190\130\224\127@\172\199\192`s\139\129a\021\003\004$?\136f\216~\027\200\184\008\2465\0030p \2487\016\127b\248\015\016@,\012\028 \235\160\006\177@\013\002)\004\166\004v \159\019\026\244\220 96 \022\128Z\0042\228\015\212 \160\163\000\002\136\005D0\252\132\170\254\135\228\"PP\252\1350Q\192wH\016\194\013\250\005\198\140\000\001\196p\235\022\195\135\215\175\025\254\127\254\204\240\255\231O`\016\000\189\013\012\0220\254\214\205\240\127\031\003\004\127(A\136\131\212\128\212\130\244\128\244^\190\204\240\003 \128X\128\018,\144\128\135`\160\"\160j\136\229\239\129\206\254\006u\200\007\160\237<\127!l\152\218\127P\2312\002#\027 \128X\190}cx\003d\252\003F\02830\194\192\145\006\196\224\228\253\024\024\253\175\025\160\236\015\192 z\197\240\031\168\025\148b@\134\252\007&#\006\160\203\024\222\190e\248\t\016`\000\202g\247}\018\016+{\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cg.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\023IDATx\218bd\152\192\240\192\\\198\\\192Q\218\145\129\143\141\143\225\255\255\255\012`\000\165\224\224;\003\131\130\024\003\131\1550L\128\145\225\223\191O\012_\190\236g\1845\241\228\007\128\000ba`c\0169\249\249$\183\029\139\029\131\146\160\018\0033#3\166!\191\025\024d\229\025\024t\185\017B\255\255\255e\248\245\235,\195\251\249'\025\158Lb`\001\008 \022\160\216\031\006&\006\134#\175\1430\1761\1791\1762\177\"\169\006\226\031\012\012\134R\012\012\154\236@\133\127PM\127\181\230\008\195\205\022\006\006\160\212?\128\000b\001\139\253c`8\254\2308\195\211\239O\025X\152X\016\134|b`\136\211c`\176\228d`\248\249\019\2175\012\012o\151\252a8_\252\008\232!\006\134\207\012\012,\000\001\196\130\236\141G\223\0301021B8\239\025\024\146M\025\024r\228\0240\192\203\153\012\012\023\170\2553p\000\217\127!\152\017 \128X\160\225\006\193@/\254g\004\154\252\129\129!\194\130\129a\130\006\166!O&\000\013\169a`\224\130:\250\031\212 \128\000bA6\132\001\024\206 Cb\172\025\024\230b3\164\135\129\225\018\208\016\001\132\001`m \251\001\002\136\005\197\016`\152\228;00\244\169b\026\242\172\143\129\225z5\003\131\008\148\255\007\018\153`W\129\180\002\004\016\011\216\016F\168!\214\016C\152\152\208\194d\026\003\195\213R\006\006~\168\210\127P\026\026O \131\024\001\002\008\162\005hH\142\t\003C\151\n\022\151\24420\156\203f`\224d@M\167\200\030\001\209\000\001\196\194\240\145\129%\211\150\129\161U\025h:\208\248\191\127!\209\011\002\207\187\025\024NW20\240@\189\193\128\228\146\255\2080b\128\024\198\004\016@,I\234\012o\n\133\025\254\189{\199\192\012\244\018\019\0163\002\241\255{5\012\140\215\230\131\013\249\255\003\170\159\017\020\169@\nj\216\127X\128\003=\244\019 \192\000\243\167\146\170I\170\216\171\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ch.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\216IDATx\218b\252\255\255?\003\012\204gd| an. \238\232\200\192\202\199\199\128,\007\002\140\140\140\012\191?}bx\185\127?\195\139\147'?$\254\255\175\000\147\003\008 \022d\133\236\012\012\"?N\158\228f\179\179c\016PRb``ff\128\025\197\008\"\254\254e\248p\246,\003P\013H-\138^\128\000B\225\0005\253\001\209\239\142\028a`fcc`\225\225e\224q\247\004\203}\217\189\131\225\015\2085 9d\1810\000\016@(\006\253\131\226\183\199\1433|{\250\148\129\147\155\143A#9\t,\247|\217r\134o\239\2231|\127\244\008\174\014\025\000\004\016\0192\231/\020\179\241\n0\252\251\244\157\225?3/\195\127&&\134\191@\252\159\129\155\225\239\167o\012l\252Bpu\200\000 \1280\\\004r\175\252\180\205\012\146\190\186\012\012@\003\254\253\252\203\192\012\020\211:\188\157\129\233\223?\134\151\187n0\156\015\179\192p\017@\000\161\024\196\008\197\204L\204\012\172\172\172\012\255\128\129\205\252\015\026\020l,\012L\192\192ffe\134\171C\006\000\001\132b\016\200f\014 ~\150\027\196\240\170\132\131\129WZ\153A\227\228.\176\220M+\015\134O\143n3\252\253\245\147\129\147\001-\164\129\000 \1280\162\144\021\228\255w/\192\209\254\243\253+\006v&H0\254\186v\146\225\247\231O`/\177\162k\004\002\128\000bA\015yfd\204\205\195\240f\223Q\160\196\127\006FNN\006\022\160A\127\161rLh\006\001\004\016\186A,\012H1\242\245\237+\134\203\2066po\255C\146cBs\020@\000\161p~00\188\001y\031f#z\128\254G2\012\168\246\003\178\028@\128\001\000\221X\147B\240\150\031\225\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ci.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002:IDATx\218b<\227\175\254@P\195H\128G\199\130\129\137\147\151\129\225\239\127\006\134\159\159\025\024<\163\025\176\129Y\012\199\129$\011\003#\195\127\134O\255\1902\236\255r\137\225\228\251+\031\000\002\136\133\131\133Q\132\249\193enV]S\0066I)\006FFf\006\134_\223\025\024\184\184\176\026\164\198 \014$\153\129\246\253e8\251\235\019\195I\230;\012\012\028\204,\000\001\196\194\200\192\252\135\145\129\137\225\247\205\243\012\204,\172\012\012L@\131\190\127a`0\180\199j\208U\134\007@\146\149\2257\195_\134#\191o000210\252g\249\007\016@,\140\127\217\024\024Y\024\024\254\220\186\204\240\227\253k\160\004#\003\227\135W@\175%`5h\017\195\001\160F.\134?@\246\163?\239\128\234\129.\255\247\135\005 \000\027d\140\004\000\008\194\176\022\152\253\255\239\\\028=f'\176\238~ M\026\236\128\149\195Y\224NX\023\144Kf\246\005M\200\246=TZ\247!\168\npx\005\016\208 6\006f\160a\172@\151\128\132\152\128~\007\025\206\200\193\129\213\160\255\255\133\128\004?\208\021,\144\136\249\015\018ef\004\008 `\024\00153\130\152\140@\195 4#H\144\149\149\001;`\130\184\226/\200\197\255A6\131\012\248\015\016@,\140L\191\129\225\251\015\236\019f\160<3\208EL,\127\1291\204\130\195\160\143@\215\252\007\0078\216E W0~c\000\008 \160\031\128\193\198\004\244\014\208\016Ff`\252\253\003\025\250\015g\024\001\019\025\016\127\003\026\006\148g\252\015\014/\134\255?\025\001\002\136\133\129\249\023\003\196\020&\136 \196\211x\000#\148\006\186\026\028w\127\193\134\003\004\016\203\127\134\191, \127\131\\\251\015h\203\223\127\192\024\001\249\255\239_\028\006q\002\021\002#\226\223_\144\006 \2557\208\236?L\000\001\196\242\237\207\2557\160\200\004\250\152\153\t\232,\144/\153~\252\255\207\240\242%\216jFF\198\255@\000g3\252cd\004;\250\031P\205\031Pv\002\026\248\246\231O\128\000\003\000\158\219\170`%\229\154u\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ck.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\174IDATx\218bl\240Hy\160kk-p\250\1834\003\031?\031C\138\240#\134-\127\021\025\158?\251\204\160,\206\205`\165\194\201\176\230\252w\134\239\223\1900\128\000#\227\127\006\022\022&\134\255\255\2552|\248\240\129a\223\190K\012'O^\251\000\016@,\235\222\240\137\168\223\190\202]\022\173\197\240US\141\129\241\2103\006\0071\017\006\017\003\001\006f\014~\134\011\031~0\200\201\1294r00313pq\1792\252\251\247\151\225\223\223?\0127o\253e8w\238!\208xf\022\128\000b<l\164\245\225\199o\030~y\007S\006\001\013Y\134\015\031\2553p\243\1772\176\241\n1\188\255\198\196 \014\180}\245k\030\134g\255\184\024D\132\185\024^\191\250\000v\205\239\223\127\024\014\030\188\205\240\241\211'\134kW\159|\006\008\000I\000\182\255\001+R\162\240\181@\027\015\240\249\214\000\157\2484\000|\213u\000\179:\133\000\015\024\007\000?\233\240\000\139\220\234\000\173\182\222\000#\030\015\000\224\226\236\000\253\253\252\000\000\000\001\000\252\252\253\000\226\226\238\000\007\008\011\000\024\025\013\247\002\136%\147\251\003C\225\132\211\012\235\239\001\195\128\2433C\164\145\002C_\247^\134\235On0\232\219\1872\204t\248\206\176\244\241{\134\219\127\216\024\030?\250\n\244\022(\164@^\005\209\252\012\127~\1791\252\254\195\205\008\016@\140\012\012\197\031\024\024\004\249\025 A\t\242/\016\131T\129t|\007bn\006Ff&\006\005eY\134\135w\031\131\195\006d\016\004\252a`e\227d\016\147\226\252\t\016@@\017.\168\001,P\204\0045\012\196\230\005+\255\255\2477\208\005\255\024$e\165\129\177\0063\228?\003\019\144)%'\193\240\245\211\183\255\000\001\0044\161\008\232\"6\168\139\024\224\138\208\217\140\140\191\025T\212\020\024~\254\252\007\012\232_\1920\250\199\192\205\203\205\240\227\251O\134\023O\031\252\000\008 \160\181_\129\202~@]\197\000u\017#\018\134\026\0074\239\206\173{\012\188\188\156\012\226\018<@\227\2551<~x\159\225\215\175\159@\217_\140\000\001\0044\232\027\212\0270\239\192\194\t\230EF\184\203@\209\254\233\211w \254\008\228\255\133bPX\254d\000\008 \160\206\223,\016M\172@\204\006\196\236P\0269\204\024\160\026\254@\241/\176f\136O\192bL\000\001\004T\249\231\013\208\016\160\170\255Pg\252\007:\129\241?\196)\255\161\158\130\177\025\208\2160\195\127\252\004\0080\000\155\184\246\020\139=vE\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cl.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\243IDATx\218bdc\152\240\192\204\\A\192\206Q\134\129\151\143\131\225\255\127&\134\255@\152\150&\202\240\239\223\127 f\192\014\024\025\024\254\253\253\203\240\249\243'\134\183o\223~\000\008 \022\006\006v\145#'\159qGD\1692\232\232\t2\188~\243\019\168\138\153\129\139\139\011h(\030\131\128\150\253\248\241\131\129\145\145\145\129\147\147\147\005 \128\152\2540\176\253in\209b\240\241\231a\208\211gc\016\021gb\184z\245\019\195\159?\191\129\248\015\195o \013\195\127\144\240\239\223\191\025~\254\252\t6\008\232\242\127\000\001\004t\224\162\015\202\210\188\252\135N\1530\176\176\1760\196G]g\184u\255#\195\137\019\150@\005\127\129\026\254cw\015\208\181 \195\254\002\157\252\254\253\251\239\000\001\004\244\026\023\003\003\1430\195\186\157\223\025\254\000}\245\244-\027\195\253\251\012\012LL@)&F\016\194b\008\136\248\199\192\194\204\196\192\240\231/\003#\0113#@\000\001\149\029\248\192$(\200\255\239\253/\160,P\130\143\155\129\225\211O\134/_\148\025@\193\243\007\139) \215\128\\\242\023\024\216\191\127\253bx\245\234\213O\128\000b\217\195\224\192\192\244\030\168\031\168\134\021\136\127\127b`\224\000\210\135y\024\024\254\130\131\020\028A(\000d\193_(\006Y\255\017\168\012 \128X^\002\025\188 \003\128\152\005\138\1911@\012\251\1433\190 .\253\013\241\003X=@\000\177@\147\004\0243!\209LX\012bDr\017L\237\127\136!\140\000\001\196\194\004N5\008\t\006$\003p\185\136\001\201B\152^\128\000\002\025\004v\213_4[\209\013c\196\"\015\211\0034\140\t \128X~00\188\001\n\254cDr\216\127H\0123\254G\232a\132\026\242\031\136\025\161\134\253\135\005:0~~\002\004\024\000\013\030\194\233\245\147\211\138\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002%IDATx\218bdHbx`\174b.\224\168\238\200\192\199\193\199\240\255\255\127\006\006v\006\134\144S\012\012?\024\024\024\2541 \000\136-\155\198\192\192\008\23012\252\251\247\137\225\203\151\253\012\239\223\159\252\000\016@,\012,\012\"'\159\157\228\182\211\180cP\146Pb`fbf\000\1381\008\16810\252\002*\255\143f\016\023\023\196\160\255\255\2552\252\250u\150\129\153\249$\003\007\007\003\011@\000\001\1810\252\001):r\239\008\003\027\011\027\003+\011+\003\003\027\003\131\233U\236.\018t\131\241~3\252\254}\132\129\145\017d(\195?\128\000b\001\203\002\173=~\2558\195\211\143O\025XX\128f\24320\248,b`\248\002V\142\000 \182h\022\204\153\127\024\254\252y\0046\232\223?\006\022\128\000\130\027\004\002\143\222\003%X\024\193V\255\185\0151\136\199\024\"\247\254,D\025\019\019\196k\255\254\253\007z\011\236\026p\128\001\004\016\019X\022\230~ \251?P\193\255\191\255\025\254\002U\168\197\253g\208;\240\159A\031\136\165\018\129\238\007\138\177\179\255g`c\003a\006\006V`(\128\012\003\025\004\016@L\208\008\128`\016\015$\001\1405\160\026\134\199\011\025\0248\129\012\014 ~?\015\028\007`\003\144\013\001\185\016\136\255\003\004\016\011X3\011\212\000\024\013T\196\005\226\20200\\\214\004\218\001t)\1594P\224)P\140\005\228j\136\007\254\254\133z\021\232\008\128\000b\001k\132\185\004\137\006\153\249\229\t\003\195O\168\175A\014f\131\134\01784\254A\012\000\135\200\127\006F\128\000\130\184\136\t\201{\140\136\192\255\199\000K|\016!\2284\133\014\000\002\136\005\168\146\005%\161\252\133`Pb\252\tKdP\240\007\234\029\144\215\254A1\216\181\140\012L\000\001\196\002L\028o\128V\253\003\026\200\012\164\153\128\016\236\166W@\249w\016\205 \135\128\130\td\254\255\023/\128\242\255\193\134\252\255\003\148\252\t\180\237\237[\134\159\000\001\006\000\142\014\170j,\251u2\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cn.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\157IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\129\145\227?\195\223\239\012\012\255\025\176\003F\024fdd\248\253\233\019\195\203\253\251\025^\156<\249\001 \128X\216\025\024D\190\157<\201\205fg\199\192\175\164\196\192\204\195\204\240\2557\003\195\191?\184\013\002\131\191\127\025>\156=\203\240\227\228I\006\160\025,\000\001\196\002\020\250\1638\155\129\129\223\239\008\195\247%l\012\255\191\17920q\002\005?\2271\004\008\254\255\254\205\240\238\200\0170\251\031\016\001\004\016\203O \131\233/P\227\159\227\012\143'>e`\228ba`\017d`\248\245\018\183A o\255\255\243\135\225\235\163G C\024\128\030`\001\008 \198\249\012\012\031x\129\014bb\000\241\024\0248\228\128~\127\005\180\226\007\003N\0002\232\223\255\255`C@!\240\145\129\225\007@\000\177@Md`\1318\145\225\207G\160\130\239\152^\129\025\128\014@z\128\030b\004\008 \144#\024\152a\024\168\242\255\007\160\203\024\240\027\244\031\162\025\012\152 \248?@\000\177\128\012`E\194,X\012\192\230\181?P\159\252\135:\002 \128XX\160\154a\0061Cm\193\230\021F$\239 \179\129z\024\001\002\136\133\tI3#\022/0\224I\152\200z\001\002\008d\0168H\254b\137bd\154\017\139<L\015\2080&\128\000b\001\198\242\027\160\224?F$\135\129\194\252?\132\134\233a\132\026\242\159\017\148;\160\226\208\024c\248\196\192\240\019 \192\000\028\233|U\225\253\186\168\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_co.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001{IDATx\218b<s\134\225\129\160\160\185\000\015\143#\003\019\019\031\003\003\195\127\006\226\000#\195\191\127\159\024\190|\217\207\240\254\253\201\015\000\001\196\194\193\193 \194\204|\146\155\149\213\142\129\141M\137\129\145\145\153(c\254\255\255\203\240\235\215Y\006\160^\006\160\025,\000\001\196\194\200\200\240\007\136\025~\255>\002\020d\003*a%\210E\191\193z@z\255\255g\248\007\016@ \131\192\156?\127\1423\252\248\241\020\168\128\005\204\199\239\026\016\249\007\168\231\017X\237\191\127\012,\000\001\0046\136\137\137\001\232\026\144\129\143\128lF\162\220\243\239\223\127\176\030\136\161\012\140\000\001\0046\008$\192\202\n\161\153\152\2543\192\\\137\2035 \012t\005\195\223\191\008\131\000\002\008\168\252\192\007\006\006^~\006\0066\176\183\128F\129c\132\128\231@n\002{\143\129\225\023\016\191\251\001\016@@\157\031\129\140\191H\1340\017\025\216\255\144\012\251\200\000\016@@\221\236\012\016\012s\0173\146a\140X\\\0023\228/\146\139\216\024\001\002\136q\031\003\195\007\160\191\248\217\161\017\207\140\166\253?\022#\255C\141\249\013\196?\129\2485\144\002\008 \150\183@g\252F\243\216\127$\140\154\150\017\024\217c\239\129\218\000\002\136\229\027\003\195\027\160\233\255\024\017~b\132F\012\227\127\132\003\024\161\006\253G\138\208\2550\015~\002\186\008 \192\000\189^q\171\187\243)\154\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\012IDATx\218bdf\232\127`f\174 \224\232(\203\192\203\199\193\240\255?\019\003\003\003#\026\006\129\255(\152\145\241\031\195\231O?\024\246\239\127\204p\234\228\131\015\000\001\196\242\151\129A\228\248\201\023\2206vR\012\138J\\\012\204\204 \131\152\208\012a@3\236\031\195\223\191\255\024\206\158\253\202\000\212\011\146`\001\008 \198\171W/}\224\225\225\229\231\224`g\224\224\224\196\162\025\023\248\207\240\227\199\0150\254\244\233\227g\128\000b\249\203\200\194\240\151\145\153\225\251\159\255\012\191?\188e`f\231``\248\241\157\225\031\023?n#\255\255\007\187\235\247\159\127\012\255\128z\127\253cd\001\008 \150\147ZZ\012\220 \183\0011\191\164.\195\149\170f\006\149{\015\024X&\0202\252\196\225>\176\007\129\134\001\131\133\225\015\016\127\004*\003\008 &\152B\144\167T\174\175f\248\"\192\197\240\165\204\159A\162h*\003\019P1\011\018fF\194\160PdFX\196\008\016@,\176 e\005\226\251\167\1753\\=p\128\225;\1316\131\234\235\131`1&4\151\192\232\191P64j\254\003\004\016\211\127\168\183\190\000\177@|\021C\153\154\004C\236\225\203\012\159\023\173\004\139\179B\229alV\168KX\144\226\022d\006@\0001^\187u\235\131\144\160 ?;\007\007\003\011\027\027\003;\011P\t\019\019D\018I!2\248\247\239\031\195\159?\127\024~\255\250\005\142\181\023/^\252\004\008 \160\182\127@\027\254\001m\248\203\192\006\196\204@\173L(Z1\131\027\024W@\209\127@U }\016\012\016@@U\147\129\190\226\001F\0280\218\225\024\022:\204h)\251/\216\024\006\134_@\012\138\211\031P\252\2417@\000\17703\252\127\003T\004\148\253\007\212\245\015\024f\127\128:\025\129\186@\017\n\210\196\012d\255\135\178\129\209\005\150\255\011r\209\127H\228\131\240\143\159\000\001\006\000\134\191\189\152^~\137\188\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cu.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\144IDATx\218b\172dP}\176\207|\190\128\163\163\004\131\000\223O\134\255\255\025\025\024\024\152\128\152\017\t\131\192\127$\252\143\129\145\241\031\195\231O?\024\014\238\127\194p\234\228\131\015\000\001\196x\144\129\225\011/\003\003\247\225\210m\012\226\198\150\012\204\204_\193\nQ\013a\1920\236\239\223\127\012g\207\190b\232\238\190\000\228\255\248\n\016@\204.\012\012e@\022\135\195\255{\012\191\184\1913\240XX2\136(q0p1\252f\224\225\254\207\192\205\203\196\192\195\195\200\192\011\196<<\012`\154\143\023\200\231fd\224\224\248\199`a\206\207`m\197\247\019 \128\024\02310|\224b`\224g\006\154&!'\199 \196\203\194 \176h\018\003\163\172\025\212\021\255\024\208\193\255\255\016\215\253\249\243\007\232\178\191\012\239\223\191\255\014\016@,\127\129B?\129X@D\150\225\243?\022\134g\215\2383\2521\241e\14434c\248\191u+\195\179wL\012\154\127?3\252cd\130\026\003\241\238\223\127\255\128\006\254\003\026\246\143\225\221\251\159\140\000\001\1968\151\145\241\131\\x\027\191b]\020\0033\011\011\195\243\238\181\012o\231\02220\254\251\011\214\146\207P\196p\135!\026\200\250\006\013\031\006$\151\1300\200)\239\127\002\004\016\019\200\157_\215\1811\240I\2413\008H\0110\252\\\211\206\192\0044\132\005(\205\002\142?F(\011\029\179\194U\000\241\127\128\000b\001\133\013\011\031\031\195\147\210I\012L\192(e\249\254\005l\135\162\149=\195\239\173\251\024z>00\232\252\253\000\020c\134{\013\228%P\216\252\250\253\155\225\231\143_\012\175\223\188d\000\008 \198\165\192\192\230gd\228g\006\186L\020\168L\154\147\129A\236\210\030\006&\021g\156\129\253\239\223?p@\255\250\245\139\225\199\143\031\012/^\188\248\t\016@, \135\241\002\013\209\006\210+\025\148\024\152\023_e\016\249\197\193\240y\193S\134\255\192\128\252\207\004q\t#\227\127h\202\250\015\014\151\127\127A1\246\155\225\207\239\031\012\239?\190a\000\008 \198\227\192\004)\000L\144\137\012\141\012'\024S\128\225y\023\026\143\204P\204\132\148\016\255B]\248\011\170\230\007\020\127\252\013\016@,\155\024\212\222\1803L\001\202r3\179\253?\005\212\197\n\180\152\021\148T\024!\154\153\129\004(\223\252\003\167 F\134?p6\196`p\002\250\t\016`\000\240I\239\215\2112\139/\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cv.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002pIDATx\218bd`\168~`n\174\"\224\232\168\204\192\199\199\197\240\255?\019\003\003\003\0123B1\008\252\135\226\127`\204\200\248\143\225\211\167o\012\251\247\223e8y\242\206\007\128\000ba``\0219y\242%\183\157\157\018\131\146\018/\003333\022C\0240\012\251\251\247/\195\217\179_\129\134\188\004\242YY\000\002\008h\016\219\031\144\198#G\0303\176\17711\176\178\178 \025\194\132f\208?\184a\191\127\255\001\235\129\168a\253\007\016@@]\156@\006\011\195\241\227\239\024\158>\253\197\192\194\194\012\213\196\002t\221/\134\127\255\152\128\222e\003\242\127\161\024\249\231\207_\134G\143\1900@\2443\177\000\004\016\208 n \131\013,\249\232\209\127\160\223\2553\136\137\127``a\253\195\160\161\247\146\225\209MA\006\030\190\127\012\023O\139@\013\252\015v\237\255\255 \023\243A\141ef\004\008 \160A\188@\006\023\136\003U\192\205\240\139\243\005\003\151\240=\134\189\027|\128b?\025\236#60\252;i\0065\228/\148f@\22631\002\004\016\227\205\2217?\008\240\t\240\179\179\179\003\195\135\149\129\249\255\003\006\198\191\236@IYD\152\255\006\005\195n\160o]!\218\255\255\007\007\246\239?\191\025~\254\252\201\240\234\237\171\031\000\001\196\194\152\230\203\192\196\196\004\196 \007\190\003\134\203w \027h\203\031\144K\005\1616?\000\250\030\232x\160F\134\127\138\012\255\160\014\250\011\164\153\128\225\207\0084\020 \128X\024\230la`\016\016d`d\231\000b6\006\166\255g\128\146@C\152tQ}\1924\019hS:\196\149\255\2541\252\251\251\135\129\241\0230\002~\254`\248\255\234\005#@\000\001\029\222\254\129\129\129\131\031\020K\016,\206 \172\244\144A^\249.\195\185\221n\224(\015L]\201\176~v\000\200\127@\252\025\020g\208X\252\003\197_~\002\004\0160\132\237j\128\006\176A\020\177\131\003\133\143\155\133\225\253\019Y\006;\191\007\012\204L\204\012\031_\1710\188~\006\143!\180\128\006\005\224\247\255\000\001\004tQ-0\000x\132\128\233\001\168\130\019\232p\014\160\024;P\021+#\019#H930lA\172?\208P\249\195\008q\205\015 \251\027\144\254\n\196\239\127\002\004\024\000\130\182\202R\211\178\017\168\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cx.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\162IDATx\218bdX\192\240\192\\\196\\\192Q\194\145\129\143\133\143\225?\016\130\016^\192\008B\140\012\159\254|b\216\255l?\195\201g'?\000\004\016\011\195{^\145\147f'\185\237\152\237\024\1488\148\024\152\025\153!\138\255\2276\004\004\254\254\251\203 \242\251,\195\180''\025\024\216\024X\000\002\136\133\161p\207\031\006\157]\012Gz\1831\176\025\1771\176~de`\248\201\128\223U@\195~\255\255\205p\224\221\017\134\139\202\012\012\138\175\024\254\001\004\016Ph\245\007&\006%~F\006\014\006i\175\221\012,\249\147\024\0244\128\138\159\000\241;\168\129LP\204\1360k\186\228\031\134;\255\0311Xs00\024\236b\248\014\016@@\169\013\031\164e\249\249e\228y\024N\030ae`d\228a`0\217\194\192\144Q\197\144`\245\157\161[\008\168\235\023\003\131\232y \253\027j (\024\127\254g\176\150``X\169\n4\244\006\195\015\128\000bbd\228dx\254\148\157\225\244\241\255\012b\146\255\025\164\196\1903\252?\029\205 \152|\153\161C\246?C\193\187\255\012\150\207\2543,\214\006F\003+\0163\0011\243\127\006\1606\134g\127\024\024\030|c`8\248\129\129\017 \128\152\220\130\185\025\254\253\003\217\194\196\192'\196\193\192#\198\002\228\188d\248\192\240\135A\000\024\\?\004\025\024\244\148\024\024Be\128\194@Z\025\232m\021\160\152\170\000\003\003\023\208e6\167\024\024\142\188b\248\015\016@\204w\175\133T\000\149p\008\13923|\254\248\155\225\233\195\239@\238\031\160\235\133\025\222<\144f\152\031\189\139A\251\015\019\131\006\207\013\134\159;\172\024~z\173e\248\162\203\192\240\226=\003\195\235\207P\175\254f\248\003\016@\1920Z\247\129\129\129\147\159\129\001\228\018\016fF\nY9\006H\020\002C\148\225+\016\243B\212\152.c`\232(``\000\026\200p\005\136\2393\252\004\008 \160\142\031\01222L\012\182v E\127\161\209\196\0085\236)\016\003\237ax\014\196@'0<\004\226{\012\012\167\195\025\024\156\129bA\245\016{t\024\024\000\002\008\168c\201\023VV>n..N\134\143\031A.b\135\186\140\t\234:X\156\255\135Z\244\015\236uH\020JAh\135\182\223\000\001\004T5\251\001\003\003\0150\146\217\129\186\216\128\186\217\128bl@]\140\140\016\195\224N\0041\129\236\191\140\016C~\253\1358\007\132\153~\002\004\024\000\245\135\191\143\143 l\012\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cy.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\146IDATx\218b<z\244\232\003aaa\001^^>\006&ff\006\134\255\012\196\001F\006\134\127\127\2552|\254\252\137\225\237\219\183\031\000\002\136\133\147\147S\132\145\145\145\155\149\149\133\129\131\131\003\162\130(\240\159\225\199\143\031\012@\189\012@3X\000\002\136\005\168\241\015\136\243\243\231O\006f\160\139@l\132R\006$\131\255CY\140`\012\146\251\249\243\023X\253\191\127\255\255\001\004`a^R\000\000a\024\n\166\254\238\227\253\193K\t.*6V\2342\1297\005/\148\004\213\013r\005\228\027\018(\205\139\2529\t\156J\216\0288\173\251Wq\204\202\021@L\140@UL@M\204,\172P\003\128\142\252\247\135\225?\019\019\195_\134?\012\191nOc\248y.\143\225/\144\255\251\195M\134\159\167\028\024~\220\242c\248\255\151\147\129\153\141\023\172\023\168\152\017 \128X@\154\153\152Y\128\222b\005{\141\133\157\157\225\247\221C\012_\246\13410\n\000\173g\007\154\251\139\129\225\239\195\021\012\255\12730\240\216mg`U\176\006\218\245\143\225\207\207\031@o\129\156\204\200\008\016@, \2313\001m\003\025\194\202\n4\140\137\149\129U\215\159\129\243>\003\195\199w@C~20\000\221\202  -\194\240\157\195\149\129E@\014\168\142\141\225\207\223\031\012\255\129z\254\002c\142\145\137\233?@\000\177\128\130\013\232?\006\022\022&0\230bcb\216|\239\024\195{\245\011\012I\236@\211\152A\241\204\2010\255\237k\134\191B\214\012\241\146r\012\191~\255\000j`\002\134)\019\195\159\223\144\160\007\008 &F\166\255\224\160\001\025\006\194\127\255\255e\008R\182g\016\231\252\2000\225\197E\134\141\127\245\025\250^^f`\226\151bHST\000\186\237\015\208\213\140p\245 \189\012\140\255\024\001\002\136\005\017\153\016\012\"\127\253\251\205\224\171d\199\240M\194\156a\253\147\189\012%\198\005\192\176bf\248\245\007\020\179\255\145\018\199\127\176^\144\025\000\001\196\242\255\255?\022\144$(\208\128\233\001\232\247\191\012@\138\225\247\159\239@\17523\132+\1861\252\000\138\253\249\254\011\145\162\255\253\005\171\005\233\001\233\005\0053@\000\018\169 \007\000\016\004\165\245\255\151\182ytV\147\2006\015\030\128\1298\220}\242\224\201\250\187*GXh\031H\224\191\014\179\163\246G\016Z\134\148\016\017\135\014\247\138ffq\005\024\0004j\237Pk\250\145\227\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_cz.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\028IDATx\218b45\156\247`\197\026;\001\030\030\030\006\134\255\140\012\255\2543\016\007\024\025\024\254\253\253\203\240\249\243'\134\183o\223~\000\008  w\242\023\006\006&\238\211'\253\0244\181\005\025\024\025\2553\000\229\137\000\255\025~\252\248\193\240\254\253{\134\175@\000\016@\204l\012Ae\127\025\1848\174\\}\205\240\255\015\027\131\142\030/P\209?\134\127\255\2541\252\253\247\023L\195\240\127$\246_\160m \131\254\252\249\003\164\127\254\004\008 F6\134\197\031\024\024\216\248A>\146\148ca`a\249\199\208\218\164\197\224\236&\0126\240\231\207\127\216\221\243\255?\195\239\223\191\129\150\253\003\185\234;@\000\001\013Z\0134\136\147\031\236i \248\205\008\210\248\141A_G\148a\207~=\136a\160\128\251\143l\008\008C\\\246\231\207_`\024\189\249\001\016@,\255\025\184\128R\220@cX\1284\019\003\235\127&\176\158\011\151\1273\136\136\220e\168[\175\205P\230\n\180\128\001j\022\208\020\144k\254B\189\199\248\235\023\003\01933#@\000\177@\\\194\0086\132\001j\024\004\200\130]v%\208\132\225&\195\013\134\231P\131\024\193nd`\248\011\197\191\128\248#P\n \128X\024\025\190\003\153\204@\005\127\192\134\252b\224\000jPc\208c\216\002\132\241\012\160\160?\015\196\\(\241\197\000V\253\027j\2377 \006\008  \253\019H\129\012\251\001dI\001\021\t1t0\2480\\\004\026\242\030(z\005\136Y\161\152\013\138\209\217 o\001\004\016\011\200\160\223@{\2553\232\002\225\006\134\141\012y\012\"@\201cP\167\227I\143`\2150Ci\128\000b\249\197 \t4\140\135\161\157!\128\161\128\225\028\195u\160\224}\006D$\253G\210\136L\255G\178\008h\024\019@\000\177\2323l{3\157a\210?`\0240o\006\n\000\0210\254\135\1960\227\127\132\030F\168!\192L\004L\252PqX\160\127\002z\011 \192\000\153\228\214\232A\222\127\221\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_de.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\168IDATx\218bd``x`nn.\224\232\232\200\192\199\199\199\240\255\255\127\006b\000###\195\167O\159\024\246\239\223\207p\242\228\201\015\000\001\196\002\020\019\0012\184\237\236\236\024\148\148\148\024\152\153\153\1372\232\239\223\191\012g\207\158\005\025\002\226\178\000\004\016\200\160? \214\145#G\024\216\216\216\024XYY\1372\232\247\239\223`=P\240\015 \128\024\129\196\007 \230\007\241\228\228\228\024XXX\1362\232\207\159?\012\143\030=\130q\191\003\004\016\227u\160A\188@\131@\218\153@\152\145\145(\131\254\001\195\242\031\212;o\025\024~\000\004\016\011H\027(TX\1614\019P\001H\012\151q\255\161\024d\200_(\027\164\028 \128\192\0061\161\025F\200M\255\161\1340\192|\001\020\002\008 \160A\1400\014\216\016f(\027\175\183`1\007U\011\178\024 \128X\024\214\13920\240110\178\131\220\007\148`\006\026L\132I\255\254\002\131\000\020@?\129\206y\251\151\017 \128X\024\190\130\141\003\198'#\132\006\153\0026\008\234\193\255P\154\241?\194c '\253\251\007\t\233\223@>\208\012\128\000d\1451\014\000 \012\002)\233\255?\172\0051qs`\186\228\006\174=n,\165\002\195\136I5\179\158\160\254w\"\148\178p\237+\019J\224\017@,\223~\252\127\003\012\167\127\172L\255\153\153\024\2553\0011#\019D\007\2004\160Q\140\160L\003e3\252\255\007\180\225?\003\200\160\255\255\255\252\253\199\240\019\232\197\183\159\254\253\004\0080\000\022\242\142\024h\214\228C\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_dj.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\019IDATx\218b\156\183\235\204\131\139\255\004\005\204\164x\024xY\153\024\254\254g`\000\"8F\006\140H\152\025H\252\252\243\143\225\214\235/\012w\159\189\255\000\016@,fR\028\"N\\\204\220'~\1782\008\240\1781p11\162\024\242\031\201\016d\195\254\255\255\207\240\248\211/\134g\223\153\025X88X\000\002\136\229\239\127\198?\140@\227\029\005\1273\\\003\n^\255\193\192 \192\012Q\141\207E \151\223\251\240\155\129\001h\241\159\127\255\255\001\004\016\011###\003\008\255\249\251\135A\139\011h\nPn\241#F\006QV\006\006vFL\131`\238\004\025\244\246\251\031 \205\200\240\235\239?\022\128\000b\001y\150\137\137\137\129\249\252]\006F3\013\006]!&\134&\030\006\134\178\171\012\012\223\129Z\164\152\0250\192\255\127\012\012@G0\252ed\006\226\255\012\127\25430\002\004\016\019\227\191\255\012\204S\1421\176\250\2161\176u\238c`\251\241\143\129\159\151\157a\1509\007C\172$\007\195\007F\014`\200r002Ch\006fv\006\006\0226 \031\132Y\025\128N`\000\154\197\008\016@,\172,\204\012L\255\024\025@\022\179\2229\195\192,\018\000\246*(\128\166\254\014g\216\251y\003P#\186\147@\129\004\197\192\160`\248\202\240\031 \128X\152\128\154\152tx\025\152\166\174c`\150\016b`ff\134xu\0073D!\007\166\215\024\254!\005\216\031\008\005\016@\016\187<\141\025\0249\128\206gcc\216\246v?\131\25517\006\006.\1608;\003v\0003\132\t\138\129\"\000\001\132\226h\255+a\012;\030ld`\224CR\252\031#\202P\211\002\2120\128\000b\001&,\176a\188\251x!\254\229\130:\253?\030\215\252C\n\167\255`1&\128\000b\217\254t\251\155\130=\005\255\024\184\129\225\205\0024\251'$\225\162\185\t\147\253\031\148\152\160\134}b\248\t\016`\000$h\150\164V\209[V\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_dk.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\003IDATx\218b<\204\192\240@\202\220\\\128\199\209\145\129\137\143\143\129A\\\158\129\193\207\141\129\225\214+\006\134\003\027\024p\002FF\134\127\159>1|\217\191\159\225\253\201\147\031\000\002\136\133\147\129A\132\249\228InV;;\0066%%\006F\017\t\006\006..\006\006Q^\006\00655\156\230\252\255\251\151\225\215\217\179\012@\189\012\028\012\012,\000\001\196\002\020\251\195\008$~\0319\194\192\204\198\198\192\160\240\149\129\193\212\144\129\225\253\027\006\134\171Wq\187\232\247o\176\030\144\222\255\012\012\255\000\002\136\005\196\000\225?\199\1433\252x\250\148\129\193\208\148\129\209\223\151\129\225\198m\006\134E\139\176\187\006D\252\249\195\240\231\209#\176\222\127@\023\001\004\016\200E\012L@\204\0122\016(\193\244\015(\196\004\020y\252\129\129\225\254}\156\014\250\247\255?X\207\127h\136\001\004\016\227\185\131g>HJ\138\240\179\177\17600\255ed`\226de`\228\231d`\004\169x\245\137\129\129\131\021\1955\255\129\134\252\251\247\143\225/(\156~\253fx\245\230\213O\128\000ba\144\224e`\002jdfgg`eee`ff\006F\008#D\151\172\008v\175\001\013\002\025\002\n'\166\159?\025\152~s\253\007\008 \134\011\012\012\031^\003\229\128v\255\255\001\196\191\229T\128\017\242\247\255\223\254\165\255\255\130\"\007\011\254\013U\011\210\003\210{\133\129\225;@\000\177\192\147\005\0203IK\001\131\008\024F\194l\012\248\192?\168z\168w\025\001\002\136\137\017]\005+\212l&\252\006\161\003\128\000b\129b\176\013 \252\247\031\0278\1771\252\231\198\235\026\024\134\250\134\t \128X\128\145\252\006\200\248\007\140Jf&P\196\127\253\195\200\252\242\229\255\127\207\1900B\021\253\255\015\245\005#$\210\024\161\134\252\255\003J\151@\252\150\129\225'@\128\001\000\224\175\176\178P\133\129\140\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_dm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\004IDATx\218bd\152\192\240\192\\\198\\\192Q\218\145\129\143\141\143\225\255\255\255\012\012@\196\240\147\129!M\157\129a\203V\006\134\175\159m\025\194#4\025f\221\154\197\192\192\006\148c\004\"FF\134O\191>1\236\127\186\159\225\228\147\147\031\000\002\136\005(!r\242\243In;\022;\006%A%\006fFf\136AL\012\012\\\\\012\012\n\178\012\012\223\191\138\001\217\\\012j2j\012\012\127!\006\253\253\255\151\225\236\219\179\012@\189 \195Y\000\002\136\005\168\233\015H\226\200\171#\012lLl\012\172L\172\012\012\252@\197\239\025\024\204W30\168\001\185\127\217\1752\188\155(\193p\213\245\005\003\131\008P\238\003\003\195\239\127\191\193z@z\025\2541\252\003\008 F\134.\1600\007P+\208!r<r\012,\",\012\012/\025\024\246\18200<\242\006:\238\014?\003\211\239/\012\1274\2552\232\000\189i\145\015\212\168\193\192\240\231\197\031\134G_\030A\\\248\149\225;@\0001^\191\206\240\129\151\151\129\159\005\168\159\137\t\132\025\025\030g\000\189s\129\129\129\229-\003C\174z1C\216\197'\0126l+\025\190K\002\029+\195\192 \187\002\232\136\127\255\129\024h\224\031\006\134\183o\025~\000\004\016KT\008P\003\200\016F\136\223\1913\255g\152~\013(i\198\192\160~\135\141\225\185\1480C\167J\015C\248\018\006\134\179Z\012\012\002g\024\024\\]!a\014\nK\160y\012\191~30\002\004\016\203\191\191\019\025\2541r\002\013af`dae\248\255G\128\129\229\191\0310\208A\138\1271x\223]\1950#\152\133\225\006\211\031\006v\160&\022\160\171\255\254Y\207\240\159\229;\195\255\191\223\128\006\253\003\210\159\255\003\004\000I\000\182\255\001\218\218\218\240\017\017\017\015\007\007\007\000\006\006\006\000\003\003\003\000\223[Q\000\253\211\180\000\229\230\000\000\028\013\000\000p \000\000X\223\000\0009\n\000\000\252\0315\000&\183\198\000\253\253\253\000\250\250\250\000\249\249\249\000\233\233\233\248\002\136\145\161\015\024\216<\192\192f\133D9\1314\016?\001FZ\002\003\195=`\1922n\001:\159\003\024\158\134\012\012v@\2391N\000\202\235\001\241#\136\215\024~\131c\241'@\00011p\003\025\188P\204\007\196\223\128\216\152\129Ap#0`\129\129\202\011t\133(;0=m2c`\004\242\025\220\128\248\011\003$\137\192\244\001\213\000\004\016\200\013,`\147\255Am\000E\231\029 \006&\007\133\167\012\012\153\002\012\012\206\207g2H\191;\0064\029(~\019\170\006Y\015#\003\019@\000\177\000\195\243\013\208\134\127@o1\131\004\192\194\140@\233\247\012\140/\129\222\249\246\031\024\150\236\031\024\129\225\192\192p\003(\206\003N\130\1448\003\025\244\007\236\194\159\000\001\006\000?\237\233\208Y\007\195\217\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_do.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\149IDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\255\127&\006\006\006&\134\191@\146\139\157\153!&^\128\001\004^\173\218\204\240\243\195s\006\144,#\008322\252\254\244\137\225\229\254\253\012/N\158\252\000\016@,\012\012\236\"\167O~\224\182\181\147ePT\226e`f\134(\253\007$9X\153\025\184\184\184\192\006\t*\2012\252\254\194\0116\008\012\254\254e\248p\246,\195\143\147'\025\216\025\024X\000\002\008h\016\203\031\144\011\142\030y\197\192\198\198\196\192\194\202\0026\232/\195\127\006^NV\006;G\136A_\239\220a\248\245\246%\220\160\255\191\1273\188;r\004\204\006Z\250\015 \128X~1\176\001\153\172\012\135\142\191gx\240\244'\003\011\011L\233?\006f\160xl\162\016\152\247|\222l\134/\031?\000E\128\134\128d\255\252a\248\250\232\0178\008~\000]\003\016@,b\002|@&'\208&F\134_\159\024\024~3B\194\224\205\247\223\012\186*B\012LL\016\131\185\004\228\025>]\185\194\240\151G\016b\208\255\255\012l\002\226`\151\1790\252g\004\008 \150C'4\025\248\249\249\129\222b\003\134\0153X#( A\024\004B\147\1832\240};\2070w\243b\006\013\144k\128\006\128\240\191\127\255\128\193\244\151\225\215\175_\012\175^\189b\004\008 \022\144\006\144f\144!\172\172\172`\026f\008\008h\190\201e8\251\030\232%\214F\184\024\200 \144! \000\210\011\196\255\001\002\136q\153\128\216\007>\006F~v\160f\022\1443A\006\131\"\229\251\023\006\017E\029\006\245\203G\193\026\188\156\2390\2369\246\156A\130\135\013\168\n\228\170\127\224p\252\247\255\015\144|\255\003 \128X\254|x\005\014\176\191\224\212\003\161\255C\233\143\215N\192\195\232\218\1817\012\127\127}ax\250\142\005I\005\008\003#\157\2253#@\0001\177\130\227\012\024\236@\204\0125\140\017\134E$\224\222\017\017\005\166\022`\012s\000Ur\000Uq\128\210\025\208-\236@\131\216\024~3\000\004\016(\178Y\024\160f3@\013\128\243\2551\193\195\226\247?V\176\214\255\016\0304\201\254\134\164\"\134?L\000\001\196\002L\003o\128\146\255\024\145\028\004\228\003}\206\192\200\254\247?(F\128a\251\159\241\231\239/@\169\159@\169\191\140 \239\252g\248\005d\127\003\210?@^\251\t\016`\000\191\152\224Q\200\024\018\134\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_dz.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\031IDATx\218b4\201\021y\160\163l\"`\164l\195\192\205\206\203\240\239?\003\195\127\006F f`\248\195\248\159\225\011\211\023\134$\2534\134\127@\254\191\191\255\024\192\018 \192\008\226\255e\248\252\249\019\195\219\183o?\000\004\016\011#\011\163\200\141\231\231\184\141U-\025d\197\229\025\152\024\153\193\006}\231b`\224\249\240\143\129\239\213O\006\230\251\239\024X\132x\024\152%\248!\006\253\007\019\012?~\252``ddd\224\228\228d\001\008 \022\160\166? \011.><\201\192\202\194\202\192\004\196\159\128\234m\246\252d\224\248\254\151\225\129\192\127\006yEc\134\127\159>00|\253\200\192\"%\198\192\200\204\0044\235?\195\207\159?\193\006\253\251\247\255\031@\000\177\252\253\203\200\000\130\151\031\159ex\253\249\005\195+YV\134\248\142/\012\156\015~2\228\229\2410<f\255\196pB8\011h?\015\195\159\127\255\024~~\253\n4\136\025l\208\239\223\191\129^db\248\251\239\031\011@\0001\253\253\207\194\240\007\132\255\1772<\250\250\138\225\199\173\135\012v{\1741t\025\188a\184\200\249\146\129\237\198#\006\166\231\191\024\254211|?y\133\129\153\135\155\129\001\200\006\025\192\012\242\0010(\024\25431\002\004\016\203\159\255@\193\127@\167232|\229ad0<\242\157\225\014\208\254\179\198<\012\178\247\2551|\019\018e\224\144\022`8)\194\195\192\193\193\205\160\251\250\005\208\016f\134?\191\2540\252\005\006\246\191\127\224\144g\004\008 &p\2403Bb\001h<\200\"\006\022\016\023H0\178\129\024\127\025X\207\190\002z\140\129\129CV\155\129\225\229W\006V66\006VVV\006f\160\023\153\128\174cdb\250\015\016@L,L@\133,\255\128\248/\003\255\207\223\012w\172\217\024\244\129\154\204\207|fx\162\0064\244\217+\006\022\023y\0063\160\237Z{62\240*\1382\000=\195\192\194\194\004\198L`w\252g\000\008 \160A\127\024@\152\149\229\015\003\199\191?\012\175e\152\024\214\235p3\212\173\253\196 \252\252\007\195-#F\176\173\172@\204)#\198\240\255\251\015\006f\160n\144\001`C\152@\174\254\199\008\016@,\204\204\255\129\018\255\128\130\016I\185\135\255\025\218\235\249\025\248\138\2553L\172\255\192\176]\241?\195g\213+\012\191_\191\001\250\013h\152\149!\003\208V\006h\130\002\187\006\020*\000\001\004\212\011\1402`T\130\210\216_`\160\255\251\205\196 {\147\153\161\172C\148\161+Y\132\129\249\027\003\195\231\165\167\025~\255bc`q\178`\248\011\012\159?\127@\129\252\031\136\255\129\147\001\200\013\000\001\196h\154/\242\000\232n! \023\2326&&\160a \225\255\127\129Q\250\029\232\229\167\236\207\254\223\201|\nN\181\191\127\254\001\234\254\207\248\239\031\208\160\255\255\254\255\249\243\027h\193OP\022\249\t\016`\000`\216\024\240\131E\031\023\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ec.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\0020IDATx\218b<s\134\225\129\160\160\185\000\015\143#\003\019\019\031\003\003\195\127\006\226\000#\195\191\127\159\024\190|\217\207\240\254\253\201\015\000\001\196\194\193\193 \194\204|\146\155\149\213\142\129\141M\137\129\145\145\153(c\254\255\255\203\240\235\215Y\006\160^\006\160\025,\000\001\196\194\200\200\240\007\136\025~\255>\002\020d\003*a\133(\004\225\223\012\012L\172\184\140\250\013\214\003\210\251\255?\195?\128\000\002\025\004\230\252\249s\156\225\199\143\167@\005,`\254\191\127\204\012\1517\255c\184{\248?\195\223\175\012\0122\250\140\012:\225L\012\188\130\127A\026\129\224\015P\207#\168Z\006\022\128\000\002\027\196\196\196\000t\013\200\192G@6#\216>\166\255\252\012\203\031|d0\180\215d\248\247\152\135a\217\171\211\012],\252@\249\143`\249\127\255\254\131\245@\012e`\004\008 \176A \001VV\008\205\196\244\159\001\226\202\015\012\127wJ0\008\173>\197\192\"\202\192\192\225j\205\192\199}\145\129\133\029\162\025\232\n\134\191\127\017\006\001\004\016\139\134\198A \205\011\196@\021\012\204\224\216``\224a\224\022x\196p0.\142\225\254\199;\012?\239\189cH7fb\2084\221\207\240\226\177&P\254#4\020\129&1\252\004\226w\255\001\002\136\133\129\225\003\216\191\160\176\001\186\007\138?0|\253\192\193\240X\247\031\195\205I\205\012\127\191\253e\224s|\198\240b\026'P\238\0178\160\129n\130\226?`\245\000\001\004\180~\007\208$\030~\006\0066\168a0W\129\162K\144\193Lu.\003\007\251w\134CW2\129\252/P\023\192\\\0032\228\023\200E?\001\002\136q\031\2088\160)\252\236P\1730c@\224\027\020\131\180q\0031\023,\013A\141\249\0135\2465\144\002\008 \150\183@g\252F\243\216\127\164\244\013\163\191\195\2113\004#{\236=P\027@\000\177\000m|\0034\253\031#\1961 s\024\255C\"\131\241?\194,F\168!\255\161\201\014,\254\015\234\178O@\023\001\004\024\000\011{\178[\221\135\221(\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ee.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\150IDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\255\127&\006\006\006&\134\255\012\140@\026\134A\224?\0243\130\233\127\012\140\140\255\024>}\250\193pp\255\019\134S'\031|\000\008 \022\006\006v\145\211'?p\219\218\2012(*\2412033!\025\0003\132\001\1970\016\254\251\247\031\195\249\179?\025\128z\129|v\022\128\000\002\026\196\246\135\129\129\149\225\232\1457\012ll,\012,\172\204h\134 \187\008a\216\159\223\127\193z@z\025\024\254\252\003\008 FV\134M@#9\248A\202e\2298\024XX\144]\129\205E\016\240\231\207\127\134\199\143~@E\190|\007\008 \144J\144\219\248\225Z\025\2095c\007\255\255\255G\230\254\000\008 \022\002\n\136\005\140\000\001\196\196@\029\240\031 \128\168e\016\003@\000\177\220\186u\139APP\144\129\131\131\003\024kl\192\192fa`b\194o\254\191\127\255\128\129\253\135\225\215\175_\012?~\252`x\241\226\005#@\000\177\252\253\251\151\001\134A\146 \1280\008{\172\193\012B\214\011\016@,\191\127\255\006a\176fP8\255\001&4&&f\228\152F\011V\144A\127\025\254\0015\255\254\253\139\001\164\023h\016\019@\000\018\201\220\006\000\016\134\129\228\217\127R\164\148\017\1430\014t.,\187\184\243\204\236D~\140&r@UT\204\028\007\144\175\131\018de\148\026\224\155\188!6\246^m\205\209\"b\\\001\006\000%]\174]\253\151\025\020\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_eg.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\153IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\25410\252\001\137\191=r\132\129\153\141\141\129\145\149\021\167!\200\134\253\255\253\027\172\007l&\003\195?\128\000b\249\005d\176\001\241\235\227\199\025\190?}\202\192\200\194\002Q\008\213\192\004\213\252\015I\012\236\245?\127\024\190<z\004\022\255\014t\017@\000\177X^\191\206\192\203\203\203\192\0024\128\137\137\t\140a\000\164\225'\195g \253\131\129\131A\020\225-\144\193\255\254\129\241\031\160\129o\223\190e\004\008 \022&`\160\177\000\195\133\013\232%f \0132\008\020\144 \252\139\225\025\195\245l\019\134\007L\130\012\254}[\024XX\021!\145\001\196 C\254\002\195\t\200\001Y\192\008\016@, \013 \205 CX\161\134\129\196\192\224\237w\006Y+c\006>f\030\006\214\015\159\024X\164X!.\005j\006\027\002\242:\196\023\255\001\002\008n\016\2040\152\171@\128E\\\135A>e+\144\245\021\136\133P\188\005\137\184\191p\031\000\004\016\200\234\015@\204\207@\025\248\t\016@L\012T\002\000\001\0042\136\133\026\230\000\004\016\200\1447\208d\194\0125\0249\0251\016`\195\189\006\016`\000\197\185\127i;\161\242\174\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_eh.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\214\216\212OX2\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\149IDATx\218|\145?/\004Q\020\197\207\2517c\217\217\217LAT\"\219(Pl\175\1786\n\013\253v6Q\209i\020(\196WP(|\001jBe\133\144\152\008\027\137D)\161\177\178\134\197\1727\235\190\153]\026\188\185\201\228\221\156\223\185\247\221\203\000\228\243\249B\161\2248N\171\213\194\223\1351\022\004\193\209\193\193\184\239K\186\251\190_,\022s\185\028\231\252\031,\138\162\135\203\203%\223\031\004d\146\170T*Zk!\196?\216\176\214\211\199\199\164x\161\202\025\215\227\204d\251\250z\013\198\005\164\192\167&\243\182\220\178\236\247\183\242K0C\198\247\247Q\140\201\189\221}'\227pA\013rF\159n\161z\139\161\001\216\150aR6N\174\212\226B\250\238.\177aqH\207K\187nF)E\165D3b\235{h\212\209t05bT\027\135X-!x\164Y\2338\154\tF\243\161:\132\196$g\141\134y\176\176\160\148\193^#\132\159\244',\025\151N\n\158U/\220l\214\238RR)\025w\138\179k\140\230\144\2342*\219\198\225\1855W\238\185\185IJ}\000O\132\185\235\030K3(0\025\027\210\014H\250\017\182GB\206\221\169t\237yy\171^:mc5\147^\001z\226E\200N\031IO?k\006\153B`v\031k;\144\161\1938\221M\240\142\250\215\008\129wlN`r\030\213~#\020\024\163\253wf\020\254\022\223\249\006\030\178\216\030\134\247\132/\001\006\000\128\196\144\240\165\250\191\153\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_er.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\167IDATx\218bl\231cxp7\213LD\216\205\241\015\191(?\195\255\255\255\025\024\190300\252b\192\013\024\129\136\145\145\225\227\207\143\012\251\239\239g9u\255\212\027\128\000bQ\248\196 \224\217{\138[\152\209\142\225\151\137\018\195sQf\134\023\130\012\012\255\197\128\026\216\128\248\007\016\255\1974\232\239\255\191\012g\158\157a8\245\250\020H\221\031\128\000b\249\006\020\191\014\196\"G\1420h\202\1793\168\220ea\208dadx\202\206\192p\233\031\003\195=\003\006\134\127B@\005L@\252\021\136\1273\128]\253\231\223\031\134#O\142\128\013e\248\207\192\004\016@\140\179\024\024>p30\240k?\005\250h\130\028\195\239\251,\012\204\159\025\024T\154\129j\234\025\024\158\222d`x\204\204\192\176\221\132\129a\191\025\208\199\138@\141@\254\159\215\127\024\030=\127\0042\004d\193w\128\000b\156\0024\200\176\141\129\159\225\003\003\195\219>\006\006nGF\006F\160\228\143\227\012\012\n'\128\174\213c`\224\005\170\149\003b\160\003\025.\002]\182\202\158\129a\139\205\127\134\223\170\016o2\220a\248\001\016@, \239\243\19930<r\000\186\154\133\129\129E\240?\003\155\004\003\195\235=@\175?d`\016\006\138\191\220\207\192\240\017\226\016\006Q\160\134\246}\012\012\029@|\023h\232f+\160\193\150\012\140\000\001\196\004\242:\211\027\006\006\001%\006\006\229e@6P\007;0\028\248\128\226\236\156@W\188\006\026\206\128\0293\255ca`<\178\152\129\161\251\242\127\128\000b\001\217\242~\006\003\131L\014\003\195C?\160A\218@E\002\012\012\186\219\024\0248M\025\024~^a`\144\006\170\145\135z\237\028\208]\149\012\253\012\027\025\226\129)\004\228\175\159@\252\146\001 \128\024\230\002\195h%0\200\030]b\248\255\226'\195\255\011~@\246Bp\196\252\255\172\204\240\255\030Pn\007\003\243\255h\134\142\255\028\012\223\255\131\226\012\020\249@\003\128\2483\016\191\006\226\203?\000\002\136a!\208\160u@\217\205@|\018\136\255\230\001\013Pb\248\191\n\1689\152\161\239?;\\32\1984\008 \128\024\214\000\013\002\198\240\255[@\188\022\168\217\031\168\153\145\225+P\242\015\030\252\011\148\252\129\248#\212\160K?\000\002\136\229\026\131\210\135\t\012Y\172G\024\130A\193\014\012{&\160\199?\252\135F,\136\002\185\002\137\253\143\017\146x\254\129\012\005\165P\160\158\247?\000\002\012\000\137x\005\149\002\2431~\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_es.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\012IDATx\218b<\204\192\240@\202\220\\\128\199\209\145\129\137\143\143\129\225\255\127\006\162\000##\195\191O\159\024\190\236\223\207\240\254\228\201\015\000\001\196\194\201\192 \194|\242$7\171\157\029\003\155\146\018\003#33Q\230\252\255\251\151\225\215\217\179\012@\189\012\028\012\012,\000\001\196\002\020\251\195\008$~\0319\194\192\204\198\198\192\192\202J\156\139~\255\006\235\001\233\005\250\225\031@\000\1770n\005\186R\018h\026\243q\134\031\018O\129\194, W30|\006\226_@\252\015\228\0134\215\128\137?\012\127B\03010\254\001*\249\192\192\002\016@,\012J\012\012L\188\012\012\204@\183\237\234x\194pk\227\127\006Y\025\006\134\160u\016\013\1408\028\244\239\223\127\006\230\127`\243\024\024\216\024\024\001\002\136\137\233\007\208 fF\1345\187\149\025\152n\255c\224d\210g`\212nb\152\179V\144\129\133\131\137\129\131\227?\nfg\255\207\192\198\006\194\144P\128\006)#@\000110\001\013\002b\205#\166\012\255\223s3\136\026\1653\240\171D28\158\245b\224d\253\007V\140\140A\006 \027\194\004\209\255\031 \128\152@\225\193\196\004\180\137\227\019\131\229w`\008\157jf\144\155h\193\192\250\255+0\180X\025XX\02400\200\000$C\192a\n\016@LL\028\016?\223\n\144d`\183\248\199`\250\134\137A\252\223[\134\243a\018\012\127\217\152\225\138\2091H3#4\000\129I\143\017 \128\024/\173g\248 \161\192\200\255\233\013'\131\132\250/\134\231/\213\024\020\164\1590\188{\252\135A\132\231\007\003\019\219?H\204!\00740\022\254\252\005\167\000\134\239?\025\024^\188f\248\t\016@\140\023\024\024>H30\240\179\131\003\031\232d f\"\144\132@\230\254\133\166\014\1609\012/\128\020@\000\177\000\025,\159\161\002,$\026\244\007j\024(\226\001\002\012\000N\244\142n\227:\153Y\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_et.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\208IDATx\218b\148\1437}`\168\170/`\161n\202\192\195\201\203\240\239\031#\003\003\003#\195\255\255L`\026\021\252g`d\252\007\166\153\152\2543|\249\254\153\225\196\205\211\012\231o_\252\000\016@,L,\204\"\151\158\\\2316\2154f\144\023\151``fb\006\026\194\0085\004\211 \136a\255\025\254\254\251\203p\229\209G\006\160^\006\160\025,\000\001\196\242\231\031\203\031&\160\134Sw/2\176\176\1760\1760\179B\212\131\012a\252\013\196\031\161f\240\0021;\1960\160\212\159\191\191\193z\254201\252\251\203\248\015 \128X^|\230d`\248\197\200\240\252\226\029\134K\207>\000\013ba\248\007\244\022\007\247k\006\161\127\252\012lO\139\128\154\153\024~INa\248\192\254\140\225\219'I\006&\198\191@\131\2540<~\253\006h,P\255\247\191,\000\001\196x}\189\216\007^^\006~\022fF\176\191\025\025\025\025\024\217~00p}bp\142|\205`\170\254\154\2257\208\017\167\175\1372\028Z,\0054\147\133\225\2557^\160\247\255\131\195\243\207\223\255\012o\223\253\255\001\016@\160\016\005\218\199\196\192\002d\177\002\013ccad`\023\255\200\176i\2432\006A\233\223@\246c\006.\137'\012\002\210,\012\243\214\174g`\151\250\006V\003R\011\210\003\210\011\242,@\0001\253ac`\248\011\194\028@\223s\002=\207\197\192\192\006\012\142\175\252,\012\215\222\0081\008s\127g\144\227\251\192\240\240\019'\195W>V\0066>\006\176\026\144Z\144\158\191\016\253\255\001\002\136\229?3\208X\160\209@\02330\001\195\153\145\025\168\2403?C\150[8\195\210\157\191\025n\2540e\248\003\012s\030\001\022\134Z\255P\134\127\2398\025\024A\234\193\174\001\130\191@C\153\2553\000\004\016\203Y\015\001\006>`4p\0001\208,\006fp\148\0112\0080<e\232\225\210f\232\146\221\198\240\027(:\253\153\005\195e\157\223\012\239\024\148\192\145\250\023H\254\001\210?\128\244[\134\127\140\000\001\196\194\198\241\143\129\029\024\192, \012\2461#\024~f\144g\224`|\203\208\255H\tl\243K&q\134\015\\\170@#\255\001\181\254\007%Y\160(P/0\208\217\254\255c\000\008 \022&\230\191,@\183\002\133\128~f\004\166\t\176\155\128\202\129\137\242\023\131$\195gf\tX\154\006\167j&F\1441\127!\198\252\135$P\230\255\127\153\000\002\136\005\232\1807\255\255\131\"\146\137\025(\014\206\023@\233\255\144d\247\031\202E\176\025\255\255c\132\166\247\255\016/\254e\248\244\255\223O\128\000\003\000\156\211\237\129\248\155S`\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_fi.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002 IDATx\218T\193!\014\128`\008\128\209\143Q\t\254\007\1778\139\1997\152\200\006\1557\192@e\184\217|O\220\253\030cLf\134\170\002\205y\t\199\206g^a[\154n~D\132\170\"3\137\136\231\021@,\028\028\028\"@\003\184\217\216\216\024@\024(\207 .\202\200\160\166\006\209 #\201\192\192\197\133i\016\008\252\250\245\011l9\208\012\022\128\000b\001\154\252\007d:H\144\137\137\tl\211\251w\012\012W\175B\020\243\t20(\203c\026\242\031h2H\015H=\144\253\015 \128X\152\152\024\025@\248\239\223?\012?\127\254\000+z\245\138\137a\209\"\168\139\228\024\024\012\245\254c\024\002\002 = \189 s\000\002\136\229\197kF\006\222\239L\012,,\204`\211\197E\153\024\206^bd\184\127\031\162\233\228Y\006\006'\199\255\012/^\162\186\232\239\191\127@\003\152\025\254\252\249\207\240\238=\003#@\000\001C\228\198\007\006\006~~\006\0066\1604(\176\153@A\t\197\216\192\127(\254\0072\014\020R ?\252\004\008 \022\136\006&\168!\172P\026\151!\200\134\253\133\178Az\153\254\003\004\016\203\129\195\012\012\130\002\140\012\236\236\140@\23911HI01\244Ocf\168.\129(+\168``\232n\254\207\240\252\005r\024\253c\248\013\244\210\159?\140\192pedx\245\154\129\001 \128X\164\196\129\006\001c\134\131\131\017\024\253\016\195\012\180\153\224\1544\148\025\128b\255\025de\016\006\001\131\007h\200?`\17212\252\248\001r\211\127F\128\000b\001E\0002\006\129\023H\182\191|\003s\005\178\13901@\000\001\013\250\207\002\177\229\031\024\131R\235o$M\223\255\130\162\0255A\194\212\13004\1493\001\004\160\145\012V\000\000A\024\154\154\255\255\157BR'!\136l\030:m\135m\135\241zD\012\152\171\170\002 Y\132iL\201\255\184/J\179K5\132\\\162L\197\0174\207)\246vs\247\253\004\024\000\007\246\221$Z\176R\234\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_fj.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003`IDATx\218\000I\000\182\255\001\204OE\224\149\254a\016\023+-\000\014\016\007\000L\018\204\000\183\2445\000\252\247\002\000\017\t\249\000N\029\218\000\179#6\000\002\251\254\000\001\255\255\000\001\000\255\000\001\001\255\000\002\000\000\000\246\251\251\000\205\227\237\000\212\227\232\240\002\136\197\225b\156\200Q\139+\220\1594E\024\158\nY2(\178\0110(\253\151dP\227x\201\160\192\198\202\176\235\149#\131\162\000\003\003\203\255\191\012@3\024\128&\129\193?\160\1617_\127a\184\249\2417\003\019\027\007\011@\000\000I\000\182\255\004l\000\171\252\161\214!\000w\029\172\000%.\229\000\228\236\231\000<\023\239\000\n\255\247\000\201\243 \000\020\236\202\000\219$F\000\000\248\251\000\252\254\007\000\251\000\004\000\000\006\000\000\251\250\000\000\204\240\003\000\000\002\002\000\254\254\000\254\002\000I\000\182\255\004\243\252\n\000\250\252\015\000\252\214\208\000\241\235\248\000\229\223\210\000\000%5\000\003\255\237\000\201\232;\000\008\219\216\000\20078\000\233\243\013\000m\190c\000>\001\210\000\224\254\000\000\"\249\252\0001\205\244\000fn\207\000\013\254\219\004\002\000I\000\182\255\004\156\245_\000\1966\223\000\171\241S\000p\191T\000\236\015(\000\021\200\183\000\127\017\173\000^\023\246\000#\229u\000+\236\254\000\253\252\002\000\222\028#\000\015\241\193\000\020\213\252\000\177\252\243\000\226#+\000\006\005\003\000\253\255\003\001\002\136e\138\251\017\134\242\163f\012\251\030\171\000}\254\146\129\193\240\019\003\215\173\023\012\013?\220\024\246\137\222f8\017\208\202\144\202\214\198\240\131\145\133\225\174B\028\195\205\231\214\012e\135V1\220\203Le\248\196\197\207\192\242\137\017\232efF\128\000bT\152~\238\195\031.1~1\209\159\012,,\156\012?\128^\229d\251\197\240\143\241\015\195\219O\188@/\254d\016\248\246\131\225\025\135(\195\1485\181\012^g\2301\\\251\205\205\160&(\193pK\132\143\193/|!\003\207\135\187?\000\002\000I\000\182\255\002\014\251\249\000\026\252\241\000\006\238\254\000\003\237\249\000\011\243\243\000\005\239\249\000\008\240\253\000\027\253\240\000\022\253\247\000\008\006\253\000\023\254\238\000\146VU\000\004\217\233\000,\253\012\000\003\196=\000\172\130s\000\003\255\000\000\005\002\254\000\002\136\137\237\255\031\006fp\\\252a`e\252\203\192\206\244\155\129\153\241\031\003\211\127 f\248\199\192\002b\003\019\013\015\211/\134'L\210\012\013\143\153\024>\026=a(9\024\201\176\228\145\005\1318\211+`\210\248\195\008\016@,L@/03\003\0213B42\128\147\0260\201\252\007'=\006d \241\251\015\195\146\019\015\024V%<e`\250\244\133A\246\2233`\002\003F\004\208\012\128\000\002\026\244\143\005\168\139\225\255\223\255\012\127\129Z\193\00602\194\013\130\025\006cI123\252\255\245\150\129\249\223\015\006\134\191\255\128\234\254\003\029\194\192\004\016\128b2H\001\000\004\129\160\150\244\255\135\006\029:\132P\218x\144\245\228\2342Z\248\153\176\025\217FO\181\2468F\020\142\163\030\129\022\201\154Z\187\150\007\254\020q\220\148\128\202\235\242\246\242/\192\000\245\152C\155\168)l\141\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_fk.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002lIDATx\218\0007\000\200\255\001\205YV\017Fa\157\238\012\012\251\226I\022\015\027\013\244\155\220(\000\000\2249\000\235,I8\174\213\003\237\226\230\000\000\004\001\000\253\000\001\253\244\243\244\192\193\212\223\222\223\002\0007\000\200\255\004<\204[y\006\201t\131X\002\0122\243\234\240\n\221\195AS%.\024\022\000\253\015\179\235\000\015\003\214\015!\019\000\000\255\000\000\246\254\254\238\210\210\230\197\196\166\t\t\"\002\0007\000\200\255\001\21450\012\203\239\007R4\007\"!\000\004\004\000\002\001\000\254\255\000\025\022\000\231\234\000\000\000\231\t+\161\247\013\000\000\241\008).gO!S\137\205\198\026%(\168\162\002\0007\000\200\255\001\020\013qV\170r{.\002\003\174\172\250\233\008\008\160\131\000\206\206\000\197\168\253\198\243U\248=\224\201\193\000\230\242\001\000\216\255\015U\179\189C\000\232\000\020\019\253()\162\002\0007\000\200\255\002^\156H|/\197\2107a\024m\254\n\249\231\003k\005\022\022\176*\193+\006x\029\177\031\188\228\202\230\228\228\251\227\228\228\n8/1\146\201x\133M2\159\181\017*#\002\136\233[\250\002)\169#\158O\156\024\024~INdu\174\137d`\248\240fB\141\176\240\247\188_\230:\012\210\012\012\226@\0173{\165\015\133j\201Z\025\219\211\244e\148\133\000\002\136\145\139\167\227\219\151\191\012\012\204\012 \192\200\192\192\196\192\240\007L\002\005\12720p\129\197\03120\024\239\248j~g\238\195\223\191\223U\2153\002\004\0163\027\155\197\239_\223\193*~00\000\025\223`\140\159`\253@\198W\006\006\182?\127T\246/\221\024\027\019\241\229\199e\221?\027\000\002\136\145\155'\239+\200\182\255`\027 \182A\172e\0043\254\131\017\163\1651\027\231\143\207\175>\190~\253\228?\191\154\020@\000\001\229b\025\024X\193\142d\129!f\176f\136\254\127`\0044\2477\216\242?`S~\001\004\224\136\014n\000\006a\024\000\218$\018\2089X\133\253\183i\139\148\224V\012p\175\2439Gd5\187\196.4\161n\184\228:\236O$\163 \136E\188\212\147y\187\173O\000\001m\243c`\224``\224\004\251\158\029f33\146#\255\194l\251\t\2469\208\183?\000\002\012\000\134\225\226(\254\199.\209\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_fm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\178IDATx\218b\020\153\176\255\129\177\140\168\128\1814\031\003/\027\011\195\191\255\140\012`\240\031\140\024~Ax\012l@\012\150\129J31\254g\248\252\235\015\195\209\167\159\024\206>y\253\001 \128X\024\2178D\206\127\254\199m\201\194\202\160 \200\201\192\204\200\200\240\255?D\241_\160.\017v\144&\006\134\151?\024\024X\024 \018@%\012\127\129\138.\190\253\206\000\212\203\0004\131\005 \128X\25430\253adbb8\245\250;\003\0273\019\003\011\144\013v\016P\207w ](\195\012v\197\254\151\127\025X\025 \134\130\192\159\127\255\192z\024\128\234\129j\255\001\004\016\200 \134\127\255\152\024N\191\249\197\240\252;\144\007T\249\239?D\195O\1607/\188fd`\005\178\175}\249\207\192\001\212\241\031\234\162\127@EO\190\254f\248\015\212\251\255\239\127\022\128\000b\249\247\159\th\020\200\209\204\012\015\19112|a\004\026\0124\133\021\168\137\007\168\225\2067\136\011x\129b \131?\003\157\199\013T\205\006t\017#\216\141\127A\225\202\008\016@L \003\2541\178\0021;\195W&\014\006k\017.\134\247\246\188\012FB\220\012\031\025\185\024\184Y!\248\011\144\173\200\207\205\240\201\129\151\193E\130\139\225\003P-H\015X\239\127&F\128\000,\145A\018\000 \008\002\017\169\255\191\184\218\154N\142\224\001\217\188\156\164\144\233\162Y\019\205\017y\160\241x\249c[\156\165\240ZfB\2296\133\014\018{\031\001\196\194\200\008\n\023\160\006\022\006\006\030 >\242\249?\003\247\137\127@\17510\008\17632|\250\0071\135\015\232\139{?\025\024\216\143\255c\224\001z[\144\021\018V\255\129a\245\015h\006@\000\001#\t\232W fb\006\026\006\196\002\204 _\003=\012t\2017`\152\024\011\002]\001\212p\234\019\208\002\160\001l\012\160\232\001E$0\224A\209\005\210\207\248\143\017 \128 .\002\025\194\008M#@\012\020\004\166\019\006\006`D1\0281`\005\011r\028\252\005NW _A\147\019\003L\239\127 \013\016@,\140\255\255\129\14630\nA\129\240\031\156\128\2543\254\003\027\201\t\196\001\151\1273\176\131\146\210_\136+\254\0011\227\127\136:\006\144\158\127 \023\254g\002\008 \150\255\191~\188\249\255\229#\208o\172\204\255\024Y\128\161\197\196\200\200\196\242\031\232w`\15602l}\011\212\246\255?#/(\2370\1303\014P\000\2286\160\130\127\192\012\244\007\024p_>\252\004\0080\000\134\220\246\194\231(\160\175\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_fo.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\139IDATx\218b<s\230\204\003AAA\017\030\030\158?LLL\012\223\025\024\0246\205z\204\016.\255\152a\213Ci\006-_y\006\029I\006\172\224\223\191\127\012_\190|ay\255\254\253\027\128\000d\204\209\t\1280\012@\193W\210\196\016)\232W\007(\184\255|A\136\253w\128\187\238\238\151\136\156\170\138\153\209[c=\131\152\147u\012\230\029D\252\147\170\"3\217\150}\188\159\000bb\004j\004\225\223\191\1273\252\253\251\151\225\231\159?\012w\174\190d\248\243\232>\195\221\171\207\024>|\254\195\240\231\015&\006\169\005\233\001\233\005\026\202\004\016@p\131@\146?~\252``\004\226\233\139\1741\252\220\183\159a\211\162s\012\239~\254d\248\137\134A\234@\024\164\007\164\023\232E\022\128\000b\t)y\199\192\194\246\139\129\145\129\137\129\155\135\153\225\213g.\134\187o\185\025\152\222\191ex\252\151\131\1610\245\019\131\130\209_\134\183oA\182C\189\005T\253\239\255?\134\255\255\254\003]\243\143\225\247\143\247\140\000\001\196\216(\158\244\129\139\153\149\159\133\145\t\168\240?\195_^v\006WQA\006%\193\183\012\175\191\2411\236x\254\131\225\215\135\207\012\204@\008\015\031P@\255\007\026\006d\253\001\026\244\233\207\143\159\000\001\196x\211\212\247\131\000\208 v\160u\172@\155\152\1291\199( \202\192\192\194\014T\253\151\129\225\227+\006\134?\191\024\024\152\160\206a\000\135\t\195_\160i\191\129\244O ~\245\231\231\015\128\000bT\148\216\249\129\153\153\151\159\145\137\133\129\139\157\149\225\201W^\134\207\255\1742|w\\\206`q\198\131\225\2183k\006\005\197\239\012\127>\255\005z\030j\016\003\196K@\227\128\225\003\n\252w?\000\002\136e\231!E\006`:\002E!$\250YX\024x\153\24720\253\250\199\240\235\206\011\134\141OU\024\156\1650\211\015(\160A\209\015\n\244\023/^0\002\004\016\019z\250x\011\196\n@[\025\254\131\164\216\024\030\222e \n\000\004\016\011\200\1910[@\24870}\252c\224\006\166\019.\134?\012\002\012?\254\252\005\1781]\004\195\176\196\t\016\128c2\198\001\000\004a`h\244\255\239\196\1938\161Nx8\221@\154\180\164m\017\177\152F\175HPS\178\203\201\183A\028\206\145\238\249?Mg\018\177\149\016f\197\163\148b\"\231\t0\000\174\001?\241z\212\213\151\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_fr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_fx.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ga.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\195IDATx\218bdHbx`\174b.\224\168\238\200\192\199\193\199\240\255\223\127\0068@b\130\001#\018\147\137\145\225\211\143O\012\251o\238g8y\231\228\007\128\000ba`a\0169\249\236$\183\157\166\029\131\146\132\018\0033#3vC\208\012\251\251\255/\195\217Gg\025\128z\025\128f\176\000\004\016\011\195_\134?\012\255\024\024\142\2209\194\192\198\204\198\192\202\204\138\219\016$\195~\255\253\013\214\003\210\0112\001 \128\024\025\"\024>0\1763\240\131\228\229D\228\024X\152X \182\226s\017P\238\207\191?\012\143\222<\130\136}g\248\014\016@\140\215\1753|\224\229e\224g\001\234gb\002aF\006b\192?`X\254\003\186\230\207\031\006\134\183o\025~\000\004\016\011#P\03130XXY!4\019\211\127\006\144\024#\014\243\254\255\135`\144!\127\255B\216 w\002\004\016\216 \144K\144\013c$\224(\144f\144! \000\241\005\195\127\128\000\130\027\0043\012\226*B\222\130\198\220_\136Z\144\025\000\001\004D;>00p\003\003\155\141\001\020\143@\163@\246`&\028\1484\0012\233/8\186\024\024~\001\241\251\159\000\001\196\194\204\240\018\200\224\006j\001\025\196\n\1970\195\024\145\012\251\015\1970C~\131\241\127\176A\031\024\000\002\008h\208O\022\144!\140`\205\172@\tF\168A0\195\152\144\\\0013\228\031\212\248\191@\245`\195\152\000\002\008\232\151\159o\2543\176\002U\252\007\234\252\015\212\245\023\168\230\0150<A\233\000d\0083(\158\024!\134\252\0072\254\128\228A\154\129\226\223\128\244\015\160\248\231\159\000\001\006\000\144=\1412\221\219\198j\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gb.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003fIDATx\218b<\227 \254\224]\2301\129S\143x\024xX\153\024\024\025\2543\128\192_ \230\149fd\008\248\179\155\129\225\247;\134\157\252\225\012\175\238\255g`f\128\128\255@\149_\190\255c\208V\250\194 \187\200\229\003@\000\177p$\237\021Q[\157\193m\146S\194pM\194\154\225\221mF\1762\016\224\022ed\224\250+\197\192\240\135\159A\158\155\139\129\143\233?\212\024F\006^\197\255\012\250\031\2071|\234\232f\248\018\188\142\005 \128\024\197\020\175~8}\128\135\159\227p\031\003\199\031\003\134o\246A\012K\246\001\213\190\255\207 $\203\200\016\242\127-\003\195\175\015\012\219y\147\025\030\223\005\026\196\205\200\016\230\198\192 p|%\195\143\223\199\024~852\152z~\250\012\016@L\255\191\254c05cdH\254P\198\240C\197\153\129)!\133!\254\223|\134\243\031\1271\204\156\255\147\225\231\225\173\012?\183\175f\232[\243\147a\239\147_\012\241|\235\0248\018s\024~H\1553\020\179\183\130\245\254\127\253\155\005 \000\000I\000\182\255\0014R\215\240\003\000\013\015\223\215\004\000\012O\002\000\202t\002\000\000\154\135\000\000\024\031\000\000NZ\000\000V`\000\000\222\210\000\000\204\206\000\000\186\180\000\000\213\191\000\000q\141\000@\159\254\000\234\152\254\000 -\252\000\253\000\237\248\002\136\241\134\187\197\007~v\022~6\006\022\006\230Wo\025\152>\13620\234\21730\222>\200\192 \0144\244\226}H\176\232\17100<\255\201\240_\211\145\225\255\165C\012\255\184^1\252\149\018f\248\197\240\135\225\213\247_?\001\002pD\006I\000\192\016\016\163t\250\255\007\163\177N;\019\167$\029\183\188[0.\018#(whS\011\\bu\218\180\132M>\171i\144\219\250\007\205\023@\012\166\193\183>X\132\188\254/\174\249\233\191v\231\143\255\191\127\255\254\255wB\213\255\191\171\023\255\255\251\247\239\255\191\238\129\255\255*\203C\216[6\255\255\219\156\012Vc>\251\199\127q\181O\255\205\131^\2557\t\188\242\029 \128\152\030\028\254\203p\255\008\003\131E\t#\1959\151\159\012LJn\012L\002\226\012\238'c\024d\013\152\024\152\196\129\222U\249\207 \235\197\196\160\191\214\135\129I\011\024!\n~\012\135t\1591\248t12<8\198\192\240\224\200\031F\128\000b\016S\186\245\225\245\235\215\255?O\241\250\255\211\223\251\255\179\203\127\255K9\252\255/)\253\251\191S\236\255\255\255\163]\254\255\247\149\255\031\157\003\018\003\202\025\255\255\127\011\168\230g\136\211\255\207}\166\255AzE\181.\255\000\008 \166\195-\255Y\024rb\025\2541\2162\196\251\172a0v\255\203\240\239\214o\134\127@\191\255a\253\203\240\247/+\016\1790\252`\001\138\003\195\229\223\243\223\012\246@5A\214[\025\254\t\16420\164\1671\236/\249\197\004\016@,\223\230\187\1889\239\183\247_\254$V\230\127\031_2\177\002\131\014\232\161\255?\128A\249\2293#\195+`D\253\255\254\159\241\243\231\151\012\127\2542\252\231`\248\199\008J\249\167:\254\253Wesfh(\177a\208^\235\251\019 \192\000\134\tZ\245Iy\236\225\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gd.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\132IDATx\218b\156\199\192\240@\210\220\\@\204\209\145\129S\154\143\129\129\249?\195\143\247\012p\192\202\203\192\192\196\202\192\240\227\029\003\003#T\140\029$\198\206\200\240\237\254'\134W\251\2473<?y\242\003@\000\177\17630\136|8y\146\2190\216\142\129\199T\137\225;\0033\195\207\023@M,\012\012\255\254\0025\1371\128M\248\005\021\251\015\021\227d\254\203\240\245\227Y\134{'O2\000\205`\001\008 \022\030\006\134?\151\1286L\138?\194\176\138\131\141\129\143\129\149\129M\147\001\003\176\163\137}e\248\205\016 \127\132\193\161\135\129\193\242\021\195?\128\000b\001\tJ310\028\191p\156\193\250\205S\006sY\022\134\169\026\012xA\241M\006\134\131O\2550<\018x\196\016\245\015\232J\160\139\000\002\136\005H3\252\000\017l\012\012\143X\0311<\190\205\200\176\230\n\003C\153)\003C\169\"T\231\031 \006Z9\2351\003C\245\t\008\251?'P;\023\003\195_\1364#@\000\129]\244\025\200c\005\250\2415\144\214\005\154\255\152\147\129\161\243:\016\223``x7\021h\007P\021O<P!\007\016\2433 B\029\232\147?@\243\128\238`\004\008 &\016\159\011H\254\006*\222\248\154\129A\022\028U\016[AVq\001\013e\005\241\127#\137\1950\019\024\129\240\127\128\000ba\130\026\196\240\141\129!\030\232T\134/\012`\2476Y\000\189\161\012d\199A\012\252\011\2128\229!\003C\2541\168\1398!\134\177\001\217\204@&@\0001\129\204`\1319\021h\152\163*\208\248X\006\134Z \013\146\004c6\008\157\007\012\179\255\209\012\012\222j@\181\191 \152\021\226\"F\128\000\002\187\232)\208\159\012z\012\012\247M\024\024\228XPc\232?\148fD\018\219d\196\192\240\001\168^\024h\2083\160\001\018@1\128\000b\001\250\132E\253\019P\192\138\129AP\133\129\001\024\190\012o\142\000\005\129\001\251\251'0l\013\129N\007z\249\029P\140\021(\246\023(&\164\207\192\160$\201\192\240\226,\003\195\169W\192\200\002:\n \128X~\000\245\001\245\254;t\153\129\153\231\031\208\149\172\012\140\239_3\252\007\186\128\017\020\181\194O\129\142\226d`|\251\026\028\022\255\129.d\252\244\156\129\225\225\007\134\255\031\174B\\\248\145\129\225'@\128\001\000\214\227\163d`\024\023\013\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ge.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\214\216\212OX2\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\221IDATx\218\132RMO\019Q\020=\247\189W\134\2330\224\140\1731U\195BS@\130\137\138.P\019\131\027\023\174ta\130+?\016\227\194\2483\252\023l\248\001&\234\142\189.\168\018\163\136\006\026\019j\186\144~\2082C;\157y\207\247\166\133\021\1377wq\238}\231\228\221/*\149J\158\2319\142\195\024\195\145U\219x\187b\192\189\005\156\027;JK)\131 h4\026\194\182m\206\249\144\246\234.,\011\133<\136\224I\020\139\134\232;\200f\161\020\2546\208jG\133|\135s-\017\250\137\136\162\2372\173\174\"\235\224\193}\140\186h\237a}\221\200&/\225\132\141\131\014>\188G\179\022\205\221\160\011\231uZPj\241\2173jj\134yc\024\182\016E\168\213\176\146\0229\127\023\133\0288\195\245k\178\188\147L\020IJ\205\023\244\2297w\178\186/\230\230X\172\168\180i\216\027eT*\006\172\253BbzV\156\227\228i|\222\"\t\nB\250\t\232\1503\000O\157p\188) I\189\007\236\153\"\001\150\n2\255\147\245\007\157\164\028A\203\239\152;bF9bk\025\139\147\180\200m\188~d\192\155e\\\1532\163\215\237\017\201\253\003\022%\212\222\023\1849I\190O\150Ek_Y\222g\023'\012;\239\014~\1855\131\185\171\006\236\252\145\155[4?K\221.\234\245\195\021o\252\192\210S<y\134J\213\132ao\144\239\131\221:\030/\226\229s|\252\212O\155\189)m\227\227j\225\133<U@\206\215\183\0009tx\023\195&\028u\229\226+\245\237\187\154\158\214\\#\011\195P\008\209\201d\196\210C}.,\012\016\002\173\238@\214\138\209l\026\249\157\217\228\246\2298\142{\237\142\150\252\019`\000\252\011\172\141i|\024)\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gf.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gg.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\214\216\212OX2\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\164IDATx\218T\146?o\212@\016\197\127\179\187\142\241\249\194\201\137\160\139D\133\128/\128@Q\148\014\161\212 \165\163\160\2243@\205\023\160\162L\001\162\140\168@A\148\148\135\160\137\004\029\002\001U.\\8\235\252w\153u.\1900\178V\158\241{;o\230Y\198\227q\150ei\154\026c\232\227\227O>\191F\011W\182\217\186\142,\202m\219\206f\179\201d\226\146$\177\214\174t\177\164]\026\178}\149\001L3\006\131\158V\150\229|>W\138\211DD4\215sI\251\254\139\226\019\025\252N\185\177\209\151{\152\147.\234\186\246\222/u\142\0159y\129\226\191F\220\185\217+l\154\230\020\239\228\249;;\136\141U\1427\185\151\002b\199\155\247\220\250A\013o?\144lP\213^'X\021\148\165O^\200\023\024A\004v\136}\136\180\004\180v\221\129ux\005\243\208\202_\166\217\163\249F\005\127\130\200\014c\149)\129\025\148W]\158B\210]yAI\248U\140\013\252\134\176 '\015\158\154\139Ck\197:\236\020Sx\226\021\014\0148\217\231\026\236m\177\179K]\1823\225\030m\137i\188L\255:\158\220\151\1815\137c\137\"c\157\177\221V\030G\028\239\007y\155\183y\246(\232it!\181T\149\020\005GG\231,\134\222\031|t\150F\139\162\252\007\012\190\249\179\208\021/\202v\020\198\2119\162\017u\171\239\250\169\135\005Z\158\231\2069\245^O\253]\022\214\233\249\178\187\243\174cz\172\173NMS{\171\170R\202?\001\006\000\255\015\172|\198-\185\216\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gh.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\213IDATx\218b<\195\192\240@\208\220\\\128\199\209\145\129\137\143\143\129\225\255\127\006\162\000##\195\191O\159\024\190\236\223\207\240\254\228\201\015\000\001\196\194\193\192 \194|\242$7\171\157\029\003\155\146\018\003#33Q\230\252\255\251\151\225\215\217\179\012@\189\012@3X\000\002\136\133\145\129\225\015\0163\252>r\132\129\153\141\141\129\129\149\1498\023\253\254\013\214\003\210\011\244\195?\128\000\002\025\004\230\2529~\156\225\199\211\167 \179\193|\188\174\001\017\127\2540\252y\244\008\172\246\031P\023@\000\1770^g``\226e``f\001\026\200\244\136\129\137\137\145(\007\253\251\247\159\129\025h\194\255?@\206[\006F\128\000b\002\134\025\003(X@>\002\249\140\141\237?\003;\251\127\006\014\142\255\012w?00\132\229\1780x\198\1770\156\188\203\192\192\206\001\145\003\169\129\133\0024H\025\001\002\136\241\230M\134\015\002\002\012\252\236\236\008\tF\184\163\024\129\026\217\193\244\207\159?`\158\002G,0\172A\193\004\020g`x\245\138\225\007@\000\177\128411A0\200\016\016\006\177\193z\024\2553\220\218\251\011\172\145\133\t\026\152\140 oA\172\001\025\006R\0112\003 \128\024\025\2301|`\224a\224\007\197!\0030\156\024\152\161\026@\000\228]`\248\177\003\197>\127\004\0050$d\193\150\252\133\242A\014}\207\240\019 \128X\192\154\217\161\134\1280\019\020C\163\231\023\208\128_\012P\195ar\255\144,\131\234\005\008 \022\160\004\011\216\134\127P\140\018\199\216R4\146Z\152\235\152\025\152\000\002\136\005\232\1807`!& \151\017H2\194\210\024\220N\236\236\255@\008\243\222'\134\159\000\001\006\000\136v\130\139\153\189\005\019\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gi.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\023IDATx\218b<s\230\204\003AAA\001\030\030\030\006&&&\006R\192\191\127\255\024\190|\249\194\240\254\253\251\015\000\001\168\026\131\020\000`\016\134U\170\"\236\186\255\255s\142\225\188z-I\170\017\177I.3\131\187CD\006\252\206E?\128\198\177W\0212\019\237\162\027\250\005\016\011P\227\031\144\230\223\191\127\131\005\1936\001\241\195\165+\024\152E$\025\190];\199\000r'\179\166\001\003\227\171g\0122\161\193\012l\156\028`u = \189@C\255\001\004\016\200 0\231\207\159?\012?~\252\000+\000\241\143\245t2\136\176s0p\003\189\204\242\225=\195'\1973\012o\238\\c\240\013\015a\248\007U\007\210\003R\011\244\"\011@\000\129\013\002\133\013\20050\246\135\183\031\025\190\221\191\207\240\018\168\024d7\200\179\223\239\220a\248\006\164\159\2378\206\160\228e\013\014\031\144\030\144\023AJ\000\002\008l\016H\000\020F \026d\144\136\148\024\003#P\001+\212 \006\168a?\129X\216H\031\028\150 \131\254\254\253\0117\008 \128\152\144]\004\011\240\231'\0313(\001e9\129\152\011\136y\161le ~\177\228\028\003+P\013\178\197@\252\031 \128\224^\131\025\006\194\146fr\012\"s70p1~`\248(\248\139\129I\238\t\003\247-5\134?_y\024\254\217\02600\129\130\001\020\163@\023\129\244\129\204\000\008 \150\127jj\224X\250\015\197 \192\015\"D\196\024\024\222\253c\224J\007\202\170\001\147@)\208\147|@\241w\175\025\254\128\002\026\170\030\164\247/\208k\000\001\196\1305\161\129\1367\175 \156\005@\236\014\210\249\025h\008\238\196\t\016@,@SY`\154\161\166\195]\006\006.@\204\134i\017\012C#\130\t \128X\128Q\250\006\200\248\007\140!f&p\026f`d\130\152\005N\226\140\247\128\017\243\015\202\006\138\00353B\189\244\255\0154&\223\002)\128\000\003\000\218\134\16725\230\2270\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gl.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002PIDATx\218b<s\230\204\003AAA\001\030\030\030\006&&&\006R\192\191\127\255\024\190|\249\194\240\254\253\251\015\000\001\196\194\193\193!\194\204\204\204\205\202\202\202\192\198\198\198\192\200\200\008V\244\031\170\152\017\135!\255\255\255g\248\245\235\023\003P/\003\208\012\022\128\000b\001j\252\003\210\252\251\247o\176 \200\128wKv2\252|}\015\172\129]T\149A(\198\005\171\129 = \189@C\255\001\004\016\200 0\231\207\159?\012_\127\252`\184ji\011\212\244\159\129\133A\005\172\248\015\195\\\134\187\189L\012\186'\01430!\185\006,\007\212\003\210\011\244\"\011@\0001\129\024\160\176\001\185\230\182q>\195\143\251\183\025~\223\023d\248~\2555\144\253\154\225\207}\001\134\159\247o\001\229r\192\234`jA\250@44\\\025\001\002\136\133\001d\016H\002\024F?\158\172\003\138\t0\252cx\129\018J\140\012\252\012?\031\175g`\225\152\199\192\004t\013\200E\160\128\254\251\247/\195?\016\031\168\008 \128XNh\1840p3\252d\224bx\207`\253\245#\003\007\2126\140\240\000\226\147\236\220@Z\008h0'\195_\160v\016\254\005\020\127\207\240\247?@\000\177\1763H\002\013\001\217\250\154\129\241\201'\006\022%\017\172\201\224\239\131w\012\204\192\016\227`P\000j\007\134)8\252\024\192\225\198\0064\018 \128\152X\128\194\172@\204\005TpM\221\131\129\017\026\014\200\024$vC\217\003\232\014E\160&F\160z\144\230\255@\252\015\200\254\007\140\152\127\140\000\001\196\196\012t,\200&f\160\147\2552<d\184\192l\206\240\229\252]\1604\003\024\1279\127\159\225\028\163\021\195\015\134{@#$\160)\011\228\166\127@\252\023\170\247\015\003@\000\177\000\029\008\196 s\129\1823\1681|cx\195p\218H\031\200\022\006+\255\011\22833\200\000\249\006\2240\129\024\240\007H\130\240\127\176u@>\019@\000\177\252d\248\247\230#\195\255\127@\1912\255\007{Y\002\024\212\210\255\129\154\024A\218\152\024\020\129\241\002\n\253\255@68\0011\194\147\0198\156\2541|b\248\243\019 \192\0002\136\200\149\197+Y\143\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\232IDATx\218b\156\193\192\240@\222\220\\@\204\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\25410\252\001iz{\228\008\0033\027\027\003#++NC\144\013\251\255\2517X\015\216L\006\134\127\000\001\196xP\144\233\131$\203?\254\255\140L\012l\210r\012L,,D\185\232\223\159?\012\191\158>b\248\007T\248\254?\195w\128\000b\153\226\177\139\129\151[\152\129\t\168\130\153\t\132\025!\1980\2260\233?\196\184\191@\019\254\002\189\243\247\255_\134o\223>0\002\004\016#\003c\255\007\134\255B\252H\142f \014\192\212\002Mc\248\244\019 \128X\128\209\132$\193\132\205zlA\013\243 L\252?@\000\177\196\228\2332\008\011\1382\176\000\195\134\153\025\132\153\128\222\004:\020\135\203\254\003e\254\001-\255\011\244\215\223\191\127\024~\255\254\197\240\241\211[\006\128\000b9\205\146\192\192\0066\004\168\004\024\206\140\1600bD\132\197\127\020\183\252\135\203\253g\132\164\183\191@\226\023\243?F\128\000by\255\241?\003\235\191?\192P\006jb\002\025\196\1320\000\139\207`\006\254\255\247\143\129\017\232\179\255\192\196\243\251\235_\006\128\000baefd\001y\137\129\tl\n4\156\152\129A\199\008\198\136p\249\0156\158\145\241?$\229\128La\002b\230\127 \1590\001\004\016\203\191\031\255\222\000\003\237\223\191\255\140@\20710A\028\015\140\219\255L0g\253\135\155\198\008d3\254c\132:\238?\152\011\140\254\127?\254\254\004\0080\000\"B\174\026l|m\163\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gn.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\140IDATx\218b\156\199\166\248@\194\204P@\220\222\154\129\149\143\135\225\223?F0\150\137\249\194\192\248\235?\003\003\144\013\006\140@6\235?\134y\231d\025\216\152\255101\253g\248\250\2273\195\177\235\167\025\206\223\190\248\001 \128X\216\025\024E~\156\190\204\205fk\193 \160(\195\192\192\196\194\240\015\168\135\139\247\007\003\227\031\160\001\255\024\160\006\0011\203\127\006U\025!\006\022& \251\255\031\134K\015?2\\||\157\129\145\153\153\005 \128\128R\204 \229\012\239\142\158a`fc\005\n\1780\252\005\186B\192\230\011\003\003\186\139\216\2543\\{*\197\192\206\002\020\254\251\155\225\244\157\139\012\255\025\025\025\254\255g\254\007\016@,\255\024\152\129\15022\188;y\137\225\231\179\215\012\140\140@\131\25420\136F\002\217_\128\154\255@\013b\0029\243\031\195\138c\186\012\\l@\238\191?\012O\222\189\006J\176\003-\254\203\002\016@,\127\025\216\192^a\002\170\255\246\248\013\003#\208\005\127\255\252\007*|\006\244\218?T\131\254\253c\184\255F\150\129\135\157\145\129\245\255?\160K\184\024\254\131\194\244\239oF\128\000\002\186\008\024&@W!\002\002\228\255\255\012\028\172\204\012\140\172 !&\168A@C\217@R|\224\200\248\203\0082\136\001l\248\255\127L\140\000\001\196\194\008\212\012R\202\004\164\153\161l\144\024+\027\144d\005\026\204\008s\017\144\006\241\153\152@\138\193j\254\131\020\131\194\144\137\241?@\000\17703\252f`\005\202\128\212\128\028\192\012\141(\022\160\167\025\129\024\232\006\132\139\128\238gd\253\194\192\204\n\178\020\232\253\191\016\217\127\140\191\024\000\002\136\133\133\225\023\003\011\208\249\172 W@]\0062\136\t\152V\024A\225\194\244\031\017F\204\255\129\177\250\011(\0074\004\168\234?\212\026&\230?\140\000\001\196\194\004\014\161\255`\003`\030\251\015\014+d\140\008\191\255\255\025\161\218\129\2141\254\003\211LL\191\025\000\002\008h\208_`\170\000F9X!\019\216s\127A\248\015\019$A\254\129\0056\136\0134\224/;\195\127`\250\248\015M\148\140`\157\255\152\000\002\136\229\007\195\2557\255\255\131\226\129\137\025\234\001\198\223@%/_\002\131\249\019\144\003\212\243\255?\196\177\140?\024\255\255\003\230\156\223\191\193\006\255\007\242\128\142\250\195\240\239\231\175\159\000\001\006\000`\134\226\134kI\178\135\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gp.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gq.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002tIDATx\218bd\182\011z`2\229\169\128\2277G\006>V>\134\255\255\2553\128\001\148\194\000\140P\138\145\145\225\211\175O\012\251\159\238g8\249\228\228\007\128\000ba>T$r&o:\183\221\138\191\012J\223\149\024\152\129\016\167!H\134\253\253\255\151\225\236\219\179\012'?\159d``c`\001\008 \022\006\134\155\127X\014T0\028k^\199\192V\127\153\129\2459+\003\195?\006\130\224\247\191\223\012G^\029\129\184\240\031\195?\128\000bdcX\252\129\129\129\157\159\145A\151A2|\014\003w\247z\134\239g\129\146?\017\222\0009\018\140\153\128\248/\200\020\006\134?\255\2540<\250\252\008\194\255\194\240\029 \128\128\006\173\006\026\196\201\255\031\168\235\015\003/CC\166\002Cv3\023D\0013\212 \016\251\241#\134/\223\2231\240(\02400p\000\029\241\031\232\140\127\255\024\254\252\249\195\240\246\237\219\031\000\001\196\244\159\129\011\024$<@c\248\025X\025X\024\234\167?b\008\241{\205\192\193\205\206\192\198\012\244<\019\027\003\007'\007C\239\245G\012i\135\234\024\216\005\216\025XYX\025\024\255\001C\229/3\195\255?@\007\252\252\199\008\016@,\016\2473\130\221\253\031h\016\200\195\191y\128\138YY\025~1\255\007:\138\145\225\253\207\191\012N\178\026\012V\204=\012\175\128j\132\216\129:\152\2550\252\007z\241\031\019\019\195?6\166\255\000\001\196\194\200\240\029\234\135\191@\175\0112\020\180+2\244\150\2412\252\130\006\t0\232\025X\216X\025\184\228x\025X\196X\025~331p\17621\252ab\004[\253\239\223_\006f\022f\006\128\000\002\134\209\178\015\255\025\184\249\1273\1520\1321\2123,\231\152\195p\234\007\003\216x&h\016\177CiPd\130\220\252\029\018\222\1920\133\196\201\027 \005\016@,\255\129B\191\025\180\025\130\129\134,f\152\195p\236\007$\025\177 \165\201_\012\136\000\128E&\011\003\"\221\130\\\013\016@,\191\0254X\002\024\154\025\2301,d8\198\128HB\255\209hF4\250?\146Z\160\161L\000\001\196\226\195\208\254\166\139a\195\191\221\192\128\250\011\241\013#P\017(\1630\"e\022F\168!\255\025A\185\003*\254\015\1542>\001\029\n\016`\000a\147\190\179\243\144\\L\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002zIDATx\218b45=\243@[[P@C\147\135!9\137\137\225\238\003\006\134cG\025\024x\249\024\024~\254``\248\245\147\129\129\129\145\001\0050B\241\151/\255\024\142\028\249\194p\238\220\251\015\000\001\196\242\228\t\135\200\253\251\204\220\162\162\172\012\156\156l\012\002|\140\012\178\210\016\013jf\012\012*\138\012\012\127\2540`\128\255@\248\227\251/\134\192@f\134\175_9X\000\002\1761\231F\000\130P\000\005\223?\002\199\156\246\028\155w\200DG\"\144\195\002\220\002\214\183]^7!\132Jk\134;,+\168~A\129#\130\233O\212\225L\149\251\018\158<\250\020@\140\215\174]\251\192\195\195\195\207\204\0122\132\005\226tFF\134\255\255\025\024v\236b`\152<\t\196\007;\001\197= W>}\250\007\200\250\011T\251\254;@\0001\202*^\255\240\231\023/\255\231\207,\012\247\23801\172\\\203\196\144\151\005Q\190~\019\003\131\133)\022\215\252\007\225\127\012\255\254\253c\248\0134\241\237\219\183?\000\002\136\229\227{F\134_\191\152\025~|ce`ccfx\255\157\t\168\136\145\129\147\139\145\161\180\130\129AJ\014\024\232\223\145\012\000;\237?\216o\255\254\131\\\243\031\168\159\129\017 \128X2\139\024\025\152Y\153\024~\253ff`eee\008\245ffx\253\142\145AY\158\129\225\213\027`8|D\132\209\255\255\008'\253\005\026\002t\0160\\\153\024\190}f\250\015\016@\140\183n\221\250 ((\200\207\206\206\206\240\247\031\027\003\015730\160\177\132.\018\000y\233\239\223\191@\151\252b\248\249\243'\195\203\151/\127\000\004\016Kb\0260\150X\129\182\17802\128!#\019\220\160\255\012\152\233\007%\140\128A\240\023\024\232\223~\254g\004\008 \150\249\179\024\024\004\005\129\134q0\000\195\136\001\028\253\004\028\004\246\018(\214\128\014b\248\001L\180/^00\000\004\016\203\250\245\255Y\184\184\129\154\153\255\001\013\000\170`\002\006 \227\127\160m\176\192EJ\205@\130\t\136\025A\137\232\031$\214\254\253e`\248\252\137\145\t \128\024\197\197\207?`d\226\022\250\255\159\149\025\228\150\255`\165L\160\200\128\250\132\017d\028\156\205\200\248\143\017d<#\208\170\255\255\255\000\013\255\t4\236\245O\128\000\003\000\248\201\244\181\183X\199\170\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gs.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002{IDATx\218\0007\000\200\255\001\155\\i >?\228\006\026\235\238\000-\016\251#\004\244\179\239\027\006\254\248(\021\006\030\021\t\196\228\252\233\234\240\000\000\001\001\000\253\004\004\254\246\246\246\186\187\209\221\220\223\002\0007\000\200\255\004\175\228\014H\193\207Vf\027\248;\"\255\237\239\008\243\004H'\017\022\007\000\253\012\n\221\236\252\019\247\242\011\011\016\000\000\255\000\000\253\n\008\254\237\237\238\200\199\219\006\006\254\002\0007\000\200\255\001\19088\253\243\246\015-+\02485\253\249\250\249\245\246\011\017\017\252\003\007\251\253\255\008\001\253\191\243\018\215\245\012\000\000\252\012\013\007\n\011\002\232\225\193\189\199\245\232\233\003\002\0007\000\200\255\004\161\016K:?\023E\026\251\226\227\239\251\240\239\008\228\217\233Wf\030\244\232\230\230\239\192\231\005\191\216\220\221\232\245\000\000\255\011\012\0052A\020\231\229\236\008\021\011\255\230\254\002\0007\000\200\255\003?Ab(\252\251\166\189\229\133\191\001\012\255\250%\000\241[\184\013\210\243\008\"\025\014\005\236\237\183\203\233\225\234\000\242\242\254\001\008\252\011\017\255\000\006\248\253\252\t\254\001\246\002\0007\000\200\255\0013!\134\227\233\251\234\246\007\000\000\255\027\014\255\013\001\247\218\244\012\254\253\245\n\018\029*\031\013\226\217\220\234\246\002\001\001\001\026-\237\019\028\251 \"\253\232\224&\224\221\194\002\136\249\227\031\215\015_\025\025\024\152\128\193\245\249'\211\155\159\028\255\255\255e``\255\253\253\203\179\023o\191\254f\005J12\254\023W\248,(\252\239;\139\0267\135\194\223/\191\001\002\136\133\145\225\011\003\195o\160\030\006\016\248\207\128\021\252g\230\252\244EU\232\223\195\159o$\197\254\253~\246\021 \128X\024\024>\001\003\023\172\129\t\172\153\t\172\144\017\201\160\255\255\025\024_\191fa\248\248\241\244\214/?4o\252\254\199\n\016@\140\204\204\241\127\255230\000\017\011\0121\1315C\244\255\003#\160\185\127\153\024~\253\0031\25403\255\003\008\192\241\024\156\000\016\002Al\162>\196\014\174\015\251/K\246\161\206-B\2007\164\205\249Q\006t3\164t\1905+\169/z\208\134\141C\n\188\236\240]\191\000\002\186\196\155\129\129\147\129\001\168\007\024\152\028\012\012\1720\219\224\142\132\216\006\244?P\231O\006\134o\012\012\223\001\002\012\000qI\006^\154\005\253\245\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gt.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\209IDATx\218b\020\153\176\255\129\177\140\168\128\1814\031\003/\027\011\195\223\127\140\012?\25520\164)330002\160\130\255\012\179\239\253e`eb``a\250\207\240\249\215\031\134\163O?1\156}\242\250\003@\000\1770\178q\136\156\255\252\143\219\146\133\149AA\144\019\168\149\145\225\247?\006\006..\236\006\169\137\252e`a\004\177\2543\\|\251\157\001\168\151\001h\006\011@\000\177\252g`\250\195\200\196\196p\234\245w\0066f&\006&F&\134\031\127\024\024\220D\217\024\176\129+\031~1\176\003]\244\255\255?\176\030\006\160\222\255\255\025\254\001\004\016\200 \134\127\255\152\024N\191\249\197\240\252\251\127\160#\024\025>\254cf\200\146\007\202\254\253\193p\245\2257\134{\207\2393\248[\027\131\013Z\254\232\007\003\231\255?\012\140@\221O\190\254f\248\015\212\251\255\239\127\022\128\000b\249\247\031\232\n\006\022\160C\153\025\030}cd\248\007t\017\031/7\195\164\173M\012\015\190>ah\176\011b\152\178w\026\195\194\147\140\0121F\142\012\2559\011\024\238\127\248\002\212\001\244?\003+\016\255e\248\247\159\145\017 \128\152@\006\252cde\248\207\200\206\240\159\137\131\225?3\023\195\167?\236@\191\031g\152\030=\145A\\\234=\195\226\014}\006\007\181\028\134\227\175\1742|\253\007T\199\204\tQ\011\212\003\210\011t\012#@\000\177\128\188\194\000t\005\003\0190pY\128\\&\022\006f\0226\134\247l\207\024\030\188\251\203 \247\219\130\225\253/u\134\163\215\1823\136\200\191\005\170cc`b\005\006\226? \254\003\162\255\002\2450\253\007\008 \022FF`(\001\221\197\200\002t%\016\255\003\178\127q\1780\028N\188\201`\239/\205PZ\188\140a\203\249w\012\251{\250\025\254\002\195Lr?3\195\255\223 =\208x\252\007\012K\160\025\000\001\196\196\196\004\140> fb\006z\018\136\025\129\014\251\244\238\011\208Vn\134\137\147w1\028y\183\155\129_\234\028\195\213\199\151\129\154\217\025^}\248\nv<H-H\015H/#\227?F\128\000\130\184\008$\000\164\225\000l\219?\006#\02130F$#\132K@\000\166\247?\144\006\008 \022\198\255\255\128\017\000\228\252\005\198\002P\000\228T\134?\255\129)\252\0318\001\162'H\144\028\200@\144f\006\144\158\127\160\004\244\159\t \000\137d\128\0020\008\195\192\214u\255\127\167\176\193\132\"\171\204f\017?pI\184\024\198{\193\027\183\157G\170\149I\003\018\134Z}Y`*\031\003\232n@\210\2215m\202W(=\007\193!\226O\252\002\012\000\209\031\024x\154\195\130\149\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gu.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\197IDATx\218b\236\2131|\240[\221Z@\199B\159\129\141\135\151\225\223\127&\134\255\255\025\025\2543\000i\006\016`d\248\007$\217\025~Cy\255\193\"L\140\255\025\254|\249\204p\246\228\021\006\230\027\199?\000\004\016\203\190\175R\"[\247Hq\151\234\2021\024\171\2000031\003\1493\129\181 0\003\195\015\168\177\012`c\2551\252\253\247\151\225\236\197'\012\221{^3\216\n\200\177\000\004\016\1390#\195\031\006\214O\012'O\221`\224b\251\203\192\194\202\0027\008\228:\214\223\255\192F\253be\002\186\002d\200\127\176A\127~\255\001\234\185\205\192\192\250\153A\148\137\225\031@\000\177\252\250\207\001\148\227a8y\230\005\195\179\231\223\025XX\024\193\006\129\188\247\251\221\031\134\208pN\006fv\006\134\021s\1911\176\008\179B=\0124\232\207\127\134\199O?\002\245r3\252\252\199\206\002\016@,?\025\184\128\018\252@\141l\012\143\158\000\253\015\182\245/\195\239\031\255\024\156\2299\024v\008\223b\248\251\253\027\131\174\128.\195\230k_\025X\185\153!!\245\031\228jAp\232\253\250\207\201\008\016@,\191\255s\002M\021\006\n\252\134*\248\015\t\232\207\031\024D\221\213\025>0\1552p\001\213\243\007\252a\248Ww\141\225\031'\031\2082\006h\216\001]\247\159\133\225\207\127.F\128\000b\130\0082A1\2006`\0241\17800\179\1783|\186\251\157A\130I\129\129y\223o\006\206k\031\024\024\216\184\193r`5\012H\145\194\200\248\031 \128XX\025\127\000\025\239\129\236\159P\193\255\144\192\229ca\248v|+\131\208\151J\006s\245\187\012\143O\18600py101}\130D\222\127\168\139\024Y\025X\025\1911\000\004\016\011\007\1957\160\192'\160A \003a\209\013\140-\022&\134}ou\025\246\026\028ep2ab`\156\018\192\192\"\254\006\026\134\255\192\022\002\195\001\200fe`c\252\206\008\016@,\236 \1510~\133\134\017\011X\002d\016\019\200\233\130\127\025\252f'1|\157\008\012G\209\175\012,\140\204\208\180\244\023\170\254\015P\239/\006v\198\239\012\000\001\196\242\242?\208\211\127\248\128\t\014$\193\005\142\005\008f\005\027\252\149\025h8/\200\023\127\024~\252\249\0035\224'\020\003}\243\135\137\22590\161\003\004\016\139\019\215\1797\146L{\255\241222\255\254\207\206\244\151\145\025\232x\214\255\255\024@400\2553\253\007\251\023\204\003%\209\191\140L@\195\152\255\255\253\207\002\012\142\207\255\2541\200\179\190\250\t\016`\000\218\220\228\221\255\242\195\008\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gw.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\191IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\223\255\255\012\255\024\024\024d\210\024\024\024\025\240\001F\134\127\255>1|\249\178\159\225\253\251\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\131\184\184\240\027\244\255\255_\134_\191\206\002\149\159d\224\224``\001\008 \150\255\012\012\127@\018\239\143\028a`fcc`dee\248\011\228\011\1841\016\000\191\025~\255>\194\192\200\0082\148\225\031@\000\177\252\131\n\127>~\156\225\239\211\167\012\127YX\192&\139f\225v\017P#\003\200\254?\127\030\129\013\250\247\143\129\005 \128X@\154\148\129x\001\016\179<z\196\144\000\148\185\012d33\225w\207\191\127\255A\161\0005\148\129\017 \128Xx\128d\t\016\239\134*\184\008\148\169\005\210@\127\227t\013\008\003]\193\240\247/\194 \128\000b\\\193\192\240A\130\129\129\223\001\170\240&(\160\129X6\015H\252\002\226\031\012\152~\252\015\197\160p\001\005\232w\134\031\000\001\004\014\163\179@<\013\170\254\004\016{\131\020\011@\013\250\139\195\144\255\012\144h\002\201\17920\000\004\016(\214\0244@\129\011\2253\252\004\226\175 \013\028P\027\177\133\248\127$9\016fa`\004\008 \022&(\251\019\152\0151\140\017\221fD\026D\2080\204\004\193\000\001\0042\008\164\031\238\003Fp\n\129:\251\015\154\215\024\145\012C\182\128\137\129\t \128X\128a\249\006\020\t@yf\144\016\208`FV\144\178\015@-\223\193^\248\015\215\206\008e3\"\025\245\015\028\216?\001\002\012\000\008e\133\018k \209\243\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_gy.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\193IDATx\218bt3P}\160\178*R@\158U\140\225\239\219O\012\255\127\255g``f```d\192\014\160\226\140\140\140\012\159~}b\216\255t?\195\201''?\000\004\016\227\021\006\158/\251\024\184\184\237/\1813(+i3<\248\201\206p\251\2117\134?\191\159\003U\003\013e\194b(\144\255\247\255_\134\179o\2072t_\233f`\248\206\240\021 \128X^\136q\253\241\252\198\192p3}\001\195\219\004;\006\253\008v\006Y!5\006\134\127\\\012G?13\\\252\248\145\225\231\247;@\003\255!\\\n\196\191\255\253f8\242\250\008\196\162\255\012\255\000\002\136q\151\168\196\007\030FF~A \255\015\135$\195I\150_\012_\219\1911D8\130\212s\002E\157\025\2541\2400,~\194\196\176\236\233+\134\143\031\247\002\013\252\207\240\135\249\015\195\163\239\143\128\022\002\149|f\248\014\016@@\131d\192\006\177\000\249,@\163\165\12711l\255\248\135\225\140\241;\134\228\029?\025d\225\254\001\025\026\195\240\231\159\000C\203=F\134\185\247n2|\127\187\001\226\194\223\012?\000\002\136q\167\136\220\007^F&~V`\224\129\\\206\0124L\248?\208\189\175\2551Lf\248\198\240\165\233-Cg\209_\184q\255\255\1310\011\195\191\127>\012\127\255\2502\172z*\203\208r\170\237'@\000\1770\002\141db\128x\159\005\200\006\185\140\029h\232\127\1768\016\003%XYQ\195\250?\208\180\191\127A:8\024\216\024\153\024\152\128\202\001\002\136\133\137\241/\0033P#\200E\028@\237\178?\153\0246}\248\201p\202\250\029C\230\161\031\012\np\237\252@\156\200\240\249\015;C\211]V\134Y\183o3|y\021\013\t\163\159\012\012\000\001\004t\209\031\160k\152\024\132\128\182\255y\249\143a!\195\023\134/\027>3t\251\1314s\001q\024\016\0113t\220\229fh\191}\129\225\211\219M@'\130\157\207\192\000\138\161_\160Xb`\004\008 \022\022\198\127\012\226\223\2551\028\251\252\129\225\145\253/\134\212}l\012\188LQ\192\000\020ch\188\207\1930\241\254\003\134\247o&\0015\254\134\1327?\212\129\176`\131&\t\128\000b\188\201\192\251\229 0AJ\239\176`p\178\023g\152\254B\152\161\249\202C\134\247oW\0015\255\001\005\003$\1730!\007\018\020\255\129\226\247\012\191\001\002\136\209\205D\245\193\159\133\150B\143\190\221f\190s\2258\0190\149\130\146\015(\172\025\161\137\239?\152\199\000e\195Hp2\132\026\244\137\225'@\128\001\000t\213\236>\146\220\158\\\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_hk.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\014IDATx\218b<\195\192\240@\208\220\\\128\199\209\145\129\137\143\143\129\225\255\127\006\162\000##\195\191O\159\024\190\236\223\207\240\254\228\201\015\000\001\196\194\193\192 \194|\242$7\171\157\029\003\155\146\018\003#33Q\230\252\255\251\151\225\215\217\179\012@\189\012@3X\000\002\136\133\145\129\225\015\0163\252>r\132\129\153\141\141\129\129\149\021U\007'7\003\131\140\002\003\195\237\171\168\226\191\127\131\245\128\244\002\253\240\015 \128\024\17510|\224a`\224\007\185\131EN\014d6X\018\014N\156``\184~\151\129!1\026\225\026\016\241\231\015\195\159G\143\024\254\002\153\239\025\024\190\003\004\016\200E\012L@\0122\136\017(\193\004\244;\131\170\014\003\131k\008\003\195\225m@\013@\165O\22200L\152\205\192\240\235\015\003C\168\007\216\176\127\192\176d\134\025\n\212\n\016@\0127\128.z\014\228\191\005\226\015@\252\t\136?\179\176\253\255\242\229\203\255/W\030\252\255\162\235\244\255\139w\206\255/\023\238\129\197>\027\251\128\213|\128\234\001\233\189\200\192\240\003 \128\152\144]\004\n\0296\016\254\243\139\129\213&\136\129\245\023PLH\146\129U\\\153\129\245\243o\006V\030\030\006\182\179[\192jX\161z\152 \248?@\0001\220\002\186\2325\212%?\128\2487(B`\248\209\243\255\127\255\252\249\255w\239)`$\253\253\255\215#\028,\254\027\170\022\164\007\164\247\n0\140\000\002\136\t\158,\160\152\t\134\157<\025\152d%\024\152\242k\024\152\156\205\024\152\152\152\024\152\238]\134\203\195\212C\003\159\017 \128Xp&\148}\219\193\137\0149\001\226\003\000\001\196\0024\013l\216?(\254\139\136\t\156\224\031\018\134\250\134\t \128X\19010\188\0012\254\001\003\143\025\232d\160\007\024\024\153 f1B\021\1292\013\156\013\212\204\248\031b\200\127`b`\248\t\196\192\216\251\t\016`\000\139\214\190Q\253\022&\218\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_hm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\167IDATx\218b\236\245Iz\160\227\234)p\248\135\016\003\215_\014\134T\169\251\012\187\255(0\220\127\249\151AQ\132\133\193UG\128a\221\205\191\012o\158\191d```\006\226\127@\252\135\129\145\241/\195\167O\223\024\246\239\191\204p\242\228\213\015\000\001\196\178\226\185\136H\213\165c\220E\2411\012\2234T\024\254\159z\197`%,\202\224m\198\202\192\"\"\200p\249\2497\0061\193\015\012B\188b\012\016\240\135ARZ\128AR\130\157a\198\244=@Cn\129,`\001\008 \150\254\215\243\254\188_\206\196\240\232\207[\006\t\013Y\134\015\1279\0258\152/2|\227\230e\248\248\135\131A\24373\195k\006\001\134\139\223\249\128\026~\0021#\195\205\155/\024\254\255\255\203p\252\248\019 \159\013\136\127\253\003\008\000I\000\182\255\001\"K\158\240\191KC\015\004\013\198\000\150\224\027\000n\208v\000\1951o\000\0185C\000,\229\203\000\153\217\242\000\159\186\224\000\000\241\232\000TW8\000\207\204\232\000\221\221\229\000\252\252\249\000\016\016\021\000or0\000c`\163\247\002\136\165F\147\133a\198\226\137\012\237\199\223\002MVa\0081\151f\152r\252(\195\193\231;\024\172}]\024\150x\252d\216\250\224\t\195\201\015?\024\132Ex\024\254\179p1\220\191\255\141\129\131\147\151\225\239\127V\160!\135\128\250$\024\001\002\136\145\129!\251\003\003\1318?\200\201\012\012?\128\228w\134\255\012\127\129lQ \254\004\196\194@)`\000\255\007\0052P)\003\023\016\1792\240\t\2403\240\n\2400<}p\015\200\255\253\019 \128\152\024\024\132\128\012\022pl\240\011\2020|\255\209\198\016\147\019\013\213$\002\196\255\129\136\025\172\025b8\015X\237\167\015/\129\134<\007\1789\129\152\233?@\000\001\013\250\006\181\249=\131\164\020\019\003333Cj\132$\144\255\020\136\223\128\197\025\024\222\"\225\231\012\214\246\178\012\029\253\014`60\240\024@f\000\004\016\208)_\129\222b\002\199\198\141\171'\129\001x\151\225\235W\144\225 \151\254b\128x\153\001\22620\254\201\192\198\242\157\225\205\139w@\246Wpr\000\138s\000\004\016PU\212\127\136\215\152\161^\132a&$\204\000M\136\255\224\t\018\129\255\130i\128\000b\129p\152\161\026\216\1440\204pf\168A\127\225\154 .\253\133b(@\000A\013b\131\026\004\011TV$\131`^\131\185\142\017\234\197\191P\254\127\176A\000\001\006\000\239\153\221;\192\020\252\149\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_hn.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002pIDATx\218b\228\020Hy`j\162)`o\163\197\192\203\199\205\240\255?\011\003\003\0033\003\195\127F\134\255\012L\012\200\128\145\225\031\144\248\015d\253e`d\252\195\240\249\211W\134\131G\1741\156>s\253\003@\000\17700\178\136\1569\247\136\219\198Z\157AQA\128\129\153\025h\008\216\000F(\141\012\128\0061\252\007\211\127\255\254e8\127\241\019\003P/P)\011\011@\000\1770\252g\251\003\178\249\216\241\187\012l\172\204\012,,,H\1340B1\003\212\128\255p\195\254\252\249\003\214\243\255?P\221\127\214\127\000\001\004T\149\240\001\168\152\031\164@NN\008h\016\019\146f\014 \254\005e\179\001\241\015\184\161\127\254\252cx\244\232\029\212\194\191\223\001\002\136\165cB,\003''7\208\000F\006&F\016\006\026\195\004a?z\242\145AIA\016\236\138{\015>1(\200\241\001\013\248\015t\197\127\134\127@\199\253\251\255\031\204\255\252\249\003#@\0001\222\184q\227\003?\016\176\177\177\129\195\135\137\137\t\024\144\140`\156U}\147aZ\171:\216\013\201%\215\024\230\246h\129\013\001\027\244\015\018N\191~\253bx\245\234\213O\128\000b\188y\243\230\007\001\001\001~vvv\006VVV\176a C\128\170\025\190}\255\195\176a\247\027\00666F\006/\007a\160\203\129q\003\132 \131@\134\252\254\253\155\225\231\207\159 \131~\000\004\016\019H\019\200\021 \0122\004\132A\001\206\194\202\194P\210t\131!\194W\130!\196S\146\161\182\227\022\003+H\028\136a\234`\250@f\000\004\016\227\230\237\167>\008\240\t\002]\196\198\192\n\245\0303\0193\208\214\191\2240\224\226`c\0009\240\227\231\159\012\204\192pdaba\248\251\239/\196E@o\253\252\t\244\218\155\151?\001\002\008\168$\n\024k,\252\224D\200\192\130\134\217\193\137\015\130A\177\246\019\136\255\160a\144\220\207\159\000\001\196\194! \000\2445\023\208V\014pt\255g\228\132\024\240\159\013\146\194\193\152\001a \227/\176\129\140\255\191\131\147\195\255\255 \252\153\001 \128\128\169\230\015\011$\217\1314\176\002\013\000\026\200\200\014v\209\127\176\171\152\224\169\154\017\236\002&p\246\129\184\2307\208\001\255\129\226\127\153\000\002\012\000\218\137\218\214\142;\229\206\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_hr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\203IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025 \128\t\136\153\161\244? \254\013\021g\004aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ@\157\204`\197\\@\252\021h\2047>\001\134\127\140,\012\204\031\1910\008\003E\254\000\197\193\022\253\253\203\240\225\236Y\006\160^\006\160\025,\000\001\196\002\180\t$\199\240\246\200\017\006f66\006FVV\0066 \127na!\131\228\250\203\012\204\162\204\012\223E\216\024\254\190\005\n\186\1552xL\154\n6\232\255\239\223`=`3\129\014\006\008 \022\144) \252\246\248q\134\031O\15920\179\1760\240\002\249\015x\229\025\158\221z\202\160\188\249\017\003\200\228\159L\140\012\028{X\129^\217\198\240\011\164\249\207\031\134\175\143\030\129\012a\248\tt\017@\0001^\186~\253\003///?+\208\000&&&\006F f\005J>\149\146a\144N\201\007*ae\248\243\2489\003\139\153\017\195\213\166\018\006\237\199\143\193a\245\255\223?\134\127@\252\027h\224\219\183o\127\000\004\016\211\191\127\255!\193\199\200\0124\004\024\022\204,\012\255\216\217\025D\223\189ax\244M\140\2251\139\022\195+-O\134GW>1\168\190~\205\240\151\149\013\172\006\164\022\164\007\164\247\239\223\127\140\000\001\196\196\n4\131\141\153\145\129\029(\206\201\198\196\192\td\240\002\195\234\157\1421\003\027\175\016\003\027\208E\140\159>3\176+\1683\188\145\148`\224\225`\007\171\001\169\005\233\001\233ecb\252\015\016@, /\129\020\179\179\1783\176\177\129lc\006z\145\145A\243\2385\134\191\169>\012\207\132\188\024\152%8\024\004O\2451p~\248\008\014\220\127@\239\255\005\186\136\t\1480\128\177\0052\003 \128\128\238\153\255\001\024\217\252\136\020\003\162Y\193A8\183F\152!\233\255\012\006\134W\031\024\214\171U3\004\149>\007\138\131\162\226;4e\253\131\196\025\195\199\159\000\001\004\244%\196 F\176f\024f\006J3\003\163\153\019\024a/\128\161\240\015h\172\020P\252\007\003\0118\142\255B\147\231o\160\154\223`\131\000\002\136\133\153\2257\011H!#8\189\178\000% \1341\131\013\002%\013\025p\128\178\00250\129S\0243\216\000F\168\236\127\160\222\255\012\127\152\000\002\144L\007)\000\128 \016E\235\254Wm\023D\133a\143Z)\226\031tDv\173\0066c\234H\187\029\138\225Q\024\005uGD\214\242\128\148D\253\002[}\136\147`_W\128\001\000\007\013\217\143\141B\141\206\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ht.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\142IDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\255\127&\006\006\006&\134\255\012\140@\026\134A\224?\0243\130\233\127\012\140\140\255\024>}\250\193pp\255\019\134S'\031|\000\008 \022\006\006v\145\211'?p\219\218\2012(*\2412033\001\1491 \025\130j\016\008\131\172\250\251\247\031\195\249\179?\025\128z\129<v\022\128\000\028\206\221\t\1280\012\000\225k\154\138\130N \184\255 \186\135\224\155\011hIZ\127:\192}\220\007\169\255\007\219z\146:ARd\153{\202\019\136\162\140\195D\1903\005\195\220H\026\216\143\139j\222\026\026\027\235+\128\128\006\001\189\195\192\198p\242\248'\134\199O\12730\178\252f8q\194\150\001\0062\250=\024\174\223x\1990\179k\002\131\006\191\005X\204\194\226\n\195\255?\140\012\207\030\253\000\234e\007\185\143\005 \128X\2542p\001\025\156@\015\000mz\004t:#\208\233LP/\253}\198\192\196e\197`b\253\151AK\208\n\238\197\251\247Y\128a\201\200\192\194\192\007\228\129\189\203\008\016@@\131D\128\012^ f\133\170\251\205\192\206\206\193p\248\192\025\134\128\210o\012\167\230\16510\255\250\200 \227|\142\161'\235?C|\148\021\208\0169\176\210?\224\240\251\013\210\203\008\016@,;\024\236\193\198\176\129|\n\196_Al\182\159\012k\238J3\252\189q\153a\145\171\014\131\0020\244\255~\159\195\176\249\186)C*\027\027\195Q\006=\176\135@n\249\005\196\239\128L\128\000bz\011d\188\133p\192\024d\024\011\011\011C_\250Q\134]G\130\025,\205D\024$5D\025\214\029Ja\152W\182\001,\007r\251\007\168z\152~\128\000bA\142hV(\237\1872\028\152F\1743\240\127\182`\248k\247\017(\198\196\240\231\136\018\003\203\245U\012/\132\1741L\129\170\253\135H\028\140\000\001\196\194\004u\005\0194(\129i\129\193:a\013\195\127v.\134_\191\2551\136\242\2420\176032\188\254t\143\129\017H\255\254y\021\236\029&X\196Ci\128\000\002\025\004v\213_\168A A7\160J\246_\223\192\138~\254\248\001\022g\129\202\255\131z\2337\146\030\160:&\128\000b\001*{\003\012\180\127\140\008\195\025\129\201\236?$!\192\1474#4\008\128\145\014\204\029P\241\127P\195>\001\237\003\0080\000\232B\205\"\191\243\130\019\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_hu.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\211IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\25410\252\001\137\191=r\132\129\153\141\141\129\145\149\021\167!\200\134\253\255\253\027\172\007l&\003\195?\128\000b\001\153\002\194o\143\031g\248\241\244)\003\019\011\011D!>C\128\248\223\159?\012_\031=\002\025\194\240\019\232\"\128\000b1\190~\157\129\151\151\151\129\021h\000\019\019\019\003#\008\019p\0178\012\255\253c\248\007\196\191\129\006\190}\251\150\017 \128X\254\253\251\015\177\135\145\025h\00830\136\152\192\001\t\018cDs\215\127\168{@\017\242\151\001\024(\255\255\130=\246\247\239?F\128\000\132\142\011\021\000 \008\0037\016\232\159\215\1358\019\024\224>+\155\168c\200q\004\003\254\132\228\231H\"6\182:&V\252\\\001\196\194\194\0014\128\147\133\129\141\029\136\217\128\006\001c\013\228E|\000\228\165\191\127\129.\255\0054\146\249/\003\200\012\128\000bd\152\200\240\129\129\155\129\031\020\135\012,@\204\140\028\199x\002\233/4\150\128!\0134\225'@\000\1770p\000\025\220@\204\n5\004\217\160\2558\018\017\204\160\191P\203\12700\000\004\016\011\152\t\142O f\130J2\162\217\206\128E\012\166\007\018WL\000\001\196\194\240\139\225\013\195\023\160\016\019\208-\140`\163@\228\127\160\008#\212\128\255\208\232b\128F#,2\255\131\013\002y\239\011\195O\128\000\003\000P\005\146\192\222\011\233L\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_id.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\140IDATx\218b\156\199\192\240@\210\220\\@\220\209\145\129\133\143\143\225\255\255\255\012\255\025 \000F\195\000#\018\205\200\200\200\240\231\211'\134\151\251\2473<?y\242\003@\000\177\17630\136\2528y\146\155\213\206\142A@I\137\129\129\153\025\174\017\151A`\240\247/\195\135\179g\025\128z\025\128f\176\000\004\016\011P\232\015H\252\253\145#\012\204ll\012\140\172\172\012\196\128\255\191\127\131\245@-\252\007\016@,\127\129\140\127@\252\238\248q\134\031O\15920\177\176\016e\208\191?\127\024\190=z\004\214\251\011\232\"\128\000\002\027\244\023\234l\144\004\019\208\239\140\132\\\0032\008\024\150\255\160z\129\152\017 \128X~\002\025,PW1\1290P\001\019!\215 \225\223@\252\003h\016@\000\1778\220\188\201   \192\192\206\206\206\192\n\012\031f``\131b\004\175\139\128\150\253\005\006\246o`8\253\252\249\147\225\213\171W\255\001\002\136\005\228\021f&&0f\001\026\0022\136\137\t\191\155\254\253\251\007\246\254?\160a } 3\000\002\008\030\178 W\1280\200\016B\006\193\013\131\186\028\232BF\128\000bb\160\018\000\008 \022\160i,0\027@\024\228wP\024\016r\013\012C}\195\004\016@,\223\190}{\003d\252\003\0064\208\187`\192\008\196\255a\t\025(\247\031\228t\024\027\168\025$\0002\228\255\031`Z\002\005\246\219\183o\127\002\004\024\000\2511\159GT\031>$\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ie.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\244IDATx\218bd\157\207\250\192L\210L\192A\194\129\129\151\133\143\225\239\255?\012\012\255\025\024\210$\210\024\024\024\0250\193\161\249\012\012\191~30\17622\252\251\254\137\225\203\149\253\012\239o\156\252\000\016@,\012\236\012\"\167~\156\226\182e\177eP\018P\004\234\133\232\230\226\226\194n\144\140\n\003\195\159\191@\187\2542\252\186\127\150\129\249\193I\006\014\022\006\022\128\000b\001*\254\003\210p\244\253Q\0066f6\006&F&\176\139\220x\221\024\176\130\167\215\128.\002\186\154\2257\195\239\155G\192v\253\255\207\240\015 \128X\024\2543\1305\158x\127\146\225\233\207\167\012\140\140\140@\137\255\012YBY\216]tl9\195\255/\223\025\024X\2540\252y\253\008\172\228\223\031\006\022\128\000b\249\015\146\004jfd\250\207\240\248\215\019\160\131\255\128\013bbb\194n\208\155\135\012\012\159\1902\252c\251\207\192\252\031\236\026\144C\024\001\002\136\005\172\026h\016\208O\012\012\204 \177\255`\131888\176\026\244\031\232\003\144\154\127@\246_\006\132A\000\001\196\002V\012\194\204P\012\24640RXY\177\187\008h\225\127\160c\255B\245\129\236\007\133*@\000\001\013\250\015f1\130\012aa\000\179A\006\177\176\176`7\136\245\031\195?\168\218\191\127!\006\129\226\007 \128X@\190b`\250\0155\026b(\216b\\a\196\012Q\0032\012&\013\020a\004\008 \184\139\224^$\004\254#\177\145\130\005 \128X\192\142\252\015\0139\144\243\160a\244\023\228nl\006\003\003\231\031P\254\0310\180\255A\013\005jc\002\008 \022\134\031\012o\128\026\25410\131C\t\2266`\180\188|\249\146\017\018\161\140\192H\252\207\008\209\192\248\255\223\023 \241\021\156v@\153\137\225'\208\176\183?\025~\002\004\024\000t\152\158H\217\233\216\015\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_il.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\0021IDATx\218b<s\230\204\003AAA\001\030\030\030\006&&&\006R\192\191\127\255\024\190|\249\194\240\254\253\251\015\000\001\196\200\192\019\254\133\129\145\149\1874\223\151\193\216@\145\129\153\153\005\168\004d #\020#\131\255P\252\143\225\239\223?\012g/\220g\232\158\184\025(\244\251+@\0001&v,\253\192\201\206\193\175(%\196\160&+\206\192\204\196\008T\n\197\255\025\129\174d\004\027\251\231\031P\132\017.\195\240\023\200\191\245\248%\195\253g\239\024\190\253\248\254\025 \128\024\175]\187\246\001\232-~fff\006\022\022\022\176\189\140\140\168.\249\247\255?\003\019\146\216\255\255\255\193\244\159?\127\128.\251\011\242\218w\128\000b\002i\002\133\013\200 \016\027D\131\248@\1350\220y\241\137!\160\251\004\131{\211Q\134[@6\019P?6\181 \187\001\002\136\005&\192\202\202\n\151\000\137\129\028P\176\232.C\142\151\022\131\008'3C\234\252\167\012\167\155\197\025@\142\001\185\008\020\208 \215@]\199\008\016@,\200.\130\025\006\241\0260,\128\001\207\204\194\198\192\202\002\020cb\001\2033\128\195\238?\216\016\016\000\187\158\137\233?@\000\193\013\130\025\006w\238\255\127\012s3\021\025r\231\\d\248\244\227?\195\138<\003\006\022Ff\006`l\128]\003\002 \195`>\000\008 \022X\000B\188\1310\020\148\004\180\229\133\025\2465;\225LC\176H\001\186\144\017 \128X\1866\158c\224\226\230\005\198\024+\003#\008\003\189\243\159\001\132\153\024\254\002\163\031\228-\160\157\012?\1291\196\012\142~\160\001\012\127\024\254\003\211\209\255?\191\1291\247\155\225\243\199w\012\000\001\196\200\192\027\tL\144\236\220\012\012\236@gq0\128i\0066\1605 \199\194\018'\216\013\160\008\007\170\001b\134_@\252\019\168\230\007\148\254\254\027 \128\024\207\159?\255\128\155\155[\008\024\144\204L\016\192\008\n<X\178\006:\255?\200\23306\208K\140\208X\251\015JG?\127\254dx\253\250\245O\128\000\003\000\005c\203\020T\190\160%\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_im.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\214\216\212OX2\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\127IDATx\218|\146?O\0021\024\198\159k9\016\021\205\137A\137\134\193\139\1311\222\128\026V\007drq\243+\232g\240#8\026\191\129\142.:\144\136\019\t\027\023e\240OXL \158\024\008\209\131x\028\244\206\210\230\008:\208<\029\218\247\249\189o\251\182J\025\208\210\233\153l\150\196b\240}L\024\138\226\217v\183Ph\155f(\nP\211\012\231ra]\007!\1470\207s+\021\19949\018\026f\001\220bQa\012\148N\194\024sK%E\022~\006f\001^\133&\147\132\210VD!^\196I.\215\022\026;\015?>\193\2314\212\030Y\236{\030c\204\178<\160\195\253\156\166B\196\178H\189\222\251\168_\025\241R4\254\164\239\013\194Z\171i\221\026\027\221\247a\136\027\164\147#\202+0\015\168\001\204\183\026a$\\\\\031\159v\136O\239\242\235k\153L\254\130\247\138\t\245\129/Y\141\008@\013\180\234\162\186\187o\199S\250\212\146\127x\160\213.G!*\204\195\235U\129&`\003\142\200$\243\157\029\025\231F\218\017\203A\176\233\008[S DvR\138\008\241\230\158\220\188\173ln\221o'HP\129\140\217 \171\181Dsz\"\171\031\232ES\203\169\232h\201\132\161#\204\028Q\248\212\128\200\216\209\229\240G\137\229S\007G\229p\155\135\030\1299\193\132\254b\255\127HpON~\003\191\002\012\000\189\133\144\237\013\167\013\233\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_in.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002[IDATx\218b\220\150,\246@T\197T@P\205\154\129\153\131\151\225\255\127\006\006\134\255\140@\002\132\177\001\160\002\198\255\012\140@\233\191?>3\188\191u\148\225\245\157\211\031\000\002\136\133\131\137A\228\223\147\211\220\172\026f\012\220\226r\012\140L\204\016\195\240\000\144!\255\255\253e\248\250\248\002\003P/\003\208\012\022\128\000b\249\255\225\213\031\006V\006\134o\023v00\255\254\197\192\200\204\n\183\152\133\141\145\129\157\153\t\200dd\248\241\251\015\195\191?\008\135\254\255\251\155\225\219\213}\012\012\239_1\252\251\197\240\015 \128\024/_\187\246\129\151\135\135\159\137\153\153\129\133\133\005\162\014H0\001\137\231\031\1910\172;\127\143\129\135\157\149!\202T\141\129\149\005\232Z\016\252\015\182\135\225\207\031\160\225\127\2552\188{\255\254;@\0001\177\000\221\201\194\196\196\192\0062\008\200f\005\210\172@\239\189\253\243\159\161\241\220\011\006iI9\006~Aq\134\156\131\247\025\152\025@j\153\193j@j\193z\128z\153\129V\003\004\016\019#P\128\025\164\153\149\149\129\141\141\013\140\217\217\217\025\022\159{\199\224&)\198\240\238\031#\195Of\022\006'\tQ\134\029\247\191\129\229`\234@z@zA~\000\008 \176AL S\209\012\147\225\231ax\241\151\145A\146\151\139A\146\143\155\225\218\215\255\012\170\162\188\024\134\128\244\002\241\127\128\000b\129\025\0043\012&\153a%\197\176\230\212o\006\193\255,\192h\254\199\224/!\198`\"\015\t\232\127\255\254\129\233\191\192\240\001\169\005\153\001\016@,\013Gg3p\241\1760\176r000\179\128\188\201\004\142_6\160wx8X\025\182\159\190\201\192\013t\129\155\174*\195\238\253_\025\254\254\007\026\002\012\237\191\127\2551\252\005\134\227\239\031\012\012\159\223\255`\004\008 F\134p\134\015\012\236\012\252\160\016\003cFH\212\131i\022 \230\130\242\191@i\164t\201\240\023\138\1911\252\004\008 \022\0061\160rN$C\024\145\020\"kd\199!\255\023l\t\019@\000\1770\252fx\003\020\248\007T\0002\n\146\250\024\192\201\133\017j\208\127\184vF\176(\130\013\146\001\005\215w\134\159\000\001\006\000\140\029\174\143\227\250<\218\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_io.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\174IDATx\218\000I\000\182\255\001\143Td\225%DD\015\230\002\022\000\237\241\000\000/\018\251\000$\004\243\000\176\237\027\000\006\254\248\000%\024\n\000\030\020\n\000\211\243\001\000\003\004\002\000\014\014\004\000\244\243\248\000\243\239\245\000\003\005\253\000\254\254\246\000\220\218\225\241\002\136\209\193\180\240\139\167\026'wL\1867\195/I\005\006\134\183\031\0248\191\189cx\203+\197 \202\197\196\240\135\157\131\225\193\155_\012,\172\204\012\172\172L\012\191\127\255\001\210\140\012\012\172?\024.?\186\1930g\195J\006\233\223\170_\001\002\000I\000\182\255\004|\250\189\252\255\208\255\000\229\149\221\000\026?=\000\253\250\251\000\243\245\246\000\017\018\017\000\247\002\005\000\251\252\255\000\030\002\254\000\215\007\031\000\235\011\023\000\t\007\000\000\003\005\255\000\000\020\239\000\179\220\170\000\238\252\234\000\012\237+\254\002\000I\000\182\255\004\152\011L\000<3\028\000H%\002\000\219\226\241\000\252\238\236\000\012\228\219\000\225R`\000 \253\239\000\223\227\238\000\196\229\255\000\n#\244\000\022!\012\000\238\237\248\000\018\018\n\000\211\225\222\000\220\207\232\0009&D\000\t\020\025\004\002\000I\000\182\255\001mg\165\240C\021\255\015\189\206\232\000\179\213\253\000h+\247\000J\004\219\000X\2309\000*\"\011\000Z1\n\000\239\225\231\000\192\233\006\000\238\001\011\000\249\245\250\000\008\n\006\000\017\023\013\000\016\002\245\000\212\220\251\000\242\243\244\248\002\000I\000\182\255\001ND\160\240\236\244\007\015\013\031\021\000\018\020\t\000\253\232\239\000\246\230\236\000\238\011\020\000\029!\013\000\006\013\007\000\002\241\244\000\252\251\253\000\028'\019\000\023\021\007\000\226\229\249\000-\030\003\0000\025\237\000\236\247\008\000\202\222\246\249\002\136E\194X\154A\133\155\135\225\217\211_\012\191\128\182\t\169H0h\218+1\188\127\243\157\225\197\019\160\001_~3H\202\0113pq23<x\240\153\225\198\245\207\012\188\162\188\012\252\015o00_nf\224gVfx\248+\241?@\000\177\220\188\240\136\129\131\131\147AVN\128\129\139\159\149\225\227\187\023\012\167o|f\016\022\229a\144\150\000\186\016\024\216\143n\188b\248\249\2277\131\180\156 \131\184\028\011\195\251\247\175\024\246|\251\193\240U7\155\225\218\189\159\192\228\240\157\001 \128X<\220\196\025y\184y\025>\188\255\014T\252\139AKU\136\129\139K\146\225\231\175\191\012\143\031\127d`cga0\210S``bbdx\247\230\027\195\187\247_\024\228uy\025x\249\165\024\184\190\222e\224\017\226`\224\253\245\150\017 \000\131t\180\003\016\008\006`\244\139\191ld\238L/c\030\206\195\234\nk+\013\141\243\012G\205\203z\027\173\197\218\246\207f\217\182\136\024\205\149+&7\016S!\156\023\"\127\200\n\198\177\193\251\029\197\131\235\014r\221\019\210[>\001\000I\000\182\255\004GE!\212\005\006\t\013--\025\n\011\011\t\005\218\221\240\000\222\224\244\000\027\028\014\001.)\019\255\246\248\253\001\212\216\248\012\221\224\249\005ic&\255\031\026\n\000\230\231\240\250\155\158\202\255\025\024\031\255RO,\001\231\231\233\251\002\000I\000\182\255\001[[\137\236\000\002\n\015\214\215\242\001\243\243\003\001\028!\026\000\023\027\017\000\234\232\250\000\224\220\245\000\006\008\005\000\031#\015\002\019\023\006\000\197\186\229\000\226\221\201\000\028\030&\000FM\025\000\239\236\241\000\177\172\196\000\255\254\244\252\002\012\000/\167NO\179\175\181_\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_iq.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\220IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\25410\252\001\137\191=r\132\129\153\141\141\129\145\149\021\167!\200\134\253\255\253\027\172\007l&\003\195?\128\000b\001\153\002\194o\142\031g\248\249\244)\0033\011\011H\002\162\024\136\153\160\236?P6L\236\255\159?\012\159\030=b\000:\132\225'\208E\000\001\196b|\253:\003\015//\003\027\208\0006&&\006& \006i\250\005\196\172P\204\0005\008\168\129\129\013*\246\239\223?\134\223@\252\019h\224\187\183o\025\001\002\136\233\223\191\255\012,\140L\012\156\204\172\012\190\235\026\024\\\151\0232p\003C\238\241\199O\012\187\158\221g\136\217>\149\193uU\001\208\021\236\012\231\223\190d`\254\207\206\016\184\177\131\193aI\006\208\245\172`\189\127\255\254c\004\008 &6`\232\131\\\194\204\202\204p\241\254b\134\203\239\1501<\250\250\153\225\199\255\223\012\017\178z\012\231\159-f8\255n\t\195\201W\015\024^\252\250\200\192\207\201\198p\250\238,\134k\143\2151p\1760\131\245\17831\253\007\008 \198[\183n}\016\020\020\228gggg`\003\006630\214@\222\195\007@\222\250\011\140\181_\191~1\252\252\249\147\225\229\203\151?\000\002\008\020\142\031\128\152\159\1292\240\019 \128\152\024\168\004\000\002\008d\016\0115\204\001\008 \144!o@\222\006bf\164d\243\031)\017\227c\195\189\006\016`\000}^\157f\141\004\2324\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ir.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002nIDATx\218bd\152\192\240\192\\\198\\\192Q\218\145\129\143\141\143\225\255\255\255\012`\000\1650\000#\148bdd\248\244\235\019\195\254\167\251\025N>9\249\001 \128X\024\216\024DN~>\201m\199b\199\160$\168\196\192\204\200\140\219\016$\195\254\254\255\203p\246\237Y\006\160^\006\160\025,\000\001\196\002\212\244\007$q\228\213\017\0066&6\006V&V\006b\192\239\127\191\193z\192.\252\199\240\015 \128\024Yg\178}\176\149\246\228\255\199\240\019\2325n\006^V~\006\006&\006\006\230\255,\012\223\024\1272\176\178K\002\185\204\012\255~\190f`\254\251\023(\0014\228\207o\134o\127\1910|\249\249\131\129\139I\144a\223\195\013\223\001\002\136\241\250\149\235\031xyy\249Y\152Y\024\152\152\153\024@\016\012@\020P\211\159\174\149\012\127\190~b\224hL\005\250\007l;\216\021\255\254\003\157\241\247\031\195\159?\127\024\222\190{\251\003 \128\152\254\254\253\015\020dd\248\207\008\212\t\012\031F\022f\006&vV\006&n\014\134\183\005\243\025\190z:2\252N\014ex\157\210\207\192\008\020\003\201123\131\213\130\244\252\003\154\250\251\207_F\128\000\028\209A\n\1280\012D\209iL\138\224\249=\129G\172+K\136\191]gx\204\016\207\000\t\144\014\016\000\132\154\153\202\t}\175\198\253H\231%\159c\223\155\001\208\164\152\153s\253%U\253\168_\00011\001]\192\200\006\140<\160M\204\028\192\224\007bV \230`aa\144^^\199\192%\197\003d\127d\144\221\212\015\022cegc`\003\202\131\213\130\244\000\245\130\204\000\008 \198\149L\204\031\164\\\131\2499\254~c`\252\246\149\129\141_\128\129\005\148\004\152\024\025\254\253\249\203\192\"\173\000t1\027\195\255\231\015\025\254\255\250\005\142\164_\192@\254\243\253+\003\003\031?\195/NA\134\187\219V\252\004\008 \150\191\255\2542|\222\185\n\024g\012\012,\2080\134\1669\140\228\132,\014\n\243? C\161|\128\000\002:\n\172\031\028!\012X\012\249\143&\142,\015\211\003r?@\000\177\252``x\003\020\252\199\008\230C\028\004\228\1312\n#Rfa\132\026\002\140_`\238\128\138\255\131\026\246\137\129\225'@\128\001\000\242\216\193\027=\2505\176\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_is.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\211IDATx\218bTS\216\240\192\192PR\192\204B\152\129\133\157\133\129W\150\155\193\143\2294\003\195\239O\012\219X\157\025^\223\253\193\192\193\198\000\005\255\025\024\1614\019\019\003\195\215\207\191\025N\157x\203p\225\252\243\015\000\001\196\194\200\200!r\229\210/nSsf\006\005En\006>\t.\006.fQ\006\134?<\012\n,\\\012\002\140\204\012l,\012p\192\0084\004\004\254\254\251\207p\237\202g\006\160^\006\160\025,\000\001\004T\194\244\007$}\254\204g\134\191\012L\012\226\255\216\024\140\153\031\002]\244\133\225)\135>\195\227\027\223\024\184\216\025\160.\129\184\006l\208\159\127`=\016\025\198\127\000\001\196\242\254+3\003#\0193\195\222\163\223\024\206_\253\205 k\201\193\224-y\152\129\225\251\011\134u\127\188\024\174\237}\205\192\195\203\132d\016\004\252\001\026\244\244\233O\134\255\255\153\025\254\253e`\001\008 \022y\007)\0066v^\006f&\022\134w\223\153\024\004T\152\024\152^\17920\188\249\201 \164\201\196\192\172#\203\192\203\205\192\240\015\205\160\191\255\2541\168j\255c\248\247\239\015\195\207\239o\025\001\002\136\241Fh\252\007~v6~6fF\006fF` \178\n3|\222\179\147\225\255\239\159\012\002\158\158@\171\191\128\180\0011\019<\184\255\003\225\191\255\140\012\127\255\255g\248\245\247?\195\171o\223\127\002\004\0160\176A1\240\031\232\"F\006V ffab`ed\002\251\157\149\153\025n\000,\168\193\134\129\013\249\007v&\211\127\176\254\255\000\001\196\018\207R\195\192\206\"\008\212\196\206\240\238'\027\131\174\0303\195<~\160\134W7\025\n\181\218\025\142\156a`\016\227\133\00514\184\129\134\252\007\006\204\191\191\191\024\2540\254d\248\206\242\146\001 \128X\238\238y\0144\241+\016\179\001\211\005\019\195\239\143j\012L\202\207\025\024X>0\\:\207\196pc\237=\134\023\002Lh!\0044\232?\200\187\191\129a\244\139\225\239\2237\140\000\001\196\"\204\243\143\129\153\249\031\003\019\216\139\140\012\146R\012\016\239\252ga\016\021c`\224\226aa\016\226a\132'Dp:b\004;\011\136@a\245\015\028\131\000\001\004LG\127Y \137\236?\216\239\191~\255e\248\203\198\t\020fg\248\246\235/P\148\025\024\030\140pC\024\025Aa\003I\014\1400\131\025\2543\001\004 \145\012R\000\006\129\024\184\187z\234\255?)\020<T\169RM\026\240\150K`\018&\147\239\189\145\000\142\180W\142\222./\016^3\127\162\232\135\202\241\169\127H\024\006e\205\242\197\160\172\182)\021\234\252\005\024\000\219\206\007\172b\253]\255\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_it.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\186IDATx\218bdHbx`\174a.\224\168\234\200\192\199\193\199\240\255\223\127\006\134_\012\012i6i\012X\193\172Y\016\154\145\145\225\223\167O\012_\246\239gx\127\242\228\007\128\000ba`a\0169\249\252$\183\157\134\029\131\146\184\018\0033#3\003\195o\006\006...\236\006\169\169\129\169\255\127\2552\252:{\150\129\249\228I\006\014\006\006\022\128\000b\001\138\253\001I\028\185\127\132\129\141\153\141\129\149\137\149\129\225'\003\131\155\186\027v\131\174^\133\208\191\1273\252>r\132\129\017d(\003\195?\128\000bdHa\248\192\192\203\192\015\146\147\019\146c\0009\145\225+\003\195\137\162\019\216\013\178\176\000i\004Z\255\135\225\207\163G\012\127\129\204\247\012\012\223\001\002\136\133\225\031\196H\016x\244\254\017\208\006\160\029\159\024\024\152\152\152\176\027t\255>\152\250\247\255?\0033B+#@\000\177\128Y \195\152 \162\255\255\255\007\243988\176\154\003\146\135i\249\139d\016@\000\177@((\1349\002h\021+++\003.\240\031j\008\003T\011\016\255\007\008 \0220\139\005*\194\012\149e\005E\003\011N\131\254A\233\191Pm 7\000\004\016\011X3\204\016f\132\139p\134\017\146a\140\008\0232\002\004\016\011\220HFT\025R\001@\000\129\012bA1\000j\200\223\191\127\241\186\230\031\146\023\129\218\153\000\002\136\133\225;\195\027\160\230\127`\015\253\007\026\251\031(\254\137\225\255\203\151/\025\191|\253\005\204\t\140\192\136\250\015\182\138\145\135\029d\013#4\197\252\007\165d`nbx\011L\194\000\001\006\000H\030|,e\140\"D\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_je.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\214\216\212OX2\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002xIDATx\218|\145_H\020Q\020\198\191{\231\206\186\201\186\174\171\022\022A`\004Q bBZXO\253Cz\008\162\151\196\167^\163\"\138J\003\t\005\t$\236\193\160\030\196\196\216\007\011\170\007\031\132\197\138JRT\018W{\208Z\"\214\157]\183eu\157\153\157\153\211\157U\151\n\234\192\225\222\153\203\247;\231|\135M\248|\243eg\154\131\190;\237\014\223\185\029\191\007\145\005\007k\242\226\1281\0318S\255xw\226I\172vw\243ThhEx{\031V\241\190>\191:4\128\162\011\023\129\189{\000\133o\128,\003\206\143\025\151\008^U\007\230)\222\170\000,Fa\132\134\192?\141\195\219\211S\196fgg\019%@\185w4\012oz\005\168\218\00545\201s\007\176\182\014\231\205\147\188\1507\180\000\129\000 \187\192\187\183\192\215E\232E\219\160\159<\129\180*R\1561\006\230\247\195:\127\014zC\019\140\231/`\158m\134\249h\000\230z\022zd\002\250\212\008L\211\132\249t\024f\243i\024\131\131\208k\014\193jm\001\171\172\128m\219*\155\155\155K\248\253\254r!\0048\231`\178\011\2147\012\244\220\000\026O\001R\136\\\014\008\143\201|\005\\\186\005\186\210\n\n\250\2258\014,\203B<\030\207\178H$\146\008\004\002\229\170\170\162\000\147]b2\n\\\189\002|\251\"\231\018@Y\016\232}\012\028\173\150\022Q\001\146\147Eb\177\216\186pE\174\216\133\184\169(J\254\027A\031P\\\006\172\198\001!\183\181\187\026\168,\005<\158<D\142\147\247\206=%\1316<\218\132\185\016a;\016\015\158A\028>\000\145\253\014\241r\020\226\181L\143%\255\237\131\232\234\1350r\133\130[z,,,$4M\163L&C\198\199I\178\235\027\221\229\018]\187K\164%\169\016\169\159D\183\187\242ovm=\025c\031\242\026W;==\157\221\000E\163\148\233\232$\195\227!{\255A\162\1450\2533\194\239\201\174\169#CQ(\211\214A\218\210\210&(\020J/\031;NiY){\185\141\204\152F\210\196\255\166\153LQ\246\250=JsN\203\141G\232s\127\191\206\166\002\129\249\226\146\210\n\222y_\160\161V\145s3\153nm\230\154\233\026\249\247}skd\141\207 \215~\147iIM\255%\192\000\169\030\128\1722\141-\204\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_jm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\018IDATx\218b<s\134\225\193Kns\129\195\175\029\025\248\216\248\024\2543\255g``d``\000RX\001T\142\241\031#\195\167\239\159\024\244\133\2473\168\254<\249\001 \128\024\165\164\025\190\028;\202\192\205\199W\202p\249\1671\195\171\143\204\012\012\172P\013\216\000\200\130\223\012\012\130\188\127\025\1408\2072|\250\212\205\224\236\202\240\021 \128X\158=e\248\163\160\192\192\176q\229\017\006\007\0156\134\127\172\172\012\019\031A\0203\176\161\025\002\018cb`\200\144g`\224d\251\205p\238\216\017\006GO\176\204?\128\000\002\217\251\001\136\249A<Cc9\134\029\219X\024\024\129\162S\15800,9\015\147\129\168\242\213g`\168\006\026\242\031\232\170\144\176?\012\135\015>\130Y\241\029 \128\160J\192\014\006cFF\198\255\205\205\140\255\223\188\001\226G\140\255\025\231\002\241,\198\255/\239A\196\166Md\004\171A\214\0032\008 \1280\012B\198\247O3\252\255\242\025\130?\223\196\174\006\138\127\000\004\016\011\003\030\192\t\012tVV(\135\021\159J\134\255\000\001\196\132M\180\175\143\129\225\239_\006\006QE\006\006\246M@\188\150\129\225'?Dl\241\\\236&\001\004\016\138\215$$\025\254\003\021\255\007\006\230\255\162;@\1779@\188\001\138\129\236\248\171\0169\144\026UuT\175\001\004\016<\214\150\205b`\008\142g`\248\243\157\129\129\251\000P\228\011\016\243!\165'\144\242\175@\012\012\140\023N\192t\196\195\192p`+\003\131{\016X\246'@\000\129\019\228\197\011\012\220l\1924\147p\139\129a\253Y\160\176\008D\003\220\000\006$\003\255\000\241\027\006\006\007=`\218\211f`\248\245\139\129\193\194\138\2257@\0001\158?\207\240\224\018\019\131P\252A\006f`bcb\224\000ja\006j\255\007\213\202\008d\255Gb\131\200\127 7\000\217?\025\024\186-\025\024\204~1\252\004\0080\000{\t\201&\214e\173\241\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_jo.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\018IDATx\218b,g`xp\192\220\\\192\209\209\145\129\143\143\143\225\255\255\255\012\196\000FFF\134O\159>1\236\223\191\159\225\228\201\147\031\000\002\136\197\135\129A$\244\228I\238Cvv\012RJJ\012\204\204\204D\025\244\247\239_\134\179g\207\130\012\001qY\000\002\136\229!\003\195\031Q +\250\200\017\134[ll\012{YY\1372\232\247\239\223\012G\128z\160\224\031@\0001.b`\248\192\197\192\192\207\002\228\233\200\2011\252faa(\005\178\175\241\t00|\250\128\211\160?\127\2540<z\244\008\198\253\014\016@\140\243\129\006qC\013b\002b\014\160\223\197\1294\143g\004\131\224\162\2018\013\250\247\239\031\024\131\012|\251\246\237\015\128\000b\250\007\018DR\160t\226\022\003\239\181G\012\183\182-g8%\"\194\240a\2501\006\022\014\014\006fV6\006f\022\016fe`bfa`d\002Z\205\200\204\240\159\129\145\225\207\223\127\140\000\001\196\194\008u\t\012s\235\2032\176\000]\197\0065\152\245\0153\003;0\220\254\129b\243\031$F\255\003\225_\198\191\012\191AB\255\152\024\152\2551\253\007\008 \022P\028\177B1\200{\015\129\182K\002M\2122\143`\1448\182\020b\218/ \230\004\1979\194[\127\255210\254\002\026\201\252\023\232bf\006\128\000ba\129\026\000r\129\030\2166\006\006\175\"\006\134s\181\219\025\024\142\000\173y\006U\128\012@\138\254\130B\028\136\127\002\241\007\006F\128\000b\001y\135\015\136\141\128x\1692\003C\198r \003\148\030\142|\132(\230FN\133h\006\253\133Z\242\131\129\001 \128X\148\128L\030 \219\190\018\232\138l \227\006\003\196\021\200\182#\027\002\019\251\015\141\165\255`9&\128\000bY\167\198\240\166s\002P\136\139\129\153a70\188\255\129\132\129\210\255\160Z\025\193a\139`\195H\006\176\026\136\247\1900\252\004\0080\000\167s\157\177\015\029\141\166\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_jp.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\171IDATx\218b<s\230\204CAAA~\030\030\030\006&&&\006R\192\191\127\255\024\190|\249\194\240\254\253\251\143\000\001\196\194\193\193!\204\204\204\204\205\202\202\202\192\198\198\198\192\200\200H\148!\255\255\255g\248\245\235\023\003P/\003\208\012\022\128\000b\001j\252\003\210\252\251\247o\176 \n\184\247\132\129\225\209S\008[N\154\129AI\006E\026\164\007\164\023h\232?\128\000\002\025\004\230\252\249\243\135\225\199\143\031`\005`7M\156\201\192\176b\001\170\193\1931\012\012%\217\012\255\161\\\144\030\144^\160\023Y\000\002\008l\016(l@\174\129\177\025v\157``h\175\199\244OO3\003\131\129)\003\131\187%8|@z@^\004\217\013\016@L \205 \001X\024\1290\251\238\219\012\028@\005\2160\251\158;pu =\208\224`\004\008 \020\023\193$\024\241\197\030P\238?\208\144\191\127\255B\185L \252\031 \128\152`\006\193\012\003a\022?=\006\022\160\"\172\024(\007S\007\211\0072\003 \128\224V\195\002\029,\233k\207\192\148_\205\000\146D\193Y\165\0169\168fXR\001\134\019#@\000\177`u>H\193\132\022\006\006g\023\006\134=G b.6\012\012\190\014\176D\132\161\005 \128X\128\166\177\192R)\008\131\252\254\031\166\208\203\022\130a\000\026.0\181 \012\245\013\019@\000\177|\251\246\237-\144\241\015\024\208\204L\016\192\008\n<Xr\002\202\253\0079\029\198\006j\006\t\128\012\249\015JG?\127\254dx\247\238\221O\128\000\003\000\207\248\154OT\029\222o\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ke.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\155IDATx\218L\198\171\013\1920\012@\193\231$\216\2346\198\158\220\216[t\132*8?\181\168\135N\128\219\204.wGU\217{\243j\1732\198\228\175\212\194\154\235\187\136\208{'\"\200\204\231\008 \022\160\152\008\144\193mgg\199\160\164\164\196\192\204\204\012V\168\166\174\203\240\238\253;\1347\175\158\130\249\002\130b\012RRR\012\215\174^\000\243\255\254\253\203p\246\236Y\144!`{\001\002\008d\208\031\016\235\200\145#\012lll\012\172\172\172`\133W\175^e\176\179\182\007j\188\202\192\008\228\155Z\1390\172[\179\130\225\239?\136+\127\255\254\013\214\003\005\255\000\002\136Q\221#\252\003++\019?#\211_\006IQa\006f&\022\176\204\135o\223\024$Y\2542Lg`c`dcg\200\255\246\158\225>\003+\131 \023\015\196E\255\2540<\127\253\150\225\255?f\134_?\255|\007\008 \150\245\012|\012\188\140,\012,\012\255\024\152\222\252e`b\252\199\240\159\001Hsr3\236\190t\142\225\n\159 \003\027\007\027\131\251\163\135\012>\134V\012\255^\127\003\186\144\153\225\0310,\2551\0082\252adbx\203\240\147\017 \128\024\231\002-\231f`\224g\003\005&\020\131\188\162\n\196I /\201\1683\008\178p2\172~p\129a#\144\127\029\136A\209\241\015\138\127\129\\\207\192\240\019 \128X\024\145\012`\134b\144\024+\148f\250\207\200\192\194\200\008\246\014\2002\022\168A\176\248\132\234\253\015\016@,V\214\185\012\130l\172\012\236@\030\027P=3\211\127\006F\160\179\153\1858\025\026\238^f\016\016fa`\002\178\245\025\005\025\164\245,\025$\190~e\248\0154\248\239?F\134_@\019\127\002\157\245\242\199\015\006\128\000bT\153\014\012l\030f~&v\160\011\128\238cdf\004\187\229\015\023\027\131\216\239\015\012\251'\240\001\013fgpO{\196\240HD\138\129\245\211O\176\155\254\255\005\226?\192p\002r\127\189\255\245\019 \128\024\129\001\241\129\129\157\129\031\236f\228@\002\005\0000\130\164\030\003]\nL \015\148\128\252\207P9\006\164@\002%\158o\012?\001\002\136\005h\008\011\003\007R\224\192\020\130\002\226;\003\1953\t(\255;R\192\193\228\255C\003\013\024\225\000\001\196\194\240\155\225\013\003(&Aq\250\031\234\158\255`%\140\012\255\225Z \218\025\161lF\1848\196U\223\025~\002\004\024\000\142\206\199\196\190\138\218|\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_kg.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\006IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\0130\131\254#\025\128L3\252\253\203\240\225\236Y\006\160^\006\160\025,\000\001\196\002T\248\007$\254\238\200\017\006f66\006FVV\020\003\216D\129\154Y\024\024~>G5\232\255\239\223`= \240\015\136\000\002\136\229\031\132\193\240\238\248q\134\159O\159\0025\177@\012\000:L~/\208\226'@M?\024\024x\252\129a\224\0014\240\019\212\160?\127\024\190>z\004\214\251\027\232\"\128\000b\249\0115\136\t\136\191\001%\152\128~\007\217\170r\141\129\225s/\003\003\151\011P\142\139\129\225C3\003\131\236f\006\134kr\016/\192\194\018\164\023h\006#@\000\193]\004\247:P\129\160\0060\168\222\003]a\0144|/\200v\006\006>;\160\129\183\128\180\005\003\195\155\227\008/\194\012\002\008 \022F\168k@\152\025*\t\n8\144\215XT\128\134\220\004*\006yM\011\232\146\143@1\160N\022$\139\161z\255\003\004\016\019H3+\020\003C\159\129\027\228g\160fv\025\006\134\031;\129\1808\208{\192\200\252\190\018H\027\000\195\232$\144\134\170\133\233\003\153\001\016@\224\160eA\019\004\185\242\1824\003\131\198\007\160\161\160\192\254\006ta<\003\195-\017\132\235\153\144\188\006\212\195\008\016@,0/1!\167\017 \000\250\134\225\188\000\003\003\1911P\014h\253\135c\136\232\255\015\165\145\245\002\004\016\200 \176\151\255\162%8X\234~y\022\017\022\140h\2420=@\195\152\000\002\136\005h\243\027\160\224?F$\135\253\007\197.\132f@r\000\136\248\207\008\202\029Pqh\1401\000\147\214O\128\000\003\000\012\171\152\0153Z\249%\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_kh.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002VIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\255\127&\006\006\006&\134\255\012\140@\026\134A\224?\0243\130\233\127\012\140\140\255\024>}\250\193pp\255\019\134S'\031|\000\008 \150\127\012\\\"'N~\226\182\182cbPP\226c`ffB3\000\217 \132\129\127\255\254c8w\246\023\003P/\144\207\197\002\016@,\127\024D\255\000\025\012\135\142\252f`a\251\201\192\202\138l\016\008\255\132\026\192\0147\004\132\127\255\254\007\214\243\135A\028\200\255\250\015 \128\024w00|\224a`\224\007i\231\144\147c`da\001k\255\0035\134C\152\025,\246\253\229O\176\017,0\163\254\252a\248\241\232\017\208\147@\003\024\024\190\003\004\016\203k \227\027T\001#P\130\153\017\226\021\001ue\134'7\2392\024%\2461\176\138\0111\\NO`\144USdxu\235>X\254\239\255\255`\003A\022~\004j\005\008 \166_@\198/\168\192_\144G\128\nX\249E\0244\206\\`\144\016\151g\224r\243a\224tpf\016\231\228d\2088{\137\129CZ\013\172\230/T\207/\136\231\025\001\002\136\133\017\028G\016\204\012s\246\151\247\012\\\172\172\012\198\015o20}\250\006v\190\249\251\247\144P\251\245\019\174\158\001\161\247?@\0001\129\130\144\003\1369Aa\015\196|@l\182z\011\003+0\\8X\152\024\216\132x\0258\128\152\013\200\006\137\153\174Z\198\192\015U\203\t\213\203\006\196\000\001\196\"\001$\004\161\002 \027yD\128!\239\164\200\192\176m9P\005\208\154\239\192\016d\002\218\201\014T\241\237+\003\183\147%\131\186\028\011\195\135G\127\192\174\255\001\196\172@\173\000\001\004\212\187\t\024\232|\252Ps\161\198\221\129F7\178'\254A1(9(A\213\193B\233\205O\128\000bafx\205\0022\151\017\236&v(\150\005\218\006\0115\228\004\249\023\200\003\025\246\029j (I\128\220\244\158\t \128\128\006}{\003\180\245\031#\195\031\160\174?@\221\191\129:Y\129\241\194\196\008\141\002\160\t\255\025!\174\249\015d\252a\132\186\228?(\225@\012\250\240\019 \192\000g5\180\176\026JJp\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ki.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\012IDATx\218\012\137\185\013\1280\016\192|<m\020\137\002:\198H\157EY%u\182\136R\129D\129\210\242\028W\217\178e\131\178\132\224\231\024\025\157CUQ\224\235\160_A\171\249\011\195\004\143\2168\173\027D\132\1875\142\148\216s\190~\001\196\194\206\192 \242\227\228In6;;\006\001%%\160*\1442\006\006\160^\006&5\006\006.\127\160\016\208\228\239\159\025\024~\029\003\178\133\024 \224\239_\134\015g\2072\000\2452\000\205`\001\008 \022\160\154? \241wG\14200\179\17710\178\1782\192\192\255\171@\003\164\128.\002*\250\247\028h0\003\002\252\255\253\027\172\007\004\254\001\017@\000\177\252\1310\024\222\029?\206\240\243\233S\006F\022\022\006\144\015@\166\127\019d``\243\004\186\002(\240k\015\144\253\146\129\001d\013\200\235\255\255\252a\248\250\232\017X\239o\160\139\000\002\136\229\015\212 \144m\223\128\018L@\191\131\020\190\231f`\208:\197\192\160\004u\193\131|\006\134k\154\012\012|o j\255\193\194\018b)#@\0001\241r\176\129m\255\001\197\127\129\nx\25433\200\229q1hq\252g\224\128b\013 \150+bf\224\253\207\001V\003S\015\210\203\205\202\204\008\016@\012\023o\222\252\240\242\248\197\255O\172\188\255?\179p\255\255\227\228\181\255_~\254\252\255\002\136\127\254\184\253\255\231O\031 v\005\178/\255\127\011\020{\015\196?.\223\252\255\210\214\255\255C3\231\255/\247\158\254\127\225\242\229\239\000\001\196\168\190\232\210\135\207*\146\252=:\236\012\188\192\192.x\200\204\192\243\228'8\214^1r2L\002&\001\014\160_\242\031\002c\240\207w\006N \251\1498;\195$e\160\138_\191\024\138n\254d`\186\252\240\007@\0001n=u\249\195m&~\254m\159A\145\200\202\016$\206\202`+\002\t\240\147\239\2541\172x\253\031\232\021\006\134`\017F\006;\017&\176\248\177\183\127\024\214\189\248\205\240\235\207o\006w\238\159\012J\191^\253\004\008 F\195\197\231?X\203\t\240\187Iq3\176\177\1772\028x\207\204p\240=$\202-\132\153\025<\132\129\154\129\186\247\190\253\199p\024\136A\t\214F\240?\131\179\224?\134\127@\131\246>\255\198p\224\246\203\159\000\001\196\184\241\228\197/W\254\243s\239\252\200\202\240\159\153\141\193U\140\149\193U\148\021\172y\199\155\127\012;\128.\002\025\234\012t\145\175(\0198)\236}\243\155a\251\203\223\012\255~\255bp\229\255\205\160\253\231\205o\128\000\000I\000\182\255\004S\206\243\236p\"\255\254\161\025\007\003\002\003\003\002\150\234\001\001@\210\002\255\249\253\000\001h\028\001\000\174\026\003\255\255\000\255\001\143\233\254\000?\207\000\255\253\001\254\001n\027\255\000\164\023\255\255\252\253\251\000\159\229\247\000[\216\235\249\002\012\000<nA!>\234\235\182\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_km.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002-IDATx\218b4ndx\176*\198\\\128\135\199\145\129\137\137\143\129\129\225?\003q\128\145\225\223\191O\012_\190\236gx\255\254\228\007\128\000bd\136c\248\194\240\143\129{]I)\131\155\1381\003##3Q\198\252\255\255\151\225\215\175\179\012\159>u\003\013c\248\n\016@,\012\002\012\127\128\0061t\175<\194p\214\154\131!B\159\153A\142\143\013\168\244\023\001\163~3\252\254}\004h1\200P\134\127\000\001\196\200\144\200\240\129A\152\129\255r\226U\134\154\147S\025._:\194 \175f\196\1762\164\011\143k \222\255\243\231\015\195\223\191\127\129^{\255\029 \128\152@\022?\201x\194P|\188\135a\235\227\153\012\162\202\138\012\007\206,d\016/\021gh8\190\024\024nL\024\152\153\153\025\232\018F0\013\226\131\002\012 \128\152\028\204K\025\152\25411\236Z?\159A\128Q\129\225\203\223\223\012\255\005\2553\252\023\249\2070mi1\131H\159\008\195d\142\151\012\028\028\028`\204\206\206\206\192\198\198\006\198\172\172\172`\195@\006\001\004\016\011\027\027/\0033\019\144\195\002\142\008\006\006f(\205\014\196\158@|\143\129\225\165\1646\003\235g$\175\001\241_(\155\t\130\255\003\004\016\211\174\019u\012LlL\012\170\014\198\012o\255>`\016\225\227f`\144\000\202j00\020,\003jhf`\152\250\025b\015\0123C1\212\016\176\189\000\001\196\192\144\192\240A\162U\246\255\199\199\159\254G\239\246\250/\177\149\225\191e6(\"pc\160k\254\255\004b\160\249\255_\003\241e\006\134\031\000\001\196\200P\000\1405F\006~\006Y\006\0066\1605\191\218\1832\240\188\240\002&.|\224\031(\206\160I\228\007\016\191\248\t\016@\160t\196\194 \td\175\204e\248\181\175\011\236\232/\240\016\192g\016\012C\"\013 \128X\024\174\234\188ahX\007\020a\005\186\231\021\208\203L@/3\253\135{\157\129\017\228\027$\246?FHp\255\251\015q\021\208\147\012o\127\002\004\024\000[\143\182\251\222\254\152\156\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_kn.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\129IDATx\218bdHbx`\174b.\224\168\238\200\192\199\193\199\240\255\223\127\0068@b\194\001\023\003\131\130$\003\003\235UF\134\243\231>1\236\219\191\159\225\228\201\147\031\000\002\136\133\129\133A\228\228\179\147\220v\154v\012J\018J\012\204\140\204\152\134\128\216,\012\012\162\"\012\012\140o\024\024\222_c`\248\241\239/\195\159\191gA\134\128T\176\000\004\016P\154\225\015\136u\228\222\017\0066\0226\006VfV\132! \154\137\129AD\156\129\129\255\031\003\195\245\021\012\012/\191@\164~\255\254\205p\228\200\017\152U\255\000\002\136\145!\133\225\003\003;\003?\003#\003\131\156\144\028\003\011\019\011\220!l\194\012\012\014\154\012\012\127\15130\000}\192\240\143A\128\225\196\137\029\012\153\153\217\012\167O\159dx\244\232\017\003\1799\003\195\018q\134\239\000\001\196\002\148\133\187\224\209\251G\012\140\255\129&r30x800p\156f`X\233\202\000\180\t\0024\181\013\025\152\152\152\024\142\156\249\201\240\242\197#\134\196p\006\134\230\191\012\012W\21500\002\004\016\011\216\016\144a@\253\012\192\224Q3\249\207 \0154\232M\006\003\195\233\135\168\225|\237\2029\1607E\024\164\172\024\024\238\18430\008\174b`\216\011\180\229-P7@\000\177\192\\\195)\195\192\224\014T\240\178\135\129a\207V\136\217\232\128\t\232\141\021R\012\012~O\024\024N\204b`\184\012\021\007\218\255\031 \128\152\024x\024\024\188\131\025\024<\191\003Mwd`8\190\149\139\225\192\137\203\012\026@o\192\129\000\003Ci\0200\128\229\024\024l\21430\028\003z\249\023(\012\129\152\021b\016\003@\000\177\248\15220\188K\002J>\134\23211\211c\1765\215a\144\1462c\184q\237<\131Y\024\003\195\014\014\1607\214\002-\001\198\216_HJ\000\135\004\0034T\128\0061\002\004\016\136\015\nK~\012\127\23200l5c`\240\186\202\192p\030\152T>CR\002<U\252\131\166\027\144\203\128I\235'@\000\177@-@\000^\006\134x`X\205\005z\249\249<`xA\133\025\209h\144a\127\017a\196\004\016@,\016\003\129\022020;\25130\205\248\207\192\200\182\131\225\255\186\159\012\140\191!\026\255\195\244\131\216\140Po\128\204\250\0075\236\019\208E\000\001\006\000\026\031\168\001\014\229\005p\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_kp.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\0025IDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\255\127&\006\006\006&\134\255\012\140@\026\134A\224?\0243\130\233\127\012\140\140\255\024>}\250\193pp\255\019\134S'\031|\000\008 \150\191\012\172\"\199O\190\231\182\182\147aPP\226a`ffF3\000\217 \132\129\127\255\254e8w\246\007\195\241\147\239\128|V\022\128\000b\249+\162\243\135\225\247\127\134CG\1900\176\176\2410\176\242\243\128]\004\209\0033\004j \227\127\184\193\191\12731\028\186\194\205\000\212\015T\247\229\031@\0001^\205\168\250\192\242\233\n?Oj4\003\203\147\015\012?/_`\224`Ve``g\192\2345\016\006\187\237\207?\134?\239?1\252\253\199\196\240\254\251\159\239\000\001\1968\159\129\225\131\225\186\157\252\028\nr\012\236<\220\012/B\252\024^]\190\200\192\204\128\027\128C\233\255\127`H\001\205\003\226\143\012\012?\000\002\136\133\2152\130\129\137Y\144\225\150\145&\131\128\166-\131\252\201C\012o\249\248\192\138\152\176\024\128\2346\006\134\191\016\195\024\001\002\136\133\241\239\031\006\014\t~\176 \011\144\205\205\198\006v\013\019\001\131\254B\217Pu\255\001\002\136\229\203\1695\012\223\150\1551\152\190\248\196\192\248\249\011\195\019U%\0066\160$!\175\129\188\244\027\202f\001b\128\000b1O\169a\224\250z\129\129\247\198^\006\182g\207\025\248\130\\\024\244\025\1291\193\137;\176A\225\243\231\223?\134_\127\2553\252\248\243\159\225\197\151\031\140\000\001\196\200 z\244\003\195_V~\134w\159\128\206\000\234\022\151\006\186\155\029K\2443@\163\031\146 \193n\250\015t\211\255\031@\238\155\159\000\001\196\194\252\2502\208e|@{9\128\006\252b`x\246\029\236\216\255`\007#\135\212?H\138\006{\n\132\127\002\241\015\160:\160A\012\239\153\000\002\136\133\153\225\247\027\160\224?F\006X\024\131\152\172@\199\255f\132\024\194\252\031\2264\144A\255\129\140?\140\016\131~\001\197\191C\013\250\250\019 \192\000\252\180\206\225\247\161\252\201\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_kr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\007IDATx\218b<z\244\232\003aaa\001>>~\006VV\022\006\016\248\243\231\031\003>\192\194\194\004\166\127\253\254\205\240\249\211'\134\183o\223~\000\008 \022NNN\017&&&n\014\014v\134\155\183\2383\240\242\2421(*H1\252\253\0115\140\137\017B\255\007\225\255\012\204\204L\012\247\031>g\248\249\227;P\1574\195\215/_\024\128f\176\000\004\016\208h\198?lll\012G\143\029g8\176\1277\195\203W\207\129.\250\195\240\247\255?0\254\253\247/\024\255\253\247\023\204\007\201=y\252\136a\255\190]\012\231/\\d\000\233\253\247\239\255?\128\000bb`d\004Y\196\160\160\160\192\192\196\194\195\160\163\165\206\240\245\199\015\134\031?\1272\\\143Kb8ah\200p\028\136o\249\2511|\003\138\129\228\012\013\180\025^\189\249\194\192\207/\000\214\251\247\223?\022\128\000b<\127\254\242\007^^\030~NN6`\024\1772\252\001z\137\025\024V\183\188C\025^\158:\192\192\001\244\145\002\016\191\004by\021\030\006\254\227\247\025~\255\254\195\192\002\244\"\200u\223\190\253\004\134\209\187\031\000\001\004t\017\019\003\0193\011\195\191\255\204@C\024\025\21688\024\190\177\1793\220;\185\159A\025h\157\003\016\023\252\239`p\254\255\132!\251\1824\003\007\2357\0066NN\176\218\191\255 z\129\193\195\008\016@L\140@\175\001\003\027\024\136\204`\023q\176\1790\252\007\250\187\138!\143A\021\168$\147!\157a\015C*\144\245\145a'\195B\0066\006f\006vvV\176Z\144\030\144^F&\166\255\000\001\196\002\012!p\196pr\176\000C\159\003\024p\255\024\228Y\128.\212)f\224\185\018\0124@\026\168\245\018\195_\134_\012\018\002\220\012,<b\012\127\127\254f\224\229\225`\000\006\023\195\159\223\191\024@f\000\004\016\019#\211\127\160\233\204\012_\191}ghi\159\012\180\141\029\232\208\127\012\207.\2032\200\202\128B\2322\208\144\015\012\130\220,\012\207\223[\002]\192\000VSR\222\196\240\226\229\027 \027\2325\198\127\140\000\001\004N%\160\180q\228\200Q\134%\139\1663L\152<\027h\016\200\223\127\024\030=6f\248\240\193\003\152$\\\025\222}\177\003\139\001\147#C{\215d\134\227G\2470\\\184p\158\001\0204 3\000\002\136\229\255\255\127,\191~\253b\240\244pc\216\179\255\020\195\175\191\028\192\196\248\151\225\251\247?\192\128dd\224\230\006af\134o?~3\252\003\154\195\193\001\228\243\13818\186\004\129\245|\254\252\025\148\130\152\000\002\136\241\228\201\147\015\184\184\184\132\216\216\216\153\129\169\027\024vL\140\191~\001S\216\255\255\224$\205\008\244\251\1270\251?\200\246\255\192\132\195\200\206\206\012\n\203\255_\190~c\248\245\243\007(\139\252\004\0080\000\017\230\027\012\209\028\191\171\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_kw.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\202IDATx\218bdPex`>\207\\\192Q\204\145\129\239\011\031\195\255\255\255\025\192\000Ja\000F(\197\200\200\240\233\215'\134\253O\2473\156|r\242\003@\000\1770\220f\0169i{\146\219n\147\029\131\146\173\018\003\243\023f\006\134\223\012\248\001\208\176\191\255\2552\156}{\150\225\228\231\147\012\012l\012,\000\001\196\002\020\254\003\146;\210~\132\129\237\022\027\003\171\031+\003\003'P\224-\030W\001\193\239\127\191\025\142\188:\002q\225?\134\127\000\001\004\162>\0001?HRNN\142\129\133\005hv\028\144c\011\196\239\192\1380\001\208\130?\255\2550<\250\252\008\2324 \255\011\195w\128\000B1\008\230w\016x\253\2505\196E\140\216]\244\239\223?0\254\243\231\015\195\219\183o\127\000\004\016\011\134e\208\192\230\224\224\000\187\230\247\175\191h!\253\031\172\230?\208\016\134\191\127\025\254\255\249\203\240\231\231?F\128\000b\193\021\006\172\172\172`_\253eaF\246\017\2046\006F\144!\192H\249\199\196\196\240\143\141\233?@\000\2254\008\020V \183\176\179`\247\214\223\191L\012L@\163\255\253\251\203\192\012\180\012 \128\176\026\212\n\196w\152\153\025^@\195\154\017\205s`\1512@R\201O ~\003\020\006\008 \020\1314\128x\027\016\139\002\241\005\168\024\019fZ\132\139\253\135b`\130a\000\008 \144\024\216\176\022 >\015\196\031\129\248\020\212&\144\141\191\160\2487\018\253\007\234\"X\202\000\026\192\004\016@,:@\151\205\002\138q300o\006\n\000m`\252\015\014N0\013\179\152\017\234\162\255\140\160\020\002\021\135y\241\019\208^\128\000\003\000\151-\159\207_\132#\175\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ky.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\254IDATx\218\000I\000\182\255\001\131K^\2241QO\016\216\255\021\000\250\242\002\000L\023\237\000\255\255\005\000\180\237\024\000\011\000\241\000<&\018\000\002\013\006\000\183\201\240\000\000\005\253\000\000\001\255\000\000\254\254\000\001\250\001\000\242\243\242\000\195\210\209\000\202\206\215\240\002\136Q.\160\247K\154\026;wV\188=\195\031iE\134?Wo\130\21210H\2020\008r\1793<bdb\184{\247\019\195\247W\031\129\006\001\197\255\003\013bfbp\213y\206p\251\222K\006S\255c\012\012\220_\190\002\004\016\203\188Gk\255\2529\242\137\225\198\235+\012\178j\178\012?\2542\129m\229defx* \201\192\245\238\007\131-\0157C\255O\017\1608#\003\195\223\127\012,\018<\012\015\143\156b\184x\251\025\208\016~\160\248\175\127\000\001\000I\000\182\255\004b\031_\000\131\136C\000-\250\243\000\215\243\247\000\012\197\180\000\255\250\246\000\nyz\000\025\220\215\000\183\251\242\000\165\219\250\000\220\198\206\000\000\004\253\000\000\251\255\000e\023\217\000$,\006\000\023\214\219\000\209\246\025\000\210\t\028\004\002\000I\000\182\255\004v-\011\000/\189\189\000@\163\212\000\219\255'\000\1935\241\000\001\246\245\00004\165\0005B\020\000\182Y\013\000\004\201\219\000\\\220\244\000\000\011\003\000\000\242\006\000DA\014\000\028\019\203\000\0019\t\000\178\2474\000\210\203\241\001\002\136\145Q\160\254\195\255\031\002\252\012\\\236\012\012\156@\1673\001\195\000\004\254\000\241s`\000KJ30\178\253b\248\255\239\0230\144\129\242\207\185\025L\178\249\024$\229\004\024\2542\127b8\181\227/\195\155]\215~\002\004\016\019#\015/\003\13100\020\185\129a\195\012\180\145\129\005\130Y\129XN\024(\246\157\225\255\223\191\016\177w\028\0127\250\2391\204\245fb\248\246\227'\003\247\031a\134\171\233;\025\012M\255\255\007\008 \022&\166/\012\255\254\255\006\006\024\003*f\128\186\012\230\194\255@AN\006\134\229O\2551H\011\158g\136\208Qb\248\247\229\030\195\242\023\"\012\223~\255`\000\008 Ff\185\226\015\127\255\179\242\13153\001\t`t\131M\250\0157\017\t\000\013}\000\242\254_\006\030\165\159\012_\190\130\188\015\012\018\254o?\001\002\136\229\239\191o@\t\160\215\024A^\002y\013\200\254\207\012e3#\025\006r\025\208\139\n\127\193\236/?\025!\177(\251\025\024v?\024\000\002\008\168\251'\0163A\013`\003b\160\251\025\129\182\252\135\134\021X\014\004\254Ab\128\017\136\255\255\004\n\127\007\242\127\000\217 \131\1271\001\004\016\011\144\241\006\136\2551\252\005:\131\017\232\175\255\160T\007\182\158\017\018L\160\164\252\031\226,FF\1368\024\001\217\255\129\1343\002\195\247\223\207\159\000\001\006\000\007\030\001\030\163\159\025\200\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_kz.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\003IDATx\218bd\200m{\144e\247E\192IQ\145\225\214{S\134\255\140\255\024\024\129\144\129\129\137\001\200\001\210 \012\002\255\129L f\248\007\198\140L\127\025>\253\248\206p\224\222\029\134\147\247o\127\000\008 \022\006\022N\145\207?\015r\203q\2413\252a\225c`f\129\025\004\193\255\255C\012b\004\027\002\195\255\024\254\254\255\203p\246\217W\134\147\175^00\176\178\178\000\004\016\011\003\243\191?\215>\2011\236}\242\130\225\011\195k\160\216_\176A\255A.\250\199\0021\016d\024\208\165\012L\127\128\188\127`\195~\255\251\195p\244\241\019\16083P\029\235?\128\000ba\248\207\201 \197\249\133\225\255\151\235\012\139\239\1531\176\176\254\000\187\229\255?v\006a\158W\012\229\134[\025\190\254fb\152r\197\139\225\237\023\017\160\151~\129]\247\231\223_\134G\239\191\002\021r00\252ef\001\008 \022\134\127\220\012\247\191\1701\136p\254ax\244\129\145\129\137\237?\208\016V\160Q?\025f:\1813\024J\191\002{M\144\227*\131\255\250v\160\171\152\128\232\015\208\203@\1510\n\000]\003\244\234\191\239\140\000\001\196\194\240\155\143A\154\239=\131\018\223[\006\134?\226\012\255Y~0\200\137\188ex\253\147\151AE\2243\003\007\219\127\176A\138|_\024\004\004\217\025x\152\2550<y'\006t\213_\160k\128r\192\176b\248\199\196\008\016@L\2240`\004\186\132\025H33\003]\195\197`)u\140!H\229\016C\240\193\014`\152\001\195\018hy\204\145V\134\008\245]\012\198R\167\129\250\129\222ab\134`F\176\254\255\000\001\196\196\192\246\153\225\197W\001\134\007\223\197\024\0248>00p\191dX\251\216\134A\150\2431\195\139\223\204\012*\203&1H\173\152\206p\2357#\003\235\255\031\012;\158\026\001\213\000\189\203\nT\203\002\196\204\159\128\006~c\000\008 \022\006\198o\012J\188w\02548\159\003%\191\000%\1270\252\254\205\2020\237\174\011\003\031\203/\006\013\193\135\012\028,\127\025\020X>2,zb\206\240\003\024\240L,@u\255\160^c\006\210\204\223\024\001\002\008\152\142\1903<\249\193\203p\255\023/P\242\0318\226A\137\237#\208\149\031\1291\199\248\143\141A\153\255\005\195\138\015:\012\031>\243\003}\243\003\154\150\254\000\189\004\195\223\024\000\002\136\133\225\015\019\139\014\255}\006{\254\007\012S~s\001]\004J:l\012L\255A1\199\204\240\232\157\018\195\163\183\202\2244\196\196\244\027\024\213L\224\024\005\187\134\225/\0043\253f\002\008 \022\134\191_\223<x-\244o\215\015\160\174\175_\153\024~\001S\031\227\223\255\012`\199\253c`b\004\198/8y\131\018$(\174\255B\216`5@\215\000\195\013\168\239'@\128\001\0003w\020/\246\133\246A\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_la.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\020IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\147\129A\228\247\201\147\220\236vv\012\252JJ\012\140\204\204`\013\248\012\002\203\255\253\203\240\241\236Y\006\160^\006\160\025,\000\001\196\"\204\192\240\135\007$s\228\008\195\12766\006\006VV\184\134\159@\252\022\136\255\0011P\029H\003\220\130\255\191\127\131\245\136\002\217\159\129J\000\002\008\168~\203\007\006\006\014~\144V99\014\006\022\022\152\227\127\1295\004%\203\001\205fdX9\227\017\212\02460\253\231\207\127\134G\143~@\197\190|\007\008 Ff\134\181@\1318\249a\142fd\252\207\240\023\204\250\199\240\250\181\005\138\183DEO\129i\144\231\255\255\135{\018\136?\253\000\008 &&\006\014\006&\006.\160$/\016\24330\253\023\002*\226g\136KUc\224\224`\135jc\006\179\203\170\213\129r|`5 \181 = \189L\012\236\140\000\001\196\130\136\007& f\129\210\140\012LL\172@/\1772\252\253\011\177\153\149\149\133\129\149\133\013\170\134\005\026r\127`z\255\003\004\016\208k\235\129^\227\225gB2\2287X\235o\160!\014(^cf>\n1\020\238\165\127@\0082\236\253\015\128\000b\249\011\142\011N`\184\192lc\134\226_@\141\023\024\210\234T\024X\152Y\024\166\213\223\000\138q\0031;\200\n \253\023\234\"P\164|g\004\008 \198}\012\012\031\128!\205\207\014\181\137\025\201\163\031\129\2482\2125\154@,\002\213\254\031J\255\134&\145\215@\n \128X\128\233\132\2297R\2320A\021\194\176,\212\160O\144\244\002\015\209\127H\161\244\030\168\013 \128X\19010\188\249\011IP\204\176@\250\015\138]\008\013\011\012Fh\"\005E:#4\226\255\255\131\186\012h\201O\128\000\003\000?\134\148\208\228\206\238S\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_lb.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002OIDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\141\129A\228\199\201\147\220\172vv\012\002JJ\012\140\204\204(\134\252G2\000\217\176\255\127\2552|8{\150\001\168\151\001h\006\011@\000\177\252e`\248\243\015(\241\246\200\017\006f66\006FVV\020\023\177A\233_h.\250\255\2517X\015H\239\031\006\134\127\000\001\196x\233\218\181\015<<<\252L@\151\176\178\176\192\157\013\148d`\007\226\127P\204\0125\140\005d\008\212\251\191\255\252a\248\007t\217\251\247\239\191\003\004\016\211\191\127\255\128\018\016[@\236\127@\246?\160\000'\003\019\195\203?_\024\148\250\181\025\012g\2162\252gb\002\139\129\228\192j\128j\193.\003\178\255\254\253\203\008\016@L\255\255020\254cd`\250\207\012\180\149\133\129\149\137\149\129\131\153\157\129\131\139\131\161l\231l\134o\239^3\252\249\250\157!zC3X\012$\007R\003R\011\210\003\210\251\2557\003#@\0001\129\188\193\004\180\141\025\2285`\248\12807PC\193\254\205\012\219\247\183\131\253\242\246\215#\134\189\199&2\204\191t\142\129\011(\007S\007\210\003\210\203\200\196\244\031 \128\152\152X\025\129\129\0124\132\003\232\026\014V0\254\207\194\204\208\235\018\204\240w\254_\006_\231l\006\160\143\024\158\207\248\202\016kh\206\192\196\202\012W\007\210\003\210\0112\003 \128\024\175\221\186\245APP\144\159\131\003h\0190\214X@\001\014\180\133\t\026\192\231\025\2223\220\254\252\144!\156\215\000\030s\192\000\002\007\244\239_\191\024~\252\248\193\240\226\197\139\159\000\001\196r^M\141\129\031(\199\n\141\017&\164\244\003\nL\144\156&\208\200\131\012\127\129\016!\015\141v\134\223@\252\006\136\001\002\008\232\t\006\022F\168\198\127h)\250?T\0170^\224\233\231/\146\028\2042\160\003\152\000\002\136\229'D-0\236\193>\001Y\200\248\031\018\171\140\255Q\029\007\"\2543\130\146\025T\252\031\212\224O\012\012?\001\002\012\000\233\130\196+\232\165j\187\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_lc.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\131IDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\255\127&\006\006\006&\134\255\012\140@\026\134A\224?\0243\130\233\127\012\140\140\255\024>}\250\193pp\255\019\134S'\031|\000\008 \022\006\006v\145\211'?p\219\218\2012(*\2412033!\025\000\209\198\0007\238?\028\255\253\251\143\225\252\217\159\012@\189@>;\011@\000\001\013b\249\003r\193\209#\175\024\216\216\152\024XXY\224\218\254\002\177\154*'\003++#\195\149k\223\024\152\025\024\224\174\251\243\251\015X\015H/\003\003\243?\128\000\002\234\002z\135\129\141\225\228\241O\012\207\158\254a`aA\216\253\155\129\143!4\226*\003\027\235/\134\165\139\205\025X\025\222\192=\250\231\207\127\134\199\143\190\001\213\177\131\172d\001\008 F6\134\213@\183q\242\195\\\193\200\248\031\238\026eY\029\006\022~'\134\159?\1590p\179\220a\184r\253\018\003\011\204M\255\145\195\238\211\015\128\000b\250\207\192\005d\242\0009@\179\024\004\129\nD\192\248\207\127Q\006\021C\006\134[\183\2391\220\185\251\139AV\227'\195\223\255\226py\144Z\144\030\144\222\255\012\156\140\000\001\196\132\008X\144_Y\192\248?\016\1792\2000\\\184x\138\225\216\t\006\134\023\207\025\024\206\159\217\002\180R\022(\199\012W\007\209\003\214\251\031 \128\152\024\025\190\003\153?\024 \244W \254\194\240\007H\179\179\2422\164\166'0\024\23320\136\n30\020\150\0222pp\179\001\195\237\027X\013D-B/@\000\001\141\252\t4\241;\146\224/\160\173|\012\145\241\151\024\234+\19010\001U\128pq\014\003CJ\214Q\160Z\t\006\144\030\152\001\012`\252\147\017 \128\128\129=\255\003#\003\023?#0\230\024\128\030\250\003\164\2550(\003\195A\013\026\228\168\128\131\241&P\254\017P\229Op\188\254\007[\252\241'@\000\001=\250\155\005\148R!\128\025\232kV\006\001\174\135\012\150f\179\024^\191\144\006\218\nK\014\255\025\132D\1591\240\t<b\248\248\001\020>\127\192\006A\244\254a\002\008 \160\139&?``\224\017bd`\007\134\"\007\208\019l\140\127\025X\255\255a\224bd\000\007,8=0B\162\249\223\127\022\134/\140\204`C~\001\005@\233\232\007\144\253\246'@\128\001\000\t\167\205\172\251\241L\207\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_li.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\208IDATx\218bdc\152\240\192\204\\A\192\222Q\150\129\151\143\131\225\255\127&\006\006\006F4\012\002\255\193\152\017L\255c`d\252\199\240\233\211\015\134\131\251\1590\156:\249\224\003@\000\17700\176\139\028;\249\157\219\210N\136\193\208\2243\195\167\175\002@\133\172\012L\012\191\145\012a@1\012\132\255\254\253\199p\254\236O\134\211'?\000\249\236,\000\001\196\242\151\129\227\015;\195/\006{\195(\006v\014g\006\005\030\022\134\007O\197\024.\223\244\002\026\246\021h\020#\154!\016\246\159\223\127\024\142\030y\005d\131|\192\252\015 \128X\2541p1\136\138\189b0\1808\206\240\244\241[\0069\245?\012\187w\0252,Zf\014t\215K\168W\144]\004\001\127\254\252gx\252\232\027P\132\029\200\251\203\002\016@\140\204\012\235>\252e\016\227\231`\253\194`b~\138AT\250\031\195\134U.@\003\190103\252a\192\005\254\255g\132\026\0132\252\211\015\128\000\002\242\014\000=\201\203\207\192\192\003\020\224\0059\019\136?\002\241o\168\179q\129\127P\012R\247\246'@\0001\238``\248\000\212\206\015r \027\016\179@\165\241\001\144\027\254B\141\248\005\196\239\024\024~\000\004\016\203[(\135\029j\008\011R\\a\1393\024\253\007\138\127B\012b\000\008 \022\006\164\212\194\132D\163\006-\0040!y\138\t5\1491\002\004\016\011\0194T\152\208\146\0306\131\144\001\204B\152^\128\000\002\025\004v\213_4\239\160\027\198\136E\030\166\007h\024\019@\000\177\252``x\003\020\252\199\136\228\176\255\160\216\133\2080=\140PC@\145\206\0085\236\255?\168a\159\128A\005\016`\000\012\241\141\130\1521E<\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_lk.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\023IDATx\218b<s\146\225\193o^s\001a~G\006Af>\006\134\127\255\025\254\17900|\250\200\196\192\252\151\129\129\153\155\129\129\225?\003\n`\004\019\140\012\127\127~bx~\231\000\195_\145\147\031\000\002\136\229\005\003\131\136\207\166\147\220\165\182v\012\245BJ\012\140\255\153\025\024\132\025\024^\253df\248\253\152\129\225\251\151\255\012\204P\179\024\145\012\250\255\247\015\195\253\179\231\024\030\2559\203\160l\192\196\002\016\128\1931\198\001\016\004\002X\229\196\136\137\015\240\005\190\215\191\184\176\243\005WFW]\\@Nom\218\164}\016^fHW\162\249\193\020\015\011\228]\152\194G}\160Y\234\138\157J\199h\204\005(g\229>\0189*\235\166\250\011 \022&F\136\021\199\223\028g\248\241\249)\003\200_\140\n\140\012\167\022\1770\240\253\251\199\192\200\197\196 \232\207\196\160\238\013d\139\255c\184\177\157\141\225\207\007\006\134\031?~1\188\216s\143\225\243_&\006F\001F\022\128\000b\249\015r\243?\168\147\191>b`\250\0034\021h\250\187\023\172\012\191\190\254c\016\246cd\184\183\145\153\129\143\233\031\003\143\231?\134\243S\217\025D\185\2551\188\255\243\159\129\149\019\024N\191\128\218\25500\002\004\016\019\003\019\212\227@\154\013h\006\027\243\127\006v\246\255\012_\25532|\007Z\240\003\232\162\219\231\024\025\184\228\2551((\252c\176s\249\197\016\218\254\139\1934\234\031\195\219\143\204\012\191\128\222\001\186\149\017 \128X\024a\161\0074\136\021\024\170\192```d\131\208L@\215\254z\199\200\224\190\242?\131s\192\031\134\031\191\025\024d\218\025\024~\255a`\0084\253\195\176\165\144\005\162\149\145\225?@\00011\130X\204\016\204\012\012gf`\212\179\0001\031\208\020^\160Ab\028\255\024L\\\129^:\204\202pa\031+C\167\011+\19576f\134\227\171\152\024x\128n\225\000\198'\019\227\127\006\128\000b\001\217\204\192\0021\008d(\019\019\004\179\252\252\199\192\014\244\230\031v\006\134EB\012\012j\241\192P\248\0014\249\240_\134\211\171\153\024><ff\016g\248\205\240\028\232&F\160\195\000\002\136\t\1588\024\160\137\005\132\129^\248\0114\141Y\129\137\225\211\250\127\012\188\172\255\025\190\243\255gx\189\018\024\224@C\223^\254\207\240q\247_\006V!`\216\129\226\234\195\127\006\128\000b\249\250\007\232\158\143\144p\250\007\140\001P,\252\191\201\192 ]\195\204\240v\238\127\134\135_\255\130\021\223\159\244\159\129\013\168\136\229\029\003\195\205vPj\251\015\246\136f\005\019\195\031n\006&\128\000b<\127\134\225\193#F\006!.\014\006f5`\186c\002E\129\000\227\255;\215\216\024\153\129^\225\017\007&b\144\024\208\187\140\255\024\254\255c\252\207\008\n\130\255\127\025\254\255\250\206\192\240\225\017\208@\165\255?\001\002\012\000>V\247j\233\1714\231\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_lr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002}IDATx\218bdc\152\240\192\216\\^\192\193Q\142\129\151\143\157\225\255\127^\006\005\134S\0126\012\183\024\22200002`\002\144\024###\195\159O\159\024^\238\223\207\240\236\228\201\015\000\001\196\200\2014\227\203\247\127\255\185w\238tc\248\252\145\149\225?\227?\006eMA\006uEF\134\223\191\254c1\230?\156\254\254\237;\195\235W/\025\190~\249\242\021 \128X\190\255c\253\179p\190\014\131\129\001\007\003\007\007\007\195\226\013\127\024\190\174\217\204 \203\240\154\225\131\000\011\022\215@\012\250\255\2317\195\187\227\199\024>\156;\207\240\249?\195?\128\000\002\186r\254\007\019=1\254\141\219u\025\254\252\254\199\224\232t\156!:L\134!\183\136\153\225\221\185\239X]\243\255?\008\255c\248\245\245;\195\191\127\012\012\239>}\253\014\016@, ;\030\220cf\144\150\191\206 \201\205\202\240\226\147\016\195\161\206\141\012\249\231/2\188\253\193\193\192\192\196\136f\020\132\255\239/\016\003\217\127\25532\188\255\249\155\017 \128Xr\230\1541|\253%\200\240\159\137\013\232\"f\006\030y&\006\187\151r\012\127\159^a\224\253\015\178\135\017\211s@'\253\005\186\234\239\191\255\012\191\255\254a\224\248\252\137\017 \128Xr//g\016\224\228``gea`efd`~\253\131\225\029\179*\195\027&>\006\214\255\127\177\196\023\196\131\140@\247\128\000\200EL@!\128\000b\185u\250<\003?;\011\003\027\144\199\006T\199\012\244\n#\195E\006\144\244?,\145\255\031\234\189\191@s~\001\013\249\005t\213\207\239?\025\000\002\136E(+\149A\144\159\155\129\157\141\149\129\141\133\153\129\153\153\137\129\137\137\025\195\021\136h\007\134\0130\128\254\002M\250\245\231/\195\207_\191\025\254\190y\207\008\016@,ojK\024\254\000\189\196\006\012\011\022F\160! \252\159\017\026\168\140\024\238\001\201\252c\004b`\172\253\001\197\0280\188\222\252\249\199\000\016@,R\203\022\179\008\n\0080\176\177\1773\176\176\178\001\189\198\194\192\008v\017v\131@\248?\200E\255\254\000#\231\023\195\175_?\025X_\191f\002\008 \150\203\022\022o8\024\192!\199\012T\198\004\210\253\031\026\158\255\025\144\194\022B\128\217P\227A\201\t\172\241#\003\195O\128\000\003\000\2155\235\003\177\023&\131\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ls.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\214\216\212OX2\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\165IDATx\218T\146\191K\\A\016\199\191\179\187\239\201\225y\022\158e\nQ{\149`q\133\144 B\192\202\216\136\133\255\135 \249S\130\133\141\127\128\1648\139p\225\236\030()\174\008X\0086zE\206\211\147\219\183;\206\155\189\028f\024\134\247f\2313?v\150\128\147\141\141\165\237\237\149\185\185\026\179\001,@\128Q+\194@T\027\136\226\211\211\168\221\254S\020\183\014pE\241\176\179\179\186\188\2200f\202\224\029\134D\198\024nn^%X\016\167\199\177\211\185\013\161\1806a\244\014N\165*\013!t\187w\234!jm\157\229YN\224\230B\205X\210\252\149\029\014\158\197\214\027\179Z\183\170\025\003?\246Gr:\246c\234\245z\141\134\1807\017\162\212\027~\\\254z\025\141\247v?\167_fir\"\131\193\192I\156DgYfU\166\216\213\181\127\029\135\131\1753S,\168x\239%f\130\t\144\200\132\021\191\239\207\191\031\135\024\142\246?n\174}H\152\132\201\135\144\255aI\170\179\128\246\197\207\214\230'k]\231\178\219Z?\148\165Ho\213x1\166A\232\203\233\183\218|\2302\024\201`\197e\024<\028\014\251\015r\209\180\176\216\172\215\235\004\146\2098\196Xr\2331\250\235\t'\171\152%8\13050\186e\233\1472H&\017\137bQ\221\129\020\012\017%\227\153\029\242\028y\006\217\152q \167\175\196V\023^\254[\183NT\169)U\003\188w\240\140\023T\165\200\234\138\181 \167]\167\215\018\213\201\154N\n\n\198o\002\012\000\029\133\196\016\232\131T\244\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_lt.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001yIDATx\218b<s\134\225\129\160\160\185\000\015\143#\003\019\019\031\003\003\195\127\006\226\000#\195\191\127\159\024\190|\217\207\240\254\253\201\015\000\001\196\194\193\193 \194\204|\146\155\149\213\142\129\141M\137\129\145\145\153(c\254\255\255\203\240\235\215Y\006\160^\006\160\025,\000\001\196\194\200\200\240\007\136\025~\255>\002\020d\003*a%\210E\191\193z@z\255\255g\248\007\016@ \131\192\156?\127\1423\252\248\241\020\168\128\005\204\199\239\026\016\249\007\168\231\017X\237\191\127\012,\000\001\196\162\181\013(\198\001\214\0154\017$\0012\153\001\130\177\154\002\193\255A\166\253\007\155\199\192\240\133\129\017 \128X\192\134pC\013b\002\2021\254G\024\194\136\197\016$\195\024\254A\013\250\205\192\008\016@,`\003X\160A\0035\140(\131`\1340\128\245\254\007\008 \022\006Q \131\031\136\217\160\0061C\013\195\007@\134\252\133\026\244\011\226\008\128\000b\220\199\192\240A\016h\020\007\212Q\164\152\243\027\136\127\000\241K\006\134\159\000\001\196\242\006*\192\134\2283&\164`@M\130\016\252\015\201g \007\189\005b\128\000b\001*f\249\011\021\248\139\020,\255\209h\244`\251\015U\255\023\194e\002\008 \022\160\211\222\000\005\2551\"|\197\248\031\146T\024\255#\2440B\013\249\015Mv`q\152\023?\001\189\006\016`\000K\220p\247_\131\226\178\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_lu.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\013IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\25410\252\001\137\191=r\132\129\153\141\141\129\145\149\021\167!\200\134\253\255\253\027\172\007l&\003\195?\128\000b\001\153\002\194o\143\031g\248\241\244)\003\019\011\011D!>C\128\248\223\159?\012_\031=\002\025\194\240\019\232\"\128\000b1\190~\157\129\151\151\151\129\021h\000\019\019\019\003#\008\019p\0178\012\255\253c\248\007\196\191\129\006\190}\251\150\017 \128X\254\253\251\015\177\135\145\025h\00830\136\152\192\001\t\018cDs\215\127\168{@\017\242\151\001\024(\255\255\130=\246\247\239?F\128\000ba\005\178\217\128bl@=\172\140L\012\204 \003\025\025\t\184\008h\016P\201o\160A\140 \189\255\024\255\003\004\016\011+\199\127\0066N\006\006vv&\00666&\176\139\152\152\240\027\004\242\197\223\191\255\025\152~1\001c\025\232\000\160\025\000\001\196\162\182\029\024T\220@\204\014\212\204\002t\0303\011\208WL\232\145\141\020:\224\000\002\250\008\024E\192\240a\248\t\212\251\225'#@\000\177\008\000Mc\226\006\250\158\245?(\152\024\2543\131S\027\\\223\127\168a\224\240B\018g\252\011\n\"\160'Y\128\174\251\241\159\001 \128XX\025\254\1770\002\003\015\232^\006\006& \013\146\004y\028\154\134A\001\203\0007\027\146\230\193\234az\12843\227\127&\128\000,\1451\014\000 \012\002\165\214\255\127\212A\019\007u(\162q%p\t\224\220\179r\244HVr\192\1332\192\156\012\226=\007\197H|\216%H\208\200I\134\216\170\167j\163\173#\192\000\024\139\198\179)\157\159g\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_lv.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\013IDATx\218b\\\172\160\251@\210\208P@\212\194\140\129\133\151\143\225\255?\006\134\255\012L\012\016\192\008d\195X \240\031\202\254\199\192\008T\242\231\243'\134\215'N1<?\127\254\003@\000\177p02\137\252\184t\149\155\213\220\152\129_N\146\129\129\137\025I\027#\0032@\024\011\164\255\253e\248x\229=\003P/\003\208\012\022\128\000b\249\207\192\242\135\017\168\228\195\153\011\012\204\172\172\012\140,,P\131P\013C1\004\136\255\255\249\003\214\195\008v\031\203?\128\000b\249\011d\252\005J\189?\127\137\225\231\171W@\0071#\212c\243\026\212\145\255\254\254e\248\246\244\005\003H\255/\160k\000\002\136\229\207\147\151@\014\019X\203\215G\175\025\152\024\145\189\130\n\254#\177\255\253\135\240A\006\253a\248\203\008\016@,\166\151w3\240\243\2433\176\177\17710\003]\195\196\0044\148\145\017\140\177\129\255\255\255\131\241\191\127\255\024\254\002]\245\235\215/\134W\175^1\002\004\016\011H\003H3\200\016V`\024\129h\\\134 \027\0062\004\004@z\129\248?@\000\177\156\209qe\224\003:\143\029\168\151\005H\179\128\131\023=\128\025P\002\030\232&\160w@^\250\207\240\019\168\228-0\184\001\002\136\133UV\156\129\141\tj\016\144f\006\185\144@`\003\147\026\0033\208U\204\255@\222d``\253\251\151\017 \128X@.`\001i\006\027\000\nt\160\215\2543B\019%#R\144C\162\157\017\152b\025\025A\178\192(b\252\007\246\001\008\003\004\0160\209\252\001\166%V\160-L\012\127\254\003\003\251?P\136\145\025h\019\019\146a0\143\129\012\249\007N\140 W\253\003{\242\031(\0011\001\004\016\203\207\255\255\222|\006F\001\227\127`\146\0069\234?8\206\254\003\163\021\232,FH\2162\1288\224\152\252\015\"\193\1343\130\194\252\031(\234\025>\253\251\243\019 \192\000\253\223\191\215\012&[\173\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ly.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\249IDATx\218bT\206\148}\160\175l,`\161j\197\192\195\193\203\240\239\031#\195\127\006 \248\207\200\000\166\024 4T\020\200\128\13601\253g\248\242\2273\195\137\219\199\024.\222=\251\001 \128X\024Y\025E\174\190\184\200m\161a\206 /&\011T\192\204\240\031j\008T'\148\254\143\016\001\026\246\239\223_\134\171O/3\000\2452\000\205`\001\008 \150\255\012\204\127@J\206\222?\195\192\202\194\202\192\204\196\130\208\140b \19650C\255\254\251\003\214\003\018\249\255\159\249\031@\000\177\252\251\203\196\192\244\159\137\225\252\163\011\012/?\189\002\026\196\140p\004\014\023\129\152\127\129.z\246\225\025\208\016\022\134\191\191\255\178\000\004\016\203\191\255\172\012\127\129\138A\150=\249\240\006\2325\168J4\199 \027\002\146\252\247\015\228\01860\247\223\127&F\128\000b\249\251\143\133\129\241\0313\003#\019#\216\233\127\129\222a\132i`\252\143f\008#\146\219\254\131\249\255\255\129\189\201\008\016@,\1400\215\003]\0021\140\017\132P}\133f\016$`\160\006B\028\255\031 \128X\152Y\25400\179\252c`b\006\026\000\n\030`\180\130\013\194\227\181\255 \012J&\127\129\222\002\186\250?\203_\006\128\000bab\004\026\196\008\012pf\160\001 \195\192\174\"\028\216\255A\006\128R\025\208\192\127\140\127\025\001\002\136\133\137\025\232\026\166\127@W\128\188\196\004\213\199\008I\136\255\025Q\013\002'F(\013\n?\198\127\224\132\t\194\000\001\004\012\163\191@\204\012\0138&P\012\0005A\019\229\127F\212\148\0133\000\024\207L\255\193\209\006\177\146\241/\019@\000\018\201 \005\000\016\008\129\172\244\255\151v\143(4\215n^\028\006q\232h\222\222\2224\171\194\1612\003\1277,S\131C\028\171\237QR\152\254\001\023\247\019`\000]r\202'\221s\016p\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ma.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\018IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\255\2094\255Gb\131\193\223\191\012\031\206\158e\000\234e\000\154\193\002\016@,@\005\127@\226\239\142\028a`fcc`deEq\193_\160\206\127@\154\021\205\137\255\127\255\006\235\001\001\160\252?\128\000b\249\007a0\188;~\156\225\231\211\167\012\140,,`[A\198i\002q\157!\003\195W\014\006\134\222\227\012\0127\129\252\159P\215\253\255\243\135\225\235\163G`\189\191\129.\002\008 \150\191P\131\152\128\248\027P\130\025\232\247?@\147.J10|\127\202\192pT\029(\014t\243\169\007\012\012g\165\025\024\180\128b\156 o@\195\018\164\023h\006#@\000\193]\132p\243\127\0061 \181S\135\129\161\195\137\129\193\2436\208u\191\024\024\194C\025\024\212\128\180\203\019\160\235\145\188\t3\008 \128\152\024\161\174\001af(\254\012Tx`\007\003C\2121\006\134\015@?\190\003z\205\251\026\003\195\137\245\012\012\159\254#\2121!\240\127\128\000bb\134\134\007\008\003C\159\129\003\138_\002\241Q3\006\134_\\@[\185\025\024\142\003\195\n\232+\006.\168<;\146>\144\025\000\001\004\012Z`H\161\011\002\241]\1605v\023\024\024\186\174A4\231j30\220\001J\242\252E\164%\152\215\128\194\140\000\001\196\184\028\232z~\006\006~6\168\001LH\138x\129\248\0114\150@\236\207\176`\132\026\000J7\192`cx\003\140L\128\000ba\130\232\007\005\024J\130\251\143\020\213\012P6\186<L\015\208EL\000\001\196\242\003h P\240\031#\"\252\024\255\131\227\014L\195\2440B\013\249\207\008\242\006T\028\026c\012\159\128\246\000\004\024\000\153\022\159eD\180VN\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mc.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\192IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\128\026\254\128\196\223\0299\194\192\204\198\198\192\200\202\n\215\244\031\151! \185\223\191\193z@\224\031\016\001\004\016\203?\008\131\225\221\241\227\012?\159>e`da\129k\192e\016\216\235\127\2540|}\244\008\172\2477\208E\000\001\196\002r\206_\168\"\144\004\019\208\239\140\012\248\001\200\160\127\192\176\252\007\213\0114\131\017 \128\192\006\253\129\026\004\182\t\168\128\137\128A\255\144\240\031\136\139\024\001\002\136\197\234\230M\006\001\001\001\0066vv\006V`\2480\003\003\027\020#x]\004\180\236/0\176\127\003\195\233\215\207\159\012\175^\189\250\015\016@,\255\254\001\163\027\232\020F \001\139Z&\002\006\253\131\169\253\015\209\0112\003 \128X\024\128\129\006\194\224@\254\243\023\232-F\006\166\255\132\252\246\143\225\031P-\227\223\127`\189\192\024d\004\008 \022\136+`I\240?F\160\226\138~\152zF\006\136\235\000\002\136\229\255\255\127, ?\255\003\217\002t\226\031\160\223\153\008$\237\127\255\254\130\213\130\244\128\244\002C\130\t \000\007\228\142\002\000\012\131\208\154\164\247\191h!c\232\135\182&\224\224\160\"\207\"b\016\238U\235*BA\160j\143\028\234\000 \204\166\207\002\018\nj\136\137sv\219k6w\159_\128\001\000\235\183\203\207\134D\144\020\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_md.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\128IDATx\218b\020\153\176\255\129\177\140\168\128\1814\031\003/\027\011\195\223\127L\012?\25503\164\169\204b@\007\255\129\248\tP\152\tH3122\252\254\244\137\225\229\254\253\012/N\158\252\000\016@,\140l\028\"\231?\255\227\182daeP\016\228d`\004*\251\253\151\153\129\139K\013\171A\194j\016\131\024\254\254e\248p\246,\195\143\147'\025\216\025\024X\000\002\136\229?\003\211\031F&&\134S\175\1913\17613\001mba\248\241\231?\131\155\216U\136f\160n\160\229p\240\229*\196\160\255\191\1273\188;r\004,\246\015\136\000\002\008d\016\195?\160wN\191\249\197\240\252;H\023+\195\199\223\028\012Y\178\139\024\128\194\012\159_33\240\138\254\007\186\230\031\003\200\188g\139\160\174\251\243\135\225\235\163G C\024~\003]\004\016\128\2271H\001\016\006`X\166\243\005\250(\255\237C\006\222\005\017T\020\183\174\238\030\2104\022\185\130h\176g\189\002\197\244\238\194\238Ll\011<\199\192mZ\147\024\231\204\155\196\215J\213\174\254\162\236\249*\128X@\006\252\003\186\130\017\136\025\128\006\252cd\003*bg\224\224\251\207\192w\132\141\225\209.v\006!\150\207\012\204\190\220\012\172\001\223\024\254\128\252\138\004`\006\001\004\016\0118\000\024\129~`b\0069\016l \019;\027\195\139\135\012\012k\133\181\024\174\135\0261<\190\195\195`\194\247\140\161\148u\013\003+4\208\255A\013b\130\224\255\000\001\196\194\200\008\012%\166\255\012\1920\006\026\004\149aeaP\148g`\208\212\184\196`\204\247\139\225\141\001+\131\169\236%\006n\022F\006Nph\129]\001\n\027\176\161@'0\000\004\016\011\019\0190\016\129\152\137\025h\024\016\255g\002\134\211W`\024\t10x'\000\197o_\003\138\001]\160\004\137=F$\251`^\003\026\196\008\016@\016\023\129\012a\252\143\234q&\168bU\136ff\168\237 \204\008\197LPq\016\013\016@,\140\255\255\1770\252\003\186\228/P7\208\176\255\255\128\244\159\191\160\244\1345A\254Fr\013L\t\2080&\128\000b\249\255\235\199\155\255_>\002\253\192\202\252\143\145\133\233\239\127VF\134\031_\255\191|\t\182\020\228\029PLC\146$\144\253\138\001\018\156@\129\255\176\176\250\004L%\000\001\006\000!\183\210\224\003\192I\218\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mf.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mg.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\217IDATx\218b<z\244\232\003aaa\001^^>\006&ff\006FF\006\006F&&\134g\179f1`\003\1400\012T\248\251\211'\134\151\251\2473\1888y\242\003@\000\177prr\138\000\005\185YYY\024888\024\024\128\1340\001\021\t\171\169\2254\008\012\254\254e\248p\246,\195\143\147'\025\216\025\024X\000\002\136\005(\245\007d\250\207\159?\025\152A.\002b\144A_\174^\197m\008\016\252\255\253\155\225\221\145#`\246? \002\008 \022\168_\024~\253\250\205\240\255\2557\006&\160\203@\006>Y\180\008E#\178A\255A\248\207\031\134\175\143\030\129\012a\248\013t\017@\000\17702\128\\\192\204\192\204\194\0026\016\132\153\128\222\251{\255>X\017#\022\239\129\012\250\247\255?P'\132\013r\n@\000\177\12852\131\\\193\nv\t\011;+\003'\0113\1310P!\027P\017+T1\186A\127\161\024\232\026P\0241\002\004\016\011(|@.\000\025\194\202\202\202\192\193\204\198\192\198\198\204`\150\003T\193\t\197\255\145L\128\251\013\0188`\211>3\252\007\008 \160\215\254\003\189\006\242$\019\0043\131h\022\136S\128>e\248\131\1979\200\134@\157\005\016@L\140L\255\193A\0032\012\140\153 .\004\187\249?\022\140-\192\128^\003\008 \022H\002\195\162\146\017\139fF\244T\tu5\016\003\004\016\203\255\255\255\128\248?\195\191\127\255\128\248?0\157\253\003\226\191\016/\253\193b\016#Zx1\128\013b\002\008 \150\239\223\191\191\001\006\248?f\022Vf&&f&6\022VFv\014\214\255\012_\128Z~\131\021\253\135kg\132\178\025\145\140\002\133\213w\134\159\000\001\006\000]\236\135q\130J\183\241\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mh.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\240IDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\151\143\131\225\223\127&\006F\006&\006\006 \137\192 \240\031\140\025\193\244?\006F\198\127\012\031>\253f\216\183\255\015\195\201\147g>\000\004\016\011\003\003\187\200\169\147\031\184-\237d\024\020\148x\0248\217X\024~\253\253\0154\138\t\201\016\006\020\195@\228\159\191\028\012o\206\190gP<Y\206\208\203\176\142\005 \128\128\006\177\252\249\005\212\244\252\225g\006\167R\005\006vvf\134\013\235\2220\220\127\248\003l\024#\146\139@\238\249\199\192\011\230)\252>\202\016s\164\131\129\149\2258\195Y\160\019\001\002\136\145\133a\209\135?\012\236\252W\175\0263\136\136p\131\02112228\219]`\248\241\251\015\003\243\127\144f&\134?\012\226@\025v\006\019\134-\012\133\0123\025\196\254\252a\184\250\232\017\195/\014N\006\254\230\t\223\001\002\136\229?\003'\003\027+7\003'\007;\208\000\006\006&&&\176a/_\252gx\247\137\129\225\239\1271 O\144A\153\225\000C\023C*\131\001\144w\027\136\223k\1520(\237\\\193\192\163-\199\240\241\237[F\128\000bad\224b\248\245\155\131!0\248%\195\158}\242\012l,\204\012aQ\207\024^}\144\002*\023\005\186\227\018C-\131)\131\015\144\247\012dA\210$\006\221\t\t\012\\\255\2541\252\253\251\151\225\215\175\031\012\239?\254b\004\008 \160\031\183}`a8\008\012\191\163@|\242?\171\224m \253\252?'P\172\021\0240\143\129\248\158\008\195\255\167\203\015\255\255\249\243'\024\255\248\241\253\255\157{o\255'\023\220\252/\"p\004\168~\213w\128\000\002\186\232;0\008\153\129v\129\002Q\146\225\247\251s\012\229\012\161\012e\012\191\025\004\"\236\025\254,\221\200\192\002\013\2243W>3L\238{\202\176|\225K\134\191@}\176\228\193\012\012E\128\000b\249\013N\025\210@\129K\0129\012\185\012\019\153\2062\252_Y\192\192\028\210\015\214|\252\246{\134\201UW\025\214\174y\004\228\253\006bV fa`\003\167\182\127@\248\007\200\255\201\008\016@\192\192~\204\144\197\176\148\1613|?\003co\015\003\195\143x\134\245\192D9\217\251&\195\161m\247\192\137\015\020[\160\176\004\025\193\004\230\255\133\138\131\156\241\011\232\144\159\012\000\001\196\184,\197\243\139\171A\026\247\nE'\134i\211^0\\\223\250\002d\003\016\179\0015\177\001\237f\134\166\164\127P\252\023n\000\208V\160! \252\2547@\0001*\232oy\240\224\226\023!\160\002`@\177\002#\159\019\152\182\216\128\001\200\004J\012@\197\204@601\129\013\249\015d\252\001\178A\222\249\005\020\255\0066\136\129\225\237O\128\000\003\000\131\214\006\189At\187\001\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mk.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\206IDATx\218b\\f\206\240\192l\153\185\000/\143#\003\195_>\134\187\243\2553\1760@\000\167$\003\131\132/\132\253z7\003\195\231\251\012\012L@\246/ V\138fd`\226\252\196\240\249\203~\1343\201'?\000\004\016\203\167\147\012\"\251\149Or\251\156\179c\224USb\208+`fx\190\141\129\129\025\168\248?\016sqA\012\226`\005b5\006\134?@\182\148\023H\242/\195\215\199g\025\014i\158d\248\201\192\192\002\016@,@\219\255p\002\197Oe\031a\208\136ac\016\143ae\016vc`\184\215\0151@\196\013b\224\251\171\012\012\255\128\180r!P\003\208\180\215k~3\\\155s\132\129\029(\246\023(\005\016@, g\1308_\142\031g\184\244\244)\003c/\011\131\201N\006\006\161,\006\134\171\022@W\20000\176\002\241\147E\012\012:'\128\234\128\214\159\006\138\255\003\154\246\235\209#\176\225\223\129.\002\008 \198\213v\012\031~_b\224\255\241\001\226\002&FF\176\183\228\002\025\024\216\148\129\174y\000\244&\031\208V\160\211\255~f`x\184\028\236\002\134\191\255\255\131\013\225\224a``\212e\248\001\016@,\186\179\024\024\248\249\129\154\216\128\002@\019~\191\254\207\240\249\030\003\195\139\233@k^10h\206\135Xp\187\018\232\154w\012\012\230[\024\024xU\129\234\197\192\193\196\240\011\232\165W\175\024\024\001\002\176D\006)\000\192 \012\147\217\252\255\201[\196\029\138(ZJ\140\001\234\248\138\214\164\005Z\n\251\008\006g\176FS\227.\249b\193\207\173\186O\000\177\\I\005\250\247\018\003\195\207\015\144\168e\129b\165\008 -\202\192p\007(\207\002t\241\191\223\012\012\220\226\012\012\023\220\129\174f\128\024\002\194\172@\175\253\215e`\000\008 \198\153\012\012\031\004\128\190c\135F7\200\223\030\031\129\138\128\225r\028\232\002\237y\144\176:k\207\192`\tT\000\012\001\134\221\140\016u \139\127\130\210\024\144\002\008 &\144\001\160\192\253\006\196b\192\216\240\249\011\t\\\144\226/@1\233D`\018\176\003\199\012X\012\164\217\019\168F\022\152,\190B\245\130\204\000\008 &\1603Y@\134\216lb`0\218\015\140\013\160\1625P\013 \240\239/$P\153\161^^\205\008Q\163\179\145\129\193\2410\196E@3\152\000\002\136\137\223\134\225\141\249-\134\207\127u\025\190=\186\195\240c6\027\195\207\031\012\012?\222\000\213\176\1523\252\004\198\200\143\151/\025~\178y3\252\004\138\253\000F\210\207\025@5\015\2062\252\248.\197\240\195\224\026\195\015nG\134o\000\001\006\000^\191\209\164W26F\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ml.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\173IDATx\218bd\152\192\240\192\\\198\\\192Q\218\145\129\143\141\143\225\255\191\255\012\012\127\024\024\210T\0240\000P\134\225\201,\006\006& \205\196\200\200\240\251\211'\134\151\251\2473\1888y\242\003@\000\1770\1761\136\156\252|\146\219\142\197\142AIP\137\129\025\008\025\25420pqa7HX\013b\016\195\223\191\012\031\206\158e\248q\242$\003;\003\003\011@\000\1770\128\236\007\202\028y}\132\129\141\153\141\129\149\145\021\236\"71\006\172\224\203U\136A\255\127\255fxw\228\008X\236\031\016\001\004\016\011\140u\252\205q\134\167\223\1592\1760\002\133~20d\201\227\240\218\"\168A\127\2540|}\244\008\164\149\2257\208E\000\001\196\002\150\133\130G\223\03010\002\253\206\240\029\168\152\t\187A\223\238C\013\250\255\031\204\007\025\004\012\tF\128\000\130\184\136\017\138\129*\2543\254\007\211\028\028\216\013B\182\152\001\201 \128\000bA6\132\129\005\202\006\210\172\172\216\013b\129*\253\007\021c\130\218\015\016@,(\134\192T\253\129F\003\022\1318\161v\253\133\132\013X\012\024\207\012\000\001\196\0023\018\204cF\176q\133\017\011\146\007`^\003*g\004\008 &\176(3T\150\008\000\011\"F$\251A4@\000\129b\141\005\022b`\217\127\016\175\253\253\139\221\144\223H\174\129)\001y\000 \128X\024~1\188a\248\002\212\206\004\2283\002\201\255@\242\007\195\255\151/!n\004\166\006PL3B\157\241\255\0214\170\129\002\255a\246\127\002\166<\128\000\003\000\156\tz\252\150k\025\218\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002!IDATx\218bd\214\174\127`\166\175,\224`\162\196\192\207\203\205\240\239?\019\003\003\003#\195\255\127\140@\n\200fbe\008\127\181\154\225+P\244\031X\006\138\025\025\025~\127\250\196\240r\255~\134\023'O~\000\008 \022\160B\145\019\151^q\187Z\16908Z\1361(Jr3\220y\242\131\225\245\187\159\012\191~\003u0\1792\240\011\1681\176\003\153\255\161\134\128\193\223\191\012\031\206\158e\248q\242$H\142\005 \128X\254\255c\251\243\159\129\153\225\227\231\207\012\018\002\204\012\223\190~g\208\148gc\184\253\240\029\195\253\167?\128.bg\176xq\149\225\011\003*\248\255\2517\195\187#G\192l\160K\255\001\004\016\011\003#'\144\201\194p\245\222g\134Wo>2\200\n\1790\252\254\253\151a\207\137\007\012\199\206\127b\248\207\198\195\016tu\017\195\155\255\016\1751@]\246\255\207\031\134\175\143\030\129\197\128\014g\001\008 \150\127\012\188@Q6\134\227\215\025\025f\236\251\200\016b+\202\176\241\2083\134\141'\1901|~\015\212\194\193\194\240\247\254}\134\031@\230_$\131\254\253\255\015\161\025\192\226\140\000\001\004\012#a\160y<\012_\19123\204\221\241\159a\237\218\151\012\031\184\153\025\024>K20\176\179\002\149\1763\252\007j\002\235\194\002`\006\001\004\016\203\174\203\190\012\252@\014\019P\225w \205\001\196\191\128X\000\228a`\200\254\006\226\151@9&\164\128\254\207\128p\029\019\004\255\007\008 \150\215@Q`\144\130c\133\005)f\222\129\232\255\016\001f\006\008f@2\232\015$l\192l\144\028@\000\129\244\194\211\006\019\018\013\211\192\000S\132\228\162\127hl\160A\140\000\001\196\194\0045\017\221\233\20046\000\179\016\166\023 \128@\006\129-\252\139f+\186a\140X\228az\128\1341\001\004\016\0110|\192I\132\017\201a\1608\250\015\013\"\228\004\013$\254\1312\014\212\176\255\208\024c\248\196\192\240\019 \192\000?\219\181\254\239,<\165\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mn.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\157IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\129\225\255\127\006.\006\006\134U~i\012\172\191\25410\253\251\199\000\002\255\025\025\025~r13\132\172\159\197\240\019$\000\228\255\254\244\137\225\229\254\253\012/N\158\252\000\016@,\236\012\012\"?N\158\228f\179\179c\016PRb`dff\000\1381\168\tr1\176\252\249\199\192\248\239?\212 \006\134\223\236\204\012\002jj\012\191A\252\191\127\025>\156=\203\000\212\011R\207\002\016@,@e\127@\n\223\0319\194\192\204\198\198\192\196\202\202\000\210zM\215\141\129\237\231\031\160\139\160\006112|\231\250\207`z\245*\216E\127\127\255fx\007\212\003\002@7\255\003\008 \022\144\195A6\252\147;\206\240\229\239S\134\015\203Y\024\196\129\252\197\246Y\012<\159\12700\003m\006+fbf\248 \196\193\224\179h\017\195g\144\158?\127\024\190>z\196\000\213\207\002\016@`\131\152\129\206fc\005*~\007\148\184\207\0086\248\193W&\006\158\239\204\012,\127!a\244\023\168\232\253\031&\134_\247\2393|\007\242\127\001\195\242?\1965\012@\171\024\001\002\136\137\133\147\129A\2391\003\131\1285\003\131\160)\003\131\225\205\255\012\130\202\255\025~\191\224`\248\199\202\201\240\143\153\011\1389\025\254\179p00\003\013\000E\008\012\192\012\002\008 \022\176\245\175\025\024\152\190\001\221\0074\148\249-\003\003\167\012P\140\133\149\129\145\245?\003#(\148A\145\196\204\004\022c\001IA4\131\001\019\004\255\007\008 \022f`P\179\128\226\155\159\129\129\003\136\2178\128~\006Y\200\206\002\012x``C\013\250\0152\136\149\005\028\163\028PC\192\177\007\n\026 \006\008 &f\160\241\255?\002m\004Z\241\247\013\144\006\202\130\196\024\024\153\128\136\017\005301\193]\196\n\197,\016\131\024\001\002\136\133\025h$\139\004\144\165\n\148\000z\141\017\024eL,P\207\255\003\005\007\196E\0120\151A]\195\008\245\0223\148\006\008 \022Fn\006\150\0317\025\024>u\001\189\197\013\020\140\003\234\191\205\000v\226\191\191\1920\250\243\031\026\168@S\255\252\005{\231\015\020\195\194\th\024\019@\000\177|\254\196\240\230\188+\003(\217\129\028\199tk\003\003\163\024(\240\184_2\254{\243\011h\222\191\255@\192\248\015\028\216\028\255_\001\173\248\0001\228?4\198\024>10\252\004\0080\000wj\213\1868\131\131R\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mo.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002OIDATx\218bd\168bx`\174`.\224\168\224\200\192\199\206\199\240\255\255\127\0068@b\130\001#\018\147\145\145\225\211\207O\012\251\031\236g8\249\224\228\007\128\000ba`e\0169\249\230$\183\157\138\029\131\146\136\018\0033#3\003\003\022\253\232f\254\253\255\151\225\236\203\179\012@\189\012@3X\000\002\136\005\168\226\015H\229\145'G\024\216\152\217\024X\153X\193\186X\152 &\008\17910\008\002\133n~\006\170\007\218\241\235\015D\252\247\191\223`=`[\2541\252\003\008 \022\152\013\199\159\030gx\250\245)\208\000\022\006&\160$\015P\179\024\016\223\249\196\192\192\193\206\005\244\2427\006a\014\006\134\023_A\250\024\024\254\252\251\195\240\232\195#\136\230\127\012,\000\001\196\002v\243\127\136-\143>?b`\252\207\200\160\204\199\192p\237\027\003\195\197\027\012\012\175[^\131\213\138\206\018\005\1713\022g`8\251\022\200d\252\143\008\199\255\012\140\000\001\196\132l\016\008\255g\254\207p\231\195\127\006=\177\000\006\014-A\134\031@\2358\2169\024\196\133U\024l\213\210\024\206\188\249\207\240\159\233?\\=X\239?\006F\128\000bd\168a\248\192\192\197\192\207\000\242$3T\226\023\003\195\207\226\159`\246\251\159\223\024\184X\217\024\216\255\177\128\002\149Ac\165+\195\253\151\135\024\024@a\248\023\228G \254\204\240\003 \128\152\192\154a\024\168\144\001\024\184\012\220\012\012Som`\248\007L\n\027\159\031b(\186\212\205\192\194\194\194\176\227\249I\134\015\191\174C\212\176\"\233\003b\128\000bfpd\168`\224\000B\152\139X\160^d\250\013\140A\030\134+\159\1740\252\252\247\145\225\195\207/\012\135_\030f8\244t'D\0292\248\193\240\023 \128X\224~eDM8\187\238ndx\252\2291C\138z\t\1316+\015\195\130;s\025\014<\216\008\241\018#R\002\131b\128\000bdhb\248\002\012#n\184\139\144\003\241\023ZJ\004y\137\t\030S\200a\244\027 \128X\128\138\223@\194\029l\012\019\144f\132\199#D\003\132\013\018\253\014\143_\1368\204\176\175\012?\001\002\012\000\246\017\188\253\026\028\222\235\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mp.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\003IDATx\218bd\240?\243\192\\CP\192Q\135\135\129\143\147\137\225\255\127\006\006\006\024\254\005\165\153\160\152\133\001\002\024\129\008\136?}\255\199\176\255\202\023\134\1477\222\127\000\008 \022\006\022\014\145\147\015\152\185\237tY\025\148$\217\024\152\153\128*\254A4\n\t30\136\178\253e\224\255\203\196\240\t\168\243\1983\168\193@\003\255\254\251\207p\246\254/\006\160^ \159\131\005 \128\128B\140\127@V\028\185\249\155\129\141\133\153\129\021h\014\003;\003C\162\028\003\131\192\155\007\012\223\158\159c\248\163\230\204 \247\241\018\195\015\022]\134\195\031\004\024>}f`\248\253\151\001\172\007\236\188\255\255\255\001\004\016\011\195_ \131\133\145\225\248\173?\012O\223\255``\001\218\152\173v\155\225\215\189\022\134}\198U\012\231D\028\024\248\249N1\240\221\212d\208eZ\205\016,\021\199\224\184\226?\195\031.\006\134Go\255@\012\250\243\143\005 \128\128\129\002\242\n\208\031\255\153\025\030=cd0Qff\136\255y\150a\149H<C\237E)\134|\205O\012\t\127D\024\210;>2\028\182\220\201\192\189\219\159\129G\017\168\246\017#X\015D/\003#@\000A\012\002\t0\176\002\221\203\198 \242\2505\003\187\130%C\245Q_\134+3\196\025\174\223\023bX\178\2285\195\255\031b\012\245\243\2153\176\203\1820\248(\\e`\248\201\006\212\199\n\209\0114\008 \128\152 Q\000\162\128\002\127Y\025.\168v3\\\255\253\134\129\225\005+CH.\027\131\153\129(Cf\133/Cu\175,\195\247E\172\012\151dl\024\252\237\129\001dx\007\232\026f\136^\006\166\255\000\001\196\196\000\138%f&\008\230`fx\207P\197  \248\147\161<\224\t\195\154~`\164\178\176\130qk\t\011\131\160;\011\131\132\244R\134s\247\141\0248\031\23200\176A\245\001\205\000\008 &\144\131\192i\132\025\200\224ed\184\190R\145\129Q\192\141!L\171\143a\249\244\195\012\012?\024\025\238^\191\195PW\243\156\225]\189\031\1957\142\147\012\153\251o2|\255\014\137$\176^`\248\000\004\016\019\0033$\224\225X\016\232\234\173w\025\206q\2481D\168\031g`\226x\193\240\226\233[\006\211w\153\012\207\19073\236\2237\131\129\225\142\nX\029\\\015\208\012\128\000bd\008\185\249\133\129]\136\155\129\t\024x\140l\144\176\250\tJ\182\255\024\216\229\153\025\182\166\127f8\179k;C\197^\007`\250\018c`\224\002\197\0110\1972\002\195\233?0\233\255\003\226\239/\127\003\004\016#C\192\249\007\012,\220B@Y\160\tL\192X\004z\152\145\233?\195_\160]\160,\242\025\024'\156\192\168\229\004\133%\227\127\134\255\255\128\242\192\196\198\008L\218\012\192t\244\255'\208\251\175\127\002\004\024\000x\240\232'\153\190\144=\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mq.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\244IDATx\218bdHbx`\174b.\224\168\238\200\192\199\193\199\240\255\223\127\0068@b\130\001#\018\147\137\145\225\211\143O\012\251o\238g8y\231\228\007\128\000ba`a\0169\249\236$\183\157\166\029\131\146\132\018\0033#3vC\208\012\251\251\255/\195\217Gg\025\128z\025\128f\176\000\004\016\011P\236\015H\226\200\189#\012l,l\012\172\204\172\168\134\252\133\026\202\130j\216\239\191\191\193z\160\150\254\003\008 \022\134\127\016\133\199\239\031gx\250\241)\003\011\019\146\014\160\021\145f\012\012\188\028\012\012\179\014\001\249\172HR\255\2540<z\247\008b\201_\006\022\128\000\130\027\004\002\143\222?\002\251\029\014\19020\200\24010\136\17630\220\127\005\228s!\005\031(,\2553\192\012b\004\008 F\134D\134\015\012\236\012\252\012\204\008\255+\13920|\252\205\192\240\230\003\144\243\027\234=\160\171\216\129\006i\t20\156\127\002U\251\031*\247\141\225'@\0001\193\003\016\132\153 \248\013\208Kk\188\129\236\007@\252\029j\216\029\006\134\213~\012\012\175\254\"\212\193\245\001\141\004\008 &\176\000\011\020\179A\240\199\231\012\012\199~\001\195a\n\003\131\189\021\003\131\1499\003\195\219\153\012\012\0318\025\024\158\222\133\184\014\172\022\166\015h\006@\000\177\128\189\0042\140\025\201&\017\006\134*\160\198\2311\012\012\007\018!^\168=\193\192\2082\027\200\150\133\006\210?\168\158\255`\154\017 \128\024\0252\128a\196\t\013#\152a\176t\244\022\026\0060 \134\148(\255A\229@\248\011\195O\128\000b\001J \226\027)\006\1934?\018\159\017\170\137\017K\170\007\006\016@\000\177\000\003\242\013(A\001\0210\003iH\016\254\007+c\132*\254\015\215\206\008e3\"\025\245\015\028!?\001\002\012\000`\028\146\019Z\133\236\184\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ms.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002YIDATx\218\0007\000\200\255\001\176\\h\024GC\204\254\026\238\225\239\"\031\023B\251\215\168\0034\244\227\233\030\014\252F%\020\223\005\006\189\201\237\004\004\254\001\000\253\000\001\253\244\243\245\192\193\211\222\221\223\002\0007\000\200\255\004j\209\"Y\244\207|}\029\2519A\240\005\247\008\206\221E+\026\027+\005\007\031\023\204\240\254\231\216\236&%\011\000\000\001\000\000\254\254\254\253\210\210\240\197\196\218\t\t\000\002\0007\000\200\255\001\205:;\255\237\247\251-(\0284$\255\252\255\245\246\253\015\005\254\251\019\029\247\248\248\024\246\240\245\013\028\147\235\022\000\000\254\000\000\255\252\252\251\198\198\210\198\198\213\011\t\016\002\1361P?W\209T\183(D\137e\215\246\151\"\170\239g\183(\175\219\198~\251\234\219\253\199\022~Q{\250\254\243\254\011\031\024@\224\207\127F\150O\162b\159\025X\132\222~\000\008 \022.\027\235\018\015\214\251\203\143Z/\226\136\207\018\239\019\224\176\236y\205\241\135q\127\142U\241\174\167^\251\223=y\250\135\225?P\219{&M;\199m\158f?\158\206\233\248\008\016\0007\000\200\255\004\016\210\226A\151\225\217\254\030\000\000\004\191\176\227k\245D\228\225\222\246\238\189\019\169<ds0!\011\202\203\000\252\000\000\005\000\000\008\005\008\024\216\212\0070\252\244\000\002\n\002\136\145\129\173\157\225\215?\176\167\153\192\142ac`\248\193\192\192\204\000\012:\016\131\027,\008\146\149\147x~ik\239\175/\012e\147=\001\002\136\153\155\211\242\247\175\239\012\012\191\192\138\128\140\175\012\012?\193\140\159`\157\223a\232\219\199/\188\219\014H\221y\252o\206j?\128\000b\228\225\205\255\242\025\232\140\255`\219\224v2\130\017\003X\252?\152\241\015\204\000\186\150\153\143\255/@\000\177|\255\246\017,\nt\021\011\0241!!\136j8\250\003v\209\223\175_\254\003\004\016\139\142\142\200\239\223l\140\140\156\255\025\185\2543p20\176\255g`\251\015\212\255\031\172\141\017\152>\2540\130\188\240\147\145\225;\227\255o\255\255\127ge\253\005\016@\140\140\140!\012\012\\0\196\001v\006+\204\193\016G\002\237\249\013F@\171\190A\016@\128\001\000\004\201\243\028\167iHZ\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mt.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002+IDATx\218b<z\236\216\003111\001\182?\127\0258\004\005\024\254300\252\255\199\000\001L\140\012L@\252t\214,\006F\168\016#\012322\252\254\244\137\225\229\254\253\012/N\158\252\000\016@,\156<<\"\172?\190q\223\184y\155\193\208\194\130\129[@\128\225\223?\160I\255!\006\1294\008\171\169\161\024\004\006\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\196\194\244\249\243\159yk\0220\200\233\2171\252\006Jh+\2002\008\202)\001\013\251\0114\136\tl\208\231\171W\025\152\144\013\001\185\250\247o\134wG\142\128\217@k\255\001\004\016\011#/?Clh\"\195\162\229k\0244\220\029\0258E$\024\190|\249\194\240\255\255\127\006F\022f\006&ff\134\167\139\022\161\024\004\246\254\159?\012_\031=\002\025\194\240\027\232\"\128\000b\001\249\130UV\142!\196\211\131A\208@\155\225\031P#\003\200\016\160K\024\129.b\002\226\239\247\239c\024\244\015\168\230?\1965\012@\1833\002\004\016\011H\250\223\159\255\012b&F\144\240\005B\0226V\008\155\021\200c\129\026\204\128\029\192\012\002\008 \022\144\205 [\255\255\253\207\192\202\202\202\192\012t\017H\012\217 \160m\012\204\200\225\003\209\012\181\024\140\255\003\004\016\011#P\024\0249\012,,L`\204\204\204\004\142rp\012\177\17600\003\013\226\128j@\246\218\031H\216\128\217 K\000\002\136\133\145\t\232l&pL\13113\019\196\133`\131\160l\022\132\205p\2390\"\177\129\0061\002\004\016\011$\129\253\135\197\005\138\255a!\003\211\136,\203\0085\152\025J\003\004\016\203\255\255\255X@Q\013J\132\255\254\253g\248\003LhLP3\025\025\2552\252\007\234\248\005\213\192\136\230=X8\001\229\152\000\002\176D\1988\000\128 \012\004\011\255\127\168N.\196E\172\132\164\243%w\181\136X\140{a\14218\250\000\150\188W\213\025\218\145S\202\190\162\234\2317\171\031\147-r\158\000\003\000\2423\162q\144\165/\253\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mu.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\154IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\147\129A\228\247\201\147\220\236vv\012\252JJ\012\140\204\204`\013\248\012\002\203\255\253\203\240\241\236Y\006\160^\006\160\025,\000\001\196\"\204\192\240\135\007$s\228\008\195\12766\006\006VV\006|\000f\193\255\223\191\193zD\129\236\207\012\012\255\000\002\008h\193\230\015\012\012\028\252 \187\228\2288\024XX\024\177\216\143n\012\208\246?\255\025\030=\250\001\021\251\242\029 \128X\128B@\198_\176\166G\143\190\002\253\142\207c\008\011\254\255G6\2527#@\000\001\013\018\0042x\129\024\200d`\006*`\196\226\018l\030\252\015u\000\200!L\140\000\001\196x\243&\195\007\001\001\006~vvH\240\128\194\154\145\1289 \215\000\195\154\001\020L?\12720\188z\197\240\003 \128X@\154\152\152 \024d\008\008\131\216\248\192\191\127\016\026d\024H-\200\012\128\000b\129\251\154\017\130a\134\018\002 \195`.\007\186\144\017 \128X\212\182C\131\136\021\028D\016\204H !\193\130\007\132\129\222cx\199\192\000\016@,\012\236\012 \012\tk\022\164\164\139\030\227\232b,\176p\006b\014\006&\128\000b\001\154\248\134\225+\195?\160\0003P1\019X\011\019P\233?\168V`L\003!\130\013#\025\192j \134}e\248\t\016`\0002hr\135\215\008\204C\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mv.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\133IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220\188vv\012\018JJ\012\255\153\153\193\026\254#i\132\129\255H\252\255\127\2552\252:{\150\225\211\201\147\012l\012\012,\000\001\196\002\148\252\195\015\1488y\243\024\195_]N\006\222\223,\012\255\1444\254\249\251\143\225\199_\006\006nVF\006&FF\184\225\255\255\252f8\246\239\004\003\191\0023\131\241\131\191\255\000\002\136\005\164I\006\136\251\191\159d\184\164\240\142\129\229\t\208E\204P\213\223\1901pp\1772\232j\1672\156\190\179\134\129\225\199'\160\028\019\216\134?\127\2540<ry\194`y\135\137\193\237\193_\022\128\000b\249\011\178\021\136\005>02<\186\254\152\129\243\025\196\144\223\255~0\252\253\247\151\225\144\213N\134\212\221\165\012O>^g`bb\001JA\012\250\255\015HH22\008}\000\170\005\234\000\008 &\144\139\128R\012\223\025\153\192\182\253\255\207\008\198\127\190\254aht\222\198\176\248\247;\134\027\183/203\002C\243?3\\\030\172\139\137\137\225\023\208h\160\145\140\000\001\196\002\021b\000{\031\228%fF\136\183@\230\178\17620\177\177@\02003\162\134:0vA\226P\165\255\001\002\136\t\022\028<\140@\t\230\255\012\140l\255\192\152E\144\153\161\250\160\011C\006\183\020\131\158\1909\195_\150\031\012\012l\127\224\242\140\160hb\254\199\192\206\244\031\172\031 \128X\128\2461\000\029\205\240Q\008(\161\014\244\"\027H\020d:'\003\195\231/\012\230O\173\024\236<:\024.]z\201\192\240\245\021D\014\228\162_@,\199\192\240N\144\129\129\021\168\026 \128\024\15130|\000\242\249\207\20223\2366ef\016\127\255\159\225\031\019\212\245@\187~\252\250\205\240\250\251\127\006\t\030&\006vh\026\0039\030\020\184/\004\024\025,.\254e\208\189\255\247'@\000\177\000\245\176\000\003\158\193\252\241_\134\024 \254\011\013\179\255h)\025h<\024\131\216\160\008\250\011\021\191\015\196w\128Z\000\002\008\228\2437@M\255\190\000}\252\000\026\238\255!A\201\248\031-A\003\tP|A\147%0\005@\013\004\166\174\159\000\001\006\000g\195\211\183\249)\141\133\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mw.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\189IDATx\218D\195\177\013\128@\008@\209Oc\172\136\219P395[\220\008\023*\173\144\198\248\146'\1922\179\203\221QU\186\155\2071\207)\243\158\015?\017\161\170\136\0082s\191\002\136\005(&\002dp\219\217\2171())1033\131\021\242\00217\016\255\135\026\244\031j\216G\168A\127\255\254e8{\246,\200\016\016\151\005 \128@\006\253\001\177\142\0289\194\192\198\198\198\192\202\202\nV\168\006\196 #\205\160\026\207\001\241\027 \190\0112\004\136\127\255\254\013\214\003\005\255\000\002\008d\217\007 \230\007\241\228\228\228\024XXX\192\174\145\002b\015 \230\130\186\230\031\016o\000\226WP\013\127\254\252ax\244\232\017\204\160\239\000\001\196\184\007(\206\0034\136\005\234\005&\160\223Aa\241\029\234\141\239P\149 w\nC\195\012\132\255\001\195\242?\212;\239\129\190\006\008 \150\167\208\176`\129bF\160\002X\152\176B1\012|\131\026\252\031\138\255@1\208\133\140\000\001\196\002v\005\146ALP\15112`\007\255\145\188\202\000\165\129z\254\003\004\016\139\0044\128\216\161\209\205\140\199\016d\195@\001\254\011\154$@z\001\002\136\145a=\208e|@\179\216\161Nb\134:\011\031\248\0075\233\015\212\164\183\012?\001\002\136\133\225\029(.\145\156\131\236\164\255h\0060\1629\t\230,\160\025\000\001\196\0024\149\005\146\146\160.\250\131\230\183\255h\1340`\t\237\191\012L\000\001\196\0024\241\013\195\023\160c\153\128na\132\1345\019P\217?\168VF\006P<#\2160\146\001\172\006b\208\023\134\159\000\001\006\000\021\026\129\2239\197<&\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mx.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002=IDATx\218bd\152\192\240\192\\\198\\\192Q\218\145\129\143\141\143\225\255\191\255\012\012\127\024\024\210T\210\024\208\001P\134\225\201\172Y\012L@\154\137\145\145\225\247\167O\012/\247\239gxq\242\228\007\128\000ba`c\0169\249\249$\183\029\139\029\131\146\160\018\0033\0162\252e`\224\226\226\194j\144\176\154\026\216 \134\191\127\025>\156=\203\240\227\228I\006v\006\006\022\128\000ba\000\217\015\1489\242\250\008\003\0273\027\003+#+\216Enbn\012\216\192\151\171W\193\006\253\255\253\155\225\221\145#`\177\127@\004\016@,0\214\2417\199\025\158~\127\202\192\194\008\020\250\201\192\144%\159\133\228\146\191\012\140@\151\254\003ym\209\"\136A\127\2540|}\244\008,\246\027\232\"\128\000b\002\187\023\n\030}{\196p\255\219}\134\251\159\23930111\252\006\234h\136\211a\136\022\151b8\177n\t\003\011P\236\199\253\251\012\223@\024h\200\127\136\027@!\193\008\016@`\239\002\173\131` \239?\211\127\134\255\220\255\0258\254q0\156\186\243\152\225\215\135O\012\n*\236\012;\150\21230rp0\176\253\007j\255\143\176\029f\016@\0001!\027\194\192\002\197\002\012\012\023\031\220g\184t\251\025\003\131w&\003\135\153,\131]\230:\134=\223\0312p\003\021\131\1480C\181@\241\127\128\000b\1940\004\024\214\012\191\024\024,\180\181\024\212\149\185\024\158\191x\199p\130\133\149\225\133\230O\006\031!\013`$\003]\011T\194\014U\202\n5\020 \128X\224\1982#Y\243\013Hq21\132[:1\168\243\1781\1763\2311hj\026\129\195\228\007\212>&$\175\001\1811\002\004\016\011\216E\204P\239\193\000#\130o\160c\131\145\150\144C\003f7@\000\177\000eX`!\006\150\253\007NY\192\244\246\023k\130\252\141\228\026\152\n\160aL\000\001\196\002\012\1437\012_\128\218\153\128|F\006Pr`\004\186\255\255\203\151/\193nbdd\252\015\004\016\247\001\217\175\192\222\000\219\249\031f\255'`\202\003\0080\000s\172\172*\160\" /\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_my.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\005IDATx\218bdc\152\240\192\216\\Q\192\193Q\129AH\128\145\225\247_\022\134\255\012\172\012 \192\008\196\255\025\152\025\162x\2152|\255\199\tdCD\024\161\172?_>3\1889z\148\225\249\217\211\031\000\002\136\145\133a\214\151?\012R\220;w|d\248\251\199\148\225\235w\001\006^\158\207\012?\191\1791\252\250\203\001R\206\224e\249\151\225\231\031F\134\127\255\024\192\006\129\241\255\191\012_\223\188ax~\229\018\195\215\031\223\191\002\004\016\011\208\144?\179\166\1822\236\219\029\206\192\194\193\201\016\021\185\138AF\246\013\216E\179f\2491|\253\202\197\224\202w\143\225\235o6\134\255 \147\024A\006\253\003\154\243\135\225\195\205\155\012\191\239\221g\248\253\227\239?\128\000b\001\153\174\174\241\133!-\219\156AN\238\014C^^\031\195\207\159`s\024\030=d`\216\186\221\130!\237\255.\134\183\191\004\024\254\002\205`\132\248\142\225\223\223\191\012\223\223~`\248\255\159\149\225\215\207\255,\000\001\196\204\192\144T!*\253\140C[\251.\195\254}\230\012\162b\215\024\140\141N\0015|`\136\012-`x\247\158\149\1612\157\155\225\235On\134\255l<\012\140\236|\012\012`,\192\192, \197\192\200/\206\240\139S\224/@\000\001\205\223\253\129\129A\148\2236\241\014\195\131\243\252\012\143/\168\001\021\189c`\248\201\001q\022\208\250\007V\185\012/\0054\129.\250\007\017\001\185\232?#\144\255\159\2257\208\187\239~}\255\t\016@\140\236\012\179?\252g\224\225\255\197\192\207\192\196\240\003\024G\012\012\191\025@\134\252\005\242\191\000C\131\153\225\231\005Q\134\231\023\153\025\254\252a\004\027\244\015d\016\144\248\003\244\222\207\223\127\024\222~z\255\003 \128X.E]e\016\228dc`gfd`\001b6\166\127\012L\140\016\151\128\194\228\0310\162\239\246\000\005X\161\017\006M\000\127\128\142\251\253\023\232p \253\253\219w\006\128\000by&)\206\240\141\155\149\129\019\168\144\149\153\137\129\153\137\th\016#8\021\129 \200\027\\\146\144\152\130\025\243\015\232\197\191@\023\253\254\011\180\2447\003\003\219\167o\140\000\001x$\147\027\000@\024\134\165\229\216\127Q\222\136\170\020B\031\012\224H\150S\207\026\008mp\171\144\1943j'\206\152O\242\020b\250G!;\149)E5c9\207\027HL\\\001\196\242\235\204Q\150\223\172\172\012\255\025\129\134\001\147'\019\200\015\140@\003\254\131B\139\t\154\134\025\192\169\025\236Q\144a\192\196\248\015\024\146\127\254\255\001b \253\235\023\019@\000\138\201 \005@\024\136\129\205v\005\165\031\174\127V\188Zj7f\143s\025\024B|?\251\133\163\005l\171Q\221t\015\192\156\164\250\180\140\128\tL\165\188\193\133\020)\140\252fY\243-|\238\241\0110\000\195\0019,=M\239=\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_mz.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\031IDATx\218b\204\211axpr\129\185\128#\187#\003\223/>\134\255\255\2553\128\001\148\194\000\140P\138\145\145\225\211\175O\012\251\159\238g8\249\228\228\007\128\000b\137\189\194 \226fr\146\251\2249;\006%y%\006\230\207\204\184\013A2\236\239\255\191\012g\223\158e8\249\249$\003\003\027\003\011@\000\177\220d`\248\163\n\148\203\201>\194\176\190\129\141\225\131!+\003\195\011\160\192_\252f\253\254\247\155\225\200\171#\016\023\254c\248\007\016@\140\139\024\024>\24020\240\243\003\005\180e\229\024\166\154\1780,i\227e\224`\226g\224\253\245\011\2328F\172\006\253\249\247\135\225\233\175\167\012\255\25502\252\255\248\255;@\0001.\003\026t\007h\144Y\002\144\177\156\129\129\253\023#\131\173\140=Cu\1283\195\187\015\031\128\150\001\197\208\252\0052\252/\208\251\255\255\129h&\134\239\223\127\254\000\008 \198u\156\012\031\022Y1\240\179+\2022\200\139\1381D|?\203\240e\002$\152\130\128\248-\003Q\224'@\000\177|\251\206\192 \253V\150\225[\243a\134H}Q\134\0232\220\012\172\1600\000\226o\012D\131\255\000\001\196\242\025H\234K?f\240Y\167\207\240\238\200G\134\223@\001yaG\134\202hg\006\147wo\025d\024\025Q\"\017\022f\127\129\222\250\247\239?\195\159\191\140\012\223\128\174\001\008 \198\165\192\160\017eb\224\255\007\012\012&\160\002\141<\006\006\217\137\\@\022/\142\168\251\207\000R\251\231\015\003\0030.\024~\252\248\207\240\226\197\255\159\000\001\196\002\210\252\235\031$\022\141w20\008\1850@=E\130\199\128\000 \128X\128v\178\000\147 \131\197G\006\006\0146\160\027\128\002\255\t$H\144\139`\024\146\202\025\152\000\002\136\133\215\153\225\141\210t\134\127\031\222103110\0011#\016\255\135e\006P\016\253\255\143`\00353\130,\002\210\255A\222\251\249\019\024\179o\025~\002\004\024\000 \020\192Z\027X\216\t\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_na.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\242IDATx\218b42:\242@OOR\192\208\152\135\129\147\139\137\129\225?\003\003\003#\132\194\n\128\018\031\129\242\188\194\012\012\174?N20\24673\188?y\242\003@\000\17701q\138\\\190\204\204md\196\200\160\172\008R\200\201\240\247\031#\003#\019\166\025\127\25410|gc`\176\018\248\195\160\248t;\195\175\163g\025>\157<\201\192\193\192\194\002\016@,\191~\179\254ag\253\197 -\181\156AO\155\157\225\206}\013\134\011\231-\024\152\152\153\025\024\025\161\142\000\186\226\029\144\230\226c`\008\225=\207\192\179\255\000\195\223\223\191\025~\0319\194\192\200\172\207P\176C\239\031@\000\177|\255\205\204\160ox\142\193\194r\t\195?\006i\006Q\193\163\012W\174\1790<|`\192\192\198\nt\193\031\006\134\187\\\012\012A\234\012\012\201{\188\025\024\206\188e\248\001v\222\031\134?\198n\012J\247_2\252\189u\136\005 \128X@\001\242\226\141\004\195\239\239,\012\172|W\025\190|Sf\184s\143\159\225\205K&\134g@\245L2\012\0123\148\0141Xv\00430\252\132yR\153a\198\202P\134\026\187\139\012\012\151\23930\188\230a\004\008 F\013\253\171\031~\253\020\2267\182\190\202\160\175u\154\225\230m+\134\227;\141\024\030\20302\216\16900\172\127\019\200\192\176y7\"\172\205K\0244v|gx\250\237\020\003\195\013\160\201\191\217\025\024\222\255\250\t\016@\140\154FW?\176\178\138\240\255\252\201\206\192\242\143\149\225\031#3\195\019YF\134n\227\167\012\1373\149\024\024^\192\140\016f\2164\181\129!4\2298\003\195\245\243\012\012\159y\129\222\003\006\226o`\012\188\253\251\003 \128XX\024\2553\176\002\163\136\149\131\137\225*\0110\188T\153\025^\179\1490\1766NDD\151l\016\131\2199a\134\189B\139\025\024\206\127b`\248\203\193\192\192\252\027\146F\254\002\t\198\191\012\000\001\196\194\0124\232\219_\006\134\135\"\140\012\141\166\159\024J\214\13810]E\152q\167\190\138A\181\225\006\003\195}\160\247\030\001C\157\017\024\172L\127 Q\tJ\"\140 \250/#@\000\177<\248\195\206 \014\012\139\139\242\189\012rM\013\008\019X\173\0242.\1530\204\2128\196\192p\001\232\191\127\252\144\212\008\195 \003\024\255Ah\134\191\012\000\001\196\226`\203\1920\251\1886\003\251\154W`%\255@\134D\2121\176/}\194\240\231\213\030`t\003S \131 \212\244\127\016\151\0005\130\021\254\135\025\252\143\001 \128\024/\1763|\225\251\201\192\013R\206\194\160\2010ik\008C\155\00500\175\222\006\006$\031\003\196\253\012H\174\249\007\193\127\129\222\251\247\023\156\158\024>\253\254\013\016`\000\216\163\243\001n\145\130\222\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_nc.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ne.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\0025IDATx\218b\220\239\206\246@D\203L\128O\207\129\129\153\147\143\129\225\255\127\016\194\011\024\025!\196\223\239\159\024>]:\192\240\230\218\169\015\000\001\196\194\193\194 \242\255\254in6}[\006NiE\006\006&f\160a\012\004L\002\226\127\127\025\190\223=\199\000\212\203\0004\131\005 \128X\024~\255\253\195\200\196\192\240\253\234!\006&&\022\006F\022\022\136\226\255x\012\001I\255\249\003\214\195\248\247\015\195\191_\012\255\000\002\136\133\241\219_\006\198\223\012\012?\206\028e\248\247\2321\194 \144\030\160\227\024\196\229\025\024\152\129\186\159=`\248\255\023a\030\200\160_\175\030A\028\247\139\129\005 \128X\248f_g\224\229\229e`\001\026\192\196\196\004\198\200\224\215\197\227\012\255\191}g`\183tB\017\255\247\239\031\024\255\001\026\248\231\237[F\128\000ba\002\006\026\01133\003\027++\0033\144\006\025\196\008\020\003\225\159\007\1421\252N\246e`\000\186\132\163\1275\003G\160'0\"\254\1311\200\144\191\127\255\130#\007\232*F\128\000b\001i\000i\006\025\194\n5\140\145\017\018\016 o\254\0032\255\0031'\144\205\002\148\007{\011\168\025l\008\016@}\241\031 \128\224\006\193\012\131\185\n\004X\\\237\02586\236a`\248\246\141\129\193\222\027\197[ \0002\012\230\003\128\000bd\241g\248\192\192\193\192\015\014Xfh\1720Bc\013\200g\1503\006\186\140\153\225\207\189S`/\194\229@\024\2283\144\2167\134\159\000\001\196\"&$\198\192\204\001\012\019P\204\000\029\194\008\180\225?,\158\129\140\255\031\158Ax|\210\208\168\255\0151\011\228\170\127 \131\2543\252a\255\199\000\016\128E2H\002\000\004A`X\253\255\199\226Z\030\185,\012p\174D\225\251oMD\155\168\016\237)g\142\163\166\n\136\218&W(\159\230H\152;J\000\001\196\0024\241\205\223\031@o3\254\003y\132\t\020\t\255!\225\201\008\201*`\146\017\1545\254\131#\020\202\006:\139\129\241\031\144\250\249\255'@\128\001\000\012,\196\012+\205\248\237\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_nf.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002yIDATx\218bd\008bx`\174n.\224\168\237\200\192\247\143\143\193\199:\140A\146\143\159\001\006\254\131\224?\006\006&&F\184\216\243O\031\025\182\028]\197\240\137\233\019\195\254\171\251\025N\222<\249\001 \128X\024\152\025DN>8\201m\167c\199\160$\163\196 \196\199\195\192\197\197\197\128\012^|\254\196 \193\197\007\231\0111\252\005\171=\251\252,\003P/\003\208\012\022\128\000b\002Z\248\007$y\228\198\017\134\203\247.3|\253\241\153\225\207\159?p\188\227\202a\134-\023\214\163\136\129\212\128\212\130\244\128\193?\134\127\000\001\196\0024\008\012\142\2239\206\240\244\214S\006\023S\015\006Av\132\215J\251\178\024\024x\024\024\"\141B\224b\207\222\189`X\188{1\195#\166G0\131X\000\002\136\tH0\128\013\003\226G/\0311|\255\195\008\012\015&0\238\218\187\140ALS\149\225;\199_\134\188\181\237pq\144\026\144Z\152>\160\025\140\000\001\196\0045\145\001\2302\006V~\006vvv\006\014\014\014\134\005\135'0\156\184\177\147\225\213\167g\012+\214\2473\252\004J\131\228@j\1601\001\211\203\008\016@\016\131\024\017\152\133\149\149\129\141\141\141\129\021Hsp\n0\008\241\2032\008\242J\131\189\247\246\231O\176\0283P\014Y\015\016\255\007\008 &0\131\005\138\153\1296\178\252``aaa\184\240\236\014\195\147w\023\024>\255}\201\240\253\255;\176}e\235*\192r\220\172\191\193j\225\250\128f\000\004\016\208\211PS\153!4/\0073\195\255\191\255\025\226\230\13530\\b`\248\253\233\023\195\215\215\159\024\024\15820\236\216\186\024\028F\194\220\028(z\128\152\017 \128X\224\006A\189\008\138^&\022&\006w\221p\134l\231\026\134\238\173\181\012b\252\210\012\025\165\249\012\199o\030c`\248\005\012\018\198\255\136D\006\210\0114\003 \128X\128\012\022\228\196\247\253\247\127\134\127\255\2541\244\005V\130\2492B\170\012\015^\191eH4v\002b_`R\252\203\240\226\227'\132\229\012`\131\152\000\002\136\005\152\028\223\000C\253\031\216\161\223\025\152^\191\250\204\248\146\251\229\127\152;E\254q\252g\225\022b|\249\242%\003##\227\127\160%\140\239^\127\005\218\008\212\245\029\026s?\024~\002\004\024\000\200B\222\026\154\201\026\241\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ng.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002mIDATx\218b\012-\176~\160\166\164'\160\169d\194\192\193\193\203\240\247\031\003\195\143\159_\024\188,|\025\176\129\157\167v2\176\176\1782\176012\252\248\241\153\225\250\1893\012\183\238]\250\000\016@,,\172,\"\143^\222\228\214Q3d\144\018\019g`d`b\248\245\231'\003\023\023\023V\131\228\165d\024X\152\153\025\2543\252cx\248\236\003\003P/\208`\022\022\128\000b\249\251\159\249\015\011P\251\173\135W\024X\153Y\025\024\153\152\025\190\255\248\202`\160l\138\213\160\167/\239\128]\196\240\239\031X\015\003P\239\159\127L\255\000\002\136\229\247?\014\006f\144A\143o1\188\255\252\129\129\145\145\129\225\211\2317\012n\166\193X\013:pv;0\008\128\174\253\207\200\240\250\195+\160\1878\128>\248\203\002\016@,\127\254\1793\252\254\199\204\000t\008\195\139\143_A\2303|\248\244\138\129\137\137\t\171A/\223\191e`\231\252\013d\177\002\013\225\0019\140\225\207\255\223\140\000\001\196\242\235\031'\003\227\1276`\2000\002!\016\252\251\195\240\235\255;\160\173\028X\013\250\249\159\135\225\255?>`\016\176\002\195\t\168\252\255\127\134_\255\1903\002\004\016\011\216/@\204\008\196L\204 6\208H\160kXA\225\128\005\128\228\152\152!j\254\253\253\207\000\182\157\145\233?@\000\177\1763}g\224`\254\195\192\194\194\200\192\204\252\031\236\181_l?\128|\022\172\006q\177}e\224`c\001{\237/\208\242?@\023\253c\250\201\000\016\128.2H\001\000\132aX7\231\254\255\\\135\147Z\188{.\164\144D\140BF\171\024\031\140<H\129\127\142\166\182\028\011n\173K\194%\189|\219\021@,l@\211X\129\222af\004\0068\016\254\005:\245?\003>\192\008F@\149@=\192\144f\004Z\204\244\135\001 \000\155d\144\003\000\008\1940T\162\255\255.:g\031\224\153\004\182\210\028\129F\006\028\155\247%\174\017R3$\253a3K-\190\015\006\023Wi\210N\127\002\176H\006+\000\1940\012m\202\252\255\239,x\145\194P\2155v\178[n\201\227\165\141\017g\138\230\172\209\th\004\225N\154\217/\177$\144\171eg\191\004u|9\026\168\185\208B\238\254>\159\000\003\000\te\212$\015g\011i\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ni.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\0024IDATx\218bd\144-\127`n\164\"\224h\169\202\192\199\195\197\240\255?\019\003\003\0033\016\003\233\255\140@\026\132A\224?\144\t\196\012\255\128\248/\003#\227?\134O_\1901\236?~\155\225\228\185;\031\000\002\136\133\129\137U\228\228\165\023\220v\022*\012J\242|\012\204\204\204\016\205`\003a\1340 \025\246\015L\255\253\251\151\225\236\149\175\012@\189@;YY\000\002\136\133\225\015\203\031\006F&\134#'\0300\176112\176\178\178@\013\192a\016\003\196\160\223\191\255\128\2450\252\006\185\156\249\031@\000\1770|d\005\234aa8\190\255\025\195\211\219_\024XX\152\160\154\128\1340\130\228\254C\244\003-c\248\251\011j\024\003\195\159?\255\024\030=\249\004d\001-\254\247\151\005 \128\024\175_\191\254\129\151\151\151\159\133\005\232K&&0F\005\031\128\248\007\016K\160\136\254\251\247\015\140\255\252\249\195\240\246\237\219\031\000\001\196\194\200\200\008\014\023VVV0\0132\008$\198\008\242\213\223O\012\137\215?1|\249\245\155a\181>\2085\204<\192\200`\004\226\255`C@\225\004b\131\220\011\016@`\131@\154\145\013cd\132\134\013P\211\163\251/\025~\252\251\197\192\170+\207\192\192\193\006\2462H3\200\016\016\128\250\226?@\000\193\013\130\025\006s\021\024\176\0083\028\011\211\00728\128\152\019\136Y\225\222\002\001\144a0\031\000\004\016#\003[30\016\216\248!\017\196\132\1361P\026b\229\006\210?!\225\203\196\014\140\161\175Hi\tJ\131}\246\237'@\000\1770\136\129\221\007T\192\012\137%\016\254\207\002M\148 \204\005\011^\168\139\128^b\252\003T\243\027\138\255\130\133\000\002\136\133\129\229\0150\186\128\138\024\12962\176A\188\193\200\0015\140\005\234J\152A\127\160\134\252\128\186\252?\1960\198\191L\000\001\196\194\240\239\215\027\160M\255\024\254\179\002C\153\149\137\225\255?\160\138?\160$\012\nU\144\171\254C\252\t\178\236\031\144\253\007\193\006\025\002J\026\127\191\254\004\0080\000\202c\196\169\217\t!\220\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_nl.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\224IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\25410\252\001\137\191=r\132\129\153\141\141\129\145\149\021\167!\200\134\253\255\253\027\172\007l&\003\195?\128\000b\001\153\002\194o\143\031g\248\241\244)\003\019\011\011D!>C\128\248\223\159?\012_\031=\002\025\194\240\019\232\"\128\000b1\190~\157\129\151\151\151\129\021h\000\019\019\019\003#\008\019p\0178\012\255\253c\248\007\196\191\129\006\190}\251\150\017 \128X\254\253\251\015\177\135\145\025h\00830\136\152\192\001\t\018cDs\215\127\168{@\017\242\151\001\024(\255\255\130=\246\247\239?F\128\000ba\005\202\177132\176\17700\176\1782\001\013b\134\026\132\199E \131\128f\252\254\253\151\129\241\031P/\019\227\127\128\000b\001y\137\141\133\149\129\157\149\157\129\013\024\216 \131@^\196\007@^\250\0114\137\t\008A\014\003\153\001\016@@\171\231\127``\224\226\007\198;P\t\200\000\024\141\018\217H\161\0036\n\018Wp\250\227O\128\000ba\134k\001if\133b\152aLH\134\253\135j\132i\254\013\198\255\193l\006\006\128\000\002\026\244\155\133\017(\201\008\214\192\002\148\192f\024\003\134!\144\136\248\003$\255\001\241\031&\128\000\002\006\241\2077@\205\160(\000\234\252\015\212\245\023h\226\031`p21B\189\n\212\241\159\017b\200\127 \227\015#\196\128_@\241o@\250\007P\252\243O\128\000\003\000?a\161\168\130\219\180\163\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_no.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\197IDATx\218b\220\167\160\240@\196\208H\128\223\194\138\129\137\157\147\129CV\144a\023\139+\195\183\223\012\012\001\172'\025\190\223}\192\192\192\198\193\192\200\000\002\255\025\024`4\211\127\134\127\159?3|<q\140\225\205\249s\031\000\002\136\133\131\145Q\132\225\210%n6ss\006\014EY\0066\t~\006yf.\134\031\127\024\024\184X\196\024X\025\129F\176\176\"\012\128\177\254\253a\248q\229\n\003P/\003\208\012\022\128\000ba``\254\003\146\248v\230\012\208VF\006\166\127b\012O\152\013\024\190\000]d\202\241\144\225\231\141G\012\012\236\236\012\008\0001\236\255\159\223`= \240\143\129\249\031@\000\1770~\253\197\192\200\196\192\240\227\232\t\134\127W\17530ZJ0\028\148\244bx\243\157\129\193\239\207j\134\207{\17530\240\242\163\024\0046\234\207_\134_O\15920\254gd\248\247\247?\011@\000\177\0088\2323\240\17833\176\000\253\204\244\253\011\003\147\138\030\195\247\215L\012\239\223\000\131AS\139A@\231\021\003\0037/\146A\144\208\250\247\015\136\181\197\025\254\252\003\026\244\2537#@\0001\154\133\222\248\192\202\206\207\207\196\204\006T\195\204\192\195\202\196pk\207\007\134\223\191\2553\232z\n3|\253\003\241\012#\138\139\128\240\255? \254\011t\205/\134\159\223^\253\004\008 \022\006``221\00113\208\t\172\012L,\204@!6\160\198\255@sY\225\00602 \251\014h4\208\016`\224\000\189\006\210\203\244\031 \128X\150\176T0\008\002c\005\232;\006\182\159_\024\152\245\012\025\178\249\155\024\030\001}\180Q\171\159\129\225\204\030`\024\241\160z\011\024.\127\255\253g\248\245\151\145\225'P\232%\203O\006\128\000b\249\176\007\024[L\140\012\236\192\000g\003\166\011\209\143\015\025\190*\1830\252\004\198'\211\249\237\012\239\214\158b`\016\016F\1371\160C\024\254\002]\245\011H\255\004r>\252\253\199\008\016@,\012<\192\196\198\012\244\030(\189\000\189\200 %\003w=\131\152\028\003\003\207m \230C2\232?\200?\160\132\004\164@\024\200\254\243\143\001 \000\011\228\182\002\000\008\131P\1371\232\255\191\182\150,[{\020\241\194\209.-aZ\209\221w9\012\203\137\016\002\238\137#\015\233]TP\212A\176\212\007\175\212\184\002pHm)\000\1310lU\239\127Oa\130\160\136NM\140\251i\191\146\230\209\208\2017\003\008t\222\1509\212\199\n\"\155v\212K$y\224\188\149\240\170\214}\252AirK\204'J\225\199\017`\000\141\005\000\184\027\212~\179\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_np.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001wIDATx\218bhn?\223\255\255\255\127\006J1@\0001\203\255\019\222\241\233\233\175\006}[\213F\006\n\000@\0001K=P.\204\127\183\148\163\227\244\255\134=oxV\187\024\137\190&\199 \128\000bz\197 \202\240\243\194\005\134\212\159G\025^uG^u\1418_K\142A\000\001\196`\194\218\252\225,\003\195\255g/^\252\127\146\021\249\191\152\153\225\191\154\232\134k\164\134\017@\0001\253\250\251\133A$.\130\225\207\175_\012\255l\131\024\242\152\152\025\022\188\014\2084g,\250\159\215}\134\159X\007\001\004\016\131\tC\211\135S@\023i2\228\252wf\142\252f\207\224\245?\000\136\189\025\196\25433L\251\239\030\177;\154\024\023\001\004\016\131!C\223\135\155\012\140\255\157\024$\254\139\024_\159\136\174\160\191\239\16081\006\001\004\016\1311C;8\140\238i\n\253\239a\224\253\175\206\181\246\0049\233\008 \128\024\244\025\018>\220\209\019\252\255\224\241\227\255\015w\239\252?\023h\168\000\195\204\255\164\026\004\016@\012N\012\225_\03013\254\127\180g\213\255G\129\230\255\031\000\013\186\013\196n\012V\255\243\218N\235\018k\016@\0001\1381t?\176`8*\240\146\225\023\003\011\0033\003\019\131\012\003;0\022D\024\174\242l`\240b\182\t7\012\223\189\194m\021\161H\003\0080\000'\195\129Q\028\252\016N\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_nr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002'IDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\255\127&\006\006\006&\134\255\012\140@\026\134A\224?\0243\130\233\127\012\140\140\255\024>}\250\193pp\255\019\134S'\031|\000\008 \022\006\006v\145\211'?p\219\218\2012(*\2412033!\025\0003\132\001\1970\016\254\251\247\031\195\249\179?\025\128z\129|v\022\128\000\002\026\196\242\007\228\130\163G^1\176\17711\176\176\178 \025\128\233\"\024\251\207\239?`= \189\012\012\204\255\000\002\008\168\011\232\029\0066\134\147\199?1<{\250\135\129\133\005\217\021\216\\\004\001\127\254\252gx\252\232\027P\132\029\200\251\203\002\016@@\149\199\128n\227\225\135\152\204\008\244;6\003\0240\012\252\255\031f\240? ~\255\003 \128\024\251'\219~\224\226f\225g\001\186\141\153\t\226\021\022f\1604P%##\019T!T\251\127\004\013\194\127\255\001\189\008\012\152O\031~\253\004\008 &\144\229 W0\001\013aaae\248\249\247\015\195\233K\031\024^\188\253\197\0002\028\228Ul\152\153\153\017\172\007\236\003`$\003\004\016\144\002\005;\031\208kl\176\128cH\201\144f\1523\227\011\144\253\150\001\020\134\200a\003\001\255\160\024\232\028\134_@\252\230\007@\0001\1781,\003\026\196\197\015\180\135\225'\195_\134}{\140\024\028\157e@\001\008\180m7\003+P\156\025%\230`\244_0\254\0076\236\227O\128\000\002:\225'P\217O \2317XIW\2513\176m\179g\191\000\210\172@9V\1606\016f\001\187\022\018\0170\131~C\245\254d\000\008 \160\139f}ad\224\229f\004{\129\131\225\007X\003+\216\155,`\2150\163y\007f\000\200K?\128F\130\240\251\223\000\001\004\212\245\243\013\208F\160\138\255@\029\255\153\216\025\216\024\2550\252\005f\020f`8\254\006*b\006\197\017#\196\144\255@\198\031FP\216\252g\248\005\020\255\0066\136\129\225\243O\128\000\003\000\0114\184\182\023\212\172\000\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_nu.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\189IDATx\218b\156\027\150!o\235x\142A\226\239W\166\020\227\231\015\222q\239\190'.\202\250\193JQ\244\167\024\131\172\198.\006\016\248\015!\255\253\251\242\245\235\254\247\239\239\002\004\016\203\132\023\202\005\023\175\164\198+\253\145\210\250\248\230\028\015\183@\186:/\135\152\210\149\215\204\239\222\191T\231\146e@\128\127\191~]\250\241\227\008'''@\000\177\204|:\243\211\149O/\021\239\137\255\210\184\162'\196\254\237\191\228\131Oo4\184\132\175~V\023\253\254\219\224\031\146\182?\191~\029cd\0042X\000\002\136%E\162\169q\130-\239\231\179K\1423H\236?\248\153C\250\178M\138\250\219\2273/\254?\196\241j]h\019\194\174\127\127\254\254}\001\212\198\200\200\008\016@,\237\174\140\\\179'\168nz\243\141\193\224M\237\205\013\231\238y\245|2\n\208\156o%dye'3\243\019\136\158\255\255\161\154\193\218\152\000\002\136\241\230M!.\254w\\\172\012\204\204 \004v\003\195\207\255\012\236\140\176\176`\132j\251\251\023\132~\255f\248\248Q\008 \128X\128\234\216\153@\026XY\017\218X\025\208\001P\027\019\019\136\001\212\tT\003\016@@m\255\152\152\160V\177\176@\1811`\211\006\246\030H3P\011@\000\17700|\000;\023\138 Fb\002\160\006\184\026\160\022\128\000\002jSf`\248\194\192\192\012\150e\130z\133\001\217\210\2550\018\018\025\127\025\024x\000\002\008\168\237.\208\001p\244\239\031NG\194\017\003\195K\128\000b\249\246\013\228\165\031?@A\002t!\030G\002\0170\024\129\008\168\005 \192\000e\213\176\237\229\218SA\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_nz.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\006IDATx\218b<\227\239\250`\234\191D\001qm]\006>\001v\006\031\1613\012\219\191\1522\252\249\206\196 \196\253\147!D\225\005\195\172\171\178\012\140\012\255\193\152\001\136\2553\252c`d\252\199\240\229\211\015\134\131\251\1590\156:\249\224\003@\000\1778\\\140\0199jq\133\251\147\166\008\195S!K\006Ev\001\006\165\255\146\012j\028/\129lV\134\157\031\012\024\212\212~20A\013\249\007\196B\252\255\025>~\250\199p\226\212O\134\211'?\000\197\217Y\000\002\000I\000\182\255\003r\016\253v\206\242\011\008O\014\210\000 \015\243\000\234\225\220\000&\002\232\000\021\242\219\000\203\227\002\000\015\232\212\000\202\227\016\000\236\235\246\000\234\235\247\000\236\246\254\000O\007\213\000\252\251\246\000\153\173\245\000\229\227\245\000\001\000\254\249\002\136\229\211\031.\134\223\191\249\025\254\\;\207\240\241\213\015\134\167\015.20\168\15410\255\127\203p\242\165\021\003\239\219;\012\139^\t\002\249\127\128\174\001\186\137\241?\195y-.\134\199O\1902\156\189\240\029\200\231a`\249\255\135\005 \128\024\185d\182}8b\249\136\255\248\175\223\012\217WB\024\222\240\0271\136\254\191\192\208$\182\134!A\244'\131\220\025G\006\134\155\207\025\024\128abo\200\200p\241\250?\134\015\192\240\251\207\196\194P\231\250\018\028V\141\187\184~\000\004\016\2119\143;\012\229\151\164\024\1787Z30<x\201\192\198\197\196\192\251\2489C\237N[\134\248S\218\012\159#\206\0035\t0\240\200\2022LR\190\197\016\227\193\011\012%a\006\134\127\130\012J\\\188\012\170\\\\@gr2\002\004\016#\003\195v`h\241\243\179\130\157\205\202\240\135\145\157\129\233\255o\160W\2543\252f`\001\186\228/\200\233@qf\006m}V\134'\247\2541|\254\244\151\129\013\232\209\031L M\191\025X\255\191\249\001\016@,\204\012\223\025\152\129q\194\008\210\244\255'\003\227\255\239\160\192\003b`\\\000\241?`d\129\2123\001\233\171\023@\170\254\131T\130c\143\237\223? \253\007\168\246;\003@\000\001\013\250\001R\0061\008h$\0082\128\141a\000\211\204p\022\003\003\007P\243\015P2`\226\006\154\244\005\200\255\013\020\253\003\196?\025\001\002\008h\025\208\021@\204\000\022\252\011N+\016m\204`\187\2553\176B1\011P\150\153\129_\134\151\225A\244\030\134H\243\247@\237\255\161z\1272\000\004\016\208\025\191Y\024\192\017\203\000\215\204\192\192\nfC=\005\149\251\007N\142\223?02pq\2411\252g\231\002\243!z\2550\001\004\016P\215\2077@\027\129\188\255@\157\255\129\186\254\002\157\243\007\024\212L\140\016C\152\255\131\162\001\164\001\024\233\255\255}\253\195(6[\007(\244\229?\251\255\175`\20720|\254\t\016`\000j[\028c\136 r}\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_om.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\213IDATx\218b\156\199\192\240@\202\206^@\220\202\146\129\133\143\143\225\031#\019\195\223\127\127\025\164\210\210\024\254\255\251\207\192\000\194\216\000#P\234\239_\134\207\159?1\188}\251\246\003@\000\177\17610\136\252:z\132[\184\169\137\129\147_\136\225\199\157\027\012\255\128\234\184\185\184\024\254\255\199c\016\195\127\134\031?~00222prr\178\000\004\016\019P\211\159\255@\147\255ij0\252\250\249\141\225\203\213\171`\252\247\207\031\134\191@\241?\255\176\227\223@\185_@5L\172\172\012\255\153\152\254\001\004\016\011\003\019#\003\171\177\021\195U9\005\006n]\029\006Fn.\134_\143\0313\008fe\129\\\015\181\027\2211\255\193b\127\12843\011\011\208\155\140,\000\001\1968\159\145\225\003\015#3?\019\208\022&\160$\011\011+\003\2089`\245\127\161\1340bx\138\001\236m\144<H\229G\006\134\031\000\001\196\002\n\130\191\255\25520C5\252\255\243\027B\00313\022\003`4(\028\153\016|F\128\000ba\132\n0A5\194\012d\193\025\196\008\131\254@\213\002#\236?@\000\177\1284\178\"a\022(\022\131(\192i\016\200[\191\129\248\007\016s\0011@\000\177\1924\194\012\002i\150\002b\197\155P\029_\176\004\210?\168I '\253\004\226\183\012\140\000\001\196\002\243\018\019\146z\176\183>\003\241\007 \254\133\154\008\225\206\250\011\197 \249w\012\012\000\001\0042\136\005\022C0\181\191`\006\253\128\186\159\001\205U0\255\253\129b`\132\003\004\016\011P\237\027P\250e\132:\012h0#+H\217;\160\214/`E\160D\195\0085\236?\156\004\169\129\133\248\023\134\159\000\001\006\000(\225\178\223\161\232\139\188\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pa.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\140IDATx\218b<z\244\232\003aaa\001^^>\006&&f\006 b\248\247\151\001\002\152\024\129b\140\012Og\205b`\132\n1\1940##\195\239O\159\024^\238\223\207\240\226\228\201\015\000\001\196\194\201\201)\002\020\228\230\228dc`c\227`\184{\247'\131\138\n;X\211\223\255\016\013\194jj(\006A$\2552|8{\150\225\199\201\147\012@\213,\000\001\196\002\148\250\195\194\202\196p\231\246'\134;w\2231\220\186\245\149A]\131\143\193@\159\135AR\146\157\225?\208\160\207W\17520!\027\002\004\255\127\255fxw\228\008\152\253\015\136\000\002\136\005h%\195\191\255\140\012\2102\204\012\2455\015\025n\222}\205 %,\196\176n\1716\195\183\031?\128\222cbx\186h\017\138A\255A\248\207\031\134\175\143\030\129\012a\248\013t\017@\000\177\176\17823\176\177\178003\1790\232\024\t2\248\135\1371\220\188\253\011\168\159\137\129\133\t\164\149\137\225\235\253\251\012\204h\006\253\251\255\031l\008(8\255\000\165\000\002\136\133\149\133\021h\016;\003+++Cu\165,\216\000P\18402\"\180\178\0015\253\002\027\t5\004\138\255C\012\001\185\136\017 \128X44n\002\153<@\204\n\196,Pi\152\022\016\230d\248\249\243'X\227\031\168\008\003\208\224?\192\192\254\011\012\167_@\185\151\175^\253\007\008 `l\255\001:\2517\208\136_@\252\003\137\254\t\212\001\194/\025XX\128^ga\004\211\236@\252\174\1279\003\02733\216\245\255\254\001\189\248\247\031\003@\000\1770\131\021\003\005\193\174a\134bD\252\252\001\134\002H\195\255\127\255\024\190^\185\201\240z\234L\134\231\179&2|\185v\146\129?!\134\129Q[\021\020\240\140\000\001\196\004\178\149\017l\216oh\208\253\135\026\196\012\245*+<\132\185\2454\025~\1568\002V\249m\215\006\006.3}p\234\005\169\006\008 \160\202\223,\144\160c\000k\254\015\215\012bC\012\252\011\012\143\223@\252\015\200\231\246\207`P\206\023e\248u\243*\195_\160+A.\005\198\013\019@\0001\1781L~\000\012l!F\006v\160\0198\128.d\003\234f\005\006'\019#\200\174\191\192\144}\250T\139\24170\221\252\249\005\020\230dad\004R\191\129\129\243\231\211g\134\223\127~3\188}\251\246'@\128\001\000\251\154\225\245g\248\236 \000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pe.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002@IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\223\255\255\012\127\025\024\024d\211\210\024\024\025P\193\127 ~:k\022X\156\137\145\145\225\247\167O\012/\247\239gxq\242\228\007\128\000bag`\016\249q\242$7\155\157\029\131\128\146\018\003\00333\216 ...\172\006\t\171\169A\196\255\254e\248p\246,\003P/\003\208\012\022\128\000b\001J\254\001\137\191;r\132\129\153\141\141\129\145\149\021l\144\160\155\027\0036\240\229\234U\176A\255\127\255\006\235\001\129\127@\004\016@\140\139\024\024>p10\2403\003\005\184\229\228\024\024YX\192\006\025\1578\001V\180e\223A\134\191\255\152\025\252]l\192.\186da\001q\221\159?\012_\031=\002\171\253\196\192\240\029 \128\024\231\003\013\226\006\026\196\002\2427\0163\002\253\206\011\164\127\\\187\206\240\235\203s\006\134\207_\025\254|}\195\176\239\246E\134\212\184j\134w\162\162\012_@\006\001\195\018\232\018\176w>\002\149\003\004\016\211?\136\211\224\128\017\168@\153Y\144\161~\242B\134\139\175\2543|\145s`\184\250\244/\131\151[\026\195\182\173\151\025X\153\216A\166\192\213\131\244\002]\197\008\016@,\140P\151\12803\020\131B\137E\214\138\225\219\250<\006\127\191+\012\239n03\236y\162\203\240\215c5\003;\208 \150\191?\224\150C\245\254\007\008 \022\136F\004\006\241\159\253\249\200\176\182\204\139AJ\205\151!\217>\156\129O\146\159a\213\221\143\012\219,\149\024\206\252\254\200\192\001q\005\195ohL\130\244\000\004\016\011(lX\144\012\002\217\240\025\136%\153\152\024\254\223\249\015f\243\000\241\014\168\011~B\2133!y\013h\016#@\0001\193\188\004\014h$IX(\240\"\137\255G\018gD\n\014\016\013\016@,L\016\011\192N\133\129\223\224\244\246\023k\130\252\141\196\135\233\001\026\198\004\016@,?\024\024\222\252\007%(\168\225@6\227/\160\158\151/_22B\146\0030\166\255C\204\004\178_\002If\136\139\254Cc\012\148\142~\002\004\024\000k\017\183\249\006\210'2\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pf.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\021IDATx\218b<\195\192\240@\208\204L\132\199\209\241\015\019??\003\195\255\255\012D\001FF\134\127\031?2|\217\191\159\229\253\169So\000\002\136\133\131\129A\128\249\212)nV;;\0066%%\006Fff\162\204\249\255\247/\195\1753g\024\128z\025\128f\252\001\008 \022F\144\225@\252\251\200\017\006fvv\006\006\022\022\176m\016\192\194\240\159\025\200\255\251\003\168\006H3\252\129\154\002t\245\159?`= \149@\030\019@\0001^\187v\237\003\015\015\015?3\208%, C\192\174\134\025\244\151\225\211\1575\012?\005\253\025D\133\127\000\249\002Ps \222\255\0034\236/\208e\239\223\191\255\014\016@, MLLL\012 \131`l\008\248\t\196\185\012\012\025\175\024\024Y\23130\237\020\004\242{\128X\022,\251\239\223?\176\030\168\161\140\000\001\0046\008$\192\202\202\n\166A\006\129\196\024\025[\025\024^\172cx\149x\135\129\139\231-\195\175M9\012|a\197@\141\027\193\154A\006\129\\\0033\008 \128P\\\0043\012$\150?\161\131\129e{1\195\219\159\223\024\222K\0240\200n\234fx}\215\146ae\029\196k C@\000\164\023\136\255\003\004\016\220 \152a0WU\19620\164\\\148`P\228\251\199 %\201\200p\156\193\154\161\195\159\t\028\023 \215\128C\016h\024\204\007\000\001\196\132H\022\140\012\200\134\202K21\204_\202\204\240Q\134\149\225\214/\022\134\214\185,\012\182\166Lpy\152zh\2243\002\004\016\227-\006\134\015\192`\228\007\166\005\0066p\132\003\157\0113]\020\202\249\011\149|\006\017\254\007M\008\191\128\024\020\151/\1281\003\016@,\176t\252\015\138\255B\210\005\004\188\198\158\024\255!a\006\168z\128\000b\249\006t\017\208RV\168K@\145\207\200\004\145\003\187\155\017\146\252\224l\160f\198\255\016C\254\131\\\245\027\168\231=\208a\000\001\006\000\195\130\168\147\020\211T\220\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pg.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\0024IDATx\218b\212f`x\176\216\220\\@\216\209\145\225#\031\031\195\255\255\255\025\25430\1281.\192\004\"\024\025\025\254|\250\196\240r\255~\134\023'O~\000\008 \150\171\012\012\"F'Or\239\180\179c\176VRb\248\194\204\204\240\027\135A 1\022V\006\006n\003\006\134\247'\2542|>{\150\225\199\201\147\012\236@a\128\000b\001\202\253\001)j8r\132!\152\141\141!\156\149\149\129\019\200\127\141\1970\022\001\006\006.W C\144\129A\192\2437\195\253\137G\192\226\255\128\008 \128X`\138\142\031?\206\240\244\203W\134i?\1903\164\255\253\203\144\008\020\187\003\196_\161\006\242\02420\200O\135\176\127\254`\000\219\207k\255\136\225\245q\006\144\015X\000\002\136\005\217Fi~9\134\251_\2382T<\184\1950\021\200\223\n\018\003\226\203@\252\238>\003\195\227u\012\012\186]\012\012\162@[n\004\252g\248\203\0011\248/0\196\000\002\136\025HWh\232{r\252\255\255\151\225\214\245S\012_>\188aP\215ub\184\015\012\244i_?0\240\001\021D\003\241'\006\176\205\012\175v\003]\185\139\129\225;0p\025D\129\244#\006\134o@\179\000\002\008\028\001\127\255\252``bB8\238\223\191\191\012\130@\012\002M@\172\003\196 \003\173\129\152\027\136?^\000\198\1560\003\0033\023\144f\002\199\226\127\128\000b\004\138\127\000b~\152!\172\172l\012\172l\236\012\223\190~\198\136\181F \174\001\226\011 \175\002c\23970\148\127\002\237{\199\192\240\003 \128\152\208\021\255\249\243\155\225\247\175\031X\211O=\016\235\001\177\024\016\027\001\253\201\n4\004\228\015`\2480\002\004\016\138A\140\140\140`\250\247\239\2238\019#(hd\129x.\016[\000\177\0004\129\002\004\016\008}\129\198\240\127W\143\192\255\202\170:\176\132M\016\171\001\2419 >\198\192\240\011 \128@Nx\000\196B \023\178\177\1773\253\249\251\151\241\223\223? \133\140H\t\026\023\027\0122\128A\005\016`\000 \231\182\227\178\142\027j\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ph.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002EIDATx\218b\1566\229\244\131\133\139_\t8:\1381\008\240q20\252gb```b\248\207\192\008\164a\024\004\254\1311#\152\254\199\192\200\248\143\225\211\167\031\012\007\247?a8u\242\193\007\128\000b\177s\216'\226\229\243\143{\251\150X\006A\145\239\012\204\204\028@c\208\013a@1\012\132\255\254\253\199p\254\236O\134\211'?\000\249\236,\000\001\196\242\251\151\214\031FF\014\134\160PV\134\183o\217\025V\173z\n6\128\137\129\025Hb\186\008\198\254\243\251\015\195\209#\175\192\174g``\254\007\016@\140\231\206_\254\192\195\195\203\207\194\196\196\192\205\243\029(\200\205P^r\151\225\208\209\215 \155\024\216\192\n\145]\004\001\127\254\252gx\252\232\027T\228\219w\128\000b<\127\225\250\007~\142[\252\236l\247\024\152X\2063\176r\185\002%\220\024N\156\252\195\224\235s\007\200\254\008t\027\011\166'\2553B\141\006\025\245\233\007@\000\1770\254\255\203\192\194\194\194\192\193W\200\192\204\002\148\248\245\145\225\207\127W\006\007{v\134\207\159\1913x\228:1\028\153\127\023\168\152\021-\204\254A\241o\144\028#@\000\177\128\194\129\137\137\017\024\200@.+\200\166\191\012\140\255\217\025\024Y\185\128\238\248\196\176\151\185\157\225\002C+\208\195\168\030\252\0115\226\023\016\191\003\n\001\004\016\011\0033+$\186\127N\005\210\167\024\152y\162\025\216\152\248\024\222\028\184\195p\2019\018h\216_`HA4\253C2\232\015\020\255\132\024\196\000\016@,\140\140\127\025\254\179\0252\252c\177``\228\138\007\186\142\147\225\150\151\015\195\243\157\219\0258\161q\002\211\204\132\228)&\212\004\194\008\016@,L\012\183\025X\216\165\025\152\217\213\024>\030\187\195p\211\209\000\172\144\003-\194\209\001#,\226\1614@\000\1770\179=\006\134\211c\134\027~3\025\222\238\159\005\140n\136\196O\180\008gD\163a\225\196\0001\140\t \128X\158\239\022~s.'\226\031P\002\020Z`\023\255\007\1339\132\134\233a\132\026\002\138tF\168a\255\255A\013\251\004\180\023 \192\000\201\006\183\192\013{\148\199\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pk.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\202IDATx\218b<z\244\232\003aaa\001^^>\00666V\134#\183\2391\\;\191\135\129\129\159\147\129\129\129\145\001\021\252\135\179\024\129R\159\190}b\216\127\241\016\195\201\171\167?\000\004\016\011''\167\008###7++\011\003\144\205 +\194\207\240GI\141\129\129\155\013\170\023\168\249\255_\006\006&\022\020#\255\254\251\195p\246\246\005\134\147w\2060003\176\000\004\016P\150\241\015\208 \134\159?\1272\176\179\1793\188x\255\156\225\234\237\171\012\012\130\028@\213?\025\024~\254g\208\208\176`\184\249\232\002\208\204\255\016\167\252\255\199\240\251\239o\134#\215O@\248\255\024\254\001\004\016\011\152\193\200\196\240\235\215o\134\031?~0\156\186u\153a\201\166E\012\0122\\\012\012/\1911\156\152\127\130\161j\245$\134}\199V20pp\131\013\225\226\224\001\235\185r\239\018\208mL@1F\022\128\000ba\004\186\139\137\145\153\129\153\005d&#\195\203\207\255\025\238?\187\207\192\240\156\129ab\215:\134W_>1\204mke`0\020\000\006\202[\006\134?\191\024\212\229-\025T\196\013\024\174\128\\\196\198\007\n:F\128\000b\001\153\204\196\204\194\192\204\204\n\012l6\134\239,\210\012\255\129\222a\016b`H\178we\176o(g\248/\001\nd\022HX3s2\220xp\148\225\198\189\195\012\012\236@E\255@a\248\143\017 \128X@\174`bb\002\026\196\204\192\202\202\n6\020\028Y\204\012`\254\175??@a\000\t\011\024`\005z\241/4\006!\194\255\001\002\136\137\017h\013\144``a\129\024\198\195\252\026\024\022@\169\175\012\0127_<g\184\208;\139\129\225\001\144\255\254\021\144\248\006\212\242\025\168\025\024\t\172@\211\153A\177\t\194\255\025\000\002\136\137\017H\000}\0076\012\228:\014\150\207\016\155$\025\024\244R\021\192\174}\255\226;\131\160\188\012\208\240/\012\234j&\012j\178\186@\181 \003\254A0\227_F\128\000\002\233g`\004{\254?\212\165\255!^\225\018\006\006.\144\239\206\198\240\249\203g\134ws\0313\252X\241\141\1619\172\134\225\222\235+\208\164\240\031\028i \239\001\004\016\203\255\255\255X@\130\255\254\253\003\227\159\127\184!f\254\005\202\138\13820|y\205 g/\198\192 \000\to\006\144\131\165\129\209\207\196\nI\172\012`\003\153\000\002\136\229\251\247\239o\128^\250\199\204\194\202\012d3\189\251\240\143\145\2257P\246;4\024\153E\2553H\002\197@\169\027\228\004`>`\248\005\203/P\215\255\250\255\019 \192\000\130\249\233\180\017\164\154f\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pl.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001@IDATx\218b<s\230\204\003AAA\001\030\030\030\006&&&\006R\192\191\127\255\024\190|\249\194\240\254\253\251\015\000\001\196\194\193\193!\194\204\204\204\205\202\202\202\192\198\198\198\192\200\200H\148!\255\255\255g\248\245\235\023\003P/\003\208\012\022\128\000b\001j\252\003\210\252\251\247o\176 )\000\164\007\164\023h\232?\128\000\002\025\004\230\252\249\243\135\225\199\143\031`\005\132\\\005r\013\008\128\244\128\212\002\189\200\002\016@`\131@a\003r\013\140Ml\248\128\244@\013e\004\008 \176A \001P\024\129h\144A0W\226r\013\008\131\012\250\251\247/\220 \128\000ba\212\208`\000\185\001\020:\172P\154Pp\131\180\254\133\178\153 \248?@\000\1770\"8`C\152\161l\188\222\130\210\127\161jAf\000\004\016\011L\146\017\138\153\1360\008f\024#\194\133\140\000\001DZ\n\196\003\000\002\136\005h\026\011\204\134\127P\231\254'\1945\255\144\188\008t\025\019@\000\177|c`x\003d\252\003\00643\208y\160\200gd\130\152\197\008U\004\138\0238\027\168\153\241?\196\144\255\127\128\244O ~\011\164\000\002\012\000\200\129a\tQ\217q\168\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pn.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003*IDATx\218b\156\022\158\244@\215?H\224\220\127I\134\175\031\185\024R\197\1741\220\253-\200\176\247\1574\131,\215\015\006K9\006\134\023\236\156\012\135\206\254f`a\251\199\192\200\008\196\012\255\024\024\128\244\231/\223\025\142\157\185\205p\246\194\221\015\000\001\000I\000\182\255\004\153\005H\020y\215\222\011]X\020\000\254\029\029\000\002\210\237\000 \006\017\000i4\013\000\007\017\020\000\228\251\007\000\243\221\244\000&$\248\000\004\004\255\000\255\255\001\000\001\001\255\000\252\253\243\000\211\213\238\000\197\207\245\000\002\254\012\004\002\000I\000\182\255\004\155\217|\252\250\193\249\000\234\238D\000\019!\029\000\246\002\006\000\002\255\251\000\253\005\007\000\238\011\020\000\024\242\250\000\024\n\001\000\143\2527\000\004\255\001\000\021\017\229\000\238\241\018\000\023\017\231\000\235\228\000\000\254\006\227\000\002\006\248\254\002\000I\000\182\255\001&b\187\240\162n'\015\029\230\210\000\209\236\022\000,\207\157\000\236\015%\000\008Y^\000\020\232\198\000\193\216\006\000\148\217\015\000\227\209\224\000\012\255\012\000\025<~\000\224\229#\000<\002\246\000\215\236\238\000\\:\225\000\143\183K\247\002\000I\000\182\255\002\1562\237\000\014\164\180\0008o\234\000J\133\240\000\n\245\245\000\225\207\221\000+C\204\000b\181\t\000A.\250\000p\242\209\000\223\224\249\000\216\227\255\000\209\197H\000\\\"\220\000\231\235\007\000\000\022\013\000\157\207*\000\243\2359\001\002\136\145M|\201\135_\204\252\252\012\156,\012\028\236L\012?\024\128\128\145\129\129\237\247\127\134_O\25420\200r2p\177\253\002\134\237\127\134\159\223\133\025\220l\188\025>Y51\136~\147d\248\200!\193\192r\163\155\225\2069\141\159\000\001\196\194&\200\198\192\204\200\196\192\204\196\0044\128\137\129\155\129\td\014\003#\208BveV\134\127\255\1281\244\159\133\129\137\137\145\129\153\2537\195\205\219\205\012&z\151\024\030\222\170c\248\199\237\205\240\252\145\008\195\215w\234\255\001\002\136\133\133\2413\0030\216\129f\000\013\000\026\004v\016\019\200\168\255`6\0193\003\028\176\003\197\223|Qax\178\235\002\003\171\214k\134\247\015\1430p~\206cx\249\157\145\001 \128\024\005\180&}\248\203\196\197\015\210\204\200\200\012v\021P;T+#\0203@\013\134\026\206\192\198\240\247\239O\006\022\160z&\150/\012?\190~\251\t\016@,\127\255\253\002\218\nT\204\200\nN\031\255\129\138 \154\153\161\006\194\012\253\007\197\127\025\254\254\255\t\180\239\015\195\159\255\223\025\024~\001\195\015\024\178\000\001\196\194\200\248\139\133\129\129\021b\231\127\016\205\0064\012\024@\012,H\1341\192\013a`\248\003\212\248\019\204\007\165r\006F\160\024\227o&\128\000\028\146I\n\000 \012\003\235\246\255\143z\020D\173\198\209K\153\150\016RH6\205\170]\142<%\250\026y/H\160\209>\196R\252\252\210\1783\022\236\220\029\193\194\180\155v\027W\128\001\000\252\005\020\147\199\1586\202\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\130IDATx\218b\148eH}\176\210\252\146\128\178\163#\195;>>\134?\255\2553\128\000\132\196\004\1400\154\145\145\225\207\167O\012\175\247\239gx~\242\228\007\128\000by\204\160+bu\210\149{\145\221'\134 %\030\134?\204\204\012_\144\012\250\143f\000\140\253\255\239_\134\015g\2072|=y\146\129\133\129\129\005 \128\128\248\203\031\006\134'\012\211\143\0242\220d\251\195\016o\207\203 n\"\198\240\247\213O\134??\254\131\172F3\242?\024\255\255\247\151\129[@\144AE\207\128\225\211\215\239\255\000\002\008\168\170\255\003\003\0033?HRNA\136\129\133\137\133\193.R\155\161+_\130\001\023\248\015\245\254\159?\127\024\254\002]\246\254\253\251\239\000\001\0044h6\208 6~)Y.\006\191 I\134\153\147\174\002\149|\007b&\134i\179\157\024B\213\17430\252\224c\248\196\192\205\192\012\180\012\236\190\255\140\012\255\128\134\253\251\199\0004\232?\195\155\015\031\127\000\004\016\208k<\012\178\138B\012\023\206\15200331\188\254\192\203\176n\209S\176\173\153)\247\0242\025\1581\2441\1322\152\000\245\127B\242\220?(\254\005\196@\1510\002\004\016\019\200\230\199\247?0\028>\245\141\129\149\149\141a\237\194\231@C\152\129\210@;\024X\129\152\153\129\003\202B\198,`\025\008\006\026\242\031 \128\128.\157\243\129\133\149\155\255\223_f\160S\1912\008\008\2423|x\255\016(-\204\176c\183+\131\171\198=\160O\133\1281\t\241\026\2165\255A^\250\195\240\251\247_\134\159?~1\188x\243\246\007@\000\001\013\254\198\240\007(\000\137T\014\160!\140\012)\189\177\012\179\139\132\161\030\129\004:\031R`\255\003\006\014(\160\127\253\250\197\192\244\227\007\003'\215\127F\128\000b\129\004,\200\129\234\192\152>\198p\189A\132A=\252:\195\151\245\031\024~|\005\186\128\145\t\154v\160!\195\248\023\232\" \254\251\155\225\023\016\255\252\243\027h\249G\006\128\000\002:c\0060\253\137r\1673La\152\192\184\159\225\013P\253]P\212bI\209\140H\t\019d\236_(~\199\192\240\027 \128X4\024N\188\153\205\176\224\159\012\208Y\187\25530\253\129$\193\255 \187\255C4\130R\013X?\019D?\220\172\255P\011\19120\252\004\0080\000\246D\2400p\213P\011\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ps.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\215IDATx\218b\204f`xx\198\220\156\223\209\209\145\129\143\143\143\225\255\255\255\012\196\000FFF\134O\159>1\236\223\191\159\225\228\201\147\031\001\002\136%\147\129Ax\193\201\147\220\127\237\236\024\148\148\148\024\152\153\153\1372\232\239\223\191\012g\207\158\005\025\002\226\178\000\004\016\011#\003\195\159\\ k\211\145#\012\151\217\216\024XYY\1372\232\247\239\223\012G\128z\160\224\031@\0001^c`\248\192\195\192\192\015r\199|99\134\213\"\162\012\255\254\253\005J\225\247\226\159?\127\024\158<y\002\242$P\253\255\239\000\001\196x\029h\016/\208 \022\160\016\019\200\223\te\012\140u\192\144\251\255\015W\2320\128\172\248\247\239\031\004\255\249\199\240\230\237\155\031\000\001\004\242\026\003\2005 \0151\003\003Zl~'\003#\151:\003cg\024Vc@\145\001\194 C@\225\244\235\215/\1607\1911\002\004\016\216 &d\195@v\002\0210\176\176\130,\199i\024\200\016\016`bb\002\225\255\000\001\0047\008b\024\208ky5\012\204]@\215\252\255\206\192\240\031\187\215\254B]\243\251\239o\134\159\127~1|\252\253\157\001 \128\024o\001\195H\016\024F\028@%\221n\012\012\147\226\197\024\254\253\254\003\n\004L\131`.\004\137\003\029\244\255\015\144\241\011\024f\031\255\255\004\008 \022\152\154.\160!\205!@\198\231W`Ep\013\216\012b\128\024\004\198\127@i\129\129\001 \128X\128jY\250\156\025\024\218\253!\002`\205\140P\250?V\159!\212\19203\003\019@\000\177L\177fx;\217\149\225\031\195\007 \247\0310\168\024\145\148\254\135\187\139\017)\230\025\161\162\255a^d\248\202\240\019 \192\000\224<\180U\230I\174g\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pt.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\0023IDATx\218bd\152\192\240\192\\\198\\\192Q\218\145\129\143\141\143\225?\0162p20\132\174g`\248\206\192\192\240\143\001\0210\1940##\195\239O\159\024^\238\223\207\240\226\228\201\015\000\001\196\194\192\198 r\242\243In;\022;\006%A%\006f&f\006\006\022\006\006^5\176y c1\012\002\131\191\127\025>\156=\203\240\227\228I\006v\160\014\128\000\002ja\248\195\192\196\192p\228\245\017\0066&6\006V6V\006Aa\160\186\015\012\012\223\158\002il\134\128,\248\253\155\225\221\145#`6\208\213\255\000\002\136\005\198:\254\2508\003\203\255\167\012S\165X\024\182\221b`\248\241\144\129\225\131\025\003\195\207\t@\252\000\213 \144+\255\255\249\195\240\245\209#\176\215\127\003]\004\016@,p\183\003}d\204\251\136\225\213\028F\006\215;\161\012O\216\2551\136\254\216\194\192\188\234'\195\007Q4\215\128\236\254\255\031B3\128]\205\008\016@L0I5.\006\134pe\006\134w_y\025b>\206e\240{\191\128\225\221ke\134\255K\2543p[\001\181\252G\195P\0003\008 \128\152`\209\192\n4\242\005P\244\205\255O\012\191?\1791\252\248\197\202\192\246\242.\131`\006\216\177\160\240G\193 1&\004\254\015\016@,`\131\128\162W\12710\\{\194\192\224\228\202\192\176\228M\020\195#\022\030\0065\183\031\012O\215\001\2379\202\192\192\129\230\181?\144\176\001\179A\134\002\004\016\011\220X \152\015\140\169\012o\006\134\205lk\025\002\17500|\202b`\248*\015\t\031\022\164\192\254\135\198\006\026\196\008\016@L0\023\129\240\157\031\012\012\194\199\024\024\026\029\1291\182\155\129\225\017P\238\199#\164\152BJW\140P\251a^\004\008 P\172\177\192B\012,\011\164\239\223\000\134\213q\006\134_P/ G=r\018\248\139\136p&\128\000b\001\170~\195\240\005h\020\019\144\207\008%\129\198\003}\201\248\022b\208\127\152~ \241\159\017\148;\160f\193\236\255\004Lj\000\001\006\000\209\151\180\177z\184i\139\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_pw.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002]IDATx\218bd\1739\243\208D^\144\223Q\129\135\129\151\141\137\225?\003\016\128\t$\026\004\024\209\184@\254\215_\255\024\014<\252\202p\226\193;\006\128\000b\249\199\194!|\25253\183\1412+\131\162\008\027\0033H\005\204\0164\131\024\024\017\220\127@|\233\213/\134\163\175\19130\176p1\000\004\016\011\195\127\198? \227\143<\249\205\192\198\204\204\192\202\004Q%\192\249\145AE\224>\003'\2437\134\183?D\024n\127Pb\248\253\151\005n\216\031\160\154\227\207~\003YL`\011\001\002\008d\016\216\170\227O\2550<\253\250\131\129\005(\168/v\153\161\221\172\146A\136\227-D\023/\003\131 \179!C\213\137V\160\161B@\229\255\025\254\002\013z\248\225\015\212\207\140\012\000\001\004\212\007b\000Medfx\244\137\145\129\147\229\023\195|\131\018\006\017\174\139\012\200\192P\228>\131\143\138\018C\195\225r\006\006f\144#@\158c\134\006\001#\003@\0001\129]\244\031(\192\200\202\192\240\151\013\024N\239\025\140\196/0pp\252\199\192^\138;\025X9\152\025\254\255g\003\170g\131\232\001\233\005\154\001\016@\016O3\002]\196\004\020``e`daa`cc\192\n\216\217\128jY@\022\130\180\253\133\184\230\223_\176\247\000\002\136\t\024M@\0232A0'3\195\189O2\012W?\0273\000\205\195\192\219\159\2492\252\250\207\201\192\000t\021\003+\016\179\1280H/#\003@\0001\129#\001\228\024\176\129\140\012\223\255p1\228\029\153\204\240\234\167$\003\019\200\161P|\244\181=C\255\249\\\132\165 \245LP\012D\000\001\196\002\138=\1484\002\180\249\200cK\006\251\013\135\025\252Tv0\136r\188b\184\246N\139a\237m\031\134/?\185!\150\162\167-\160\025\000\001\196\200\220|\243\203_N!n\006\022`\1920\179\129c\015\028f\160$\242\023)\133\179B]\014\210\248\031\024c\255\129\146\255\128\138\254\254\004&\241\015\012\000\001\196\194\244\251\0270\1770\254\003\198\0000:\152\152\128\008\228\222\255`-\255\192\214\254\007G\203\015p\190\128\176\129\018\140\255\254\001\217\192t\244\023h\216\175\143\140\000\001\006\000e\163\172ib\029:\214\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_py.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\018IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\25410\252\001\137\191=r\132\129\153\141\141\129\145\149\021\167!\200\134\253\255\253\027\172\007l&\003\195?\128\000b\249\td\176\002\241\171\227\199\025\190=}\202\192\200\194\002Q\008\196 \1831\12952\003\021\131 \003\\\238\255\159?\012_\030=b\000:\132\225\027\208E\000\001\196bu\253:\003///\003\011\208\000&&&0\134\001\144\"\134o\143\025\024~\252b`\016Rf`Br\213\191\127\255\192\248\015\208\192\183o\2232\002\004\016\011\0190\208X\128\225\194\006\244\0183\144\006\025\004\nH\016f\184y\149\193\183\181\143\225\023#\007\195\206\130$\006\006CcHd\0001\200\144\191\192p\002r@\174d\004\008 \022\144\006\144f\144!\172P\195\192\134\128=\255\159A\132\137\159\2257\027+\003\235\015\160\135XY!\017\001\212\0126\004\228u\136/\254\003\004\016\220 \152a0W\129C\194\216\148aE+P\195O\160\215\180m\161\161\195\008v\013$\226\254\194}\000\016@@\171\231}``\224\228\135\004-,xa\161\001r\1290\148\253\014\136\127!\133\222?H|\129\241\167\159\000\001\196\194\012\142\007\160\169\012,P\141\172h\006~\135j\230\000b6$\003~\131\241\127\168+\001\002\008h\208o\022\160c\129L\144\129,@al\134\161\187\2267P5\200\128?@\242\031\016\255a\002\008@\"\025\164\000\000\1940\204\233\255\127\234\205\139\147I\141\2446\198\018J\0251r\002s!HA]\140E\157=,\025\016\nK\196Pa\193\209\255 \181\205~\229\019`\000\150\131\178\208\011o\204\013\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_qa.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002dIDATx\218b<s\230\204\003AAA\001\030\030\030\006&&&\006\016\248\245\237\023\195\157\147W\024\222\220?\203\192\196\206\195\192\192\200\008\020\253\207\000\"!\248?\0033P\233\175\207\159\025n\031?\194p\255\220\153\015\000\001\196\194\193\193!\194\204\204\204\205\202\202\202\192\198\198\006\212\195\200\192\244\247?\131\128 \011\003\023\155\006\003#\011\027\003\012 \027\244\255\223_\134\167\151/2\188\188p\142\129\149\145\145\005 \128X\128\026\255\1284\255\254\253\155\001h X\195\159_?\025\190\190y\195\240\238\254\013\006&\014.\168v\132! \250\223\159\223\012\247O\159\132\168g`\252\007\016@ \131\192\174\248\243\231\015\195\143\031?\192\018\223\191|f\184\185\127?\195\195\227{\025Xy\005\160^\131\026\007a2\252\005\170\127\247\228)\195?\006&\134\159\255\254\177\000\004\016\216 P\216\128\\\003c\127x\241\129\225\206\233S\012\159\158<\007\026\244\021\161\027\028R\144\208\250\251\255?\195?FV \205\192\240\243\255?F\128\000\002\027\0042\004\020F \026d\144\144\164\012\131\128\1625\195\139\219\151\024\216\254\011\193]\244\031\2210\144\023\129\172_@\014@\000\161\184\008f\02433\011\003\203\127\1608P?\019\194Sp\131\192^\003\233\003\186\n$\198\196\192\248\031 \128\224\006\193\012\003\225\191_?1\252~~\150\129\015\020\147L@{\025\255\161x\237\031\208\018\144K\128\129\204\240\027\200\255\205\248\151\001 \128\152\224Q\011\013t\144\129\252\226\252\012\018\234\170\012\172\191~1\176\002\181\1920\027\016\179\003\013\229\000\026\206\001\212\204\0014\n\132\217\129\017\015\016@,\012X\192\239\239?\129\248\023\195_\160\161\127\192\222b\002G;\200VF\160w\024\193^\254\207\192\194\008q#\027\227\127\006\128\000b\249\255\255?\216\176\127\255\254\129\241\223\191\127\025\190|\249\201\240\244\222C\134\239,\172\012\191\193\210\140`C@\154\153\128\154\152\254\253\135\134\221?\176A\192\212\199\004\016@,\223\190}{\003\244\210?`@33A\000\227\215\159\191\255\179+X2\190\185z\130\129\157\029\236\004F\006\176!\012\255\153\025\2543B\013\252\207\252\255\031\200\137\160t\244\019 \192\000\158\166\215\015\184\250Y{\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_re.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ro.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\138IDATx\218b\020\017\137}`l\172)`m\163\195\192\203\195\195\240\247\0313\195\207\031\156\012i\017\251\024\024~\17920\252cb\000\003F\006\134\255\\\255\025\222-\251\205\192\192\006\228212\252\249\242\137\225\221\145\003\012/\206\158\250\000\016@,\140\140\204\"\231\207?\224\182\180\210dPP\020d`dda\248\253\139\149\129\139O\141\129\225\015\208\144\255\140\008\131\216\129\230\170\253e``\001\178\255\255e\248|\241\028\195\207\243\167\025\216\025\025X\000\002\136\229?\003\251\031F\006f\134S'\2390\176\1772301\1792\252\248\206\193\224fq\149\129\225\023P\199?\132A \240\237\218\031\176\139\254\255\253\205\240\233\228Q\176\216\127\006\198\127\000\001\196\242\255?\023\195?\160A\167\207<cx\254\252\027P\003\011\195\199\015\220\012Y\001K\129\186\216 \174\002\001f\160\006\017\006\134WK~1\252\231\254\015\228\252a\248\254\2441\216\197\191\255\255g\001\008 \150\127\012\188\012L@+@N}\244\228?\195\191\127\191\025>\188\251\203\192\244\239\001\208\016\014\132A \189\255\128\193\246\224\007\195?n\144\193\255\193\206\004\145\255\25432\002\004\016\208E|@\023\177\003\195\134\025,\241\239?3\208P~\006\014V\160_X\152 N\129\185\008\024\246L\1600\251\255\031\228\029\176o\129L\160\030\006F\128\000bA\004\000\019\0243\1305\1780\176\178\130(FD\224\128\012b\003\201\000-\003;\240?X\248/4\030\000\002\008\024k_\024\152\024\127\003]\004Q\207\192\0042\240\023\003\0110\026\024X\255\194\205\001\027\004\180\150\157\241\0318E\128\226\000$\245\015h 3\144\001\016@@\199\127\001\n\252\000\026\006\148\000\154\246\031\164\026\168\011l\030\211\127\008f\1288\248?0\\@\178\127\025\129~a\002{\t\024T O\254g\004\008 \160\139\190\002\013a\005rX\160\225\193\012\245&\204\2030'\253\135\179\025\161\193\012\166\025!.\002\008 `(\252d\001i\252\207\192\n\014\004Pr`\000\198\228_`\234\002\199\024r\172\253\249\207\240\027d\004(\176\2553\130\189\005\014]\198\255L\000\001\004\140\181\191o\254\0033\006P\134\025\024\141L\127\255\130\228\024\255\191|\013T\249\005\200\250\011\214\199\008u\236\255\151@60\165\128\130\002D\129\013\251\240\159\225'@\128\001\000)R\226_\232\219$3\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ru.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001wIDATx\218b<z\244\232\003aaa\001^^>\006&ff\006\134\255\012\196\001F\006\134\127\127\2552|\254\252\137\225\237\219\183\031\000\002\136\133\147\147S\132\145\145\145\155\149\149\133\129\131\131\003\162\130(\240\159\225\199\143\031\012@\189\012@3X\000\002\136\133\133\133\241\015++\019\195\159?\191\024\254\254e\006K\0166\236?\195\255\255\255\193z@z\153\152\254\255\003\008 \160A\236\012 \252\255?#\195\175_\127 \174f\196o\016\200\016\008\205\008\214\203\200\200\194\002\016@@\029\203?00\176\243\195\189\206\008\177\017w`A\\\252\031E\250\203\015\128\000baf\224\0052\184\129\152\005\136\153\128\250\1530\188\1290\000\025\252\131b\176/\024\001\002\008\168\155\025l\008#\003+\003\132\205\004\213\132\207E\255\161\134\252\133\170b\249\015\016@,\127\193\006\176\0011+\194UD\027\244\007\202ge\000\008 \198=\012\012\031\004\025\024\248\217\161\198\193\220\196\128\197(F$O\253\005\226_@\252\019\136_\002)\128\000by\007\021dCr\015\019\142\224\134%\012\228\208\001\025\246\030\136\001\002\136\005\168\152\005f\250_$[\255\227\008jd\249\191P\012\178\027 \128X~00\188\001\n\254cD\n\233\255\012\224\216e\252\143\208\195\0085\004\152r\024`\169\236?\204\139\159\128^\003\0080\000\197\135m\006\143\149\029o\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_rw.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\228IDATx\218b\212\168:\243@OAP\192\\\129\135\129\155\157\137\225\223\127\006\006 \130\0008\003\n\024\017\204\223@\246\143\159\255\024\206=\248\194p\233\193\251\015\000\001\196\194\196\202!r\253\0133\183\185\n+\131\156\008\027\0033##\134~d\240\031j\160$\203c\134s\207\153\024N\191ec\224`\229`\001\008 \150\127\255\025\255\1284\159\127\242\155\129\149\153\153\129\133\t\2051\255Q]\243\013\136\029x\0142(r\156d\016\251\127\144a1{/\195\195\175\\\255\000\002\136\229\031P\005\008_x\250\135\225\229\215\031\012\204 \131\024\025\225\134 \155\243\031H\188\007\2102\"'\024\228\248\1510\252\251\252\132\225\255?f`p\252c\001\008 \150\223\127\128\006\253eb`dbfx\244\129\017H3!\007\005\006\248\013\196U\031\139\024\252\248U\025.\127\213a\184\254K\130\129\243\207[F\128\000by\255\025\168\237/3\003#3+\208Zf f\130\186\136\145\001\195\196\255\016\226\231\159\255\012\019_\005201\252e\224e\250\197\240\2273\003#@\0001\222\188\201\240A@\128\129\159\157\157\129\129\021h\02233\194g8\003\028h\224\223\191@\215\001\157\247\243'\003\195\171W\012?\000\002\136\005\164\t\232\0270\006\025\002\194LL\248\013\250\247\015B\131\012c\130z\000 \128X\224I\132\017\130a\134\018\002 \195\224q\242\159\129\017 \128X\212\230\000Y\\@\0122\018\232\026\006&\2440\193\158 \025@\174\002\186\136\225\015\016\127b`\000\008 \022\160!,(\0061\162\025\130\150\142P\228a\006\253e`\002\008 \022 \227\013\195\015pR\130\184\135\017\146d\192Z\254\195\1810B\013A\176\255\131!\196\176\239\012?\001\002\012\000\029<\140S\030\222\030\200\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sa.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\198IDATx\218bdHbx`\174b.\224\168\238\200\192\199\193\199\240\255\223\127\0068@b\130\001#\018\147\137\145\225\211\143O\012\251o\238g8y\231\228\007\128\000ba`a\0169\249\236$\183\157\166\029\131\146\132\018\0033#3B\245?\168f\152\129LP6P\236\239\223\191\012g\031\157e8\249\228$\003\208\012\022\128\000\012\201A\011@0\024\128\225\183-\229@\1858(9\248M\014~\249\142R\172D\148I\162\249\216\241\233Q!\188V\154n\236\241\238\227\222_\228\136\024&\139\153\013\235\238\1443\166\144\026\187L\164wN\183\245\193%\201\149\209T-<\200/\128X\024\25420\200\178\17100~\224f\184q\239\017\195\163\031w\024\158\254z\196\240\234\211\011\006;\017w\134O\028\143\025\222\2539\199\192\202\200\002\020{\198\240R\244\003\195\129g;\025\158\008\191\001:\132\139\225\015+\007\003\195\031\006\022\128\000\0029\150\225\193\183\155\012\023>\\b\232\189\210\012\228\1371\024r{1p\253\151`x\246\237\019\195\154\027+\024X\254\1392\220~\247\132\225\227\247\127\012\187\030\236cx\249\249#\195\130\235\179\024X\025\164\024^}\254\002\2422#@\0001\129\253\252\155\129A\145\205\131\129\153\149\147\129\159\221\152\225\204\155;\012\223\254\1762\252`\018d\176S)f\224b\215e``\149f\184\254\246*\195\247\031\028\012<lJ\012\154\194>\012\251\030\031b\248\254\133\005\020n\140\000\001\196\002r\017\0113'\195\127\246\127\0125\210+\024\150=\155\196p\231\221!\134h\197\025\012'>/b`\227\228e\248\247\243/\195\254\187\147\024\1328\228\0248\152y\024\184\255\1382<\255y\153\225\205\247{@\199\176\130\227\023 \128\024\025\146\025>\000\189\202\015\142\017\022\164\216a\130\178\127\0011+R,\"\199\232_(\254\194\240\003 \128\152\024\152!\154\024Y\024\025\196X%\024\132xE\024\216\185\217!\154A\152\027\136\217 \150\136\242K0\024\201Z00\188\003\242\153\161\0223\1311#@\000\177 \219\254\139\233'\131\017\191\005\195\207\255\191\025\152\152X\0258\217\248\024\024\25531\252\254\251\139\129\229\031\011\131\185\168\013\131\133\170\014\003\147\222?\006\207\237\206(\174\007\008 F\134L\160\1958\128\2462C\019\223?h\162cBJ\144PqNv^\006\029\017+\134w?\1582\220\253|\005\028I`5\223\024~\003\004\016#C\n\195\003\160\019\133\128\138\153\129\0060\129\181\253\135\166\223\255\240\140\194\008\2074\255\192*\017\178 \131\1903\252\004\0080\000\204\155\222l'\181\128Z\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sb.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002gIDATx\218bd`X\252 ,LI@EE\136\129\135\135\133\225\255\127F\006f\022f\006n\030&\134O\031\25420002@\192\127\006\004\248\199\192\200\248\159\225\211\167_\012\251\247\191b8y\242\241\007\128\000ba`\224\022)+\019\230\190s\135\003\168\128\141\129\153\153\137\193\206\158\131\129\135\155\137a\219\182\031\012\152\224?\024\255\253\251\159\225\236\217\015@C~\003\249\154,\000\001\0044\136\225\143\181\245c\006\019\019>\134\254~\025\134\135\143~3L\159\246\013h#\019\208u\255\176\024\002\161\127\003\245\0319\"\008d\255e\168\136n\254\007\016@@\131X\025~\254dd8v\236\011\003'\215\023\134O_\2540,Z\244\014\168\128\005\205;0\131@\226\242\012\127\254|g\0080\235eX\249\160\155\225\205m\006\022\128\000\002\n\238\254\240\228\201\157\255~!\023\128\170\014\255gd<\250\127\201\138\027\255\223\188\185\007d\031\001\243!\248$\016\191\004\226G\255s\195\154\255\191z\193\240\255\1976\134\255\001\205@\211-\025\190\003\004\016\216ES\023\253a\184t\145\013h(?8\176\023,cc\216{\130\017\200\0069\157\025\136%\129\2487C|\224V\134)\011\226\025\254\159e`\136Y\196\192\176i\007TZ\132\129\017 \128\128Qr\224\003\003\003/?(\160!\206f\130\198\020\008\203\002\241O\134H\239=@\195\131\025\024n00\164\157a`X\184\030\170T\000\234\219\031\012?\000\002\136\005d\0190\188\225\209\n1P\005,[\026=\137\161ca\025\003\195y\006\134\164%@\003\182A\149\201@\233\191P-@;\001\002\008j\208O\168K\212\128\248\023CM\\+C\243\252\006\006\006\160\237\201\179\024\024\230m\131\186@\002\170\236?\026fd`\004\008 \022\008K\029ltuL\019C\211\252v\006\166s@\023\204d`\152\191\133\001\020\132\012\012\162\208\176@O\151\176\016\000\026\014\016@@\234\210\151\188\224\185\220\205s'2\176]b`H\191\200\192\176h+\212\005BP\023\160kd@r\205_p(\252\006\008 \198\243\027\024\030p+1\008%/g`>|\012\168\141\013\168T\000\234`\136\230\255@\136\157\205\000\015\236\159\000\001\006\000q:\210\252\249e\205\176\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sc.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\167IDATx\218bd`\168~hn\174\194\239\232\168\204\192\199\199\197\240\255?\019\003\003\003\008\1790\200*\190dpw>\201\192\196\244\159\001\003\252fd\248\183\239\019\195\151\169\251\025\222\031?\249\017 \128X\024\024X\133O\158|\201mg\167\196\160\164\196\203\192\204\204\012T\197\204\192\206\241\151\193\202\234+\003'\135*\166!\159\024\024\254_\249\203\240\235\226Y\006\230\227'\0258\128\182\002\004\016\208 \182? \023\0289\242\152\129\141\141\137\129\149\149\021\236\"\015\207\011\012\172,\207\024\254\252A3\228\026\016\031\002\025\246\155\225\247\145#\012\140@&\208\189\255\000\002\008h\016'\216\027\199\143\191cx\250\244\023\003\011\011\007\131\179\203\005\006%\1975\012?\127\"\025\240\013\136g\002\241J\176F\006\144\013\127\030=\002\027\244\015h\000@\000\001\013\226\0012\217\193\230>z\196\196 .\249\142!;g\0140\\\222#\012\185\002\196\165@|\006!\244\239\255\127\006f\006\168\161\012\012\140\000\001\0044\136\023Hs\129\195\005\228\178\242\198E\012\202\138\239\024\024\025\161:\022\000q\029\016\191\131p\255C1\208\021\012\127a\006\177\1761\002\004\016\208 \144\014F\176\171\156|O3d\197\237\134\024\242\005\136\171\129x\006fX\1314\255e\003\006\137\150\003\003\147U\004\016K\254\007\008 \022\136\014\006\006\t\169W\0123&t3\128\"\141\233\"P \027\136O\162\153\192\014\140\031c;\134\127n\161\012\012\030\150\012\127\213\165\025\152\128a\197\248\242%\003@\000\001\013\250\n\182\163\165s6\131\188\204;\006\166E@\131\138\129B\031\1444\155Z30x\00620x910\024h\002\253\245\143\225\031\200\128_\191\192\129\254\237\207\015F\128\000b\001\2496(\230\000C\184\007\208\250T\160\198E ?\003#\192\206\158\129\193;\156\129\193\215\153\129AS\nl\230w\160\133O\191>a\184\245\246&\195\205\1837\024n\190\187\193p\007\200\190\245\240\014\003@\0001J\203\021|9\2082\139[l1\015\003\219\007+\006f\031O\134\239\238\022\012O\149\005\024\1741~b\184\250\234)\195\173\215\183\024\030\191?\197\240\240\227E\134W?\2383|\255\013\012\142_\208\208\254\007\014\207\223\000\001\196X\149\236\240PW\240\159\224U!m\230\155J\\L\015\153>0>~w\233\255\187\143\183\025\127\254\250\000\210\240\031\008\025\025 9\007\020\231\140\2400\255\0155\236+\195O\128\000\003\000\243\211\213\186\213\027K<\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sd.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\236IDATx\218bT\247bx\176\252\173\185\128\136\163#\195\007>>\134\255\255\2553\252g`\000cl\128\017\134\025\025\025~\127\250\196\240r\255~\134\023'O~\000\008 \150\155z\012\"Fl'\185w\176\2191\216()1|aff\248M\192 0\248\251\151\225\195\217\179\012?N\158d`g``\001\008 \022\134w\012\127\024\184\025\024\0265\1430\1320\1761\132]ee\224\002\170{E\192\176\255\191\1273\188=r\004b&\003\195?\128\000bdHa\248\0004\146\159\129\137\129ANU\142\129\005\008SW30$?\021`\184\003\148\250\008T\200\140n\008\016\255\251\243\135\225\235\163G C@j\190\003\004\016#C\018P5\007\208 \144\n\160a\140\236@\006+\003\131\174v$\195>\143I`\205?\128\152\005\2010p\024\254\251\199\240\015\136\127\003\013|\251\246\237\015\128\000b\130\024\143P\241\255'0\176\191\253g\184t`\025\131H\158\008C\243\249\163\012\002\236\028\012\172\172l\012\204, \204\202\192\204\204\194\192\200\0044\154\145\025\236\198\191\127\2551\002\004\016\011JT0A1#\212?@\204\205\198\0024\004\168\249\223\127\160}\144P\003\197\236_``\003\131\137\129\233\031\019\003;\019\211\127\128\000b\001kd\129j\004\209l@s8\024\025\188l\227\0256\249\207\197\026\216 /\253\253\203\004\180\015\232\250\127\127\025XX\152\025\000\002\136\145!\013\024F\156\1920\002\134\011\131\020\212E\019\025\024x\238\2431|a\248\196@$\248\t\016@\016\023\001\019\002\1312\016\031\005\226E\016\025\018\012\001\003\128\000ba\016\006z\136\019\200j\007\226\007\012\228\002&\128\000ba8\207\240\134a\0278\222\152\145\130\250?R\"\198\199\134{\013 \192\000~$\143\217Bn8l\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_se.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\018IDATx\218bd`8\243\192\220\\P\192\209\145\135\129\143\143\137\129\137\249/Cr\210\\\134\187\0154\025\246\238\178e\192\005\024\025\025\024>}\250\199\176\127\255\023\134\147'\223\127\000\008 \022\006\006\014\145\147'\153\185\237\236X\025\148\148\216\024\216\216\2541pq\1691\136\nK0\168\169q\2254\232\239\223\255\012g\207\254\002\026\194\012\228q\176\000\004\016\208 \198?@\204p\228\200o\160!\204\012\220\220\191\025\156\157\175\002m\251\201p\245\1706N\131~\255f\000\235\001\233e`\248\255\015 \128X \012F\134\227\199\2550<}\250\131\129\005(\146\146\178\136\225\252E\127\134E\139\220p\024\243\159\225\015\208\250G\143\254@\013\250\199\002\016@,\166\182W\025\216X8\024\152\128\252\223\191\216\024DE?001\221g\144\146>\206\192\201s\135A\\\252\013T+<t ^\251\199\192 \175\0024\002(\241\243\215gF\128\000b\188q\131\225\003??\003?\027\027\003\0033\208\187LL\144\128dd\196\225\150\255\016\252\239\031(\156\024\024~\253b`x\245\138\225'@\000\177l\217\023\013\012\0236\006V\022F\160$;0\160\1270\132\250\204gx\245F\146a\195\1428\006A\1297p\151\252\255\1430\236\223?\144\247\2543\252\006\226\143\031\127\252\007\008 \160\240\173\015\012\012\175\129R\159\128\248\007\016\255\254\015\180\233\255\2449y@\246_\028\2487T-H\015H\239\149\239\000\001\196\194\128\226wF\160\235~\128\189'#\249\008\200gb\192\013\254\193\195\011\232FF\128\000b\194\150\208\192\202\25433\144\002\000\002\008\232\162\255,\008\027\254\001\013\248\007\014\196\159\1278Aq\131\19950\012\182\158\t \128\128\134|\003\134&#P\132\021\028g\255\254\253b|\249\146\225\255\235\183 w\191\004)\002\197\019\212\157 \246?FHb\000E<(\029\253\004\226\183?\001\002\012\000\202?\202f~N\249\218\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sg.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002/IDATx\218b\156\199\192\240@\220\220\\@>6\129\129\137\139\151\225\247\139G\012\255\255\255g\248\207\128\0290\1940##\195\239O\159\024^\238\223\207\240\226\228\201\015\000\001\196\194\194\192 \194\173\163\203\205\237\238\202\192r\246\012\003\147\142\030\003\019\1910\195\175WO\192\026\176\025\004\006\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\135\225\015\127a!\195\147\184X\006\137\172\\\134\127\215\1751\252\251\245\147\129UJ\142\225\207\135w\012\255>\127\1964\004\008\254\255\254\205\240\238\200\0170\251\031\016\001\004\016\203_\1763Y\024>\028?\206\240\235\203\023\006\134\223\127\128\138~1\176\138\1381\252~\247\142\225\255\159\223\024\006\129\188\253\255\207\031\134\175\143\030\129\012a\000\170`\001\008 \150?@\198\219\182\249\012\"\171v3\188\139\244`\224r\244g\248y\245\012\003\011\0037\195\215\219'\176z\015d\208?`8\130\012\0019\004h\006#@\0001\206f`\248\192\201\192\192/\169\237\196\240\247\203k\134\175\015/30Am\255\007\213\132n\216?$\012r\239\007\006\134\159\000\001\196bu\243&\003\159\128\000\003\211?&\006\022>.\0066ff\006fFF\1400Aq\017\2085\127\129\129\253\027\024N\191~\254dx\245\234\213\127\128\000b\249\251\239?\216Z6\014\022\006V\160\"f fb\196e\004\212E@\131\192I\000\148L\128z\255\001\205\000\008 \022\006`\160\1290#0!0\254\249\011\244\022#\003\211\127\006\252\224\223?\134\127@\181\140\127\255\129\245\002c\144\017 \128X \t\236?,.0\002\021k\026B\196\029X/H\028 \128X\254\255\255\199\002\242\243?\144-@'\254\001\250\157\233?\022S\144L\251\247\239/X-H\015H/0$\152\000\002pH\006+\000\128 \012e\206\254\255G\003\143\018E5\005\015;lC\198\243\204\156\194\253\210\007\205t0\144\254\180C?\000\152\188\165+\128\026\005]$\199\017c[\240F\196\250\002\012\0003\014\236\200\014\168\156\128\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sh.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002NIDATx\218\0007\000\200\255\001\180Xi\017:C\188\250\026\006\252\007_\029\236\005\000\245\155\226'\000\000\248E\028\251 #\012\155\199\254\000\250\251\000\000\255\001\000\253\000\001\252\244\243\245\192\193\216\222\221\226\002\136%\253\131\227\196\135O\243\018\149?\137\168q\220\189\197\254\253c\128\150\168\188\240\239_\\\002\199\239\255T\146~\195\192\192\206\192\240\015\136\128\224\210\165/G\143<\230\228\252\011\016@\140\215t5x\158\127e\1834`\215\214d`bb``b\248\207\192 $\204\240\241+\003\027\227\244oF\031\0258\025\128V1\252\255\243\135\233\210\185\235\187\246}\224\230\249\001\016\0007\000\200\255\001DD\154_c1B\008\223\254\213\248\000\223\207\007\224\207\229\160\170\027\204\189\214\208\245\155\233\027\193\185\219\000\251\250\000\000\001\000\000\005\204\204\134\230\188\245\0219\244(/\130\002\136\197\201\140\223\249\214\185\2369\159\215?\021\127\019\247\135Q\236\175\161\236~s?\198m\225,\2057\206*\221g\004;\018\008~\207\223m{\236\180\166.\1750\0033\011@\0001j\240\207\186\241\145\029,\199\200\196\244\135\249\255\159\223\255\129\236/\012\012\"*\170\127\031\220\249\254\231?\011\2166f\005\230\184\239\142\243\255\253\253\240\24547@\0001\127c\013\250\253\139\029\228%\006\198\255\255\217\2541\176\129\021q00\252y\247\238\255?\006\022\176\0203\003\003\031#\207Gf\206\182\143g\2383\177\216\001\004\016#7\207\228\175_\128\162\255\193\170!\224?\003:`\004!F~f\1827\127\127\np\243|\004\008 \160a\159\145\228\152 \214\194\016\196\008\008\250\199\240\255\227\223\159@\145\175@.@\000\177|\253\242\158\001\2280\160\133\172`\006P\027\011\152\203\004\214\246\015\028\250\127\192\140\223`\244\247\235\151_\000\001\196bm-\193\200\196\197\200\200\241\031\136\128Q\196\200\246\239?\243\127\006\022\184m\140\012\127\152\024\2552\252\255\197\200\240\157\241\255\143\255@\244\239\027@\000\001\229\146\025\024x\024\024x\025\024\184\025\024\184\192\129\193\002s-\196\182\127`\219~00|\003\187\016\232\169/\000\001\006\000\199\205\219\217LI\020~\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_si.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\235IDATx\218b<s\230\204\003AAA\001\030\030\030\006&&&\006R\192\191\127\255\024\190|\249\194\240\254\253\251\015\000\001\196\194\193\193!\194\204\204\204}|\203\t\006AY9\134\223\191\185\025\2169~0\240pr2\168\233K\2254\228\255\255\255\012\191~\253b\000\234e\000\154\193\002\016@,\140\140\140\127\128\152\161{\2069\006\007'F\006^\001F\134\031_Y\024\004\217\152\024\148\180\197\240\186\232\247\239\223\012 \189@C\255\001\004\016\019\136\001\194g\143\127cX\188\248\"\131\134\154\002\195\162E\199\024\182\174\185\206\240\243\231O\172\248\199\143\031`\252\231\207\031\176^\160\023Y\000\002\136\145\129\161\225\003\003\1953\254Y]\225\012\001\t\186\240p\234k8\200\208>u;\144%\003\196\127\128\152\017\234\014F\168\215@4\019\020\255\248\001\016@,\012\012\210`\197kw|a\008Kcc\184\193\200\196\160\205\196\200\176}\251_\160b{\160\028+\146g\024\145C\t\022\228@\252\129\017 \128\128\1981\003\025|\012;\247\221fX\222w\147\193\128\157\141\161&\2294\195\249\187\175\129\226\188@\204\006\197\236H4\012\003\221\001\214\207\242\031 \128\128V\204\001z\141\157\031b\243{\006[ u\2487HR\000\136\255\162\185\002\230\170\255H\174\002\169\249\242\003 \128\024\247\001\221%\200\192\192\207\t\149z\001\196\138\132\210\015T\251oP\232\000\241K\006\134\159\000\001\196\242\006*\192\006u(\200]\207\160v\253\199\226\022F\168A\255\160Q\240\011\136\223\0021@\000\177\000\021\179\252\133\n {\228?\026\205\136F\195<\245\023\194e\002\008 \022\160\211\222\000\005\2551BB\013\020\151\140\255A\177\011\161az\024\161\134\128\"\157\017j\216\127\152\023?\001\189\006\016`\000\227\156\165\195\147\135\134\177\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sj.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\197IDATx\218b\220\167\160\240@\196\208H\128\223\194\138\129\137\157\147\129CV\144a\023\139+\195\183\223\012\012\001\172'\025\190\223}\192\192\192\198\193\192\200\000\002\255\025\024`4\211\127\134\127\159?3|<q\140\225\205\249s\031\000\002\136\133\131\145Q\132\225\210%n6ss\006\014EY\0066\t~\006yf.\134\031\127\024\024\184X\196\024X\025\129F\176\176\"\012\128\177\254\253a\248q\229\n\003P/\003\208\012\022\128\000ba``\254\003\146\248v\230\012\208VF\006\166\127b\012O\152\013\024\190\000]d\202\241\144\225\231\141G\012\012\236\236\012\008\0001\236\255\159\223`= \240\143\129\249\031@\000\1770~\253\197\192\200\196\192\240\227\232\t\134\127W\17530ZJ0\028\148\244bx\243\157\129\193\239\207j\134\207{\17530\240\242\163\024\0046\234\207_\134_O\15920\254gd\248\247\247?\011@\000\177\0088\2323\240\17833\176\000\253\204\244\253\011\003\147\138\030\195\247\215L\012\239\223\000\131AS\139A@\231\021\003\0037/\146A\144\208\250\247\015\136\181\197\025\254\252\003\026\244\2537#@\0001\154\133\222\248\192\202\206\207\207\196\204\006T\195\204\192\195\202\196pk\207\007\134\223\191\2553\232z\n3|\253\003\241\012#\138\139\128\240\255? \254\011t\205/\134\159\223^\253\004\008 \022\006``221\00113\208\t\172\012L,\204@!6\160\198\255@sY\225\00602 \251\014h4\208\016`\224\000\189\006\210\203\244\031 \128X\150\176T0\008\002c\005\232;\006\182\159_\024\152\245\012\025\178\249\155\024\030\001}\180Q\171\159\129\225\204\030`\024\241\160z\011\024.\127\255\253g\248\245\151\145\225'P\232%\203O\006\128\000b\249\176\007\024[L\140\012\236\192\000g\003\166\011\209\143\015\025\190*\1830\252\004\198'\211\249\237\012\239\214\158b`\016\016F\1371\160C\024\254\002]\245\011H\255\004r>\252\253\199\008\016@,\012<\192\196\198\012\244\030(\189\000\189\200 %\003w=\131\152\028\003\003\207m \230C2\232?\200?\160\132\004\164@\024\200\254\243\143\001 \000\011\228\182\002\000\008\131P\1371\232\255\191\182\150,[{\020\241\194\209.-aZ\209\221w9\012\203\137\016\002\238\137#\015\233]TP\212A\176\212\007\175\212\184\002pHm)\000\1310lU\239\127Oa\130\160\136NM\140\251i\191\146\230\209\208\2017\003\008t\222\1509\212\199\n\"\155v\212K$y\224\188\149\240\170\214}\252AirK\204'J\225\199\017`\000\141\005\000\184\027\212~\179\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sk.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\0026IDATx\218b<s\230\204\003AAA\001\030\030\030\006&&&\006R\192\191\127\255\024\190|\249\194\240\254\253\251\015\000\001\196\194\193\193!\194\204\204\204\205\202\202\202\192\198\198\198\192\200\200H\148!\255\255\255g\248\245\235\023\003P/\003\208\012\022\128\000b\001j\252\003\210\252\233\212)\006\134/\223\025\216\133\133\025\024y\249\024~>x\196\192*$\202\192m\172\133\211\176\223\191\127\131-\006\026\250\015 \128@\006\1299wS\146\024~1\1770\136\007\1343\176\233\2333\188j\173c\248\002Tl~\226\004V\215\128\192\159?\127\192z\129^d\001\008 \022-\173e@!\021\134^\160\019\189\172\149\025\254\155:0\176\201\1381\008:\0071\240\173\237e\016\023_\011\148\127\001\n\017\1681\140P\195@4\019\020\255`\004\008 \022\006\006y\006\006fa\006..v\006!\021K\006N!!\006F\tn\006V\005K\134\127\204\028\012\255Y\229\024\024~\t\129\180\194\013\129\186\011\022\228@\252\129\017 \128\128\0061\003\017\027\195/a[\006\158y\189\012S\151\239bxl\152\194Px,\131ATI\140\129\225;\031\208\160_H\0060\"\025\244\023\138Y\254\003\004\016Pt\206\007\006\006.~k\133\207\012\231_\253c\248\246\141\007\020\140@\245\127\025\162T\0303,\187o\012\012\140\175P/\192\012\250\143f\216\151\031\000\001\196\184\015\232.\001\006\006~Qv\006\134\028\197\133\012\027o\179\002\229\2223p)\2331\220\254\234\193\240\239\229Wx\2320 y\230/\196:\134\031@\252\146\129\225'@\000\177\188\129\n|\249\201\192\176\234E<C\170\198L\134#\012\186\012W?\1871\220y\249\157\225\019\154\167\024\161\006\129\240\031 \006y\250-\016\003\004\016\227J\160\025\188\012\012\220\204 \159\002\177*\144`\007\186\238\230W\136\162\255h!\131-\132\222\003\221\002\016@,@\167\189\001\n\254c\004\135:\003\211\027`\210\000Z\245\031h#\227\127\132\030F\168!\160H\135\165\253\2550/\002]\253\019 \192\000\209Y\172f\250]^m\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sl.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\217IDATx\218bdHbx`\174b.\224\168\238\200\192\199\193\199\240\255\223\127\0068@b\130\001#\018\147\137\145\225\211\143O\012\251o\238g8y\231\228\007\128\000ba`a\0169\249\236$\183\157\166\029\131\146\132\018\0033#3vC\208\012\251\251\255/\195\217Gg\025\128z\025\128f\176\000\004\016\011\195?\134? MG\238\030a`cfc`ef%\202E\191\255\254\006\235\001\171\249\203\240\015 \128\024\025\"\024>0\1763\240\131$\229D\228\024X\152X \026\240\185\008(\247\231\223\031\134Go\030A\196\1903|\007\008 \198\235\215\175\127\224\229\229\229gaaa`bb\002cb\192\191\127\255\192\248\207\159?\012o\223\190\253\001\016\128\0132F\002\000\006A\024h\255\255\225\170\200]\215\014,,\201\229t\201\129\141Q\026\150\008\006H\226\175\245>\201s\019\184\147\166Qw\184\002\136\005\020\182L\172@#\216\024\024XY\153\024\152\153\153\161\006\225\006 \131\152\254\130\003\n\024<\140\012L,\140\255\001\002\136\133\021\232%6\022V\006vVv\006666\176A\132\188\007\242\210\223\191\127\025\128\001\193\000r\024\200\012\128\000\002Z=\255\003\003\003\0230\176A\209\0142\000F\163E\019J4\254\003G\021\130\254\248\019 \128X\152\225Z@\154Y\161\024f\024\019\146a\255\161\026a\154\127\131\241\1270\155\129\001 \128\128\006\253fa\004J2\1305\176\000%\176\025\198\128a\008#\216\224?\224@\255\207\240\135\t \128\128\137\230\231\027\160\230\127\224hc\248\015\212\245\023h\226\031Pp2B\189\n\212\241\159\017b\200\127 \227\015#\196\128_@\241o@\250\007P\252\243O\128\000\003\000\186\144\161%\143\008r\001\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\154IDATx\218b\220\183o\223\003iii\001\030\030^\006&ff\006\134\255\012\196\001F\006\134\127\127\2552|\254\252\137\225\237\219\183\031\000\002\136\133\131\131C\132\145\145\145\155\149\149\133\001\200\134\168@\215\001\006\2326\252g\248\241\227\007\003P/\003'''\011@\000\"\199 \005\000\016\008\129\186\245\255\255.\132\150\004usp\004'X+\208\221\024\231Q\242SYp]\166\013J\191;\156M|\201\218\002\136\133\145\129\t\168\138\137\225\215\175\223@\201op\131\216\216\217\192n\185:\127\026\2161\218qY\012\012@\159\255\252\245\011n\208\239\223\191\193z\255\254\251\199\002\016@,LL\204\012l@o\177\000]\195\196\196\0046\136\133\149\021\172x\202\148\233\012\198\183\154\024\152\255\1761\1802\221aH\142\237b\144\002z\255\207\159\223`\131\152\129\174\253\253\231/H/#@\000\177\240\243s0\176\177\177\12913\146a\238Q\241\012\204?\2460l\214?\206\240\007\232\"\133\235A\012a]R\012\167\155>3\176\253g\003z\231\031\195_``3\001]\200\194\194\204\008\016@,\026\177\199\025\024\216\249!\129\202\008t;\019\011\016\17910\156_\199\224\029\018\194\240\237\031\027\003\203o\022\134_\156!\012O\190Ld\224\245=\194\000t\018P-\016\255\255\011\193\191>\254\007\008 \022\006\001\160?9\190\003\253\0154\008\020\176\2240\018``\016sf\216\186\239\024\131\173\143/\195?\160\198\203?\2223|\249\175\194\192\192\015\148g\249\004\n$`\252\003\241_`\004\252\248\205\000\016@,\012\204\223\128\018@\001\022\168A\192\192\231\225\250\203\016\155\156\196\192\201/\207\240\227\241zp\128\218\170\184\0025\221c\152|\240-\195\215\159@=\012\127!\0061\002\013b\254\198\008\016@\192\232\255\012u\t0\246\024X\193\006\253\003\218r\230=\031\195\197;\175\025X\127\027\129\029\251\229\238w\006]\tI`\004\190\135\166)\160A\140@\2230\001i\166\175\012\000\001\0044\008\024\000 \193\255@\234?\208 f\014\134o?\216\025N\223\252\011\014\175_\140\252\208\132\243\151\225\226C`\184\176p\002\197\153\192Z \004090\254e\002\008 \160\202\239o\024\254\179\253\003\1668`H33\129\157\247\159\233?\195\255\127\140\016\133@60iB]\001L\149\127\025\025\024Ai\2337P\0130l\255\127\005&\174\015?\001\002\012\000B\248\226\021\161\202\175\019\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sn.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\238IDATx\218bdHbx`\174b.\224\168\238\200\192\199\193\199\240\255\223\127\006\134\159\012\012i\246\012\024\000(\195\240d\022\003\003\019\144fbdd\248\253\233\019\195\203\253\251\025^\156<\249\001 \128X\024X\024DN>;\201m\167i\199\160$\161\196\192\012\132\012\191\025\024\184\184\176\027$\172\0061\136\225\239_\134\015g\2072\2528y\146\129\157\129\129\005 \128X\128B\127@\226G\238\029a`cac`ebe`\248\193\192\224\166\201\128\021|\185\n1\232\255\239\223\012\239\142\028\001\139\253\003\"\128\000b\001\145 \171\142\223?\206\240\244\227S\006\022&\160\217\159\025\024\178lqxm\017\212\160?\127\024\190>z\004\214\014\244\000\011@\000\193\013\002\129G\239\03110\002!\195G\160b&\136\216\241g\016+-e\192\020\195\183\251P\131\254\255\007k\003\137\253e``\004\008 &8\015j%(\176\2553\254g\224\224\248\2070\249\242\127\006\223> \238\255\207\208v\233?\003+P\140\249?H\209\127\184+a\006\001\004\016\196^F(\006\241\152!\nX\129AUe\005d\188\001\226\151\012\012\237\214\192\008`\133\200\177@\1491!\240\127\128\000b\001\179`2,Po\178@\162\225\249W\006\134\235\011 \194\015\128IB\153\027h\024\212\206\191\144\176\001+\007i\005\008 \022\184\2090\026j%(\140\164y1\003\155\005\201\2410\175\001\1812\002\004\016\019\220}\140H\248?\003N\000\147bD\179\031 \128X\128\",(!\247\031\226\238\191\127\177\027\242\027\20150%@\195\152\000\002\136\005(\243\006\168\226\031\208@f \013\138EF\134\175\012\255_\190\004[\202\000\204\t\160\152f\132:\227\255+ \t\245\222\127h\1401|\002f*\128\000\003\000\155\004\152m\150\141\133\208\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_so.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\189IDATx\218b\148\013+}`\164\174*`\161\165\202\192\195\193\197\240\255?3\195\127\006&\006\134\255L\016\026\t02\252\003\018\255\1924#\227_\134/?\1901\156\184v\155\225\220\205\219\031\000\002\136\133\137\133E\228\210\195\231\220\230\218\202\012\n\146|\012LL\204PC\024\193Z!\024\004\254\1311#\136\006\026\246\239\223_\134\203\015\1900\000\2452\000\205`\001\008 \150\255\255\217\254\252gdf8s\251\017\003\027\0113\003\0113\011\146!@\003\255C]\0036\239\031\220\176?\127\255\128\245\128\244\254\255\199\250\015 \128X\254\253\231\006J03\156\189\243\150\225\229\135_\012,L\140`] \003\254\0011\019\208`F\160\216\159_\191\129\174\005\242A\006\002%\255\000%\159\188\249\012\228p2\252\253\199\204\002\016@,\255\254\241\002]\202\006T\252\159\225\241\219\127@\197\016/\252\007jxt\250:Ca\129/\131 7;C]\203*\006YSM\160\027!\225\246\239\031\200D\001\160k\128!\246\239\027#@\000A\013\226\002:\130\t\226\021\160\196\159\191\255\025\020\165\184\025\166/\242f\176S\017\000k4S\151g\232\218p\151\225\234\189\143\012\172L /\003-\252\255\015\136\128\225\245\151\137\017 \128\152\224\001\000\244+#(\160\153X\024\152YY\025\206\220\250\196\176\232\232\011\006V \027\132\215_~\207p\232\220;\006f\022V\176\026\176ZFf\168^\134\255\000\001\196\194\196\252\021\024\014\127\129r\140\224\176\0009\140\017(\249\139\237;\0037\171 \195\139\207\191\025\190\255\252\205\192\203\242\141\2257\203+\006v6\030\176k\128\142\001\226\255\192\224\007&\018\230o\012\000\001\196\194\204\252\133\129\153\249'\216\006&f\144A \147\152\024d\005\2543|\251\252\145A>m*\003\195\239\255\012\017\142\026\012\242bL`M`/\129\146\000(\006\129\142\248\207\244\157\017 \128\128\145\244\021\232\002\014 \006:\147\001\232l\0066\160\141L\012l\204L\012Gn\190cP\016\149\000\167\132\1637\222\001\147\0070i\252\135$H\006\134?@=\191\129r@\223\000\205\000\008@\"\025\164\000\000\130@0+\169\255\1916L\171\tO*\236\138;\216E\140P,\184\138H\0017\016MzX\021\140'16.\008\255fgZ\249\1527\168F\128]\159\000\028\147;\014\000 \012B\169\159\251_\212Yc\026\193\1823\129\001\030\131\238KpR\179\144\206\225\133\02354\147\210\212\211a\168[Pq\141\164\012EZ\232\022\161<\251~\001\006\000vC\005\227\154lQ\239\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\028IDATx\218bd\152\192\240\192\\\198\\\192Q\218\145\129\143\141\143\225\255\255\255\012`\000\1650\000#\148bdd\248\244\235\019\195\254\167\251\025N>9\249\001 \128X\024X\025DN~<\201m'k\199\160$\160\196\192\204\200\204@\012\248\251\255/\195\2177g\025\128z\025\128f\176\000\004\016\011\131\186\240\031\006nF\134#<W\024\216\216\004\024X\025YQ\173\135\186\000\226B\1323\127\255\255\013\214\195\160%\194\192\240\229\255?\128\000b\188\150U\251\129\135\131\145\159\153\241/\003\139\000\031\003\0033\019\216\2170\019\254}\129hd\226a\128\155\008\246\254\223\127\012\127>|\002\186\140\153\225\253\183?\223\001\002\136q\001\003\195\007n\006\006~\022\144b\016\006\026\002s\196/ \022\128\026\249\030\136\217\144\028\247\015h\216? \253\007\136?20\252\000\008 \166\191 \255B%\193\248?\212F \150\205\255\207\160\251\244?\131\222\251\255\012\138e\0161\152<L\253_\136a\140\000\001\196\196\008s\t\016\131\130\153\005\138A\252\175K\025\024\248\132\025\024x8\025\024>\175\131\136\193\228\153\145\244\001\241\127\128\000b\001\t\178B\157\205\nU\196\008\181\141\2275\003\195\019\031\136\0319nC\188\193\004\149\003\177\127C\217 =\000\001\196x+\167\254\131 \023\011?\007\144\199\198\204\200\192\002t#\019#P\249?\160q\156\140\012?/2\128\195\130S\023H\252\004jc\002\134\205\127`@\255\251\207\240\235\239\127\134\031@\019_|\254\241\019 \128\024\025\014\n\127`\224g\228g\224\000jde\132\186\153\017\026\000@\154\003\026\194?@\254\249\015q\238\191\255\144\192\249\013\164\127\000\241\235\127?\001\002\136\133\225\250[\022\006\030$\207#b\030\170\t\202fBJF\255\145\252\007\194\031\024\152\000\002\136\005\232\2097\012\223\128\202\153\128na\004+\007\145\160\184e\132\026\006\138\"\004\027F20 \226\255+\195O\128\000\003\000s\138\182\028%X\212\190\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_st.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\000IDATx\218b\140\208dxp\191\220\\\192\145\215\145\129\143\131\143\225\255\191\255\012p\128\196\004\003F$&\019#\195\167\031\159\024\246\223\220\207p\242\206\201\015\000\001\196Rs\157A\164\167\251$\247\223\233v\012J\220J\012\204@H\140A\127\255\255e8\251\232,\195\201''\025\024\152\024X\000\002\136\2292\003\195\159\198\171\012\012\011\167\031a\184\\\192\198\192\250\140\149\129\225\031T\019\030\131~\255\253\205p\228\234\017\006\134O@\206/\134\127\000\001\196\184\136\129\225\003\015\003\003\191$\144/_+\199\192\156\195\194\192\200\200\128\023\252\007[\240\135\225\207\159G\012\127\25520\188\127\207\240\029 \128X\254\130\133\024\024^\000\241\203\230G\012\026\239\025\025D\026\024\008\130\127\192\176df\134\025\202\192\008\016@L _\252C\242\197\153)\255\025n\005\254g\224\224\248\207p\239\233\127\006K\251\255\012\134f\255\025\174\223\129\136\177\179\255gX\181\229?\131\152\024\003Ca#\003\2160\144A\000\001\196\002\242\005\019\020\131\196X@\024\200a\005\006\149\190\006\003\195\237\171\016\011\204\012\017\174\017\020\128\208w\175\001\2451\129\241\127\128\000b\001i\006\234a`\131\026d\\\198\192 \222\142\208\244\226)P\030(\193\194\130\016s4a`\248\242\030(\247\028b\016(L\001\002\008,\0152D\022\136\213\170\128\026\154!\1460 .\133\025>\162\192\152\249\003\012Xq\160\166\031?\192\225\196\008\016@, \215\152\001q\149\014\003\195lM #\155\001\017\253\200\129\007\011\003X\250\002\201\253\133\178\19110\000\004\016\227M\160+{t\025\184g\231\002\005n#i\252\143#\029!'\013\152a\223\024~\003\004\016c\152\014\195\131U\241\012B\012\247\129A\244\015l'#\208\128\255P\026f$#\212 \008\155\017)\221\131\012\251\206\240\019 \192\000Z\129\151\148d\167\016=\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sv.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002DIDATx\218bd\240\207z`\174\161!\224\168\163\193\192\199\201\205\240\255?3\003\003\00830\0011#\020\131\192\127(\254\007\020\250\203\192\008\196\159\190\127e\216\127\229\006\195\201\0277>\000\004\016\011\003\011\171\200\201\007O\184\237t\213\024\148$\249\025\152\153\144\012\249\143f\016#\194\176\191\255\2542\156\189\255\153\001\168\151\001h\006\011@\000\1770\252e\253\0034\158\225\200\181\187\012lL\140\012\172,\172H\00601\160\130\127p\003\127\255\249\013\214\195\240\023\168\238\015\203?\128\000ba\248\008T\204\202\200p\252\236\003\134\167\143\2231\17603#\\\193\198\001T\244\023\226\008V\022\006\134_\223\225\174\251\243\247/\195\163W\159 \193\240\147\129\005 \128\024\175_\191\254\129\151\151\151\159\133\133\133\129\137\137\t\140Q\192\239\199@\135\001]\194,\139\226\194\127\255\254\129\241\159?\127\024\222\190}\251\003 \128X\024\129\222b\006\186\130\149\149\021L\131\012\002\137\129p\199\202}\012\194\156\172\012\252\204,\012\023\158\223ahK\241\006F\198\1270\006\025\242\023\232*\016\027\228\005\128\000\002\027\004\210\140l\024H\012\004\216\185\2541,\189\\\207\192\193 \197\160#\231\003\150\007{\012\168\025d\008\008@}\241\031 \128\224\006\193\012\131\185\n\004\170\194|\025\1968\222\129\"\133!\1933\016(\194\002\247\022\008\128\012\131\249\000 \128\024\025\028\138?\000\003\146\031\172\006\228\018F&\008\013\npN~\006\006^a\144\019\024\024\190\002\003\246\219\027hX\003\249\255\255A\232?@\254\207\031?\001\002\136\133A\016h\002;\208\201\192p``\002bF6\168\205\204\016\252\231'D3\007P\013\135\024\200\029\012`\221\255\127\001\157\006\164\255\002\241\183?\012\000\001\196\194\192\252\139\005a\008'\0043\000\013\251\015JO0\003\025 \0060\00251\254\006\178\129\1340\000\147\002\019(9\000\249,\191\153\000\002\136\133\225\207o\160{\255\000\221\249\015\1487\152\128\206\005E\0250j\128~\0039\157\241\031\132\013JL@Y8\155\017$\249\023\226\178\159\223\127\002\004\024\000\0132\202\189\174!-\213\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sy.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\187IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\128\026\254\128\196\223\0299\194\192\204\198\198\192\200\202\n\215\244\031\151! \185\223\191\193z@\224\031\016\001\004\016\203W\168\134\031\199\1433|x\250\020d6\0033T\019\200\006&\168F\160b\020q\134?\127\024\190>z\196\240\023\200\252\004\212\005\016@,\150\215\1753\240\242\2422\176\002\013\248\207\196\196\192\002\194H\154a\1341B\013b\128\138\253\249\247\143\129\017\136\127\003\013|\251\246-#@\000\177\252\251\247\031\162\140\145\153\129\157\153\133\129\021H{\220)c\248\252\247%\195!\141E\012\172P'1\253cdp\191]\200\240\237\239\007\134\253\234s\025\152\025\2552\252\250\0152\242/0\184\2541\002\004\016\011\027\208\005\236\192\000\230`ea`ge\003\13453\195\197\159\203\024~\252\249\196\192\203\206\134\0180\231\191/c\248\245\239+\003\015\199b\160\230\191\012,@\185\031\255\254\130\244\255\007\008 \022\022f&\160\183\152\129A\195\204\192\204\202\0126\232\171\213{\1721\246\221\230\019\196\203@/\129\252\203\242\159\153\129\245/P/\208\012\128\000\002\217\247\001\136\249\025(\003?\001\002\136\137\129J\000 \128@\006\177P\195\028\128\000\002\025\242\006)\153\192b\250?R\250\195\199\134{\013 \192\000\027\007\136!\013iu\227\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_sz.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003BIDATx\218bd\136\158\255\192\\MV\192QC\130\129\143\147\141\225\255\127F\006\006\016f\128\209H\128\241?\144\248\015\166\025\129\248\211\247_\012\251o\188`8y\235\241\007\128\000ba\248\163$r\242\022\015\183\157\170\000\131\146(7\0033#\178f\024\027\164\025d\240\127\184\204_ \251\236\253\175@C~20\252ae\001\008@\194\028\171\000\008B\001\020\189\246(\008\013\161\161/i\236\187\221\163\181o\169\232\1334h\022\180\031\142\153\195pX\139\239\252\136\235'*\169y>\223\"\200\025\185S\"\022\193\228L\227,\198\253a)\t\221\023t[\209\011}\005\016\203\195\012\006\006.f\006\006f\166\211\012\\\252\207\025\024?\1790(\13820<\253\245\137\161\250\223?\006m#\011\134\170\154f\1347\243\1672\220\\\188\008\232F.\160\006N\134\127_\1902|\251\243\138\225\031\027\019\195\167\223\255Y\000\002\000I\000\182\255\002\236\000\016\000\235\254\017\000\235\232\017\000\238\238\237\000\028S\229\000\192\255\224\0007\205\218\000\190\173\199\000\182\t4\000\002\012\012\000\011kw\000\011\145\173\000\240\018\213\000\245\029\204\000\250do\000\241\0009\000\235\248\013\000\235\000\016\001\002\000I\000\182\255\003C\015\022x\011\016\255\008\"\031\221\000?n\240\000\221\016\243\000S\151\250\000 (D\000 \222\244\000\213\153q\000\225\228\011\000\014\018\022\000\0299'\000(cc\000\255\006\177\000\019\tE\000\002\212\137\000\251\000\004\000\240\252\011\253\002\136\137\t\024\144\194\031\1590tto`\144\243\250\204\176o\138\0228p\255\243\1762p<\186\004\014X=\011+\134\255\127\025\0258xY\025\024\159I0\188M\127\192\208\252\226\006\131\231\190\151\012\175\148t\024\216~\252\248\015\016@,,\140\127\024~\190\226f\224\237\189\201\192\239\"\204\016\246\252\031\131\146\148$C\194\131\011\012\207~~ap\012,`\168\200vbx\n4\240\205\225\235\012\199\029t\024\132\024\216\025\248\14221\252uea\248y\247/0\140\2553\000\004\000I\000\182\255\001\160\022\023\240\016\003\002\015\030\237\238\000\n\252\251\000\233\021\018\000$\012\008\000\237\244\246\000Z\233\238\000\248\001\000\000\219\215\219\000\231\155\160\000\212\141\133\000\005\014\012\000\001\017\014\000\011\238\231\000\245\012\t\000\000\242\251\000\219\n\017\249\002\136\241\212n\254\015B\252\140\252\028\156\255\024\128\017\192\192\200\n\244,0z\1338X\024\152Y9\025\254\222\127\206p\231\241_\006n\160\129\220*|\012L\130l\012\191\129I\225\255\239\255\012L\159\1912|`\230fx\241\242\255O\128\000bd\136=\250\133\129]\128\155\129\137\141\129\129\137\029\232\001\022 \006\166\007`\152\128\019!0\020\025\254\255\003\165\015\160\024\144f\252\007J\142@\252\135\129\225\223/ \006&\200\239\175\127\003\004\016P\215\2217\012\127y\2541\252e\007\234\006\185\137\021\168\027\232\233\255L\140@\012\203\023\140\144\212\013L\170\140\255\024!\006\001\157\244\031h\200\255o@3\223\254\004\0080\000\242;\028\t\246\214\022\154\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tc.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002gIDATx\218\0007\000\200\255\001\180hf\0172A\188\240\022\006\254\001_*\250\005\007\251\155\206\025\000\000\237E%\t #\018\155\190\247\000\250\244\000\000\255\001\000\254\000\001\253\244\243\245\192\193\211\222\221\224\002\136%\253\150\222D\209\199y~\186\159$\0219\158\223d\255\253)\192KZ^N\250\215\007\190\227/\190(I?c`\224g\000\001\198\127\255\254]\186\244\235\232\145{\156\156L\000\001\0007\000\200\255\001\214Q*\012\228\243\00760\007)*\000\250\001\000\001\002\000\005\000\000\n\019\000\239\245\000\021\004\151\217!\241\253\t\024\026\240[S\221\239\245\255\251\253\197\213\212\224\n\t\013\002\0007\000\200\255\003\217 v\016Xo\0313+\249\237\011\250\229\229\001\234\204\226I\141\011\244\244\211\239\002\131\209\025\171\175\210\210\209\227\251\002\198L>\214\006\236\223\007\022\194=>\176\026\029\233\002\0007\000\200\255\002B6\025C\003\213lu\187\029p\239\t\007\253\003\025\01418\160M\163\240-,\007\131\013\206\228\225\237\228\228\254\232\236\246\002\015\214\255\232\244\003\000\001AS\223,-\221\002\0007\000\200\255\001(\022{\216\234\255\000\000\007\000\000\004\002\001\252\003\001\254\251\254\003\000\000\232\000\000*$%\002\224\220\233\252\255\n%+\222\206\200\153\247\253\tvM2\127\166\208\245\242\n\002\136\233\2097\014\176\030&`p\253\251\207\242\251\031\144\011\212&\205\192\240\238\206\2377\127\254\17910\252\187}\213\156\149\149a\1931\225\005\223\132\2223\253\255\253\149\019 \128X\024\025\19010\252f@\001\255\025\208\193\255\178R{\189\236\235:J_Y\216\153c\146\188\000\002\136\153\141\205\240\247\175\239\012\012\191\024\024\254\192\208_\160\0130\244\023,\242\249\228)my\222\151\203{O%F\216_\190\164\002\016@\140\012\012Q\012\160 \007:\140\005\137d\002#\006$\205@\146\133\139\241\243\183\255@\197\159\001\002\176,G)\000@@\016@gD+\199p\013\247\191\146ldP\234\253\190\216Ze0\178\232B\006m+\233\229\223\136\0218!'\006\213um?\002\008h\155\031\003P5\003'0\142\193a\003\177\025\136\024a\254\252\011F@\255\255d\000\005\004\208G?\000\002\012\000\031\239\238*t\193d`\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_td.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\138IDATx\218b\020\017\137}`l\172)`m\163\195\192\203\195\195\240\247\0313\195\207\031\156\012i\017\251\024\024~\17920\252cb\000\003F\006\134\255\\\255\025\222-\251\205\192\192\006\228212\252\249\242\137\225\221\145\003\012/\206\158\250\000\016@,\140\140\204\"\231\207?\224\182\180\210dPP\020d`dda\248\253\139\149\129\139O\141\129\225\015\208\144\255\140\008\131\216\129\230\170\253e``\001\178\255\255e\248|\241\028\195\207\243\167\025\216\025\025X\000\002\136\229?\003\251\031F\006f\134S'\2390\176\1772301\1792\252\248\206\193\224fq\149\129\225\023P\199?\132A \240\237\218\031\176\139\254\255\253\205\240\233\228Q\176\216\127\006\198\127\000\001\196\242\255?\023\195?\160A\167\207<cx\254\252\027P\003\011\195\199\015\220\012Y\001K\129\186\216 \174\002\001f\160\006\017\006\134WK~1\252\231\254\015\228\252a\248\254\2441\216\197\191\255\255g\001\008 \150\127\012\188\012L@+@N}\244\228?\195\191\127\191\025>\188\251\203\192\244\239\001\208\016\014\132A \189\255\128\193\246\224\007\195?n\144\193\255\193\206\004\145\255\25432\002\004\016\208E|@\023\177\003\195\134\025,\241\239?3\208P~\006\014V\160_X\152 N\129\185\008\024\246L\1600\251\255\031\228\029\176o\129L\160\030\006F\128\000bA\004\000\019\0243\1305\1780\176\178\130(FD\224\128\012b\003\201\000-\003;\240?X\248/4\030\000\002\008\024k_\024\152\024\127\003]\004Q\207\192\0042\240\023\003\0110\026\024X\255\194\205\001\027\004\180\150\157\241\0318E\128\226\000$\245\015h 3\144\001\016@@\199\127\001\n\252\000\026\006\148\000\154\246\031\164\026\168\011l\030\211\127\008f\1288\248?0\\@\178\127\025\129~a\002{\t\024T O\254g\004\008 \160\139\190\002\013a\005rX\160\225\193\012\245&\204\2030'\253\135\179\025\161\193\012\166\025!.\002\008 `(\252d\001i\252\207\192\n\014\004Pr`\000\198\228_`\234\002\199\024r\172\253\249\207\240\027d\004(\176\2553\130\189\005\014]\198\255L\000\001\004\140\181\191o\254\0033\006P\134\025\024\141L\127\255\130\228\024\255\191|\013T\249\005\200\250\011\214\199\008u\236\255\151@60\165\128\130\002D\129\013\251\240\159\225'@\128\001\000)R\226_\232\219$3\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tf.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\134IDATx\218bdc\152\240\208\204\\\129\223\222Q\134\129\143\143\131\225\239\127&\0066\022f\134\192P~\006\030nF\134\127\255\024 \128\137\145\225\255\143?\012o\214\174f\248\247\253\011\144\203\200\240\251\211'\134\151\251\2473\1888y\242#@\000\17700\176\011\159>\249\129\219\214N\150AQ\137\151\129\137\153\137\129\149\133\137\129\159\143\139\129\131\003\213 \006\182?\012\255T\148\024\254\255\252\193\192\240\247/\195\135\179g\025~\156<\201\192\206\192\192\002\016@@\131X\254\000U1\028=\242\138\129\141\141\137\129\137\149\153\129\003\136\141M\217\025X\128.\251\251\239?\216\028F&&\160\001?\025\190\222\184\193\240\239\219W\134\255\191\1273\188;r\004,\007\180\235\031@\000\001\013\226`\248\207\192\198p\242\248'\134gO\25500\17802\240r\1770x\249\241\000\013ba\248\253\027j\016\208\208\127\159\1910<_\181\138\225\247\187\183\012\255\255\252a\248\250\232\017\200\016\134\223@\215\000\004\016\216 \006\006N\160a\140\012@q\134\127\140\255\024\248x\254\003]\206\200\192\200\200\004t\t\194E@I\134\239\015\1592\252z\243\156\225\255\255\255\012\255!\174a\248\011\148\006\008 \150\255\012\\@&7\208\024\022P@\000\021\128\194\133\153\129\133\141\139\129\157\131\153\129\233\023$\136\024Y\153\024\254\176\254c`\252\015T\247\255?\003\012\192\012\002\008 \160(#\003\004\003m\004\027\006r\t\011\003+++\016330\252G\024\196\196\198\198\000\2449H#\003<\014 \248?@\000\001\197\191\003\153\204@\237\127\192B`#\025Y\129I\128\017\024{\204`/@\194\136\005\136\2551p0\254\005\171\249\011\t\027\176=@\235\024\000\002\008\232\132\159P\131X\160B\016\195\152\153\025\025\152\128\225\194\012\015#\160(P\140\021\024\134\127\161.\129y\013\168\139\017 \128\192\0061\130\013\128\249\027\226U\024\015\017\026\140\012\200\000\022\024\204P\026 \128\128\006\253fA\248\024\226\200\255\012\172\012\191\255\252g\248\243\023h\251\031\168\139\128^\250\011\244\253\207\255\204`/1@\189\007\213\197\004\016@ \023\189\005j\004\154\244\031\020\178@\143\252a\004\234\255\255\242\213kFVp:b\004\006\211\127FP`\255{\255\237\255\235\127\255\025\127C\\\244\031\026c\012\159\129\134\000\004\024\000\156}\201\015F\202\143\190\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tg.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002)IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012  \000\196k4\024\024~p\002\025\127\024 \128\145\001\014\024\153\024\025>\253\248\196\176\255\230~\134\147wN~\000\008 \022v\006\006\145\031'Or\179\218\2171\008()1023\131\021\242\000\177\156(\144`\199n\208\223\127\127\025\206\190=\203p\242\236I \135\129\005 \128X\254C\149\189?r\132\129KS\155\225\207\163\007\012 7}\007bie\160$\2080\166\031\008s`f\253\255\255\155\225?\203\017\134\222T\006\134o\159\025\254\001\004\016\203?\160 \0083\200k1\176y{2\252<r\146\225yi\001X\204 \011\170\139\157\001\005@|\255\135A\129\251\017\195_)\160#\2223\176\000\004\016\203_\168\203\191\1598\198\240\139\145\145\225\227\134\003\012_\239\223g\000y\240\209u\006\006^m \227\027\170\183@\006\129\194\242\031\208\182?@\205\239\19010\002\004\016\227\028\006\134\015\220\012\012\252\028\140\236\012\127\255\255\004[\206\008\132*@\015j\248\0029\018@\252\017\213 \136iP\175\128\240\015\134\159\000\001\004v\017\008\255\004\026\194\002\164\127\131}\242\031,\198\240\019\136ANc\130bdC\254#\241\153\024\254\003\004\016\139\213\017\006\006A`\\s\002\157\194\202\n\212\007\212\200\012\180\157\021h\210\019\160\248\127 \159\233/\170c@^\250\011\020\251\013\180\245'0\"^\191d`\000\008 \022v1\160\011\004\025\024\2168\128\152\141\129\129\005\232,&\168\237\210\012\216\001,l~\253\002\250\n\168\254\255\023\006F\128\000b\217p\003\024\160\252@\003\128.b\134\025\194\132p\253\127\006\212\168\007\007\213?\168\171\128\134\253\001z\255\253k\006\006\128\000bd\008d\248\194\192\198\192\013\014\003\148\132\130\022\014\0128\228!\129\253\027 \128X\024\132\025\222\000C\249\031P\0013P\002b\220\127\176\018F\168A\255\225\218\025\161lF\1848\196 6\134\159\000\001\006\000,d\172\206\140\192\238^\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_th.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\156IDATx\218b\156\203\192\240@\194\220\\@\194\209\145\129\133\143\143\225\255\255\255\012\255\025\240\003F\016fdd\248\243\233\019\195\139\253\251\025^\156<\249\001 \128XX\024\024D\190\158<\201\205lg\199 \160\164\196\192\192\204\012V\252\031\143!`\240\247/\195\251\179g\025\128z\025\128f\176\000\004\016\227\165\171W?\240\240\240\240spp0p\0021#\003q\000d\209\247\031?\024~\000\241\167O\159>\003\004\016\011\011\227?\006\022F\160w\254\252d\248\245\227/\216N\144\179\241\026\242\255?\216\168\255\127\254\128\2452\254\251\205\002\016@@\029\203>00p\240\195\157\206\248\031\201c\255qx\140\017h\024\178e\159\127\000\004\016\0113\003\031\144\193\013\196@\15920\001\2452a\241\004J\232@\193?(\254\003\150\004\008 \150\255`\005 \205\204PL\138A\127\1614\211\127\128\000b\249\199\240\005*\0003\136\017\138\241\197\027\204\251\127\161\248\011\003@\000\177\220\186\165\199 ((\196\192\193\193\206\192\198\198\198\192\002L\016LLLx\003\251\223\191\127\012\127\128\001\253\235\215/`\172\253dx\241\2269#@\000\177\252\001\186\226\015\208; \154\017\136\255\0031\019\003\001\131\128*\255\000U\"\235\005\008 \150\011jj,\188X<\246\015G\1561a\241\216{\1600@\000\177\252b`x\003\012\165\127\140\136\144\006%\000PJa\252\143\008mF\168A\160H\135\165\178\255\176\224\254\204\192\240\019 \192\000\1763\137\205zX\235\002\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tj.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002FIDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X~20\252a\001\138\191<r\132\129\129\141\141\129\145\149\021\174\233?.C@r\191\127\131\245\252\006\178\12700\252\003\008 \198\227\019\230\127\224\225b\227gb\254\207\192\198\195\205\192\192\196\004t6L'\023P\195g\134\255\127\12720q\138\001\149\127\129\024\002\178\225\223?\134__\1902\252\251\203\200\240\254\243\183\239\000\001\196\"\224n\193\192\203\203\203\192\194\194\0024\131\t\140\017\224\003\208U\220 \127\128\237ed\016\128\203\252\003\026\004\194\127\254\252a\248\247\246-#@\000\177\128\002\141\025\024.\172@/\129h&\176\139\024\025\254|x\198\192\204)\200\240\251\195}\006\134\223?\025\216\196u\024\254|y\205\192\"(\tv\017\200\144\191\192p\250\015v\030\003#@\000\129\013\002iF6\012\164\146\145\141\157\129\133\147\151\129\241\167\008\195?\198\215\012\172\028\220\012L\012?\025X\128j\128\178`C@\000\234\139\255\000\001\0047\008f\024\204U\172\252\178\012\012\223\1911\176\222\234\003\026\012\212\196'\205\192\202%\197\192\192\nq\013$\226\254\194}\000\016@,\171_\030d\224\249\193\206\192\193\201\012\180\013b\024\003\019#0\246\184\025\254\0035|\229\002\026\242\255\031\003\231\207\147\012\204L\252\012\255?|\004\0074\200\144?\191\2551\252\248\014L\006\175\1910\002\004\016#\195D`\136\2422\240\131lb`\134bP\172\253\131\178\217\161\161\251\011\136\255\128\252\002M\023\127\161\024\020\255\239\024~\002\004\016\011\003\007\003\008\003\147\020\0203\162%\152\191P\026&\015K`\255\161\006\131,\227d`\002\008 \022\160Mo\024\190\000\237\007\250\nh\000\019\216\024&\160\178\127P\227\024\025\254\131C\023\198\134\145\012`5\016\195\1900\252\004\0080\000o\176\187~\133v\020F\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tk.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\006IDATx\218b<\227\239\250`\234\191D\001qm]\006>\001v\006\031\1613\012\219\191\1522\252\249\206\196 \196\253\147!D\225\005\195\172\171\178\012\140\012\255\193\152\001\136\2553\252c`d\252\199\240\229\211\015\134\131\251\1590\156:\249\224\003@\000\1778\\\140\0199jq\133\251\147\166\008\195S!K\006Ev\001\006\165\255\146\012j\028/\129lV\134\157\031\012\024\212\212~20A\013\249\007\196B\252\255\025>~\250\199p\226\212O\134\211'?\000\197\217Y\000\002\000I\000\182\255\003r\016\253v\206\242\011\008O\014\210\000 \015\243\000\234\225\220\000&\002\232\000\021\242\219\000\203\227\002\000\015\232\212\000\202\227\016\000\236\235\246\000\234\235\247\000\236\246\254\000O\007\213\000\252\251\246\000\153\173\245\000\229\227\245\000\001\000\254\249\002\136\229\211\031.\134\223\191\249\025\254\\;\207\240\241\213\015\134\167\015.20\168\15410\255\127\203p\242\165\021\003\239\219;\012\139^\t\002\249\127\128\174\001\186\137\241?\195y-.\134\199O\1902\156\189\240\029\200\231a`\249\255\135\005 \128\024\185d\182}8b\249\136\255\248\175\223\012\217WB\024\222\240\0271\136\254\191\192\208$\182\134!A\244'\131\220\025G\006\134\155\207\025\024\128abo\200\200p\241\250?\134\015\192\240\251\207\196\194P\231\250\018\028V\141\187\184~\000\004\016\2119\143;\012\229\151\164\024\1787Z30<x\201\192\198\197\196\192\251\2489C\237N[\134\248S\218\012\159#\206\0035\t0\240\200\2022LR\190\197\016\227\193\011\012%a\006\134\127\130\012J\\\188\012\170\\\\@gr2\002\004\016#\003\195v`h\241\243\179\130\157\205\202\240\135\145\157\129\233\255o\160W\2543\252f`\001\186\228/\200\233@qf\006m}V\134'\247\2541|\254\244\151\129\013\232\209\031L M\191\025X\255\191\249\001\016@,\204\012\223\025\152\129q\194\008\210\244\255'\003\227\255\239\160\192\003b`\\\000\241?`d\129\2123\001\233\171\023@\170\254\131T\130c\143\237\223? \253\007\168\246;\003@\000\001\013\250\001R\0061\008h$\0082\128\141a\000\211\204p\022\003\003\007P\243\015P2`\226\006\154\244\005\200\255\013\020\253\003\196?\025\001\002\008h\025\208\021@\204\000\022\252\011N+\016m\204`\187\2553\176B1\011P\150\153\129_\134\151\225A\244\030\134H\243\247@\237\255\161z\1272\000\004\016\208\025\191Y\024\192\017\203\000\215\204\192\192\nfC=\005\149\251\007N\142\223?02pq\2411\252g\231\002\243!z\2550\001\004\016P\215\2077@\027\129\188\255@\157\255\129\186\254\002\157\243\007\024\212L\140\016C\152\255\131\162\001\164\001\024\233\255\255}\253\195(6[\007(\244\229?\251\255\175`\20720|\254\t\016`\000j[\028c\136 r}\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002+IDATx\218bd\200bx\224\192i!\208\203\219\202\192\195\197\196p\145\249!\195m\253\167\012L?\152\025\254\253\251\203\128\002\024\145\152L\140\012\159~|b\216\127s?\195\201;'?\000\004\016\011\003\027\131\200\253k\247\1859\156>20\024\2012\232\253\210e`\020\225f`g\226f`\252\207\192\240\243\2077\134\255@\136n\224\223\255\127\025\206>:\203p\242\217I\006\006\022\006\022\128\000ba\248\199\240\231\133\208k\134\199\027\0151(\255ve8\199v\151\225\145(#\195\175\183_\128\138\1273(rk1\220\253p\149\129\129\t\213\160\223\127\1273\028\185w\004\194\255\207\240\015 \128@\0061\136~\020ax\243\134\135\225\253\153c\012W\159?eX\198w\137\129\249\237g\006W\233@\134\167\255\1423\236\190\179\030d+\n\248\243\239\015\195\163w\143\024\192\142\253\203\192\002\016@, \198'\214\143\012\255_\1762p\252fa\184\251\245\022\195\253'\215\025\162$s\025>}\255\207\176\244b\031\003\003+R\248@}\249\255\223\127\008\027b\016#@\000\129]\196\196\204\201\240\235\203;\134o\002\178\012\204,\018\012\255\153\1913,\189\212\197\000\146c\224@5\000\012\254!\241!lF\128\000b\129\249\249\015(\016\152\217\024\254\253\001r\152\161\006\160\1331\0280C\013\248\007\023\249\015\016@, \191\255g\248\194 \202-\204\192\003\2447\023\195[\006`LB0.\131`^\250\003\2452\208\013\000\001\196\002b\008\252\020f\248'\255\155\225\157\196c\006\169\187\210\016\155\152\t\024\132\172\134\153\129\017 \128\152@\006=\019~\201\192p\237\028\131\2349N\134;\191NA\002\023\217\230\255h\1342\"a&\008\006\008 &\144\169Ro%\025x\229\229\024\206\154\255d\176`\241a`\248\014u66\252\023\138\255\161\026\n\016@,\012?\024X\216\153\2551H\200\0252\252;w\141\225\142\236o\006\134\015@\201\031(\129\137\234\018\024\251\031<\250\153\000\002\012\000\143+\195\165\2149e\022\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tn.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002?IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013 \131\254A5\193\248LH|\134\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\128\n\254\128\196\223\0299\194\192\204\198\198\192\200\202\nw\141`X\020\003\171\1808P\197_\134\223\247\1590\188\223\178\014\238\170\255\191\127\131\2450@,\252\007\016@\140\139\024\024>p10\240\131\220\193-'\199\192\200\194\002\150T?q\130\225\215\157G\012?\151,g\224\169*b`g\131Xp\197\194\002b\209\159?\012_\031=b\248\011d~b`\248\014\016@,\127\161^\0009\251\027H\002\232w\181\153\171\024~\223|\200\240*7\143Av\207f\006&`\184\129\196A\150IVv2\220J\011\003\139\193\188\0154\131\017 \128\152\254A9\176p`\004*\016\142\244`\248\2126\159\129?\172\138\129\135\131\131\225m\209\028\134'f\158@\175\1793\136Gx\128\213\192\188\0153\008 \128X\024\161\174\129a\016`\005\134\021+\019\011\003+3\016\003\195\140\141\137\149\225/77\152\205\192\196\200\192\130\020\025P}\255\001\002\136\t\228\\V(\230\000b6 \254\190b7\131d[6\195\1755\157\012\255\129a&?\183\128A\237\194^\006N`8}Z\189\015\172\134\003I\031\200\012\128\000b\\\n\012l>``\179C\005a\1742\001:\255\199\213\219\012\223\154\219\025\004\022\205d\224\002\026\002r\193\t`X\253\133\186\2327\016\255\004\226\183@\n \128\152\152\160&2!%6\0168\011Jp\175?2\240\175\152\199\240\031\152f^\175\217\197p\028(\246\015I-\178^\128\000b\001\018\224\248\254\139\148ra\001\127\222\209\020\133\207\138&\015\211\0034\140\t \128X~00\188\249\015JPH\014\003\242\129\030\003\211 \013\224\200\132\186\246?#\148\013\146\130\198\024(\029\253\004\0080\000\229\145\181\226\145\151\193\150\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_to.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\224IDATx\218b<z\244\232\003a\017\017\001^\001\001\134\127\159\19130\252\251\207\192\"\200\003\166\153\152\024\025\158\206\154\197\192\200\128\000\1400\204\200\200\240\251\211'\134\151\251\2473\1888y\242\003@\000\177prr\1380\178\179ss\176\1782|?\179\159\225?33\003\175\151\023\195?\168\006a55\184\001\2004\195\223\191\012\031\206\158e\248q\242$\003;\003\003\011@\000\1770\177\177\253\249}\255\001\195\245\170J\006!''\006F\160\129_\175^e\016\008\143b`\151\018g\248\012d3\161\027\002\004\255\127\255fxw\228\008\152\013\180\244\031@\000\177\128\156\200\240\151\137\225\221\241\227\012\223\158>e`ba\001kd\182\182g\248/,\192\240t\209\"\012\131\254\131\240\159?\012_\031=\002\187\2527\208E\000\001\196\242\255\255\127\006N\013%\006\227\023/\024.\203+2\252\249\245\131\193\248\245k\176\002\144\001?\238\223\135\135\011\003\146A\255\128\250\254C\\\195\240\023(\013\016@,\204@\023\176\002\195\133\t\232%\197\027w\025\152\128\162\172\236\236\224\192\004)\004\218\004\015\175\255\012\152\000f\016@\000\177\156\208\208`\224\002r\128\001\198\192\t\242\018\016\223\132*b\129\242\153\145\\\002\163\255B\217L\016\252\031 \128XX\161\006\176A5\178@\217\012X\002\024\217k\127 a\003f\131,\002\008 \176A\172P\205\172PA&4\023\160\027\250\015\141\013\212\195\008\016@,LH\154\025\177x\001\023`\132\234\129\233\005\008 \144A,\012H~\198e\024#\022y\152\030\160aL\000\001\196\242\131\129\225\013P\240\031#\146\195\128|`\\\129i\152\030F\168!\255\025A\185\003*\014\1411\134O\012\012?\001\002\012\000\002\230\140v\001S\218\216\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tl.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\008IDATx\218bt\145cz0\211\213\\\128G\212\129\129\137\143\151\129\225\255\127\006\162\000##\195\191O\159\024\190\236\223\207\240\254\228\201\015\000\001\196\178\231\209?\017\229+'\184\223-\177e`{\167\204\192\248\136\137(s\254\255\253\203\240\235\236Y\006\230\147'\0258\024\024X\000\002\136\005(\246\135\225\228\127\006\239\184\195\012\1477\1781\168j\17620\172\004\138>#\224\178\223\191\025~\0319\194\192\0082\148\129\225\031@\000\129\232\015@\204\015\146\147\147\147c\176\014ga\152X\004\020f\006\nD\003\233\187\255!J\145]\003\"\254\252a\248\243\232\017\195_ \243=\003\195w\128\000\002\027\196\204\204\194/)\173\196\240\228\209-\160\215y\128B\223\024^\191\006)\007J\191\002\226\016 \243:\170\129\255\128a\249\015\236\029\006\134\183\012\012?\000\002\008$\246A\2154\240\255\219\183o\255\239=|\013\166\026\136\025\255\167\1500\254\255\242\133\001\138\153\255\127\142b\249\255\025(\254\t(\015\244\198\127\160\001\255\159\003\241E\160A\000\001\004\n#\0063\187\008\006fff\006^\030\014\020/|\255\202\192\192\202\138\228%>\006X\152\128\189\004\002L\016\252\031 \128\024\160a\244\223\206%\002\234\018&\176k\128\145\002\193O\153\254\255\213\005b\144\024(\178\128\2487\016\255\000b\144\203^\003\241\021\160\157\000\001\0047\008\134]3\129)\2337\227\255\255\255\129\024h\192\127\160\001\255!\169\011\142A\134\253\004\226\207P\131.\003\189\006\016@(\006\173~\013r\tP\179\021v\003\240\025\004\016@ \131\1900X2\254\255x\138\233\255\247l\166\255\191\128\006\000c\002/\254\005\196\223\129\248#\194k\191\000\002\136\197U\142\233\205T&\134\127\239\204\254331\252g\002\006\028#4\240\024\025 \004\200\021p\246?P\000\130\162\031b(\195OH\244\255\004\0080\000\133\166\0190\001\153\133\193\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tr.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\006IDATx\218b<\195\192\240@\208\220\\\128\199\209\145\129\137\143\143\129\225\255\127\006\162\000##\195\191O\159\024\190\236\223\207\240\254\228\201\015\000\001\196\194\193\192 \194|\242$7\171\157\029\003\155\146\018\003#33Q\230\252\255\251\151\225\215\217\179\012@\189\012@3X\000\002\136\133\145\129\225\015\0163\252>r\132\129\153\141\141\129\129_\128\129\193\200\156\129\225\243\023\006\134\139\167p\155\244\2517X\015H/\208\015\255\000\002\136\241\026\003\195\007\030\160v\144;XV\174g`p\176b`\252\249\147\129\225\228y\1604PI{#\003\195\167\143\168\174\001\017\127\2540\252y\244\136\225/\144\249\158\129\225;@\000\129\\\196\192\004\196\204\tU\012\140\142\214\012L\217\245\012\012kf t\169h\003C\241\001F\216\253\003\242\153a\134\002C\012 \128\024n\000]\244\028\200\127\251\246\237\255\015\031>\252\255\004d\127\006\226/\232\184q\253\255/\006\174\255?32\130\213|\000\233\001b\144\222\139\012\012?\000\002\008\225\"` \179\174\185\002\182\133\017=<&\237e`H\183a`0Ub`\240\210\007\187\226/T\138\t\130\255\003\004\016\195-\160\139^\003\025\159>}\250\255\227\199\143\255\191A\017\130\142\005\132\129\145\244\247\255\223\19620\031\164\230\007H\015\016\131\244^\001\134\017@\000\193\013\250lj\253\255\231\207\159\255\255\182N\000\133\006\004s\243\252\255\207\203\135\224\1310\208k \195~B\131\000\164\2472\208k\000\001\0047\008\020\014?\003\195\1926\131\193\142C\255\255\023\182\254\255\207\202\134j\016\212\149?\161z`\006\001\004\016#\200 A`\244\179\003\253\202\006\n+\144\159\149\180\128\142\253\206\192\240\252>\214$\244\015\026F\191\128\024h \195\011 \005\016@,\223@\169\018*\192\0023\232\2225\188\169\026f\208\031\168a\192\240b\002\0080\000\008Q\004\146\224\230F\028\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tt.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002jIDATx\218b<\148\155\247\160\244\243W\001G\tQ\006>>>\134\255\255\2553p\137)0\196\008\2030\188\185~\132\225\007\003*`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136q5\003\195\023\211\242J\238Y\202J\012z|\188\012\204\204\204\016\029\002\162\012^\162\210\012\159n_`\248\005\213\204\128D3\252\253\203\240\225\236Y\134\219\221\221\012\223\025\024\190\002\004\016\011\208\198?7;\219\025\242\167\206d\152\254\029\200{\248\000n\251Uiy\134By\021\134\239\199\246\130]\198\136\228\178\255\191\1273\188;r\004\204\254\007D\000\001\196\184\136\129\225\003'\003\003\191\000P@\175c\"\131\203\181K\012_\143\236G\232\2087a8ae\207\240`z/\195G\168a\255A\248\207\031\134\175\143\0301\252\005\178?10|\007\008 \198\249@\131\184\129\006\129<\196\015\196\006\013\211\024\228\143\031d\248\182k\021\1940S\007\134\215\206~\012\215;\138\024\222C\133\254\001\195\018\232\018\134?@\012\180\224\007@\0001\253\1318\013l\211g \190\220\144\197\240\194(\140\129\2115\021\028\240`|j?\131\200\254C\012\134\165+\025\132\161b0\000\210\011t\021#@\0001\129\012`\130b\022 \254\006\196\151\218\131\025\222\155z1\240xd \\ub=\003\207\225\149\012&\213\027\024$\144\244@\241\127\128\000b\002y\137\021\138\217\129\024\024^\012?A.k\013`\248hc\204\192\237\021\1370\236\248Z\006\246\003\211\025\140\154\2311HC-\006\233\003\153\001\016@L,H\002\172P6\027\016\127\007\025V\147\202\240\197\222\142\129\203'\020a\216\209\157\012\172{\1513\2324\2452\136A\013\001bF\128\000bb\130\153\136\020\189\176\016\000\197\210\133\242L\134\175\214\238\012\188>1\008\195\014\236f`\223\177\129A\179\182\137A\024\170\015 \128@\006\1770@\002\012\028\003\191\129\248\023\212{ \246k >Y\153\002\0123\031\006\030\247X\132a\199\0143\240\238\221\195\160V]\003\138m&\128\000b\\\200\192\240\000\0246B\140H\014\003\186\008\020/\140P\151\129\217<\160T\016\209\252\223\234\217M\198\007\135\150 \028\174\161\197\176\217\205\245'@\128\001\000\198\241\196\189\229L\255+\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tv.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003uIDATx\218b<\227\239\250`\234\191D\001qm]\006>\001v\006\031\1613\012\219\191\1522\252\249\206\196 \200\249\131!T\246&\195\\u\027\006\150_\255\024\024\255\255g``d\000\003&\198\255\012o~13\236\127\250\133\225\214\147G\031\000\002\136\197\225b\156\200Q\139+\220\1594E\024\158\nY2(\178\0110(\253\151dP\227x\197\160\200\198\198\176\243\1333\1312\0313\003\219\255\127\012\012 \131@\000h\216\143\127\204\012\230\127\21500\191;\206p\1385\155\005 \000\000I\000\182\255\003r\016\253v\206\242\011\008O\014\210\000 \015\243\000\234\225\220\000&\002\232\000\021\242\220\000\203\225\000\000\014\224\207\000\208)%\000\238\244\251\000\231\248\001\000\233\249\000\000\240\250\251\000\227\248\002\000\194\234\252\000\201\240\027\000\237\245\012\249\002\000I\000\182\255\004\243\252\n\000\250\252\015\000\252\214\208\000\241\235\248\000\229\223\210\000\000%5\000\003\255\238\000\201\232:\000\012\218\213\000\168>C\000\249\239\000\000D\013\188\000\231\253\025\000\002\000\254\000?\020\187\000\132\225k\000\012\254\026\000\008\254\232\004\002\000I\000\182\255\001\t\021\183\240\197>\223\015\197\244\252\000m\216T\000\236\015-\000\021\255\212\000\128\018\171\000`\022\248\000 \177N\000\000\168\017\000\002\247\002\000\153\030p\000\223\251&\000\134\231k\000$\007\227\000\235\245\017\000\243\252\003\000\012\243\231\248\002\136\241\\p\210\135\178\253>\252{\222\169\002=\255\147\225\147\158\t\131\244\165S\012\159\025x\025\028\216o3l\241\155\203\192\155\176\132\129\2373$\176\127\001\221\195\251\255\023\195\159\191\012\012l\204?\025\146\133\1510,\186k\253\019 \128X\140\189K\025\254\135\0081\008\136\253g`d\229d\016\252\253\131\129\143\253\031\131 \195o\134\003\159\148\024x~\1863Xs_a\136\021[\198\144\249\160\141\129\031h\025?\251O`\224\255`x\253\141\155A\141\253\n\195\175\255N\255\001\002\136\137\255\215O\006a\160 \203\251\255\192\024\248\205 \240\245\007\003\235\199\223@\252\159A\236\255w\006>\230\127\012?\127s0<\254\175\192\192\206\198\196\240\145\145\155!Wz\nC\151\\!\195W\006\014\134\140G\189\012\192 c\000\008 F\225\153\231>0\242\008\2403\177s00\178\176000\0031#\0198\150\129n\004z\228?\195\151\191\\\012\255\254\1790\240\178|f\144\229z\204\240\235/3\195\165\207J\012\162\255\2222\252\251\249\147\225\255\251\151?\001\002\136\137\017\152\176\152\152\129Z\024\161i\004\154P^\255\231cx\253\151\143\225+\208\016'\193C\012\145\018k\024\190\254\227dh\147,e\176\229>\204\192\201\240\007\156(\153\129.\006\233\005\008  \251\031\011\208:\134\255\127\2551\252\007\209\127\2543\188\255\197\193P*6\151a\182l1\195\223_\012\012B\204\223\025LYO\001\147\201\127\134\192[\027\024\022\188\138\005F\197\023\176\030\144^\160\171\153\000\002\136Qd\242\225\007\012\236\\B\012L\172\204\255\024Y\152\128\194\140\223\025\184\255k\243\222cd\001\218t\249\147\202\127P\238\248\203\200\200 \200\244\013h\023\144\001r\013\208\004\198\127@[\254\000S\232\167\183?\001\002\012\000\149\207J}\146$W\205\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tw.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\252IDATx\218bdc\152\240\192\204\\A\192\214Q\134\129\151\143\131\225\255\127&\006\006\006\016f\004B&\134\255\012,\012\225\012\203\024\190\002E\254\129E\161\152\145\145\225\247\167O\012/\247\239gxq\242\228\007\128\000ba``\0239~\242=\183\163\163<\131\167\167\024\131\1804;\195\243\023\191\025\030\220\253\197\240\235\015P\007\003+\003\031\131\026\003;\144\245\031j\008\024\252\253\203\240\225\236Y\134\031'O\130\228X\000\002\008h\016\203\159\191\012\204\012\159>~cPRb\005+W\144ga\184|\241#\195\157\187?\128|n\006s\134\171`\023!\131\255\191\1273\188;r\004\204\006\186\244\031@\000\177\252g\224\0002\217\024\174\\\253\194\240\227\1997\176\183@\206>\176\231\025\195\190\195\159\129|!\134\000\134E\012\239\160^c\128\186\236\255\159?\012_\031=\002\139\253\006\186\006 \128X\2541p\001\157\203\201p\236\020\019C]\231;\134\248\024\017\134Uk\2220\172\221\248\147\225\195G&\176\215\2542\220g\000\185\237/\146A\255\254\255\135\208\016qF\128\000\002z\249\224\007\006\006^~H\000\1790\136\002\201\215\224\144\000)\003\133\012\007\195Y\006Y\134\151\232\006A\241/ \006\026\240\019 \128Xv0\2163\240B\181\252\134*\006\133\020\015T\003H\236-<\030\017\006\193\012\133\198\241\127\128\000by\0115\149\029\236\030\008\006\217\244\019\170\008\164\137\025\138\025\144\012\250\003\181\004&\015\016@ }\240\180\193\132D\19540\192\020!\185\232\031\026\027h\016#@\000\1770AMDw:2\141\013\192,\132\233\005\008 \144A`\011\255\162\217\138n\024#\022y\152\030\160aL\000\001\196\002\140\2147@\193\127\140H\014\003\242\129\145\011\166\025\144\0194\144\248\207\008\137j\17684\234\025>\001\131\020 \192\000\004\238\159\221j<\233@\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_tz.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002qIDATx\218bdHbx`\174b.\224\168\238\200\192\199\193\199\240\255\223\127\0068@b\194\001\023\003\131\188\004\003\003\2195F\134\243\231>1\236\219\191\159\225\228\201\147\031\000\002\136\133\129\133A\228\228\179\147\220v\154v\012J\018J\012\204\140\204\152\134\128\216,\012\012\162\"\012\012L\239\024\024\222]g`\248\241\239/\195\159\191gA\134\128T\176\000\004\016P\154\225\015\136u\228\222\017\0066\0226\006VfV\132! \154\137\129AD\156\129A\224\031\003\195\173\149\012\012\207>C\164~\255\254\205p\228\200\017\152U\255\000\002\136\145!\133\225\003\003;\003?\003#\003\131\156\144\028\003\011\019\011\220!l\194\012\012\014\154\012\012\127\15110\236=\128\234\195?\127\2540<z\244\136\193\216\156\129AZ\220\252;@\000\1770\252Cx\227\209\251G\012\140\255\129&r30x800p\156f`X\233\202\000\180\t\019\176\178\255g\008\tg`\248\245w6\195\1665\218\140\000\001\196\0026\004d\024P?\0030x\212L\2543(\000\013z\147\206\192p\250\017\003V\224\025\004\180\1559\159a\255\206,\134\183\031~\001\131\239\014#@\000\177\192\\\195)\205\192\224d\005T\208\207\192\176m3v\003\244A\222\1445ax\254`>\195\2493\194\192\224{\204\192\202\240\003\020\144\255\001\002\136\133\129\135\129\193\219\159\129\129\253 0\028\156\024\024>b1\128W\128\129\193\215\011\024S\191W0\172[\237\002\020y\200\192\198p\019\232\137\127@w\128\226\234;\003@\000\177\248\152\002\1633\137\129\225\216c\236\174\008\013\003\006:g\"\195\246\181\141\012\239\190\252\004\026p\001\232\018PX\252\005c\136A?\025\001\002\008\0202\160\176\228G7\192\216\140\129AQ^\151\225\233\163\005\012\199O\202\0005\223\006\026\242\011\026\160 C~\131\241\127\160\216\127\134\143?\001\002\136\005\146\212\016\128\155\023\024c\030@o\252\218\192\176f\181-P\2289\208\128\007@o0\0035\176\195\013a\004\027\248\027j\240\031&\128\000\002\185\232\001\016\0111\002Uz\248301\253\235f\220\183\195\243\255\247_?\025Y\129!\198\008\012H`\0200B4\252\0072\2540B\210\240/\160\2487\160\225\160\192~\251\019 \192\000\127\254\186\220 \198\150\236\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ua.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\182IDATx\218b\020\153\176\255\129\177\140\168\128\1814\031\003/\027\011\195\191\255\140\012`\240\159\001;\128J31\254g\248\252\235\015\195\209\167\159\024\206>y\253\001 \128X\024\2178D\206\127\254\199m\201\194\202\160 \200\201\192\204\200\200\240\255?\154.8\128H\000\1490\252\005*\186\248\246;\003P/\003\208\012\022\128\000b\249\207\192\244\135\145\137\137\225\212\235\239\012l\204L\012,@6\170>F\004\007\201\220?\255\254\129\2450\000\213\003\205\252\007\016@ \131\024\254\253cb8\253\230\023\195\243\239\255\025\152\153\0241\253\129\230\"\016\248\251\239?\195\147\175\191\025\254\003\245\254\255\251\159\005 \128X\254\252ce`\252\207\006T\195\194p\255+\019\003#\019\212\237\248\000\208\t\255\255\129hf \254\003d\1790\002\004\016\203\199\239\028@\017n\006\006\022\160aL@\tf&\136Kp\025\006\014\192\255 '10\252\251\011\244\227/\006\134\239_\025\001\002\136\241\230M\134\015\002\002\012\252\236\236\012\012\172\172@s\152\137r\016\195_\160\025\191\12730\252\252\201\192\240\234\021\195\015\128\000b\001i\002\133/\008\131\012\001a\228\240\198\006\254\253\131\134\211_\136Z\144\025\000\001\196\002\015V\168o`\134\018\002 \195`.\007\186\144\017 \128\136\208B\028\000\008 \022\160i,0\027@\024\228\220\255\255\t\187\006\134\161\190a\002\008 \150o\223\024\222\000\025\255\128\001\205\012\244\018\019\019(\0050\129\019\012#T\209\127\144\211al\160fF\144E@\250\255\159?\144\192~\251\150\225'@\128\001\000\138M\1555\190,\023\"\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ug.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\245IDATx\218bd``x`nn.\224\232\232\200\192\199\199\199\240\255\255\127\006b\000###\195\167O\159\024\246\239\223\207p\242\228\201\015\000\001\196\002\020\019\0012\184\237\236\236\024\148\148\148\024\152\153\153\1372\232\239\223\191\012g\207\158\005\025\002\226\178\000\004\016\227\213\171\012\031xx\024\24898,\02588\156\128b\172h:\1604\134\249\191\025~\252\216\007\196\199\129.c\248\012\016@,\140?\128\206\004\186\235\207\175\227\012?\190?e``ba`\132*\253\255\000(\199\007d\252b`\248\247\029\200Vd\000\203\129=\255\239\015\195\159\223\143\024\024\255\001\153_\025X\000\002\136\229\1641\003\0037\200m@\204\196\240\136\129\137\017b\012P\031\131\146f$\195\195\2188\0065\025\003\134_E\245\012\247\206\205b`g\128\024\246\015\024\150@3\024\254\000\241G\160\016@\0001\238d`\248\192\203\192\192\207\nu=3\2127@\1352\232}\249\194\016;\127?C\139\139&\131\188\172\004\195%`\024p \169\249\011\246 \003\195[\006\134\159\000\001\004\178\252\003\212\181\024\248\231\207\159\255W\031z\252?\195V\246\255\207\231\175\254\227R\007\242\000@\000\2255HD\194\250\255\151g\127\255\191\251\244\247\191\142n ^\131\000\002\136\241\214M\134\015\130\130\160Xc``c\003\134\0210\176\152\152\160\001q\027\026\008\028PZ\025\"\254\015\0248\127\128\252_\192H\248\001\012\131\023/\024~\002\004\016\0118\196@f\254C\1940\160\n\148\250\014\145g\228BS\003\195P\189\000\001\196rR\147\129\133\007\026k\200I\005\150\190\025q\240aI\236\015$l\152\000\002\136\005\200y\003t\221?F\1369`O\0015\1292\n\227\127\132\025\140PC\2543\130\162\026*\254\015j\2167`\172\001\004\024\0007\030\193\132SP\028\163\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_um.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\203IDATx\218b\148\016\158\250\192\192PN\192\214N\134\129\155\151\131\225\255_\006\006F&&\134\255\012L\012\255\25410\252f`a\008\252\189\012H32\252\251\207\196\192\200\248\159\001\004\024\025\025\025\254|\250\204\240\250\192~\134\231\167N}\000\008 \0226V\014\145{w\191q;933\168\170\240\000\013a\134+\252\247\143\145\225\231\031F\006\025\199,\134_?\2551\252\255\0151\132\001h\013\144\195\240\245\243'\134\191\206\206\012l\223\190\178\000\004\016\203\207?\204\127\024\12720\156<\241\138\129\t\232\018ff&\184A\127\25532|\249\193\194`\254b\027\195oN\017\160\246\255\016C\128\248\223\159?\012\031.\\`\248p\245*\195\215?\255\254\001\004\016\011\019\019\007\003;\027;\195\229\139_\024\222\188y\202\192\204\194\004\178\140\129\025\228t\160\139^}`aHo\020e\248\248\226\027\195\223\1270\023\253\003\186\022h\152\136,\003\151\157<\195\175\175\191X\000\002\136\229\207/v\134oL\156@\21502\220\187\007r\t\200\194\127`\254\031`\024\189\248\200\204\240y\213j\134\175\236\138@\023\130\012b\004\227\191\255@\190\003\169ab\248\254\253'#@\000\177\188\254\192\006\012V. f\001\218\003\012\023\176\141L\012\172@\231\255\134x\146\129K3\144\225\231wV\134\223\127\024a!\004\012\248\255`\195@1\194\252\229\003#@\000\177T.S\001\006\168\000\003\015/;\003+3+\195\247?\204\012|\220@\155\128\177\247\245\015\003\003\023\027\003\195\159\0037\025\152\255\179\128\252\0111\008h\018\200u\255AV\255\007\197/\211\127\128\000b\137Y\027\195 \196\201\204\192\001\140,V\166\255\012l@\197\144@ed`\001F\245\175\255\\\012\247\025-\192\206\128F\003\216 P\210`\004\185\008h\225\191\175\223\025\000\002\136\229\181v\012\195onV\006N` \179\1780\002c\141\153\129\137\145\t\226~hx\240B\162\017\226)\160\225`o\253\253\011\244\234\127\006\022\160\211\191~\252\202\008\016@,\223\015ma`eca\248\195\012\n\023`\24432\003\2450\131\195\233\255\127&\168a\144\144a\004;\001\148\158\254\002\189\0064\008\200\254\t\012\168\239?~1\000\004\016\011\127Y!\139\000\191\000\003++\027\208E\236@\023\177\129\013\002\197\008\2043\008\240\015\156\178\193\006\253\253\005t\209O\134\223\191\1271\252y\251\134\t \128X\030\248\249\189a\007\170\000z\135\025\026\012 O\252\255\007\205\012\140\144\176e\132\196%8I\195\157\008\146\255\003T\249\137\129\225'@\128\001\000\168\195\015rV\132>\240\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_us.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\203IDATx\218b\148\016\158\250\192\192PN\192\214N\134\129\155\151\131\225\255_\006\006F&&\134\255\012L\012\255\25410\252f`a\008\252\189\012H32\252\251\207\196\192\200\248\159\001\004\024\025\025\025\254|\250\204\240\250\192~\134\231\167N}\000\008 \0226V\014\145{w\191q;933\168\170\240\000\013a\134+\252\247\143\145\225\231\031F\006\025\199,\134_?\2551\252\255\0151\132\001h\013\144\195\240\245\243'\134\191\206\206\012l\223\190\178\000\004\016\203\207?\204\127\024\12720\156<\241\138\129\t\232\018ff&\184A\127\25532|\249\193\194`\254b\027\195oN\017\160\246\255\016C\128\248\223\159?\012\031.\\`\248p\245*\195\215?\255\254\001\004\016\011\019\019\007\003;\027;\195\229\139_\024\222\188y\202\192\204\194\004\178\140\129\025\228t\160\139^}`aHo\020e\248\248\226\027\195\223\1270\023\253\003\186\022h\152\136,\003\151\157<\195\175\175\191X\000\002\136\229\207/v\134oL\156@\21502\220\187\007r\t\200\194\127`\254\031`\024\189\248\200\204\240y\213j\134\175\236\138@\023\130\012b\004\227\191\255@\190\003\169ab\248\254\253'#@\000\177\188\254\192\006\012V. f\001\218\003\012\023\176\141L\012\172@\231\255\134x\146\129K3\144\225\231wV\134\223\127\024a!\004\012\248\255`\195@1\194\252\229\003#@\000\177T.S\001\006\168\000\003\015/;\003+3+\195\247?\204\012|\220@\155\128\177\247\245\015\003\003\023\027\003\195\159\0037\025\152\255\179\128\252\0111\008h\018\200u\255AV\255\007\197/\211\127\128\000b\137Y\027\195 \196\201\204\192\001\140,V\166\255\012l@\197\144@ed`\001F\245\175\255\\\012\247\025-\192\206\128F\003\216 P\210`\004\185\008h\225\191\175\223\025\000\002\136\229\181v\012\195onV\006N` \179\1780\002c\141\153\129\137\145\t\226~hx\240B\162\017\226)\160\225`o\253\253\011\244\234\127\006\022\160\211\191~\252\202\008\016@,\223\015ma`eca\248\195\012\n\023`\24432\003\2450\131\195\233\255\127&\168a\144\144a\004;\001\148\158\254\002\189\0064\008\200\254\t\012\168\239?~1\000\004\016\011\127Y!\139\000\191\000\003++\027\208E\236@\023\177\129\013\002\197\008\2043\008\240\015\156\178\193\006\253\253\005t\209O\134\223\191\1271\252y\251\134\t \128X\030\248\249\189a\007\170\000z\135\025\026\012 O\252\255\007\205\012\140\144\176e\132\196%8I\195\157\008\146\255\003T\249\137\129\225'@\128\001\000\168\195\015rV\132>\240\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_uy.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\131IDATx\218b<s\230\204\003AAA\001..\030\006ff&\006\016`dd \n\252\251\247\143\225\203\151/\012\239\223\191\255\000\016@,\028\028\236\"\191~1s3\179\156a\224\226\020\002\026&\206\192\206.\206\240\254\231?\1343\247\1270\176\179\129\012\255\143\208\205\248\031\204\255\247\255?\195\213g\159\024\230\030~\192\240\247\2157\022\128\000b\249\247\143\233\207\167O\147\025>\127>\198 $\228\196\192\196\204\206\192\195\229\205\240\241\167\"\195\197\199_\025\1848`\206\251\143\160\129B\127\254\254e8r\251=\195\135\175@\151\253d\248\007\016@, Q\144\224\239?\199\025\030?y\202\192\195\195\194\240\253\155<\131\152\176,C\150%\007\138c\024\224F\001\005\255\253g\136\215ac\248\251O\012\232\181w,\000\001\196\194\196\196\200\192\201\229\200\240\238\195T\134\223\127\0311\252\253\162\197 %\166\194\176\224\242\015\134\242\140[\012\012\218\172\232\166@\168\127P\014\208@\134\159\159\024\001\002\136\241\198\141\027\031\248\129\128\229\251M\160\004\023\003;\175\000\003#\135$\208\157\255\025\150]\250\194 \202\205\204\192\192\132\022\200\192\240\001\005\244?\144O~\253f\248\240\246\245O\128\000b\217t\243;\003\175\000\007\003+\135:0|\216\024\152>\130\172\252\205\192\207\202\200\224\160\198\013t:\178\223\024\193\142\248\0154\008\020\028\127\254\252f\248\245\235?\195\219\191\204\255\001\002\136\145\193k\231\007\1603\248\025X\128^`\004\218\014M\002\012\204@\029@.#\019z\0081B\189\004\244\027\2080\134\127\127\024\024\190\190\251\001\016@\140\183\174_\255 ((\196\015L\006\012l\172\172\012,,,\012LLL\004\211\207\159?\127\024~\253\254\205\240\227\199O\134\023/\158\255\004\008 \150\200\229\143\025X\184>00\177\176\0031\0270<X\128\2461\0031\200\027\140\240Hc\132\166!F\176\012\196%\255\254\252\002\226\159\012\191>\189e\000\008 \150sO\190\1760p\128\188\004t*\019P\001\003\2080\006`\170\248\207\004\193(\190\250\007\193\012@\2390\252\002\026\006\196\127\12700|\251\198\004\016@\140\231\207\159\127\192\205\205-\196\202\202\202\204\004\001\140@\252\031\238\008FF`\216\254\135\179\129\222\002\t\128\188\247\031\228\189\159?\1272\188~\253\250'@\128\001\000\232\231\253\1355\134S\006\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_uz.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\130IDATx\218bd\136\153\255 \209ZE@VL\144\129\131\133\149\129\129\129\137\129\141\133\137\225\255\127F\134\127\255\024\024\254\252\005\n12@\193\127 \251?\152f\004\210\159~\252d\216\127\2539\195\201\219O>\000\004\016K\150\185\152\200\222\199_\185\253\004\005\025\180\229x\024\184\217X\024\152\024!:\255\002\013\250\241\235?\170A \0004\228/\208\150\179\015\1273\156|\252\149\129\129\153\157\005 \128X\174r\136\253\249#\194\204p\228\201/\006>\225\255\012\156\236\255\024\254\255\003\218\200\196\196\240\227\247?\134?\223\254\"\012bD\024\246\027h\203\017\160A\012\236B@!\206\127\000\001\196\200\228\208\240!T\146\159\255\210\211\159\012\018b\188\012\255X\025A\190c`\001z\237\247O&\134\175_\128\\&d\023A\240\031\160AO\159\127\006\178\152\025\254\255\249\245\029 \128X\174\198h2\2402\1782\176p2\0015\252g`b\006\169\131y\001h(3\003V\240\015\028\134\140\012\127\25400\188\253\244\153\017 \128X\254\218\2323\252\231\231g``cc`df\006\026\198\004\212\207\0081\004\027\000Z\242\031\132A1\241\247/\195\255_\191\024\254\188z\197\008\016@@\0310\130\221\0142\132\153\149\149\129\025H3\2262\004n\214\127\176!\255@\028\144\191\129^\001\008 \150\127\219\1752\252\231\226a`d\003\026\000\140vP \131\195\004)`\017\128\017,\004r\012#\144`\252\003\140\152_@\003?\189g\000\008 \150\213\143\0222\240r33\000\029\195\192\194\204\200\192\204\196\008u\017#\212\024Fx@3Bi\144\139\254\254\003\005\248\127\134\223\192\136{\255\2417#@\000\177\176\000\195\136E\128\141\129\025\148~\128\t\146\145\137\149\225?\019\011$6\192\152\017j\028\136\245\023\130\255\253a`\250\247\155\129\249\207o\160\139\2540\176\188\254\198\000\016@,\172\159>\1790\254\231\002:\135\147\225?\208\160?\140@C\024\217\128\254g\005b \251?34\002\255\002S\005\208\000\134\223\224\196\205\248\031\232\020`\1481\254\249\206\192\246\249\011\019@\000\014\233\024\007\000\016\132\161\168\160\247?\169\155\131\017cka%\233@\222\031q\238Tv\160\163\203\192i4\168\127T\191,h\150!3/\166\167\235b\250\207\161\197\139\182\215>_\128\001\000\022\198\245\018J\030\248\208\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_va.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\143IDATx\218b<s\134\225\129\160\160\153\008\015\143\227\031&&~\006\006\134\255\012\232\224\207\1594\1768#\211\127\006f&&\134GO>3\200\201\2402\252\249\251\151\225\227\135\015,o\223\190}\003\016@,\028\028\012\002\204\204\167\184YY\237\024\216\216\148\024\024\025\1531\012\250\251\151\139\001\168\031(\007\225\191yz\128\129\139]\157A\\B\134\129\003h\000;;\199\031\128\000b\001I\130\240\239\223G\024\152\153\217\129\202X\128\152\017\205(7\134\015\031\2542l\223\190\134\129\141\225\025\131\136\200\127\134\227\007/0<zt\145\225\196\153\255\012\221}\029L\000\001\0047\232\207\159\019\012?~<\003\027\196\136n\014C\022\195\158}\167\024V\172\152\203 '\252\147\225\222\173O\012Z&\218\012'\143la\184u\151\129\225\223\1916\022\128\000\002\027\004r633\200\192G@6#\022\17511x\184[0\156:\167\015t:\007C\138\175*\195\227K\185\012WD\152\024\014\1758\001R\194\008\016@\1407n0|\224\231g\224gc\131\024\006\011\011\152\171\254\003\195\254\199\143/\012\028@_3\002\229~\254\251\202 \204'\197\224\023\221\2060\127R2\195\175_\191\024\158<}\254\019 \128P\\\196\202\ns\025\170\139X\128\018\183o?a\248\253\255'\195\254\213\150\012\"<,\012\255\222\221`\184\246\224\003\195\139G\239\0244\1489\254\003\004\016\220 \152a0W\161\025\1970mb<\195\217]\231\024\148\245\189\025JKB\024Dy>3\244eG1ph\24828\216\2332\000\004\016\\\011\204;0CQ1\019ChX<\131\177w\028\131\191\155?\195\161M\237\012\\l\255\024\140\237]\025\212Tx\024\204\141\228\025\001\002\016I\1346\000\0031\012\244\162\005\221\161{\134\255\n&\149\002\250!\185\006\181\150\204\206\228d\173\165\219\022\153\162J\204\199\024/_\187\197\179\161\249s\029\231\1765\155\1966\017\177_\001\196\244\031\154\144\129\026\192\024h\016\n\006\137\253\249\253\151\225\235\151\223\012?\127\253f\248\013\020\\\181~-\195\195{\143\192)\027h 0\013\254f\000\008 \150o\223\024>\000]\206\202\194\002\246\006\200\023\140@\252\031\150*\129\222\253\255\245\219K \251\031\003\011\011\208e\191\2542\214M[\194\192\206\197\246\255\197\243\023@C~1}\250\244\233\007@\128\001\000%\188\007\1553?\226\223\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_vc.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\0023IDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\155O\148AW\255\"\131\133\217e\006|\224\216S\006\134\1717\025\025>\177|b\216\127s?\195\201;'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\148\148\184\025d\164\197\025\184\184~\2265HF\136\129\225\187\244_\134\179\175\2072\156|v\146\129\129\133\129\005 \128\128\006\177\252a``b8z\228\021\003\019\155(\131\144\192\003\006%\197\235x\013z\245\137\129\225\242\195\223\012G^\028\129\008\252g\248\007\016@@\1318\1284\027\195\201\227\159\024\030<}\207\192\195u\132\193\192h+^\131N?b`X|\232\015\195#\214G C\024\024\2542\176\000\004\016\019\200 \006\006n \159\135\225\209#&\134\215\239\191201\221\007\227\142c\247\025\030}\186\207\240\235\255}\134\202\253\247\225\226\175~\002\197\223@\013\129\024\196\008\016@,\255\025\184\192\0061\002=\n\162\191\255\019b`g\255\207\192\200\200\192\2087\131\129\225R\008\003\1310\015\003\195\202i\012\012\019\189\129\250\128\026\1913C\013\000\129\127`6#@\000\001u\003u\1281\208q@\195\152\153\153\024\216\216\160\138\196\025\024\158}``x\243\021\200\150b``e\133\0083\1770 \1801BB\t \128X\024\025\190\003if \255\015\216\141<\172\031\025XX \026\030L``Ph\0052\128Rg{\024\224\226\188,`;!\024\234\006\128\000\0022\127B\013b\001\187\147\131\249;0\028 \026\228\005\024 \210\239\024\024\140\164\017\129\205\193\004\214\002\193\255!\218\001\002\008l\016#\\\228\0310l\254\163\196Ps(\003\195\235\175\168\177\198\136\204`\130`\128\000\002\026\244\155\005\018b\144\004\241\243/;\195\223\191\008M\149V\016\026Y\236\231_\006\132\022p\16010\001\004\016\200Eo\2543\176\002\133\255\003\157\245\129\233\237G&\198\151/\193\206\003[\012\140\189\255\192\152\130\179\255\001\029\253\014\232U`\208\254g\248\0025\240;\195O\128\000\003\000]\021\165-\238\171\145\167\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ve.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002,IDATx\218b<\179\142\225\129\160\152\133\192\015&\031\00611&\006\134\127\255\025\224\000\137\t\006\140\168\156\127\127>1|y\187\159\225\253\139\147\031\000\002\136\133C\136A\164\183\247\"\183cp>\003\167\020#\1318\0233\196\000tC\208\012\251\255\255/\195\175\207g\025\152\127\158d\224`g`\001\008 \022F.\134?\191\021D\024\022^\127\201  \246\145AX\031h\194\015\006\194\224\223o\134\223_\14200\178\002\013ef\248\007\016@\140\215.3|\224\249\197\192\255\2342\003\131\172\181\028\003\0037\011\003\227O\160\194?PW\253\131\186\002\232P\134\191@\204\014r\013H\252\015\208\005\143\024\254\002\229\223\191g\248\014\016@@%\187?\000e\249\025\025\152\128\250\024\025\024\025A:8\128\248-\0163103}g\224\224\248\197\240\245\155\008\144\255\005\136%\129\248;\2080\152\255A\248\227\015\128\000baf\248\013d\178\13151\001\013\002\201\243\242~b`\252\207\202\240\255\031#\195\151\239\194\012\223\191\003\029\202\241\155\129\133\133\011\232\186\143\012\159?\177\129\181C\130\011\228\204_\140\000\001H\160\150\021\000@\016\182\012\131\178\255\255\209\194n\2132v\153\236!L\222\249A\nE\202\005\205\014\011\012\195\141\0159\194V\248j\152\179\163R\019\213\240\"2\175N\206\021@L\127\129\002\127\025\216\160\152\147\129[\2243\195\247\127\255\024\254\252\229\003\006\015B\014\196\254\243\159\155\225\221OV\006A\225w@>\023\146>V\006\128\000b\220\203\192\240A\144\129\129\031\020*lP\1352A\217\216\146\209_ \241\011(\193\002\242\016\003$\130_20\252\004\008 \150\183\208\008\002id\129\026\194\196\128=)\129\012b\252\015\137\200\127P} \195\222\0011@\000\177\128\012\255\011\021\248\139\148x\255\163\209\140h\244\127\168\250\191\016.\019@\000\177\000\157\246\006d\t#$\1650A-\005E\030\227\127\132\030F\168!\255\129\152\017\150\184\255A\013\250\004\244\026@\128\001\0004\150\182\228q4\191\177\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_vg.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\002\000\000\000\224pz\235\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002lIDATx\218\0007\000\200\255\001\187_m\0137=\189\251\022\002\247\249C\021\254!\n\251\155\224\027\000\000\2383\022\0072,\018\175\212\253\236\234\237\000\000\002\001\000\253\000\001\253\244\243\245\192\193\211\222\221\224\002\136\197\239\134B=\203\189\1724\173/\242\138L\015\030q}}\238\174%\175\193'\241\159Y`\255\139\175|\188\175\249\184\005\025\024\254\003\209\191\127\127/]\250t\244\200\029N\206\255\000\001\0007\000\200\255\004\205\004\176\012\189\246\250\245\208\013/%\000\245\251\251\001\004#\n\188\251\014\030\000\236\238=\011\001\196\247\031\196\245\n\000\000\253\001\000\000\251\252\254\198\198\216\000\000\006\002\003\001\002\0007\000\200\255\004\129\002ELn1B\020\248\255\228\240\240\229\217\018\217\184\225\140\170\031\217\212\255\000\247\152\220\011\182\204\219\229\232\244\000\000\015/[\176\231V\230\215*\239C\140\249\202gT\002\0007\000\200\255\002\022<%C\016\242\134\144\210\024z\243\223\235\255\003+ 5D\190?\174\245\254/\022^\021\247\218\205\236\228\228\251\228\228\004\250\235\235\243\242\230\155\018\177\030\252\254\254\251\005\002\0007\000\200\255\004\211\165\215\026\226\253\000\000\t\000\000\249\\\189\018\017\002\012\000\246\241\215\179\209\025\179'<>\025\n\007\246\239\248\255\000\000\031\187\236\254=\248\000\022\027\026\206\221\000\255\253\002\002\136\229\212;\160\134?\012\012,\012\012\012o\191\179\188e`\003s\021\024\024\190\0299t\155\129\129\149\001\004\254\152\243\241\222\147e\208\147g\179\017a\184\253\139\001 \128\152\217\216,\127\255\250\001\180\138\129\001H~\007\170\1341\128\"\191\192\140\239\140\012o9\191H\188\188\249\235\192\175\179\135\026\149\184\159K\001\004\016P\155\193\239_?\193\138~\131\237\249\011#\255\193\217LL\223\253Rn\202\223\151`\190\252\\\142\137\155G\233;@\000\001\0036\022\236\018f\176;!\008\200f\002#\006\176f\136~&\176\017\012`'\252\004\008 \022kkyF&NFF\206\255@\004\012\024F\246\127\255Y\254\1314C\18112\252ab\252\195\240\255'#\208\181\255\191\255\007\162\127\223\001\002\008h\155\031\003\003\0078$\129\209\202\014\179\025\136\024\193\218\254\131\173\250\011\246\194O\176\207\129\190\253\001\016`\000\016\142\254\136E\151\203O\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_vi.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\003\001IDATx\218b<s\230\204\003AAA\017\030\030\158?LLL\012\164\128\127\255\2541|\249\242\133\229\253\251\247o\000\002P-\198(\000\1950\016;\211\1581di\254\255\205L\142\233\197k6!\1647\"\190\189\215 '\220\029fv\197U\t\201@\242\242\146\144\153MO?\127\029\001\196\002\210\248\250M*\195\231\207L\012bb)\012l\236\186@M\138\012,\204\236\012 3_\191Y\200 \192\255\001\168\161\016\204\255\251\023\228\146\015\012?~\220fx\243v2\195\203\151\027\025\184\184\0222\001\004\016\216 Y\1535@\013]\012\247\03141\252\253\195\194 \175\192\192\240\243;\007\0037\223N\006>\222\149\012/_\191d\016\021vdx\253N\147\129\151\203\130\225=\208\220\151/\255\000\013~\196 .\182\026h\137\026\011@\000\000I\000\182\255\004\224\226\248\000\249\251\003\000\248\252|\000@$~\000\233\237.\000\237\234\233\000#%+\000\021\021\t\000\002\000\169\000\001\000\008\000\253\000\252\0006>\231\000\181\173\223\000\224\227\000\000\015\016O\000\017\016\202\000\204\208\252\000*%\236\001\002\136EI\129\157\161k\214\127\006]\153?\012W\021\1913\184L\224ex\215\218\196\240\140#\141aaD?\003\235g=\006N\182\171\012\031_\0242p\134\206dx\244\225?\195\239\191{\024^\1894a\144\146\248\195\240\246\211G\144\151\025\001\002\000I\000\182\255\002\001\001\003\000\231\229\002\000\015\017\006\0009%\026\000\000\219\219\000\144\221>\000%\000\230\000(\029\208\000,\018\250\000 \013\014\000+\013\189\000!)\006\000'\021\249\000\151\1589\000\146\148\227\000\254\255\254\000\250\249\001\000\002\002\001\255\002\008h\016\019CC1\007\131\189\003\019\003333\131e\176;CS\183\013\195\245\2193\025\004\234\1751|T\248\203\240\249\212;\134\159!\220\012|\014\155\024\190}\253\203\240\239\231\027\134\233\253b@\175\1773h\170\178\002c\144\137\001 \128X@Q\169\164\200\201\192\193\193\014\142\250\205\005\219\024\204>23\\}\183\149\193\235\255u\134\155.\028\012\255\129\129/f\202\192\160\240\237?\195\246\211\140\012\249\153\219\025T\148\156\192\209oj\192\195\240\226\197\023F\128\000\194H\129\130\252\012\012w'\252g\184\243\165\156\129\015h\184\154T\016\131\1329\003\131\138\212*\134\234v\006\134\205[_2\216X\187a$N\128\000b\001%,X*\005\225\191\192\132\002\018\171\244\012`\000\242\024\020\229V1\252\254\195\192\192\206\198\192\160\173\243\140\193\196\128\031\172\006\166\030\1508\001\002\136\229\219\183o\031\128Y\131\149\133\133\005\024h`\192\008\196 \211\193I\028\232]\160\186\255`\182\187\003\195\255\127\255\2223\190|\t\182\248\255\159?\127\024~\255\254\205\004\204\"?\000\002\012\000=\186\016\214\011KH\179\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_vn.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\213IDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\128\026\254\128\196\223\0299\194\192\204\198\198\192\200\202\n\215\244\031\151! \185\223\191\193z@\224\031\016\001\004\016\203?\008\131\225\221\241\227\012?\159>e`da\129k\000\025\196\0042\000H\252\253\199\128\"\254\255\207\031\134\175\143\030\129\245\254\006\186\008 \128X\254B\013\002i\248\006\148`\002\250\029\166\225+\016+%20\176\13820\\\235b`\224C2\232\0314,Az\129f0\002\004\016\220E\0087C\020p\17110hMe`\016\178\000\005,\003\131\160\011\003\195\1892\006\134/\231Q\189\0113\008 \128\152\024\161\174\001aP0\179\0001(\148~\222b`\2484\129\129\129\139\141\129\129\019(\240e\025\003\195\247\243\0169\022\168Z&\004\254\015\016@,\204P\1410\204\002\013T\144\151Y\129\156\159\207\129\170\190\130\002\129\001\020;`\003@.\254\003\t\0270\027$\006\016@ y\184+X\145l\002\137\253z\207\192pN\001\226|A[\006\006\014$\2390\"\177\129z\024\001\002\136\137\tI3#Z\180\127>\004\017\003\201\127:\204\128\146P\025\145\130\003D\003\004\016\011\019\196r\176W\024\176\024\246\031M\028Y\030\166\007h\024\019@\000\177\252``x\003\020\252\199\136\228\176\255\224\184\003\2110=\140PC\2543B\"\017,\014\1411\134O\192\160\004\0080\000\004a\136\003\233\140>\221\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_vu.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002?IDATx\218bt\147ax\224#m.\224\235\232\200\240\151\143\143\225\235\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\197\209\137A\228\141\226I\238M\255\236\024\236\149\148\024\020\152\153\025~\002\021\254\194a\024#\140\241\247/\195\135\179g\025~\156<\201\192\206\192\192\002\016@,\149\139\024\254\232\17010\180d\030ax*\198\198p\2420+\131\026\208\004\029\160\218O@\252\019\155! K~\255fxw\228\008\152\253\015\136\000\002\008$\247\001\136\249A\002\161Ar\012\174\214,\012\207X\025\024NO``\008\003\1389\002\241# \254\001\196LH\006\253\251\243\135\225\219\163G\012\127\129\236\143\012\012\223\001\002\008l\144\153!\003\255\132j\006\134}\135\024\024Z\23112\216\15530\020\02710\204\248\194\192p\127\006\144\013T$\006\196\223\160\174\002y\249\0310,\129.a\248\0031\232\007@\000\129\013\154\215\205\192\223\187\132\129A^\138\129!\198\157\129!\170\000b\171\013\2089~@S\206,\005\134\217}\160\001\172H.\250\0155\016h\218\143_\012?\001\002\136\005$\184\238 \003\131\178\012\003\131\134\"P\195?\132bN\160uag\025\024.030<\016a\000\005*,L\024\254\255\131\026\006\164\127\255`\248\015\016@\2400ru``\152W\206\192 \235\007\212\236\202\192`\158\202\192\240u5\003C\221S\160\1722\016\243\129b\n\022\210P\211\254B\241W\134\031\000\001\132\018\216Vz\012\012\181\206\012\012\159\129!\027v\029( \207\000\137\190\207\208\192`\196b\208\031\176\252O\128\000\002{MO\147\129\161\170\144\129\129\2372\003\131\239E\160\156(P\208\003\026\186oq\197?RB\003\138\003\004\016ce%\195\023\147\223\012\220\025g\024\024^\011\000\005\129\177\197\240\027\026\223\255q$kd\131\254\130-\252\013\016@\140\202\214\012\015\238\2420\0081\168303\176\000\147\2027\160RH.a\132\026\244\031\174\157\017\202f\132\139C\188\248\157\225'@\128\001\000gH\18230\\\236j\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_wf.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ws.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001\252IDATx\218bd`\008~`n\174-\224\232\168\203\192\199\199\205\240\255\255\127\0061I\t\006FF&\134\151\207^000\176\0031\019\003\004\1761\1641\236\1350\025\025\025\254}\250\196\240e\255~\134\247'O~\000\008 \022\006\006f\145\147'\239r\219\217i1()\1370\176\176\1760p\243p\001\21312H\138+2\252\254\253\159\225\247\175_ \157@\204\194\192\197\160\0066\231\255\223\191\012\191\206\158e`>y\146\129\003(\001\016@@\131X\255\128l<r\228\026\131\186\134(\131\168(?\195\201\019\151\128J\153\025\228\020\164\025\254\0015<y\252\014\234*V\0067\134\171\016\023\253\254\205\240\251\200\017\176\241\255\025\024\254\001\004\016\144N\253\000\180\141\031\196\149\147\019d`cca\248\247\239\027\131\162\178<\195\2197\223\025>}|\011\245\030H\011\023\195\t\134\185 \141\012\012\127\2540\252y\244\136\225/\144\249\158\129\225;@\000\001]\196\007v2\208P\134G\143\254\002\189\244\149\193;\202\138\129\149\2337\195\190=7\129\226@\1353\252\128\186\136\019H\222\007;\232\0310,\153!\174\001\135\024@\000\001M\144\129\218\200\012V\252\255\255c\134O<j`m\255\255\223\006\146\n@\252\023j ;\016\254\007k\254\007\021\133\025\004\016@\140@;?\00800\240\179\131C\000b\028#\003~\240\031j\200o \254\t\196\175\128N\006\008 \022F\168\163\153\160\1340#E6.\240\015J\255\133\170\005\153\001\016@,0IF(f\"\194 \152a\140\008\0232\002\004\0161z\136\002\000\001\196\242\031\018e`\027\208\002\016\175k\254!y\017\2322&\128\000b\249\198\192\240\006\200\248\007\012hf\160\243\152\152 \206\252\015s9#(\242\144\216@\205\140\208X\251\255\007\026\216\192\148\246\019 \192\000.\141\140\168z\224 \226\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_ye.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\001SIDATx\218b\156\199\192\240@\194\220\\@\220\209\145\129\149\143\143\225\255\255\255\012\255\025\024\192\024\027`\132aFF\134\223\159>1\188\220\191\159\225\197\201\147\031\000\002\136\133\157\129A\228\199\201\147\220lvv\012\002JJ\012\012\204\204`\013\248\012\002\131\191\127\025>\156=\203\000\212\203\0004\131\005 \128X\25410\252\001\137\191=r\132\129\153\141\141\129\145\149\021\167!\200\134\253\255\253\027\172\007l&\003\195?\128\000b\249\005d\176\001\241\235\227\199\025\190?}\202\192\200\194\002Q\136\207\016\016\254\243\135\225\203\163G\012@\1350|\007\186\008 \128X,\175_g\224\229\229e`\001\026\192\196\196\004\198\196\128\127\255\254\129\241\031\160\129o\223\190e\004\008 \022&`\160\177\000\195\133\013\232%f \0132\008\020\144 \140\013\128#\003\136A\134\252\005\134\019\144\003r%#@\000\177\1284\1284\131\012a\133\026\134\203\016d\195\192\134\000\001\212\023\255\001\002\008n\016\2040\152\171\008y\011\018q\127\225>\000\008 \144\213\031\128\152\159\1292\240\019 \128\152\024\168\004\000\002\008d\016\0115\204\001\008 \144!o@\222\006bf\168\193\176\164\002\011q|l\184\215\000\002\012\000\163\246kJ\144\186\151\"\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_yt.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002HIDATx\218bdc\152\240\192\204\\A\192\222Q\134\129\143\143\131\225\239\127&\134\255\012\012\012ii\162\012\255\254\253\003b\006\008`bd`\002\226g\179f10\130\185\140\012\191?}bx\185\127?\195\139\147'?\000\004\016\011\003\003\187\200\233\147\031\184m\237d\025\020\149x\025\152\152A\006\253g\224\226\226b\248\255\031\213 F\160fa55\176A\012\127\2552|8{\150\225\199\201\147\012\236\012\012,\000\001\0044\136\229\015P\021\195\209#\175\024\216\216\152\024\152X\153\129\198\252cps\227\007\027\244\247\223\127\1769\140LL`W|\185z\021l\208\255\223\191\025\222\0299\002\150\003\218\245\015 \128\024\217\024\022\127```\227\007I\202\202q10\17802\252e\248\205p\226\1325\2085\191\025~\255\134\026\196\194\204\192\204\204\204p\197\194\002\204\255\255\231\015\195\215G\143\128j\025\024>10|\007\008 \160\1398\128LN\160+\024\025\128\226\012\255\024\129\174\000\242\152\128.\248\015\012/F&$\023\001\241\247\251\247\193a\248\255\255\1270\013\2429\2080F\128\000b\001\134\006\144\201\0134\134\005\020\016@\005\140@\005\127\024888\024\254\252ef`\250\005\t\"FV&\006f\160\171\128\n\024\144\001\204 \128\000\002\234\006y\n\028\015@\204\002e30\176\178\178\002]\001\178\026\213 \022\168\016<\014 \248?@\000\001C\228;\144\201\012\212\254\007,\0041\230\015\003\011\011\0110\150\254\129\189\000\t#\022\160\02438 \254C\\\001\012I\008\027\232N\006\128\000\002Z\240\019j\016\011T\136\t\172\004\022F\204\2400b\004\139\177B]\195\132\2285\160.F\128\000\002\027\196\0086\000\230wF\184\247\024\144Dab\200\170\152\144\172\006\008 \160A\191Y\016>\134:\018\136\255\002\019\220\159\191\192\024\252\003u\017\227_\176\238_H\001\253\023\161\139\t \000\139\228v\002\000\008\195@\171t\2559\131. Tb\130\254\135#/;Zl)\018=\137\130\148\228\157\000\162N\233G\161\154\024.;sp\154\249\028\241/\230\031\237+\192\000D\246\184\020\127=\026\014\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_rs.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\214\216\212OX2\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002%IDATx\218|\146\221j\019A\020\199\2553;\187\249\254Zi\146Bis\167\136H\027\204\141\224]\159\193\023\240\222'\240\206K_\192\171\130\005\159A(z+H\160\212\138)\001oZ4\137\141\219\174\201\230kwg\198\179\155]+\"\030\230\191\003g\230\255;3gV\028\236u\1904\239\239\214\154\157\014D\161\008\173\024\180\230@$\026\000\195:t2+\202\144\184F8\2430\234v1:=\185\022\0227\234\203\179^\201l\239\162\186\181I\230\200M\018\004\012\008\194t\002\211\tR\175\165$\220^\015\228\0051La\128\007\006-\252<\253\0083c\129\021\n\224\141<\153f\004*C\014\167\128\012c\022K!$M\185\200\019y9\184\020W\172\004\1591L>\159c<\158#\151\227\200\183\191C\228\\\004n\003\179\019\027!\227\201\013\211\235E\236\000\222h\012\197\202p!MV\216\127\233p3c\199\253\144\018\2076\174\240\168\242\013~q\011\185\233\005^;\2198\156\214@\165\147V\177\248\146J\233u\011\020\141\149\183\0163F\155x\129*\210\206P\193\220\127\128j\224\194\153\007\184\213x\008\249U\192=r\168g\t\137\177\155>i\018\151\148\019\132\012\163\147$\162jV>\139\202\246\006*\011\133J\171\t\211\180h\141\204*\018\255c\2307>b\136b9\000\207\174\136l\196\015\228w\223aR\190\134i\223\131st\000\195\217A\181\222\164\157\193\239\254h\189\254h\185~=Ek\236\253\241'\199\174\217v&\155\141\171\251\031\222\192}{\136\250\227\231\024\189z\138\205'/`\222n\199\255O\026J)\132a\136 \008\176Z.1\028\013\023\172\223\239;6E\150@\150eA\008\129\201\241\025\022\151?Pl\237\160t\183\133\191#\005\249\190\143%\129\006\131\193BP\222\140\022\"Iz5F\205,\237\221A)}f)\255\t\138\242\169\143sn\136\249|~If\233y\158\160\217\160\136a\255\011M\253\137@\233\169\028\199Y\254\018`\000\216\021\011\187\255\031s\161\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_za.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002gIDATx\218bd\152\192\240\192\\\198\\ Q\173\152!\248\167\030\195\175]\155\024^1\252f\192\005\024a\152\145\145\225\247\167O\012/\247\239gxq\242\228\007\128\000ba`a\0169\249\233$\183\221\247\211\012{\229\024\024,\n\"\024\212.\252b\248\240\236<\195\031\168&t\131\192\224\239_\134\015g\2072\2528y\146\129\157\129\129\005 \128Xz\028\025\254\148\\e`8\242\234\008\003\027\011\027\195\141\215\215\024\164tl\024\194\197\149\025\254.\001\218\198\240\025\171\171\254\255\254\205\240\246\200\017\136\153\012\012\255\000\002\136\209K\133\225\131\205>\006\254\147\204\012\012\231O\2011\176\252c\129\168\148\225b\152\162\208\197`R\243\136\225\227\158~\160g\185\161\198\252\135\144\127\2540\252z\244\020\236\234\015\012\012\223\001\002\136\017B3\240oig``Of`p\187\000\020z\001\020a\002bV\006\006/\135N\1348f\011`\184=\002\n1\002\141\129x\238\223?\016fd\000\154\199\240\233\237\183\031\000\001\0047\008$)\004\196{\21500lR``\168\191\0055\236?\148F8\006B\255\131\226\191`\019~\002\004\016\011\186\255Y\129\"\204@\1510\176 \025\196\140\195\160?P\154\153\225?@\000\193\013\218\221\199\192\192\145\197\192\160s\014\200\185\011\196l@\012\140\142J\151\002\006g\166P\134\027\012\159\160\2301\002\189\244\031\024i\255\025~\255\250\199\240\251\231\031\134O/?1\000\004\016\139\183\026\003\131\243Q\006\134I@M\155wBm\003\026\207\169\002\228k\158e8\027d\196\224\178\254*\1310\003/\220A0?\253\007:\233?\195/ fb\004\008 \022\151-\012\012\133\199\128\226?\161\222\225b`(q\247eP\191\184\137!\153\241)\195C\134\003\012\176\128D\013\152\223H\248#\003@\00012\204`\248\002\180\140\027\020\030l\170\012\012\203\244\1421\220\1395c([y\014\028\008\236\240\000B5\132\017\232\018\006\134\031@\215\128\240\251\223\000\001\196\002\020{\195\240\149\225_\136x\008s\192\233^\166D\147\183\140\159\025\246\252g\001:\151\t\020\138\012\204@\031\253g\132\024\242\031\200\248\195\200\000\241\018P\252\027\216 \006\134\207?\001\002\012\000Yn\218\197K\253?\250\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_zm.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\030IDATx\218b\020\201dx`\172l.`\173\234\200\192\203\193\199\240\239\223\127\0060\128R0\000\2262\003\241/ \254\195\200\192\192\200\196\200\240\233\199'\134\253\183\2473\\\187}\242\003@\000\1770\1782\136\156\127q\146\219R\195\142AAL\137\129\153\137\153\225?\154!0\131\216\129\132\221_\006\134\207 \129\127\127\025\206?>\203\144q\227$\195\130\255\012,\000\001\196\242\031b\001\195\169\251G\024\216X\216\024X\152XQu#\129\239@\133g\128b\006\127\024\024\204\127\253f0\186u\132!\155\131\129a\013\208X\128\000b\249\015\180\001\228\155\211\143\1423<\255\244\020\232\"\022\160\187\025\176\130\175@\169\159<\012\012\172l\012\012\170\191\2540\156d|\196\240\001\200g\248\200\192\002\016@, C\152@\150\003\233G\031\030101AMA3\236=P\179\243=V\134\214s\028\012[8\25404<\255\198\192\000t\196\134(\006\134{_\025\024\001\002\136\229\255?\160\139\254\129\002\015\162\249\239\127D`3\"\025\246\135\157\129A\248#3\131\2505n\134\143<?\024\024\190|\003\139\155\003\245*\254d`\004\008 \022\184\237LP\204\1360\000\217 P\148}\007\026\198$\240\159\225\005\208u\012_ \194\192\184ax\199\196\240\031 \128X\024\129F\129\131\133\025\162\152\tj\024F8\0015\243\000\163\134\021\024\168\220L\127\225\194 \189 \195\000\002\136\133\t\234\002\016\007l\024\019\003\246\192\006\138\179\129,b\248\199\192\198\136\020\157\016\2230\002\004\016\011#\212\021\140\140\152.AIO\255!\177\011R\192\136f\001(|\001\002\136\005(\200\002\215\244\015\162\225?,\013\253GJJ@\223\252\248\203\008\164\152\024~\254Gu2\208\017L\000\001\196\242\2557\195\027\144e@k\152\129\2300\001\013\0049\238\255\127\144\008$\230\254\131\196@\150|\252\246\255\255\011\160\248\155\191\140\240\228\250\250+0i\252d\248\t\016`\000\015\133\164\255r\005\139\146\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_me.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\214\216\212OX2\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002)IDATx\218TS\203nS1\016=3\246mn\008!\141BR!\160T\130JP`Y\t\232\015\176g\193\143 \190\130\143`\133\196\174\0116\236\016H4\162\002\177*\139R\137$E-\141\146\155\016B^~0\215\247\006\129%\219\178g\206\153336\189xz\243k\163\176U\173o=\128\142\203\240\0302Hv\202vd\131\194\234A\228\243\0290\211\017\186\007\239q69Ht\212\1546\146\151\187\229\250\147\027(o\175\003J\231\144\229\248\159\138\150Gk\144|<B\242l\023\209\163\171\145v\196\011\006\163\191\215DT*\129t\148A3i\240\181\024b\006u\1679\031\005Jo\022\001\147\026-+\171\189\215pb\2347?`~r\026\136H\156y\227\028\220`\014\190_\0210\195\237\245\192\149\021\248\239\019\184\185\011D\191Z\237\128]X\022E.\202\"\200:nu\192\"D\173\021\177\178\179\t\251&\001\159L$\166\131)\204\160v.a\241\252\020\230\219\008\142(`\\\154\165\141X;QD\225\"\151\236\028\\\164\161.\215`nGx7\219\196\144Jx\184\250\t\133\245*f\220\022\031\241S\025I\138s^ASN\160\242\201r\2103\011:\252\t\127\235\"z\237U\196j\014\\i@\237\031CuF\226\164\254\246\211\1326\008F\241\002Z.\011r\145\246K\177\212g(\233\188:De\187\143{w\006!r\249K\130n\135Q\209R\249\197\028VB\154P\018\015\195F\136\148\t\004)Y\148\018\137<\158\138[]\186w4\196\221\235\018\162\1681~\251\003\023j\231\177\226l\000s\174(\004O9\152\140\164\148\025\242\151\002/\210M3\017\221\014\191\139B\031Kg?\015\016\163'6\029\186H\001\131\012\203Vj$m\243iW\172\0131h\249\134'\217\025\175\143\243\023\200\193F\162\008yJ6\236\014\236\172\210\230Z|\230\031oXC\242\164\189\146\204\210B\138>\207\225\155\252\1633|\015\"\023\192)\141\147i\156\193xMO\255\0080\000VI\245\243s`E\232\000\000\000\000IEND\174B`\130";

  Hashtbl.add files "flag_zw.png" "\137PNG\013\n\026\n\000\000\000\013IHDR\000\000\000\018\000\000\000\012\008\006\000\000\000o\018\237\188\000\000\000\004gAMA\000\000\175\2007\005\138\233\000\000\000\025tEXtSoftware\000Adobe ImageReadyq\201e<\000\000\002\138IDATx\218b\236l\236}\176\238\202*\001\223DG\006A.>\134\239\127\25530\254g`\000\"(\129\004\024\193\008\194dbd\248\242\227\019\195\145{\251\025\206\222?\249\001 \128\024\175\\\185\242\133\235=\015\247\244\131S\025\\|\141\025\132\249\153\025\190\253@\024\244\031a\006\138A\255\255\255e\184\251\242,\195\186\211\221\012\127~0|\005\008 \198\171W\175~\224\225\225\225\231\224\224`\216\191k\023\131\177\210]\0061M\160J&\168\139\2543 t#\131\255\191\025~|\223\007\196\199\025>}b\248\012\016@,\140\140 kN2\252\218\253\129\193Q\221\142a\234U\025\134wU\201\012u\234@\197b\028\012\159\127B\204\132\251\142\017b\248\191\127\127\024~\189y\204\240\143\129\147\225\211\247\255,\000\001\196\242\255\031#\195\127\166\183\012?\206e2\252z\186\132!/\196\157a\155\204\001\134*7y\134P\160\030cva\160\229\2551\028\245\239\255\127\160!\\\012\127\128\236\223\012\255\025\001\002\136\225\252\146c\031\174\004s\252\127y\157\225\255\243\141\012\255o\1552\252\255\252\250\243\255/_\190\252w\136m\006{\142\137\141\0057fe\006\225\031\000\001\196\196e*\204 4\173\135\225\239c\006\006Va\006\006\241C\185\012l|l\012\172\172\172\012\2559\004!\182\255\251\143\007\131\228\025\254\003\004\016\011#\208\209\255.\189e`\231\225a\224\224\250\194\192\206\146\199\176\253\t\011\195NEf\134\006\160!v\156\"\012\127\209\188\006\212\203\240\023\024P\191\128\162?\129\244K \031 \128X\128\241\200\192\170\156\197\192!Z\196\192\202\198\198PT\182\131\225\237\nU\134\165\190@YYn\134\247\223\191303\162\166#\160C\024\254\000\241/`\154\251\241\151\129\225\235\023\006F\128\000ba\000&,&^\136\186\204\192\008\134\156\144\245\012\134}0\187\1912\008b\137y\144w\254\000C\249\215/`p\000\211\220\215\023\012\012\000\001\196\242\255\255\127\150\223\247\024\024D\131x\025<r\025\024v\20020L\\\008Q\012\140P\148\004\tJ\006@{\025\152\128\130\140\255 \024\152\n\024\128\t\156\t \128X\214\173\216\248\166rE\217?\201\004\006\230+?\025\152\142\238g\000\005\219\127FP\176\128R6\136\252\015I>@\147\254\195\147\018H\013\2000P\154\250\194\240\019 \192\000\190\216\t@\196Eg+\000\000\000\000IEND\174B`\130";
