C
C  This file is part of MUMPS 5.2.1, released
C  on Fri Jun 14 14:46:05 UTC 2019
C
C
C  Copyright 1991-2019 CERFACS, CNRS, ENS Lyon, INP Toulouse, Inria,
C  Mumps Technologies, University of Bordeaux.
C
C  This version of MUMPS is provided to you free of charge. It is
C  released under the CeCILL-C license:
C  http://www.cecill.info/licences/Licence_CeCILL-C_V1-en.html
C
      MODULE DMUMPS_DYNAMIC_MEMORY_M
      CONTAINS
      SUBROUTINE DMUMPS_DM_SET_DYNPTR( CB_STATE, A, LA,
     &                                PAMASTER_OR_PTRAST, IXXD,
     &                                IXXR, SON_A, IACHK, RECSIZE )
      IMPLICIT NONE
      INTEGER, INTENT(IN) :: CB_STATE
      INTEGER, INTENT(IN) :: IXXR(2), IXXD(2)
      INTEGER(8), INTENT(IN) :: LA, PAMASTER_OR_PTRAST
      DOUBLE PRECISION, INTENT(IN), TARGET :: A( LA )
#if defined(MUMPS_F2003)
      DOUBLE PRECISION, POINTER, DIMENSION(:), INTENT(OUT) :: SON_A
#else
      DOUBLE PRECISION, POINTER, DIMENSION(:) :: SON_A
#endif
      INTEGER(8), INTENT(OUT) :: IACHK, RECSIZE
#if ! defined(NODYNAMICCB)
      IF ( DMUMPS_DM_IS_DYNAMIC( IXXD ) ) THEN
        CALL MUMPS_GETI8(RECSIZE, IXXD)
        CALL DMUMPS_DM_SET_PTR( PAMASTER_OR_PTRAST, RECSIZE, SON_A )
        IACHK = 1_8
      ELSE
#endif
        CALL MUMPS_GETI8(RECSIZE, IXXR)
        IACHK = PAMASTER_OR_PTRAST
        SON_A => A
#if ! defined(NODYNAMICCB)
      ENDIF
#endif
      RETURN
      END SUBROUTINE DMUMPS_DM_SET_DYNPTR
      SUBROUTINE DMUMPS_DM_PAMASTERORPTRAST( N, SLAVEF, MYID, KEEP28,
     &                                    INODE, CB_STATE, IXXD,
     &                                    STEP, DAD, PROCNODE_STEPS,
     &                                    RCURRENT, PAMASTER, PTRAST,
     &                                    IS_PAMASTER, IS_PTRAST )
      IMPLICIT NONE
      INTEGER, INTENT(in) :: KEEP28, N, SLAVEF, MYID, INODE, CB_STATE
      INTEGER, INTENT(in) :: IXXD(2)
      INTEGER, INTENT(in) :: DAD(KEEP28)
      INTEGER, INTENT(in) :: STEP(N)
      INTEGER, INTENT(in) :: PROCNODE_STEPS(KEEP28)
      LOGICAL, INTENT(out) :: IS_PAMASTER, IS_PTRAST
      INTEGER(8), INTENT(in) :: PAMASTER(KEEP28), PTRAST(KEEP28)
      INTEGER(8), INTENT(in) :: RCURRENT
      LOGICAL :: DAD_TYPE2_NOT_ON_MYID
      INTEGER :: NODETYPE, DADTYPE
      INCLUDE 'mumps_headers.h'
      INTEGER, EXTERNAL :: MUMPS_TYPENODE
      INTEGER, EXTERNAL :: MUMPS_PROCNODE
      IS_PAMASTER = .FALSE.
      IS_PTRAST   = .FALSE.
      IF (CB_STATE .EQ. S_FREE) THEN
        RETURN
      ENDIF
      NODETYPE = MUMPS_TYPENODE(PROCNODE_STEPS(STEP(INODE)), SLAVEF)
      DADTYPE=-99999 
      DAD_TYPE2_NOT_ON_MYID = .FALSE.
      IF (DAD(STEP(INODE)) .NE. 0) THEN
        DADTYPE= MUMPS_TYPENODE(
     &           PROCNODE_STEPS(STEP(DAD(STEP(INODE)))),
     &           SLAVEF)
        IF (DADTYPE .EQ. 2 .AND.
     &      MUMPS_PROCNODE(
     &           PROCNODE_STEPS(STEP(DAD(STEP(INODE)))),
     &           SLAVEF).NE.MYID
     &    ) THEN
          DAD_TYPE2_NOT_ON_MYID = .TRUE.
        ENDIF
      ENDIF
      IF (DMUMPS_DM_ISBAND(CB_STATE)) THEN
        IS_PTRAST=.TRUE.
      ELSE IF (NODETYPE.EQ.1
     &  .AND. MUMPS_PROCNODE(PROCNODE_STEPS(STEP(INODE)),
     &           SLAVEF).EQ.MYID
     &  .AND. DAD_TYPE2_NOT_ON_MYID)
     &  THEN
        IS_PTRAST=.TRUE.
      ELSE
        IS_PAMASTER=.TRUE.
      ENDIF
      RETURN
      END SUBROUTINE DMUMPS_DM_PAMASTERORPTRAST
      LOGICAL FUNCTION DMUMPS_DM_ISBAND(XXSTATE)
      INTEGER, INTENT(IN) :: XXSTATE
      INCLUDE 'mumps_headers.h'
      SELECT CASE (XXSTATE)
        CASE(S_NOTFREE, S_CB1COMP);
          DMUMPS_DM_ISBAND = .FALSE.
        CASE(S_ACTIVE, S_ALL,
     &    S_NOLCBCONTIG, S_NOLCBNOCONTIG, S_NOLCLEANED,
     &    S_NOLCBNOCONTIG38, S_NOLCBCONTIG38, S_NOLCLEANED38,
     &    S_NOLNOCB, S_NOLNOCBCLEANED);
          DMUMPS_DM_ISBAND = .TRUE.
        CASE(S_FREE);
          DMUMPS_DM_ISBAND = .FALSE.
        CASE DEFAULT;
          WRITE(*,*) "Wrong state during DMUMPS_DM_ISBAND", XXSTATE
          CALL MUMPS_ABORT()
        END SELECT
      RETURN
      END FUNCTION DMUMPS_DM_ISBAND
      LOGICAL FUNCTION DMUMPS_DM_IS_DYNAMIC(IXXD)
      INTEGER :: IXXD(2)
      INTEGER(8) :: DYN_SIZE
      CALL MUMPS_GETI8( DYN_SIZE, IXXD )
      DMUMPS_DM_IS_DYNAMIC = DYN_SIZE > 0_8
      RETURN
      END FUNCTION DMUMPS_DM_IS_DYNAMIC
      SUBROUTINE  DMUMPS_DM_FAC_UPD_DYNCB_MEMCNTS
     &                     (MEM_COUNT_ALLOCATED, KEEP8, 
     &                      IFLAG, IERROR)
      IMPLICIT NONE
      INTEGER(8), INTENT(IN)    :: MEM_COUNT_ALLOCATED
      INTEGER(8), INTENT(INOUT) :: KEEP8(150)
      INTEGER, INTENT(INOUT)    :: IFLAG, IERROR
      IF (MEM_COUNT_ALLOCATED.GT.0) THEN
           KEEP8(73) = KEEP8(73) + MEM_COUNT_ALLOCATED
           KEEP8(72) = max(KEEP8(72), KEEP8(73))
           KEEP8(74) = max(KEEP8(74), KEEP8(71)+ KEEP8(73))
           IF ( KEEP8(74) .GT. KEEP8(75) ) THEN
             IFLAG = -19
             CALL MUMPS_SET_IERROR(
     &            (KEEP8(74)-KEEP8(75)), IERROR)
           ENDIF
           KEEP8(69) = KEEP8(69) + MEM_COUNT_ALLOCATED
           KEEP8(68) = max(KEEP8(69), KEEP8(68))
      ELSE
           KEEP8(73) = KEEP8(73) + MEM_COUNT_ALLOCATED
           KEEP8(69) = KEEP8(69) + MEM_COUNT_ALLOCATED
      ENDIF
      RETURN
      END SUBROUTINE DMUMPS_DM_FAC_UPD_DYNCB_MEMCNTS
#if ! defined(NODYNAMICCB)
      SUBROUTINE DMUMPS_DM_CBSTATIC2DYNAMIC(
     &           SIZER_NEEDED, SKIP_TOP_STACK,
     &           MYID, N, SLAVEF,
     &           KEEP, KEEP8,
     &           IW, LIW, IWPOSCB, IWPOS,
     &           A, LA, LRLU, IPTRLU, LRLUS, 
     &           STEP, PTRAST, PAMASTER,
     &           PROCNODE_STEPS, DAD, IFLAG, IERROR)
      USE DMUMPS_LOAD, ONLY : DMUMPS_LOAD_MEM_UPDATE
      IMPLICIT NONE
      INTEGER(8), INTENT(in) :: SIZER_NEEDED
      LOGICAL, INTENT(in)    :: SKIP_TOP_STACK
      INTEGER, INTENT(in)  :: N, SLAVEF, KEEP(500)
      INTEGER, INTENT(in)  :: MYID
      INTEGER(8), INTENT(inout) :: KEEP8(150)
      INTEGER :: IWPOS, IWPOSCB, LIW
      INTEGER, INTENT(inout) :: IW( LIW )
      INTEGER(8) :: LA, LRLU, IPTRLU, LRLUS
      DOUBLE PRECISION, INTENT(in) :: A( LA )
      INTEGER, INTENT(in)    :: STEP(N)
      INTEGER(8), INTENT(inout) :: PTRAST(KEEP(28)), PAMASTER(KEEP(28))
      INTEGER, INTENT(in)    :: PROCNODE_STEPS(KEEP(28)), DAD(KEEP(28))
      INTEGER, INTENT(inout) :: IFLAG, IERROR
      INCLUDE 'mumps_headers.h'
      INTEGER    :: ICURRENT, INODE, TYPEINODE, CB_STATE
      INTEGER(8) :: RCURRENT, RCURRENT_SIZE, SIZEHOLE
      LOGICAL    :: MOVE2DYNAMIC
      LOGICAL    :: SSARBRDAD 
      INTEGER(8) :: TMP_ADDRESS
      INTEGER(8) :: I8
      DOUBLE PRECISION, DIMENSION(:), POINTER :: DYNAMIC_CB
      LOGICAL :: IS_PAMASTER, IS_PTRAST
      INTEGER :: allocok
      LOGICAL      :: IFLAG_M13_OCCURED, IFLAG_M19_OCCURED
      INTEGER(8)   :: MIN_SIZE_M13, MIN_SIZE_M19
      INTEGER, EXTERNAL :: MUMPS_TYPENODE
      IF (KEEP(141).EQ.0) THEN
        IF (LRLUS.LT.SIZER_NEEDED) THEN
          IFLAG = -9
          CALL MUMPS_SET_IERROR(SIZER_NEEDED-LRLUS, IERROR)
        ENDIF
        RETURN
      ENDIF
      IFLAG_M13_OCCURED  = .FALSE.
      MIN_SIZE_M13       = huge(MIN_SIZE_M13)
      IFLAG_M19_OCCURED  = .FALSE.
      MIN_SIZE_M19       = huge(MIN_SIZE_M19)
      ICURRENT  = IWPOSCB + 1 
      RCURRENT  = IPTRLU  + 1
      IF (KEEP(141).EQ.1 .AND. SIZER_NEEDED.LE.LRLUS) GOTO 500
      IF ((KEEP8(71) + KEEP8(73)+ SIZER_NEEDED-LRLUS).GT.
     &               KEEP8(75)) THEN
           IFLAG = -19
           CALL MUMPS_SET_IERROR
     &       (KEEP8(74) + SIZER_NEEDED-LRLUS-KEEP8(75), IERROR)
            GOTO 500
      ENDIF
      DO WHILE (ICURRENT .NE. LIW-KEEP(IXSZ)+1)
        INODE        = IW(ICURRENT+XXN)
        CB_STATE     = IW(ICURRENT+XXS)
        CALL MUMPS_GETI8( RCURRENT_SIZE, IW(ICURRENT+XXR))
        CALL DMUMPS_DM_PAMASTERORPTRAST( N, SLAVEF, MYID, KEEP(28),
     &                                  INODE, CB_STATE,
     &                                  IW(ICURRENT+XXD:ICURRENT+XXD+1),
     &                                  STEP, DAD, PROCNODE_STEPS,
     &                                  RCURRENT, PAMASTER, PTRAST,
     &                                  IS_PAMASTER, IS_PTRAST )
        IF ( CB_STATE .NE. S_FREE .AND.
     &       .NOT. DMUMPS_DM_IS_DYNAMIC(IW(ICURRENT+XXD)) ) THEN
          TYPEINODE = MUMPS_TYPENODE(PROCNODE_STEPS(STEP(INODE)),SLAVEF)
          IF (KEEP(141) .EQ. -1) THEN
            MOVE2DYNAMIC = .FALSE.  
            MOVE2DYNAMIC = MOVE2DYNAMIC .OR.
     &                     CB_STATE .EQ. S_NOLCBCONTIG .OR.
     &                     CB_STATE .EQ. S_NOLCBNOCONTIG .OR.
     &                     CB_STATE .EQ. S_NOLCLEANED .OR.
     &                     CB_STATE .EQ. S_ALL .OR.
     &                     CB_STATE .EQ. S_ACTIVE
          ELSE IF (KEEP(141) .EQ. 2) THEN
            MOVE2DYNAMIC = .TRUE. 
            MOVE2DYNAMIC = MOVE2DYNAMIC .AND. (TYPEINODE.NE.3)
          ELSE IF (KEEP(141) .EQ. 1) THEN
            MOVE2DYNAMIC = .FALSE. 
            IF (LRLUS.GT.SIZER_NEEDED) GOTO 500
            IF (TYPEINODE.EQ.3) GOTO 100
            MOVE2DYNAMIC = MOVE2DYNAMIC.OR..TRUE.
          ELSE
            WRITE(*,*) "Internal error in DMUMPS_DM_CBSTATIC2DYNAMIC",
     &      MOVE2DYNAMIC
            CALL MUMPS_ABORT()
          ENDIF
          MOVE2DYNAMIC = MOVE2DYNAMIC .AND. (RCURRENT_SIZE .NE. 0_8)
          MOVE2DYNAMIC = MOVE2DYNAMIC .AND. 
     &         .NOT. ((ICURRENT.EQ.IWPOSCB + 1).AND.(SKIP_TOP_STACK))
          IF (RCURRENT_SIZE+KEEP8(73)+KEEP8(71).GT.KEEP8(75)) THEN
               IFLAG_M19_OCCURED= .TRUE.
               MIN_SIZE_M19     = min( MIN_SIZE_M19,  
     &           RCURRENT_SIZE+KEEP8(73)+KEEP8(71)-KEEP8(75) )
               MOVE2DYNAMIC = .FALSE.
          ENDIF
          IF (MOVE2DYNAMIC) THEN
            ALLOCATE(DYNAMIC_CB(RCURRENT_SIZE), stat=allocok)
            IF (allocok .GT. 0) THEN
              IF ( (KEEP(141).NE.1).OR. 
     &           (SIZER_NEEDED-LRLUS).GE.RCURRENT_SIZE) THEN
                IFLAG = -13
                CALL MUMPS_SET_IERROR(SIZER_NEEDED-LRLUS, IERROR)
                GOTO 500
              ENDIF
              IFLAG_M13_OCCURED = .TRUE.
              MIN_SIZE_M13  = min(MIN_SIZE_M13, RCURRENT_SIZE)
            ENDIF
            SIZEHOLE=0_8
            IF (KEEP(216).NE.3) THEN
              CALL DMUMPS_SIZEFREEINREC( IW(ICURRENT),
     &        LIW-ICURRENT+1, SIZEHOLE, KEEP(IXSZ))
            ENDIF
            CALL MUMPS_STOREI8(RCURRENT_SIZE,IW(ICURRENT+XXD))
            DO I8=1_8, RCURRENT_SIZE
              DYNAMIC_CB(I8) = A(RCURRENT+I8-1_8)
            ENDDO
            CALL MUMPS_ADDR_C(DYNAMIC_CB(1), TMP_ADDRESS)
            IF (IS_PTRAST) THEN
              PTRAST(STEP(INODE)) = TMP_ADDRESS
            ELSE IF (IS_PAMASTER) THEN
              PAMASTER(STEP(INODE)) = TMP_ADDRESS
            ELSE
              WRITE(*,*) 
     &          "Internal error 3 in DMUMPS_DM_CBSTATIC2DYNAMIC",
     &        RCURRENT, PTRAST(STEP(INODE)), PAMASTER(STEP(INODE))
              CALL MUMPS_ABORT()
            ENDIF
            LRLUS = LRLUS + (RCURRENT_SIZE-SIZEHOLE)
            KEEP8(69) = KEEP8(69)- (RCURRENT_SIZE-SIZEHOLE)
            CALL MUMPS_SET_SSARBR_DAD(SSARBRDAD, INODE,
     &           DAD, N, KEEP(28),
     &           STEP, PROCNODE_STEPS, SLAVEF)
            CALL DMUMPS_LOAD_MEM_UPDATE( SSARBRDAD, .FALSE.,
     &      LA - LRLUS, 0_8, -(RCURRENT_SIZE-SIZEHOLE),
     &      KEEP, KEEP8, LRLUS)
            IF (ICURRENT .EQ. IWPOSCB+1) THEN
              IPTRLU = IPTRLU + RCURRENT_SIZE
              LRLU = LRLU + RCURRENT_SIZE
              CALL MUMPS_STOREI8(0_8, IW(ICURRENT+XXR))
            ENDIF
            CALL DMUMPS_DM_FAC_UPD_DYNCB_MEMCNTS (
     &                            RCURRENT_SIZE, KEEP8, 
     &                            IFLAG, IERROR)
            IF (IFLAG.LT.0) GOTO 500
          ENDIF
        ENDIF
 100    CONTINUE
        RCURRENT = RCURRENT + RCURRENT_SIZE
        ICURRENT = ICURRENT + IW(ICURRENT+XXI)
      END DO
      IF (LRLUS.LT.SIZER_NEEDED) THEN
        IF (IFLAG_M19_OCCURED) THEN
            IFLAG = -19
            CALL MUMPS_SET_IERROR(MIN_SIZE_M19, IERROR)
        ELSE IF (IFLAG_M13_OCCURED) THEN
            IFLAG = -13
            CALL MUMPS_SET_IERROR(MIN_SIZE_M13, IERROR)
        ELSE
            IFLAG = -9
            CALL MUMPS_SET_IERROR(SIZER_NEEDED-LRLUS, IERROR)
        ENDIF
      ENDIF
 500  CONTINUE
      RETURN
      END SUBROUTINE DMUMPS_DM_CBSTATIC2DYNAMIC
      SUBROUTINE DMUMPS_DM_FREEALLDYNAMICCB( MYID, N, SLAVEF,
     &           KEEP, KEEP8, IW, LIW, IWPOSCB, IWPOS,
     &           LRLU, IPTRLU, LRLUS, STEP, PTRAST, PAMASTER,
     &           PROCNODE_STEPS, DAD )
      INTEGER, INTENT(in)  :: N, SLAVEF, KEEP(500)
      INTEGER, INTENT(in)  :: MYID
      INTEGER(8), INTENT(inout) :: KEEP8(150)  
      INTEGER :: IWPOS, IWPOSCB, LIW
      INTEGER, INTENT(inout) :: IW( LIW ) 
      INTEGER(8) :: LRLU, IPTRLU, LRLUS
      INTEGER, INTENT(in)    :: STEP(N)
      INTEGER(8), INTENT(in) :: PTRAST(KEEP(28)), PAMASTER(KEEP(28))
      INTEGER, INTENT(in)    :: PROCNODE_STEPS(KEEP(28)), DAD(KEEP(28))
      INCLUDE 'mumps_headers.h'
      INTEGER :: ICURRENT, INODE
      INTEGER :: CB_STATE
      INTEGER(8) :: DYN_SIZE, TMP_ADDRESS
      INTEGER(8), PARAMETER :: RDUMMY = -987654
      LOGICAL :: IS_PAMASTER, IS_PTRAST
      DOUBLE PRECISION, DIMENSION(:), POINTER :: TMP_PTR
      ICURRENT  = IWPOSCB + 1 
      IF (KEEP8(73) .NE. 0_8) THEN
       DO WHILE (ICURRENT .NE. LIW-KEEP(IXSZ)+1)
        INODE = IW(ICURRENT+XXN)
        CB_STATE = IW(ICURRENT+XXS)
        IF (CB_STATE.NE.S_FREE) THEN
         CALL MUMPS_GETI8( DYN_SIZE, IW(ICURRENT+XXD) )
         IF (DYN_SIZE .GT. 0_8) THEN
          CALL DMUMPS_DM_PAMASTERORPTRAST( N, SLAVEF, MYID, KEEP(28),
     &    INODE, CB_STATE, IW(ICURRENT+XXD),
     &    STEP, DAD, PROCNODE_STEPS,
     &    RDUMMY, PAMASTER, PTRAST,  
     &    IS_PAMASTER, IS_PTRAST )
          IF (IS_PAMASTER) THEN
            TMP_ADDRESS = PAMASTER(STEP(INODE))
          ELSE IF (IS_PTRAST) THEN
            TMP_ADDRESS = PTRAST(STEP(INODE))
          ELSE
            WRITE(*,*) "Internal error 1 in DMUMPS_DM_FREEALLDYNAMICCB"
     &      , IS_PTRAST, IS_PAMASTER
          ENDIF
          CALL DMUMPS_DM_SET_PTR(TMP_ADDRESS, DYN_SIZE, TMP_PTR)
          CALL DMUMPS_DM_FREE_BLOCK(TMP_PTR, DYN_SIZE, KEEP8)
          CALL MUMPS_STOREI8(0_8, IW(ICURRENT+XXD))
         ENDIF
        ENDIF
        ICURRENT = ICURRENT + IW(ICURRENT+XXI)
       ENDDO
      ENDIF
      RETURN
      END SUBROUTINE DMUMPS_DM_FREEALLDYNAMICCB
      SUBROUTINE DMUMPS_DM_SET_PTR(ADDRESS, SIZFR8, CBPTR)
      USE DMUMPS_STATIC_PTR_M, ONLY : DMUMPS_GET_TMP_PTR
      IMPLICIT NONE
      INTEGER(8), INTENT(IN) :: ADDRESS, SIZFR8
#if defined(MUMPS_F2003)
      DOUBLE PRECISION, DIMENSION(:), POINTER, INTENT(out) :: CBPTR
#else
      DOUBLE PRECISION, DIMENSION(:), POINTER :: CBPTR
#endif
!$OMP CRITICAL(STATIC_PTR_ACCESS)
      CALL DMUMPS_SET_TMP_PTR_C( ADDRESS, SIZFR8 )
      CALL DMUMPS_GET_TMP_PTR( CBPTR )
!$OMP END CRITICAL(STATIC_PTR_ACCESS)
      RETURN
      END SUBROUTINE DMUMPS_DM_SET_PTR
      SUBROUTINE DMUMPS_DM_FREE_BLOCK(DYNPTR, SIZFR8, KEEP8)
      IMPLICIT NONE
      DOUBLE PRECISION, POINTER, DIMENSION(:) :: DYNPTR
      INTEGER(8) :: SIZFR8
      INTEGER(8) :: KEEP8(150)
      INTEGER IDUMMY
      DEALLOCATE(DYNPTR)
      NULLIFY(DYNPTR)
      CALL DMUMPS_DM_FAC_UPD_DYNCB_MEMCNTS (
     &                         -SIZFR8, KEEP8, IDUMMY, IDUMMY)
      RETURN
      END SUBROUTINE DMUMPS_DM_FREE_BLOCK
#endif
      END MODULE DMUMPS_DYNAMIC_MEMORY_M
