/*
 * Decompiled with CFR 0.152.
 */
package org.helios.jmx.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.helios.helpers.JMXHelperExtended;
import org.helios.jmx.client.AliasFailureException;
import org.helios.jmx.client.AsyncClientInterfaceNotSupported;
import org.helios.jmx.client.AsyncHeliosJMXClient;
import org.helios.jmx.client.ConnectionException;
import org.helios.jmx.client.ConstructionException;
import org.helios.jmx.client.HeliosJMXClient;
import org.helios.jmx.dynamic.OperationNotFoundException;
import org.helios.jmx.dynamic.core.registry.AliasingProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHeliosJMXClient
implements HeliosJMXClient {
    protected MBeanServerConnection mBeanServerConnection = null;
    protected ObjectName bootStrapService = null;
    protected boolean async = false;
    protected AsyncHeliosJMXClient asyncClient = null;
    protected AliasingProxy aliasedCallHandler = null;
    protected String clientPrincipal = null;
    protected String clientCredentials = null;
    protected String serverURL = null;
    protected String defaultDomain = null;
    protected Object securityLevel = null;
    protected Object securityProtocol = null;

    public AbstractHeliosJMXClient() {
    }

    public AbstractHeliosJMXClient(Properties env) throws ConnectionException, ConstructionException {
        this.defaultDomain = env.getProperty("org.helios.client.jmx.domain", "DefaultDomain");
        this.bootStrapService = JMXHelperExtended.objectName(env.getProperty("org.helios.bootstrap.objectname", "org.helios:service=HeliosBootStrap"));
        this.clientPrincipal = env.getProperty("org.helios.client.principal", "HeliosClient");
        this.clientCredentials = env.getProperty("org.helios.client.credentials", "HeliosClientCredentials");
        this.serverURL = env.getProperty("org.helios.server.url", SERVER_URL_DEFAULT);
        this.securityLevel = env.getProperty("java.naming.security.authentication");
        this.securityProtocol = env.getProperty("java.naming.security.protocol");
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() {
        return this.mBeanServerConnection;
    }

    @Override
    public Object getAttribute(ObjectName objectName, String attributeName) throws AttributeNotFoundException, InstanceNotFoundException {
        try {
            return this.mBeanServerConnection.getAttribute(objectName, attributeName);
        }
        catch (MBeanException e) {
            throw this.processException("MBean Exception getting attribute", objectName, attributeName, e);
        }
        catch (ReflectionException e) {
            throw this.processException("Refelection Exception getting attribute", objectName, attributeName, e);
        }
        catch (IOException e) {
            throw this.processException("IO Exception getting attribute", objectName, attributeName, e);
        }
    }

    @Override
    public Map<String, Object> getAttributes(ObjectName objectName, String[] attributeNames) throws InstanceNotFoundException {
        HashMap<String, Object> attributes = null;
        try {
            AttributeList attrs = this.mBeanServerConnection.getAttributes(objectName, attributeNames);
            attributes = new HashMap<String, Object>(attrs.size());
            Attribute a = null;
            for (int i = 0; i < attrs.size(); ++i) {
                a = (Attribute)attrs.get(i);
                attributes.put(a.getName(), a.getValue());
            }
            return attributes;
        }
        catch (ReflectionException e) {
            throw this.processException("Reflection Exception getting attributes", objectName, this.flatten(attributeNames), e);
        }
        catch (IOException e) {
            throw this.processException("IO Exception getting attributes", objectName, this.flatten(attributeNames), e);
        }
    }

    @Override
    public Object getAttribute(String aliasName) throws AliasFailureException {
        return this.aliasedCallHandler.getAttribute(aliasName);
    }

    @Override
    public Map<String, Object> getAttributes(String ... aliasNames) {
        return this.aliasedCallHandler.getAttributes(aliasNames);
    }

    @Override
    public void setAttribute(ObjectName objectName, String attributeName, Object value) throws AttributeNotFoundException, InstanceNotFoundException {
        try {
            this.mBeanServerConnection.setAttribute(objectName, new Attribute(attributeName, value));
        }
        catch (InvalidAttributeValueException e) {
            throw this.processException("Invalid Value Exception setting attribute", objectName, this.flatten(attributeName, value), e);
        }
        catch (MBeanException e) {
            throw this.processException("MBean Exception setting attribute", objectName, this.flatten(attributeName, value), e);
        }
        catch (ReflectionException e) {
            throw this.processException("Reflection Exception setting attribute", objectName, this.flatten(attributeName, value), e);
        }
        catch (IOException e) {
            throw this.processException("IO Exception setting attribute", objectName, this.flatten(attributeName, value), e);
        }
    }

    @Override
    public void setAttributes(ObjectName objectName, Map<String, ? extends Object> values) throws InstanceNotFoundException {
        if (values == null || values.size() < 1) {
            return;
        }
        AttributeList attrList = new AttributeList(values.size());
        for (Map.Entry<String, ? extends Object> entry : values.entrySet()) {
            attrList.add(new Attribute(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public void setAttribute(String aliasName, Object value) throws AliasFailureException {
        this.aliasedCallHandler.setAttribute(aliasName, value);
    }

    @Override
    public Object invoke(ObjectName objectName, String action, Object[] args, String[] signature) throws InstanceNotFoundException, OperationNotFoundException {
        try {
            Object retValue = this.mBeanServerConnection.invoke(objectName, action, args, signature);
            return retValue;
        }
        catch (MBeanException e) {
            throw this.processException("MBean Exception invoking op", objectName, action, e);
        }
        catch (ReflectionException e) {
            throw this.processException("Reflection Exception invoking op", objectName, action, e);
        }
        catch (IOException e) {
            throw this.processException("IO Exception invoking op", objectName, action, e);
        }
    }

    @Override
    public Object invoke(String aliasName, Object ... args) throws AliasFailureException {
        return this.aliasedCallHandler.invoke(aliasName, args);
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        try {
            this.mBeanServerConnection.addNotificationListener(objectName, listener, filter, handback);
        }
        catch (IOException e) {
            throw this.processException("IO Exception adding notification listener", objectName, listener.toString(), e);
        }
    }

    @Override
    public void addNotificationListener(String aliasName, NotificationListener listener, NotificationFilter filter, Object handback) throws AliasFailureException {
        this.aliasedCallHandler.addNotificationListener(aliasName, listener, filter, handback);
    }

    @Override
    public int addWildcardNotificationListener(String regEx, NotificationListener listener, NotificationFilter filter, Object handback, boolean perpetual) {
        return this.aliasedCallHandler.addWildcardNotificationListener(regEx, listener, filter, handback, perpetual);
    }

    @Override
    public int addWildcardAttributeNotificationListener(String regEx, NotificationListener listener, NotificationFilter filter, Object handback, boolean perpetual) {
        return this.aliasedCallHandler.addWildcardAttributeNotificationListener(regEx, listener, filter, handback, perpetual);
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    @Override
    public AsyncHeliosJMXClient getAsyncInterface() throws AsyncClientInterfaceNotSupported {
        if (!this.async) {
            throw new AsyncClientInterfaceNotSupported();
        }
        return this.asyncClient;
    }

    protected RuntimeException processException(String cause, ObjectName on, String target, Exception exception) {
        StringBuilder buff = new StringBuilder(cause);
        buff.append(" occured for object name [").append(on).append("] ");
        buff.append(" for target [").append(target).append("]");
        return new RuntimeException(buff.toString(), exception);
    }

    protected <K> String flatten(K[] array) {
        StringBuilder buff = new StringBuilder();
        for (K k : array) {
            buff.append(k.toString()).append(",");
        }
        buff.deleteCharAt(buff.length() - 1);
        return buff.toString();
    }

    protected String flatten(String name, Object value) {
        StringBuilder buff = new StringBuilder(name);
        buff.append(":").append(value);
        return buff.toString();
    }
}

