/* This file was contributed by Suzanne Skinner and is copyrighted
   under the GNU General Public License. (C) 2002 Suzanne Skinner.

   The code contained in this file is free software; you can
   redistribute it and/or modify it under the terms of the GNU General
   Public License as published by the Free Software Foundation; either
   version 2, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

/* This library implements a simple growable-string type, dynstr. A dynstr
 * is a pointer to a struct containing, in addition to the null-terminated
 * string, a bufsize field indicating its current allocation size.
 * ds_ functions (all of which take a pointer to dynstr) will realloc
 * the buffer if necessary.
 *
 * Always set a dynstr to NULL when declaring it. ds_ functions will recognize
 * this and initialize it to empty-string before performing any other
 * operations.
 *
 * You can retrieve the C string stored in a dynstr by calling the ds_get
 * function, which returns char*. To free up any allocated space for a dynstr
 * (setting it back to NULL), call ds_free(&str). It is safe to call this
 * function on a NULL dynstr.
 *
 * Various functions return -1 if there is not enough memory.
 */

#ifndef DYNSTR_H
#define DYNSTR_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

struct dynstr_struct {
    char   *buf;
    size_t  bufsize;
};
typedef struct dynstr_struct *dynstr;

int      ds_set(dynstr *str, const char *text);
char    *ds_get(dynstr *str);
size_t   ds_len(dynstr *str);
void     ds_free(dynstr *str);
int      ds_append(dynstr *str, const char *text);
int      ds_append_char(dynstr *str, char ch);
int      ds_insert(dynstr *str, int pos, const char *text);
int      ds_insert_char(dynstr *str, int pos, char ch);
int      ds_delete_substr(dynstr *str, int pos, int len);
int      ds_delete_char(dynstr *str, int pos);
int      ds_truncate(dynstr *str, int new_len);
int      ds_sprintf(dynstr *str, const char *format, ...);
int      ds_sprintf_at(dynstr *str, int pos, const char *format, ...);
int      ds_vsprintf(dynstr *str, const char *format, va_list args);
int      ds_vsprintf_at(dynstr *str, int pos, const char *format,
                        va_list args);

#endif /* DYNSTR_H */
