/* $Id: missing.h,v 1.2 2002/12/09 05:28:09 selinger Exp $ */
/* replacements for missing library functions */

/* libc documentation: "On architectures where a simple assignment is
   invalid, hopefully `__va_copy' _will_ be available" */

#ifndef va_copy
# ifdef __va_copy
#  define va_copy(dest, src) __va_copy(dest, src)
# else
#  define va_copy(dest, src) ((dest) = (src))
# endif /* __va_copy */
#endif /* undef va_copy */

#ifndef HAVE_HSTRERROR
extern const char *hstrerror(int err);
#endif

#ifndef HAVE_STRCASESTR
  char *strcasestr(const char *haystack, const char *needle);
#endif

#ifndef HAVE_STRSEP
  char *strsep(char **stringp, const char *delim);
#endif

#ifndef HAVE_VASPRINTF
  int vasprintf(char **str, const char *fmt, va_list args);
#endif

