/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2009 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.javacard.project.customizer;

import org.netbeans.modules.javacard.common.JarOrDirectoryFilter;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

import javax.swing.*;
import java.io.File;
import org.openide.util.HelpCtx;

/**
 *
 * @author Anki R. Nelaturu
 */
public class DependencyCustomizer extends javax.swing.JPanel implements ActionListener, MouseListener, ListSelectionListener {

    /** Creates new form ClsLibProjectCustomizerDependencies */
    public DependencyCustomizer(JCProjectProperties props) {
        initComponents();
        libList.setModel(props.getClassPathModel());
        HelpCtx.setHelpIDString(this, "org.netbeans.modules.javacard.DependenciesPanel"); //NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        libList = new javax.swing.JList();
        jLabel1 = new javax.swing.JLabel();
        addLibButton = new javax.swing.JButton();
        removeLibButton = new javax.swing.JButton();
        upLibButton = new javax.swing.JButton();
        downLibButton = new javax.swing.JButton();
        addJarButton = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();

        libList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        libList.addMouseListener(this);
        libList.addListSelectionListener(this);
        jScrollPane1.setViewportView(libList);

        jLabel1.setFont(jLabel1.getFont().deriveFont(jLabel1.getFont().getStyle() | java.awt.Font.BOLD));
        jLabel1.setText(org.openide.util.NbBundle.getMessage(DependencyCustomizer.class, "DependencyCustomizer.jLabel1.text")); // NOI18N

        addLibButton.setText(org.openide.util.NbBundle.getMessage(DependencyCustomizer.class, "DependencyCustomizer.addLibButton.text")); // NOI18N
        addLibButton.setToolTipText(org.openide.util.NbBundle.getMessage(DependencyCustomizer.class, "DependencyCustomizer.addLibButton.toolTipText")); // NOI18N
        addLibButton.setEnabled(false);
        addLibButton.addActionListener(this);

        removeLibButton.setText(org.openide.util.NbBundle.getMessage(DependencyCustomizer.class, "DependencyCustomizer.removeLibButton.text")); // NOI18N
        removeLibButton.addActionListener(this);

        upLibButton.setText(org.openide.util.NbBundle.getMessage(DependencyCustomizer.class, "DependencyCustomizer.upLibButton.text")); // NOI18N
        upLibButton.addActionListener(this);

        downLibButton.setText(org.openide.util.NbBundle.getMessage(DependencyCustomizer.class, "DependencyCustomizer.downLibButton.text")); // NOI18N
        downLibButton.addActionListener(this);

        addJarButton.setText(org.openide.util.NbBundle.getMessage(DependencyCustomizer.class, "DependencyCustomizer.addJarButton.text")); // NOI18N
        addJarButton.addActionListener(this);

        jScrollPane2.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jScrollPane2.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane2.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);
        jScrollPane2.setViewportBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));

        jTextArea1.setBackground(javax.swing.UIManager.getDefaults().getColor("control"));
        jTextArea1.setColumns(20);
        jTextArea1.setEditable(false);
        jTextArea1.setFont(downLibButton.getFont());
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(5);
        jTextArea1.setText(org.openide.util.NbBundle.getMessage(DependencyCustomizer.class, "DependencyCustomizer.jTextArea1.text")); // NOI18N
        jTextArea1.setWrapStyleWord(true);
        jTextArea1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jScrollPane2.setViewportView(jTextArea1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 514, Short.MAX_VALUE)
                        .addContainerGap())
                    .addComponent(jLabel1)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 310, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(addLibButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(downLibButton, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(upLibButton, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(removeLibButton, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(addJarButton, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addContainerGap())))
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {addJarButton, addLibButton, downLibButton, removeLibButton, upLibButton});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(9, 9, 9)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 61, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(addLibButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(addJarButton)
                        .addGap(9, 9, 9)
                        .addComponent(removeLibButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(upLibButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(downLibButton))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 297, Short.MAX_VALUE))
                .addContainerGap())
        );
    }

    // Code for dispatching events from components to event handlers.

    public void actionPerformed(java.awt.event.ActionEvent evt) {
        if (evt.getSource() == addLibButton) {
            DependencyCustomizer.this.addLibButtonActionPerformed(evt);
        }
        else if (evt.getSource() == removeLibButton) {
            DependencyCustomizer.this.removeLibButtonActionPerformed(evt);
        }
        else if (evt.getSource() == upLibButton) {
            DependencyCustomizer.this.upLibButtonActionPerformed(evt);
        }
        else if (evt.getSource() == downLibButton) {
            DependencyCustomizer.this.downLibButtonActionPerformed(evt);
        }
        else if (evt.getSource() == addJarButton) {
            DependencyCustomizer.this.addJarButtonActionPerformed(evt);
        }
    }

    public void mouseClicked(java.awt.event.MouseEvent evt) {
        if (evt.getSource() == libList) {
            DependencyCustomizer.this.libListMouseClicked(evt);
        }
    }

    public void mouseEntered(java.awt.event.MouseEvent evt) {
    }

    public void mouseExited(java.awt.event.MouseEvent evt) {
    }

    public void mousePressed(java.awt.event.MouseEvent evt) {
    }

    public void mouseReleased(java.awt.event.MouseEvent evt) {
    }

    public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
        if (evt.getSource() == libList) {
            DependencyCustomizer.this.libListValueChanged(evt);
        }
    }// </editor-fold>//GEN-END:initComponents

    private void libListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_libListMouseClicked
        int index = libList.getSelectedIndex();
        removeLibButton.setEnabled(index != -1);
        upLibButton.setEnabled(index != -1);
        downLibButton.setEnabled(index != -1);
    }//GEN-LAST:event_libListMouseClicked

    private void addLibButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addLibButtonActionPerformed

    }//GEN-LAST:event_addLibButtonActionPerformed

    private void removeLibButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeLibButtonActionPerformed
        int index = libList.getSelectedIndex();
        if(index != -1) {
            ((DefaultListModel)libList.getModel()).removeElementAt(index);
        }
    }//GEN-LAST:event_removeLibButtonActionPerformed

    private void libListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_libListValueChanged
        int index = libList.getSelectedIndex();
        removeLibButton.setEnabled(index != -1);
        upLibButton.setEnabled(index != -1);
        downLibButton.setEnabled(index != -1);
    }//GEN-LAST:event_libListValueChanged

    private void upLibButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_upLibButtonActionPerformed
        int index = libList.getSelectedIndex();
        if(index > 0) {
            DefaultListModel m = (DefaultListModel) libList.getModel();
            Object o = m.elementAt(index);
            m.removeElementAt(index);
            m.insertElementAt(o, index-1);
            libList.setSelectedIndex(index - 1);
        }
    }//GEN-LAST:event_upLibButtonActionPerformed

    private void downLibButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_downLibButtonActionPerformed
        int index = libList.getSelectedIndex();
        if(index < libList.getModel().getSize() - 1) {
            DefaultListModel m = (DefaultListModel) libList.getModel();
            Object o = m.elementAt(index);
            m.removeElementAt(index);
            m.insertElementAt(o, index+1);
            libList.setSelectedIndex(index + 1);
        }
    }//GEN-LAST:event_downLibButtonActionPerformed

    private void addJarButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addJarButtonActionPerformed
        File[] files = null;
        if ((files = new FileChooserBuilder(DependencyCustomizer.class).
                setFileFilter(new JarOrDirectoryFilter()).setTitle (
                NbBundle.getMessage(DependencyCustomizer.class,
                "DLG_JAR_OR_DIR")).showMultiOpenDialog()) != null) { //NOI18N
            for(File f : files) {
                ((DefaultListModel)libList.getModel()).addElement(f.getAbsolutePath());
            }
        }
}//GEN-LAST:event_addJarButtonActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addJarButton;
    private javax.swing.JButton addLibButton;
    private javax.swing.JButton downLibButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JList libList;
    private javax.swing.JButton removeLibButton;
    private javax.swing.JButton upLibButton;
    // End of variables declaration//GEN-END:variables

}
