/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2009 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.git.remote.ui.status;

import javax.swing.JPanel;
import javax.swing.UIManager;

/**
 * The main class of the Synchronize view, shows and acts on set of file roots. 
 * 
 * @author Maros Sandor 
 */
class VersioningPanel extends JPanel {
    
    /**
     * Creates a new Synchronize Panel managed by the given versioning system.
     *  
     * @param parent enclosing top component
     */ 
    public VersioningPanel () {
        initComponents();
        
        if( "Aqua".equals( UIManager.getLookAndFeel().getID() ) ) {             // NOI18N
            setBackground(UIManager.getColor("NbExplorerView.background")); // NOI18N
            jPanel2.setBackground(UIManager.getColor("NbExplorerView.background")); // NOI18N
            jPanel3.setBackground(UIManager.getColor("NbExplorerView.background")); // NOI18N
            jPanel4.setBackground(UIManager.getColor("NbExplorerView.background")); // NOI18N
            jPanel5.setBackground(UIManager.getColor("NbExplorerView.background")); // NOI18N
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        btnGroupModes = new javax.swing.ButtonGroup();
        viewButtonGroup = new javax.swing.ButtonGroup();
        jPanel4 = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        jPanel2.setFloatable(false);
        jPanel2.setRollover(true);

        btnGroupModes.add(tgbHeadVsWorking);
        tgbHeadVsWorking.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/head_vs_working.png"))); // NOI18N
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/git/remote/ui/status/Bundle"); // NOI18N
        tgbHeadVsWorking.setToolTipText(bundle.getString("CTL_Synchronize_Action_HeadVsWorking_Tooltip")); // NOI18N
        tgbHeadVsWorking.setFocusable(false);
        jPanel2.add(tgbHeadVsWorking);
        tgbHeadVsWorking.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(VersioningPanel.class, "CTL_Synchronize_Action_HeadVsWorking_Text")); // NOI18N

        btnGroupModes.add(tgbHeadVsIndex);
        tgbHeadVsIndex.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/head_vs_index.png"))); // NOI18N
        tgbHeadVsIndex.setToolTipText(bundle.getString("CTL_Synchronize_Action_HeadVsIndex_Tooltip")); // NOI18N
        tgbHeadVsIndex.setFocusable(false);
        jPanel2.add(tgbHeadVsIndex);
        tgbHeadVsIndex.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(VersioningPanel.class, "CTL_Synchronize_Action_HeadVsIndex_Text")); // NOI18N

        btnGroupModes.add(tgbIndexVsWorking);
        tgbIndexVsWorking.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/index_vs_working.png"))); // NOI18N
        tgbIndexVsWorking.setToolTipText(bundle.getString("CTL_Synchronize_Action_IndexVsWorking_Tooltip")); // NOI18N
        tgbIndexVsWorking.setFocusable(false);
        jPanel2.add(tgbIndexVsWorking);
        tgbIndexVsWorking.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(VersioningPanel.class, "CTL_Synchronize_Action_IndexVsWorking_Text")); // NOI18N

        jPanel4.setMaximumSize(new java.awt.Dimension(40, 32767));
        jPanel4.setOpaque(false);
        jPanel2.add(jPanel4);

        viewButtonGroup.add(listButton);
        listButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/file_view.png"))); // NOI18N
        listButton.setToolTipText(bundle.getString("CTL_listButton.toolTipText")); // NOI18N
        listButton.setFocusable(false);
        listButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jPanel2.add(listButton);

        viewButtonGroup.add(treeButton);
        treeButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/logical_view.png"))); // NOI18N
        treeButton.setToolTipText(bundle.getString("CTL_treeButton.toolTipText")); // NOI18N
        treeButton.setFocusable(false);
        treeButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jPanel2.add(treeButton);

        jPanel5.setMaximumSize(new java.awt.Dimension(40, 32767));
        jPanel5.setOpaque(false);
        jPanel2.add(jPanel5);

        btnRefresh.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/refresh.png"))); // NOI18N
        btnRefresh.setToolTipText(bundle.getString("CTL_Synchronize_Action_Refresh_Tooltip")); // NOI18N
        btnRefresh.setFocusable(false);
        btnRefresh.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jPanel2.add(btnRefresh);
        btnRefresh.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(VersioningPanel.class, "CTL_Synchronize_Action_Refresh_Text")); // NOI18N

        btnDiff.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/diff.png"))); // NOI18N
        btnDiff.setToolTipText(bundle.getString("CTL_Synchronize_Action_Diff_Tooltip")); // NOI18N
        btnDiff.setFocusable(false);
        jPanel2.add(btnDiff);
        btnDiff.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(VersioningPanel.class, "CTL_Synchronize_Action_Diff_Text")); // NOI18N

        jPanel3.setMaximumSize(new java.awt.Dimension(20, 32767));
        jPanel3.setOpaque(false);
        jPanel2.add(jPanel3);

        btnRevert.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/get_clean.png"))); // NOI18N
        btnRevert.setToolTipText(bundle.getString("CTL_Synchronize_Action_CheckoutPaths_Tooltip")); // NOI18N
        btnRevert.setFocusable(false);
        jPanel2.add(btnRevert);
        btnRevert.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(VersioningPanel.class, "CTL_Synchronize_Action_CheckoutPaths_Text")); // NOI18N

        btnCommit.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/commit.png"))); // NOI18N
        btnCommit.setToolTipText(bundle.getString("CTL_Synchronize_Action_Commit_Tooltip")); // NOI18N
        btnCommit.setFocusable(false);
        jPanel2.add(btnCommit);
        btnCommit.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(VersioningPanel.class, "CTL_Synchronize_Action_Commit_Text")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 0, 3, 0);
        add(jPanel2, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    final javax.swing.JButton btnCommit = new javax.swing.JButton();
    final javax.swing.JButton btnDiff = new javax.swing.JButton();
    private javax.swing.ButtonGroup btnGroupModes;
    final javax.swing.JButton btnRefresh = new javax.swing.JButton();
    final javax.swing.JButton btnRevert = new javax.swing.JButton();
    final javax.swing.JToolBar jPanel2 = new javax.swing.JToolBar();
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    final javax.swing.JToggleButton listButton = new javax.swing.JToggleButton();
    final javax.swing.JToggleButton tgbHeadVsIndex = new javax.swing.JToggleButton();
    final javax.swing.JToggleButton tgbHeadVsWorking = new javax.swing.JToggleButton();
    final javax.swing.JToggleButton tgbIndexVsWorking = new javax.swing.JToggleButton();
    final javax.swing.JToggleButton treeButton = new javax.swing.JToggleButton();
    private javax.swing.ButtonGroup viewButtonGroup;
    // End of variables declaration//GEN-END:variables
}
