<!--
title: "Step ∞. You're finished!"
custom_edit_url: https://github.com/netdata/netdata/edit/master/docs/guides/step-by-step/step-99.md
-->

# Step ∞. You're finished!

Congratulations. 🎉

You've completed the step-by-step Netdata guide. That means you're well on your way to becoming an expert in using
our toolkit for health monitoring and performance troubleshooting.

But, perhaps more importantly, also that much closer to being an expert in the _fundamental skills behind health
monitoring and performance troubleshooting_, which you can take with you to any job or project.

And that is the entire point of this guide, and Netdata's [documentation](https://learn.netdata.cloud) as a
whole—give you every resource possible to help you build faster, more resilient systems, services, and applications.

Along the way, you learned how to:

-   Navigate Netdata's dashboard and visually detect anomalies using its charts.
-   Monitor multiple systems using Netdata agents connected together with your browser and Netdata Cloud.
-   Edit your `netdata.conf` file to tweak Netdata to your liking.
-   Tune existing alarms and create entirely new ones, plus get notifications about alarms on your favorite services.
-   Take advantage of Netdata's auto-detection capabilities to ensure your applications/services are monitored with
    little to no configuration.
-   Use advanced features within Netdata's dashboard.
-   Build a custom dashboard using `dashboard.js`.
-   Save more historical metrics with the database engine or archive metrics to MongoDB.
-   Put Netdata behind a proxy to enable HTTPS and improve performance.

Seems like a lot, right? Well, we hope it felt manageable and, yes, even _fun_.

## What's next?

Now that you're at the end of our step-by-step Netdata guide, the next steps are entirely up to you. In fact, you're
just at the beginning of your journey into health monitoring and performance troubleshooting.

Our documentation exists to put every Netdata resource in front of you as easily and coherently as we possibly can.
Click around, search, and find new mountains to climb.

If that feels like too much possibility to you, why not one of these options:

-   Share your experience with Netdata and this guide. Be sure to [@mention](https://twitter.com/linuxnetdata) us on 
    Twitter!
-   Contribute to what we do. Browse our [open issues](https://github.com/netdata/netdata/issues) and check out out
    [contributions doc](/README.md#contribute) for ideas of how you can pitch in.

We can't wait to see what you monitor next! Bon voyage! ⛵

[![analytics](https://www.google-analytics.com/collect?v=1&aip=1&t=pageview&_s=1&ds=github&dr=https%3A%2F%2Fgithub.com%2Fnetdata%2Fnetdata&dl=https%3A%2F%2Fmy-netdata.io%2Fgithub%2Fdocs%2Fguides%2Fstep-by-step%2Fstep-99&_u=MAC~&cid=5792dfd7-8dc4-476b-af31-da2fdb9f93d2&tid=UA-64295674-3)](<>)
