# Snapshot report for `test/test.js`

The actual snapshot is saved in `test.js.snap`.

Generated by [AVA](https://ava.li).

## imports an image

> Snapshot 1

    `'use strict';␊
    ␊
    const img = "data:image/jpeg;base64,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";␊
    ␊
    /* eslint-disable */␊
    ␊
    const state = 'valid';␊
    ␊
    console.log(state, img);␊
    `

## imports an image for the dom

> Snapshot 1

    `'use strict';␊
    ␊
    const img = new Image();␊
      img.src = "data:image/jpeg;base64,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";␊
    ␊
    /* eslint-disable */␊
    ␊
    const state = 'valid';␊
    ␊
    console.log(state, img);␊
    `

## imports an svg for dom, encodes for url

> Snapshot 1

    `'use strict';␊
    ␊
    const img = new Image();␊
      img.src = "data:image/svg+xml,%3c%3fxml version='1.0' encoding='UTF-8'%3f%3e%3csvg width='256px' height='335px' viewBox='0 0 256 335' version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' preserveAspectRatio='xMidYMid'%3e %3cdefs%3e %3clinearGradient x1='26.8242921%25' y1='48.2236445%25' x2='67.5758137%25' y2='55.339338%25' id='linearGradient-1'%3e %3cstop stop-color='%23FF6533' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='%23FF5633' offset='15.7%25'%3e%3c/stop%3e %3cstop stop-color='%23FF4333' offset='43.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3733' offset='71.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3333' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3clinearGradient x1='20.4503837%25' y1='38.1333935%25' x2='93.4858428%25' y2='80.4322382%25' id='linearGradient-2'%3e %3cstop stop-color='%23BF3338' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3333' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3clinearGradient x1='32.2926113%25' y1='39.496861%25' x2='45.5563705%25' y2='48.9139013%25' id='linearGradient-3'%3e %3cstop stop-color='%23FF6533' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='%23FF5633' offset='15.7%25'%3e%3c/stop%3e %3cstop stop-color='%23FF4333' offset='43.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3733' offset='71.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3333' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3clinearGradient x1='51.5641026%25' y1='78.3444231%25' x2='48.5176441%25' y2='41.6628279%25' id='linearGradient-4'%3e %3cstop stop-color='%23FF6533' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='%23FF5633' offset='15.7%25'%3e%3c/stop%3e %3cstop stop-color='%23FF4333' offset='43.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3733' offset='71.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3333' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3clinearGradient x1='40.2012262%25' y1='47.2148639%25' x2='53.9750044%25' y2='54.5349876%25' id='linearGradient-5'%3e %3cstop stop-color='%23FBB040' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='%23FB8840' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3clinearGradient x1='55.2222794%25' y1='5.88782542%25' x2='40.9262994%25' y2='128.016462%25' id='linearGradient-6'%3e %3cstop stop-color='white' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='white' stop-opacity='0' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3c/defs%3e %3cg%3e %3cpath d='M256%2c110.132723 C256%2c90.4494279 250.844851%2c71.9963387 241.76476%2c56.0036613 C217.687872%2c31.2237986 165.316247%2c25.4828375 152.311213%2c55.8864989 C138.954691%2c87.0517162 174.747826%2c121.731808 190.389016%2c118.97849 C210.306636%2c115.463616 186.874142%2c69.7702517 186.874142%2c69.7702517 C217.336384%2c127.179863 210.306636%2c109.605492 155.240275%2c162.328604 C100.173913%2c215.051716 43.9359268%2c326.297483 35.7345538%2c330.983982 C35.3830664%2c331.218307 35.0315789%2c331.39405 34.6215103%2c331.569794 L250.610526%2c331.569794 C254.418307%2c331.569794 256.878719%2c327.527689 255.179863%2c324.129977 L198.707551%2c212.356979 C197.477346%2c209.955149 198.356064%2c206.967506 200.699314%2c205.620137 C233.73913%2c186.639817 256%2c151.022426 256%2c110.132723 Z' fill='url(%23linearGradient-1)'%3e%3c/path%3e %3cpath d='M256%2c110.132723 C256%2c90.4494279 250.844851%2c71.9963387 241.76476%2c56.0036613 C217.687872%2c31.2237986 165.316247%2c25.4828375 152.311213%2c55.8864989 C138.954691%2c87.0517162 174.747826%2c121.731808 190.389016%2c118.97849 C210.306636%2c115.463616 186.874142%2c69.7702517 186.874142%2c69.7702517 C217.336384%2c127.179863 210.306636%2c109.605492 155.240275%2c162.328604 C100.173913%2c215.051716 43.9359268%2c326.297483 35.7345538%2c330.983982 C35.3830664%2c331.218307 35.0315789%2c331.39405 34.6215103%2c331.569794 L250.610526%2c331.569794 C254.418307%2c331.569794 256.878719%2c327.527689 255.179863%2c324.129977 L198.707551%2c212.356979 C197.477346%2c209.955149 198.356064%2c206.967506 200.699314%2c205.620137 C233.73913%2c186.639817 256%2c151.022426 256%2c110.132723 Z' fill='url(%23linearGradient-2)'%3e%3c/path%3e %3cpath d='M35.7345538%2c330.983982 C43.9359268%2c326.297483 100.173913%2c214.993135 155.240275%2c162.270023 C210.306636%2c109.546911 217.336384%2c127.121281 186.874142%2c69.7116705 C186.874142%2c69.7116705 70.2974828%2c233.153318 28.1189931%2c313.995423' fill='url(%23linearGradient-3)'%3e%3c/path%3e %3cpath d='M52.1372998%2c184.530892 C130.870481%2c39.776659 141.180778%2c25.1899314 182.187643%2c25.1899314 C203.745538%2c25.1899314 225.479176%2c34.9144165 239.538673%2c52.195881 C220.382609%2c21.3235698 186.464073%2c0.644393593 147.624714%2c0.0585812357 L13.8837529%2c0.0585812357 C11.0718535%2c0.0585812357 8.78718535%2c2.34324943 8.78718535%2c5.15514874 L8.78718535%2c274.745995 C16.7542334%2c254.183982 30.2864989%2c224.776201 52.1372998%2c184.530892 Z' fill='url(%23linearGradient-4)'%3e%3c/path%3e %3cpath d='M155.240275%2c162.270023 C100.173913%2c214.993135 43.9359268%2c326.297483 35.7345538%2c330.983982 C27.5331808%2c335.670481 13.7665904%2c336.256293 6.44393593%2c328.05492 C-1.34736842%2c319.326316 -13.4736842%2c305.208238 52.1372998%2c184.530892 C130.870481%2c39.776659 141.180778%2c25.1899314 182.187643%2c25.1899314 C203.745538%2c25.1899314 225.479176%2c34.9144165 239.538673%2c52.195881 C240.300229%2c53.426087 241.061785%2c54.7148741 241.823341%2c56.0036613 C217.746453%2c31.2237986 165.374828%2c25.4828375 152.369794%2c55.8864989 C139.013272%2c87.0517162 174.806407%2c121.731808 190.447597%2c118.97849 C210.365217%2c115.463616 186.932723%2c69.7702517 186.932723%2c69.7702517 C217.336384%2c127.121281 210.306636%2c109.546911 155.240275%2c162.270023 Z' fill='url(%23linearGradient-5)'%3e%3c/path%3e %3cpath d='M58.5812357%2c190.974828 C137.314416%2c46.220595 147.624714%2c31.6338673 188.631579%2c31.6338673 C206.381693%2c31.6338673 224.24897%2c38.2535469 237.839817%2c50.204119 C223.78032%2c34.1528604 202.9254%2c25.1899314 182.187643%2c25.1899314 C141.180778%2c25.1899314 130.870481%2c39.776659 52.1372998%2c184.530892 C-13.4736842%2c305.208238 -1.34736842%2c319.326316 6.44393593%2c328.05492 C7.55697941%2c329.285126 8.84576659%2c330.339588 10.193135%2c331.218307 C3.33913043%2c321.259497 0.292906178%2c298.119908 58.5812357%2c190.974828 Z' fill='url(%23linearGradient-6)' opacity='0.3'%3e%3c/path%3e %3c/g%3e%3c/svg%3e";␊
    ␊
    /* eslint-disable */␊
    ␊
    const state = 'valid';␊
    ␊
    console.log(state, img);␊
    `

## imports an svg, encodes for url

> Snapshot 1

    `'use strict';␊
    ␊
    const img = "data:image/svg+xml,%3c%3fxml version='1.0' encoding='UTF-8'%3f%3e%3csvg width='256px' height='335px' viewBox='0 0 256 335' version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' preserveAspectRatio='xMidYMid'%3e %3cdefs%3e %3clinearGradient x1='26.8242921%25' y1='48.2236445%25' x2='67.5758137%25' y2='55.339338%25' id='linearGradient-1'%3e %3cstop stop-color='%23FF6533' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='%23FF5633' offset='15.7%25'%3e%3c/stop%3e %3cstop stop-color='%23FF4333' offset='43.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3733' offset='71.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3333' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3clinearGradient x1='20.4503837%25' y1='38.1333935%25' x2='93.4858428%25' y2='80.4322382%25' id='linearGradient-2'%3e %3cstop stop-color='%23BF3338' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3333' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3clinearGradient x1='32.2926113%25' y1='39.496861%25' x2='45.5563705%25' y2='48.9139013%25' id='linearGradient-3'%3e %3cstop stop-color='%23FF6533' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='%23FF5633' offset='15.7%25'%3e%3c/stop%3e %3cstop stop-color='%23FF4333' offset='43.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3733' offset='71.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3333' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3clinearGradient x1='51.5641026%25' y1='78.3444231%25' x2='48.5176441%25' y2='41.6628279%25' id='linearGradient-4'%3e %3cstop stop-color='%23FF6533' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='%23FF5633' offset='15.7%25'%3e%3c/stop%3e %3cstop stop-color='%23FF4333' offset='43.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3733' offset='71.4%25'%3e%3c/stop%3e %3cstop stop-color='%23FF3333' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3clinearGradient x1='40.2012262%25' y1='47.2148639%25' x2='53.9750044%25' y2='54.5349876%25' id='linearGradient-5'%3e %3cstop stop-color='%23FBB040' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='%23FB8840' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3clinearGradient x1='55.2222794%25' y1='5.88782542%25' x2='40.9262994%25' y2='128.016462%25' id='linearGradient-6'%3e %3cstop stop-color='white' offset='0%25'%3e%3c/stop%3e %3cstop stop-color='white' stop-opacity='0' offset='100%25'%3e%3c/stop%3e %3c/linearGradient%3e %3c/defs%3e %3cg%3e %3cpath d='M256%2c110.132723 C256%2c90.4494279 250.844851%2c71.9963387 241.76476%2c56.0036613 C217.687872%2c31.2237986 165.316247%2c25.4828375 152.311213%2c55.8864989 C138.954691%2c87.0517162 174.747826%2c121.731808 190.389016%2c118.97849 C210.306636%2c115.463616 186.874142%2c69.7702517 186.874142%2c69.7702517 C217.336384%2c127.179863 210.306636%2c109.605492 155.240275%2c162.328604 C100.173913%2c215.051716 43.9359268%2c326.297483 35.7345538%2c330.983982 C35.3830664%2c331.218307 35.0315789%2c331.39405 34.6215103%2c331.569794 L250.610526%2c331.569794 C254.418307%2c331.569794 256.878719%2c327.527689 255.179863%2c324.129977 L198.707551%2c212.356979 C197.477346%2c209.955149 198.356064%2c206.967506 200.699314%2c205.620137 C233.73913%2c186.639817 256%2c151.022426 256%2c110.132723 Z' fill='url(%23linearGradient-1)'%3e%3c/path%3e %3cpath d='M256%2c110.132723 C256%2c90.4494279 250.844851%2c71.9963387 241.76476%2c56.0036613 C217.687872%2c31.2237986 165.316247%2c25.4828375 152.311213%2c55.8864989 C138.954691%2c87.0517162 174.747826%2c121.731808 190.389016%2c118.97849 C210.306636%2c115.463616 186.874142%2c69.7702517 186.874142%2c69.7702517 C217.336384%2c127.179863 210.306636%2c109.605492 155.240275%2c162.328604 C100.173913%2c215.051716 43.9359268%2c326.297483 35.7345538%2c330.983982 C35.3830664%2c331.218307 35.0315789%2c331.39405 34.6215103%2c331.569794 L250.610526%2c331.569794 C254.418307%2c331.569794 256.878719%2c327.527689 255.179863%2c324.129977 L198.707551%2c212.356979 C197.477346%2c209.955149 198.356064%2c206.967506 200.699314%2c205.620137 C233.73913%2c186.639817 256%2c151.022426 256%2c110.132723 Z' fill='url(%23linearGradient-2)'%3e%3c/path%3e %3cpath d='M35.7345538%2c330.983982 C43.9359268%2c326.297483 100.173913%2c214.993135 155.240275%2c162.270023 C210.306636%2c109.546911 217.336384%2c127.121281 186.874142%2c69.7116705 C186.874142%2c69.7116705 70.2974828%2c233.153318 28.1189931%2c313.995423' fill='url(%23linearGradient-3)'%3e%3c/path%3e %3cpath d='M52.1372998%2c184.530892 C130.870481%2c39.776659 141.180778%2c25.1899314 182.187643%2c25.1899314 C203.745538%2c25.1899314 225.479176%2c34.9144165 239.538673%2c52.195881 C220.382609%2c21.3235698 186.464073%2c0.644393593 147.624714%2c0.0585812357 L13.8837529%2c0.0585812357 C11.0718535%2c0.0585812357 8.78718535%2c2.34324943 8.78718535%2c5.15514874 L8.78718535%2c274.745995 C16.7542334%2c254.183982 30.2864989%2c224.776201 52.1372998%2c184.530892 Z' fill='url(%23linearGradient-4)'%3e%3c/path%3e %3cpath d='M155.240275%2c162.270023 C100.173913%2c214.993135 43.9359268%2c326.297483 35.7345538%2c330.983982 C27.5331808%2c335.670481 13.7665904%2c336.256293 6.44393593%2c328.05492 C-1.34736842%2c319.326316 -13.4736842%2c305.208238 52.1372998%2c184.530892 C130.870481%2c39.776659 141.180778%2c25.1899314 182.187643%2c25.1899314 C203.745538%2c25.1899314 225.479176%2c34.9144165 239.538673%2c52.195881 C240.300229%2c53.426087 241.061785%2c54.7148741 241.823341%2c56.0036613 C217.746453%2c31.2237986 165.374828%2c25.4828375 152.369794%2c55.8864989 C139.013272%2c87.0517162 174.806407%2c121.731808 190.447597%2c118.97849 C210.365217%2c115.463616 186.932723%2c69.7702517 186.932723%2c69.7702517 C217.336384%2c127.121281 210.306636%2c109.546911 155.240275%2c162.270023 Z' fill='url(%23linearGradient-5)'%3e%3c/path%3e %3cpath d='M58.5812357%2c190.974828 C137.314416%2c46.220595 147.624714%2c31.6338673 188.631579%2c31.6338673 C206.381693%2c31.6338673 224.24897%2c38.2535469 237.839817%2c50.204119 C223.78032%2c34.1528604 202.9254%2c25.1899314 182.187643%2c25.1899314 C141.180778%2c25.1899314 130.870481%2c39.776659 52.1372998%2c184.530892 C-13.4736842%2c305.208238 -1.34736842%2c319.326316 6.44393593%2c328.05492 C7.55697941%2c329.285126 8.84576659%2c330.339588 10.193135%2c331.218307 C3.33913043%2c321.259497 0.292906178%2c298.119908 58.5812357%2c190.974828 Z' fill='url(%23linearGradient-6)' opacity='0.3'%3e%3c/path%3e %3c/g%3e%3c/svg%3e";␊
    ␊
    /* eslint-disable */␊
    ␊
    const state = 'valid';␊
    ␊
    console.log(state, img);␊
    `
