/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/*
* When adding modules to the namespace, ensure that they are added in alphabetical order according to module name.
*/

// MODULES //

var setReadOnly = require( '@stdlib/utils/define-read-only-property' );


// MAIN //

/**
* Top-level namespace.
*
* @namespace ns
*/
var ns = {};

/**
* @name exponent
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/exponent}
*/
setReadOnly( ns, 'exponent', require( './../../../float64/base/exponent' ) );

/**
* @name fromBinaryString
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/from-binary-string}
*/
setReadOnly( ns, 'fromBinaryString', require( './../../../float64/base/from-binary-string' ) );

/**
* @name fromInt64Bytes
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/from-int64-bytes}
*/
setReadOnly( ns, 'fromInt64Bytes', require( './../../../float64/base/from-int64-bytes' ) );

/**
* @name fromWords
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/from-words}
*/
setReadOnly( ns, 'fromWords', require( './../../../float64/base/from-words' ) );

/**
* @name getHighWord
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/get-high-word}
*/
setReadOnly( ns, 'getHighWord', require( './../../../float64/base/get-high-word' ) );

/**
* @name getLowWord
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/get-low-word}
*/
setReadOnly( ns, 'getLowWord', require( './../../../float64/base/get-low-word' ) );

/**
* @name normalize
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/normalize}
*/
setReadOnly( ns, 'normalize', require( './../../../float64/base/normalize' ) );

/**
* @name setHighWord
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/set-high-word}
*/
setReadOnly( ns, 'setHighWord', require( './../../../float64/base/set-high-word' ) );

/**
* @name setLowWord
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/set-low-word}
*/
setReadOnly( ns, 'setLowWord', require( './../../../float64/base/set-low-word' ) );

/**
* @name signbit
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/signbit}
*/
setReadOnly( ns, 'signbit', require( './../../../float64/base/signbit' ) );

/**
* @name toBinaryString
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/to-binary-string}
*/
setReadOnly( ns, 'toBinaryString', require( './../../../float64/base/to-binary-string' ) );

/**
* @name float64ToFloat32
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/to-float32}
*/
setReadOnly( ns, 'float64ToFloat32', require( './../../../float64/base/to-float32' ) );

/**
* @name float64ToInt32
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/to-int32}
*/
setReadOnly( ns, 'float64ToInt32', require( './../../../float64/base/to-int32' ) );

/**
* @name float64ToInt64Bytes
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/to-int64-bytes}
*/
setReadOnly( ns, 'float64ToInt64Bytes', require( './../../../float64/base/to-int64-bytes' ) );

/**
* @name float64ToUint32
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/to-uint32}
*/
setReadOnly( ns, 'float64ToUint32', require( './../../../float64/base/to-uint32' ) );

/**
* @name toWords
* @memberof ns
* @readonly
* @type {Function}
* @see {@link module:@stdlib/number/float64/base/to-words}
*/
setReadOnly( ns, 'toWords', require( './../../../float64/base/to-words' ) );


// EXPORTS //

module.exports = ns;
