#!/usr/bin/env node

var test = require('tape');
var bufferEqual = require('buffer-equal');
var WebSocketFrame = require('../../lib/WebSocketFrame');

test('Serializing a WebSocket Frame with no data', function(t) {
  t.plan(2);
  
  // WebSocketFrame uses a per-connection buffer for the mask bytes
  // and the frame header to avoid allocating tons of small chunks of RAM.
  var maskBytesBuffer = new Buffer(4);
  var frameHeaderBuffer = new Buffer(10);
  
  var frameBytes;
  var frame = new WebSocketFrame(maskBytesBuffer, frameHeaderBuffer, {});
  frame.fin = true;
  frame.mask = true;
  frame.opcode = 0x09; // WebSocketFrame.PING
  t.doesNotThrow(
    function() { frameBytes = frame.toBuffer(true); },
    'should not throw an error'
  );
  
  t.assert(
    bufferEqual
      (frameBytes, new Buffer('898000000000', 'hex')),
    'Generated bytes should be correct'
  );
  
  t.end();
});