# Node.js Foundation TSC Meeting 2015-08-19

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-08-19
* **GitHub Issue**: https://github.com/nodejs/node/issues/2435
* **Minutes Google Doc**: https://docs.google.com/document/d/1xsj_4UlrLNxahRvC7SpLtFM3D-Ks6CZEqEM5nyj6bjk
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1q2bFjnf0Y23Ljxoze56Pmrbailaj5-UAqIUqIYVhiIk>_

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests prior to meeting.

* Procedure for rolling out node-accept-pull-request [#2434](https://github.com/nodejs/node/issues/2434)
* Release procedure changes & nominating @sam-github and @jasnell as releasers [#2416](https://github.com/nodejs/node/issues/2416)

## Minutes


### Present

* Mikeal Rogers
* Rod Vagg (TSC)
* James Snell (TSC)
* Michael Dawson (TSC)
* Steven R Loomis (TSC) 
* Chris Dickinson (TSC)
* Alexis Campailla (TSC)
* Brian White (TSC)
* Jeremiah Senkpiel (TSC)
* Shigeki Ohtsu (TSC)
* Trevor Norris (TSC)
* Domenic Denicola
* Ben Noordhuis (TSC)
* Colin Ihrig (TSC)
* Bert Belder (TSC)


### Standup

* Mikeal Rogers: Linuxconf, preparing next board meeting agenda, nailing down the foundation conf
* Rod Vagg: build work, memory leak testing, progress towards v4 (mainly infra)
* James Snell: some joyent/node PR triaging, preparing for nodeconf.eu
* Michael Dawson: nodeconf.eu, some AIX build work, talking to the v8 team about security notifications
* Steven R Loomis: Intl WG, landed Intl with small-icu by default in nodejs/node
* Chris Dickinson: first docs WG meeting, working on streams docs (again), working on docs tooling
* Alexis Campailla: working on ci convergence and jenkins jobs
* Brian White: not much, looking over issues and PRs, submitted a couple PRs
* Jeremiah Senkpiel: not so much, working on 0.10, 0.12 -> v4 upgrade docs, 3.1.0 release which should be ready straight after this meeting.
* Shigeki Ohtsu: little time to work on node right now, joined the LTS meeting to discuss OpenSSL LTS
* Trevor Norris: reviewing issues and PRs, noticed a bug in asyncwrap
* Domenic Denicola: issues and PRs, v8 team has a new Project Manager who is more interested in node; communicated our API stability concerns to him
* Ben Noordhuis: fixed a big memory leak, fixed a regression in windows module loading, reviewing PRs, responding to bug reports

### Review of the previous meeting

* Travel assistance amendment (no issue for this)
* FYI: Collaboration WG: https://github.com/nodejs/collaboration  
* Summit recap
* level-set on repo rename
* Future: “project lifecycle” (Mikeal) - process by which top level projects are added (libuv, node-gyp, etc), (conferences…)

### Procedure for rolling out node-accept-pull-request [#2434](https://github.com/nodejs/node/issues/2434)

* Discussed some potential concerns, which were alleviated:
* Jeremiah: Wondered how to land PRs where nits needed to be fixed.
* Bert: Concerns about Jenkins costantly building the wrong PR in the io.js CI infrastructure.
* Trevor: asked for a dropdown to pick the reviewers.
* Bert: asked whether the job would support landing multiple commits. Alexis confirmed this.
* Alexis: mentioned that there is also an node-accept-commit job that is more low-level and advanced.

### Release procedure changes & nominating @sam-github and @jasnell as releasers [#2416](https://github.com/nodejs/node/issues/2416)

Votes for @jasnell:

* Rod Vagg: +1
* Michael Dawson: +1 
* Steven R Loomis: +1
* Chris Dickinson: +1
* Alexis Campailla: +1
* Brian White: +1
* Jeremiah Senkpiel: +1
* Shigeki Ohtsu: +1
* Trevor Norris: +1
* Ben Noordhuis: +1
* Colin Ihrig: +1
* Bert Belder: +1

Votes for @sam-github:

* Rod Vagg: +1
* Michael Dawson: +1 
* Steven R Loomis: +1
* Chris Dickinson: +1
* Alexis Campailla: +1
* Brian White: +1
* Jeremiah Senkpiel: +1
* Shigeki Ohtsu: +1
* Trevor Norris: +1
* Ben Noordhuis: +1
* Colin Ihrig: +1
* Bert Belder: +1

No objections to combining the a whole "release team" to handle all release branches including 0.10, 0.12, stable and LTS.

### node-gyp is now in our org [#2379](https://github.com/nodejs/node/issues/2379)

* Rod: node-gyp has a busy issue tracker and has no tests, needs more eyes
* Ben: Zero tests?
* Rod: Correct.
* Domenic: on Windows Chromium’s depot_tools will automatically download VS community edition and put it in the right place. Someone with copious free time could have node-gyp do similar things.

* Discussed maybe looking at `gn` (the eventual replacement for `gyp`)

* Domenic: even v8 still uses gyp, don’t worry about it for a good while until noise about it being deprecated gets louder
* Rod: issue [#151](https://github.com/nodejs/build/issues/151) in build has a discussion about precompiled native addons. Chime in!

## Next Meeting

August 26th
