/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __NB_UI_NOTE_VIEW_H__
#define __NB_UI_NOTE_VIEW_H__ 

#include <glib.h>
#include <gtk/gtk.h>

#include "../nb_attachment_list.h"

typedef struct _cursor_list CursorList;

struct _cursor_list
{
	GdkCursorType current_cursor;
	GdkCursor * hand_cursor;
	GdkCursor * text_cursor;

};

void		nb_ui_note_view_create (void);
void		nb_ui_note_view_set_cursor_if_appropriate (GtkTextView * textview, gint x, gint y);

void		nb_ui_note_view_reset (void);
gboolean	nb_ui_note_view_is_empty (void);

/* retrieve fields value */
gchar 		* nb_ui_note_view_get_title (void);
gchar 		* nb_ui_note_view_get_text (void);

void		nb_ui_note_view_set_fields (gchar * title, gchar * text, int type, int status, gchar * date, AttachmentList * attachments);

/* callbacks */
gboolean		nb_ui_note_view_on_link_clicked (GtkTextView * textview, GdkEvent * event);
gboolean	nb_ui_note_view_motion_notify_event (GtkWidget * textview, GdkEventMotion * event);
gboolean	nb_ui_note_view_visibility_notify_event (GtkWidget * textview, GdkEventVisibility * event);

#endif
