#include "slicetime.h"
#include "data.h"
#include "controller.h"


bool RecoSliceTime::process(RecoData& rd, RecoController& controller) {
  Log<Reco> odinlog(c_label(),"process");

  Range all=Range::all();

  dvector sliceorder=controller.dim_values(slice);
  ODINLOG(odinlog,normalDebug) << "sliceorder=" << sliceorder.printbody() << STD_endl;

  ComplexData<5>& indata=rd.data(Rank<5>());
  TinyVector<int,5> inshape=indata.shape();

  int nrep=inshape(0);
  int nslices=inshape(1);

  if(nrep>1 && nslices>1) {

    dvector sliceshift(nslices); sliceshift=0.0;
    if(nslices==int(sliceorder.size())) {
      for(int islice=0; islice<nslices; islice++) {
        sliceshift[islice]=secureDivision(sliceorder[islice],nslices);
      }
    }
    ODINLOG(odinlog,normalDebug) << "sliceshift=" << sliceshift.printbody() << STD_endl;


    ComplexData<1> tcourse(nrep);
    TinyVector<float,1> subpixel_shift;
    for(int islice=0; islice<inshape(1); islice++) {
      for(int iphase3d=0; iphase3d<inshape(2); iphase3d++) {
        for(int iphase=0; iphase<inshape(3); iphase++) {
          for(int iread=0; iread<inshape(4); iread++) {
            tcourse(all)=indata(all,islice,iphase3d,iphase,iread);
            subpixel_shift(0)=sliceshift[islice];
            tcourse.congrid(tcourse.shape(), &subpixel_shift);
            indata(all,islice,iphase3d,iphase,iread)=tcourse(all);
          }
        }
      }
    }

  }

  return execute_next_step(rd,controller);
}
