"computeLinearModel" <-
function(x, y, testLevel = 0.95){
  
  # Checking for NAs in y, beta is assumed not to contain any
  indexNA <- which(is.na(y))

  if(length(indexNA) > 0) {
    x[indexNA, ] <- NA 
  }

  # Checking for NAs in x, beta is assumed not to contain any
  indexNA <- which(is.na(x), arr.ind=TRUE)

  if(length(indexNA) > 0) {

    x[indexNA[, 1], ] <- NA 
    y[indexNA[, 1]] <- NA
    # Eliminating the NAs
    x <- matrix(x[ ! is.na(x)], ncol = ncol(x))
    y <- y[ ! is.na(y)]
  }

  linearModel <- lm(y ~ x, data = data.frame(x, y))
  modelSummary <- summary(linearModel)

  parameterEstimate <- modelSummary$coefficients[, 1]

  # Computation of the t-value used in the CIs
  tValue <- qt(testLevel, length(x)-1)

  confidenceIntervalLow <- parameterEstimate - tValue * modelSummary$coefficients[, 2]
  confidenceIntervalHigh <- parameterEstimate + tValue * modelSummary$coefficients[, 2]
  pValues <- modelSummary$coefficients[, 4]
  
  list(linearmodel = "",
       parameterEstimate = as.numeric(parameterEstimate), 
       confidenceIntervalLow = as.numeric(confidenceIntervalLow), 
       confidenceIntervalHigh = as.numeric(confidenceIntervalHigh), 
       pValues = as.numeric(pValues))
 
}

