# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 007-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53563);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 007-1 (zope)";
 script_name(name);

 desc = "The remote host is missing an update to zope
announced via advisory DSA 007-1.

A busy week for the Zope team: on Monday another security alert was
released revealing a potential problem found by Peter Kelly. This
problem involved incorrect protection of data updating for Image and
File objects: any user with DTML editing privileges could update the
File or Image object data directly.

This has been fixed in version 2.1.6-5.4 by including the 2000-12-19
hotfix, and we recommend that you upgrade your zope package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20007-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 007-1 (zope)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"zope", ver:"2.1.6-5.4", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
