# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1487-1 (libexif)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60360);
 script_cve_id("CVE-2007-2645", "CVE-2007-6351", "CVE-2007-6352");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1487-1 (libexif)";
 script_name(name);

 desc = "The remote host is missing an update to libexif
announced via advisory DSA 1487-1.

Several vulnerabilities have been discovered in the EXIF parsing code
of the libexif library, which can lead to denial of service or the
xecution of arbitrary code if a user is tricked into opening a
malformed image.

CVE-2007-2645

Victor Stinner discovered an integer overflow, which may result in
denial of service or potentially the execution of arbitrary code.

CVE-2007-6351

Meder Kydyraliev discovered an infinite loop, which may result in
denial of service.

CVE-2007-6352

Victor Stinner discovered an integer overflow, which may result
in denial of service or potentially the execution of arbitrary
code.

This update also fixes two potential NULL pointer deferences.

For the stable distribution (etch), these problems have been fixed in
version 0.6.13-5etch2.

For the old stable distribution (sarge), these problems have been
fixed in 0.6.9-6sarge2.


We recommend that you upgrade your libexif packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201487-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1487-1 (libexif)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libexif-dev", ver:"0.6.9-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libexif10", ver:"0.6.9-6sarge2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libexif12", ver:"0.6.13-5etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libexif-dev", ver:"0.6.13-5etch2", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
