# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1900-1 (postgresql-7.4, postgresql-8.1, postgresql-8.3, postgresql-8.4)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65005);
 script_cve_id("CVE-2009-3229", "CVE-2009-3230", "CVE-2009-3231");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1900-1 (postgresql-7.4, postgresql-8.1, postgresql-8.3, postgresql-8.4)");

 desc = "The remote host is missing an update to postgresql-7.4, postgresql-8.1, postgresql-8.3, postgresql-8.4
announced via advisory DSA 1900-1.

Several vulnerabilities have been discovered in PostgreSQL, an SQL
database system.  The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2009-3229

Authenticated users can shut down the backend server by re-LOAD-ing
libraries in $libdir/plugins, if any libraries are present there.
(The old stable distribution (etch) is not affected by this issue.)

CVE-2009-3230

Authenticated non-superusers can gain database superuser privileges if
they can create functions and tables due to incorrect execution of
functions in functional indexes.

CVE-2009-3231

If PostgreSQL is configured with LDAP authentication, and the LDAP
configuration allows anonymous binds, it is possible for a user to
authenticate themselves with an empty password.  (The old stable
distribution (etch) is not affected by this issue.)

In addition, this update contains reliability improvements which do
not target security issues.

For the old stable distribution (etch), these problems have been fixed
in version 7.4.26-0etch1 of the postgresql-7.4 source package, and
version 8.1.18-0etch1 of the postgresql-8.1 source package.

For the stable distribution (lenny), these problems have been fixed in
version 8.3.8-0lenny1 of the postgresql-8.3 source package.

For the unstable distribution (sid), these problems have been fixed in
version 8.3.8-1 of the postgresql-8.3 source package, and version
8.4.1-1 of the postgresql-8.4 source package.

We recommend that you upgrade your PostgreSQL packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201900-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1900-1 (postgresql-7.4, postgresql-8.1, postgresql-8.3, postgresql-8.4)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"postgresql-server-dev-7.4", ver:"7.4.26-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc-8.1", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc-7.4", ver:"7.4.26-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-7.4", ver:"7.4.26-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-7.4", ver:"7.4.26-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq4", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.1", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.1", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg5", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat2", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.1", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.1", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-7.4", ver:"7.4.26-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes2", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-7.4", ver:"7.4.26-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.1", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-7.4", ver:"7.4.26-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-7.4", ver:"7.4.26-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.1", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.1", ver:"8.1.18-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc-8.3", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-doc", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-pltcl-8.3", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq-dev", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-contrib-8.3", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-compat3", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpq5", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpgtypes3", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg6", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-client-8.3", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-server-dev-8.3", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plperl-8.3", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libecpg-dev", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-plpython-8.3", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"postgresql-8.3", ver:"8.3.8-0lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
