# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-3769 (cups)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63877);
 script_cve_id("CVE-2009-0163", "CVE-2009-0164", "CVE-2009-0146", "CVE-2009-0147", "CVE-2009-0166", "CVE-2008-5183", "CVE-2008-5286", "CVE-2008-1722");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-3769 (cups)";
 script_name(name);

 desc = "The remote host is missing an update to cups
announced via advisory FEDORA-2009-3769.

This update fixes several security issues: CVE-2009-0163, CVE-2009-0164,
CVE-2009-0146, CVE-2009-0147, and CVE-2009-0166.

PDF files are now converted to PostScript using the poppler package's
pdftops program.    NOTE: If your CUPS server is accessed using a
hostname or hostnames not known to the server itself you must add
ServerAlias hostname to cupsd.conf for each such name.  The special
line ServerAlias * disables checking (but this allows DNS rebinding attacks).

ChangeLog:

* Tue Apr 21 2009 Tim Waugh  1:1.3.10-1
- 1.3.10.  No longer need ext, includeifexists, str2988,
CVE-2008-5183, CVE-2008-5286, str3077, str3078, str3059, str3055 patches.
- Requires poppler-utils.
- NOTE: If your CUPS server is accessed using a hostname or hostnames
not known to the server itself you must add ServerAlias hostname
for each such name.  The special line ServerAlias * disables checking
(but this allows DNS rebinding attacks).

References:

[ 1 ] Bug #490597 - CVE-2009-0164 cups: insufficient checking of the HTTP Host: header
https://bugzilla.redhat.com/show_bug.cgi?id=490597
[ 2 ] Bug #490596 - CVE-2009-0163 cups: Integer overflow in the TIFF image filter
https://bugzilla.redhat.com/show_bug.cgi?id=490596
[ 3 ] Bug #490612 - CVE-2009-0146 xpdf: Multiple buffer overflows in JBIG2 decoder (setBitmap, readSymbolDictSeg)
https://bugzilla.redhat.com/show_bug.cgi?id=490612
[ 4 ] Bug #490614 - CVE-2009-0147 xpdf: Multiple integer overflows in JBIG2 decoder
https://bugzilla.redhat.com/show_bug.cgi?id=490614
[ 5 ] Bug #490625 - CVE-2009-0166 xpdf: Freeing of potentially uninitialized memory in JBIG2 decoder
https://bugzilla.redhat.com/show_bug.cgi?id=490625

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update cups' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-3769

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-3769 (cups)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"cups", rpm:"cups~1.3.10~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.3.10~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.3.10~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-lpd", rpm:"cups-lpd~1.3.10~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-php", rpm:"cups-php~1.3.10~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-debuginfo", rpm:"cups-debuginfo~1.3.10~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
